/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.ui.DefaultTimeBar;
import com.google.android.exoplayer2.ui.DefaultTrackNameProvider;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.StyledPlayerControlViewLayoutManager;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.ui.TrackNameProvider;
import com.google.android.exoplayer2.ui._$;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.RepeatModeUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StyledPlayerControlView
extends FrameLayout {
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 0;
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    public static final int DEFAULT_TIME_BAR_MIN_UPDATE_INTERVAL_MS = 200;
    private static final int MAX_UPDATE_INTERVAL_MS = 1000;
    public static final int MAX_WINDOWS_FOR_MULTI_WINDOW_TIME_BAR = 100;
    private static final int SETTINGS_AUDIO_TRACK_SELECTION_POSITION = 1;
    private static final int SETTINGS_PLAYBACK_SPEED_POSITION = 0;
    private long[] adGroupTimesMs;
    private View audioTrackButton;
    private TrackSelectionAdapter audioTrackSelectionAdapter;
    private final float buttonAlphaDisabled;
    private final float buttonAlphaEnabled;
    private final ComponentListener componentListener;
    private ControlDispatcher controlDispatcher;
    private StyledPlayerControlViewLayoutManager controlViewLayoutManager;
    private long currentWindowOffset;
    private final TextView durationView;
    private long[] extraAdGroupTimesMs;
    private boolean[] extraPlayedAdGroups;
    private final View fastForwardButton;
    private final TextView fastForwardButtonTextView;
    private long fastForwardMs;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private ImageView fullScreenButton;
    private final String fullScreenEnterContentDescription;
    private final Drawable fullScreenEnterDrawable;
    private final String fullScreenExitContentDescription;
    private final Drawable fullScreenExitDrawable;
    private boolean isAttachedToWindow;
    private boolean isFullScreen;
    private ImageView minimalFullScreenButton;
    private boolean multiWindowTimeBar;
    private boolean needToHideBars;
    private final View nextButton;
    private OnFullScreenModeChangedListener onFullScreenModeChangedListener;
    private final Timeline.Period period;
    private final View playPauseButton;
    private PlaybackPreparer playbackPreparer;
    private PlaybackSpeedAdapter playbackSpeedAdapter;
    private View playbackSpeedButton;
    private boolean[] playedAdGroups;
    private Player player;
    private final TextView positionView;
    private final View previousButton;
    private ProgressUpdateListener progressUpdateListener;
    private final String repeatAllButtonContentDescription;
    private final Drawable repeatAllButtonDrawable;
    private final String repeatOffButtonContentDescription;
    private final Drawable repeatOffButtonDrawable;
    private final String repeatOneButtonContentDescription;
    private final Drawable repeatOneButtonDrawable;
    private final ImageView repeatToggleButton;
    private int repeatToggleModes;
    private Resources resources;
    private final View rewindButton;
    private final TextView rewindButtonTextView;
    private long rewindMs;
    private boolean scrubbing;
    private SettingsAdapter settingsAdapter;
    private View settingsButton;
    private RecyclerView settingsView;
    private PopupWindow settingsWindow;
    private int settingsWindowMargin;
    private boolean showMultiWindowTimeBar;
    private int showTimeoutMs;
    private final ImageView shuffleButton;
    private final Drawable shuffleOffButtonDrawable;
    private final String shuffleOffContentDescription;
    private final Drawable shuffleOnButtonDrawable;
    private final String shuffleOnContentDescription;
    private ImageView subtitleButton;
    private final Drawable subtitleOffButtonDrawable;
    private final String subtitleOffContentDescription;
    private final Drawable subtitleOnButtonDrawable;
    private final String subtitleOnContentDescription;
    private TrackSelectionAdapter textTrackSelectionAdapter;
    private final TimeBar timeBar;
    private int timeBarMinUpdateIntervalMs;
    private TrackNameProvider trackNameProvider;
    private DefaultTrackSelector trackSelector;
    private final Runnable updateProgressAction;
    private final CopyOnWriteArrayList<VisibilityListener> visibilityListeners;
    private final View vrButton;
    private final Timeline.Window window;

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ui");
    }

    public StyledPlayerControlView(Context context) {
        this(context, null);
    }

    public StyledPlayerControlView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public StyledPlayerControlView(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet, n2, attributeSet);
    }

    public StyledPlayerControlView(Context context, AttributeSet object, int n2, AttributeSet attributeSet) {
        super(context, object, n2);
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        n2 = R.layout.exo_styled_player_control_view;
        this.rewindMs = 5000L;
        this.fastForwardMs = 15000L;
        this.showTimeoutMs = 5000;
        this.repeatToggleModes = 0;
        this.timeBarMinUpdateIntervalMs = 200;
        if (attributeSet != null) {
            object = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.StyledPlayerControlView, 0, 0);
            try {
                this.rewindMs = object.getInt(R.styleable.StyledPlayerControlView_rewind_increment, (int)this.rewindMs);
                this.fastForwardMs = object.getInt(R.styleable.StyledPlayerControlView_fastforward_increment, (int)this.fastForwardMs);
                n2 = object.getResourceId(R.styleable.StyledPlayerControlView_controller_layout_id, n2);
                this.showTimeoutMs = object.getInt(R.styleable.StyledPlayerControlView_show_timeout, this.showTimeoutMs);
                this.repeatToggleModes = StyledPlayerControlView.getRepeatToggleModes((TypedArray)object, this.repeatToggleModes);
                bl8 = object.getBoolean(R.styleable.StyledPlayerControlView_show_rewind_button, true);
                bl7 = object.getBoolean(R.styleable.StyledPlayerControlView_show_fastforward_button, true);
                bl6 = object.getBoolean(R.styleable.StyledPlayerControlView_show_previous_button, true);
                bl5 = object.getBoolean(R.styleable.StyledPlayerControlView_show_next_button, true);
                bl4 = object.getBoolean(R.styleable.StyledPlayerControlView_show_shuffle_button, false);
                bl3 = object.getBoolean(R.styleable.StyledPlayerControlView_show_subtitle_button, false);
                bl2 = object.getBoolean(R.styleable.StyledPlayerControlView_show_vr_button, false);
                this.setTimeBarMinUpdateInterval(object.getInt(R.styleable.StyledPlayerControlView_time_bar_min_update_interval, this.timeBarMinUpdateIntervalMs));
                bl = object.getBoolean(R.styleable.StyledPlayerControlView_animation_enabled, true);
            }
            finally {
                object.recycle();
            }
        } else {
            bl5 = true;
            bl6 = true;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = true;
            bl8 = true;
            bl7 = true;
        }
        LayoutInflater.from((Context)context).inflate(n2, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        this.componentListener = new ComponentListener();
        this.visibilityListeners = new CopyOnWriteArrayList();
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.adGroupTimesMs = new long[0];
        this.playedAdGroups = new boolean[0];
        this.extraAdGroupTimesMs = new long[0];
        this.extraPlayedAdGroups = new boolean[0];
        this.controlDispatcher = new DefaultControlDispatcher(this.fastForwardMs, this.rewindMs);
        this.updateProgressAction = new _$.Lambda.StyledPlayerControlView.d94Vth4Hab4ZDVeJwJC_V3ktUD8(this);
        this.durationView = (TextView)this.findViewById(R.id.exo_duration);
        this.positionView = (TextView)this.findViewById(R.id.exo_position);
        this.subtitleButton = (ImageView)this.findViewById(R.id.exo_subtitle);
        object = this.subtitleButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.fullScreenButton = (ImageView)this.findViewById(R.id.exo_fullscreen);
        StyledPlayerControlView.initializeFullScreenButton((View)this.fullScreenButton, (View.OnClickListener)new _$.Lambda.StyledPlayerControlView.sd8_DmGij0WN1841R1uwrzjMVPo(this));
        this.minimalFullScreenButton = (ImageView)this.findViewById(R.id.exo_minimal_fullscreen);
        StyledPlayerControlView.initializeFullScreenButton((View)this.minimalFullScreenButton, (View.OnClickListener)new _$.Lambda.StyledPlayerControlView.sd8_DmGij0WN1841R1uwrzjMVPo(this));
        this.settingsButton = this.findViewById(R.id.exo_settings);
        object = this.settingsButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.playbackSpeedButton = this.findViewById(R.id.exo_playback_speed);
        object = this.playbackSpeedButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.audioTrackButton = this.findViewById(R.id.exo_audio_track);
        object = this.audioTrackButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        Object object2 = (TimeBar)this.findViewById(R.id.exo_progress);
        object = this.findViewById(R.id.exo_progress_placeholder);
        if (object2 != null) {
            this.timeBar = object2;
        } else if (object != null) {
            object2 = new DefaultTimeBar(context, null, 0, attributeSet, R.style.ExoStyledControls_TimeBar);
            object2.setId(R.id.exo_progress);
            object2.setLayoutParams(object.getLayoutParams());
            attributeSet = (ViewGroup)object.getParent();
            n2 = attributeSet.indexOfChild((View)object);
            attributeSet.removeView((View)object);
            attributeSet.addView((View)object2, n2);
            this.timeBar = object2;
        } else {
            this.timeBar = null;
        }
        object = this.timeBar;
        if (object != null) {
            object.addListener((TimeBar.OnScrubListener)this.componentListener);
        }
        this.playPauseButton = this.findViewById(R.id.exo_play_pause);
        object = this.playPauseButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.previousButton = this.findViewById(R.id.exo_prev);
        object = this.previousButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.nextButton = this.findViewById(R.id.exo_next);
        object = this.nextButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        object2 = ResourcesCompat.getFont((Context)context, (int)R.font.roboto_medium_numbers);
        attributeSet = this.findViewById(R.id.exo_rew);
        object = attributeSet == null ? (TextView)this.findViewById(R.id.exo_rew_with_amount) : null;
        this.rewindButtonTextView = object;
        object = this.rewindButtonTextView;
        if (object != null) {
            object.setTypeface((Typeface)object2);
        }
        object = attributeSet;
        if (attributeSet == null) {
            object = this.rewindButtonTextView;
        }
        this.rewindButton = object;
        object = this.rewindButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        object = (attributeSet = this.findViewById(R.id.exo_ffwd)) == null ? (TextView)this.findViewById(R.id.exo_ffwd_with_amount) : null;
        this.fastForwardButtonTextView = object;
        object = this.fastForwardButtonTextView;
        if (object != null) {
            object.setTypeface((Typeface)object2);
        }
        object = attributeSet;
        if (attributeSet == null) {
            object = this.fastForwardButtonTextView;
        }
        this.fastForwardButton = object;
        object = this.fastForwardButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.repeatToggleButton = (ImageView)this.findViewById(R.id.exo_repeat_toggle);
        object = this.repeatToggleButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.shuffleButton = (ImageView)this.findViewById(R.id.exo_shuffle);
        object = this.shuffleButton;
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.resources = context.getResources();
        this.buttonAlphaEnabled = (float)this.resources.getInteger(R.integer.exo_media_button_opacity_percentage_enabled) / 100.0f;
        this.buttonAlphaDisabled = (float)this.resources.getInteger(R.integer.exo_media_button_opacity_percentage_disabled) / 100.0f;
        this.vrButton = this.findViewById(R.id.exo_vr);
        object = this.vrButton;
        if (object != null) {
            this.updateButton(false, (View)object);
        }
        this.controlViewLayoutManager = new StyledPlayerControlViewLayoutManager(this);
        this.controlViewLayoutManager.setAnimationEnabled(bl);
        object2 = this.resources.getString(R.string.exo_controls_playback_speed);
        attributeSet = this.resources.getDrawable(R.drawable.exo_styled_controls_speed);
        object = this.resources.getString(R.string.exo_track_selection_title_audio);
        Drawable drawable2 = this.resources.getDrawable(R.drawable.exo_styled_controls_audiotrack);
        this.settingsAdapter = new SettingsAdapter(new String[]{object2, object}, new Drawable[]{attributeSet, drawable2});
        this.settingsWindowMargin = this.resources.getDimensionPixelSize(R.dimen.exo_settings_offset);
        this.settingsView = (RecyclerView)LayoutInflater.from((Context)context).inflate(R.layout.exo_styled_settings_list, null);
        this.settingsView.setAdapter(this.settingsAdapter);
        this.settingsView.setLayoutManager(new LinearLayoutManager(this.getContext()));
        this.settingsWindow = new PopupWindow((View)this.settingsView, -2, -2, true);
        if (Util.SDK_INT < 23) {
            this.settingsWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        bl = false;
        this.settingsWindow.setOnDismissListener((PopupWindow.OnDismissListener)this.componentListener);
        this.needToHideBars = true;
        this.trackNameProvider = new DefaultTrackNameProvider(this.getResources());
        this.subtitleOnButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_subtitle_on);
        this.subtitleOffButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_subtitle_off);
        this.subtitleOnContentDescription = this.resources.getString(R.string.exo_controls_cc_enabled_description);
        this.subtitleOffContentDescription = this.resources.getString(R.string.exo_controls_cc_disabled_description);
        this.textTrackSelectionAdapter = new TextTrackSelectionAdapter();
        this.audioTrackSelectionAdapter = new AudioTrackSelectionAdapter();
        this.playbackSpeedAdapter = new PlaybackSpeedAdapter(this.resources.getStringArray(R.array.exo_playback_speeds), this.resources.getIntArray(R.array.exo_speed_multiplied_by_100));
        this.fullScreenExitDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_fullscreen_exit);
        this.fullScreenEnterDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_fullscreen_enter);
        this.repeatOffButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_repeat_off);
        this.repeatOneButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_repeat_one);
        this.repeatAllButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_repeat_all);
        this.shuffleOnButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_shuffle_on);
        this.shuffleOffButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_shuffle_off);
        this.fullScreenExitContentDescription = this.resources.getString(R.string.exo_controls_fullscreen_exit_description);
        this.fullScreenEnterContentDescription = this.resources.getString(R.string.exo_controls_fullscreen_enter_description);
        this.repeatOffButtonContentDescription = this.resources.getString(R.string.exo_controls_repeat_off_description);
        this.repeatOneButtonContentDescription = this.resources.getString(R.string.exo_controls_repeat_one_description);
        this.repeatAllButtonContentDescription = this.resources.getString(R.string.exo_controls_repeat_all_description);
        this.shuffleOnContentDescription = this.resources.getString(R.string.exo_controls_shuffle_on_description);
        this.shuffleOffContentDescription = this.resources.getString(R.string.exo_controls_shuffle_off_description);
        context = (ViewGroup)this.findViewById(R.id.exo_bottom_bar);
        this.controlViewLayoutManager.setShowButton((View)context, true);
        this.controlViewLayoutManager.setShowButton(this.fastForwardButton, bl7);
        this.controlViewLayoutManager.setShowButton(this.rewindButton, bl8);
        this.controlViewLayoutManager.setShowButton(this.previousButton, bl6);
        this.controlViewLayoutManager.setShowButton(this.nextButton, bl5);
        this.controlViewLayoutManager.setShowButton((View)this.shuffleButton, bl4);
        this.controlViewLayoutManager.setShowButton((View)this.subtitleButton, bl3);
        this.controlViewLayoutManager.setShowButton(this.vrButton, bl2);
        object = this.controlViewLayoutManager;
        context = this.repeatToggleButton;
        bl8 = bl;
        if (this.repeatToggleModes != 0) {
            bl8 = true;
        }
        object.setShowButton((View)context, bl8);
        this.addOnLayoutChangeListener((View.OnLayoutChangeListener)new _$.Lambda.StyledPlayerControlView.niv5NEP7ncglQ9JFsIeRrAXS1yQ(this));
    }

    static /* synthetic */ boolean access$302(StyledPlayerControlView styledPlayerControlView, boolean bl) {
        styledPlayerControlView.scrubbing = bl;
        return bl;
    }

    private static boolean canShowMultiWindowTimeBar(Timeline timeline, Timeline.Window window) {
        if (timeline.getWindowCount() > 100) {
            return false;
        }
        int n2 = timeline.getWindowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (timeline.getWindow((int)i2, (Timeline.Window)window).durationUs != -9223372036854775807L) continue;
            return false;
        }
        return true;
    }

    private void dispatchPause(Player player) {
        this.controlDispatcher.dispatchSetPlayWhenReady(player, false);
    }

    private void dispatchPlay(Player player) {
        int n2 = player.getPlaybackState();
        if (n2 == 1) {
            PlaybackPreparer playbackPreparer = this.playbackPreparer;
            if (playbackPreparer != null) {
                playbackPreparer.preparePlayback();
            } else {
                this.controlDispatcher.dispatchPrepare(player);
            }
        } else if (n2 == 4) {
            this.seekTo(player, player.getCurrentWindowIndex(), -9223372036854775807L);
        }
        this.controlDispatcher.dispatchSetPlayWhenReady(player, true);
    }

    private void dispatchPlayPause(Player player) {
        int n2 = player.getPlaybackState();
        if (n2 != 1 && n2 != 4 && player.getPlayWhenReady()) {
            this.dispatchPause(player);
        } else {
            this.dispatchPlay(player);
        }
    }

    private void displaySettingsWindow(RecyclerView.Adapter<?> adapter) {
        this.settingsView.setAdapter(adapter);
        this.updateSettingsWindowSize();
        this.needToHideBars = false;
        this.settingsWindow.dismiss();
        this.needToHideBars = true;
        int n2 = this.getWidth();
        int n3 = this.settingsWindow.getWidth();
        int n4 = this.settingsWindowMargin;
        int n5 = -this.settingsWindow.getHeight();
        int n6 = this.settingsWindowMargin;
        this.settingsWindow.showAsDropDown((View)this, n2 - n3 - n4, n5 - n6);
    }

    private void gatherTrackInfosForAdapter(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int n2, List<TrackInfo> list) {
        TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(n2);
        TrackSelection trackSelection = Assertions.checkNotNull(this.player).getCurrentTrackSelections().get(n2);
        for (int i2 = 0; i2 < trackGroupArray.length; ++i2) {
            TrackGroup trackGroup = trackGroupArray.get(i2);
            for (int i3 = 0; i3 < trackGroup.length; ++i3) {
                Format format = trackGroup.getFormat(i3);
                if (mappedTrackInfo.getTrackSupport(n2, i2, i3) != 4) continue;
                boolean bl = trackSelection != null && trackSelection.indexOf(format) != -1;
                list.add(new TrackInfo(n2, i2, i3, this.trackNameProvider.getTrackName(format), bl));
            }
        }
    }

    private static int getRepeatToggleModes(TypedArray typedArray, int n2) {
        return typedArray.getInt(R.styleable.StyledPlayerControlView_repeat_toggle_modes, n2);
    }

    private void initTrackSelectionAdapter() {
        DefaultTrackSelector defaultTrackSelector;
        this.textTrackSelectionAdapter.clear();
        this.audioTrackSelectionAdapter.clear();
        if (this.player != null && (defaultTrackSelector = this.trackSelector) != null) {
            if ((defaultTrackSelector = defaultTrackSelector.getCurrentMappedTrackInfo()) == null) {
                return;
            }
            ArrayList<TrackInfo> arrayList = new ArrayList<TrackInfo>();
            ArrayList<TrackInfo> arrayList2 = new ArrayList<TrackInfo>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            for (int i2 = 0; i2 < defaultTrackSelector.getRendererCount(); ++i2) {
                if (defaultTrackSelector.getRendererType(i2) == 3 && this.controlViewLayoutManager.getShowButton((View)this.subtitleButton)) {
                    this.gatherTrackInfosForAdapter((MappingTrackSelector.MappedTrackInfo)defaultTrackSelector, i2, arrayList);
                    arrayList3.add(i2);
                    continue;
                }
                if (defaultTrackSelector.getRendererType(i2) != 1) continue;
                this.gatherTrackInfosForAdapter((MappingTrackSelector.MappedTrackInfo)defaultTrackSelector, i2, arrayList2);
                arrayList4.add(i2);
            }
            this.textTrackSelectionAdapter.init(arrayList3, arrayList, (MappingTrackSelector.MappedTrackInfo)defaultTrackSelector);
            this.audioTrackSelectionAdapter.init(arrayList4, arrayList2, (MappingTrackSelector.MappedTrackInfo)defaultTrackSelector);
        }
    }

    private static void initializeFullScreenButton(View view, View.OnClickListener onClickListener) {
        if (view == null) {
            return;
        }
        view.setVisibility(8);
        view.setOnClickListener(onClickListener);
    }

    private static boolean isHandledMediaKey(int n2) {
        boolean bl = n2 == 90 || n2 == 89 || n2 == 85 || n2 == 79 || n2 == 126 || n2 == 127 || n2 == 87 || n2 == 88;
        return bl;
    }

    public static /* synthetic */ void lambda$d94Vth4Hab4ZDVeJwJC_V3ktUD8(StyledPlayerControlView styledPlayerControlView) {
        styledPlayerControlView.updateProgress();
    }

    public static /* synthetic */ void lambda$niv5NEP7ncglQ9JFsIeRrAXS1yQ(StyledPlayerControlView styledPlayerControlView, View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        styledPlayerControlView.onLayoutChange(view, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static /* synthetic */ void lambda$sd8-DmGij0WN1841R1uwrzjMVPo(StyledPlayerControlView styledPlayerControlView, View view) {
        styledPlayerControlView.onFullScreenButtonClicked(view);
    }

    private void onFullScreenButtonClicked(View object) {
        if (this.onFullScreenModeChangedListener == null) {
            return;
        }
        this.isFullScreen ^= true;
        this.updateFullScreenButtonForState(this.fullScreenButton, this.isFullScreen);
        this.updateFullScreenButtonForState(this.minimalFullScreenButton, this.isFullScreen);
        object = this.onFullScreenModeChangedListener;
        if (object != null) {
            object.onFullScreenModeChanged(this.isFullScreen);
        }
    }

    private void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if ((n4 - n2 != n8 - n6 || n5 - n3 != n9 - n7) && this.settingsWindow.isShowing()) {
            this.updateSettingsWindowSize();
            n4 = this.getWidth();
            n2 = this.settingsWindow.getWidth();
            n5 = this.settingsWindowMargin;
            n3 = -this.settingsWindow.getHeight();
            n6 = this.settingsWindowMargin;
            this.settingsWindow.update(view, n4 - n2 - n5, n3 - n6, -1, -1);
        }
    }

    private void onSettingViewClicked(int n2) {
        if (n2 == 0) {
            this.displaySettingsWindow(this.playbackSpeedAdapter);
        } else if (n2 == 1) {
            this.displaySettingsWindow(this.audioTrackSelectionAdapter);
        } else {
            this.settingsWindow.dismiss();
        }
    }

    private boolean seekTo(Player player, int n2, long l2) {
        return this.controlDispatcher.dispatchSeekTo(player, n2, l2);
    }

    private void seekToTimeBarPosition(Player player, long l2) {
        int n2;
        Timeline timeline = player.getCurrentTimeline();
        if (this.multiWindowTimeBar && !timeline.isEmpty()) {
            long l3;
            int n3 = timeline.getWindowCount();
            n2 = 0;
            while (l2 >= (l3 = timeline.getWindow(n2, this.window).getDurationMs())) {
                if (n2 == n3 - 1) {
                    l2 = l3;
                    break;
                }
                l2 -= l3;
                ++n2;
            }
        } else {
            n2 = player.getCurrentWindowIndex();
        }
        if (!this.seekTo(player, n2, l2)) {
            this.updateProgress();
        }
    }

    private void setPlaybackSpeed(float f2) {
        Player player = this.player;
        if (player == null) {
            return;
        }
        this.controlDispatcher.dispatchSetPlaybackParameters(player, player.getPlaybackParameters().withSpeed(f2));
    }

    private boolean shouldShowPauseButton() {
        Player player = this.player;
        boolean bl = true;
        if (player == null || player.getPlaybackState() == 4 || this.player.getPlaybackState() == 1 || !this.player.getPlayWhenReady()) {
            bl = false;
        }
        return bl;
    }

    private void updateButton(boolean bl, View view) {
        if (view == null) {
            return;
        }
        view.setEnabled(bl);
        float f2 = bl ? this.buttonAlphaEnabled : this.buttonAlphaDisabled;
        view.setAlpha(f2);
    }

    private void updateFastForwardButton() {
        ControlDispatcher controlDispatcher = this.controlDispatcher;
        if (controlDispatcher instanceof DefaultControlDispatcher) {
            this.fastForwardMs = ((DefaultControlDispatcher)controlDispatcher).getFastForwardIncrementMs();
        }
        int n2 = (int)(this.fastForwardMs / 1000L);
        controlDispatcher = this.fastForwardButtonTextView;
        if (controlDispatcher != null) {
            controlDispatcher.setText((CharSequence)String.valueOf(n2));
        }
        if ((controlDispatcher = this.fastForwardButton) != null) {
            controlDispatcher.setContentDescription((CharSequence)this.resources.getQuantityString(R.plurals.exo_controls_fastforward_by_amount_description, n2, new Object[]{n2}));
        }
    }

    private void updateFullScreenButtonForState(ImageView imageView, boolean bl) {
        if (imageView == null) {
            return;
        }
        if (bl) {
            imageView.setImageDrawable(this.fullScreenExitDrawable);
            imageView.setContentDescription((CharSequence)this.fullScreenExitContentDescription);
        } else {
            imageView.setImageDrawable(this.fullScreenEnterDrawable);
            imageView.setContentDescription((CharSequence)this.fullScreenEnterContentDescription);
        }
    }

    private static void updateFullScreenButtonVisibility(View view, boolean bl) {
        if (view == null) {
            return;
        }
        if (bl) {
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    private void updateNavigation() {
        if (this.isVisible() && this.isAttachedToWindow) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Timeline timeline;
            Player player = this.player;
            boolean bl5 = false;
            boolean bl6 = false;
            if (player != null && !(timeline = player.getCurrentTimeline()).isEmpty() && !player.isPlayingAd()) {
                timeline.getWindow(player.getCurrentWindowIndex(), this.window);
                bl5 = this.window.isSeekable;
                bl4 = bl5 || !this.window.isLive() || player.hasPrevious();
                bl3 = bl5 && this.controlDispatcher.isRewindEnabled();
                bl2 = bl5 && this.controlDispatcher.isFastForwardEnabled();
                if (this.window.isLive() && this.window.isDynamic || player.hasNext()) {
                    bl6 = true;
                }
                bl = bl6;
                bl6 = bl3;
                bl3 = bl5;
            } else {
                bl = false;
                bl3 = false;
                bl4 = false;
                bl2 = false;
                bl6 = bl5;
            }
            if (bl6) {
                this.updateRewindButton();
            }
            if (bl2) {
                this.updateFastForwardButton();
            }
            this.updateButton(bl4, this.previousButton);
            this.updateButton(bl6, this.rewindButton);
            this.updateButton(bl2, this.fastForwardButton);
            this.updateButton(bl, this.nextButton);
            player = this.timeBar;
            if (player != null) {
                player.setEnabled(bl3);
            }
        }
    }

    private void updatePlayPauseButton() {
        if (this.isVisible() && this.isAttachedToWindow && this.playPauseButton != null) {
            if (this.shouldShowPauseButton()) {
                ((ImageView)this.playPauseButton).setImageDrawable(this.resources.getDrawable(R.drawable.exo_styled_controls_pause));
                this.playPauseButton.setContentDescription((CharSequence)this.resources.getString(R.string.exo_controls_pause_description));
            } else {
                ((ImageView)this.playPauseButton).setImageDrawable(this.resources.getDrawable(R.drawable.exo_styled_controls_play));
                this.playPauseButton.setContentDescription((CharSequence)this.resources.getString(R.string.exo_controls_play_description));
            }
        }
    }

    private void updatePlaybackSpeedList() {
        Player player = this.player;
        if (player == null) {
            return;
        }
        this.playbackSpeedAdapter.updateSelectedIndex(player.getPlaybackParameters().speed);
        this.settingsAdapter.setSubTextAtPosition(0, this.playbackSpeedAdapter.getSelectedText());
    }

    private void updateProgress() {
        if (this.isVisible() && this.isAttachedToWindow) {
            long l2;
            Player player = this.player;
            long l3 = 0L;
            if (player != null) {
                l3 = this.currentWindowOffset + player.getContentPosition();
                l2 = this.currentWindowOffset + player.getContentBufferedPosition();
            } else {
                l2 = 0L;
            }
            Object object = this.positionView;
            if (object != null && !this.scrubbing) {
                object.setText((CharSequence)Util.getStringForTime(this.formatBuilder, this.formatter, l3));
            }
            if ((object = this.timeBar) != null) {
                object.setPosition(l3);
                this.timeBar.setBufferedPosition(l2);
            }
            if ((object = this.progressUpdateListener) != null) {
                object.onProgressUpdate(l3, l2);
            }
            this.removeCallbacks(this.updateProgressAction);
            int n2 = player == null ? 1 : player.getPlaybackState();
            long l4 = 1000L;
            if (player != null && player.isPlaying()) {
                object = this.timeBar;
                l2 = object != null ? object.getPreferredUpdateDelay() : 1000L;
                l2 = Math.min(l2, 1000L - l3 % 1000L);
                float f2 = player.getPlaybackParameters().speed;
                l3 = l4;
                if (f2 > 0.0f) {
                    l3 = (long)((float)l2 / f2);
                }
                l3 = Util.constrainValue(l3, (long)this.timeBarMinUpdateIntervalMs, 1000L);
                this.postDelayed(this.updateProgressAction, l3);
            } else if (n2 != 4 && n2 != 1) {
                this.postDelayed(this.updateProgressAction, 1000L);
            }
        }
    }

    private void updateRepeatModeButton() {
        ImageView imageView;
        if (this.isVisible() && this.isAttachedToWindow && (imageView = this.repeatToggleButton) != null) {
            if (this.repeatToggleModes == 0) {
                this.updateButton(false, (View)imageView);
                return;
            }
            Player player = this.player;
            if (player == null) {
                this.updateButton(false, (View)imageView);
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
                return;
            }
            this.updateButton(true, (View)imageView);
            int n2 = player.getRepeatMode();
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        this.repeatToggleButton.setImageDrawable(this.repeatAllButtonDrawable);
                        this.repeatToggleButton.setContentDescription((CharSequence)this.repeatAllButtonContentDescription);
                    }
                } else {
                    this.repeatToggleButton.setImageDrawable(this.repeatOneButtonDrawable);
                    this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOneButtonContentDescription);
                }
            } else {
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
            }
        }
    }

    private void updateRewindButton() {
        ControlDispatcher controlDispatcher = this.controlDispatcher;
        if (controlDispatcher instanceof DefaultControlDispatcher) {
            this.rewindMs = ((DefaultControlDispatcher)controlDispatcher).getRewindIncrementMs();
        }
        int n2 = (int)(this.rewindMs / 1000L);
        controlDispatcher = this.rewindButtonTextView;
        if (controlDispatcher != null) {
            controlDispatcher.setText((CharSequence)String.valueOf(n2));
        }
        if ((controlDispatcher = this.rewindButton) != null) {
            controlDispatcher.setContentDescription((CharSequence)this.resources.getQuantityString(R.plurals.exo_controls_rewind_by_amount_description, n2, new Object[]{n2}));
        }
    }

    private void updateSettingsWindowSize() {
        this.settingsView.measure(0, 0);
        int n2 = this.getWidth();
        int n3 = this.settingsWindowMargin;
        n2 = Math.min(this.settingsView.getMeasuredWidth(), n2 - n3 * 2);
        this.settingsWindow.setWidth(n2);
        n2 = Math.min(this.getHeight() - this.settingsWindowMargin * 2, this.settingsView.getMeasuredHeight());
        this.settingsWindow.setHeight(n2);
    }

    private void updateShuffleButton() {
        Object object;
        if (this.isVisible() && this.isAttachedToWindow && (object = this.shuffleButton) != null) {
            Player player = this.player;
            if (!this.controlViewLayoutManager.getShowButton((View)object)) {
                this.updateButton(false, (View)this.shuffleButton);
            } else if (player == null) {
                this.updateButton(false, (View)this.shuffleButton);
                this.shuffleButton.setImageDrawable(this.shuffleOffButtonDrawable);
                this.shuffleButton.setContentDescription((CharSequence)this.shuffleOffContentDescription);
            } else {
                this.updateButton(true, (View)this.shuffleButton);
                ImageView imageView = this.shuffleButton;
                object = player.getShuffleModeEnabled() ? this.shuffleOnButtonDrawable : this.shuffleOffButtonDrawable;
                imageView.setImageDrawable((Drawable)object);
                imageView = this.shuffleButton;
                object = player.getShuffleModeEnabled() ? this.shuffleOnContentDescription : this.shuffleOffContentDescription;
                imageView.setContentDescription((CharSequence)object);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void updateTimeline() {
        block13: {
            block14: {
                var1_1 = this.player;
                if (var1_1 == null) {
                    return;
                }
                var2_2 = this.showMultiWindowTimeBar != false && StyledPlayerControlView.canShowMultiWindowTimeBar(var1_1.getCurrentTimeline(), this.window) != false;
                this.multiWindowTimeBar = var2_2;
                this.currentWindowOffset = 0L;
                var3_3 /* !! */  = var1_1.getCurrentTimeline();
                if (var3_3 /* !! */ .isEmpty()) break block14;
                var4_4 = var1_1.getCurrentWindowIndex();
                var5_5 = this.multiWindowTimeBar != false ? 0 : var4_4;
                var6_6 = this.multiWindowTimeBar != false ? var3_3 /* !! */ .getWindowCount() - 1 : var4_4;
                var7_7 = 0L;
                var9_8 = 0;
                for (var10_9 = var5_5; var10_9 <= var6_6; ++var10_9) {
                    if (var10_9 == var4_4) {
                        this.currentWindowOffset = C.usToMs(var7_7);
                    }
                    var3_3 /* !! */ .getWindow(var10_9, this.window);
                    if (this.window.durationUs == -9223372036854775807L) {
                        Assertions.checkState(this.multiWindowTimeBar ^ true);
                        break block13;
                    }
                    var5_5 = var9_8;
                    for (var11_10 = this.window.firstPeriodIndex; var11_10 <= this.window.lastPeriodIndex; ++var11_10) {
                        var3_3 /* !! */ .getPeriod(var11_10, this.period);
                        var12_11 = this.period.getAdGroupCount();
                        for (var9_8 = 0; var9_8 < var12_11; ++var9_8) {
                            var15_13 = var13_12 = this.period.getAdGroupTimeUs(var9_8);
                            if (var13_12 != -9223372036854775808L) ** GOTO lbl34
                            if (this.period.durationUs == -9223372036854775807L) {
                                var17_14 = var5_5;
                            } else {
                                var15_13 = this.period.durationUs;
lbl34:
                                // 2 sources

                                var17_14 = var5_5;
                                if ((var15_13 += this.period.getPositionInWindowUs()) >= 0L) {
                                    var1_1 = this.adGroupTimesMs;
                                    if (var5_5 == ((Object)var1_1).length) {
                                        var17_14 = ((Object)var1_1).length == 0 ? 1 : ((Object)var1_1).length * 2;
                                        this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, var17_14);
                                        this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, var17_14);
                                    }
                                    this.adGroupTimesMs[var5_5] = C.usToMs(var7_7 + var15_13);
                                    this.playedAdGroups[var5_5] = this.period.hasPlayedAdGroup(var9_8);
                                    var17_14 = var5_5 + 1;
                                }
                            }
                            var5_5 = var17_14;
                        }
                    }
                    var7_7 += this.window.durationUs;
                    var9_8 = var5_5;
                }
                break block13;
            }
            var9_8 = 0;
            var7_7 = 0L;
        }
        var7_7 = C.usToMs(var7_7);
        var3_3 /* !! */  = this.durationView;
        if (var3_3 /* !! */  != null) {
            var3_3 /* !! */ .setText((CharSequence)Util.getStringForTime(this.formatBuilder, this.formatter, var7_7));
        }
        if ((var3_3 /* !! */  = this.timeBar) != null) {
            var3_3 /* !! */ .setDuration(var7_7);
            var4_4 = this.extraAdGroupTimesMs.length;
            var5_5 = var9_8 + var4_4;
            var3_3 /* !! */  = (Timeline)this.adGroupTimesMs;
            if (var5_5 > ((Timeline)var3_3 /* !! */ ).length) {
                this.adGroupTimesMs = Arrays.copyOf((long[])var3_3 /* !! */ , var5_5);
                this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, var5_5);
            }
            System.arraycopy(this.extraAdGroupTimesMs, 0, this.adGroupTimesMs, var9_8, var4_4);
            System.arraycopy(this.extraPlayedAdGroups, 0, this.playedAdGroups, var9_8, var4_4);
            this.timeBar.setAdGroupTimesMs(this.adGroupTimesMs, this.playedAdGroups, var5_5);
        }
        this.updateProgress();
    }

    private void updateTrackLists() {
        this.initTrackSelectionAdapter();
        boolean bl = this.textTrackSelectionAdapter.getItemCount() > 0;
        this.updateButton(bl, (View)this.subtitleButton);
    }

    public void addVisibilityListener(VisibilityListener visibilityListener) {
        Assertions.checkNotNull(visibilityListener);
        this.visibilityListeners.add(visibilityListener);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = this.dispatchMediaKeyEvent(keyEvent) || super.dispatchKeyEvent(keyEvent);
        return bl;
    }

    public boolean dispatchMediaKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        Player player = this.player;
        if (player != null && StyledPlayerControlView.isHandledMediaKey(n2)) {
            if (keyEvent.getAction() == 0) {
                if (n2 == 90) {
                    if (player.getPlaybackState() != 4) {
                        this.controlDispatcher.dispatchFastForward(player);
                    }
                } else if (n2 == 89) {
                    this.controlDispatcher.dispatchRewind(player);
                } else if (keyEvent.getRepeatCount() == 0) {
                    if (n2 != 79 && n2 != 85) {
                        if (n2 != 87) {
                            if (n2 != 88) {
                                if (n2 != 126) {
                                    if (n2 == 127) {
                                        this.dispatchPause(player);
                                    }
                                } else {
                                    this.dispatchPlay(player);
                                }
                            } else {
                                this.controlDispatcher.dispatchPrevious(player);
                            }
                        } else {
                            this.controlDispatcher.dispatchNext(player);
                        }
                    } else {
                        this.dispatchPlayPause(player);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getRepeatToggleModes() {
        return this.repeatToggleModes;
    }

    public boolean getShowShuffleButton() {
        return this.controlViewLayoutManager.getShowButton((View)this.shuffleButton);
    }

    public boolean getShowSubtitleButton() {
        return this.controlViewLayoutManager.getShowButton((View)this.subtitleButton);
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public boolean getShowVrButton() {
        return this.controlViewLayoutManager.getShowButton(this.vrButton);
    }

    public void hide() {
        this.controlViewLayoutManager.hide();
    }

    public void hideImmediately() {
        this.controlViewLayoutManager.hideImmediately();
    }

    public boolean isAnimationEnabled() {
        return this.controlViewLayoutManager.isAnimationEnabled();
    }

    public boolean isFullyVisible() {
        return this.controlViewLayoutManager.isFullyVisible();
    }

    public boolean isVisible() {
        boolean bl = this.getVisibility() == 0;
        return bl;
    }

    void notifyOnVisibilityChange() {
        Iterator<VisibilityListener> iterator2 = this.visibilityListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onVisibilityChange(this.getVisibility());
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.controlViewLayoutManager.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.isFullyVisible()) {
            this.controlViewLayoutManager.resetHideCallbacks();
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.controlViewLayoutManager.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.controlViewLayoutManager.removeHideCallbacks();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        this.controlViewLayoutManager.onLayout(bl, n2, n3, n4, n5);
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public void removeVisibilityListener(VisibilityListener visibilityListener) {
        this.visibilityListeners.remove(visibilityListener);
    }

    void requestPlayPauseFocus() {
        View view = this.playPauseButton;
        if (view != null) {
            view.requestFocus();
        }
    }

    public void setAnimationEnabled(boolean bl) {
        this.controlViewLayoutManager.setAnimationEnabled(bl);
    }

    public void setControlDispatcher(ControlDispatcher controlDispatcher) {
        if (this.controlDispatcher != controlDispatcher) {
            this.controlDispatcher = controlDispatcher;
            this.updateNavigation();
        }
    }

    public void setExtraAdGroupMarkers(long[] lArray, boolean[] blArray) {
        boolean bl = false;
        if (lArray == null) {
            this.extraAdGroupTimesMs = new long[0];
            this.extraPlayedAdGroups = new boolean[0];
        } else {
            if (lArray.length == (blArray = Assertions.checkNotNull(blArray)).length) {
                bl = true;
            }
            Assertions.checkArgument(bl);
            this.extraAdGroupTimesMs = lArray;
            this.extraPlayedAdGroups = blArray;
        }
        this.updateTimeline();
    }

    public void setOnFullScreenModeChangedListener(OnFullScreenModeChangedListener onFullScreenModeChangedListener) {
        this.onFullScreenModeChangedListener = onFullScreenModeChangedListener;
        ImageView imageView = this.fullScreenButton;
        boolean bl = true;
        boolean bl2 = onFullScreenModeChangedListener != null;
        StyledPlayerControlView.updateFullScreenButtonVisibility((View)imageView, bl2);
        imageView = this.minimalFullScreenButton;
        bl2 = onFullScreenModeChangedListener != null ? bl : false;
        StyledPlayerControlView.updateFullScreenButtonVisibility((View)imageView, bl2);
    }

    @Deprecated
    public void setPlaybackPreparer(PlaybackPreparer playbackPreparer) {
        this.playbackPreparer = playbackPreparer;
    }

    public void setPlayer(Player player) {
        Object object = Looper.myLooper();
        Looper looper = Looper.getMainLooper();
        boolean bl = true;
        boolean bl2 = object == looper;
        Assertions.checkState(bl2);
        bl2 = bl;
        if (player != null) {
            bl2 = player.getApplicationLooper() == Looper.getMainLooper() ? bl : false;
        }
        Assertions.checkArgument(bl2);
        object = this.player;
        if (object == player) {
            return;
        }
        if (object != null) {
            object.removeListener(this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener(this.componentListener);
        }
        if (player instanceof ExoPlayer) {
            if ((player = ((ExoPlayer)player).getTrackSelector()) instanceof DefaultTrackSelector) {
                this.trackSelector = (DefaultTrackSelector)((Object)player);
            }
        } else {
            this.trackSelector = null;
        }
        this.updateAll();
    }

    public void setProgressUpdateListener(ProgressUpdateListener progressUpdateListener) {
        this.progressUpdateListener = progressUpdateListener;
    }

    public void setRepeatToggleModes(int n2) {
        this.repeatToggleModes = n2;
        Player player = this.player;
        boolean bl = false;
        if (player != null) {
            int n3 = player.getRepeatMode();
            if (n2 == 0 && n3 != 0) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 0);
            } else if (n2 == 1 && n3 == 2) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 1);
            } else if (n2 == 2 && n3 == 1) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 2);
            }
        }
        player = this.controlViewLayoutManager;
        ImageView imageView = this.repeatToggleButton;
        if (n2 != 0) {
            bl = true;
        }
        player.setShowButton((View)imageView, bl);
        this.updateRepeatModeButton();
    }

    public void setShowFastForwardButton(boolean bl) {
        this.controlViewLayoutManager.setShowButton(this.fastForwardButton, bl);
        this.updateNavigation();
    }

    public void setShowMultiWindowTimeBar(boolean bl) {
        this.showMultiWindowTimeBar = bl;
        this.updateTimeline();
    }

    public void setShowNextButton(boolean bl) {
        this.controlViewLayoutManager.setShowButton(this.nextButton, bl);
        this.updateNavigation();
    }

    public void setShowPreviousButton(boolean bl) {
        this.controlViewLayoutManager.setShowButton(this.previousButton, bl);
        this.updateNavigation();
    }

    public void setShowRewindButton(boolean bl) {
        this.controlViewLayoutManager.setShowButton(this.rewindButton, bl);
        this.updateNavigation();
    }

    public void setShowShuffleButton(boolean bl) {
        this.controlViewLayoutManager.setShowButton((View)this.shuffleButton, bl);
        this.updateShuffleButton();
    }

    public void setShowSubtitleButton(boolean bl) {
        this.controlViewLayoutManager.setShowButton((View)this.subtitleButton, bl);
    }

    public void setShowTimeoutMs(int n2) {
        this.showTimeoutMs = n2;
        if (this.isFullyVisible()) {
            this.controlViewLayoutManager.resetHideCallbacks();
        }
    }

    public void setShowVrButton(boolean bl) {
        this.controlViewLayoutManager.setShowButton(this.vrButton, bl);
    }

    public void setTimeBarMinUpdateInterval(int n2) {
        this.timeBarMinUpdateIntervalMs = Util.constrainValue(n2, 16, 1000);
    }

    public void setVrButtonListener(View.OnClickListener onClickListener) {
        View view = this.vrButton;
        if (view != null) {
            view.setOnClickListener(onClickListener);
            boolean bl = onClickListener != null;
            this.updateButton(bl, this.vrButton);
        }
    }

    public void show() {
        this.controlViewLayoutManager.show();
    }

    void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateRepeatModeButton();
        this.updateShuffleButton();
        this.updateTrackLists();
        this.updatePlaybackSpeedList();
        this.updateTimeline();
    }

    private final class AudioTrackSelectionAdapter
    extends TrackSelectionAdapter {
        private AudioTrackSelectionAdapter() {
        }

        @Override
        public void init(List<Integer> list, List<TrackInfo> list2, MappingTrackSelector.MappedTrackInfo mappedTrackInfo) {
            Object object;
            int n2;
            int n3;
            block7: {
                n3 = 0;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    int n4 = list.get(n2);
                    object = mappedTrackInfo.getTrackGroups(n4);
                    if (StyledPlayerControlView.this.trackSelector == null || !StyledPlayerControlView.this.trackSelector.getParameters().hasSelectionOverride(n4, (TrackGroupArray)object)) continue;
                    n2 = 1;
                    break block7;
                }
                n2 = 0;
            }
            if (list2.isEmpty()) {
                StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, StyledPlayerControlView.this.getResources().getString(R.string.exo_track_selection_none));
            } else if (n2 == 0) {
                StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, StyledPlayerControlView.this.getResources().getString(R.string.exo_track_selection_auto));
            } else {
                while (n3 < list2.size()) {
                    object = list2.get(n3);
                    if (object.selected) {
                        StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, object.trackName);
                        break;
                    }
                    ++n3;
                }
            }
            this.rendererIndices = list;
            this.tracks = list2;
            this.mappedTrackInfo = mappedTrackInfo;
        }

        public /* synthetic */ void lambda$onBindViewHolderAtZeroPosition$0$StyledPlayerControlView$AudioTrackSelectionAdapter(View object) {
            if (StyledPlayerControlView.this.trackSelector != null) {
                object = StyledPlayerControlView.this.trackSelector.getParameters().buildUpon();
                for (int i2 = 0; i2 < this.rendererIndices.size(); ++i2) {
                    object = ((DefaultTrackSelector.ParametersBuilder)object).clearSelectionOverrides((Integer)this.rendererIndices.get(i2));
                }
                Assertions.checkNotNull(StyledPlayerControlView.this.trackSelector).setParameters((DefaultTrackSelector.ParametersBuilder)object);
            }
            StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, StyledPlayerControlView.this.getResources().getString(R.string.exo_track_selection_auto));
            StyledPlayerControlView.this.settingsWindow.dismiss();
        }

        @Override
        public void onBindViewHolderAtZeroPosition(SubSettingViewHolder subSettingViewHolder) {
            int n2;
            int n3;
            DefaultTrackSelector.Parameters parameters;
            block2: {
                subSettingViewHolder.textView.setText(R.string.exo_track_selection_auto);
                parameters = Assertions.checkNotNull(StyledPlayerControlView.this.trackSelector).getParameters();
                n3 = 0;
                for (n2 = 0; n2 < this.rendererIndices.size(); ++n2) {
                    int n4 = (Integer)this.rendererIndices.get(n2);
                    if (!parameters.hasSelectionOverride(n4, Assertions.checkNotNull(this.mappedTrackInfo).getTrackGroups(n4))) continue;
                    n2 = 1;
                    break block2;
                }
                n2 = 0;
            }
            parameters = subSettingViewHolder.checkView;
            if (n2 != 0) {
                n3 = 4;
            }
            parameters.setVisibility(n3);
            subSettingViewHolder.itemView.setOnClickListener((View.OnClickListener)new _$.Lambda.StyledPlayerControlView.AudioTrackSelectionAdapter.hrRy8Jfn1OBeXfostW2eNouUobI(this));
        }

        @Override
        public void onTrackSelection(String string2) {
            StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, string2);
        }
    }

    private final class ComponentListener
    implements Player.EventListener,
    TimeBar.OnScrubListener,
    View.OnClickListener,
    PopupWindow.OnDismissListener {
        private ComponentListener() {
        }

        public void onClick(View object) {
            Player player = StyledPlayerControlView.this.player;
            if (player == null) {
                return;
            }
            StyledPlayerControlView.this.controlViewLayoutManager.resetHideCallbacks();
            if (StyledPlayerControlView.this.nextButton == object) {
                StyledPlayerControlView.this.controlDispatcher.dispatchNext(player);
            } else if (StyledPlayerControlView.this.previousButton == object) {
                StyledPlayerControlView.this.controlDispatcher.dispatchPrevious(player);
            } else if (StyledPlayerControlView.this.fastForwardButton == object) {
                if (player.getPlaybackState() != 4) {
                    StyledPlayerControlView.this.controlDispatcher.dispatchFastForward(player);
                }
            } else if (StyledPlayerControlView.this.rewindButton == object) {
                StyledPlayerControlView.this.controlDispatcher.dispatchRewind(player);
            } else if (StyledPlayerControlView.this.playPauseButton == object) {
                StyledPlayerControlView.this.dispatchPlayPause(player);
            } else if (StyledPlayerControlView.this.repeatToggleButton == object) {
                StyledPlayerControlView.this.controlDispatcher.dispatchSetRepeatMode(player, RepeatModeUtil.getNextRepeatMode(player.getRepeatMode(), StyledPlayerControlView.this.repeatToggleModes));
            } else if (StyledPlayerControlView.this.shuffleButton == object) {
                StyledPlayerControlView.this.controlDispatcher.dispatchSetShuffleModeEnabled(player, player.getShuffleModeEnabled() ^ true);
            } else if (StyledPlayerControlView.this.settingsButton == object) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                object = StyledPlayerControlView.this;
                ((StyledPlayerControlView)((Object)object)).displaySettingsWindow(((StyledPlayerControlView)((Object)object)).settingsAdapter);
            } else if (StyledPlayerControlView.this.playbackSpeedButton == object) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                object = StyledPlayerControlView.this;
                ((StyledPlayerControlView)((Object)object)).displaySettingsWindow(((StyledPlayerControlView)((Object)object)).playbackSpeedAdapter);
            } else if (StyledPlayerControlView.this.audioTrackButton == object) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                object = StyledPlayerControlView.this;
                ((StyledPlayerControlView)((Object)object)).displaySettingsWindow(((StyledPlayerControlView)((Object)object)).audioTrackSelectionAdapter);
            } else if (StyledPlayerControlView.this.subtitleButton == object) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                object = StyledPlayerControlView.this;
                ((StyledPlayerControlView)((Object)object)).displaySettingsWindow(((StyledPlayerControlView)((Object)object)).textTrackSelectionAdapter);
            }
        }

        public void onDismiss() {
            if (StyledPlayerControlView.this.needToHideBars) {
                StyledPlayerControlView.this.controlViewLayoutManager.resetHideCallbacks();
            }
        }

        @Override
        public void onEvents(Player player, Player.Events events) {
            if (events.containsAny(5, 6)) {
                StyledPlayerControlView.this.updatePlayPauseButton();
            }
            if (events.containsAny(5, 6, 8)) {
                StyledPlayerControlView.this.updateProgress();
            }
            if (events.contains(9)) {
                StyledPlayerControlView.this.updateRepeatModeButton();
            }
            if (events.contains(10)) {
                StyledPlayerControlView.this.updateShuffleButton();
            }
            if (events.containsAny(9, 10, 12, 0)) {
                StyledPlayerControlView.this.updateNavigation();
            }
            if (events.containsAny(12, 0)) {
                StyledPlayerControlView.this.updateTimeline();
            }
            if (events.contains(13)) {
                StyledPlayerControlView.this.updatePlaybackSpeedList();
            }
            if (events.contains(2)) {
                StyledPlayerControlView.this.updateTrackLists();
            }
        }

        @Override
        public /* synthetic */ void onExperimentalOffloadSchedulingEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalOffloadSchedulingEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onExperimentalSleepingForOffloadChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalSleepingForOffloadChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsPlayingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsPlayingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onMediaItemTransition(MediaItem mediaItem, int n2) {
            Player.EventListener._CC.$default$onMediaItemTransition((Player.EventListener)this, (MediaItem)mediaItem, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayWhenReadyChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayWhenReadyChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            Player.EventListener._CC.$default$onPlaybackParametersChanged((Player.EventListener)this, (PlaybackParameters)playbackParameters);
        }

        @Override
        public /* synthetic */ void onPlaybackStateChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackStateChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlaybackSuppressionReasonChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackSuppressionReasonChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayerError(ExoPlaybackException exoPlaybackException) {
            Player.EventListener._CC.$default$onPlayerError((Player.EventListener)this, (ExoPlaybackException)exoPlaybackException);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onPlayerStateChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayerStateChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPositionDiscontinuity(int n2) {
            Player.EventListener._CC.$default$onPositionDiscontinuity((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onRepeatModeChanged(int n2) {
            Player.EventListener._CC.$default$onRepeatModeChanged((Player.EventListener)this, (int)n2);
        }

        public void onScrubMove(TimeBar timeBar, long l2) {
            if (StyledPlayerControlView.this.positionView != null) {
                StyledPlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime(StyledPlayerControlView.this.formatBuilder, StyledPlayerControlView.this.formatter, l2));
            }
        }

        public void onScrubStart(TimeBar timeBar, long l2) {
            StyledPlayerControlView.access$302(StyledPlayerControlView.this, true);
            if (StyledPlayerControlView.this.positionView != null) {
                StyledPlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime(StyledPlayerControlView.this.formatBuilder, StyledPlayerControlView.this.formatter, l2));
            }
            StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
        }

        public void onScrubStop(TimeBar object, long l2, boolean bl) {
            StyledPlayerControlView.access$302(StyledPlayerControlView.this, false);
            if (!bl && StyledPlayerControlView.this.player != null) {
                object = StyledPlayerControlView.this;
                ((StyledPlayerControlView)((Object)object)).seekToTimeBarPosition(((StyledPlayerControlView)((Object)object)).player, l2);
            }
            StyledPlayerControlView.this.controlViewLayoutManager.resetHideCallbacks();
        }

        @Override
        @Deprecated
        public /* synthetic */ void onSeekProcessed() {
            Player.EventListener._CC.$default$onSeekProcessed((Player.EventListener)this);
        }

        @Override
        public /* synthetic */ void onShuffleModeEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onShuffleModeEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onStaticMetadataChanged(List<Metadata> list) {
            Player.EventListener._CC.$default$onStaticMetadataChanged((Player.EventListener)this, list);
        }

        @Override
        public /* synthetic */ void onTimelineChanged(Timeline timeline, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onTimelineChanged(Timeline timeline, Object object, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (Object)object, (int)n2);
        }

        @Override
        public /* synthetic */ void onTracksChanged(TrackGroupArray trackGroupArray, TrackSelectionArray trackSelectionArray) {
            Player.EventListener._CC.$default$onTracksChanged((Player.EventListener)this, (TrackGroupArray)trackGroupArray, (TrackSelectionArray)trackSelectionArray);
        }
    }

    public static interface OnFullScreenModeChangedListener {
        public void onFullScreenModeChanged(boolean var1);
    }

    private final class PlaybackSpeedAdapter
    extends RecyclerView.Adapter<SubSettingViewHolder> {
        private final String[] playbackSpeedTexts;
        private final int[] playbackSpeedsMultBy100;
        private int selectedIndex;

        public PlaybackSpeedAdapter(String[] stringArray, int[] nArray) {
            this.playbackSpeedTexts = stringArray;
            this.playbackSpeedsMultBy100 = nArray;
        }

        @Override
        public int getItemCount() {
            return this.playbackSpeedTexts.length;
        }

        public String getSelectedText() {
            return this.playbackSpeedTexts[this.selectedIndex];
        }

        public /* synthetic */ void lambda$onBindViewHolder$0$StyledPlayerControlView$PlaybackSpeedAdapter(int n2, View view) {
            if (n2 != this.selectedIndex) {
                float f2 = (float)this.playbackSpeedsMultBy100[n2] / 100.0f;
                StyledPlayerControlView.this.setPlaybackSpeed(f2);
            }
            StyledPlayerControlView.this.settingsWindow.dismiss();
        }

        @Override
        public void onBindViewHolder(SubSettingViewHolder subSettingViewHolder, int n2) {
            if (n2 < this.playbackSpeedTexts.length) {
                subSettingViewHolder.textView.setText((CharSequence)this.playbackSpeedTexts[n2]);
            }
            View view = subSettingViewHolder.checkView;
            int n3 = n2 == this.selectedIndex ? 0 : 4;
            view.setVisibility(n3);
            subSettingViewHolder.itemView.setOnClickListener((View.OnClickListener)new _$.Lambda.StyledPlayerControlView.PlaybackSpeedAdapter.mEGmGMMlAI__CipqsxEmK1AQlD4(this, n2));
        }

        @Override
        public SubSettingViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
            return new SubSettingViewHolder(LayoutInflater.from((Context)StyledPlayerControlView.this.getContext()).inflate(R.layout.exo_styled_sub_settings_list_item, null));
        }

        public void updateSelectedIndex(float f2) {
            int[] nArray;
            int n2 = Math.round(f2 * 100.0f);
            int n3 = 0;
            int n4 = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < (nArray = this.playbackSpeedsMultBy100).length; ++i2) {
                int n5 = Math.abs(n2 - nArray[i2]);
                int n6 = n4;
                if (n5 < n4) {
                    n3 = i2;
                    n6 = n5;
                }
                n4 = n6;
            }
            this.selectedIndex = n3;
        }
    }

    public static interface ProgressUpdateListener {
        public void onProgressUpdate(long var1, long var3);
    }

    private final class SettingViewHolder
    extends RecyclerView.ViewHolder {
        private final ImageView iconView;
        private final TextView mainTextView;
        private final TextView subTextView;

        public SettingViewHolder(View view) {
            super(view);
            this.mainTextView = (TextView)view.findViewById(R.id.exo_main_text);
            this.subTextView = (TextView)view.findViewById(R.id.exo_sub_text);
            this.iconView = (ImageView)view.findViewById(R.id.exo_icon);
            view.setOnClickListener((View.OnClickListener)new _$.Lambda.StyledPlayerControlView.SettingViewHolder.QG0HWBZp7AbXaQL4toH_6bB9s6o(this));
        }

        public /* synthetic */ void lambda$new$0$StyledPlayerControlView$SettingViewHolder(View view) {
            StyledPlayerControlView.this.onSettingViewClicked(this.getAdapterPosition());
        }
    }

    private class SettingsAdapter
    extends RecyclerView.Adapter<SettingViewHolder> {
        private final Drawable[] iconIds;
        private final String[] mainTexts;
        private final String[] subTexts;

        public SettingsAdapter(String[] stringArray, Drawable[] drawableArray) {
            this.mainTexts = stringArray;
            this.subTexts = new String[stringArray.length];
            this.iconIds = drawableArray;
        }

        @Override
        public int getItemCount() {
            return this.mainTexts.length;
        }

        @Override
        public long getItemId(int n2) {
            return n2;
        }

        @Override
        public void onBindViewHolder(SettingViewHolder settingViewHolder, int n2) {
            settingViewHolder.mainTextView.setText((CharSequence)this.mainTexts[n2]);
            if (this.subTexts[n2] == null) {
                settingViewHolder.subTextView.setVisibility(8);
            } else {
                settingViewHolder.subTextView.setText((CharSequence)this.subTexts[n2]);
            }
            if (this.iconIds[n2] == null) {
                settingViewHolder.iconView.setVisibility(8);
            } else {
                settingViewHolder.iconView.setImageDrawable(this.iconIds[n2]);
            }
        }

        @Override
        public SettingViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
            viewGroup = LayoutInflater.from((Context)StyledPlayerControlView.this.getContext()).inflate(R.layout.exo_styled_settings_list_item, null);
            return new SettingViewHolder((View)viewGroup);
        }

        public void setSubTextAtPosition(int n2, String string2) {
            this.subTexts[n2] = string2;
        }
    }

    private static class SubSettingViewHolder
    extends RecyclerView.ViewHolder {
        public final View checkView;
        public final TextView textView;

        public SubSettingViewHolder(View view) {
            super(view);
            this.textView = (TextView)view.findViewById(R.id.exo_text);
            this.checkView = view.findViewById(R.id.exo_check);
        }
    }

    private final class TextTrackSelectionAdapter
    extends TrackSelectionAdapter {
        private TextTrackSelectionAdapter() {
        }

        @Override
        public void init(List<Integer> list, List<TrackInfo> list2, MappingTrackSelector.MappedTrackInfo mappedTrackInfo) {
            boolean bl;
            boolean bl2 = false;
            int n2 = 0;
            while (true) {
                bl = bl2;
                if (n2 >= list2.size()) break;
                if (list2.get((int)n2).selected) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (StyledPlayerControlView.this.subtitleButton != null) {
                ImageView imageView = StyledPlayerControlView.this.subtitleButton;
                Object object = StyledPlayerControlView.this;
                object = bl ? ((StyledPlayerControlView)object).subtitleOnButtonDrawable : ((StyledPlayerControlView)object).subtitleOffButtonDrawable;
                imageView.setImageDrawable((Drawable)object);
                imageView = StyledPlayerControlView.this.subtitleButton;
                object = bl ? StyledPlayerControlView.this.subtitleOnContentDescription : StyledPlayerControlView.this.subtitleOffContentDescription;
                imageView.setContentDescription((CharSequence)object);
            }
            this.rendererIndices = list;
            this.tracks = list2;
            this.mappedTrackInfo = mappedTrackInfo;
        }

        public /* synthetic */ void lambda$onBindViewHolderAtZeroPosition$0$StyledPlayerControlView$TextTrackSelectionAdapter(View object) {
            if (StyledPlayerControlView.this.trackSelector != null) {
                object = StyledPlayerControlView.this.trackSelector.getParameters().buildUpon();
                for (int i2 = 0; i2 < this.rendererIndices.size(); ++i2) {
                    int n2 = (Integer)this.rendererIndices.get(i2);
                    object = ((DefaultTrackSelector.ParametersBuilder)object).clearSelectionOverrides(n2).setRendererDisabled(n2, true);
                }
                Assertions.checkNotNull(StyledPlayerControlView.this.trackSelector).setParameters((DefaultTrackSelector.ParametersBuilder)object);
                StyledPlayerControlView.this.settingsWindow.dismiss();
            }
        }

        @Override
        public void onBindViewHolder(SubSettingViewHolder subSettingViewHolder, int n2) {
            super.onBindViewHolder(subSettingViewHolder, n2);
            if (n2 > 0) {
                TrackInfo trackInfo = (TrackInfo)this.tracks.get(n2 - 1);
                subSettingViewHolder = subSettingViewHolder.checkView;
                n2 = trackInfo.selected ? 0 : 4;
                subSettingViewHolder.setVisibility(n2);
            }
        }

        @Override
        public void onBindViewHolderAtZeroPosition(SubSettingViewHolder subSettingViewHolder) {
            int n2;
            int n3;
            block1: {
                subSettingViewHolder.textView.setText(R.string.exo_track_selection_none);
                n3 = 0;
                for (n2 = 0; n2 < this.tracks.size(); ++n2) {
                    if (!((TrackInfo)this.tracks.get((int)n2)).selected) continue;
                    n2 = 0;
                    break block1;
                }
                n2 = 1;
            }
            View view = subSettingViewHolder.checkView;
            n2 = n2 != 0 ? n3 : 4;
            view.setVisibility(n2);
            subSettingViewHolder.itemView.setOnClickListener((View.OnClickListener)new _$.Lambda.StyledPlayerControlView.TextTrackSelectionAdapter.T0d3G57M_lGcyhOvHI6rvuBqAzc(this));
        }

        @Override
        public void onTrackSelection(String string2) {
        }
    }

    private static final class TrackInfo {
        public final int groupIndex;
        public final int rendererIndex;
        public final boolean selected;
        public final int trackIndex;
        public final String trackName;

        public TrackInfo(int n2, int n3, int n4, String string2, boolean bl) {
            this.rendererIndex = n2;
            this.groupIndex = n3;
            this.trackIndex = n4;
            this.trackName = string2;
            this.selected = bl;
        }
    }

    private abstract class TrackSelectionAdapter
    extends RecyclerView.Adapter<SubSettingViewHolder> {
        protected MappingTrackSelector.MappedTrackInfo mappedTrackInfo = null;
        protected List<Integer> rendererIndices = new ArrayList<Integer>();
        protected List<TrackInfo> tracks = new ArrayList<TrackInfo>();

        public void clear() {
            this.tracks = Collections.emptyList();
            this.mappedTrackInfo = null;
        }

        @Override
        public int getItemCount() {
            int n2 = this.tracks.isEmpty() ? 0 : this.tracks.size() + 1;
            return n2;
        }

        public abstract void init(List<Integer> var1, List<TrackInfo> var2, MappingTrackSelector.MappedTrackInfo var3);

        public /* synthetic */ void lambda$onBindViewHolder$0$StyledPlayerControlView$TrackSelectionAdapter(TrackInfo trackInfo, View object) {
            if (this.mappedTrackInfo != null && StyledPlayerControlView.this.trackSelector != null) {
                object = StyledPlayerControlView.this.trackSelector.getParameters().buildUpon();
                for (int i2 = 0; i2 < this.rendererIndices.size(); ++i2) {
                    int n2 = this.rendererIndices.get(i2);
                    object = n2 == trackInfo.rendererIndex ? ((DefaultTrackSelector.ParametersBuilder)object).setSelectionOverride(n2, Assertions.checkNotNull(this.mappedTrackInfo).getTrackGroups(n2), new DefaultTrackSelector.SelectionOverride(trackInfo.groupIndex, trackInfo.trackIndex)).setRendererDisabled(n2, false) : ((DefaultTrackSelector.ParametersBuilder)object).clearSelectionOverrides(n2).setRendererDisabled(n2, true);
                }
                Assertions.checkNotNull(StyledPlayerControlView.this.trackSelector).setParameters((DefaultTrackSelector.ParametersBuilder)object);
                this.onTrackSelection(trackInfo.trackName);
                StyledPlayerControlView.this.settingsWindow.dismiss();
            }
        }

        @Override
        public void onBindViewHolder(SubSettingViewHolder subSettingViewHolder, int n2) {
            if (StyledPlayerControlView.this.trackSelector != null && this.mappedTrackInfo != null) {
                if (n2 == 0) {
                    this.onBindViewHolderAtZeroPosition(subSettingViewHolder);
                } else {
                    Object object = this.tracks;
                    int n3 = 1;
                    object = object.get(n2 - 1);
                    TrackGroupArray trackGroupArray = this.mappedTrackInfo.getTrackGroups(((TrackInfo)object).rendererIndex);
                    boolean bl = Assertions.checkNotNull(StyledPlayerControlView.this.trackSelector).getParameters().hasSelectionOverride(((TrackInfo)object).rendererIndex, trackGroupArray);
                    int n4 = 0;
                    n2 = bl && ((TrackInfo)object).selected ? n3 : 0;
                    subSettingViewHolder.textView.setText((CharSequence)((TrackInfo)object).trackName);
                    trackGroupArray = subSettingViewHolder.checkView;
                    n2 = n2 != 0 ? n4 : 4;
                    trackGroupArray.setVisibility(n2);
                    subSettingViewHolder.itemView.setOnClickListener((View.OnClickListener)new _$.Lambda.StyledPlayerControlView.TrackSelectionAdapter.9z_RzuVk07lzOQ3zOBPYNxuP63k(this, (TrackInfo)object));
                }
            }
        }

        public abstract void onBindViewHolderAtZeroPosition(SubSettingViewHolder var1);

        @Override
        public SubSettingViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
            return new SubSettingViewHolder(LayoutInflater.from((Context)StyledPlayerControlView.this.getContext()).inflate(R.layout.exo_styled_sub_settings_list_item, null));
        }

        public abstract void onTrackSelection(String var1);
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

