/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.flac.PictureFrame;
import com.google.android.exoplayer2.metadata.id3.ApicFrame;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.android.exoplayer2.ui.PlayerControlView;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.SubtitleView;
import com.google.android.exoplayer2.ui.spherical.SingleTapListener;
import com.google.android.exoplayer2.ui.spherical.SphericalGLSurfaceView;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ErrorMessageProvider;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoDecoderGLSurfaceView;
import com.google.android.exoplayer2.video.VideoListener;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class PlayerView
extends FrameLayout
implements AdsLoader.AdViewProvider {
    private static final int PICTURE_TYPE_FRONT_COVER = 3;
    private static final int PICTURE_TYPE_NOT_SET = -1;
    public static final int SHOW_BUFFERING_ALWAYS = 2;
    public static final int SHOW_BUFFERING_NEVER = 0;
    public static final int SHOW_BUFFERING_WHEN_PLAYING = 1;
    private static final int SURFACE_TYPE_NONE = 0;
    private static final int SURFACE_TYPE_SPHERICAL_GL_SURFACE_VIEW = 3;
    private static final int SURFACE_TYPE_SURFACE_VIEW = 1;
    private static final int SURFACE_TYPE_TEXTURE_VIEW = 2;
    private static final int SURFACE_TYPE_VIDEO_DECODER_GL_SURFACE_VIEW = 4;
    private final FrameLayout adOverlayFrameLayout;
    private final ImageView artworkView;
    private final View bufferingView;
    private final ComponentListener componentListener = new ComponentListener();
    private final AspectRatioFrameLayout contentFrame;
    private final PlayerControlView controller;
    private boolean controllerAutoShow;
    private boolean controllerHideDuringAds;
    private boolean controllerHideOnTouch;
    private int controllerShowTimeoutMs;
    private PlayerControlView.VisibilityListener controllerVisibilityListener;
    private CharSequence customErrorMessage;
    private Drawable defaultArtwork;
    private ErrorMessageProvider<? super ExoPlaybackException> errorMessageProvider;
    private final TextView errorMessageView;
    private boolean isTouching;
    private boolean keepContentOnPlayerReset;
    private final FrameLayout overlayFrameLayout;
    private Player player;
    private int showBuffering;
    private final View shutterView;
    private final SubtitleView subtitleView;
    private final View surfaceView;
    private int textureViewRotation;
    private boolean useArtwork;
    private boolean useController;
    private boolean useSensorRotation;

    public PlayerView(Context context) {
        this(context, null);
    }

    public PlayerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PlayerView(Context object, AttributeSet attributeSet, int n2) {
        super((Context)object, attributeSet, n2);
        Object object2;
        boolean bl;
        int n3;
        boolean bl2;
        boolean bl3;
        int n4;
        int n5;
        boolean bl4;
        int n6;
        boolean bl5;
        int n7;
        boolean bl6;
        Object object3;
        if (this.isInEditMode()) {
            this.contentFrame = null;
            this.shutterView = null;
            this.surfaceView = null;
            this.artworkView = null;
            this.subtitleView = null;
            this.bufferingView = null;
            this.errorMessageView = null;
            this.controller = null;
            this.adOverlayFrameLayout = null;
            this.overlayFrameLayout = null;
            object = new ImageView((Context)object);
            if (Util.SDK_INT >= 23) {
                PlayerView.configureEditModeLogoV23(this.getResources(), (ImageView)object);
            } else {
                PlayerView.configureEditModeLogo(this.getResources(), (ImageView)object);
            }
            this.addView((View)object);
            return;
        }
        int n8 = R.layout.exo_player_view;
        this.useSensorRotation = true;
        if (attributeSet != null) {
            object3 = object.getTheme().obtainStyledAttributes(attributeSet, R.styleable.PlayerView, 0, 0);
            try {
                bl6 = object3.hasValue(R.styleable.PlayerView_shutter_background_color);
                n7 = object3.getColor(R.styleable.PlayerView_shutter_background_color, 0);
                n8 = object3.getResourceId(R.styleable.PlayerView_player_layout_id, n8);
                bl5 = object3.getBoolean(R.styleable.PlayerView_use_artwork, true);
                n6 = object3.getResourceId(R.styleable.PlayerView_default_artwork, 0);
                bl4 = object3.getBoolean(R.styleable.PlayerView_use_controller, true);
                n5 = object3.getInt(R.styleable.PlayerView_surface_type, 1);
                n4 = object3.getInt(R.styleable.PlayerView_resize_mode, 0);
                n2 = object3.getInt(R.styleable.PlayerView_show_timeout, 5000);
                bl3 = object3.getBoolean(R.styleable.PlayerView_hide_on_touch, true);
                bl2 = object3.getBoolean(R.styleable.PlayerView_auto_show, true);
                n3 = object3.getInteger(R.styleable.PlayerView_show_buffering, 0);
                this.keepContentOnPlayerReset = object3.getBoolean(R.styleable.PlayerView_keep_content_on_player_reset, this.keepContentOnPlayerReset);
                bl = object3.getBoolean(R.styleable.PlayerView_hide_during_ads, true);
                this.useSensorRotation = object3.getBoolean(R.styleable.PlayerView_use_sensor_rotation, this.useSensorRotation);
            }
            finally {
                object3.recycle();
            }
        } else {
            bl3 = true;
            bl2 = true;
            n3 = 0;
            bl = true;
            bl6 = false;
            n7 = 0;
            bl5 = true;
            n6 = 0;
            bl4 = true;
            n5 = 1;
            n4 = 0;
            n2 = 5000;
        }
        LayoutInflater.from((Context)object).inflate(n8, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        this.contentFrame = (AspectRatioFrameLayout)this.findViewById(R.id.exo_content_frame);
        object3 = this.contentFrame;
        if (object3 != null) {
            PlayerView.setResizeModeRaw((AspectRatioFrameLayout)((Object)object3), n4);
        }
        this.shutterView = this.findViewById(R.id.exo_shutter);
        object3 = this.shutterView;
        if (object3 != null && bl6) {
            object3.setBackgroundColor(n7);
        }
        if (this.contentFrame != null && n5 != 0) {
            object2 = new ViewGroup.LayoutParams(-1, -1);
            if (n5 != 2) {
                if (n5 != 3) {
                    this.surfaceView = n5 != 4 ? new SurfaceView((Context)object) : new VideoDecoderGLSurfaceView((Context)object);
                } else {
                    object3 = new SphericalGLSurfaceView((Context)object);
                    object3.setSingleTapListener((SingleTapListener)this.componentListener);
                    object3.setUseSensorRotation(this.useSensorRotation);
                    this.surfaceView = object3;
                }
            } else {
                this.surfaceView = new TextureView((Context)object);
            }
            this.surfaceView.setLayoutParams(object2);
            this.contentFrame.addView(this.surfaceView, 0);
        } else {
            this.surfaceView = null;
        }
        this.adOverlayFrameLayout = (FrameLayout)this.findViewById(R.id.exo_ad_overlay);
        this.overlayFrameLayout = (FrameLayout)this.findViewById(R.id.exo_overlay);
        this.artworkView = (ImageView)this.findViewById(R.id.exo_artwork);
        bl6 = bl5 && this.artworkView != null;
        this.useArtwork = bl6;
        if (n6 != 0) {
            this.defaultArtwork = ContextCompat.getDrawable((Context)this.getContext(), (int)n6);
        }
        this.subtitleView = (SubtitleView)this.findViewById(R.id.exo_subtitles);
        object3 = this.subtitleView;
        if (object3 != null) {
            object3.setUserDefaultStyle();
            this.subtitleView.setUserDefaultTextSize();
        }
        this.bufferingView = this.findViewById(R.id.exo_buffering);
        object3 = this.bufferingView;
        if (object3 != null) {
            object3.setVisibility(8);
        }
        this.showBuffering = n3;
        this.errorMessageView = (TextView)this.findViewById(R.id.exo_error_message);
        object3 = this.errorMessageView;
        if (object3 != null) {
            object3.setVisibility(8);
        }
        object2 = (PlayerControlView)this.findViewById(R.id.exo_controller);
        object3 = this.findViewById(R.id.exo_controller_placeholder);
        if (object2 != null) {
            this.controller = object2;
        } else if (object3 != null) {
            this.controller = new PlayerControlView((Context)object, null, 0, attributeSet);
            this.controller.setId(R.id.exo_controller);
            this.controller.setLayoutParams(object3.getLayoutParams());
            object = (ViewGroup)object3.getParent();
            n6 = object.indexOfChild((View)object3);
            object.removeView((View)object3);
            object.addView((View)this.controller, n6);
        } else {
            this.controller = null;
        }
        bl6 = false;
        if (this.controller == null) {
            n2 = 0;
        }
        this.controllerShowTimeoutMs = n2;
        this.controllerHideOnTouch = bl3;
        this.controllerAutoShow = bl2;
        this.controllerHideDuringAds = bl;
        bl = bl6;
        if (bl4) {
            bl = bl6;
            if (this.controller != null) {
                bl = true;
            }
        }
        this.useController = bl;
        this.hideController();
        this.updateContentDescription();
        object = this.controller;
        if (object != null) {
            ((PlayerControlView)((Object)object)).addVisibilityListener(this.componentListener);
        }
    }

    static /* synthetic */ int access$202(PlayerView playerView, int n2) {
        playerView.textureViewRotation = n2;
        return n2;
    }

    private static void applyTextureViewRotation(TextureView textureView, int n2) {
        Matrix matrix = new Matrix();
        float f2 = textureView.getWidth();
        float f3 = textureView.getHeight();
        if (f2 != 0.0f && f3 != 0.0f && n2 != 0) {
            float f4 = f2 / 2.0f;
            float f5 = f3 / 2.0f;
            matrix.postRotate((float)n2, f4, f5);
            RectF rectF = new RectF(0.0f, 0.0f, f2, f3);
            RectF rectF2 = new RectF();
            matrix.mapRect(rectF2, rectF);
            matrix.postScale(f2 / rectF2.width(), f3 / rectF2.height(), f4, f5);
        }
        textureView.setTransform(matrix);
    }

    private void closeShutter() {
        View view = this.shutterView;
        if (view != null) {
            view.setVisibility(0);
        }
    }

    private static void configureEditModeLogo(Resources resources, ImageView imageView) {
        imageView.setImageDrawable(resources.getDrawable(R.drawable.exo_edit_mode_logo));
        imageView.setBackgroundColor(resources.getColor(R.color.exo_edit_mode_background_color));
    }

    private static void configureEditModeLogoV23(Resources resources, ImageView imageView) {
        imageView.setImageDrawable(resources.getDrawable(R.drawable.exo_edit_mode_logo, null));
        imageView.setBackgroundColor(resources.getColor(R.color.exo_edit_mode_background_color, null));
    }

    private void hideArtwork() {
        ImageView imageView = this.artworkView;
        if (imageView != null) {
            imageView.setImageResource(17170445);
            this.artworkView.setVisibility(4);
        }
    }

    private boolean isDpadKey(int n2) {
        boolean bl = n2 == 19 || n2 == 270 || n2 == 22 || n2 == 271 || n2 == 20 || n2 == 269 || n2 == 21 || n2 == 268 || n2 == 23;
        return bl;
    }

    private boolean isPlayingAd() {
        Player player = this.player;
        boolean bl = player != null && player.isPlayingAd() && this.player.getPlayWhenReady();
        return bl;
    }

    private void maybeShowController(boolean bl) {
        if (this.isPlayingAd() && this.controllerHideDuringAds) {
            return;
        }
        if (this.useController()) {
            boolean bl2 = this.controller.isVisible() && this.controller.getShowTimeoutMs() <= 0;
            boolean bl3 = this.shouldShowControllerIndefinitely();
            if (bl || bl2 || bl3) {
                this.showController(bl3);
            }
        }
    }

    @RequiresNonNull(value={"artworkView"})
    private boolean setArtworkFromMetadata(Metadata metadata) {
        boolean bl;
        int n2 = 0;
        int n3 = -1;
        boolean bl2 = false;
        while (true) {
            int n4;
            block5: {
                int n5;
                Object object;
                block6: {
                    block4: {
                        Object object2;
                        block3: {
                            bl = bl2;
                            if (n2 >= metadata.length()) break;
                            object = metadata.get(n2);
                            if (!(object instanceof ApicFrame)) break block3;
                            object2 = (ApicFrame)object;
                            object = object2.pictureData;
                            n5 = object2.pictureType;
                            break block4;
                        }
                        n4 = n3;
                        bl = bl2;
                        if (!(object instanceof PictureFrame)) break block5;
                        object2 = (PictureFrame)object;
                        object = object2.pictureData;
                        n5 = object2.pictureType;
                    }
                    if (n3 == -1) break block6;
                    n4 = n3;
                    bl = bl2;
                    if (n5 != 3) break block5;
                }
                object = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((Metadata.Entry)object).length);
                bl = this.setDrawableArtwork((Drawable)new BitmapDrawable(this.getResources(), (Bitmap)object));
                if (n5 == 3) break;
                n4 = n5;
            }
            ++n2;
            n3 = n4;
            bl2 = bl;
        }
        return bl;
    }

    @RequiresNonNull(value={"artworkView"})
    private boolean setDrawableArtwork(Drawable drawable2) {
        if (drawable2 != null) {
            int n2 = drawable2.getIntrinsicWidth();
            int n3 = drawable2.getIntrinsicHeight();
            if (n2 > 0 && n3 > 0) {
                this.onContentAspectRatioChanged((float)n2 / (float)n3, this.contentFrame, (View)this.artworkView);
                this.artworkView.setImageDrawable(drawable2);
                this.artworkView.setVisibility(0);
                return true;
            }
        }
        return false;
    }

    private static void setResizeModeRaw(AspectRatioFrameLayout aspectRatioFrameLayout, int n2) {
        aspectRatioFrameLayout.setResizeMode(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldShowControllerIndefinitely() {
        Player player = this.player;
        boolean bl = true;
        if (player == null) {
            return true;
        }
        int n2 = player.getPlaybackState();
        if (!this.controllerAutoShow) return false;
        boolean bl2 = bl;
        if (n2 == 1) return bl2;
        bl2 = bl;
        if (n2 == 4) return bl2;
        if (this.player.getPlayWhenReady()) return false;
        return bl;
    }

    private void showController(boolean bl) {
        if (!this.useController()) {
            return;
        }
        PlayerControlView playerControlView = this.controller;
        int n2 = bl ? 0 : this.controllerShowTimeoutMs;
        playerControlView.setShowTimeoutMs(n2);
        this.controller.show();
    }

    public static void switchTargetView(Player player, PlayerView playerView, PlayerView playerView2) {
        if (playerView == playerView2) {
            return;
        }
        if (playerView2 != null) {
            playerView2.setPlayer(player);
        }
        if (playerView != null) {
            playerView.setPlayer(null);
        }
    }

    private boolean toggleControllerVisibility() {
        if (this.useController() && this.player != null) {
            if (!this.controller.isVisible()) {
                this.maybeShowController(true);
            } else if (this.controllerHideOnTouch) {
                this.controller.hide();
            }
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void updateBuffering() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateContentDescription() {
        PlayerControlView playerControlView = this.controller;
        String string2 = null;
        if (playerControlView != null && this.useController) {
            if (playerControlView.getVisibility() == 0) {
                if (this.controllerHideOnTouch) {
                    string2 = this.getResources().getString(R.string.exo_controls_hide);
                }
                this.setContentDescription(string2);
            } else {
                this.setContentDescription(this.getResources().getString(R.string.exo_controls_show));
            }
        } else {
            this.setContentDescription(null);
        }
    }

    private void updateControllerVisibility() {
        if (this.isPlayingAd() && this.controllerHideDuringAds) {
            this.hideController();
        } else {
            this.maybeShowController(false);
        }
    }

    private void updateErrorMessage() {
        ErrorMessageProvider<? super ExoPlaybackException> errorMessageProvider = this.errorMessageView;
        if (errorMessageProvider != null) {
            Object object = this.customErrorMessage;
            if (object != null) {
                errorMessageProvider.setText((CharSequence)object);
                this.errorMessageView.setVisibility(0);
                return;
            }
            object = this.player;
            object = object != null ? object.getPlayerError() : null;
            if (object != null && (errorMessageProvider = this.errorMessageProvider) != null) {
                object = (CharSequence)errorMessageProvider.getErrorMessage((Throwable)object).second;
                this.errorMessageView.setText((CharSequence)object);
                this.errorMessageView.setVisibility(0);
            } else {
                this.errorMessageView.setVisibility(8);
            }
        }
    }

    private void updateForCurrentTrackSelections(boolean bl) {
        Object object = this.player;
        if (object != null && !object.getCurrentTrackGroups().isEmpty()) {
            if (bl && !this.keepContentOnPlayerReset) {
                this.closeShutter();
            }
            TrackSelectionArray trackSelectionArray = object.getCurrentTrackSelections();
            for (int i2 = 0; i2 < trackSelectionArray.length; ++i2) {
                if (object.getRendererType(i2) != 2 || trackSelectionArray.get(i2) == null) continue;
                this.hideArtwork();
                return;
            }
            this.closeShutter();
            if (this.useArtwork()) {
                object = object.getCurrentStaticMetadata().iterator();
                while (object.hasNext()) {
                    if (!this.setArtworkFromMetadata((Metadata)object.next())) continue;
                    return;
                }
                if (this.setDrawableArtwork(this.defaultArtwork)) {
                    return;
                }
            }
            this.hideArtwork();
            return;
        }
        if (!this.keepContentOnPlayerReset) {
            this.hideArtwork();
            this.closeShutter();
        }
    }

    @EnsuresNonNullIf(expression={"artworkView"}, result=true)
    private boolean useArtwork() {
        if (this.useArtwork) {
            Assertions.checkStateNotNull(this.artworkView);
            return true;
        }
        return false;
    }

    @EnsuresNonNullIf(expression={"controller"}, result=true)
    private boolean useController() {
        if (this.useController) {
            Assertions.checkStateNotNull(this.controller);
            return true;
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Player player = this.player;
        if (player != null && player.isPlayingAd()) {
            return super.dispatchKeyEvent(keyEvent);
        }
        boolean bl = this.isDpadKey(keyEvent.getKeyCode());
        boolean bl2 = true;
        if (bl && this.useController() && !this.controller.isVisible()) {
            this.maybeShowController(true);
        } else if (!this.dispatchMediaKeyEvent(keyEvent) && !super.dispatchKeyEvent(keyEvent)) {
            if (bl && this.useController()) {
                this.maybeShowController(true);
            }
            bl2 = false;
        } else {
            this.maybeShowController(true);
        }
        return bl2;
    }

    public boolean dispatchMediaKeyEvent(KeyEvent keyEvent) {
        boolean bl = this.useController() && this.controller.dispatchMediaKeyEvent(keyEvent);
        return bl;
    }

    @Override
    public List<AdsLoader.OverlayInfo> getAdOverlayInfos() {
        ArrayList<AdsLoader.OverlayInfo> arrayList = new ArrayList<AdsLoader.OverlayInfo>();
        FrameLayout frameLayout = this.overlayFrameLayout;
        if (frameLayout != null) {
            arrayList.add(new AdsLoader.OverlayInfo((View)frameLayout, 3, "Transparent overlay does not impact viewability"));
        }
        if ((frameLayout = this.controller) != null) {
            arrayList.add(new AdsLoader.OverlayInfo((View)frameLayout, 0));
        }
        return ImmutableList.copyOf(arrayList);
    }

    @Override
    @Deprecated
    public /* synthetic */ View[] getAdOverlayViews() {
        return AdsLoader.AdViewProvider._CC.$default$getAdOverlayViews((AdsLoader.AdViewProvider)this);
    }

    @Override
    public ViewGroup getAdViewGroup() {
        return (ViewGroup)Assertions.checkStateNotNull(this.adOverlayFrameLayout, "exo_ad_overlay must be present for ad playback");
    }

    public boolean getControllerAutoShow() {
        return this.controllerAutoShow;
    }

    public boolean getControllerHideOnTouch() {
        return this.controllerHideOnTouch;
    }

    public int getControllerShowTimeoutMs() {
        return this.controllerShowTimeoutMs;
    }

    public Drawable getDefaultArtwork() {
        return this.defaultArtwork;
    }

    public FrameLayout getOverlayFrameLayout() {
        return this.overlayFrameLayout;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getResizeMode() {
        Assertions.checkStateNotNull(this.contentFrame);
        return this.contentFrame.getResizeMode();
    }

    public SubtitleView getSubtitleView() {
        return this.subtitleView;
    }

    public boolean getUseArtwork() {
        return this.useArtwork;
    }

    public boolean getUseController() {
        return this.useController;
    }

    public View getVideoSurfaceView() {
        return this.surfaceView;
    }

    public void hideController() {
        PlayerControlView playerControlView = this.controller;
        if (playerControlView != null) {
            playerControlView.hide();
        }
    }

    public boolean isControllerVisible() {
        PlayerControlView playerControlView = this.controller;
        boolean bl = playerControlView != null && playerControlView.isVisible();
        return bl;
    }

    protected void onContentAspectRatioChanged(float f2, AspectRatioFrameLayout aspectRatioFrameLayout, View view) {
        if (aspectRatioFrameLayout != null) {
            if (view instanceof SphericalGLSurfaceView) {
                f2 = 0.0f;
            }
            aspectRatioFrameLayout.setAspectRatio(f2);
        }
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public void onPause() {
        View view = this.surfaceView;
        if (view instanceof SphericalGLSurfaceView) {
            ((SphericalGLSurfaceView)view).onPause();
        }
    }

    public void onResume() {
        View view = this.surfaceView;
        if (view instanceof SphericalGLSurfaceView) {
            ((SphericalGLSurfaceView)view).onResume();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.useController() && this.player != null) {
            int n2 = motionEvent.getAction();
            if (n2 != 0) {
                if (n2 != 1) {
                    return false;
                }
                if (this.isTouching) {
                    this.isTouching = false;
                    this.performClick();
                    return true;
                }
                return false;
            }
            this.isTouching = true;
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (this.useController() && this.player != null) {
            this.maybeShowController(true);
            return true;
        }
        return false;
    }

    public boolean performClick() {
        super.performClick();
        return this.toggleControllerVisibility();
    }

    public void setAspectRatioListener(AspectRatioFrameLayout.AspectRatioListener aspectRatioListener) {
        Assertions.checkStateNotNull(this.contentFrame);
        this.contentFrame.setAspectRatioListener(aspectRatioListener);
    }

    public void setControlDispatcher(ControlDispatcher controlDispatcher) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setControlDispatcher(controlDispatcher);
    }

    public void setControllerAutoShow(boolean bl) {
        this.controllerAutoShow = bl;
    }

    public void setControllerHideDuringAds(boolean bl) {
        this.controllerHideDuringAds = bl;
    }

    public void setControllerHideOnTouch(boolean bl) {
        Assertions.checkStateNotNull(this.controller);
        this.controllerHideOnTouch = bl;
        this.updateContentDescription();
    }

    public void setControllerShowTimeoutMs(int n2) {
        Assertions.checkStateNotNull(this.controller);
        this.controllerShowTimeoutMs = n2;
        if (this.controller.isVisible()) {
            this.showController();
        }
    }

    public void setControllerVisibilityListener(PlayerControlView.VisibilityListener visibilityListener) {
        Assertions.checkStateNotNull(this.controller);
        PlayerControlView.VisibilityListener visibilityListener2 = this.controllerVisibilityListener;
        if (visibilityListener2 == visibilityListener) {
            return;
        }
        if (visibilityListener2 != null) {
            this.controller.removeVisibilityListener(visibilityListener2);
        }
        this.controllerVisibilityListener = visibilityListener;
        if (visibilityListener != null) {
            this.controller.addVisibilityListener(visibilityListener);
        }
    }

    public void setCustomErrorMessage(CharSequence charSequence) {
        boolean bl = this.errorMessageView != null;
        Assertions.checkState(bl);
        this.customErrorMessage = charSequence;
        this.updateErrorMessage();
    }

    public void setDefaultArtwork(Drawable drawable2) {
        if (this.defaultArtwork != drawable2) {
            this.defaultArtwork = drawable2;
            this.updateForCurrentTrackSelections(false);
        }
    }

    public void setErrorMessageProvider(ErrorMessageProvider<? super ExoPlaybackException> errorMessageProvider) {
        if (this.errorMessageProvider != errorMessageProvider) {
            this.errorMessageProvider = errorMessageProvider;
            this.updateErrorMessage();
        }
    }

    public void setExtraAdGroupMarkers(long[] lArray, boolean[] blArray) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setExtraAdGroupMarkers(lArray, blArray);
    }

    @Deprecated
    public void setFastForwardIncrementMs(int n2) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setFastForwardIncrementMs(n2);
    }

    public void setKeepContentOnPlayerReset(boolean bl) {
        if (this.keepContentOnPlayerReset != bl) {
            this.keepContentOnPlayerReset = bl;
            this.updateForCurrentTrackSelections(false);
        }
    }

    @Deprecated
    public void setPlaybackPreparer(PlaybackPreparer playbackPreparer) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setPlaybackPreparer(playbackPreparer);
    }

    public void setPlayer(Player player) {
        Object object;
        boolean bl = Looper.myLooper() == Looper.getMainLooper();
        Assertions.checkState(bl);
        bl = player == null || player.getApplicationLooper() == Looper.getMainLooper();
        Assertions.checkArgument(bl);
        Object object2 = this.player;
        if (object2 == player) {
            return;
        }
        if (object2 != null) {
            object2.removeListener(this.componentListener);
            Player.VideoComponent videoComponent = object2.getVideoComponent();
            if (videoComponent != null) {
                videoComponent.removeVideoListener(this.componentListener);
                object = this.surfaceView;
                if (object instanceof TextureView) {
                    videoComponent.clearVideoTextureView((TextureView)object);
                } else if (object instanceof SphericalGLSurfaceView) {
                    ((SphericalGLSurfaceView)object).setVideoComponent(null);
                } else if (object instanceof SurfaceView) {
                    videoComponent.clearVideoSurfaceView((SurfaceView)object);
                }
            }
            if ((object = object2.getTextComponent()) != null) {
                object.removeTextOutput(this.componentListener);
            }
        }
        if ((object = this.subtitleView) != null) {
            ((SubtitleView)((Object)object)).setCues(null);
        }
        this.player = player;
        if (this.useController()) {
            this.controller.setPlayer(player);
        }
        this.updateBuffering();
        this.updateErrorMessage();
        this.updateForCurrentTrackSelections(true);
        if (player != null) {
            object2 = player.getVideoComponent();
            if (object2 != null) {
                object = this.surfaceView;
                if (object instanceof TextureView) {
                    object2.setVideoTextureView((TextureView)object);
                } else if (object instanceof SphericalGLSurfaceView) {
                    ((SphericalGLSurfaceView)object).setVideoComponent((Player.VideoComponent)object2);
                } else if (object instanceof SurfaceView) {
                    object2.setVideoSurfaceView((SurfaceView)object);
                }
                object2.addVideoListener(this.componentListener);
            }
            if ((object2 = player.getTextComponent()) != null) {
                object2.addTextOutput(this.componentListener);
                object = this.subtitleView;
                if (object != null) {
                    ((SubtitleView)((Object)object)).setCues(object2.getCurrentCues());
                }
            }
            player.addListener(this.componentListener);
            this.maybeShowController(false);
        } else {
            this.hideController();
        }
    }

    public void setRepeatToggleModes(int n2) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setRepeatToggleModes(n2);
    }

    public void setResizeMode(int n2) {
        Assertions.checkStateNotNull(this.contentFrame);
        this.contentFrame.setResizeMode(n2);
    }

    @Deprecated
    public void setRewindIncrementMs(int n2) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setRewindIncrementMs(n2);
    }

    public void setShowBuffering(int n2) {
        if (this.showBuffering != n2) {
            this.showBuffering = n2;
            this.updateBuffering();
        }
    }

    public void setShowFastForwardButton(boolean bl) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setShowFastForwardButton(bl);
    }

    public void setShowMultiWindowTimeBar(boolean bl) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setShowMultiWindowTimeBar(bl);
    }

    public void setShowNextButton(boolean bl) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setShowNextButton(bl);
    }

    public void setShowPreviousButton(boolean bl) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setShowPreviousButton(bl);
    }

    public void setShowRewindButton(boolean bl) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setShowRewindButton(bl);
    }

    public void setShowShuffleButton(boolean bl) {
        Assertions.checkStateNotNull(this.controller);
        this.controller.setShowShuffleButton(bl);
    }

    public void setShutterBackgroundColor(int n2) {
        View view = this.shutterView;
        if (view != null) {
            view.setBackgroundColor(n2);
        }
    }

    public void setUseArtwork(boolean bl) {
        boolean bl2 = !bl || this.artworkView != null;
        Assertions.checkState(bl2);
        if (this.useArtwork != bl) {
            this.useArtwork = bl;
            this.updateForCurrentTrackSelections(false);
        }
    }

    public void setUseController(boolean bl) {
        boolean bl2 = !bl || this.controller != null;
        Assertions.checkState(bl2);
        if (this.useController == bl) {
            return;
        }
        this.useController = bl;
        if (this.useController()) {
            this.controller.setPlayer(this.player);
        } else {
            PlayerControlView playerControlView = this.controller;
            if (playerControlView != null) {
                playerControlView.hide();
                this.controller.setPlayer(null);
            }
        }
        this.updateContentDescription();
    }

    public void setUseSensorRotation(boolean bl) {
        if (this.useSensorRotation != bl) {
            this.useSensorRotation = bl;
            View view = this.surfaceView;
            if (view instanceof SphericalGLSurfaceView) {
                ((SphericalGLSurfaceView)view).setUseSensorRotation(bl);
            }
        }
    }

    public void setVisibility(int n2) {
        super.setVisibility(n2);
        View view = this.surfaceView;
        if (view instanceof SurfaceView) {
            view.setVisibility(n2);
        }
    }

    public void showController() {
        this.showController(this.shouldShowControllerIndefinitely());
    }

    private final class ComponentListener
    implements Player.EventListener,
    TextOutput,
    VideoListener,
    View.OnLayoutChangeListener,
    SingleTapListener,
    PlayerControlView.VisibilityListener {
        private Object lastPeriodUidWithTracks;
        private final Timeline.Period period = new Timeline.Period();

        public void onCues(List<Cue> list) {
            if (PlayerView.this.subtitleView != null) {
                PlayerView.this.subtitleView.onCues(list);
            }
        }

        @Override
        public /* synthetic */ void onEvents(Player player, Player.Events events) {
            Player.EventListener._CC.$default$onEvents((Player.EventListener)this, (Player)player, (Player.Events)events);
        }

        @Override
        public /* synthetic */ void onExperimentalOffloadSchedulingEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalOffloadSchedulingEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onExperimentalSleepingForOffloadChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalSleepingForOffloadChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsPlayingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsPlayingChanged((Player.EventListener)this, (boolean)bl);
        }

        public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            PlayerView.applyTextureViewRotation((TextureView)view, PlayerView.this.textureViewRotation);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onMediaItemTransition(MediaItem mediaItem, int n2) {
            Player.EventListener._CC.$default$onMediaItemTransition((Player.EventListener)this, (MediaItem)mediaItem, (int)n2);
        }

        @Override
        public void onPlayWhenReadyChanged(boolean bl, int n2) {
            PlayerView.this.updateBuffering();
            PlayerView.this.updateControllerVisibility();
        }

        @Override
        public /* synthetic */ void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            Player.EventListener._CC.$default$onPlaybackParametersChanged((Player.EventListener)this, (PlaybackParameters)playbackParameters);
        }

        @Override
        public void onPlaybackStateChanged(int n2) {
            PlayerView.this.updateBuffering();
            PlayerView.this.updateErrorMessage();
            PlayerView.this.updateControllerVisibility();
        }

        @Override
        public /* synthetic */ void onPlaybackSuppressionReasonChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackSuppressionReasonChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayerError(ExoPlaybackException exoPlaybackException) {
            Player.EventListener._CC.$default$onPlayerError((Player.EventListener)this, (ExoPlaybackException)exoPlaybackException);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onPlayerStateChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayerStateChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public void onPositionDiscontinuity(int n2) {
            if (PlayerView.this.isPlayingAd() && PlayerView.this.controllerHideDuringAds) {
                PlayerView.this.hideController();
            }
        }

        public void onRenderedFirstFrame() {
            if (PlayerView.this.shutterView != null) {
                PlayerView.this.shutterView.setVisibility(4);
            }
        }

        @Override
        public /* synthetic */ void onRepeatModeChanged(int n2) {
            Player.EventListener._CC.$default$onRepeatModeChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onSeekProcessed() {
            Player.EventListener._CC.$default$onSeekProcessed((Player.EventListener)this);
        }

        @Override
        public /* synthetic */ void onShuffleModeEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onShuffleModeEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return PlayerView.this.toggleControllerVisibility();
        }

        @Override
        public /* synthetic */ void onStaticMetadataChanged(List<Metadata> list) {
            Player.EventListener._CC.$default$onStaticMetadataChanged((Player.EventListener)this, list);
        }

        public /* synthetic */ void onSurfaceSizeChanged(int n2, int n3) {
            VideoListener._CC.$default$onSurfaceSizeChanged((VideoListener)this, (int)n2, (int)n3);
        }

        @Override
        public /* synthetic */ void onTimelineChanged(Timeline timeline, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onTimelineChanged(Timeline timeline, Object object, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (Object)object, (int)n2);
        }

        @Override
        public void onTracksChanged(TrackGroupArray trackGroupArray, TrackSelectionArray object) {
            Player player = Assertions.checkNotNull(PlayerView.this.player);
            trackGroupArray = player.getCurrentTimeline();
            if (trackGroupArray.isEmpty()) {
                this.lastPeriodUidWithTracks = null;
            } else if (!player.getCurrentTrackGroups().isEmpty()) {
                this.lastPeriodUidWithTracks = trackGroupArray.getPeriod((int)player.getCurrentPeriodIndex(), (Timeline.Period)this.period, (boolean)true).uid;
            } else {
                object = this.lastPeriodUidWithTracks;
                if (object != null) {
                    int n2 = trackGroupArray.getIndexOfPeriod(object);
                    if (n2 != -1) {
                        n2 = trackGroupArray.getPeriod((int)n2, (Timeline.Period)this.period).windowIndex;
                        if (player.getCurrentWindowIndex() == n2) {
                            return;
                        }
                    }
                    this.lastPeriodUidWithTracks = null;
                }
            }
            PlayerView.this.updateForCurrentTrackSelections(false);
        }

        public void onVideoSizeChanged(int n2, int n3, int n4, float f2) {
            float f3;
            block5: {
                block7: {
                    block6: {
                        f2 = n3 != 0 && n2 != 0 ? (float)n2 * f2 / (float)n3 : 1.0f;
                        f3 = f2;
                        if (!(PlayerView.this.surfaceView instanceof TextureView)) break block5;
                        if (n4 == 90) break block6;
                        f3 = f2;
                        if (n4 != 270) break block7;
                    }
                    f3 = 1.0f / f2;
                }
                if (PlayerView.this.textureViewRotation != 0) {
                    PlayerView.this.surfaceView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                }
                PlayerView.access$202(PlayerView.this, n4);
                if (PlayerView.this.textureViewRotation != 0) {
                    PlayerView.this.surfaceView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                }
                PlayerView.applyTextureViewRotation((TextureView)PlayerView.this.surfaceView, PlayerView.this.textureViewRotation);
            }
            PlayerView playerView = PlayerView.this;
            playerView.onContentAspectRatioChanged(f3, playerView.contentFrame, PlayerView.this.surfaceView);
        }

        @Override
        public void onVisibilityChange(int n2) {
            PlayerView.this.updateContentDescription();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowBuffering {
    }
}

