/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.media.app.NotificationCompat;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui._$;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PlayerNotificationManager {
    private static final String ACTION_DISMISS = "com.google.android.exoplayer.dismiss";
    public static final String ACTION_FAST_FORWARD = "com.google.android.exoplayer.ffwd";
    public static final String ACTION_NEXT = "com.google.android.exoplayer.next";
    public static final String ACTION_PAUSE = "com.google.android.exoplayer.pause";
    public static final String ACTION_PLAY = "com.google.android.exoplayer.play";
    public static final String ACTION_PREVIOUS = "com.google.android.exoplayer.prev";
    public static final String ACTION_REWIND = "com.google.android.exoplayer.rewind";
    public static final String ACTION_STOP = "com.google.android.exoplayer.stop";
    public static final String EXTRA_INSTANCE_ID = "INSTANCE_ID";
    private static final int MSG_START_OR_UPDATE_NOTIFICATION = 0;
    private static final int MSG_UPDATE_NOTIFICATION_BITMAP = 1;
    private static int instanceIdCounter;
    private int badgeIconType;
    private NotificationCompat.Builder builder;
    private List<NotificationCompat.Action> builderActions;
    private final String channelId;
    private int color;
    private boolean colorized;
    private final Context context;
    private ControlDispatcher controlDispatcher;
    private int currentNotificationTag;
    private final CustomActionReceiver customActionReceiver;
    private final Map<String, NotificationCompat.Action> customActions;
    private int defaults;
    private final PendingIntent dismissPendingIntent;
    private final int instanceId;
    private final IntentFilter intentFilter;
    private boolean isNotificationStarted;
    private final Handler mainHandler;
    private final MediaDescriptionAdapter mediaDescriptionAdapter;
    private MediaSessionCompat.Token mediaSessionToken;
    private final NotificationBroadcastReceiver notificationBroadcastReceiver;
    private final int notificationId;
    private NotificationListener notificationListener;
    private final NotificationManagerCompat notificationManager;
    private final Map<String, NotificationCompat.Action> playbackActions;
    private PlaybackPreparer playbackPreparer;
    private Player player;
    private final Player.EventListener playerListener;
    private int priority;
    private int smallIconResourceId;
    private boolean useChronometer;
    private boolean useNextAction;
    private boolean useNextActionInCompactView;
    private boolean usePlayPauseActions;
    private boolean usePreviousAction;
    private boolean usePreviousActionInCompactView;
    private boolean useStopAction;
    private int visibility;
    private final Timeline.Window window;

    public PlayerNotificationManager(Context context, String string2, int n2, MediaDescriptionAdapter mediaDescriptionAdapter) {
        this(context, string2, n2, mediaDescriptionAdapter, null, null);
    }

    public PlayerNotificationManager(Context context, String string2, int n2, MediaDescriptionAdapter mediaDescriptionAdapter, CustomActionReceiver customActionReceiver) {
        this(context, string2, n2, mediaDescriptionAdapter, null, customActionReceiver);
    }

    public PlayerNotificationManager(Context context, String string2, int n2, MediaDescriptionAdapter mediaDescriptionAdapter, NotificationListener notificationListener) {
        this(context, string2, n2, mediaDescriptionAdapter, notificationListener, null);
    }

    /*
     * WARNING - void declaration
     */
    public PlayerNotificationManager(Context object3, String object22, int n2, MediaDescriptionAdapter mediaDescriptionAdapter, NotificationListener notificationListener, CustomActionReceiver customActionReceiver) {
        void var1_5;
        void var6_15;
        void var5_14;
        void var4_13;
        int n3;
        void var2_8;
        Context context;
        this.context = context = object3.getApplicationContext();
        this.channelId = var2_8;
        this.notificationId = n3;
        this.mediaDescriptionAdapter = var4_13;
        this.notificationListener = var5_14;
        this.customActionReceiver = var6_15;
        this.controlDispatcher = new DefaultControlDispatcher();
        this.window = new Timeline.Window();
        n3 = instanceIdCounter;
        instanceIdCounter = n3 + 1;
        this.instanceId = n3;
        this.mainHandler = Util.createHandler(Looper.getMainLooper(), (Handler.Callback)new _$.Lambda.PlayerNotificationManager.ZG0s_7uOzb_YtyUlp8ahx3j4wBg(this));
        this.notificationManager = NotificationManagerCompat.from((Context)context);
        this.playerListener = new PlayerListener();
        this.notificationBroadcastReceiver = new NotificationBroadcastReceiver();
        this.intentFilter = new IntentFilter();
        this.usePreviousAction = true;
        this.useNextAction = true;
        this.usePlayPauseActions = true;
        this.colorized = true;
        this.useChronometer = true;
        this.color = 0;
        this.smallIconResourceId = R.drawable.exo_notification_small_icon;
        this.defaults = 0;
        this.priority = -1;
        this.badgeIconType = 1;
        this.visibility = 1;
        this.playbackActions = PlayerNotificationManager.createPlaybackActions(context, this.instanceId);
        for (String string2 : this.playbackActions.keySet()) {
            this.intentFilter.addAction(string2);
        }
        if (var6_15 != null) {
            Map<String, NotificationCompat.Action> map = var6_15.createCustomActions(context, this.instanceId);
        } else {
            Map map = Collections.emptyMap();
        }
        this.customActions = var1_5;
        for (String string3 : this.customActions.keySet()) {
            this.intentFilter.addAction(string3);
        }
        this.dismissPendingIntent = PlayerNotificationManager.createBroadcastIntent(ACTION_DISMISS, context, this.instanceId);
        this.intentFilter.addAction(ACTION_DISMISS);
    }

    private static PendingIntent createBroadcastIntent(String string2, Context context, int n2) {
        string2 = new Intent(string2).setPackage(context.getPackageName());
        string2.putExtra(EXTRA_INSTANCE_ID, n2);
        return PendingIntent.getBroadcast((Context)context, (int)n2, (Intent)string2, (int)0x8000000);
    }

    private static Map<String, NotificationCompat.Action> createPlaybackActions(Context context, int n2) {
        HashMap<String, NotificationCompat.Action> hashMap = new HashMap<String, NotificationCompat.Action>();
        hashMap.put(ACTION_PLAY, new NotificationCompat.Action(R.drawable.exo_notification_play, (CharSequence)context.getString(R.string.exo_controls_play_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PLAY, context, n2)));
        hashMap.put(ACTION_PAUSE, new NotificationCompat.Action(R.drawable.exo_notification_pause, (CharSequence)context.getString(R.string.exo_controls_pause_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PAUSE, context, n2)));
        hashMap.put(ACTION_STOP, new NotificationCompat.Action(R.drawable.exo_notification_stop, (CharSequence)context.getString(R.string.exo_controls_stop_description), PlayerNotificationManager.createBroadcastIntent(ACTION_STOP, context, n2)));
        hashMap.put(ACTION_REWIND, new NotificationCompat.Action(R.drawable.exo_notification_rewind, (CharSequence)context.getString(R.string.exo_controls_rewind_description), PlayerNotificationManager.createBroadcastIntent(ACTION_REWIND, context, n2)));
        hashMap.put(ACTION_FAST_FORWARD, new NotificationCompat.Action(R.drawable.exo_notification_fastforward, (CharSequence)context.getString(R.string.exo_controls_fastforward_description), PlayerNotificationManager.createBroadcastIntent(ACTION_FAST_FORWARD, context, n2)));
        hashMap.put(ACTION_PREVIOUS, new NotificationCompat.Action(R.drawable.exo_notification_previous, (CharSequence)context.getString(R.string.exo_controls_previous_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PREVIOUS, context, n2)));
        hashMap.put(ACTION_NEXT, new NotificationCompat.Action(R.drawable.exo_notification_next, (CharSequence)context.getString(R.string.exo_controls_next_description), PlayerNotificationManager.createBroadcastIntent(ACTION_NEXT, context, n2)));
        return hashMap;
    }

    public static PlayerNotificationManager createWithNotificationChannel(Context context, String string2, int n2, int n3, int n4, MediaDescriptionAdapter mediaDescriptionAdapter) {
        NotificationUtil.createNotificationChannel(context, string2, n2, n3, 2);
        return new PlayerNotificationManager(context, string2, n4, mediaDescriptionAdapter);
    }

    public static PlayerNotificationManager createWithNotificationChannel(Context context, String string2, int n2, int n3, int n4, MediaDescriptionAdapter mediaDescriptionAdapter, NotificationListener notificationListener) {
        NotificationUtil.createNotificationChannel(context, string2, n2, n3, 2);
        return new PlayerNotificationManager(context, string2, n4, mediaDescriptionAdapter, notificationListener);
    }

    @Deprecated
    public static PlayerNotificationManager createWithNotificationChannel(Context context, String string2, int n2, int n3, MediaDescriptionAdapter mediaDescriptionAdapter) {
        return PlayerNotificationManager.createWithNotificationChannel(context, string2, n2, 0, n3, mediaDescriptionAdapter);
    }

    @Deprecated
    public static PlayerNotificationManager createWithNotificationChannel(Context context, String string2, int n2, int n3, MediaDescriptionAdapter mediaDescriptionAdapter, NotificationListener notificationListener) {
        return PlayerNotificationManager.createWithNotificationChannel(context, string2, n2, 0, n3, mediaDescriptionAdapter, notificationListener);
    }

    private boolean handleMessage(Message object) {
        int n2 = object.what;
        if (n2 != 0) {
            if (n2 != 1) {
                return false;
            }
            if (this.player != null && this.isNotificationStarted && this.currentNotificationTag == object.arg1) {
                this.startOrUpdateNotification(this.player, (Bitmap)object.obj);
            }
        } else {
            object = this.player;
            if (object != null) {
                this.startOrUpdateNotification((Player)object, null);
            }
        }
        return true;
    }

    public static /* synthetic */ boolean lambda$ZG0s-7uOzb-YtyUlp8ahx3j4wBg(PlayerNotificationManager playerNotificationManager, Message message) {
        return playerNotificationManager.handleMessage(message);
    }

    private void postStartOrUpdateNotification() {
        if (!this.mainHandler.hasMessages(0)) {
            this.mainHandler.sendEmptyMessage(0);
        }
    }

    private void postUpdateNotificationBitmap(Bitmap bitmap, int n2) {
        this.mainHandler.obtainMessage(1, n2, -1, (Object)bitmap).sendToTarget();
    }

    private static void setLargeIcon(NotificationCompat.Builder builder, Bitmap bitmap) {
        builder.setLargeIcon(bitmap);
    }

    private boolean shouldShowPauseButton(Player player) {
        int n2 = player.getPlaybackState();
        boolean bl = true;
        if (n2 == 4 || player.getPlaybackState() == 1 || !player.getPlayWhenReady()) {
            bl = false;
        }
        return bl;
    }

    private void startOrUpdateNotification(Player object, Bitmap object2) {
        boolean bl = this.getOngoing((Player)object);
        this.builder = this.createNotification((Player)object, this.builder, bl, (Bitmap)object2);
        object = this.builder;
        boolean bl2 = false;
        if (object == null) {
            this.stopNotification(false);
            return;
        }
        object = ((NotificationCompat.Builder)object).build();
        this.notificationManager.notify(this.notificationId, (Notification)object);
        if (!this.isNotificationStarted) {
            this.context.registerReceiver((BroadcastReceiver)this.notificationBroadcastReceiver, this.intentFilter);
            object2 = this.notificationListener;
            if (object2 != null) {
                object2.onNotificationStarted(this.notificationId, (Notification)object);
            }
        }
        if ((object2 = this.notificationListener) != null) {
            int n2 = this.notificationId;
            if (bl || !this.isNotificationStarted) {
                bl2 = true;
            }
            object2.onNotificationPosted(n2, (Notification)object, bl2);
        }
        this.isNotificationStarted = true;
    }

    private void stopNotification(boolean bl) {
        if (this.isNotificationStarted) {
            this.isNotificationStarted = false;
            this.mainHandler.removeMessages(0);
            this.notificationManager.cancel(this.notificationId);
            this.context.unregisterReceiver((BroadcastReceiver)this.notificationBroadcastReceiver);
            NotificationListener notificationListener = this.notificationListener;
            if (notificationListener != null) {
                notificationListener.onNotificationCancelled(this.notificationId, bl);
                this.notificationListener.onNotificationCancelled(this.notificationId);
            }
        }
    }

    protected NotificationCompat.Builder createNotification(Player player, NotificationCompat.Builder object, boolean bl, Bitmap object2) {
        Object object3;
        int n2;
        if (player.getPlaybackState() == 1 && player.getCurrentTimeline().isEmpty()) {
            this.builderActions = null;
            return null;
        }
        List<String> list = this.getActions(player);
        NotificationCompat.MediaStyle mediaStyle = new ArrayList(list.size());
        for (n2 = 0; n2 < list.size(); ++n2) {
            object3 = list.get(n2);
            object3 = this.playbackActions.containsKey(object3) ? this.playbackActions.get(object3) : this.customActions.get(object3);
            if (object3 == null) continue;
            mediaStyle.add(object3);
        }
        if (object == null || !mediaStyle.equals(this.builderActions)) {
            object3 = new NotificationCompat.Builder(this.context, this.channelId);
            this.builderActions = mediaStyle;
            n2 = 0;
            while (true) {
                object = object3;
                if (n2 >= mediaStyle.size()) break;
                ((NotificationCompat.Builder)object3).addAction((NotificationCompat.Action)mediaStyle.get(n2));
                ++n2;
            }
        }
        mediaStyle = new NotificationCompat.MediaStyle();
        object3 = this.mediaSessionToken;
        if (object3 != null) {
            mediaStyle.setMediaSession((MediaSessionCompat.Token)object3);
        }
        mediaStyle.setShowActionsInCompactView(this.getActionIndicesForCompactView(list, player));
        mediaStyle.setShowCancelButton(bl ^ true);
        mediaStyle.setCancelButtonIntent(this.dismissPendingIntent);
        ((NotificationCompat.Builder)object).setStyle((NotificationCompat.Style)mediaStyle);
        ((NotificationCompat.Builder)object).setDeleteIntent(this.dismissPendingIntent);
        ((NotificationCompat.Builder)object).setBadgeIconType(this.badgeIconType).setOngoing(bl).setColor(this.color).setColorized(this.colorized).setSmallIcon(this.smallIconResourceId).setVisibility(this.visibility).setPriority(this.priority).setDefaults(this.defaults);
        if (Util.SDK_INT >= 21 && this.useChronometer && player.isPlaying() && !player.isPlayingAd() && !player.isCurrentWindowDynamic() && player.getPlaybackParameters().speed == 1.0f) {
            ((NotificationCompat.Builder)object).setWhen(System.currentTimeMillis() - player.getContentPosition()).setShowWhen(true).setUsesChronometer(true);
        } else {
            ((NotificationCompat.Builder)object).setShowWhen(false).setUsesChronometer(false);
        }
        ((NotificationCompat.Builder)object).setContentTitle(this.mediaDescriptionAdapter.getCurrentContentTitle(player));
        ((NotificationCompat.Builder)object).setContentText(this.mediaDescriptionAdapter.getCurrentContentText(player));
        ((NotificationCompat.Builder)object).setSubText(this.mediaDescriptionAdapter.getCurrentSubText(player));
        object3 = object2;
        if (object2 == null) {
            object2 = this.mediaDescriptionAdapter;
            this.currentNotificationTag = n2 = this.currentNotificationTag + 1;
            object3 = object2.getCurrentLargeIcon(player, new BitmapCallback(n2));
        }
        PlayerNotificationManager.setLargeIcon((NotificationCompat.Builder)object, (Bitmap)object3);
        ((NotificationCompat.Builder)object).setContentIntent(this.mediaDescriptionAdapter.createCurrentContentIntent(player));
        return object;
    }

    protected int[] getActionIndicesForCompactView(List<String> object, Player player) {
        int n2 = object.indexOf(ACTION_PAUSE);
        int n3 = object.indexOf(ACTION_PLAY);
        int n4 = this.usePreviousActionInCompactView ? object.indexOf(ACTION_PREVIOUS) : -1;
        int n5 = this.useNextActionInCompactView ? object.indexOf(ACTION_NEXT) : -1;
        object = new int[3];
        int n6 = 0;
        if (n4 != -1) {
            object[0] = n4;
            n6 = 1;
        }
        boolean bl = this.shouldShowPauseButton(player);
        if (n2 != -1 && bl) {
            n4 = n6 + 1;
            object[n6] = n2;
            n6 = n4;
        } else if (n3 != -1 && !bl) {
            n4 = n6 + 1;
            object[n6] = n3;
            n6 = n4;
        }
        n4 = n6;
        if (n5 != -1) {
            object[n6] = n5;
            n4 = n6 + 1;
        }
        return Arrays.copyOf((int[])object, n4);
    }

    protected List<String> getActions(Player player) {
        CustomActionReceiver customActionReceiver;
        boolean bl;
        boolean bl2;
        Object object = player.getCurrentTimeline();
        boolean bl3 = object.isEmpty();
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3 && !player.isPlayingAd()) {
            object.getWindow(player.getCurrentWindowIndex(), this.window);
            bl3 = this.window.isSeekable;
            bl4 = bl3 || !this.window.isLive() || player.hasPrevious();
            bl2 = bl3 && this.controlDispatcher.isRewindEnabled();
            bl = bl3 && this.controlDispatcher.isFastForwardEnabled();
            if (this.window.isLive() && this.window.isDynamic || player.hasNext()) {
                bl5 = true;
            }
            boolean bl6 = bl5;
            bl5 = bl;
            bl = bl6;
        } else {
            bl5 = false;
            bl = false;
            bl2 = false;
        }
        object = new ArrayList();
        if (this.usePreviousAction && bl4) {
            object.add(ACTION_PREVIOUS);
        }
        if (bl2) {
            object.add(ACTION_REWIND);
        }
        if (this.usePlayPauseActions) {
            if (this.shouldShowPauseButton(player)) {
                object.add(ACTION_PAUSE);
            } else {
                object.add(ACTION_PLAY);
            }
        }
        if (bl5) {
            object.add(ACTION_FAST_FORWARD);
        }
        if (this.useNextAction && bl) {
            object.add(ACTION_NEXT);
        }
        if ((customActionReceiver = this.customActionReceiver) != null) {
            object.addAll(customActionReceiver.getCustomActions(player));
        }
        if (this.useStopAction) {
            object.add(ACTION_STOP);
        }
        return object;
    }

    protected boolean getOngoing(Player player) {
        int n2 = player.getPlaybackState();
        boolean bl = (n2 == 2 || n2 == 3) && player.getPlayWhenReady();
        return bl;
    }

    public void invalidate() {
        if (this.isNotificationStarted) {
            this.postStartOrUpdateNotification();
        }
    }

    public final void setBadgeIconType(int n2) {
        if (this.badgeIconType == n2) {
            return;
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException();
        }
        this.badgeIconType = n2;
        this.invalidate();
    }

    public final void setColor(int n2) {
        if (this.color != n2) {
            this.color = n2;
            this.invalidate();
        }
    }

    public final void setColorized(boolean bl) {
        if (this.colorized != bl) {
            this.colorized = bl;
            this.invalidate();
        }
    }

    public final void setControlDispatcher(ControlDispatcher controlDispatcher) {
        if (this.controlDispatcher != controlDispatcher) {
            this.controlDispatcher = controlDispatcher;
            this.invalidate();
        }
    }

    public final void setDefaults(int n2) {
        if (this.defaults != n2) {
            this.defaults = n2;
            this.invalidate();
        }
    }

    @Deprecated
    public final void setFastForwardIncrementMs(long l2) {
        ControlDispatcher controlDispatcher = this.controlDispatcher;
        if (controlDispatcher instanceof DefaultControlDispatcher) {
            ((DefaultControlDispatcher)controlDispatcher).setFastForwardIncrementMs(l2);
            this.invalidate();
        }
    }

    public final void setMediaSessionToken(MediaSessionCompat.Token token) {
        if (!Util.areEqual(this.mediaSessionToken, token)) {
            this.mediaSessionToken = token;
            this.invalidate();
        }
    }

    @Deprecated
    public final void setNotificationListener(NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    @Deprecated
    public void setPlaybackPreparer(PlaybackPreparer playbackPreparer) {
        this.playbackPreparer = playbackPreparer;
    }

    public final void setPlayer(Player player) {
        Object object = Looper.myLooper();
        Looper looper = Looper.getMainLooper();
        boolean bl = true;
        boolean bl2 = object == looper;
        Assertions.checkState(bl2);
        bl2 = bl;
        if (player != null) {
            bl2 = player.getApplicationLooper() == Looper.getMainLooper() ? bl : false;
        }
        Assertions.checkArgument(bl2);
        object = this.player;
        if (object == player) {
            return;
        }
        if (object != null) {
            object.removeListener(this.playerListener);
            if (player == null) {
                this.stopNotification(false);
            }
        }
        this.player = player;
        if (player != null) {
            player.addListener(this.playerListener);
            this.postStartOrUpdateNotification();
        }
    }

    public final void setPriority(int n2) {
        if (this.priority == n2) {
            return;
        }
        if (n2 != -2 && n2 != -1 && n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException();
        }
        this.priority = n2;
        this.invalidate();
    }

    @Deprecated
    public final void setRewindIncrementMs(long l2) {
        ControlDispatcher controlDispatcher = this.controlDispatcher;
        if (controlDispatcher instanceof DefaultControlDispatcher) {
            ((DefaultControlDispatcher)controlDispatcher).setRewindIncrementMs(l2);
            this.invalidate();
        }
    }

    public final void setSmallIcon(int n2) {
        if (this.smallIconResourceId != n2) {
            this.smallIconResourceId = n2;
            this.invalidate();
        }
    }

    public final void setUseChronometer(boolean bl) {
        if (this.useChronometer != bl) {
            this.useChronometer = bl;
            this.invalidate();
        }
    }

    @Deprecated
    public final void setUseNavigationActions(boolean bl) {
        this.setUseNextAction(bl);
        this.setUsePreviousAction(bl);
    }

    @Deprecated
    public final void setUseNavigationActionsInCompactView(boolean bl) {
        this.setUseNextActionInCompactView(bl);
        this.setUsePreviousActionInCompactView(bl);
    }

    public void setUseNextAction(boolean bl) {
        if (this.useNextAction != bl) {
            this.useNextAction = bl;
            this.invalidate();
        }
    }

    public void setUseNextActionInCompactView(boolean bl) {
        if (this.useNextActionInCompactView != bl) {
            this.useNextActionInCompactView = bl;
            this.invalidate();
        }
    }

    public final void setUsePlayPauseActions(boolean bl) {
        if (this.usePlayPauseActions != bl) {
            this.usePlayPauseActions = bl;
            this.invalidate();
        }
    }

    public void setUsePreviousAction(boolean bl) {
        if (this.usePreviousAction != bl) {
            this.usePreviousAction = bl;
            this.invalidate();
        }
    }

    public void setUsePreviousActionInCompactView(boolean bl) {
        if (this.usePreviousActionInCompactView != bl) {
            this.usePreviousActionInCompactView = bl;
            this.invalidate();
        }
    }

    public final void setUseStopAction(boolean bl) {
        if (this.useStopAction == bl) {
            return;
        }
        this.useStopAction = bl;
        this.invalidate();
    }

    public final void setVisibility(int n2) {
        if (this.visibility == n2) {
            return;
        }
        if (n2 != -1 && n2 != 0 && n2 != 1) {
            throw new IllegalStateException();
        }
        this.visibility = n2;
        this.invalidate();
    }

    public final class BitmapCallback {
        private final int notificationTag;

        private BitmapCallback(int n2) {
            this.notificationTag = n2;
        }

        public void onBitmap(Bitmap bitmap) {
            if (bitmap != null) {
                PlayerNotificationManager.this.postUpdateNotificationBitmap(bitmap, this.notificationTag);
            }
        }
    }

    public static interface CustomActionReceiver {
        public Map<String, NotificationCompat.Action> createCustomActions(Context var1, int var2);

        public List<String> getCustomActions(Player var1);

        public void onCustomAction(Player var1, String var2, Intent var3);
    }

    public static interface MediaDescriptionAdapter {
        public PendingIntent createCurrentContentIntent(Player var1);

        public CharSequence getCurrentContentText(Player var1);

        public CharSequence getCurrentContentTitle(Player var1);

        public Bitmap getCurrentLargeIcon(Player var1, BitmapCallback var2);

        public CharSequence getCurrentSubText(Player var1);
    }

    private class NotificationBroadcastReceiver
    extends BroadcastReceiver {
        private NotificationBroadcastReceiver() {
        }

        public void onReceive(Context object, Intent intent) {
            object = PlayerNotificationManager.this.player;
            if (object != null && PlayerNotificationManager.this.isNotificationStarted && intent.getIntExtra(PlayerNotificationManager.EXTRA_INSTANCE_ID, PlayerNotificationManager.this.instanceId) == PlayerNotificationManager.this.instanceId) {
                String string2 = intent.getAction();
                if (PlayerNotificationManager.ACTION_PLAY.equals(string2)) {
                    if (object.getPlaybackState() == 1) {
                        if (PlayerNotificationManager.this.playbackPreparer != null) {
                            PlayerNotificationManager.this.playbackPreparer.preparePlayback();
                        } else {
                            PlayerNotificationManager.this.controlDispatcher.dispatchPrepare((Player)object);
                        }
                    } else if (object.getPlaybackState() == 4) {
                        PlayerNotificationManager.this.controlDispatcher.dispatchSeekTo((Player)object, object.getCurrentWindowIndex(), -9223372036854775807L);
                    }
                    PlayerNotificationManager.this.controlDispatcher.dispatchSetPlayWhenReady((Player)object, true);
                } else if (PlayerNotificationManager.ACTION_PAUSE.equals(string2)) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchSetPlayWhenReady((Player)object, false);
                } else if (PlayerNotificationManager.ACTION_PREVIOUS.equals(string2)) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchPrevious((Player)object);
                } else if (PlayerNotificationManager.ACTION_REWIND.equals(string2)) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchRewind((Player)object);
                } else if (PlayerNotificationManager.ACTION_FAST_FORWARD.equals(string2)) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchFastForward((Player)object);
                } else if (PlayerNotificationManager.ACTION_NEXT.equals(string2)) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchNext((Player)object);
                } else if (PlayerNotificationManager.ACTION_STOP.equals(string2)) {
                    PlayerNotificationManager.this.controlDispatcher.dispatchStop((Player)object, true);
                } else if (PlayerNotificationManager.ACTION_DISMISS.equals(string2)) {
                    PlayerNotificationManager.this.stopNotification(true);
                } else if (string2 != null && PlayerNotificationManager.this.customActionReceiver != null && PlayerNotificationManager.this.customActions.containsKey(string2)) {
                    PlayerNotificationManager.this.customActionReceiver.onCustomAction((Player)object, string2, intent);
                }
            }
        }
    }

    public static interface NotificationListener {
        @Deprecated
        public void onNotificationCancelled(int var1);

        public void onNotificationCancelled(int var1, boolean var2);

        public void onNotificationPosted(int var1, Notification var2, boolean var3);

        @Deprecated
        public void onNotificationStarted(int var1, Notification var2);
    }

    private class PlayerListener
    implements Player.EventListener {
        private PlayerListener() {
        }

        @Override
        public void onEvents(Player player, Player.Events events) {
            if (events.containsAny(5, 6, 8, 0, 13, 12, 9, 10)) {
                PlayerNotificationManager.this.postStartOrUpdateNotification();
            }
        }

        @Override
        public /* synthetic */ void onExperimentalOffloadSchedulingEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalOffloadSchedulingEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onExperimentalSleepingForOffloadChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalSleepingForOffloadChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsPlayingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsPlayingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onMediaItemTransition(MediaItem mediaItem, int n2) {
            Player.EventListener._CC.$default$onMediaItemTransition((Player.EventListener)this, (MediaItem)mediaItem, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayWhenReadyChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayWhenReadyChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            Player.EventListener._CC.$default$onPlaybackParametersChanged((Player.EventListener)this, (PlaybackParameters)playbackParameters);
        }

        @Override
        public /* synthetic */ void onPlaybackStateChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackStateChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlaybackSuppressionReasonChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackSuppressionReasonChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayerError(ExoPlaybackException exoPlaybackException) {
            Player.EventListener._CC.$default$onPlayerError((Player.EventListener)this, (ExoPlaybackException)exoPlaybackException);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onPlayerStateChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayerStateChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPositionDiscontinuity(int n2) {
            Player.EventListener._CC.$default$onPositionDiscontinuity((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onRepeatModeChanged(int n2) {
            Player.EventListener._CC.$default$onRepeatModeChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onSeekProcessed() {
            Player.EventListener._CC.$default$onSeekProcessed((Player.EventListener)this);
        }

        @Override
        public /* synthetic */ void onShuffleModeEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onShuffleModeEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onStaticMetadataChanged(List<Metadata> list) {
            Player.EventListener._CC.$default$onStaticMetadataChanged((Player.EventListener)this, list);
        }

        @Override
        public /* synthetic */ void onTimelineChanged(Timeline timeline, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onTimelineChanged(Timeline timeline, Object object, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (Object)object, (int)n2);
        }

        @Override
        public /* synthetic */ void onTracksChanged(TrackGroupArray trackGroupArray, TrackSelectionArray trackSelectionArray) {
            Player.EventListener._CC.$default$onTracksChanged((Player.EventListener)this, (TrackGroupArray)trackGroupArray, (TrackSelectionArray)trackSelectionArray);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }
}

