/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.ui.DefaultTimeBar;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.ui._$;
import com.google.android.exoplayer2.ui._$$Lambda$1vmvJI4HM5BSJdnh7cGvyaODZdE;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.RepeatModeUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class PlayerControlView
extends FrameLayout {
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 0;
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    public static final int DEFAULT_TIME_BAR_MIN_UPDATE_INTERVAL_MS = 200;
    private static final int MAX_UPDATE_INTERVAL_MS = 1000;
    public static final int MAX_WINDOWS_FOR_MULTI_WINDOW_TIME_BAR = 100;
    private long[] adGroupTimesMs;
    private final float buttonAlphaDisabled;
    private final float buttonAlphaEnabled;
    private final ComponentListener componentListener;
    private ControlDispatcher controlDispatcher;
    private long currentWindowOffset;
    private final TextView durationView;
    private long[] extraAdGroupTimesMs;
    private boolean[] extraPlayedAdGroups;
    private final View fastForwardButton;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Runnable hideAction;
    private long hideAtMs;
    private boolean isAttachedToWindow;
    private boolean multiWindowTimeBar;
    private final View nextButton;
    private final View pauseButton;
    private final Timeline.Period period;
    private final View playButton;
    private PlaybackPreparer playbackPreparer;
    private boolean[] playedAdGroups;
    private Player player;
    private final TextView positionView;
    private final View previousButton;
    private ProgressUpdateListener progressUpdateListener;
    private final String repeatAllButtonContentDescription;
    private final Drawable repeatAllButtonDrawable;
    private final String repeatOffButtonContentDescription;
    private final Drawable repeatOffButtonDrawable;
    private final String repeatOneButtonContentDescription;
    private final Drawable repeatOneButtonDrawable;
    private final ImageView repeatToggleButton;
    private int repeatToggleModes;
    private final View rewindButton;
    private boolean scrubbing;
    private boolean showFastForwardButton;
    private boolean showMultiWindowTimeBar;
    private boolean showNextButton;
    private boolean showPreviousButton;
    private boolean showRewindButton;
    private boolean showShuffleButton;
    private int showTimeoutMs;
    private final ImageView shuffleButton;
    private final Drawable shuffleOffButtonDrawable;
    private final String shuffleOffContentDescription;
    private final Drawable shuffleOnButtonDrawable;
    private final String shuffleOnContentDescription;
    private final TimeBar timeBar;
    private int timeBarMinUpdateIntervalMs;
    private final Runnable updateProgressAction;
    private final CopyOnWriteArrayList<VisibilityListener> visibilityListeners;
    private final View vrButton;
    private final Timeline.Window window;

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ui");
    }

    public PlayerControlView(Context context) {
        this(context, null);
    }

    public PlayerControlView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PlayerControlView(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet, n2, attributeSet);
    }

    public PlayerControlView(Context context, AttributeSet attributeSet, int n2, AttributeSet attributeSet2) {
        super(context, attributeSet, n2);
        int n3 = R.layout.exo_player_control_view;
        int n4 = 5000;
        this.showTimeoutMs = 5000;
        this.repeatToggleModes = 0;
        this.timeBarMinUpdateIntervalMs = 200;
        this.hideAtMs = -9223372036854775807L;
        this.showRewindButton = true;
        this.showFastForwardButton = true;
        this.showPreviousButton = true;
        this.showNextButton = true;
        this.showShuffleButton = false;
        n2 = 15000;
        int n5 = n3;
        if (attributeSet2 != null) {
            attributeSet = context.getTheme().obtainStyledAttributes(attributeSet2, R.styleable.PlayerControlView, 0, 0);
            try {
                n4 = attributeSet.getInt(R.styleable.PlayerControlView_rewind_increment, 5000);
                n2 = attributeSet.getInt(R.styleable.PlayerControlView_fastforward_increment, 15000);
                this.showTimeoutMs = attributeSet.getInt(R.styleable.PlayerControlView_show_timeout, this.showTimeoutMs);
                n5 = attributeSet.getResourceId(R.styleable.PlayerControlView_controller_layout_id, n3);
                this.repeatToggleModes = PlayerControlView.getRepeatToggleModes((TypedArray)attributeSet, this.repeatToggleModes);
                this.showRewindButton = attributeSet.getBoolean(R.styleable.PlayerControlView_show_rewind_button, this.showRewindButton);
                this.showFastForwardButton = attributeSet.getBoolean(R.styleable.PlayerControlView_show_fastforward_button, this.showFastForwardButton);
                this.showPreviousButton = attributeSet.getBoolean(R.styleable.PlayerControlView_show_previous_button, this.showPreviousButton);
                this.showNextButton = attributeSet.getBoolean(R.styleable.PlayerControlView_show_next_button, this.showNextButton);
                this.showShuffleButton = attributeSet.getBoolean(R.styleable.PlayerControlView_show_shuffle_button, this.showShuffleButton);
                this.setTimeBarMinUpdateInterval(attributeSet.getInt(R.styleable.PlayerControlView_time_bar_min_update_interval, this.timeBarMinUpdateIntervalMs));
            }
            finally {
                attributeSet.recycle();
            }
        }
        this.visibilityListeners = new CopyOnWriteArrayList();
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.adGroupTimesMs = new long[0];
        this.playedAdGroups = new boolean[0];
        this.extraAdGroupTimesMs = new long[0];
        this.extraPlayedAdGroups = new boolean[0];
        this.componentListener = new ComponentListener();
        this.controlDispatcher = new DefaultControlDispatcher((long)n2, (long)n4);
        this.updateProgressAction = new _$.Lambda.PlayerControlView.UNnS0kV7Qp5A4iJshVHLVqmqwTE(this);
        this.hideAction = new _$$Lambda$1vmvJI4HM5BSJdnh7cGvyaODZdE(this);
        LayoutInflater.from((Context)context).inflate(n5, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        TimeBar timeBar = (TimeBar)this.findViewById(R.id.exo_progress);
        attributeSet = this.findViewById(R.id.exo_progress_placeholder);
        if (timeBar != null) {
            this.timeBar = timeBar;
        } else if (attributeSet != null) {
            attributeSet2 = new DefaultTimeBar(context, null, 0, attributeSet2);
            attributeSet2.setId(R.id.exo_progress);
            attributeSet2.setLayoutParams(attributeSet.getLayoutParams());
            timeBar = (ViewGroup)attributeSet.getParent();
            n2 = timeBar.indexOfChild((View)attributeSet);
            timeBar.removeView((View)attributeSet);
            timeBar.addView((View)attributeSet2, n2);
            this.timeBar = attributeSet2;
        } else {
            this.timeBar = null;
        }
        this.durationView = (TextView)this.findViewById(R.id.exo_duration);
        this.positionView = (TextView)this.findViewById(R.id.exo_position);
        attributeSet = this.timeBar;
        if (attributeSet != null) {
            attributeSet.addListener((TimeBar.OnScrubListener)this.componentListener);
        }
        this.playButton = this.findViewById(R.id.exo_play);
        attributeSet = this.playButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.pauseButton = this.findViewById(R.id.exo_pause);
        attributeSet = this.pauseButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.previousButton = this.findViewById(R.id.exo_prev);
        attributeSet = this.previousButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.nextButton = this.findViewById(R.id.exo_next);
        attributeSet = this.nextButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.rewindButton = this.findViewById(R.id.exo_rew);
        attributeSet = this.rewindButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.fastForwardButton = this.findViewById(R.id.exo_ffwd);
        attributeSet = this.fastForwardButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.repeatToggleButton = (ImageView)this.findViewById(R.id.exo_repeat_toggle);
        attributeSet = this.repeatToggleButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.shuffleButton = (ImageView)this.findViewById(R.id.exo_shuffle);
        attributeSet = this.shuffleButton;
        if (attributeSet != null) {
            attributeSet.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.vrButton = this.findViewById(R.id.exo_vr);
        this.setShowVrButton(false);
        this.updateButton(false, false, this.vrButton);
        context = context.getResources();
        this.buttonAlphaEnabled = (float)context.getInteger(R.integer.exo_media_button_opacity_percentage_enabled) / 100.0f;
        this.buttonAlphaDisabled = (float)context.getInteger(R.integer.exo_media_button_opacity_percentage_disabled) / 100.0f;
        this.repeatOffButtonDrawable = context.getDrawable(R.drawable.exo_controls_repeat_off);
        this.repeatOneButtonDrawable = context.getDrawable(R.drawable.exo_controls_repeat_one);
        this.repeatAllButtonDrawable = context.getDrawable(R.drawable.exo_controls_repeat_all);
        this.shuffleOnButtonDrawable = context.getDrawable(R.drawable.exo_controls_shuffle_on);
        this.shuffleOffButtonDrawable = context.getDrawable(R.drawable.exo_controls_shuffle_off);
        this.repeatOffButtonContentDescription = context.getString(R.string.exo_controls_repeat_off_description);
        this.repeatOneButtonContentDescription = context.getString(R.string.exo_controls_repeat_one_description);
        this.repeatAllButtonContentDescription = context.getString(R.string.exo_controls_repeat_all_description);
        this.shuffleOnContentDescription = context.getString(R.string.exo_controls_shuffle_on_description);
        this.shuffleOffContentDescription = context.getString(R.string.exo_controls_shuffle_off_description);
    }

    static /* synthetic */ boolean access$102(PlayerControlView playerControlView, boolean bl) {
        playerControlView.scrubbing = bl;
        return bl;
    }

    private static boolean canShowMultiWindowTimeBar(Timeline timeline, Timeline.Window window) {
        if (timeline.getWindowCount() > 100) {
            return false;
        }
        int n2 = timeline.getWindowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (timeline.getWindow((int)i2, (Timeline.Window)window).durationUs != -9223372036854775807L) continue;
            return false;
        }
        return true;
    }

    private void dispatchPause(Player player) {
        this.controlDispatcher.dispatchSetPlayWhenReady(player, false);
    }

    private void dispatchPlay(Player player) {
        int n2 = player.getPlaybackState();
        if (n2 == 1) {
            PlaybackPreparer playbackPreparer = this.playbackPreparer;
            if (playbackPreparer != null) {
                playbackPreparer.preparePlayback();
            } else {
                this.controlDispatcher.dispatchPrepare(player);
            }
        } else if (n2 == 4) {
            this.seekTo(player, player.getCurrentWindowIndex(), -9223372036854775807L);
        }
        this.controlDispatcher.dispatchSetPlayWhenReady(player, true);
    }

    private void dispatchPlayPause(Player player) {
        int n2 = player.getPlaybackState();
        if (n2 != 1 && n2 != 4 && player.getPlayWhenReady()) {
            this.dispatchPause(player);
        } else {
            this.dispatchPlay(player);
        }
    }

    private static int getRepeatToggleModes(TypedArray typedArray, int n2) {
        return typedArray.getInt(R.styleable.PlayerControlView_repeat_toggle_modes, n2);
    }

    private void hideAfterTimeout() {
        this.removeCallbacks(this.hideAction);
        if (this.showTimeoutMs > 0) {
            long l2 = SystemClock.uptimeMillis();
            int n2 = this.showTimeoutMs;
            this.hideAtMs = l2 + (long)n2;
            if (this.isAttachedToWindow) {
                this.postDelayed(this.hideAction, n2);
            }
        } else {
            this.hideAtMs = -9223372036854775807L;
        }
    }

    private static boolean isHandledMediaKey(int n2) {
        boolean bl = n2 == 90 || n2 == 89 || n2 == 85 || n2 == 79 || n2 == 126 || n2 == 127 || n2 == 87 || n2 == 88;
        return bl;
    }

    public static /* synthetic */ void lambda$UNnS0kV7Qp5A4iJshVHLVqmqwTE(PlayerControlView playerControlView) {
        playerControlView.updateProgress();
    }

    private void requestPlayPauseFocus() {
        View view;
        boolean bl = this.shouldShowPauseButton();
        if (!bl && (view = this.playButton) != null) {
            view.requestFocus();
        } else if (bl && (view = this.pauseButton) != null) {
            view.requestFocus();
        }
    }

    private boolean seekTo(Player player, int n2, long l2) {
        return this.controlDispatcher.dispatchSeekTo(player, n2, l2);
    }

    private void seekToTimeBarPosition(Player player, long l2) {
        int n2;
        Timeline timeline = player.getCurrentTimeline();
        if (this.multiWindowTimeBar && !timeline.isEmpty()) {
            long l3;
            int n3 = timeline.getWindowCount();
            n2 = 0;
            while (l2 >= (l3 = timeline.getWindow(n2, this.window).getDurationMs())) {
                if (n2 == n3 - 1) {
                    l2 = l3;
                    break;
                }
                l2 -= l3;
                ++n2;
            }
        } else {
            n2 = player.getCurrentWindowIndex();
        }
        if (!this.seekTo(player, n2, l2)) {
            this.updateProgress();
        }
    }

    private boolean shouldShowPauseButton() {
        Player player = this.player;
        boolean bl = true;
        if (player == null || player.getPlaybackState() == 4 || this.player.getPlaybackState() == 1 || !this.player.getPlayWhenReady()) {
            bl = false;
        }
        return bl;
    }

    private void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateRepeatModeButton();
        this.updateShuffleButton();
        this.updateTimeline();
    }

    private void updateButton(boolean bl, boolean bl2, View view) {
        if (view == null) {
            return;
        }
        view.setEnabled(bl2);
        float f2 = bl2 ? this.buttonAlphaEnabled : this.buttonAlphaDisabled;
        view.setAlpha(f2);
        int n2 = bl ? 0 : 8;
        view.setVisibility(n2);
    }

    private void updateNavigation() {
        if (this.isVisible() && this.isAttachedToWindow) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Timeline timeline;
            Player player = this.player;
            boolean bl5 = false;
            boolean bl6 = false;
            if (player != null && !(timeline = player.getCurrentTimeline()).isEmpty() && !player.isPlayingAd()) {
                timeline.getWindow(player.getCurrentWindowIndex(), this.window);
                bl5 = this.window.isSeekable;
                bl4 = bl5 || !this.window.isLive() || player.hasPrevious();
                bl3 = bl5 && this.controlDispatcher.isRewindEnabled();
                bl2 = bl5 && this.controlDispatcher.isFastForwardEnabled();
                if (this.window.isLive() && this.window.isDynamic || player.hasNext()) {
                    bl6 = true;
                }
                bl = bl6;
                bl6 = bl4;
                bl4 = bl;
                bl = bl5;
            } else {
                bl4 = false;
                bl = false;
                bl3 = false;
                bl2 = false;
                bl6 = bl5;
            }
            this.updateButton(this.showPreviousButton, bl6, this.previousButton);
            this.updateButton(this.showRewindButton, bl3, this.rewindButton);
            this.updateButton(this.showFastForwardButton, bl2, this.fastForwardButton);
            this.updateButton(this.showNextButton, bl4, this.nextButton);
            player = this.timeBar;
            if (player != null) {
                player.setEnabled(bl);
            }
        }
    }

    private void updatePlayPauseButton() {
        if (this.isVisible() && this.isAttachedToWindow) {
            int n2;
            int n3;
            boolean bl = this.shouldShowPauseButton();
            View view = this.playButton;
            int n4 = 8;
            int n5 = 1;
            if (view != null) {
                n3 = bl && view.isFocused() ? 1 : 0;
                n2 = n3 | 0;
                view = this.playButton;
                n3 = bl ? 8 : 0;
                view.setVisibility(n3);
                n3 = n2;
            } else {
                n3 = 0;
            }
            view = this.pauseButton;
            n2 = n3;
            if (view != null) {
                n2 = !bl && view.isFocused() ? n5 : 0;
                n2 = n3 | n2;
                view = this.pauseButton;
                n3 = n4;
                if (bl) {
                    n3 = 0;
                }
                view.setVisibility(n3);
            }
            if (n2 != 0) {
                this.requestPlayPauseFocus();
            }
        }
    }

    private void updateProgress() {
        if (this.isVisible() && this.isAttachedToWindow) {
            long l2;
            Player player = this.player;
            long l3 = 0L;
            if (player != null) {
                l3 = this.currentWindowOffset + player.getContentPosition();
                l2 = this.currentWindowOffset + player.getContentBufferedPosition();
            } else {
                l2 = 0L;
            }
            Object object = this.positionView;
            if (object != null && !this.scrubbing) {
                object.setText((CharSequence)Util.getStringForTime(this.formatBuilder, this.formatter, l3));
            }
            if ((object = this.timeBar) != null) {
                object.setPosition(l3);
                this.timeBar.setBufferedPosition(l2);
            }
            if ((object = this.progressUpdateListener) != null) {
                object.onProgressUpdate(l3, l2);
            }
            this.removeCallbacks(this.updateProgressAction);
            int n2 = player == null ? 1 : player.getPlaybackState();
            long l4 = 1000L;
            if (player != null && player.isPlaying()) {
                object = this.timeBar;
                l2 = object != null ? object.getPreferredUpdateDelay() : 1000L;
                l2 = Math.min(l2, 1000L - l3 % 1000L);
                float f2 = player.getPlaybackParameters().speed;
                l3 = l4;
                if (f2 > 0.0f) {
                    l3 = (long)((float)l2 / f2);
                }
                l3 = Util.constrainValue(l3, (long)this.timeBarMinUpdateIntervalMs, 1000L);
                this.postDelayed(this.updateProgressAction, l3);
            } else if (n2 != 4 && n2 != 1) {
                this.postDelayed(this.updateProgressAction, 1000L);
            }
        }
    }

    private void updateRepeatModeButton() {
        ImageView imageView;
        if (this.isVisible() && this.isAttachedToWindow && (imageView = this.repeatToggleButton) != null) {
            if (this.repeatToggleModes == 0) {
                this.updateButton(false, false, (View)imageView);
                return;
            }
            Player player = this.player;
            if (player == null) {
                this.updateButton(true, false, (View)imageView);
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
                return;
            }
            this.updateButton(true, true, (View)imageView);
            int n2 = player.getRepeatMode();
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        this.repeatToggleButton.setImageDrawable(this.repeatAllButtonDrawable);
                        this.repeatToggleButton.setContentDescription((CharSequence)this.repeatAllButtonContentDescription);
                    }
                } else {
                    this.repeatToggleButton.setImageDrawable(this.repeatOneButtonDrawable);
                    this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOneButtonContentDescription);
                }
            } else {
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
            }
            this.repeatToggleButton.setVisibility(0);
        }
    }

    private void updateShuffleButton() {
        Object object;
        if (this.isVisible() && this.isAttachedToWindow && (object = this.shuffleButton) != null) {
            Player player = this.player;
            if (!this.showShuffleButton) {
                this.updateButton(false, false, (View)object);
            } else if (player == null) {
                this.updateButton(true, false, (View)object);
                this.shuffleButton.setImageDrawable(this.shuffleOffButtonDrawable);
                this.shuffleButton.setContentDescription((CharSequence)this.shuffleOffContentDescription);
            } else {
                this.updateButton(true, true, (View)object);
                ImageView imageView = this.shuffleButton;
                object = player.getShuffleModeEnabled() ? this.shuffleOnButtonDrawable : this.shuffleOffButtonDrawable;
                imageView.setImageDrawable((Drawable)object);
                imageView = this.shuffleButton;
                object = player.getShuffleModeEnabled() ? this.shuffleOnContentDescription : this.shuffleOffContentDescription;
                imageView.setContentDescription((CharSequence)object);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void updateTimeline() {
        block13: {
            block14: {
                var1_1 = this.player;
                if (var1_1 == null) {
                    return;
                }
                var2_2 = this.showMultiWindowTimeBar != false && PlayerControlView.canShowMultiWindowTimeBar(var1_1.getCurrentTimeline(), this.window) != false;
                this.multiWindowTimeBar = var2_2;
                this.currentWindowOffset = 0L;
                var3_3 /* !! */  = var1_1.getCurrentTimeline();
                if (var3_3 /* !! */ .isEmpty()) break block14;
                var4_4 = var1_1.getCurrentWindowIndex();
                var6_6 = this.multiWindowTimeBar != false ? var3_3 /* !! */ .getWindowCount() - 1 : var4_4;
                var7_7 = 0L;
                var9_8 = 0;
                for (var5_5 = this.multiWindowTimeBar != false ? 0 : var4_4; var5_5 <= var6_6; ++var5_5) {
                    if (var5_5 == var4_4) {
                        this.currentWindowOffset = C.usToMs(var7_7);
                    }
                    var3_3 /* !! */ .getWindow(var5_5, this.window);
                    if (this.window.durationUs == -9223372036854775807L) {
                        Assertions.checkState(this.multiWindowTimeBar ^ true);
                        break block13;
                    }
                    for (var10_9 = this.window.firstPeriodIndex; var10_9 <= this.window.lastPeriodIndex; ++var10_9) {
                        var3_3 /* !! */ .getPeriod(var10_9, this.period);
                        var11_10 = this.period.getAdGroupCount();
                        for (var12_11 = 0; var12_11 < var11_10; ++var12_11) {
                            var15_13 = var13_12 = this.period.getAdGroupTimeUs(var12_11);
                            if (var13_12 != -9223372036854775808L) ** GOTO lbl32
                            if (this.period.durationUs == -9223372036854775807L) {
                                var17_14 = var9_8;
                            } else {
                                var15_13 = this.period.durationUs;
lbl32:
                                // 2 sources

                                var17_14 = var9_8;
                                if ((var15_13 += this.period.getPositionInWindowUs()) >= 0L) {
                                    var1_1 = this.adGroupTimesMs;
                                    if (var9_8 == ((Object)var1_1).length) {
                                        var17_14 = ((Object)var1_1).length == 0 ? 1 : ((Object)var1_1).length * 2;
                                        this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, var17_14);
                                        this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, var17_14);
                                    }
                                    this.adGroupTimesMs[var9_8] = C.usToMs(var7_7 + var15_13);
                                    this.playedAdGroups[var9_8] = this.period.hasPlayedAdGroup(var12_11);
                                    var17_14 = var9_8 + 1;
                                }
                            }
                            var9_8 = var17_14;
                        }
                    }
                    var7_7 += this.window.durationUs;
                }
                break block13;
            }
            var9_8 = 0;
            var7_7 = 0L;
        }
        var7_7 = C.usToMs(var7_7);
        var3_3 /* !! */  = this.durationView;
        if (var3_3 /* !! */  != null) {
            var3_3 /* !! */ .setText((CharSequence)Util.getStringForTime(this.formatBuilder, this.formatter, var7_7));
        }
        if ((var3_3 /* !! */  = this.timeBar) != null) {
            var3_3 /* !! */ .setDuration(var7_7);
            var5_5 = this.extraAdGroupTimesMs.length;
            var4_4 = var9_8 + var5_5;
            var3_3 /* !! */  = (Timeline)this.adGroupTimesMs;
            if (var4_4 > ((Timeline)var3_3 /* !! */ ).length) {
                this.adGroupTimesMs = Arrays.copyOf((long[])var3_3 /* !! */ , var4_4);
                this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, var4_4);
            }
            System.arraycopy(this.extraAdGroupTimesMs, 0, this.adGroupTimesMs, var9_8, var5_5);
            System.arraycopy(this.extraPlayedAdGroups, 0, this.playedAdGroups, var9_8, var5_5);
            this.timeBar.setAdGroupTimesMs(this.adGroupTimesMs, this.playedAdGroups, var4_4);
        }
        this.updateProgress();
    }

    public void addVisibilityListener(VisibilityListener visibilityListener) {
        Assertions.checkNotNull(visibilityListener);
        this.visibilityListeners.add(visibilityListener);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = this.dispatchMediaKeyEvent(keyEvent) || super.dispatchKeyEvent(keyEvent);
        return bl;
    }

    public boolean dispatchMediaKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        Player player = this.player;
        if (player != null && PlayerControlView.isHandledMediaKey(n2)) {
            if (keyEvent.getAction() == 0) {
                if (n2 == 90) {
                    if (player.getPlaybackState() != 4) {
                        this.controlDispatcher.dispatchFastForward(player);
                    }
                } else if (n2 == 89) {
                    this.controlDispatcher.dispatchRewind(player);
                } else if (keyEvent.getRepeatCount() == 0) {
                    if (n2 != 79 && n2 != 85) {
                        if (n2 != 87) {
                            if (n2 != 88) {
                                if (n2 != 126) {
                                    if (n2 == 127) {
                                        this.dispatchPause(player);
                                    }
                                } else {
                                    this.dispatchPlay(player);
                                }
                            } else {
                                this.controlDispatcher.dispatchPrevious(player);
                            }
                        } else {
                            this.controlDispatcher.dispatchNext(player);
                        }
                    } else {
                        this.dispatchPlayPause(player);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public final boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.removeCallbacks(this.hideAction);
        } else if (motionEvent.getAction() == 1) {
            this.hideAfterTimeout();
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getRepeatToggleModes() {
        return this.repeatToggleModes;
    }

    public boolean getShowShuffleButton() {
        return this.showShuffleButton;
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public boolean getShowVrButton() {
        View view = this.vrButton;
        boolean bl = view != null && view.getVisibility() == 0;
        return bl;
    }

    public void hide() {
        if (this.isVisible()) {
            this.setVisibility(8);
            Iterator<VisibilityListener> iterator2 = this.visibilityListeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onVisibilityChange(this.getVisibility());
            }
            this.removeCallbacks(this.updateProgressAction);
            this.removeCallbacks(this.hideAction);
            this.hideAtMs = -9223372036854775807L;
        }
    }

    public boolean isVisible() {
        boolean bl = this.getVisibility() == 0;
        return bl;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
        long l2 = this.hideAtMs;
        if (l2 != -9223372036854775807L) {
            if ((l2 -= SystemClock.uptimeMillis()) <= 0L) {
                this.hide();
            } else {
                this.postDelayed(this.hideAction, l2);
            }
        } else if (this.isVisible()) {
            this.hideAfterTimeout();
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.removeCallbacks(this.hideAction);
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public void removeVisibilityListener(VisibilityListener visibilityListener) {
        this.visibilityListeners.remove(visibilityListener);
    }

    public void setControlDispatcher(ControlDispatcher controlDispatcher) {
        if (this.controlDispatcher != controlDispatcher) {
            this.controlDispatcher = controlDispatcher;
            this.updateNavigation();
        }
    }

    public void setExtraAdGroupMarkers(long[] lArray, boolean[] blArray) {
        boolean bl = false;
        if (lArray == null) {
            this.extraAdGroupTimesMs = new long[0];
            this.extraPlayedAdGroups = new boolean[0];
        } else {
            if (lArray.length == (blArray = Assertions.checkNotNull(blArray)).length) {
                bl = true;
            }
            Assertions.checkArgument(bl);
            this.extraAdGroupTimesMs = lArray;
            this.extraPlayedAdGroups = blArray;
        }
        this.updateTimeline();
    }

    @Deprecated
    public void setFastForwardIncrementMs(int n2) {
        ControlDispatcher controlDispatcher = this.controlDispatcher;
        if (controlDispatcher instanceof DefaultControlDispatcher) {
            ((DefaultControlDispatcher)controlDispatcher).setFastForwardIncrementMs((long)n2);
            this.updateNavigation();
        }
    }

    @Deprecated
    public void setPlaybackPreparer(PlaybackPreparer playbackPreparer) {
        this.playbackPreparer = playbackPreparer;
    }

    public void setPlayer(Player player) {
        Looper looper = Looper.myLooper();
        Object object = Looper.getMainLooper();
        boolean bl = true;
        boolean bl2 = looper == object;
        Assertions.checkState(bl2);
        bl2 = bl;
        if (player != null) {
            bl2 = player.getApplicationLooper() == Looper.getMainLooper() ? bl : false;
        }
        Assertions.checkArgument(bl2);
        object = this.player;
        if (object == player) {
            return;
        }
        if (object != null) {
            object.removeListener(this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener(this.componentListener);
        }
        this.updateAll();
    }

    public void setProgressUpdateListener(ProgressUpdateListener progressUpdateListener) {
        this.progressUpdateListener = progressUpdateListener;
    }

    public void setRepeatToggleModes(int n2) {
        this.repeatToggleModes = n2;
        Player player = this.player;
        if (player != null) {
            int n3 = player.getRepeatMode();
            if (n2 == 0 && n3 != 0) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 0);
            } else if (n2 == 1 && n3 == 2) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 1);
            } else if (n2 == 2 && n3 == 1) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 2);
            }
        }
        this.updateRepeatModeButton();
    }

    @Deprecated
    public void setRewindIncrementMs(int n2) {
        ControlDispatcher controlDispatcher = this.controlDispatcher;
        if (controlDispatcher instanceof DefaultControlDispatcher) {
            ((DefaultControlDispatcher)controlDispatcher).setRewindIncrementMs((long)n2);
            this.updateNavigation();
        }
    }

    public void setShowFastForwardButton(boolean bl) {
        this.showFastForwardButton = bl;
        this.updateNavigation();
    }

    public void setShowMultiWindowTimeBar(boolean bl) {
        this.showMultiWindowTimeBar = bl;
        this.updateTimeline();
    }

    public void setShowNextButton(boolean bl) {
        this.showNextButton = bl;
        this.updateNavigation();
    }

    public void setShowPreviousButton(boolean bl) {
        this.showPreviousButton = bl;
        this.updateNavigation();
    }

    public void setShowRewindButton(boolean bl) {
        this.showRewindButton = bl;
        this.updateNavigation();
    }

    public void setShowShuffleButton(boolean bl) {
        this.showShuffleButton = bl;
        this.updateShuffleButton();
    }

    public void setShowTimeoutMs(int n2) {
        this.showTimeoutMs = n2;
        if (this.isVisible()) {
            this.hideAfterTimeout();
        }
    }

    public void setShowVrButton(boolean bl) {
        View view = this.vrButton;
        if (view != null) {
            int n2 = bl ? 0 : 8;
            view.setVisibility(n2);
        }
    }

    public void setTimeBarMinUpdateInterval(int n2) {
        this.timeBarMinUpdateIntervalMs = Util.constrainValue(n2, 16, 1000);
    }

    public void setVrButtonListener(View.OnClickListener onClickListener) {
        View view = this.vrButton;
        if (view != null) {
            view.setOnClickListener(onClickListener);
            boolean bl = this.getShowVrButton();
            boolean bl2 = onClickListener != null;
            this.updateButton(bl, bl2, this.vrButton);
        }
    }

    public void show() {
        if (!this.isVisible()) {
            this.setVisibility(0);
            Iterator<VisibilityListener> iterator2 = this.visibilityListeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onVisibilityChange(this.getVisibility());
            }
            this.updateAll();
            this.requestPlayPauseFocus();
        }
        this.hideAfterTimeout();
    }

    private final class ComponentListener
    implements Player.EventListener,
    TimeBar.OnScrubListener,
    View.OnClickListener {
        private ComponentListener() {
        }

        public void onClick(View view) {
            Player player = PlayerControlView.this.player;
            if (player == null) {
                return;
            }
            if (PlayerControlView.this.nextButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchNext(player);
            } else if (PlayerControlView.this.previousButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchPrevious(player);
            } else if (PlayerControlView.this.fastForwardButton == view) {
                if (player.getPlaybackState() != 4) {
                    PlayerControlView.this.controlDispatcher.dispatchFastForward(player);
                }
            } else if (PlayerControlView.this.rewindButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchRewind(player);
            } else if (PlayerControlView.this.playButton == view) {
                PlayerControlView.this.dispatchPlay(player);
            } else if (PlayerControlView.this.pauseButton == view) {
                PlayerControlView.this.dispatchPause(player);
            } else if (PlayerControlView.this.repeatToggleButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchSetRepeatMode(player, RepeatModeUtil.getNextRepeatMode(player.getRepeatMode(), PlayerControlView.this.repeatToggleModes));
            } else if (PlayerControlView.this.shuffleButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchSetShuffleModeEnabled(player, player.getShuffleModeEnabled() ^ true);
            }
        }

        @Override
        public void onEvents(Player player, Player.Events events) {
            if (events.containsAny(5, 6)) {
                PlayerControlView.this.updatePlayPauseButton();
            }
            if (events.containsAny(5, 6, 8)) {
                PlayerControlView.this.updateProgress();
            }
            if (events.contains(9)) {
                PlayerControlView.this.updateRepeatModeButton();
            }
            if (events.contains(10)) {
                PlayerControlView.this.updateShuffleButton();
            }
            if (events.containsAny(9, 10, 12, 0)) {
                PlayerControlView.this.updateNavigation();
            }
            if (events.containsAny(12, 0)) {
                PlayerControlView.this.updateTimeline();
            }
        }

        @Override
        public /* synthetic */ void onExperimentalOffloadSchedulingEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalOffloadSchedulingEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onExperimentalSleepingForOffloadChanged(boolean bl) {
            Player.EventListener._CC.$default$onExperimentalSleepingForOffloadChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsPlayingChanged(boolean bl) {
            Player.EventListener._CC.$default$onIsPlayingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onLoadingChanged(boolean bl) {
            Player.EventListener._CC.$default$onLoadingChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onMediaItemTransition(MediaItem mediaItem, int n2) {
            Player.EventListener._CC.$default$onMediaItemTransition((Player.EventListener)this, (MediaItem)mediaItem, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayWhenReadyChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayWhenReadyChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            Player.EventListener._CC.$default$onPlaybackParametersChanged((Player.EventListener)this, (PlaybackParameters)playbackParameters);
        }

        @Override
        public /* synthetic */ void onPlaybackStateChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackStateChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlaybackSuppressionReasonChanged(int n2) {
            Player.EventListener._CC.$default$onPlaybackSuppressionReasonChanged((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlayerError(ExoPlaybackException exoPlaybackException) {
            Player.EventListener._CC.$default$onPlayerError((Player.EventListener)this, (ExoPlaybackException)exoPlaybackException);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onPlayerStateChanged(boolean bl, int n2) {
            Player.EventListener._CC.$default$onPlayerStateChanged((Player.EventListener)this, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPositionDiscontinuity(int n2) {
            Player.EventListener._CC.$default$onPositionDiscontinuity((Player.EventListener)this, (int)n2);
        }

        @Override
        public /* synthetic */ void onRepeatModeChanged(int n2) {
            Player.EventListener._CC.$default$onRepeatModeChanged((Player.EventListener)this, (int)n2);
        }

        public void onScrubMove(TimeBar timeBar, long l2) {
            if (PlayerControlView.this.positionView != null) {
                PlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime(PlayerControlView.this.formatBuilder, PlayerControlView.this.formatter, l2));
            }
        }

        public void onScrubStart(TimeBar timeBar, long l2) {
            PlayerControlView.access$102(PlayerControlView.this, true);
            if (PlayerControlView.this.positionView != null) {
                PlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime(PlayerControlView.this.formatBuilder, PlayerControlView.this.formatter, l2));
            }
        }

        public void onScrubStop(TimeBar object, long l2, boolean bl) {
            PlayerControlView.access$102(PlayerControlView.this, false);
            if (!bl && PlayerControlView.this.player != null) {
                object = PlayerControlView.this;
                ((PlayerControlView)((Object)object)).seekToTimeBarPosition(((PlayerControlView)((Object)object)).player, l2);
            }
        }

        @Override
        @Deprecated
        public /* synthetic */ void onSeekProcessed() {
            Player.EventListener._CC.$default$onSeekProcessed((Player.EventListener)this);
        }

        @Override
        public /* synthetic */ void onShuffleModeEnabledChanged(boolean bl) {
            Player.EventListener._CC.$default$onShuffleModeEnabledChanged((Player.EventListener)this, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onStaticMetadataChanged(List<Metadata> list) {
            Player.EventListener._CC.$default$onStaticMetadataChanged((Player.EventListener)this, list);
        }

        @Override
        public /* synthetic */ void onTimelineChanged(Timeline timeline, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onTimelineChanged(Timeline timeline, Object object, int n2) {
            Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (Object)object, (int)n2);
        }

        @Override
        public /* synthetic */ void onTracksChanged(TrackGroupArray trackGroupArray, TrackSelectionArray trackSelectionArray) {
            Player.EventListener._CC.$default$onTracksChanged((Player.EventListener)this, (TrackGroupArray)trackGroupArray, (TrackSelectionArray)trackSelectionArray);
        }
    }

    public static interface ProgressUpdateListener {
        public void onProgressUpdate(long var1, long var3);
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

