/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.os.Looper;
import android.widget.TextView;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.Assertions;
import java.util.List;
import java.util.Locale;

public class DebugTextViewHelper
implements Player.EventListener,
Runnable {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final SimpleExoPlayer player;
    private boolean started;
    private final TextView textView;

    public DebugTextViewHelper(SimpleExoPlayer simpleExoPlayer, TextView textView) {
        boolean bl = simpleExoPlayer.getApplicationLooper() == Looper.getMainLooper();
        Assertions.checkArgument(bl);
        this.player = simpleExoPlayer;
        this.textView = textView;
    }

    private static String getDecoderCountersBufferCountString(DecoderCounters decoderCounters) {
        if (decoderCounters == null) {
            return "";
        }
        decoderCounters.ensureUpdated();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" sib:");
        stringBuilder.append(decoderCounters.skippedInputBufferCount);
        stringBuilder.append(" sb:");
        stringBuilder.append(decoderCounters.skippedOutputBufferCount);
        stringBuilder.append(" rb:");
        stringBuilder.append(decoderCounters.renderedOutputBufferCount);
        stringBuilder.append(" db:");
        stringBuilder.append(decoderCounters.droppedBufferCount);
        stringBuilder.append(" mcdb:");
        stringBuilder.append(decoderCounters.maxConsecutiveDroppedBufferCount);
        stringBuilder.append(" dk:");
        stringBuilder.append(decoderCounters.droppedToKeyframeCount);
        return stringBuilder.toString();
    }

    private static String getPixelAspectRatioString(float f2) {
        CharSequence charSequence;
        if (f2 != -1.0f && f2 != 1.0f) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(" par:");
            ((StringBuilder)charSequence).append(String.format(Locale.US, "%.02f", Float.valueOf(f2)));
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = "";
        }
        return charSequence;
    }

    private static String getVideoFrameProcessingOffsetAverageString(long l2, int n2) {
        if (n2 == 0) {
            return "N/A";
        }
        double d2 = l2;
        double d3 = n2;
        Double.isNaN(d2);
        Double.isNaN(d3);
        return String.valueOf((long)(d2 / d3));
    }

    protected String getAudioString() {
        Format format = this.player.getAudioFormat();
        DecoderCounters decoderCounters = this.player.getAudioDecoderCounters();
        if (format != null && decoderCounters != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            stringBuilder.append(format.sampleMimeType);
            stringBuilder.append("(id:");
            stringBuilder.append(format.id);
            stringBuilder.append(" hz:");
            stringBuilder.append(format.sampleRate);
            stringBuilder.append(" ch:");
            stringBuilder.append(format.channelCount);
            stringBuilder.append(DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return "";
    }

    protected String getDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getPlayerStateString());
        stringBuilder.append(this.getVideoString());
        stringBuilder.append(this.getAudioString());
        return stringBuilder.toString();
    }

    protected String getPlayerStateString() {
        int n2 = this.player.getPlaybackState();
        String string2 = n2 != 1 ? (n2 != 2 ? (n2 != 3 ? (n2 != 4 ? "unknown" : "ended") : "ready") : "buffering") : "idle";
        return String.format("playWhenReady:%s playbackState:%s window:%s", this.player.getPlayWhenReady(), string2, this.player.getCurrentWindowIndex());
    }

    protected String getVideoString() {
        Format format = this.player.getVideoFormat();
        DecoderCounters decoderCounters = this.player.getVideoDecoderCounters();
        if (format != null && decoderCounters != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            stringBuilder.append(format.sampleMimeType);
            stringBuilder.append("(id:");
            stringBuilder.append(format.id);
            stringBuilder.append(" r:");
            stringBuilder.append(format.width);
            stringBuilder.append("x");
            stringBuilder.append(format.height);
            stringBuilder.append(DebugTextViewHelper.getPixelAspectRatioString(format.pixelWidthHeightRatio));
            stringBuilder.append(DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters));
            stringBuilder.append(" vfpo: ");
            stringBuilder.append(DebugTextViewHelper.getVideoFrameProcessingOffsetAverageString(decoderCounters.totalVideoFrameProcessingOffsetUs, decoderCounters.videoFrameProcessingOffsetCount));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public /* synthetic */ void onEvents(Player player, Player.Events events) {
        Player.EventListener._CC.$default$onEvents((Player.EventListener)this, (Player)player, (Player.Events)events);
    }

    @Override
    public /* synthetic */ void onExperimentalOffloadSchedulingEnabledChanged(boolean bl) {
        Player.EventListener._CC.$default$onExperimentalOffloadSchedulingEnabledChanged((Player.EventListener)this, (boolean)bl);
    }

    @Override
    public /* synthetic */ void onExperimentalSleepingForOffloadChanged(boolean bl) {
        Player.EventListener._CC.$default$onExperimentalSleepingForOffloadChanged((Player.EventListener)this, (boolean)bl);
    }

    @Override
    public /* synthetic */ void onIsLoadingChanged(boolean bl) {
        Player.EventListener._CC.$default$onIsLoadingChanged((Player.EventListener)this, (boolean)bl);
    }

    @Override
    public /* synthetic */ void onIsPlayingChanged(boolean bl) {
        Player.EventListener._CC.$default$onIsPlayingChanged((Player.EventListener)this, (boolean)bl);
    }

    @Override
    @Deprecated
    public /* synthetic */ void onLoadingChanged(boolean bl) {
        Player.EventListener._CC.$default$onLoadingChanged((Player.EventListener)this, (boolean)bl);
    }

    @Override
    public /* synthetic */ void onMediaItemTransition(MediaItem mediaItem, int n2) {
        Player.EventListener._CC.$default$onMediaItemTransition((Player.EventListener)this, (MediaItem)mediaItem, (int)n2);
    }

    @Override
    public final void onPlayWhenReadyChanged(boolean bl, int n2) {
        this.updateAndPost();
    }

    @Override
    public /* synthetic */ void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        Player.EventListener._CC.$default$onPlaybackParametersChanged((Player.EventListener)this, (PlaybackParameters)playbackParameters);
    }

    @Override
    public final void onPlaybackStateChanged(int n2) {
        this.updateAndPost();
    }

    @Override
    public /* synthetic */ void onPlaybackSuppressionReasonChanged(int n2) {
        Player.EventListener._CC.$default$onPlaybackSuppressionReasonChanged((Player.EventListener)this, (int)n2);
    }

    @Override
    public /* synthetic */ void onPlayerError(ExoPlaybackException exoPlaybackException) {
        Player.EventListener._CC.$default$onPlayerError((Player.EventListener)this, (ExoPlaybackException)exoPlaybackException);
    }

    @Override
    @Deprecated
    public /* synthetic */ void onPlayerStateChanged(boolean bl, int n2) {
        Player.EventListener._CC.$default$onPlayerStateChanged((Player.EventListener)this, (boolean)bl, (int)n2);
    }

    @Override
    public final void onPositionDiscontinuity(int n2) {
        this.updateAndPost();
    }

    @Override
    public /* synthetic */ void onRepeatModeChanged(int n2) {
        Player.EventListener._CC.$default$onRepeatModeChanged((Player.EventListener)this, (int)n2);
    }

    @Override
    @Deprecated
    public /* synthetic */ void onSeekProcessed() {
        Player.EventListener._CC.$default$onSeekProcessed((Player.EventListener)this);
    }

    @Override
    public /* synthetic */ void onShuffleModeEnabledChanged(boolean bl) {
        Player.EventListener._CC.$default$onShuffleModeEnabledChanged((Player.EventListener)this, (boolean)bl);
    }

    @Override
    public /* synthetic */ void onStaticMetadataChanged(List<Metadata> list) {
        Player.EventListener._CC.$default$onStaticMetadataChanged((Player.EventListener)this, list);
    }

    @Override
    public /* synthetic */ void onTimelineChanged(Timeline timeline, int n2) {
        Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (int)n2);
    }

    @Override
    @Deprecated
    public /* synthetic */ void onTimelineChanged(Timeline timeline, Object object, int n2) {
        Player.EventListener._CC.$default$onTimelineChanged((Player.EventListener)this, (Timeline)timeline, (Object)object, (int)n2);
    }

    @Override
    public /* synthetic */ void onTracksChanged(TrackGroupArray trackGroupArray, TrackSelectionArray trackSelectionArray) {
        Player.EventListener._CC.$default$onTracksChanged((Player.EventListener)this, (TrackGroupArray)trackGroupArray, (TrackSelectionArray)trackSelectionArray);
    }

    @Override
    public final void run() {
        this.updateAndPost();
    }

    public final void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.player.addListener(this);
        this.updateAndPost();
    }

    public final void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.player.removeListener(this);
        this.textView.removeCallbacks((Runnable)this);
    }

    protected final void updateAndPost() {
        this.textView.setText((CharSequence)this.getDebugString());
        this.textView.removeCallbacks((Runnable)this);
        this.textView.postDelayed((Runnable)this, 1000L);
    }
}

