/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.exoplayer2.ui.R;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AspectRatioFrameLayout
extends FrameLayout {
    private static final float MAX_ASPECT_RATIO_DEFORMATION_FRACTION = 0.01f;
    public static final int RESIZE_MODE_FILL = 3;
    public static final int RESIZE_MODE_FIT = 0;
    public static final int RESIZE_MODE_FIXED_HEIGHT = 2;
    public static final int RESIZE_MODE_FIXED_WIDTH = 1;
    public static final int RESIZE_MODE_ZOOM = 4;
    private AspectRatioListener aspectRatioListener;
    private final AspectRatioUpdateDispatcher aspectRatioUpdateDispatcher;
    private int resizeMode = 0;
    private float videoAspectRatio;

    public AspectRatioFrameLayout(Context context) {
        this(context, null);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (attributeSet != null) {
            attributeSet = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.AspectRatioFrameLayout, 0, 0);
            try {
                this.resizeMode = attributeSet.getInt(R.styleable.AspectRatioFrameLayout_resize_mode, 0);
            }
            finally {
                attributeSet.recycle();
            }
        }
        this.aspectRatioUpdateDispatcher = new AspectRatioUpdateDispatcher();
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        block5: {
            block6: {
                block11: {
                    block7: {
                        block10: {
                            block8: {
                                block9: {
                                    super.onMeasure(var1_1, var2_2);
                                    if (this.videoAspectRatio <= 0.0f) {
                                        return;
                                    }
                                    var2_2 = this.getMeasuredWidth();
                                    var3_3 = var2_2;
                                    var5_5 = var3_3 / (var4_4 = (float)(var1_1 = this.getMeasuredHeight()));
                                    var6_6 = this.videoAspectRatio / var5_5 - 1.0f;
                                    if (Math.abs(var6_6) <= 0.01f) {
                                        this.aspectRatioUpdateDispatcher.scheduleUpdate(this.videoAspectRatio, var5_5, false);
                                        return;
                                    }
                                    var7_7 = this.resizeMode;
                                    if (var7_7 == 0) break block6;
                                    if (var7_7 == 1) break block7;
                                    if (var7_7 == 2) break block8;
                                    if (var7_7 != 4) break block5;
                                    if (!(var6_6 > 0.0f)) break block9;
                                    var6_6 = this.videoAspectRatio;
                                    break block10;
                                }
                                var6_6 = this.videoAspectRatio;
                                break block11;
                            }
                            var6_6 = this.videoAspectRatio;
                        }
lbl25:
                        // 2 sources

                        while (true) {
                            var2_2 = (int)(var4_4 * var6_6);
                            break block5;
                            break;
                        }
                    }
                    var6_6 = this.videoAspectRatio;
                }
lbl31:
                // 2 sources

                while (true) {
                    var1_1 = (int)(var3_3 / var6_6);
                    break block5;
                    break;
                }
            }
            if (var6_6 > 0.0f) {
                var6_6 = this.videoAspectRatio;
                ** continue;
            }
            var6_6 = this.videoAspectRatio;
            ** while (true)
        }
        this.aspectRatioUpdateDispatcher.scheduleUpdate(this.videoAspectRatio, var5_5, true);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)var2_2, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)var1_1, (int)0x40000000));
    }

    public void setAspectRatio(float f2) {
        if (this.videoAspectRatio != f2) {
            this.videoAspectRatio = f2;
            this.requestLayout();
        }
    }

    public void setAspectRatioListener(AspectRatioListener aspectRatioListener) {
        this.aspectRatioListener = aspectRatioListener;
    }

    public void setResizeMode(int n2) {
        if (this.resizeMode != n2) {
            this.resizeMode = n2;
            this.requestLayout();
        }
    }

    public static interface AspectRatioListener {
        public void onAspectRatioUpdated(float var1, float var2, boolean var3);
    }

    private final class AspectRatioUpdateDispatcher
    implements Runnable {
        private boolean aspectRatioMismatch;
        private boolean isScheduled;
        private float naturalAspectRatio;
        private float targetAspectRatio;

        private AspectRatioUpdateDispatcher() {
        }

        @Override
        public void run() {
            this.isScheduled = false;
            if (AspectRatioFrameLayout.this.aspectRatioListener == null) {
                return;
            }
            AspectRatioFrameLayout.this.aspectRatioListener.onAspectRatioUpdated(this.targetAspectRatio, this.naturalAspectRatio, this.aspectRatioMismatch);
        }

        public void scheduleUpdate(float f2, float f3, boolean bl) {
            this.targetAspectRatio = f2;
            this.naturalAspectRatio = f3;
            this.aspectRatioMismatch = bl;
            if (!this.isScheduled) {
                this.isScheduled = true;
                AspectRatioFrameLayout.this.post(this);
            }
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResizeMode {
    }
}

