/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.view.Surface;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.transformer.FrameworkMuxer;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.Transformation;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.transformer.TransformerAudioRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.transformer.TransformerVideoRenderer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public final class Transformer {
    public static final int PROGRESS_STATE_AVAILABLE = 1;
    public static final int PROGRESS_STATE_NO_TRANSFORMATION = 4;
    public static final int PROGRESS_STATE_UNAVAILABLE = 2;
    public static final int PROGRESS_STATE_WAITING_FOR_AVAILABILITY = 0;
    private final Clock clock;
    private final Context context;
    private Listener listener;
    private final Looper looper;
    private final MediaSourceFactory mediaSourceFactory;
    private final Muxer.Factory muxerFactory;
    private MuxerWrapper muxerWrapper;
    private SimpleExoPlayer player;
    private int progressState;
    private final Transformation transformation;

    private Transformer(Context context, MediaSourceFactory mediaSourceFactory, Muxer.Factory factory, Transformation transformation, Listener listener2, Looper looper, Clock clock) {
        boolean bl = !transformation.removeAudio || !transformation.removeVideo;
        Assertions.checkState(bl, "Audio and video cannot both be removed.");
        this.context = context;
        this.mediaSourceFactory = mediaSourceFactory;
        this.muxerFactory = factory;
        this.transformation = transformation;
        this.listener = listener2;
        this.looper = looper;
        this.clock = clock;
        this.progressState = 4;
    }

    static /* synthetic */ int access$902(Transformer transformer, int n2) {
        transformer.progressState = n2;
        return n2;
    }

    private void releaseResources(boolean bl) {
        this.verifyApplicationThread();
        SimpleExoPlayer simpleExoPlayer = this.player;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.release();
            this.player = null;
        }
        if ((simpleExoPlayer = this.muxerWrapper) != null) {
            simpleExoPlayer.release(bl);
            this.muxerWrapper = null;
        }
        this.progressState = 4;
    }

    private void startTransformation(MediaItem mediaItem, Muxer muxer) {
        this.verifyApplicationThread();
        if (this.player == null) {
            muxer = new MuxerWrapper(muxer);
            this.muxerWrapper = muxer;
            DefaultTrackSelector defaultTrackSelector = new DefaultTrackSelector(this.context);
            defaultTrackSelector.setParameters(new DefaultTrackSelector.ParametersBuilder(this.context).setForceHighestSupportedBitrate(true).build());
            DefaultLoadControl defaultLoadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(50000, 50000, 250, 500).build();
            this.player = new SimpleExoPlayer.Builder(this.context, new TransformerRenderersFactory((MuxerWrapper)muxer, this.transformation)).setMediaSourceFactory(this.mediaSourceFactory).setTrackSelector((TrackSelector)defaultTrackSelector).setLoadControl((LoadControl)defaultLoadControl).setLooper(this.looper).setClock(this.clock).build();
            this.player.setMediaItem(mediaItem);
            this.player.addAnalyticsListener(new TransformerAnalyticsListener(mediaItem, (MuxerWrapper)muxer));
            this.player.prepare();
            this.progressState = 0;
            return;
        }
        throw new IllegalStateException("There is already a transformation in progress.");
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() == this.looper) {
            return;
        }
        throw new IllegalStateException("Transformer is accessed on the wrong thread.");
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public void cancel() {
        this.releaseResources(true);
    }

    public Looper getApplicationLooper() {
        return this.looper;
    }

    public int getProgress(ProgressHolder progressHolder) {
        this.verifyApplicationThread();
        if (this.progressState == 1) {
            Player player = (Player)((Object)Assertions.checkNotNull(this.player));
            long l2 = player.getDuration();
            progressHolder.progress = Math.min((int)(player.getCurrentPosition() * 100L / l2), 99);
        }
        return this.progressState;
    }

    public void setListener(Listener listener2) {
        this.verifyApplicationThread();
        this.listener = listener2;
    }

    public void startTransformation(MediaItem mediaItem, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.startTransformation(mediaItem, this.muxerFactory.create(parcelFileDescriptor, this.transformation.outputMimeType));
    }

    public void startTransformation(MediaItem mediaItem, String string2) throws IOException {
        this.startTransformation(mediaItem, this.muxerFactory.create(string2, this.transformation.outputMimeType));
    }

    public static final class Builder {
        private Clock clock;
        private Context context;
        private boolean flattenForSlowMotion;
        private Listener listener;
        private Looper looper;
        private MediaSourceFactory mediaSourceFactory;
        private Muxer.Factory muxerFactory;
        private String outputMimeType;
        private boolean removeAudio;
        private boolean removeVideo;

        public Builder() {
            this.muxerFactory = new FrameworkMuxer.Factory();
            this.outputMimeType = "video/mp4";
            this.listener = new Listener(){

                @Override
                public /* synthetic */ void onTransformationCompleted(MediaItem mediaItem) {
                    Listener._CC.$default$onTransformationCompleted((Listener)this, (MediaItem)mediaItem);
                }

                @Override
                public /* synthetic */ void onTransformationError(MediaItem mediaItem, Exception exception) {
                    Listener._CC.$default$onTransformationError((Listener)this, (MediaItem)mediaItem, (Exception)exception);
                }
            };
            this.looper = Util.getCurrentOrMainLooper();
            this.clock = Clock.DEFAULT;
        }

        private Builder(Transformer transformer) {
            this.context = transformer.context;
            this.mediaSourceFactory = transformer.mediaSourceFactory;
            this.muxerFactory = transformer.muxerFactory;
            this.removeAudio = ((Transformer)transformer).transformation.removeAudio;
            this.removeVideo = ((Transformer)transformer).transformation.removeVideo;
            this.flattenForSlowMotion = ((Transformer)transformer).transformation.flattenForSlowMotion;
            this.outputMimeType = ((Transformer)transformer).transformation.outputMimeType;
            this.listener = transformer.listener;
            this.looper = transformer.looper;
            this.clock = transformer.clock;
        }

        public Transformer build() {
            Object object;
            Assertions.checkStateNotNull(this.context);
            if (this.mediaSourceFactory == null) {
                object = new DefaultExtractorsFactory();
                if (this.flattenForSlowMotion) {
                    object.setMp4ExtractorFlags(4);
                }
                this.mediaSourceFactory = new DefaultMediaSourceFactory(this.context, (ExtractorsFactory)object);
            }
            boolean bl = this.muxerFactory.supportsOutputMimeType(this.outputMimeType);
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported output MIME type: ");
            ((StringBuilder)object).append(this.outputMimeType);
            Assertions.checkState(bl, ((StringBuilder)object).toString());
            object = new Transformation(this.removeAudio, this.removeVideo, this.flattenForSlowMotion, this.outputMimeType);
            return new Transformer(this.context, this.mediaSourceFactory, this.muxerFactory, (Transformation)object, this.listener, this.looper, this.clock);
        }

        Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setContext(Context context) {
            this.context = context.getApplicationContext();
            return this;
        }

        public Builder setFlattenForSlowMotion(boolean bl) {
            this.flattenForSlowMotion = bl;
            return this;
        }

        public Builder setListener(Listener listener2) {
            this.listener = listener2;
            return this;
        }

        public Builder setLooper(Looper looper) {
            this.looper = looper;
            return this;
        }

        public Builder setMediaSourceFactory(MediaSourceFactory mediaSourceFactory) {
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        Builder setMuxerFactory(Muxer.Factory factory) {
            this.muxerFactory = factory;
            return this;
        }

        public Builder setOutputMimeType(String string2) {
            this.outputMimeType = string2;
            return this;
        }

        public Builder setRemoveAudio(boolean bl) {
            this.removeAudio = bl;
            return this;
        }

        public Builder setRemoveVideo(boolean bl) {
            this.removeVideo = bl;
            return this;
        }
    }

    public static interface Listener {
        public void onTransformationCompleted(MediaItem var1);

        public void onTransformationError(MediaItem var1, Exception var2);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgressState {
    }

    private final class TransformerAnalyticsListener
    implements AnalyticsListener {
        private final MediaItem mediaItem;
        private final MuxerWrapper muxerWrapper;

        public TransformerAnalyticsListener(MediaItem mediaItem, MuxerWrapper muxerWrapper) {
            this.mediaItem = mediaItem;
            this.muxerWrapper = muxerWrapper;
        }

        private void handleTransformationEnded(Exception exception) {
            Exception exception2;
            block4: {
                try {
                    Transformer.this.releaseResources(false);
                    exception2 = exception;
                }
                catch (IllegalStateException illegalStateException) {
                    exception2 = exception;
                    if (exception != null) break block4;
                    exception2 = illegalStateException;
                }
            }
            if (exception2 == null) {
                Transformer.this.listener.onTransformationCompleted(this.mediaItem);
            } else {
                Transformer.this.listener.onTransformationError(this.mediaItem, exception2);
            }
        }

        @Override
        public /* synthetic */ void onAudioAttributesChanged(AnalyticsListener.EventTime eventTime, AudioAttributes audioAttributes) {
            AnalyticsListener._CC.$default$onAudioAttributesChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (AudioAttributes)audioAttributes);
        }

        @Override
        public /* synthetic */ void onAudioDecoderInitialized(AnalyticsListener.EventTime eventTime, String string2, long l2) {
            AnalyticsListener._CC.$default$onAudioDecoderInitialized((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (String)string2, (long)l2);
        }

        @Override
        public /* synthetic */ void onAudioDecoderReleased(AnalyticsListener.EventTime eventTime, String string2) {
            AnalyticsListener._CC.$default$onAudioDecoderReleased((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (String)string2);
        }

        @Override
        public /* synthetic */ void onAudioDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
            AnalyticsListener._CC.$default$onAudioDisabled((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (DecoderCounters)decoderCounters);
        }

        @Override
        public /* synthetic */ void onAudioEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
            AnalyticsListener._CC.$default$onAudioEnabled((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (DecoderCounters)decoderCounters);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onAudioInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format) {
            AnalyticsListener._CC.$default$onAudioInputFormatChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Format)format);
        }

        @Override
        public /* synthetic */ void onAudioInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format, DecoderReuseEvaluation decoderReuseEvaluation) {
            AnalyticsListener._CC.$default$onAudioInputFormatChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Format)format, (DecoderReuseEvaluation)decoderReuseEvaluation);
        }

        @Override
        public /* synthetic */ void onAudioPositionAdvancing(AnalyticsListener.EventTime eventTime, long l2) {
            AnalyticsListener._CC.$default$onAudioPositionAdvancing((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (long)l2);
        }

        @Override
        public /* synthetic */ void onAudioSessionIdChanged(AnalyticsListener.EventTime eventTime, int n2) {
            AnalyticsListener._CC.$default$onAudioSessionIdChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2);
        }

        @Override
        public /* synthetic */ void onAudioSinkError(AnalyticsListener.EventTime eventTime, Exception exception) {
            AnalyticsListener._CC.$default$onAudioSinkError((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Exception)exception);
        }

        @Override
        public /* synthetic */ void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int n2, long l2, long l3) {
            AnalyticsListener._CC.$default$onAudioUnderrun((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (long)l2, (long)l3);
        }

        @Override
        public /* synthetic */ void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int n2, long l2, long l3) {
            AnalyticsListener._CC.$default$onBandwidthEstimate((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (long)l2, (long)l3);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onDecoderDisabled(AnalyticsListener.EventTime eventTime, int n2, DecoderCounters decoderCounters) {
            AnalyticsListener._CC.$default$onDecoderDisabled((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (DecoderCounters)decoderCounters);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onDecoderEnabled(AnalyticsListener.EventTime eventTime, int n2, DecoderCounters decoderCounters) {
            AnalyticsListener._CC.$default$onDecoderEnabled((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (DecoderCounters)decoderCounters);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onDecoderInitialized(AnalyticsListener.EventTime eventTime, int n2, String string2, long l2) {
            AnalyticsListener._CC.$default$onDecoderInitialized((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (String)string2, (long)l2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onDecoderInputFormatChanged(AnalyticsListener.EventTime eventTime, int n2, Format format) {
            AnalyticsListener._CC.$default$onDecoderInputFormatChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (Format)format);
        }

        @Override
        public /* synthetic */ void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
            AnalyticsListener._CC.$default$onDownstreamFormatChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (MediaLoadData)mediaLoadData);
        }

        @Override
        public /* synthetic */ void onDrmKeysLoaded(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onDrmKeysLoaded((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        public /* synthetic */ void onDrmKeysRemoved(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onDrmKeysRemoved((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        public /* synthetic */ void onDrmKeysRestored(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onDrmKeysRestored((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        public /* synthetic */ void onDrmSessionAcquired(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onDrmSessionAcquired((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        public /* synthetic */ void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception exception) {
            AnalyticsListener._CC.$default$onDrmSessionManagerError((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Exception)exception);
        }

        @Override
        public /* synthetic */ void onDrmSessionReleased(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onDrmSessionReleased((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        public /* synthetic */ void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int n2, long l2) {
            AnalyticsListener._CC.$default$onDroppedVideoFrames((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (long)l2);
        }

        @Override
        public /* synthetic */ void onEvents(Player player, AnalyticsListener.Events events) {
            AnalyticsListener._CC.$default$onEvents((AnalyticsListener)this, (Player)player, (AnalyticsListener.Events)events);
        }

        @Override
        public /* synthetic */ void onIsLoadingChanged(AnalyticsListener.EventTime eventTime, boolean bl) {
            AnalyticsListener._CC.$default$onIsLoadingChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onIsPlayingChanged(AnalyticsListener.EventTime eventTime, boolean bl) {
            AnalyticsListener._CC.$default$onIsPlayingChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onLoadCanceled(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            AnalyticsListener._CC.$default$onLoadCanceled((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (LoadEventInfo)loadEventInfo, (MediaLoadData)mediaLoadData);
        }

        @Override
        public /* synthetic */ void onLoadCompleted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            AnalyticsListener._CC.$default$onLoadCompleted((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (LoadEventInfo)loadEventInfo, (MediaLoadData)mediaLoadData);
        }

        @Override
        public /* synthetic */ void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException iOException, boolean bl) {
            AnalyticsListener._CC.$default$onLoadError((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (LoadEventInfo)loadEventInfo, (MediaLoadData)mediaLoadData, (IOException)iOException, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onLoadStarted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            AnalyticsListener._CC.$default$onLoadStarted((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (LoadEventInfo)loadEventInfo, (MediaLoadData)mediaLoadData);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onLoadingChanged(AnalyticsListener.EventTime eventTime, boolean bl) {
            AnalyticsListener._CC.$default$onLoadingChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onMediaItemTransition(AnalyticsListener.EventTime eventTime, MediaItem mediaItem, int n2) {
            AnalyticsListener._CC.$default$onMediaItemTransition((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (MediaItem)mediaItem, (int)n2);
        }

        @Override
        public /* synthetic */ void onMetadata(AnalyticsListener.EventTime eventTime, Metadata metadata) {
            AnalyticsListener._CC.$default$onMetadata((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Metadata)metadata);
        }

        @Override
        public /* synthetic */ void onPlayWhenReadyChanged(AnalyticsListener.EventTime eventTime, boolean bl, int n2) {
            AnalyticsListener._CC.$default$onPlayWhenReadyChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
            AnalyticsListener._CC.$default$onPlaybackParametersChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (PlaybackParameters)playbackParameters);
        }

        @Override
        public void onPlaybackStateChanged(AnalyticsListener.EventTime eventTime, int n2) {
            if (n2 == 4) {
                this.handleTransformationEnded(null);
            }
        }

        @Override
        public /* synthetic */ void onPlaybackSuppressionReasonChanged(AnalyticsListener.EventTime eventTime, int n2) {
            AnalyticsListener._CC.$default$onPlaybackSuppressionReasonChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2);
        }

        @Override
        public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException exoPlaybackException) {
            this.handleTransformationEnded(exoPlaybackException);
        }

        @Override
        public /* synthetic */ void onPlayerReleased(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onPlayerReleased((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onPlayerStateChanged(AnalyticsListener.EventTime eventTime, boolean bl, int n2) {
            AnalyticsListener._CC.$default$onPlayerStateChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (boolean)bl, (int)n2);
        }

        @Override
        public /* synthetic */ void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, int n2) {
            AnalyticsListener._CC.$default$onPositionDiscontinuity((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2);
        }

        @Override
        public /* synthetic */ void onRenderedFirstFrame(AnalyticsListener.EventTime eventTime, Surface surface) {
            AnalyticsListener._CC.$default$onRenderedFirstFrame((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Surface)surface);
        }

        @Override
        public /* synthetic */ void onRepeatModeChanged(AnalyticsListener.EventTime eventTime, int n2) {
            AnalyticsListener._CC.$default$onRepeatModeChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onSeekProcessed(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onSeekProcessed((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        public /* synthetic */ void onSeekStarted(AnalyticsListener.EventTime eventTime) {
            AnalyticsListener._CC.$default$onSeekStarted((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime);
        }

        @Override
        public /* synthetic */ void onShuffleModeChanged(AnalyticsListener.EventTime eventTime, boolean bl) {
            AnalyticsListener._CC.$default$onShuffleModeChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onSkipSilenceEnabledChanged(AnalyticsListener.EventTime eventTime, boolean bl) {
            AnalyticsListener._CC.$default$onSkipSilenceEnabledChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (boolean)bl);
        }

        @Override
        public /* synthetic */ void onStaticMetadataChanged(AnalyticsListener.EventTime eventTime, List<Metadata> list) {
            AnalyticsListener._CC.$default$onStaticMetadataChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, list);
        }

        @Override
        public /* synthetic */ void onSurfaceSizeChanged(AnalyticsListener.EventTime eventTime, int n2, int n3) {
            AnalyticsListener._CC.$default$onSurfaceSizeChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (int)n3);
        }

        @Override
        public void onTimelineChanged(AnalyticsListener.EventTime object, int n2) {
            if (Transformer.this.progressState != 0) {
                return;
            }
            Timeline.Window window = new Timeline.Window();
            ((AnalyticsListener.EventTime)object).timeline.getWindow(0, window);
            if (!window.isPlaceholder) {
                long l2 = window.durationUs;
                object = Transformer.this;
                n2 = l2 > 0L && l2 != -9223372036854775807L ? 1 : 2;
                Transformer.access$902((Transformer)object, n2);
                Assertions.checkNotNull(Transformer.this.player).play();
            }
        }

        @Override
        public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray trackGroupArray, TrackSelectionArray trackSelectionArray) {
            if (this.muxerWrapper.getTrackCount() == 0) {
                this.handleTransformationEnded(new IllegalStateException("The output does not contain any tracks. Check that at least one of the input sample formats is supported."));
            }
        }

        @Override
        public /* synthetic */ void onUpstreamDiscarded(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
            AnalyticsListener._CC.$default$onUpstreamDiscarded((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (MediaLoadData)mediaLoadData);
        }

        @Override
        public /* synthetic */ void onVideoDecoderInitialized(AnalyticsListener.EventTime eventTime, String string2, long l2) {
            AnalyticsListener._CC.$default$onVideoDecoderInitialized((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (String)string2, (long)l2);
        }

        @Override
        public /* synthetic */ void onVideoDecoderReleased(AnalyticsListener.EventTime eventTime, String string2) {
            AnalyticsListener._CC.$default$onVideoDecoderReleased((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (String)string2);
        }

        @Override
        public /* synthetic */ void onVideoDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
            AnalyticsListener._CC.$default$onVideoDisabled((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (DecoderCounters)decoderCounters);
        }

        @Override
        public /* synthetic */ void onVideoEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
            AnalyticsListener._CC.$default$onVideoEnabled((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (DecoderCounters)decoderCounters);
        }

        @Override
        public /* synthetic */ void onVideoFrameProcessingOffset(AnalyticsListener.EventTime eventTime, long l2, int n2) {
            AnalyticsListener._CC.$default$onVideoFrameProcessingOffset((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (long)l2, (int)n2);
        }

        @Override
        @Deprecated
        public /* synthetic */ void onVideoInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format) {
            AnalyticsListener._CC.$default$onVideoInputFormatChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Format)format);
        }

        @Override
        public /* synthetic */ void onVideoInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format, DecoderReuseEvaluation decoderReuseEvaluation) {
            AnalyticsListener._CC.$default$onVideoInputFormatChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (Format)format, (DecoderReuseEvaluation)decoderReuseEvaluation);
        }

        @Override
        public /* synthetic */ void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, int n2, int n3, int n4, float f2) {
            AnalyticsListener._CC.$default$onVideoSizeChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (int)n2, (int)n3, (int)n4, (float)f2);
        }

        @Override
        public /* synthetic */ void onVolumeChanged(AnalyticsListener.EventTime eventTime, float f2) {
            AnalyticsListener._CC.$default$onVolumeChanged((AnalyticsListener)this, (AnalyticsListener.EventTime)eventTime, (float)f2);
        }
    }

    private static final class TransformerRenderersFactory
    implements RenderersFactory {
        private final TransformerMediaClock mediaClock;
        private final MuxerWrapper muxerWrapper;
        private final Transformation transformation;

        public TransformerRenderersFactory(MuxerWrapper muxerWrapper, Transformation transformation) {
            this.muxerWrapper = muxerWrapper;
            this.transformation = transformation;
            this.mediaClock = new TransformerMediaClock();
        }

        public Renderer[] createRenderers(Handler rendererArray, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textOutput, MetadataOutput metadataOutput) {
            boolean bl = this.transformation.removeAudio;
            int n2 = 1;
            int n3 = !bl && !this.transformation.removeVideo ? 2 : 1;
            rendererArray = new Renderer[n3];
            if (!this.transformation.removeAudio) {
                rendererArray[0] = new TransformerAudioRenderer(this.muxerWrapper, this.mediaClock, this.transformation);
                n3 = n2;
            } else {
                n3 = 0;
            }
            if (!this.transformation.removeVideo) {
                rendererArray[n3] = new TransformerVideoRenderer(this.muxerWrapper, this.mediaClock, this.transformation);
            }
            return rendererArray;
        }
    }
}

