/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.mp4.SlowMotionData;
import com.google.android.exoplayer2.metadata.mp4.SmtaMetadataEntry;
import com.google.android.exoplayer2.transformer.SampleTransformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class SefSlowMotionVideoSampleTransformer
implements SampleTransformer {
    static final int INPUT_FRAME_RATE = 30;
    private static final int NAL_START_CODE_LENGTH = NalUnitUtil.NAL_START_CODE.length;
    private static final int NAL_UNIT_TYPE_PREFIX = 14;
    private static final int TARGET_OUTPUT_FRAME_RATE = 30;
    private final float captureFrameRate;
    private SegmentInfo currentSegmentInfo;
    private long frameTimeDeltaUs;
    private final int inputMaxLayer;
    private SegmentInfo nextSegmentInfo;
    private final int normalSpeedMaxLayer;
    private final byte[] scratch = new byte[NAL_START_CODE_LENGTH];
    private final Iterator<SlowMotionData.Segment> segmentIterator;
    private final SlowMotionData slowMotionData;

    public SefSlowMotionVideoSampleTransformer(Format format) {
        MetadataInfo metadataInfo = SefSlowMotionVideoSampleTransformer.getMetadataInfo(format.metadata);
        this.slowMotionData = metadataInfo.slowMotionData;
        Object object = this.slowMotionData;
        object = object != null ? ((SlowMotionData)object).segments : ImmutableList.of();
        this.segmentIterator = object.iterator();
        this.captureFrameRate = metadataInfo.captureFrameRate;
        this.inputMaxLayer = metadataInfo.inputMaxLayer;
        this.normalSpeedMaxLayer = metadataInfo.normalSpeedMaxLayer;
        object = this.segmentIterator.hasNext() ? new SegmentInfo(this.segmentIterator.next(), this.inputMaxLayer, this.normalSpeedMaxLayer) : null;
        this.nextSegmentInfo = object;
        if (this.slowMotionData != null) {
            boolean bl = "video/avc".equals(format.sampleMimeType);
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported MIME type for SEF slow motion video track: ");
            ((StringBuilder)object).append(format.sampleMimeType);
            Assertions.checkArgument(bl, ((StringBuilder)object).toString());
        }
    }

    private void enterNextSegment() {
        if (this.currentSegmentInfo != null) {
            this.leaveCurrentSegment();
        }
        this.currentSegmentInfo = this.nextSegmentInfo;
        SegmentInfo segmentInfo = this.segmentIterator.hasNext() ? new SegmentInfo(this.segmentIterator.next(), this.inputMaxLayer, this.normalSpeedMaxLayer) : null;
        this.nextSegmentInfo = segmentInfo;
    }

    private static MetadataInfo getMetadataInfo(Metadata object) {
        int n2;
        MetadataInfo metadataInfo = new MetadataInfo();
        if (object == null) {
            return metadataInfo;
        }
        boolean bl = false;
        for (n2 = 0; n2 < object.length(); ++n2) {
            Metadata.Entry entry = object.get(n2);
            if (entry instanceof SmtaMetadataEntry) {
                entry = (SmtaMetadataEntry)entry;
                metadataInfo.captureFrameRate = entry.captureFrameRate;
                metadataInfo.inputMaxLayer = entry.svcTemporalLayerCount - 1;
                continue;
            }
            if (!(entry instanceof SlowMotionData)) continue;
            metadataInfo.slowMotionData = (SlowMotionData)entry;
        }
        if (metadataInfo.slowMotionData == null) {
            return metadataInfo;
        }
        boolean bl2 = metadataInfo.inputMaxLayer != -1;
        Assertions.checkState(bl2, "SVC temporal layer count not found.");
        bl2 = metadataInfo.captureFrameRate != -3.4028235E38f;
        Assertions.checkState(bl2, "Capture frame rate not found.");
        bl2 = metadataInfo.captureFrameRate % 1.0f == 0.0f && metadataInfo.captureFrameRate % 30.0f == 0.0f;
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid capture frame rate: ");
        ((StringBuilder)object).append(metadataInfo.captureFrameRate);
        Assertions.checkState(bl2, ((StringBuilder)object).toString());
        n2 = (int)metadataInfo.captureFrameRate / 30;
        for (int i2 = metadataInfo.inputMaxLayer; i2 >= 0; --i2) {
            if ((n2 & 1) == 1) {
                bl2 = bl;
                if (n2 >> 1 == 0) {
                    bl2 = true;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Could not compute normal speed max SVC layer for capture frame rate  ");
                ((StringBuilder)object).append(metadataInfo.captureFrameRate);
                Assertions.checkState(bl2, ((StringBuilder)object).toString());
                metadataInfo.normalSpeedMaxLayer = i2;
                break;
            }
            n2 >>= 1;
        }
        return metadataInfo;
    }

    @RequiresNonNull(value={"currentSegmentInfo"})
    private void leaveCurrentSegment() {
        this.frameTimeDeltaUs += (this.currentSegmentInfo.endTimeUs - this.currentSegmentInfo.startTimeUs) * (long)(this.currentSegmentInfo.speedDivisor - 1);
        this.currentSegmentInfo = null;
    }

    private boolean shouldKeepFrameForOutputValidity(int n2, long l2) {
        SegmentInfo segmentInfo = this.nextSegmentInfo;
        if (segmentInfo != null && n2 < segmentInfo.maxLayer) {
            l2 = (this.nextSegmentInfo.startTimeUs - l2) * 30L / 1000000L;
            float f2 = -(1 << this.inputMaxLayer - this.nextSegmentInfo.maxLayer);
            for (int i2 = 1; i2 < this.nextSegmentInfo.maxLayer && (float)l2 < (float)(1 << this.inputMaxLayer - i2) + (f2 + 0.45f); ++i2) {
                if (n2 > i2) continue;
                return true;
            }
        }
        return false;
    }

    private void skipToNextNalUnit(ByteBuffer object) {
        int n2;
        int n3;
        int n4 = ((Buffer)object).position();
        while ((n3 = ((Buffer)object).remaining()) >= (n2 = NAL_START_CODE_LENGTH)) {
            ((ByteBuffer)object).get(this.scratch, 0, n2);
            if (Arrays.equals(this.scratch, NalUnitUtil.NAL_START_CODE)) {
                ((ByteBuffer)object).position(n4);
                return;
            }
            ((ByteBuffer)object).position(++n4);
        }
        object = new IllegalStateException("Could not find NAL unit start code.");
        throw object;
    }

    long getCurrentFrameOutputTimeUs(long l2) {
        long l3 = this.frameTimeDeltaUs + l2;
        SegmentInfo segmentInfo = this.currentSegmentInfo;
        long l4 = l3;
        if (segmentInfo != null) {
            l4 = l3 + (l2 - segmentInfo.startTimeUs) * (long)(this.currentSegmentInfo.speedDivisor - 1);
        }
        return Math.round((float)(l4 * 30L) / this.captureFrameRate);
    }

    boolean processCurrentFrame(int n2, long l2) {
        SegmentInfo segmentInfo;
        while ((segmentInfo = this.nextSegmentInfo) != null && l2 >= segmentInfo.endTimeUs) {
            this.enterNextSegment();
        }
        segmentInfo = this.nextSegmentInfo;
        if (segmentInfo != null && l2 >= segmentInfo.startTimeUs) {
            this.enterNextSegment();
        } else {
            segmentInfo = this.currentSegmentInfo;
            if (segmentInfo != null && l2 >= segmentInfo.endTimeUs) {
                this.leaveCurrentSegment();
            }
        }
        segmentInfo = this.currentSegmentInfo;
        int n3 = segmentInfo != null ? segmentInfo.maxLayer : this.normalSpeedMaxLayer;
        boolean bl = n2 <= n3 || this.shouldKeepFrameForOutputValidity(n2, l2);
        return bl;
    }

    @Override
    public void transformSample(DecoderInputBuffer decoderInputBuffer) {
        if (this.slowMotionData == null) {
            return;
        }
        ByteBuffer byteBuffer = Util.castNonNull(decoderInputBuffer.data);
        byteBuffer.position(byteBuffer.position() + NAL_START_CODE_LENGTH);
        byte[] byArray = this.scratch;
        boolean bl = false;
        byteBuffer.get(byArray, 0, 4);
        byArray = this.scratch;
        byte by2 = byArray[0];
        boolean bl2 = (byArray[1] & 0xFF) >> 7 == 1;
        boolean bl3 = bl;
        if ((by2 & 0x1F) == 14) {
            bl3 = bl;
            if (bl2) {
                bl3 = true;
            }
        }
        Assertions.checkState(bl3, "Missing SVC extension prefix NAL unit.");
        if (this.processCurrentFrame((this.scratch[3] & 0xFF) >> 5, decoderInputBuffer.timeUs)) {
            decoderInputBuffer.timeUs = this.getCurrentFrameOutputTimeUs(decoderInputBuffer.timeUs);
            this.skipToNextNalUnit(byteBuffer);
        } else {
            decoderInputBuffer.data = null;
        }
    }

    private static final class MetadataInfo {
        public float captureFrameRate = -3.4028235E38f;
        public int inputMaxLayer = -1;
        public int normalSpeedMaxLayer = -1;
        public SlowMotionData slowMotionData;
    }

    private static final class SegmentInfo {
        public final long endTimeUs;
        public final int maxLayer;
        public final int speedDivisor;
        public final long startTimeUs;

        public SegmentInfo(SlowMotionData.Segment segment, int n2, int n3) {
            this.startTimeUs = C.msToUs(segment.startTimeMs);
            this.endTimeUs = C.msToUs(segment.endTimeMs);
            this.speedDivisor = segment.speedDivisor;
            this.maxLayer = SegmentInfo.getSlowMotionMaxLayer(this.speedDivisor, n2, n3);
        }

        private static int getSlowMotionMaxLayer(int n2, int n3, int n4) {
            int n5 = n4;
            for (n4 = n2; n4 > 0; n4 >>= 1) {
                boolean bl = true;
                if ((n4 & 1) == 1) {
                    if (n4 >> 1 != 0) {
                        bl = false;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Invalid speed divisor: ");
                    stringBuilder.append(n2);
                    Assertions.checkState(bl, stringBuilder.toString());
                    break;
                }
                ++n5;
            }
            return Math.min(n5, n3);
        }
    }
}

