/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.mediacodec.MediaCodecAdapter;
import com.google.android.exoplayer2.mediacodec.MediaFormatUtil;
import com.google.android.exoplayer2.mediacodec.SynchronousMediaCodecAdapter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

final class MediaCodecAdapterWrapper {
    private static final int MEDIA_CODEC_PCM_ENCODING = 2;
    private final MediaCodecAdapter codec;
    private int inputBufferIndex;
    private boolean inputStreamEnded;
    private ByteBuffer outputBuffer;
    private int outputBufferIndex;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private Format outputFormat;
    private boolean outputStreamEnded;

    private MediaCodecAdapterWrapper(MediaCodecAdapter mediaCodecAdapter) {
        this.codec = mediaCodecAdapter;
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.inputBufferIndex = -1;
        this.outputBufferIndex = -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaCodecAdapterWrapper createForAudioDecoding(Format object) throws IOException {
        MediaCodec mediaCodec;
        Object object2;
        block7: {
            MediaFormat mediaFormat;
            object2 = null;
            try {
                mediaCodec = MediaCodec.createDecoderByType((String)Assertions.checkNotNull(((Format)object).sampleMimeType));
            }
            catch (Exception exception) {
                mediaCodec = null;
                break block7;
            }
            try {
                mediaFormat = MediaFormat.createAudioFormat((String)((Format)object).sampleMimeType, (int)((Format)object).sampleRate, (int)((Format)object).channelCount);
                MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)((Format)object).maxInputSize);
                MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)((Format)object).initializationData);
                object = new SynchronousMediaCodecAdapter.Factory();
                object = object.createAdapter(mediaCodec);
            }
            catch (Exception exception) {
                break block7;
            }
            try {
                object.configure(mediaFormat, null, null, 0);
                object.start();
                return new MediaCodecAdapterWrapper((MediaCodecAdapter)object);
            }
            catch (Exception exception) {
                object2 = object;
                object = exception;
            }
        }
        if (object2 == null) {
            if (mediaCodec == null) throw object;
            mediaCodec.release();
            throw object;
        }
        object2.release();
        throw object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaCodecAdapterWrapper createForAudioEncoding(Format object) throws IOException {
        MediaCodec mediaCodec;
        Object object2;
        block7: {
            MediaFormat mediaFormat;
            object2 = null;
            try {
                mediaCodec = MediaCodec.createEncoderByType((String)Assertions.checkNotNull(((Format)object).sampleMimeType));
            }
            catch (Exception exception) {
                mediaCodec = null;
                break block7;
            }
            try {
                mediaFormat = MediaFormat.createAudioFormat((String)((Format)object).sampleMimeType, (int)((Format)object).sampleRate, (int)((Format)object).channelCount);
                mediaFormat.setInteger("bitrate", ((Format)object).bitrate);
                object = new SynchronousMediaCodecAdapter.Factory();
                object = object.createAdapter(mediaCodec);
            }
            catch (Exception exception) {
                break block7;
            }
            try {
                object.configure(mediaFormat, null, null, 1);
                object.start();
                return new MediaCodecAdapterWrapper((MediaCodecAdapter)object);
            }
            catch (Exception exception) {
                object2 = object;
                object = exception;
            }
        }
        if (object2 == null) {
            if (mediaCodec == null) throw object;
            mediaCodec.release();
            throw object;
        }
        object2.release();
        throw object;
    }

    private static Format getFormat(MediaFormat mediaFormat) {
        Format.Builder builder = new ImmutableList.Builder();
        int n2 = 0;
        while (true) {
            Object object = new StringBuilder();
            ((StringBuilder)object).append("csd-");
            ((StringBuilder)object).append(n2);
            ByteBuffer byteBuffer = mediaFormat.getByteBuffer(((StringBuilder)object).toString());
            if (byteBuffer == null) {
                object = mediaFormat.getString("mime");
                builder = new Format.Builder().setSampleMimeType(mediaFormat.getString("mime")).setInitializationData((List)((Object)builder.build()));
                if (MimeTypes.isVideo((String)object)) {
                    builder.setWidth(mediaFormat.getInteger("width")).setHeight(mediaFormat.getInteger("height"));
                } else if (MimeTypes.isAudio((String)object)) {
                    builder.setChannelCount(mediaFormat.getInteger("channel-count")).setSampleRate(mediaFormat.getInteger("sample-rate")).setPcmEncoding(2);
                }
                return builder.build();
            }
            object = new byte[byteBuffer.remaining()];
            byteBuffer.get((byte[])object);
            builder.add(object);
            ++n2;
        }
    }

    private boolean maybeDequeueOutputBuffer() {
        if (this.outputBufferIndex >= 0) {
            return true;
        }
        if (this.outputStreamEnded) {
            return false;
        }
        this.outputBufferIndex = this.codec.dequeueOutputBufferIndex(this.outputBufferInfo);
        int n2 = this.outputBufferIndex;
        if (n2 < 0) {
            if (n2 == -2) {
                this.outputFormat = MediaCodecAdapterWrapper.getFormat(this.codec.getOutputFormat());
            }
            return false;
        }
        if ((this.outputBufferInfo.flags & 4) != 0) {
            this.outputStreamEnded = true;
            if (this.outputBufferInfo.size == 0) {
                this.releaseOutputBuffer();
                return false;
            }
        }
        if ((this.outputBufferInfo.flags & 2) != 0) {
            this.releaseOutputBuffer();
            return false;
        }
        this.outputBuffer = Assertions.checkNotNull(this.codec.getOutputBuffer(this.outputBufferIndex));
        this.outputBuffer.position(this.outputBufferInfo.offset);
        this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
        return true;
    }

    public ByteBuffer getOutputBuffer() {
        ByteBuffer byteBuffer = this.maybeDequeueOutputBuffer() ? this.outputBuffer : null;
        return byteBuffer;
    }

    public MediaCodec.BufferInfo getOutputBufferInfo() {
        MediaCodec.BufferInfo bufferInfo = this.maybeDequeueOutputBuffer() ? this.outputBufferInfo : null;
        return bufferInfo;
    }

    public Format getOutputFormat() {
        this.maybeDequeueOutputBuffer();
        return this.outputFormat;
    }

    public boolean isEnded() {
        boolean bl = this.outputStreamEnded && this.outputBufferIndex == -1;
        return bl;
    }

    @EnsuresNonNullIf(expression={"#1.data"}, result=true)
    public boolean maybeDequeueInputBuffer(DecoderInputBuffer decoderInputBuffer) {
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputBufferIndex < 0) {
            this.inputBufferIndex = this.codec.dequeueInputBufferIndex();
            int n2 = this.inputBufferIndex;
            if (n2 < 0) {
                return false;
            }
            decoderInputBuffer.data = this.codec.getInputBuffer(n2);
            decoderInputBuffer.clear();
        }
        Assertions.checkNotNull(decoderInputBuffer.data);
        return true;
    }

    public void queueInputBuffer(DecoderInputBuffer decoderInputBuffer) {
        int n2;
        int n3;
        int n4;
        Assertions.checkState(this.inputStreamEnded ^ true, "Input buffer can not be queued after the input stream has ended.");
        if (decoderInputBuffer.data != null && decoderInputBuffer.data.hasRemaining()) {
            n4 = decoderInputBuffer.data.position();
            n3 = decoderInputBuffer.data.remaining();
        } else {
            n4 = 0;
            n3 = 0;
        }
        if (decoderInputBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            n2 = 4;
        } else {
            n2 = 0;
        }
        this.codec.queueInputBuffer(this.inputBufferIndex, n4, n3, decoderInputBuffer.timeUs, n2);
        this.inputBufferIndex = -1;
        decoderInputBuffer.data = null;
    }

    public void release() {
        this.outputBuffer = null;
        this.codec.release();
    }

    public void releaseOutputBuffer() {
        this.outputBuffer = null;
        this.codec.releaseOutputBuffer(this.outputBufferIndex, false);
        this.outputBufferIndex = -1;
    }
}

