/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.content.Context;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Locale;

public class TrackSelectionParameters
implements Parcelable {
    public static final Parcelable.Creator<TrackSelectionParameters> CREATOR;
    @Deprecated
    public static final TrackSelectionParameters DEFAULT;
    public static final TrackSelectionParameters DEFAULT_WITHOUT_CONTEXT;
    public final int disabledTextTrackSelectionFlags;
    public final ImmutableList<String> preferredAudioLanguages;
    public final int preferredAudioRoleFlags;
    public final ImmutableList<String> preferredTextLanguages;
    public final int preferredTextRoleFlags;
    public final boolean selectUndeterminedTextLanguage;

    static {
        DEFAULT = DEFAULT_WITHOUT_CONTEXT = new Builder().build();
        CREATOR = new Parcelable.Creator<TrackSelectionParameters>(){

            public TrackSelectionParameters createFromParcel(Parcel parcel) {
                return new TrackSelectionParameters(parcel);
            }

            public TrackSelectionParameters[] newArray(int n2) {
                return new TrackSelectionParameters[n2];
            }
        };
    }

    TrackSelectionParameters(Parcel parcel) {
        ArrayList arrayList = new ArrayList();
        parcel.readList(arrayList, null);
        this.preferredAudioLanguages = ImmutableList.copyOf(arrayList);
        this.preferredAudioRoleFlags = parcel.readInt();
        arrayList = new ArrayList();
        parcel.readList(arrayList, null);
        this.preferredTextLanguages = ImmutableList.copyOf(arrayList);
        this.preferredTextRoleFlags = parcel.readInt();
        this.selectUndeterminedTextLanguage = Util.readBoolean(parcel);
        this.disabledTextTrackSelectionFlags = parcel.readInt();
    }

    TrackSelectionParameters(ImmutableList<String> immutableList, int n2, ImmutableList<String> immutableList2, int n3, boolean bl, int n4) {
        this.preferredAudioLanguages = immutableList;
        this.preferredAudioRoleFlags = n2;
        this.preferredTextLanguages = immutableList2;
        this.preferredTextRoleFlags = n3;
        this.selectUndeterminedTextLanguage = bl;
        this.disabledTextTrackSelectionFlags = n4;
    }

    public static TrackSelectionParameters getDefaults(Context context) {
        return new Builder(context).build();
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (TrackSelectionParameters)object;
            if (!this.preferredAudioLanguages.equals(((TrackSelectionParameters)object).preferredAudioLanguages) || this.preferredAudioRoleFlags != ((TrackSelectionParameters)object).preferredAudioRoleFlags || !this.preferredTextLanguages.equals(((TrackSelectionParameters)object).preferredTextLanguages) || this.preferredTextRoleFlags != ((TrackSelectionParameters)object).preferredTextRoleFlags || this.selectUndeterminedTextLanguage != ((TrackSelectionParameters)object).selectUndeterminedTextLanguage || this.disabledTextTrackSelectionFlags != ((TrackSelectionParameters)object).disabledTextTrackSelectionFlags) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return (((((this.preferredAudioLanguages.hashCode() + 31) * 31 + this.preferredAudioRoleFlags) * 31 + this.preferredTextLanguages.hashCode()) * 31 + this.preferredTextRoleFlags) * 31 + this.selectUndeterminedTextLanguage) * 31 + this.disabledTextTrackSelectionFlags;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeList(this.preferredAudioLanguages);
        parcel.writeInt(this.preferredAudioRoleFlags);
        parcel.writeList(this.preferredTextLanguages);
        parcel.writeInt(this.preferredTextRoleFlags);
        Util.writeBoolean(parcel, this.selectUndeterminedTextLanguage);
        parcel.writeInt(this.disabledTextTrackSelectionFlags);
    }

    public static class Builder {
        int disabledTextTrackSelectionFlags;
        ImmutableList<String> preferredAudioLanguages;
        int preferredAudioRoleFlags;
        ImmutableList<String> preferredTextLanguages;
        int preferredTextRoleFlags;
        boolean selectUndeterminedTextLanguage;

        @Deprecated
        public Builder() {
            this.preferredAudioLanguages = ImmutableList.of();
            this.preferredAudioRoleFlags = 0;
            this.preferredTextLanguages = ImmutableList.of();
            this.preferredTextRoleFlags = 0;
            this.selectUndeterminedTextLanguage = false;
            this.disabledTextTrackSelectionFlags = 0;
        }

        public Builder(Context context) {
            this();
            this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
        }

        Builder(TrackSelectionParameters trackSelectionParameters) {
            this.preferredAudioLanguages = trackSelectionParameters.preferredAudioLanguages;
            this.preferredAudioRoleFlags = trackSelectionParameters.preferredAudioRoleFlags;
            this.preferredTextLanguages = trackSelectionParameters.preferredTextLanguages;
            this.preferredTextRoleFlags = trackSelectionParameters.preferredTextRoleFlags;
            this.selectUndeterminedTextLanguage = trackSelectionParameters.selectUndeterminedTextLanguage;
            this.disabledTextTrackSelectionFlags = trackSelectionParameters.disabledTextTrackSelectionFlags;
        }

        private void setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(Context object) {
            if (Util.SDK_INT < 23 && Looper.myLooper() == null) {
                return;
            }
            if ((object = (CaptioningManager)object.getSystemService("captioning")) != null && object.isEnabled()) {
                this.preferredTextRoleFlags = 1088;
                if ((object = object.getLocale()) != null) {
                    this.preferredTextLanguages = ImmutableList.of(Util.getLocaleLanguageTag((Locale)object));
                }
            }
        }

        public TrackSelectionParameters build() {
            return new TrackSelectionParameters(this.preferredAudioLanguages, this.preferredAudioRoleFlags, this.preferredTextLanguages, this.preferredTextRoleFlags, this.selectUndeterminedTextLanguage, this.disabledTextTrackSelectionFlags);
        }

        public Builder setDisabledTextTrackSelectionFlags(int n2) {
            this.disabledTextTrackSelectionFlags = n2;
            return this;
        }

        public Builder setPreferredAudioLanguage(String object) {
            object = object == null ? this.setPreferredAudioLanguages(new String[0]) : this.setPreferredAudioLanguages(new String[]{object});
            return object;
        }

        public Builder setPreferredAudioLanguages(String ... stringArray) {
            ImmutableList.Builder builder = ImmutableList.builder();
            stringArray = Assertions.checkNotNull(stringArray);
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                builder.add(Util.normalizeLanguageCode(Assertions.checkNotNull(stringArray[i2])));
            }
            this.preferredAudioLanguages = builder.build();
            return this;
        }

        public Builder setPreferredAudioRoleFlags(int n2) {
            this.preferredAudioRoleFlags = n2;
            return this;
        }

        public Builder setPreferredTextLanguage(String object) {
            object = object == null ? this.setPreferredTextLanguages(new String[0]) : this.setPreferredTextLanguages(new String[]{object});
            return object;
        }

        public Builder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            if (Util.SDK_INT >= 19) {
                this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(context);
            }
            return this;
        }

        public Builder setPreferredTextLanguages(String ... stringArray) {
            ImmutableList.Builder builder = ImmutableList.builder();
            stringArray = Assertions.checkNotNull(stringArray);
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                builder.add(Util.normalizeLanguageCode(Assertions.checkNotNull(stringArray[i2])));
            }
            this.preferredTextLanguages = builder.build();
            return this;
        }

        public Builder setPreferredTextRoleFlags(int n2) {
            this.preferredTextRoleFlags = n2;
            return this;
        }

        public Builder setSelectUndeterminedTextLanguage(boolean bl) {
            this.selectUndeterminedTextLanguage = bl;
            return this;
        }
    }
}

