/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.content.Context;
import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.RendererCapabilities$_CC;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.trackselection._$;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public class DefaultTrackSelector
extends MappingTrackSelector {
    private static final Ordering<Integer> FORMAT_VALUE_ORDERING;
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;
    private static final Ordering<Integer> NO_ORDER;
    private static final int[] NO_TRACKS;
    private final AtomicReference<Parameters> parametersReference;
    private final ExoTrackSelection.Factory trackSelectionFactory;

    static {
        NO_TRACKS = new int[0];
        FORMAT_VALUE_ORDERING = Ordering.from(_$.Lambda.DefaultTrackSelector.gh9ENrJWQNcjWuI1Z_gGyXt_1Q0.INSTANCE);
        NO_ORDER = Ordering.from(_$.Lambda.DefaultTrackSelector.lrZL_zTAASesn9_0AYwE4dMwJKI.INSTANCE);
    }

    @Deprecated
    public DefaultTrackSelector() {
        this(Parameters.DEFAULT_WITHOUT_CONTEXT, (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory());
    }

    public DefaultTrackSelector(Context context) {
        this(context, (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory());
    }

    public DefaultTrackSelector(Context context, ExoTrackSelection.Factory factory) {
        this(Parameters.getDefaults(context), factory);
    }

    public DefaultTrackSelector(Parameters parameters, ExoTrackSelection.Factory factory) {
        this.trackSelectionFactory = factory;
        this.parametersReference = new AtomicReference<Parameters>(parameters);
    }

    @Deprecated
    public DefaultTrackSelector(ExoTrackSelection.Factory factory) {
        this(Parameters.DEFAULT_WITHOUT_CONTEXT, factory);
    }

    private static void filterAdaptiveVideoTrackCountForMimeType(TrackGroup trackGroup, int[] nArray, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, List<Integer> list) {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            int n11 = list.get(i2);
            if (DefaultTrackSelector.isSupportedAdaptiveVideoTrack(trackGroup.getFormat(n11), string2, nArray[n11], n2, n3, n4, n5, n6, n7, n8, n9, n10)) continue;
            list.remove(i2);
        }
    }

    private static int[] getAdaptiveAudioTracks(TrackGroup trackGroup, int[] nArray, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        Format format = trackGroup.getFormat(n2);
        int[] nArray2 = new int[trackGroup.length];
        int n4 = 0;
        for (int i2 = 0; i2 < trackGroup.length; ++i2) {
            int n5;
            block4: {
                block3: {
                    if (i2 == n2) break block3;
                    n5 = n4;
                    if (!DefaultTrackSelector.isSupportedAdaptiveAudioTrack(trackGroup.getFormat(i2), nArray[i2], format, n3, bl, bl2, bl3)) break block4;
                }
                nArray2[n4] = i2;
                n5 = n4 + 1;
            }
            n4 = n5;
        }
        return Arrays.copyOf(nArray2, n4);
    }

    private static int getAdaptiveVideoTrackCountForMimeType(TrackGroup trackGroup, int[] nArray, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, List<Integer> list) {
        int n11 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n12 = list.get(i2);
            int n13 = n11;
            if (DefaultTrackSelector.isSupportedAdaptiveVideoTrack(trackGroup.getFormat(n12), string2, nArray[n12], n2, n3, n4, n5, n6, n7, n8, n9, n10)) {
                n13 = n11 + 1;
            }
            n11 = n13;
        }
        return n11;
    }

    private static int[] getAdaptiveVideoTracksForGroup(TrackGroup object, int[] nArray, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl2) {
        String string2;
        if (((TrackGroup)object).length < 2) {
            return NO_TRACKS;
        }
        List<Integer> list = DefaultTrackSelector.getViewportFilteredTrackIndices((TrackGroup)object, n11, n12, bl2);
        if (list.size() < 2) {
            return NO_TRACKS;
        }
        if (!bl) {
            HashSet<String> hashSet = new HashSet<String>();
            string2 = null;
            n11 = 0;
            for (n12 = 0; n12 < list.size(); ++n12) {
                int n13;
                String string3 = object.getFormat((int)list.get((int)n12).intValue()).sampleMimeType;
                if (!hashSet.add(string3) || (n13 = DefaultTrackSelector.getAdaptiveVideoTrackCountForMimeType((TrackGroup)object, nArray, n2, string3, n3, n4, n5, n6, n7, n8, n9, n10, list)) <= n11) continue;
                n11 = n13;
                string2 = string3;
            }
        } else {
            string2 = null;
        }
        DefaultTrackSelector.filterAdaptiveVideoTrackCountForMimeType((TrackGroup)object, nArray, n2, string2, n3, n4, n5, n6, n7, n8, n9, n10, list);
        object = list.size() < 2 ? (Object)NO_TRACKS : (Object)Ints.toArray(list);
        return object;
    }

    protected static int getFormatLanguageScore(Format object, String string2, boolean bl) {
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.equals(((Format)object).language)) {
            return 4;
        }
        string2 = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(string2);
        object = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(((Format)object).language);
        int n2 = 0;
        if (object != null && string2 != null) {
            if (!((String)object).startsWith(string2) && !string2.startsWith((String)object)) {
                if (Util.splitAtFirst((String)object, "-")[0].equals(Util.splitAtFirst(string2, "-")[0])) {
                    return 2;
                }
                return 0;
            }
            return 3;
        }
        int n3 = n2;
        if (bl) {
            n3 = n2;
            if (object == null) {
                n3 = 1;
            }
        }
        return n3;
    }

    private static Point getMaxVideoSizeInViewport(boolean bl, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        block6: {
            block5: {
                if (!bl) break block5;
                n7 = 1;
                n6 = n4 > n5 ? 1 : 0;
                if (n2 <= n3) {
                    n7 = 0;
                }
                if (n6 != n7) break block6;
            }
            n6 = n3;
            n3 = n2;
            n2 = n6;
        }
        n6 = n4 * n2;
        n7 = n5 * n3;
        if (n6 >= n7) {
            return new Point(n3, Util.ceilDivide(n7, n4));
        }
        return new Point(Util.ceilDivide(n6, n5), n2);
    }

    private static List<Integer> getViewportFilteredTrackIndices(TrackGroup trackGroup, int n2, int n3, boolean bl) {
        int n4;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(trackGroup.length);
        int n5 = 0;
        for (n4 = 0; n4 < trackGroup.length; ++n4) {
            arrayList.add(n4);
        }
        if (n2 != Integer.MAX_VALUE && n3 != Integer.MAX_VALUE) {
            n4 = Integer.MAX_VALUE;
            while (n5 < trackGroup.length) {
                Format format = trackGroup.getFormat(n5);
                int n6 = n4;
                if (format.width > 0) {
                    n6 = n4;
                    if (format.height > 0) {
                        Point point = DefaultTrackSelector.getMaxVideoSizeInViewport(bl, n2, n3, format.width, format.height);
                        int n7 = format.width * format.height;
                        n6 = n4;
                        if (format.width >= (int)((float)point.x * 0.98f)) {
                            n6 = n4;
                            if (format.height >= (int)((float)point.y * 0.98f)) {
                                n6 = n4;
                                if (n7 < n4) {
                                    n6 = n7;
                                }
                            }
                        }
                    }
                }
                ++n5;
                n4 = n6;
            }
            if (n4 != Integer.MAX_VALUE) {
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    n3 = trackGroup.getFormat(arrayList.get(n2).intValue()).getPixelCount();
                    if (n3 != -1 && n3 <= n4) continue;
                    arrayList.remove(n2);
                }
            }
        }
        return arrayList;
    }

    protected static boolean isSupported(int n2, boolean bl) {
        bl = (n2 = RendererCapabilities$_CC.getFormatSupport(n2)) == 4 || bl && n2 == 3;
        return bl;
    }

    private static boolean isSupportedAdaptiveAudioTrack(Format format, int n2, Format format2, int n3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        block2: {
            block5: {
                boolean bl5;
                block4: {
                    block3: {
                        bl4 = bl5 = false;
                        if (!DefaultTrackSelector.isSupported(n2, false)) break block2;
                        bl4 = bl5;
                        if (format.bitrate == -1) break block2;
                        bl4 = bl5;
                        if (format.bitrate > n3) break block2;
                        if (bl3) break block3;
                        bl4 = bl5;
                        if (format.channelCount == -1) break block2;
                        bl4 = bl5;
                        if (format.channelCount != format2.channelCount) break block2;
                    }
                    if (bl) break block4;
                    bl4 = bl5;
                    if (format.sampleMimeType == null) break block2;
                    bl4 = bl5;
                    if (!TextUtils.equals((CharSequence)format.sampleMimeType, (CharSequence)format2.sampleMimeType)) break block2;
                }
                if (bl2) break block5;
                bl4 = bl5;
                if (format.sampleRate == -1) break block2;
                bl4 = bl5;
                if (format.sampleRate != format2.sampleRate) break block2;
            }
            bl4 = true;
        }
        return bl4;
    }

    private static boolean isSupportedAdaptiveVideoTrack(Format format, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        boolean bl;
        block4: {
            block9: {
                boolean bl2;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                int n12 = format.roleFlags;
                                bl2 = false;
                                if ((n12 & 0x4000) != 0) {
                                    return false;
                                }
                                bl = bl2;
                                if (!DefaultTrackSelector.isSupported(n2, false)) break block4;
                                bl = bl2;
                                if ((n2 & n3) == 0) break block4;
                                if (string2 == null) break block5;
                                bl = bl2;
                                if (!Util.areEqual(format.sampleMimeType, string2)) break block4;
                            }
                            if (format.width == -1) break block6;
                            bl = bl2;
                            if (n8 > format.width) break block4;
                            bl = bl2;
                            if (format.width > n4) break block4;
                        }
                        if (format.height == -1) break block7;
                        bl = bl2;
                        if (n9 > format.height) break block4;
                        bl = bl2;
                        if (format.height > n5) break block4;
                    }
                    if (format.frameRate == -1.0f) break block8;
                    bl = bl2;
                    if (!((float)n10 <= format.frameRate)) break block4;
                    bl = bl2;
                    if (!(format.frameRate <= (float)n6)) break block4;
                }
                if (format.bitrate == -1) break block9;
                bl = bl2;
                if (n11 > format.bitrate) break block4;
                bl = bl2;
                if (format.bitrate > n7) break block4;
            }
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ int lambda$static$0(Integer n2, Integer n3) {
        int n4 = n2;
        int n5 = -1;
        if (n4 == -1) {
            if (n3 == -1) {
                n5 = 0;
            }
        } else {
            n5 = n3 == -1 ? 1 : n2 - n3;
        }
        return n5;
    }

    static /* synthetic */ int lambda$static$1(Integer n2, Integer n3) {
        return 0;
    }

    private static void maybeConfigureRenderersForTunneling(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] nArray, RendererConfiguration[] rendererConfigurationArray, ExoTrackSelection[] exoTrackSelectionArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block5: {
            n6 = 0;
            n5 = -1;
            n4 = -1;
            for (n3 = 0; n3 < mappedTrackInfo.getRendererCount(); ++n3) {
                int n7;
                block7: {
                    block10: {
                        block9: {
                            block8: {
                                ExoTrackSelection exoTrackSelection;
                                int n8;
                                block6: {
                                    n8 = mappedTrackInfo.getRendererType(n3);
                                    exoTrackSelection = exoTrackSelectionArray[n3];
                                    if (n8 == 1) break block6;
                                    n2 = n5;
                                    n7 = n4;
                                    if (n8 != 2) break block7;
                                }
                                n2 = n5;
                                n7 = n4;
                                if (exoTrackSelection == null) break block7;
                                n2 = n5;
                                n7 = n4;
                                if (!DefaultTrackSelector.rendererSupportsTunneling(nArray[n3], mappedTrackInfo.getTrackGroups(n3), exoTrackSelection)) break block7;
                                if (n8 != 1) break block8;
                                if (n4 != -1) break block9;
                                n7 = n3;
                                n2 = n5;
                                break block7;
                            }
                            if (n5 == -1) break block10;
                        }
                        n3 = 0;
                        break block5;
                    }
                    n2 = n3;
                    n7 = n4;
                }
                n5 = n2;
                n4 = n7;
            }
            n3 = 1;
        }
        n2 = n6;
        if (n4 != -1) {
            n2 = n6;
            if (n5 != -1) {
                n2 = 1;
            }
        }
        if ((n3 & n2) != 0) {
            mappedTrackInfo = new RendererConfiguration(true);
            rendererConfigurationArray[n4] = mappedTrackInfo;
            rendererConfigurationArray[n5] = mappedTrackInfo;
        }
    }

    protected static String normalizeUndeterminedLanguageToNull(String string2) {
        String string3;
        block3: {
            block2: {
                if (TextUtils.isEmpty((CharSequence)string2)) break block2;
                string3 = string2;
                if (!TextUtils.equals((CharSequence)string2, (CharSequence)"und")) break block3;
            }
            string3 = null;
        }
        return string3;
    }

    private static boolean rendererSupportsTunneling(int[][] nArray, TrackGroupArray trackGroupArray, ExoTrackSelection exoTrackSelection) {
        if (exoTrackSelection == null) {
            return false;
        }
        int n2 = trackGroupArray.indexOf(exoTrackSelection.getTrackGroup());
        for (int i2 = 0; i2 < exoTrackSelection.length(); ++i2) {
            if (RendererCapabilities$_CC.getTunnelingSupport(nArray[n2][exoTrackSelection.getIndexInTrackGroup(i2)]) == 32) continue;
            return false;
        }
        return true;
    }

    private static ExoTrackSelection.Definition selectAdaptiveVideoTrack(TrackGroupArray trackGroupArray, int[][] nArray, int n2, Parameters parameters) {
        Object object = parameters;
        int n3 = ((Parameters)object).allowVideoNonSeamlessAdaptiveness ? 24 : 16;
        boolean bl = ((Parameters)object).allowVideoMixedMimeTypeAdaptiveness && (n2 & n3) != 0;
        n2 = 0;
        while (true) {
            object = parameters;
            TrackGroupArray trackGroupArray2 = trackGroupArray;
            if (n2 >= trackGroupArray2.length) break;
            object = DefaultTrackSelector.getAdaptiveVideoTracksForGroup((TrackGroup)(trackGroupArray2 = trackGroupArray2.get(n2)), nArray[n2], bl, n3, ((Parameters)object).maxVideoWidth, ((Parameters)object).maxVideoHeight, ((Parameters)object).maxVideoFrameRate, ((Parameters)object).maxVideoBitrate, ((Parameters)object).minVideoWidth, ((Parameters)object).minVideoHeight, ((Parameters)object).minVideoFrameRate, ((Parameters)object).minVideoBitrate, ((Parameters)object).viewportWidth, ((Parameters)object).viewportHeight, ((Parameters)object).viewportOrientationMayChange);
            if (((Object)object).length > 0) {
                return new ExoTrackSelection.Definition((TrackGroup)trackGroupArray2, (int[])object);
            }
            ++n2;
        }
        return null;
    }

    private static ExoTrackSelection.Definition selectFixedVideoTrack(TrackGroupArray object, int[][] nArray, Parameters parameters) {
        TrackGroup trackGroup;
        Object var3_3 = null;
        TrackGroup trackGroup2 = trackGroup = null;
        int n2 = -1;
        for (int i2 = 0; i2 < object.length; ++i2) {
            TrackGroup trackGroup3 = object.get(i2);
            List<Integer> list = DefaultTrackSelector.getViewportFilteredTrackIndices(trackGroup3, parameters.viewportWidth, parameters.viewportHeight, parameters.viewportOrientationMayChange);
            int[] nArray2 = nArray[i2];
            TrackGroup trackGroup4 = trackGroup2;
            trackGroup2 = trackGroup;
            trackGroup = trackGroup4;
            for (int i3 = 0; i3 < trackGroup3.length; ++i3) {
                TrackGroup trackGroup5;
                int n3;
                block5: {
                    Object object2;
                    block7: {
                        block6: {
                            block4: {
                                object2 = trackGroup3.getFormat(i3);
                                if ((((Format)object2).roleFlags & 0x4000) == 0) break block4;
                                n3 = n2;
                                trackGroup5 = trackGroup2;
                                trackGroup4 = trackGroup;
                                break block5;
                            }
                            n3 = n2;
                            trackGroup5 = trackGroup2;
                            trackGroup4 = trackGroup;
                            if (!DefaultTrackSelector.isSupported(nArray2[i3], parameters.exceedRendererCapabilitiesIfNecessary)) break block5;
                            object2 = new VideoTrackScore((Format)object2, parameters, nArray2[i3], list.contains(i3));
                            if (((VideoTrackScore)object2).isWithinMaxConstraints || parameters.exceedVideoConstraintsIfNecessary) break block6;
                            n3 = n2;
                            trackGroup5 = trackGroup2;
                            trackGroup4 = trackGroup;
                            break block5;
                        }
                        if (trackGroup == null) break block7;
                        n3 = n2;
                        trackGroup5 = trackGroup2;
                        trackGroup4 = trackGroup;
                        if (((VideoTrackScore)object2).compareTo((VideoTrackScore)trackGroup) <= 0) break block5;
                    }
                    n3 = i3;
                    trackGroup5 = trackGroup3;
                    trackGroup4 = object2;
                }
                n2 = n3;
                trackGroup2 = trackGroup5;
                trackGroup = trackGroup4;
            }
            trackGroup4 = trackGroup;
            trackGroup = trackGroup2;
            trackGroup2 = trackGroup4;
        }
        object = trackGroup == null ? var3_3 : new ExoTrackSelection.Definition(trackGroup, new int[]{n2});
        return object;
    }

    public ParametersBuilder buildUponParameters() {
        return this.getParameters().buildUpon();
    }

    public Parameters getParameters() {
        return this.parametersReference.get();
    }

    protected ExoTrackSelection.Definition[] selectAllTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] nArray, int[] nArray2, Parameters parameters) throws ExoPlaybackException {
        ExoTrackSelection.Definition definition;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5 = mappedTrackInfo.getRendererCount();
        ExoTrackSelection.Definition[] definitionArray = new ExoTrackSelection.Definition[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (true) {
            n4 = 1;
            if (n8 >= n5) break;
            n3 = n7;
            n2 = n9;
            if (2 == mappedTrackInfo.getRendererType(n8)) {
                n3 = n7;
                if (n7 == 0) {
                    definitionArray[n8] = this.selectVideoTrack(mappedTrackInfo.getTrackGroups(n8), nArray[n8], nArray2[n8], parameters, true);
                    n3 = definitionArray[n8] != null ? 1 : 0;
                }
                n7 = mappedTrackInfo.getTrackGroups((int)n8).length > 0 ? n4 : 0;
                n2 = n9 | n7;
            }
            ++n8;
            n7 = n3;
            n9 = n2;
        }
        Object object2 = object = null;
        n3 = -1;
        for (n7 = 0; n7 < n5; ++n7) {
            if (1 != mappedTrackInfo.getRendererType(n7)) continue;
            boolean bl = parameters.allowMultipleAdaptiveSelections || n9 == 0;
            TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(n7);
            Object object3 = nArray[n7];
            n4 = nArray2[n7];
            n2 = n3;
            definition = object;
            n8 = n7;
            object3 = this.selectAudioTrack(trackGroupArray, (int[][])object3, n4, parameters, bl);
            if (object3 == null || definition != null && ((AudioTrackScore)object3.second).compareTo((AudioTrackScore)definition) <= 0) continue;
            if (n2 != -1) {
                definitionArray[n2] = null;
            }
            definitionArray[n8] = object2 = (ExoTrackSelection.Definition)object3.first;
            object2 = object2.group.getFormat((int)object2.tracks[0]).language;
            object = (AudioTrackScore)object3.second;
            n3 = n8;
        }
        nArray2 = object2;
        object2 = null;
        n7 = -1;
        for (n3 = n6; n3 < n5; ++n3) {
            block12: {
                block9: {
                    block10: {
                        block11: {
                            block13: {
                                n9 = mappedTrackInfo.getRendererType(n3);
                                if (n9 == 1) break block9;
                                if (n9 == 2) break block10;
                                if (n9 != 3) break block11;
                                definition = this.selectTextTrack(mappedTrackInfo.getTrackGroups(n3), nArray[n3], parameters, (String)nArray2);
                                object = object2;
                                n9 = n7;
                                if (definition == null) break block12;
                                if (object2 == null) break block13;
                                object = object2;
                                n9 = n7;
                                if (((TextTrackScore)definition.second).compareTo((TextTrackScore)object2) <= 0) break block12;
                            }
                            if (n7 != -1) {
                                definitionArray[n7] = null;
                            }
                            definitionArray[n3] = (ExoTrackSelection.Definition)definition.first;
                            object = (TextTrackScore)definition.second;
                            n9 = n3;
                            break block12;
                        }
                        definitionArray[n3] = this.selectOtherTrack(n9, mappedTrackInfo.getTrackGroups(n3), nArray[n3], parameters);
                    }
                    object = object2;
                    n9 = n7;
                    break block12;
                }
                n9 = n7;
                object = object2;
            }
            object2 = object;
            n7 = n9;
        }
        return definitionArray;
    }

    protected Pair<ExoTrackSelection.Definition, AudioTrackScore> selectAudioTrack(TrackGroupArray trackGroupArray, int[][] object, int n2, Parameters parameters, boolean bl) throws ExoPlaybackException {
        Object object2;
        Object var6_6 = null;
        TrackGroup trackGroup = null;
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < trackGroupArray.length; ++n2) {
            TrackGroup trackGroup2 = trackGroupArray.get(n2);
            int[] nArray = object[n2];
            for (int i2 = 0; i2 < trackGroup2.length; ++i2) {
                int n5;
                int n6;
                block11: {
                    AudioTrackScore audioTrackScore;
                    block13: {
                        block12: {
                            n6 = n3;
                            n5 = n4;
                            object2 = trackGroup;
                            if (!DefaultTrackSelector.isSupported(nArray[i2], parameters.exceedRendererCapabilitiesIfNecessary)) break block11;
                            audioTrackScore = new AudioTrackScore(trackGroup2.getFormat(i2), parameters, nArray[i2]);
                            if (audioTrackScore.isWithinConstraints || parameters.exceedAudioConstraintsIfNecessary) break block12;
                            n6 = n3;
                            n5 = n4;
                            object2 = trackGroup;
                            break block11;
                        }
                        if (trackGroup == null) break block13;
                        n6 = n3;
                        n5 = n4;
                        object2 = trackGroup;
                        if (audioTrackScore.compareTo((AudioTrackScore)trackGroup) <= 0) break block11;
                    }
                    n6 = n2;
                    n5 = i2;
                    object2 = audioTrackScore;
                }
                n3 = n6;
                n4 = n5;
                trackGroup = object2;
            }
        }
        if (n3 == -1) {
            return null;
        }
        object2 = trackGroupArray.get(n3);
        trackGroupArray = var6_6;
        if (!parameters.forceHighestSupportedBitrate) {
            trackGroupArray = var6_6;
            if (!parameters.forceLowestBitrate) {
                trackGroupArray = var6_6;
                if (bl) {
                    object = DefaultTrackSelector.getAdaptiveAudioTracks(object2, object[n3], n4, parameters.maxAudioBitrate, parameters.allowAudioMixedMimeTypeAdaptiveness, parameters.allowAudioMixedSampleRateAdaptiveness, parameters.allowAudioMixedChannelCountAdaptiveness);
                    trackGroupArray = var6_6;
                    if (((int[][])object).length > 1) {
                        trackGroupArray = new ExoTrackSelection.Definition(object2, (int[])object);
                    }
                }
            }
        }
        object = trackGroupArray;
        if (trackGroupArray == null) {
            object = new ExoTrackSelection.Definition(object2, new int[]{n4});
        }
        return Pair.create((Object)object, (Object)Assertions.checkNotNull(trackGroup));
    }

    protected ExoTrackSelection.Definition selectOtherTrack(int n2, TrackGroupArray object, int[][] nArray, Parameters parameters) throws ExoPlaybackException {
        TrackGroup trackGroup;
        Object var5_5 = null;
        TrackGroup trackGroup2 = trackGroup = null;
        int n3 = 0;
        for (int i2 = 0; i2 < object.length; ++i2) {
            TrackGroup trackGroup3 = object.get(i2);
            int[] nArray2 = nArray[i2];
            Object object2 = trackGroup;
            trackGroup = trackGroup2;
            trackGroup2 = object2;
            for (n2 = 0; n2 < trackGroup3.length; ++n2) {
                TrackGroup trackGroup4;
                int n4;
                block4: {
                    OtherTrackScore otherTrackScore;
                    block5: {
                        n4 = n3;
                        trackGroup4 = trackGroup2;
                        object2 = trackGroup;
                        if (!DefaultTrackSelector.isSupported(nArray2[n2], parameters.exceedRendererCapabilitiesIfNecessary)) break block4;
                        otherTrackScore = new OtherTrackScore(trackGroup3.getFormat(n2), nArray2[n2]);
                        if (trackGroup == null) break block5;
                        n4 = n3;
                        trackGroup4 = trackGroup2;
                        object2 = trackGroup;
                        if (otherTrackScore.compareTo((OtherTrackScore)trackGroup) <= 0) break block4;
                    }
                    n4 = n2;
                    trackGroup4 = trackGroup3;
                    object2 = otherTrackScore;
                }
                n3 = n4;
                trackGroup2 = trackGroup4;
                trackGroup = object2;
            }
            object2 = trackGroup;
            trackGroup = trackGroup2;
            trackGroup2 = object2;
        }
        object = trackGroup == null ? var5_5 : new ExoTrackSelection.Definition(trackGroup, new int[]{n3});
        return object;
    }

    protected Pair<ExoTrackSelection.Definition, TextTrackScore> selectTextTrack(TrackGroupArray object, int[][] nArray, Parameters parameters, String string2) throws ExoPlaybackException {
        TrackGroup trackGroup;
        Object var5_5 = null;
        TrackGroup trackGroup2 = trackGroup = null;
        int n2 = -1;
        for (int i2 = 0; i2 < object.length; ++i2) {
            TrackGroup trackGroup3 = object.get(i2);
            int[] nArray2 = nArray[i2];
            TrackGroup trackGroup4 = trackGroup2;
            trackGroup2 = trackGroup;
            trackGroup = trackGroup4;
            for (int i3 = 0; i3 < trackGroup3.length; ++i3) {
                Object object2;
                int n3;
                block5: {
                    block4: {
                        TextTrackScore textTrackScore;
                        block6: {
                            if (!DefaultTrackSelector.isSupported(nArray2[i3], parameters.exceedRendererCapabilitiesIfNecessary)) break block4;
                            textTrackScore = new TextTrackScore(trackGroup3.getFormat(i3), parameters, nArray2[i3], string2);
                            n3 = n2;
                            trackGroup4 = trackGroup2;
                            object2 = trackGroup;
                            if (!textTrackScore.isWithinConstraints) break block5;
                            if (trackGroup == null) break block6;
                            n3 = n2;
                            trackGroup4 = trackGroup2;
                            object2 = trackGroup;
                            if (textTrackScore.compareTo((TextTrackScore)trackGroup) <= 0) break block5;
                        }
                        n3 = i3;
                        trackGroup4 = trackGroup3;
                        object2 = textTrackScore;
                        break block5;
                    }
                    object2 = trackGroup;
                    trackGroup4 = trackGroup2;
                    n3 = n2;
                }
                n2 = n3;
                trackGroup2 = trackGroup4;
                trackGroup = object2;
            }
            trackGroup4 = trackGroup2;
            trackGroup2 = trackGroup;
            trackGroup = trackGroup4;
        }
        object = trackGroup == null ? var5_5 : Pair.create((Object)new ExoTrackSelection.Definition(trackGroup, new int[]{n2}), (Object)Assertions.checkNotNull(trackGroup2));
        return object;
    }

    protected final Pair<RendererConfiguration[], ExoTrackSelection[]> selectTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] nArray, int[] object, MediaSource.MediaPeriodId rendererConfigurationArray, Timeline exoTrackSelectionArray) throws ExoPlaybackException {
        Parameters parameters = this.parametersReference.get();
        int n2 = mappedTrackInfo.getRendererCount();
        ExoTrackSelection.Definition[] definitionArray = this.selectAllTracks(mappedTrackInfo, nArray, (int[])object, parameters);
        int n3 = 0;
        while (true) {
            object = null;
            if (n3 >= n2) break;
            if (parameters.getRendererDisabled(n3)) {
                definitionArray[n3] = null;
            } else {
                TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(n3);
                if (parameters.hasSelectionOverride(n3, trackGroupArray)) {
                    SelectionOverride selectionOverride = parameters.getSelectionOverride(n3, trackGroupArray);
                    if (selectionOverride != null) {
                        object = new ExoTrackSelection.Definition(trackGroupArray.get(selectionOverride.groupIndex), selectionOverride.tracks, selectionOverride.reason, (Object)selectionOverride.data);
                    }
                    definitionArray[n3] = (ExoTrackSelection.Definition)object;
                }
            }
            ++n3;
        }
        exoTrackSelectionArray = this.trackSelectionFactory.createTrackSelections(definitionArray, this.getBandwidthMeter(), (MediaSource.MediaPeriodId)rendererConfigurationArray, (Timeline)exoTrackSelectionArray);
        rendererConfigurationArray = new RendererConfiguration[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            boolean bl = !parameters.getRendererDisabled(n3) && (mappedTrackInfo.getRendererType(n3) == 7 || exoTrackSelectionArray[n3] != null);
            object = bl ? (Object)RendererConfiguration.DEFAULT : null;
            rendererConfigurationArray[n3] = (RendererConfiguration)object;
        }
        if (parameters.tunnelingEnabled) {
            DefaultTrackSelector.maybeConfigureRenderersForTunneling(mappedTrackInfo, nArray, rendererConfigurationArray, exoTrackSelectionArray);
        }
        return Pair.create((Object)rendererConfigurationArray, (Object)exoTrackSelectionArray);
    }

    protected ExoTrackSelection.Definition selectVideoTrack(TrackGroupArray trackGroupArray, int[][] nArray, int n2, Parameters parameters, boolean bl) throws ExoPlaybackException {
        ExoTrackSelection.Definition definition = !parameters.forceHighestSupportedBitrate && !parameters.forceLowestBitrate && bl ? DefaultTrackSelector.selectAdaptiveVideoTrack(trackGroupArray, nArray, n2, parameters) : null;
        ExoTrackSelection.Definition definition2 = definition;
        if (definition == null) {
            definition2 = DefaultTrackSelector.selectFixedVideoTrack(trackGroupArray, nArray, parameters);
        }
        return definition2;
    }

    public void setParameters(Parameters parameters) {
        Assertions.checkNotNull(parameters);
        if (!this.parametersReference.getAndSet(parameters).equals(parameters)) {
            this.invalidate();
        }
    }

    public void setParameters(ParametersBuilder parametersBuilder) {
        this.setParameters(parametersBuilder.build());
    }

    protected static final class AudioTrackScore
    implements Comparable<AudioTrackScore> {
        private final int bitrate;
        private final int channelCount;
        private final boolean isDefaultSelectionFlag;
        public final boolean isWithinConstraints;
        private final boolean isWithinRendererCapabilities;
        private final String language;
        private final int localeLanguageMatchIndex;
        private final int localeLanguageScore;
        private final Parameters parameters;
        private final int preferredLanguageIndex;
        private final int preferredLanguageScore;
        private final int preferredMimeTypeMatchIndex;
        private final int preferredRoleFlagsScore;
        private final int sampleRate;

        /*
         * Exception decompiling
         */
        public AudioTrackScore(Format var1_1, Parameters var2_2, int var3_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int compareTo(AudioTrackScore audioTrackScore) {
            Ordering ordering = this.isWithinConstraints && this.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            ComparisonChain comparisonChain = ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, audioTrackScore.isWithinRendererCapabilities).compare(this.preferredLanguageIndex, audioTrackScore.preferredLanguageIndex, Ordering.natural().reverse()).compare(this.preferredLanguageScore, audioTrackScore.preferredLanguageScore).compare(this.preferredRoleFlagsScore, audioTrackScore.preferredRoleFlagsScore).compareFalseFirst(this.isWithinConstraints, audioTrackScore.isWithinConstraints).compare(this.preferredMimeTypeMatchIndex, audioTrackScore.preferredMimeTypeMatchIndex, Ordering.natural().reverse());
            int n2 = this.bitrate;
            int n3 = audioTrackScore.bitrate;
            Ordering ordering2 = this.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER;
            ordering2 = comparisonChain.compare(n2, n3, ordering2).compareFalseFirst(this.isDefaultSelectionFlag, audioTrackScore.isDefaultSelectionFlag).compare(this.localeLanguageMatchIndex, audioTrackScore.localeLanguageMatchIndex, Ordering.natural().reverse()).compare(this.localeLanguageScore, audioTrackScore.localeLanguageScore).compare(this.channelCount, audioTrackScore.channelCount, ordering).compare(this.sampleRate, audioTrackScore.sampleRate, ordering);
            n2 = this.bitrate;
            n3 = audioTrackScore.bitrate;
            if (!Util.areEqual(this.language, audioTrackScore.language)) {
                ordering = NO_ORDER;
            }
            return ((ComparisonChain)((Object)ordering2)).compare(n2, n3, ordering).result();
        }
    }

    protected static final class OtherTrackScore
    implements Comparable<OtherTrackScore> {
        private final boolean isDefault;
        private final boolean isWithinRendererCapabilities;

        public OtherTrackScore(Format format, int n2) {
            int n3 = format.selectionFlags;
            boolean bl = true;
            if ((n3 & 1) == 0) {
                bl = false;
            }
            this.isDefault = bl;
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(n2, false);
        }

        @Override
        public int compareTo(OtherTrackScore otherTrackScore) {
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, otherTrackScore.isWithinRendererCapabilities).compareFalseFirst(this.isDefault, otherTrackScore.isDefault).result();
        }
    }

    public static final class Parameters
    extends TrackSelectionParameters {
        public static final Parcelable.Creator<Parameters> CREATOR;
        public static final Parameters DEFAULT_WITHOUT_CONTEXT;
        public final boolean allowAudioMixedChannelCountAdaptiveness;
        public final boolean allowAudioMixedMimeTypeAdaptiveness;
        public final boolean allowAudioMixedSampleRateAdaptiveness;
        public final boolean allowMultipleAdaptiveSelections;
        public final boolean allowVideoMixedMimeTypeAdaptiveness;
        public final boolean allowVideoNonSeamlessAdaptiveness;
        public final boolean exceedAudioConstraintsIfNecessary;
        public final boolean exceedRendererCapabilitiesIfNecessary;
        public final boolean exceedVideoConstraintsIfNecessary;
        public final boolean forceHighestSupportedBitrate;
        public final boolean forceLowestBitrate;
        public final int maxAudioBitrate;
        public final int maxAudioChannelCount;
        public final int maxVideoBitrate;
        public final int maxVideoFrameRate;
        public final int maxVideoHeight;
        public final int maxVideoWidth;
        public final int minVideoBitrate;
        public final int minVideoFrameRate;
        public final int minVideoHeight;
        public final int minVideoWidth;
        public final ImmutableList<String> preferredAudioMimeTypes;
        public final ImmutableList<String> preferredVideoMimeTypes;
        private final SparseBooleanArray rendererDisabledFlags;
        private final SparseArray<Map<TrackGroupArray, SelectionOverride>> selectionOverrides;
        public final boolean tunnelingEnabled;
        public final int viewportHeight;
        public final boolean viewportOrientationMayChange;
        public final int viewportWidth;

        static {
            DEFAULT_WITHOUT_CONTEXT = new ParametersBuilder().build();
            CREATOR = new Parcelable.Creator<Parameters>(){

                public Parameters createFromParcel(Parcel parcel) {
                    return new Parameters(parcel);
                }

                public Parameters[] newArray(int n2) {
                    return new Parameters[n2];
                }
            };
        }

        Parameters(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, boolean bl3, int n10, int n11, boolean bl4, ImmutableList<String> immutableList, ImmutableList<String> immutableList2, int n12, int n13, int n14, boolean bl5, boolean bl6, boolean bl7, boolean bl8, ImmutableList<String> immutableList3, ImmutableList<String> immutableList4, int n15, boolean bl9, int n16, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray, SparseBooleanArray sparseBooleanArray) {
            super(immutableList2, n12, immutableList4, n15, bl9, n16);
            this.maxVideoWidth = n2;
            this.maxVideoHeight = n3;
            this.maxVideoFrameRate = n4;
            this.maxVideoBitrate = n5;
            this.minVideoWidth = n6;
            this.minVideoHeight = n7;
            this.minVideoFrameRate = n8;
            this.minVideoBitrate = n9;
            this.exceedVideoConstraintsIfNecessary = bl;
            this.allowVideoMixedMimeTypeAdaptiveness = bl2;
            this.allowVideoNonSeamlessAdaptiveness = bl3;
            this.viewportWidth = n10;
            this.viewportHeight = n11;
            this.viewportOrientationMayChange = bl4;
            this.preferredVideoMimeTypes = immutableList;
            this.maxAudioChannelCount = n13;
            this.maxAudioBitrate = n14;
            this.exceedAudioConstraintsIfNecessary = bl5;
            this.allowAudioMixedMimeTypeAdaptiveness = bl6;
            this.allowAudioMixedSampleRateAdaptiveness = bl7;
            this.allowAudioMixedChannelCountAdaptiveness = bl8;
            this.preferredAudioMimeTypes = immutableList3;
            this.forceLowestBitrate = bl10;
            this.forceHighestSupportedBitrate = bl11;
            this.exceedRendererCapabilitiesIfNecessary = bl12;
            this.tunnelingEnabled = bl13;
            this.allowMultipleAdaptiveSelections = bl14;
            this.selectionOverrides = sparseArray;
            this.rendererDisabledFlags = sparseBooleanArray;
        }

        Parameters(Parcel parcel) {
            super(parcel);
            this.maxVideoWidth = parcel.readInt();
            this.maxVideoHeight = parcel.readInt();
            this.maxVideoFrameRate = parcel.readInt();
            this.maxVideoBitrate = parcel.readInt();
            this.minVideoWidth = parcel.readInt();
            this.minVideoHeight = parcel.readInt();
            this.minVideoFrameRate = parcel.readInt();
            this.minVideoBitrate = parcel.readInt();
            this.exceedVideoConstraintsIfNecessary = Util.readBoolean(parcel);
            this.allowVideoMixedMimeTypeAdaptiveness = Util.readBoolean(parcel);
            this.allowVideoNonSeamlessAdaptiveness = Util.readBoolean(parcel);
            this.viewportWidth = parcel.readInt();
            this.viewportHeight = parcel.readInt();
            this.viewportOrientationMayChange = Util.readBoolean(parcel);
            ArrayList arrayList = new ArrayList();
            parcel.readList(arrayList, null);
            this.preferredVideoMimeTypes = ImmutableList.copyOf(arrayList);
            this.maxAudioChannelCount = parcel.readInt();
            this.maxAudioBitrate = parcel.readInt();
            this.exceedAudioConstraintsIfNecessary = Util.readBoolean(parcel);
            this.allowAudioMixedMimeTypeAdaptiveness = Util.readBoolean(parcel);
            this.allowAudioMixedSampleRateAdaptiveness = Util.readBoolean(parcel);
            this.allowAudioMixedChannelCountAdaptiveness = Util.readBoolean(parcel);
            arrayList = new ArrayList();
            parcel.readList(arrayList, null);
            this.preferredAudioMimeTypes = ImmutableList.copyOf(arrayList);
            this.forceLowestBitrate = Util.readBoolean(parcel);
            this.forceHighestSupportedBitrate = Util.readBoolean(parcel);
            this.exceedRendererCapabilitiesIfNecessary = Util.readBoolean(parcel);
            this.tunnelingEnabled = Util.readBoolean(parcel);
            this.allowMultipleAdaptiveSelections = Util.readBoolean(parcel);
            this.selectionOverrides = Parameters.readSelectionOverrides(parcel);
            this.rendererDisabledFlags = Util.castNonNull(parcel.readSparseBooleanArray());
        }

        private static boolean areRendererDisabledFlagsEqual(SparseBooleanArray sparseBooleanArray, SparseBooleanArray sparseBooleanArray2) {
            int n2 = sparseBooleanArray.size();
            if (sparseBooleanArray2.size() != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (sparseBooleanArray2.indexOfKey(sparseBooleanArray.keyAt(i2)) >= 0) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray, SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray2) {
            int n2 = sparseArray.size();
            if (sparseArray2.size() != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = sparseArray2.indexOfKey(sparseArray.keyAt(i2));
                if (n3 >= 0 && Parameters.areSelectionOverridesEqual((Map)sparseArray.valueAt(i2), (Map)sparseArray2.valueAt(n3))) {
                    continue;
                }
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(Map<TrackGroupArray, SelectionOverride> trackGroupArray, Map<TrackGroupArray, SelectionOverride> map) {
            int n2 = trackGroupArray.size();
            if (map.size() != n2) {
                return false;
            }
            for (Map.Entry<TrackGroupArray, SelectionOverride> entry : trackGroupArray.entrySet()) {
                trackGroupArray = entry.getKey();
                if (map.containsKey(trackGroupArray) && Util.areEqual(entry.getValue(), map.get(trackGroupArray))) continue;
                return false;
            }
            return true;
        }

        public static Parameters getDefaults(Context context) {
            return new ParametersBuilder(context).build();
        }

        private static SparseArray<Map<TrackGroupArray, SelectionOverride>> readSelectionOverrides(Parcel parcel) {
            int n2 = parcel.readInt();
            SparseArray sparseArray = new SparseArray(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = parcel.readInt();
                int n4 = parcel.readInt();
                HashMap<TrackGroupArray, SelectionOverride> hashMap = new HashMap<TrackGroupArray, SelectionOverride>(n4);
                for (int i3 = 0; i3 < n4; ++i3) {
                    hashMap.put(Assertions.checkNotNull((TrackGroupArray)parcel.readParcelable(TrackGroupArray.class.getClassLoader())), (SelectionOverride)parcel.readParcelable(SelectionOverride.class.getClassLoader()));
                }
                sparseArray.put(n3, hashMap);
            }
            return sparseArray;
        }

        private static void writeSelectionOverridesToParcel(Parcel parcel, SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray) {
            int n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = sparseArray.keyAt(i2);
                Map map = (Map)sparseArray.valueAt(i2);
                int n4 = map.size();
                parcel.writeInt(n3);
                parcel.writeInt(n4);
                for (Map.Entry entry : map.entrySet()) {
                    parcel.writeParcelable((Parcelable)entry.getKey(), 0);
                    parcel.writeParcelable((Parcelable)entry.getValue(), 0);
                }
            }
        }

        @Override
        public ParametersBuilder buildUpon() {
            return new ParametersBuilder(this);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                Parameters parameters = (Parameters)object;
                if (!(super.equals(object) && this.maxVideoWidth == parameters.maxVideoWidth && this.maxVideoHeight == parameters.maxVideoHeight && this.maxVideoFrameRate == parameters.maxVideoFrameRate && this.maxVideoBitrate == parameters.maxVideoBitrate && this.minVideoWidth == parameters.minVideoWidth && this.minVideoHeight == parameters.minVideoHeight && this.minVideoFrameRate == parameters.minVideoFrameRate && this.minVideoBitrate == parameters.minVideoBitrate && this.exceedVideoConstraintsIfNecessary == parameters.exceedVideoConstraintsIfNecessary && this.allowVideoMixedMimeTypeAdaptiveness == parameters.allowVideoMixedMimeTypeAdaptiveness && this.allowVideoNonSeamlessAdaptiveness == parameters.allowVideoNonSeamlessAdaptiveness && this.viewportOrientationMayChange == parameters.viewportOrientationMayChange && this.viewportWidth == parameters.viewportWidth && this.viewportHeight == parameters.viewportHeight && this.preferredVideoMimeTypes.equals(parameters.preferredVideoMimeTypes) && this.maxAudioChannelCount == parameters.maxAudioChannelCount && this.maxAudioBitrate == parameters.maxAudioBitrate && this.exceedAudioConstraintsIfNecessary == parameters.exceedAudioConstraintsIfNecessary && this.allowAudioMixedMimeTypeAdaptiveness == parameters.allowAudioMixedMimeTypeAdaptiveness && this.allowAudioMixedSampleRateAdaptiveness == parameters.allowAudioMixedSampleRateAdaptiveness && this.allowAudioMixedChannelCountAdaptiveness == parameters.allowAudioMixedChannelCountAdaptiveness && this.preferredAudioMimeTypes.equals(parameters.preferredAudioMimeTypes) && this.forceLowestBitrate == parameters.forceLowestBitrate && this.forceHighestSupportedBitrate == parameters.forceHighestSupportedBitrate && this.exceedRendererCapabilitiesIfNecessary == parameters.exceedRendererCapabilitiesIfNecessary && this.tunnelingEnabled == parameters.tunnelingEnabled && this.allowMultipleAdaptiveSelections == parameters.allowMultipleAdaptiveSelections && Parameters.areRendererDisabledFlagsEqual(this.rendererDisabledFlags, parameters.rendererDisabledFlags) && Parameters.areSelectionOverridesEqual(this.selectionOverrides, parameters.selectionOverrides))) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public final boolean getRendererDisabled(int n2) {
            return this.rendererDisabledFlags.get(n2);
        }

        public final SelectionOverride getSelectionOverride(int n2, TrackGroupArray object) {
            Map map = (Map)this.selectionOverrides.get(n2);
            object = map != null ? (SelectionOverride)map.get(object) : null;
            return object;
        }

        public final boolean hasSelectionOverride(int n2, TrackGroupArray trackGroupArray) {
            Map map = (Map)this.selectionOverrides.get(n2);
            boolean bl = map != null && map.containsKey(trackGroupArray);
            return bl;
        }

        @Override
        public int hashCode() {
            return ((((((((((((((((((((((((((super.hashCode() * 31 + this.maxVideoWidth) * 31 + this.maxVideoHeight) * 31 + this.maxVideoFrameRate) * 31 + this.maxVideoBitrate) * 31 + this.minVideoWidth) * 31 + this.minVideoHeight) * 31 + this.minVideoFrameRate) * 31 + this.minVideoBitrate) * 31 + this.exceedVideoConstraintsIfNecessary) * 31 + this.allowVideoMixedMimeTypeAdaptiveness) * 31 + this.allowVideoNonSeamlessAdaptiveness) * 31 + this.viewportOrientationMayChange) * 31 + this.viewportWidth) * 31 + this.viewportHeight) * 31 + this.preferredVideoMimeTypes.hashCode()) * 31 + this.maxAudioChannelCount) * 31 + this.maxAudioBitrate) * 31 + this.exceedAudioConstraintsIfNecessary) * 31 + this.allowAudioMixedMimeTypeAdaptiveness) * 31 + this.allowAudioMixedSampleRateAdaptiveness) * 31 + this.allowAudioMixedChannelCountAdaptiveness) * 31 + this.preferredAudioMimeTypes.hashCode()) * 31 + this.forceLowestBitrate) * 31 + this.forceHighestSupportedBitrate) * 31 + this.exceedRendererCapabilitiesIfNecessary) * 31 + this.tunnelingEnabled) * 31 + this.allowMultipleAdaptiveSelections;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.maxVideoWidth);
            parcel.writeInt(this.maxVideoHeight);
            parcel.writeInt(this.maxVideoFrameRate);
            parcel.writeInt(this.maxVideoBitrate);
            parcel.writeInt(this.minVideoWidth);
            parcel.writeInt(this.minVideoHeight);
            parcel.writeInt(this.minVideoFrameRate);
            parcel.writeInt(this.minVideoBitrate);
            Util.writeBoolean(parcel, this.exceedVideoConstraintsIfNecessary);
            Util.writeBoolean(parcel, this.allowVideoMixedMimeTypeAdaptiveness);
            Util.writeBoolean(parcel, this.allowVideoNonSeamlessAdaptiveness);
            parcel.writeInt(this.viewportWidth);
            parcel.writeInt(this.viewportHeight);
            Util.writeBoolean(parcel, this.viewportOrientationMayChange);
            parcel.writeList(this.preferredVideoMimeTypes);
            parcel.writeInt(this.maxAudioChannelCount);
            parcel.writeInt(this.maxAudioBitrate);
            Util.writeBoolean(parcel, this.exceedAudioConstraintsIfNecessary);
            Util.writeBoolean(parcel, this.allowAudioMixedMimeTypeAdaptiveness);
            Util.writeBoolean(parcel, this.allowAudioMixedSampleRateAdaptiveness);
            Util.writeBoolean(parcel, this.allowAudioMixedChannelCountAdaptiveness);
            parcel.writeList(this.preferredAudioMimeTypes);
            Util.writeBoolean(parcel, this.forceLowestBitrate);
            Util.writeBoolean(parcel, this.forceHighestSupportedBitrate);
            Util.writeBoolean(parcel, this.exceedRendererCapabilitiesIfNecessary);
            Util.writeBoolean(parcel, this.tunnelingEnabled);
            Util.writeBoolean(parcel, this.allowMultipleAdaptiveSelections);
            Parameters.writeSelectionOverridesToParcel(parcel, this.selectionOverrides);
            parcel.writeSparseBooleanArray(this.rendererDisabledFlags);
        }
    }

    public static final class ParametersBuilder
    extends TrackSelectionParameters.Builder {
        private boolean allowAudioMixedChannelCountAdaptiveness;
        private boolean allowAudioMixedMimeTypeAdaptiveness;
        private boolean allowAudioMixedSampleRateAdaptiveness;
        private boolean allowMultipleAdaptiveSelections;
        private boolean allowVideoMixedMimeTypeAdaptiveness;
        private boolean allowVideoNonSeamlessAdaptiveness;
        private boolean exceedAudioConstraintsIfNecessary;
        private boolean exceedRendererCapabilitiesIfNecessary;
        private boolean exceedVideoConstraintsIfNecessary;
        private boolean forceHighestSupportedBitrate;
        private boolean forceLowestBitrate;
        private int maxAudioBitrate;
        private int maxAudioChannelCount;
        private int maxVideoBitrate;
        private int maxVideoFrameRate;
        private int maxVideoHeight;
        private int maxVideoWidth;
        private int minVideoBitrate;
        private int minVideoFrameRate;
        private int minVideoHeight;
        private int minVideoWidth;
        private ImmutableList<String> preferredAudioMimeTypes;
        private ImmutableList<String> preferredVideoMimeTypes;
        private final SparseBooleanArray rendererDisabledFlags;
        private final SparseArray<Map<TrackGroupArray, SelectionOverride>> selectionOverrides;
        private boolean tunnelingEnabled;
        private int viewportHeight;
        private boolean viewportOrientationMayChange;
        private int viewportWidth;

        @Deprecated
        public ParametersBuilder() {
            this.setInitialValuesWithoutContext();
            this.selectionOverrides = new SparseArray();
            this.rendererDisabledFlags = new SparseBooleanArray();
        }

        public ParametersBuilder(Context context) {
            super(context);
            this.setInitialValuesWithoutContext();
            this.selectionOverrides = new SparseArray();
            this.rendererDisabledFlags = new SparseBooleanArray();
            this.setViewportSizeToPhysicalDisplaySize(context, true);
        }

        private ParametersBuilder(Parameters parameters) {
            super(parameters);
            this.maxVideoWidth = parameters.maxVideoWidth;
            this.maxVideoHeight = parameters.maxVideoHeight;
            this.maxVideoFrameRate = parameters.maxVideoFrameRate;
            this.maxVideoBitrate = parameters.maxVideoBitrate;
            this.minVideoWidth = parameters.minVideoWidth;
            this.minVideoHeight = parameters.minVideoHeight;
            this.minVideoFrameRate = parameters.minVideoFrameRate;
            this.minVideoBitrate = parameters.minVideoBitrate;
            this.exceedVideoConstraintsIfNecessary = parameters.exceedVideoConstraintsIfNecessary;
            this.allowVideoMixedMimeTypeAdaptiveness = parameters.allowVideoMixedMimeTypeAdaptiveness;
            this.allowVideoNonSeamlessAdaptiveness = parameters.allowVideoNonSeamlessAdaptiveness;
            this.viewportWidth = parameters.viewportWidth;
            this.viewportHeight = parameters.viewportHeight;
            this.viewportOrientationMayChange = parameters.viewportOrientationMayChange;
            this.preferredVideoMimeTypes = parameters.preferredVideoMimeTypes;
            this.maxAudioChannelCount = parameters.maxAudioChannelCount;
            this.maxAudioBitrate = parameters.maxAudioBitrate;
            this.exceedAudioConstraintsIfNecessary = parameters.exceedAudioConstraintsIfNecessary;
            this.allowAudioMixedMimeTypeAdaptiveness = parameters.allowAudioMixedMimeTypeAdaptiveness;
            this.allowAudioMixedSampleRateAdaptiveness = parameters.allowAudioMixedSampleRateAdaptiveness;
            this.allowAudioMixedChannelCountAdaptiveness = parameters.allowAudioMixedChannelCountAdaptiveness;
            this.preferredAudioMimeTypes = parameters.preferredAudioMimeTypes;
            this.forceLowestBitrate = parameters.forceLowestBitrate;
            this.forceHighestSupportedBitrate = parameters.forceHighestSupportedBitrate;
            this.exceedRendererCapabilitiesIfNecessary = parameters.exceedRendererCapabilitiesIfNecessary;
            this.tunnelingEnabled = parameters.tunnelingEnabled;
            this.allowMultipleAdaptiveSelections = parameters.allowMultipleAdaptiveSelections;
            this.selectionOverrides = ParametersBuilder.cloneSelectionOverrides((SparseArray<Map<TrackGroupArray, SelectionOverride>>)parameters.selectionOverrides);
            this.rendererDisabledFlags = parameters.rendererDisabledFlags.clone();
        }

        private static SparseArray<Map<TrackGroupArray, SelectionOverride>> cloneSelectionOverrides(SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray) {
            SparseArray sparseArray2 = new SparseArray();
            for (int i2 = 0; i2 < sparseArray.size(); ++i2) {
                sparseArray2.put(sparseArray.keyAt(i2), new HashMap((Map)sparseArray.valueAt(i2)));
            }
            return sparseArray2;
        }

        @EnsuresNonNull(value={"preferredVideoMimeTypes", "preferredAudioMimeTypes"})
        private void setInitialValuesWithoutContext() {
            this.maxVideoWidth = Integer.MAX_VALUE;
            this.maxVideoHeight = Integer.MAX_VALUE;
            this.maxVideoFrameRate = Integer.MAX_VALUE;
            this.maxVideoBitrate = Integer.MAX_VALUE;
            this.exceedVideoConstraintsIfNecessary = true;
            this.allowVideoMixedMimeTypeAdaptiveness = false;
            this.allowVideoNonSeamlessAdaptiveness = true;
            this.viewportWidth = Integer.MAX_VALUE;
            this.viewportHeight = Integer.MAX_VALUE;
            this.viewportOrientationMayChange = true;
            this.preferredVideoMimeTypes = ImmutableList.of();
            this.maxAudioChannelCount = Integer.MAX_VALUE;
            this.maxAudioBitrate = Integer.MAX_VALUE;
            this.exceedAudioConstraintsIfNecessary = true;
            this.allowAudioMixedMimeTypeAdaptiveness = false;
            this.allowAudioMixedSampleRateAdaptiveness = false;
            this.allowAudioMixedChannelCountAdaptiveness = false;
            this.preferredAudioMimeTypes = ImmutableList.of();
            this.forceLowestBitrate = false;
            this.forceHighestSupportedBitrate = false;
            this.exceedRendererCapabilitiesIfNecessary = true;
            this.tunnelingEnabled = false;
            this.allowMultipleAdaptiveSelections = true;
        }

        @Override
        public Parameters build() {
            return new Parameters(this.maxVideoWidth, this.maxVideoHeight, this.maxVideoFrameRate, this.maxVideoBitrate, this.minVideoWidth, this.minVideoHeight, this.minVideoFrameRate, this.minVideoBitrate, this.exceedVideoConstraintsIfNecessary, this.allowVideoMixedMimeTypeAdaptiveness, this.allowVideoNonSeamlessAdaptiveness, this.viewportWidth, this.viewportHeight, this.viewportOrientationMayChange, this.preferredVideoMimeTypes, this.preferredAudioLanguages, this.preferredAudioRoleFlags, this.maxAudioChannelCount, this.maxAudioBitrate, this.exceedAudioConstraintsIfNecessary, this.allowAudioMixedMimeTypeAdaptiveness, this.allowAudioMixedSampleRateAdaptiveness, this.allowAudioMixedChannelCountAdaptiveness, this.preferredAudioMimeTypes, this.preferredTextLanguages, this.preferredTextRoleFlags, this.selectUndeterminedTextLanguage, this.disabledTextTrackSelectionFlags, this.forceLowestBitrate, this.forceHighestSupportedBitrate, this.exceedRendererCapabilitiesIfNecessary, this.tunnelingEnabled, this.allowMultipleAdaptiveSelections, this.selectionOverrides, this.rendererDisabledFlags);
        }

        public final ParametersBuilder clearSelectionOverride(int n2, TrackGroupArray trackGroupArray) {
            Map map = (Map)this.selectionOverrides.get(n2);
            if (map != null && map.containsKey(trackGroupArray)) {
                map.remove(trackGroupArray);
                if (map.isEmpty()) {
                    this.selectionOverrides.remove(n2);
                }
            }
            return this;
        }

        public final ParametersBuilder clearSelectionOverrides() {
            if (this.selectionOverrides.size() == 0) {
                return this;
            }
            this.selectionOverrides.clear();
            return this;
        }

        public final ParametersBuilder clearSelectionOverrides(int n2) {
            Map map = (Map)this.selectionOverrides.get(n2);
            if (map != null && !map.isEmpty()) {
                this.selectionOverrides.remove(n2);
            }
            return this;
        }

        public ParametersBuilder clearVideoSizeConstraints() {
            return this.setMaxVideoSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public ParametersBuilder clearViewportSizeConstraints() {
            return this.setViewportSize(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        public ParametersBuilder setAllowAudioMixedChannelCountAdaptiveness(boolean bl) {
            this.allowAudioMixedChannelCountAdaptiveness = bl;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedMimeTypeAdaptiveness(boolean bl) {
            this.allowAudioMixedMimeTypeAdaptiveness = bl;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedSampleRateAdaptiveness(boolean bl) {
            this.allowAudioMixedSampleRateAdaptiveness = bl;
            return this;
        }

        public ParametersBuilder setAllowMultipleAdaptiveSelections(boolean bl) {
            this.allowMultipleAdaptiveSelections = bl;
            return this;
        }

        public ParametersBuilder setAllowVideoMixedMimeTypeAdaptiveness(boolean bl) {
            this.allowVideoMixedMimeTypeAdaptiveness = bl;
            return this;
        }

        public ParametersBuilder setAllowVideoNonSeamlessAdaptiveness(boolean bl) {
            this.allowVideoNonSeamlessAdaptiveness = bl;
            return this;
        }

        @Override
        public ParametersBuilder setDisabledTextTrackSelectionFlags(int n2) {
            super.setDisabledTextTrackSelectionFlags(n2);
            return this;
        }

        public ParametersBuilder setExceedAudioConstraintsIfNecessary(boolean bl) {
            this.exceedAudioConstraintsIfNecessary = bl;
            return this;
        }

        public ParametersBuilder setExceedRendererCapabilitiesIfNecessary(boolean bl) {
            this.exceedRendererCapabilitiesIfNecessary = bl;
            return this;
        }

        public ParametersBuilder setExceedVideoConstraintsIfNecessary(boolean bl) {
            this.exceedVideoConstraintsIfNecessary = bl;
            return this;
        }

        public ParametersBuilder setForceHighestSupportedBitrate(boolean bl) {
            this.forceHighestSupportedBitrate = bl;
            return this;
        }

        public ParametersBuilder setForceLowestBitrate(boolean bl) {
            this.forceLowestBitrate = bl;
            return this;
        }

        public ParametersBuilder setMaxAudioBitrate(int n2) {
            this.maxAudioBitrate = n2;
            return this;
        }

        public ParametersBuilder setMaxAudioChannelCount(int n2) {
            this.maxAudioChannelCount = n2;
            return this;
        }

        public ParametersBuilder setMaxVideoBitrate(int n2) {
            this.maxVideoBitrate = n2;
            return this;
        }

        public ParametersBuilder setMaxVideoFrameRate(int n2) {
            this.maxVideoFrameRate = n2;
            return this;
        }

        public ParametersBuilder setMaxVideoSize(int n2, int n3) {
            this.maxVideoWidth = n2;
            this.maxVideoHeight = n3;
            return this;
        }

        public ParametersBuilder setMaxVideoSizeSd() {
            return this.setMaxVideoSize(1279, 719);
        }

        public ParametersBuilder setMinVideoBitrate(int n2) {
            this.minVideoBitrate = n2;
            return this;
        }

        public ParametersBuilder setMinVideoFrameRate(int n2) {
            this.minVideoFrameRate = n2;
            return this;
        }

        public ParametersBuilder setMinVideoSize(int n2, int n3) {
            this.minVideoWidth = n2;
            this.minVideoHeight = n3;
            return this;
        }

        @Override
        public ParametersBuilder setPreferredAudioLanguage(String string2) {
            super.setPreferredAudioLanguage(string2);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredAudioLanguages(String ... stringArray) {
            super.setPreferredAudioLanguages(stringArray);
            return this;
        }

        public ParametersBuilder setPreferredAudioMimeType(String object) {
            object = object == null ? this.setPreferredAudioMimeTypes(new String[0]) : this.setPreferredAudioMimeTypes(new String[]{object});
            return object;
        }

        public ParametersBuilder setPreferredAudioMimeTypes(String ... stringArray) {
            this.preferredAudioMimeTypes = ImmutableList.copyOf(stringArray);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredAudioRoleFlags(int n2) {
            super.setPreferredAudioRoleFlags(n2);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredTextLanguage(String string2) {
            super.setPreferredTextLanguage(string2);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            super.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredTextLanguages(String ... stringArray) {
            super.setPreferredTextLanguages(stringArray);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredTextRoleFlags(int n2) {
            super.setPreferredTextRoleFlags(n2);
            return this;
        }

        public ParametersBuilder setPreferredVideoMimeType(String object) {
            object = object == null ? this.setPreferredVideoMimeTypes(new String[0]) : this.setPreferredVideoMimeTypes(new String[]{object});
            return object;
        }

        public ParametersBuilder setPreferredVideoMimeTypes(String ... stringArray) {
            this.preferredVideoMimeTypes = ImmutableList.copyOf(stringArray);
            return this;
        }

        public final ParametersBuilder setRendererDisabled(int n2, boolean bl) {
            if (this.rendererDisabledFlags.get(n2) == bl) {
                return this;
            }
            if (bl) {
                this.rendererDisabledFlags.put(n2, true);
            } else {
                this.rendererDisabledFlags.delete(n2);
            }
            return this;
        }

        @Override
        public ParametersBuilder setSelectUndeterminedTextLanguage(boolean bl) {
            super.setSelectUndeterminedTextLanguage(bl);
            return this;
        }

        public final ParametersBuilder setSelectionOverride(int n2, TrackGroupArray trackGroupArray, SelectionOverride selectionOverride) {
            HashMap<TrackGroupArray, SelectionOverride> hashMap;
            HashMap<TrackGroupArray, SelectionOverride> hashMap2 = hashMap = (HashMap<TrackGroupArray, SelectionOverride>)this.selectionOverrides.get(n2);
            if (hashMap == null) {
                hashMap2 = new HashMap<TrackGroupArray, SelectionOverride>();
                this.selectionOverrides.put(n2, hashMap2);
            }
            if (hashMap2.containsKey(trackGroupArray) && Util.areEqual(hashMap2.get(trackGroupArray), selectionOverride)) {
                return this;
            }
            hashMap2.put(trackGroupArray, selectionOverride);
            return this;
        }

        public ParametersBuilder setTunnelingEnabled(boolean bl) {
            this.tunnelingEnabled = bl;
            return this;
        }

        public ParametersBuilder setViewportSize(int n2, int n3, boolean bl) {
            this.viewportWidth = n2;
            this.viewportHeight = n3;
            this.viewportOrientationMayChange = bl;
            return this;
        }

        public ParametersBuilder setViewportSizeToPhysicalDisplaySize(Context context, boolean bl) {
            context = Util.getCurrentDisplayModeSize(context);
            return this.setViewportSize(context.x, context.y, bl);
        }
    }

    public static final class SelectionOverride
    implements Parcelable {
        public static final Parcelable.Creator<SelectionOverride> CREATOR = new Parcelable.Creator<SelectionOverride>(){

            public SelectionOverride createFromParcel(Parcel parcel) {
                return new SelectionOverride(parcel);
            }

            public SelectionOverride[] newArray(int n2) {
                return new SelectionOverride[n2];
            }
        };
        public final int data;
        public final int groupIndex;
        public final int length;
        public final int reason;
        public final int[] tracks;

        public SelectionOverride(int n2, int ... nArray) {
            this(n2, nArray, 2, 0);
        }

        public SelectionOverride(int n2, int[] nArray, int n3, int n4) {
            this.groupIndex = n2;
            this.tracks = Arrays.copyOf(nArray, nArray.length);
            this.length = nArray.length;
            this.reason = n3;
            this.data = n4;
            Arrays.sort(this.tracks);
        }

        SelectionOverride(Parcel parcel) {
            this.groupIndex = parcel.readInt();
            this.length = parcel.readByte();
            this.tracks = new int[this.length];
            parcel.readIntArray(this.tracks);
            this.reason = parcel.readInt();
            this.data = parcel.readInt();
        }

        public boolean containsTrack(int n2) {
            int[] nArray = this.tracks;
            int n3 = nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (nArray[i2] != n2) continue;
                return true;
            }
            return false;
        }

        public int describeContents() {
            return 0;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (SelectionOverride)object;
                if (this.groupIndex != ((SelectionOverride)object).groupIndex || !Arrays.equals(this.tracks, ((SelectionOverride)object).tracks) || this.reason != ((SelectionOverride)object).reason || this.data != ((SelectionOverride)object).data) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return ((this.groupIndex * 31 + Arrays.hashCode(this.tracks)) * 31 + this.reason) * 31 + this.data;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.groupIndex);
            parcel.writeInt(this.tracks.length);
            parcel.writeIntArray(this.tracks);
            parcel.writeInt(this.reason);
            parcel.writeInt(this.data);
        }
    }

    protected static final class TextTrackScore
    implements Comparable<TextTrackScore> {
        private final boolean hasCaptionRoleFlags;
        private final boolean isDefault;
        private final boolean isForced;
        public final boolean isWithinConstraints;
        private final boolean isWithinRendererCapabilities;
        private final int preferredLanguageIndex;
        private final int preferredLanguageScore;
        private final int preferredRoleFlagsScore;
        private final int selectedAudioLanguageScore;

        public TextTrackScore(Format format, Parameters parameters, int n2, String string2) {
            boolean bl;
            block5: {
                block4: {
                    int n3;
                    boolean bl2;
                    block3: {
                        bl2 = false;
                        this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(n2, false);
                        n2 = format.selectionFlags & ~parameters.disabledTextTrackSelectionFlags;
                        bl = (n2 & 1) != 0;
                        this.isDefault = bl;
                        bl = (n2 & 2) != 0;
                        this.isForced = bl;
                        n3 = Integer.MAX_VALUE;
                        ImmutableList immutableList = parameters.preferredTextLanguages.isEmpty() ? ImmutableList.of("") : parameters.preferredTextLanguages;
                        for (n2 = 0; n2 < immutableList.size(); ++n2) {
                            int n4 = DefaultTrackSelector.getFormatLanguageScore(format, (String)immutableList.get(n2), parameters.selectUndeterminedTextLanguage);
                            if (n4 <= 0) continue;
                            n3 = n2;
                            n2 = n4;
                            break block3;
                        }
                        n2 = 0;
                    }
                    this.preferredLanguageIndex = n3;
                    this.preferredLanguageScore = n2;
                    this.preferredRoleFlagsScore = Integer.bitCount(format.roleFlags & parameters.preferredTextRoleFlags);
                    bl = (format.roleFlags & 0x440) != 0;
                    this.hasCaptionRoleFlags = bl;
                    bl = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(string2) == null;
                    this.selectedAudioLanguageScore = DefaultTrackSelector.getFormatLanguageScore(format, string2, bl);
                    if (this.preferredLanguageScore > 0 || parameters.preferredTextLanguages.isEmpty() && this.preferredRoleFlagsScore > 0 || this.isDefault) break block4;
                    bl = bl2;
                    if (!this.isForced) break block5;
                    bl = bl2;
                    if (this.selectedAudioLanguageScore <= 0) break block5;
                }
                bl = true;
            }
            this.isWithinConstraints = bl;
        }

        @Override
        public int compareTo(TextTrackScore textTrackScore) {
            ComparisonChain comparisonChain = ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, textTrackScore.isWithinRendererCapabilities).compare(this.preferredLanguageIndex, textTrackScore.preferredLanguageIndex, Ordering.natural().reverse()).compare(this.preferredLanguageScore, textTrackScore.preferredLanguageScore).compare(this.preferredRoleFlagsScore, textTrackScore.preferredRoleFlagsScore).compareFalseFirst(this.isDefault, textTrackScore.isDefault);
            boolean bl = this.isForced;
            boolean bl2 = textTrackScore.isForced;
            Ordering<Object> ordering = this.preferredLanguageScore == 0 ? Ordering.natural() : Ordering.natural().reverse();
            comparisonChain = comparisonChain.compare(bl, bl2, ordering).compare(this.selectedAudioLanguageScore, textTrackScore.selectedAudioLanguageScore);
            ordering = comparisonChain;
            if (this.preferredRoleFlagsScore == 0) {
                ordering = comparisonChain.compareTrueFirst(this.hasCaptionRoleFlags, textTrackScore.hasCaptionRoleFlags);
            }
            return ((ComparisonChain)((Object)ordering)).result();
        }
    }

    protected static final class VideoTrackScore
    implements Comparable<VideoTrackScore> {
        private final int bitrate;
        public final boolean isWithinMaxConstraints;
        private final boolean isWithinMinConstraints;
        private final boolean isWithinRendererCapabilities;
        private final Parameters parameters;
        private final int pixelCount;
        private final int preferredMimeTypeMatchIndex;

        /*
         * Exception decompiling
         */
        public VideoTrackScore(Format var1_1, Parameters var2_2, int var3_3, boolean var4_4) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int compareTo(VideoTrackScore videoTrackScore) {
            Ordering ordering = this.isWithinMaxConstraints && this.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            ComparisonChain comparisonChain = ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, videoTrackScore.isWithinRendererCapabilities).compareFalseFirst(this.isWithinMaxConstraints, videoTrackScore.isWithinMaxConstraints).compareFalseFirst(this.isWithinMinConstraints, videoTrackScore.isWithinMinConstraints).compare(this.preferredMimeTypeMatchIndex, videoTrackScore.preferredMimeTypeMatchIndex, Ordering.natural().reverse());
            int n2 = this.bitrate;
            int n3 = videoTrackScore.bitrate;
            Ordering ordering2 = this.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER;
            return comparisonChain.compare(n2, n3, ordering2).compare(this.pixelCount, videoTrackScore.pixelCount, ordering).compare(this.bitrate, videoTrackScore.bitrate, ordering).result();
        }
    }
}

