/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.webvtt;

import android.text.TextUtils;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class WebvttCssStyle {
    public static final int FONT_SIZE_UNIT_EM = 2;
    public static final int FONT_SIZE_UNIT_PERCENT = 3;
    public static final int FONT_SIZE_UNIT_PIXEL = 1;
    private static final int OFF = 0;
    private static final int ON = 1;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_BOLD_ITALIC = 3;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_NORMAL = 0;
    public static final int UNSPECIFIED = -1;
    private int backgroundColor;
    private int bold = -1;
    private boolean combineUpright = false;
    private int fontColor;
    private String fontFamily = null;
    private float fontSize;
    private int fontSizeUnit = -1;
    private boolean hasBackgroundColor = false;
    private boolean hasFontColor = false;
    private int italic = -1;
    private int linethrough = -1;
    private int rubyPosition = -1;
    private Set<String> targetClasses = Collections.emptySet();
    private String targetId = "";
    private String targetTag = "";
    private String targetVoice = "";
    private int underline = -1;

    private static int updateScoreForMatch(int n2, String string2, String string3, int n3) {
        if (!string2.isEmpty()) {
            int n4 = -1;
            if (n2 != -1) {
                if (string2.equals(string3)) {
                    n4 = n2 + n3;
                }
                return n4;
            }
        }
        return n2;
    }

    public int getBackgroundColor() {
        if (this.hasBackgroundColor) {
            return this.backgroundColor;
        }
        throw new IllegalStateException("Background color not defined.");
    }

    public boolean getCombineUpright() {
        return this.combineUpright;
    }

    public int getFontColor() {
        if (this.hasFontColor) {
            return this.fontColor;
        }
        throw new IllegalStateException("Font color not defined");
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getFontSizeUnit() {
        return this.fontSizeUnit;
    }

    public int getRubyPosition() {
        return this.rubyPosition;
    }

    public int getSpecificityScore(String string2, String string3, Set<String> set, String string4) {
        if (this.targetId.isEmpty() && this.targetTag.isEmpty() && this.targetClasses.isEmpty() && this.targetVoice.isEmpty()) {
            return TextUtils.isEmpty((CharSequence)string3) ? 1 : 0;
        }
        int n2 = WebvttCssStyle.updateScoreForMatch(WebvttCssStyle.updateScoreForMatch(WebvttCssStyle.updateScoreForMatch(0, this.targetId, string2, 0x40000000), this.targetTag, string3, 2), this.targetVoice, string4, 4);
        if (n2 != -1 && set.containsAll(this.targetClasses)) {
            return n2 + this.targetClasses.size() * 4;
        }
        return 0;
    }

    public int getStyle() {
        if (this.bold == -1 && this.italic == -1) {
            return -1;
        }
        int n2 = this.bold;
        int n3 = 0;
        n2 = n2 == 1 ? 1 : 0;
        if (this.italic == 1) {
            n3 = 2;
        }
        return n2 | n3;
    }

    public boolean hasBackgroundColor() {
        return this.hasBackgroundColor;
    }

    public boolean hasFontColor() {
        return this.hasFontColor;
    }

    public boolean isLinethrough() {
        int n2 = this.linethrough;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isUnderline() {
        int n2 = this.underline;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public WebvttCssStyle setBackgroundColor(int n2) {
        this.backgroundColor = n2;
        this.hasBackgroundColor = true;
        return this;
    }

    public WebvttCssStyle setBold(boolean bl) {
        this.bold = bl ? 1 : 0;
        return this;
    }

    public WebvttCssStyle setCombineUpright(boolean bl) {
        this.combineUpright = bl;
        return this;
    }

    public WebvttCssStyle setFontColor(int n2) {
        this.fontColor = n2;
        this.hasFontColor = true;
        return this;
    }

    public WebvttCssStyle setFontFamily(String string2) {
        this.fontFamily = Util.toLowerInvariant(string2);
        return this;
    }

    public WebvttCssStyle setFontSize(float f2) {
        this.fontSize = f2;
        return this;
    }

    public WebvttCssStyle setFontSizeUnit(short s2) {
        this.fontSizeUnit = s2;
        return this;
    }

    public WebvttCssStyle setItalic(boolean bl) {
        this.italic = bl ? 1 : 0;
        return this;
    }

    public WebvttCssStyle setLinethrough(boolean bl) {
        this.linethrough = bl ? 1 : 0;
        return this;
    }

    public WebvttCssStyle setRubyPosition(int n2) {
        this.rubyPosition = n2;
        return this;
    }

    public void setTargetClasses(String[] stringArray) {
        this.targetClasses = new HashSet<String>(Arrays.asList(stringArray));
    }

    public void setTargetId(String string2) {
        this.targetId = string2;
    }

    public void setTargetTagName(String string2) {
        this.targetTag = string2;
    }

    public void setTargetVoice(String string2) {
        this.targetVoice = string2;
    }

    public WebvttCssStyle setUnderline(boolean bl) {
        this.underline = bl ? 1 : 0;
        return this;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontSizeUnit {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StyleFlags {
    }
}

