/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.ttml;

import android.text.Layout;
import com.google.android.exoplayer2.text.ttml.TextEmphasis;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

final class TtmlStyle {
    public static final int FONT_SIZE_UNIT_EM = 2;
    public static final int FONT_SIZE_UNIT_PERCENT = 3;
    public static final int FONT_SIZE_UNIT_PIXEL = 1;
    private static final int OFF = 0;
    private static final int ON = 1;
    public static final int RUBY_TYPE_BASE = 2;
    public static final int RUBY_TYPE_CONTAINER = 1;
    public static final int RUBY_TYPE_DELIMITER = 4;
    public static final int RUBY_TYPE_TEXT = 3;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_BOLD_ITALIC = 3;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_NORMAL = 0;
    public static final int UNSPECIFIED = -1;
    public static final float UNSPECIFIED_SHEAR = Float.MAX_VALUE;
    private int backgroundColor;
    private int bold = -1;
    private int fontColor;
    private String fontFamily;
    private float fontSize;
    private int fontSizeUnit = -1;
    private boolean hasBackgroundColor;
    private boolean hasFontColor;
    private String id;
    private int italic = -1;
    private int linethrough = -1;
    private int rubyPosition = -1;
    private int rubyType = -1;
    private float shearPercentage = Float.MAX_VALUE;
    private Layout.Alignment textAlign;
    private int textCombine = -1;
    private TextEmphasis textEmphasis;
    private int underline = -1;

    private TtmlStyle inherit(TtmlStyle ttmlStyle, boolean bl) {
        if (ttmlStyle != null) {
            int n2;
            String string2;
            if (!this.hasFontColor && ttmlStyle.hasFontColor) {
                this.setFontColor(ttmlStyle.fontColor);
            }
            if (this.bold == -1) {
                this.bold = ttmlStyle.bold;
            }
            if (this.italic == -1) {
                this.italic = ttmlStyle.italic;
            }
            if (this.fontFamily == null && (string2 = ttmlStyle.fontFamily) != null) {
                this.fontFamily = string2;
            }
            if (this.linethrough == -1) {
                this.linethrough = ttmlStyle.linethrough;
            }
            if (this.underline == -1) {
                this.underline = ttmlStyle.underline;
            }
            if (this.rubyPosition == -1) {
                this.rubyPosition = ttmlStyle.rubyPosition;
            }
            if (this.textAlign == null && (string2 = ttmlStyle.textAlign) != null) {
                this.textAlign = string2;
            }
            if (this.textCombine == -1) {
                this.textCombine = ttmlStyle.textCombine;
            }
            if (this.fontSizeUnit == -1) {
                this.fontSizeUnit = ttmlStyle.fontSizeUnit;
                this.fontSize = ttmlStyle.fontSize;
            }
            if (this.textEmphasis == null) {
                this.textEmphasis = ttmlStyle.textEmphasis;
            }
            if (this.shearPercentage == Float.MAX_VALUE) {
                this.shearPercentage = ttmlStyle.shearPercentage;
            }
            if (bl && !this.hasBackgroundColor && ttmlStyle.hasBackgroundColor) {
                this.setBackgroundColor(ttmlStyle.backgroundColor);
            }
            if (bl && this.rubyType == -1 && (n2 = ttmlStyle.rubyType) != -1) {
                this.rubyType = n2;
            }
        }
        return this;
    }

    public TtmlStyle chain(TtmlStyle ttmlStyle) {
        return this.inherit(ttmlStyle, true);
    }

    public int getBackgroundColor() {
        if (this.hasBackgroundColor) {
            return this.backgroundColor;
        }
        throw new IllegalStateException("Background color has not been defined.");
    }

    public int getFontColor() {
        if (this.hasFontColor) {
            return this.fontColor;
        }
        throw new IllegalStateException("Font color has not been defined.");
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getFontSizeUnit() {
        return this.fontSizeUnit;
    }

    public String getId() {
        return this.id;
    }

    public int getRubyPosition() {
        return this.rubyPosition;
    }

    public int getRubyType() {
        return this.rubyType;
    }

    public float getShearPercentage() {
        return this.shearPercentage;
    }

    public int getStyle() {
        if (this.bold == -1 && this.italic == -1) {
            return -1;
        }
        int n2 = this.bold;
        int n3 = 0;
        n2 = n2 == 1 ? 1 : 0;
        if (this.italic == 1) {
            n3 = 2;
        }
        return n2 | n3;
    }

    public Layout.Alignment getTextAlign() {
        return this.textAlign;
    }

    public boolean getTextCombine() {
        int n2 = this.textCombine;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public TextEmphasis getTextEmphasis() {
        return this.textEmphasis;
    }

    public boolean hasBackgroundColor() {
        return this.hasBackgroundColor;
    }

    public boolean hasFontColor() {
        return this.hasFontColor;
    }

    public TtmlStyle inherit(TtmlStyle ttmlStyle) {
        return this.inherit(ttmlStyle, false);
    }

    public boolean isLinethrough() {
        int n2 = this.linethrough;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isUnderline() {
        int n2 = this.underline;
        boolean bl = true;
        if (n2 != 1) {
            bl = false;
        }
        return bl;
    }

    public TtmlStyle setBackgroundColor(int n2) {
        this.backgroundColor = n2;
        this.hasBackgroundColor = true;
        return this;
    }

    public TtmlStyle setBold(boolean bl) {
        this.bold = bl ? 1 : 0;
        return this;
    }

    public TtmlStyle setFontColor(int n2) {
        this.fontColor = n2;
        this.hasFontColor = true;
        return this;
    }

    public TtmlStyle setFontFamily(String string2) {
        this.fontFamily = string2;
        return this;
    }

    public TtmlStyle setFontSize(float f2) {
        this.fontSize = f2;
        return this;
    }

    public TtmlStyle setFontSizeUnit(int n2) {
        this.fontSizeUnit = n2;
        return this;
    }

    public TtmlStyle setId(String string2) {
        this.id = string2;
        return this;
    }

    public TtmlStyle setItalic(boolean bl) {
        this.italic = bl ? 1 : 0;
        return this;
    }

    public TtmlStyle setLinethrough(boolean bl) {
        this.linethrough = bl ? 1 : 0;
        return this;
    }

    public TtmlStyle setRubyPosition(int n2) {
        this.rubyPosition = n2;
        return this;
    }

    public TtmlStyle setRubyType(int n2) {
        this.rubyType = n2;
        return this;
    }

    public TtmlStyle setShearPercentage(float f2) {
        this.shearPercentage = f2;
        return this;
    }

    public TtmlStyle setTextAlign(Layout.Alignment alignment) {
        this.textAlign = alignment;
        return this;
    }

    public TtmlStyle setTextCombine(boolean bl) {
        this.textCombine = bl ? 1 : 0;
        return this;
    }

    public TtmlStyle setTextEmphasis(TextEmphasis textEmphasis) {
        this.textEmphasis = textEmphasis;
        return this;
    }

    public TtmlStyle setUnderline(boolean bl) {
        this.underline = bl ? 1 : 0;
        return this;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontSizeUnit {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RubyType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StyleFlags {
    }
}

