/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.ssa;

import android.graphics.Color;
import android.graphics.PointF;
import android.text.TextUtils;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Ints;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SsaStyle {
    public static final int SSA_ALIGNMENT_BOTTOM_CENTER = 2;
    public static final int SSA_ALIGNMENT_BOTTOM_LEFT = 1;
    public static final int SSA_ALIGNMENT_BOTTOM_RIGHT = 3;
    public static final int SSA_ALIGNMENT_MIDDLE_CENTER = 5;
    public static final int SSA_ALIGNMENT_MIDDLE_LEFT = 4;
    public static final int SSA_ALIGNMENT_MIDDLE_RIGHT = 6;
    public static final int SSA_ALIGNMENT_TOP_CENTER = 8;
    public static final int SSA_ALIGNMENT_TOP_LEFT = 7;
    public static final int SSA_ALIGNMENT_TOP_RIGHT = 9;
    public static final int SSA_ALIGNMENT_UNKNOWN = -1;
    private static final String TAG = "SsaStyle";
    public final int alignment;
    public final boolean bold;
    public final float fontSize;
    public final boolean italic;
    public final String name;
    public final Integer primaryColor;

    private SsaStyle(String string2, int n2, Integer n3, float f2, boolean bl, boolean bl2) {
        this.name = string2;
        this.alignment = n2;
        this.primaryColor = n3;
        this.fontSize = f2;
        this.bold = bl;
        this.italic = bl2;
    }

    public static SsaStyle fromStyleLine(String string2, Format object) {
        Comparable<StringBuilder> comparable;
        int n2;
        String string3;
        Assertions.checkArgument(string2.startsWith("Style:"));
        String[] stringArray = TextUtils.split((String)string2.substring(6), (String)",");
        if (stringArray.length != ((Format)object).length) {
            Log.w(TAG, Util.formatInvariant("Skipping malformed 'Style:' line (expected %s values, found %s): '%s'", ((Format)object).length, stringArray.length, string2));
            return null;
        }
        try {
            string3 = stringArray[((Format)object).nameIndex].trim();
            n2 = ((Format)object).alignmentIndex != -1 ? SsaStyle.parseAlignment(stringArray[((Format)object).alignmentIndex].trim()) : -1;
        }
        catch (RuntimeException runtimeException) {
            comparable = new StringBuilder();
            comparable.append("Skipping malformed 'Style:' line: '");
            comparable.append(string2);
            comparable.append("'");
            Log.w(TAG, comparable.toString(), runtimeException);
            return null;
        }
        comparable = ((Format)object).primaryColorIndex != -1 ? SsaStyle.parseColor(stringArray[((Format)object).primaryColorIndex].trim()) : null;
        float f2 = ((Format)object).fontSizeIndex != -1 ? SsaStyle.parseFontSize(stringArray[((Format)object).fontSizeIndex].trim()) : -3.4028235E38f;
        boolean bl = ((Format)object).boldIndex != -1 ? SsaStyle.parseBoldOrItalic(stringArray[((Format)object).boldIndex].trim()) : false;
        boolean bl2 = ((Format)object).italicIndex != -1 ? SsaStyle.parseBoldOrItalic(stringArray[((Format)object).italicIndex].trim()) : false;
        object = new SsaStyle(string3, n2, (Integer)comparable, f2, bl, bl2);
        return object;
    }

    private static boolean isValidAlignment(int n2) {
        switch (n2) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int parseAlignment(String string2) {
        try {
            int n2 = Integer.parseInt(string2.trim());
            boolean bl = SsaStyle.isValidAlignment(n2);
            if (bl) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ignoring unknown alignment: ");
        stringBuilder.append(string2);
        Log.w(TAG, stringBuilder.toString());
        return -1;
    }

    private static boolean parseBoldOrItalic(String string2) {
        boolean bl = false;
        try {
            int n2 = Integer.parseInt(string2);
            if (n2 == 1 || n2 == -1) {
                bl = true;
            }
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to parse bold/italic: '");
            stringBuilder.append(string2);
            stringBuilder.append("'");
            Log.w(TAG, stringBuilder.toString(), numberFormatException);
            return false;
        }
    }

    public static Integer parseColor(String string2) {
        boolean bl;
        long l2;
        try {
            l2 = string2.startsWith("&H") ? Long.parseLong(string2.substring(2), 16) : Long.parseLong(string2);
            bl = l2 <= 0xFFFFFFFFL;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to parse color expression: '");
            stringBuilder.append(string2);
            stringBuilder.append("'");
            Log.w(TAG, stringBuilder.toString(), illegalArgumentException);
            return null;
        }
        Assertions.checkArgument(bl);
        int n2 = Ints.checkedCast(l2 >> 24 & 0xFFL ^ 0xFFL);
        int n3 = Ints.checkedCast(l2 >> 16 & 0xFFL);
        int n4 = Ints.checkedCast(l2 >> 8 & 0xFFL);
        return Color.argb((int)n2, (int)Ints.checkedCast(l2 & 0xFFL), (int)n4, (int)n3);
    }

    private static float parseFontSize(String string2) {
        try {
            float f2 = Float.parseFloat(string2);
            return f2;
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to parse font size: '");
            stringBuilder.append(string2);
            stringBuilder.append("'");
            Log.w(TAG, stringBuilder.toString(), numberFormatException);
            return -3.4028235E38f;
        }
    }

    static final class Format {
        public final int alignmentIndex;
        public final int boldIndex;
        public final int fontSizeIndex;
        public final int italicIndex;
        public final int length;
        public final int nameIndex;
        public final int primaryColorIndex;

        private Format(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.nameIndex = n2;
            this.alignmentIndex = n3;
            this.primaryColorIndex = n4;
            this.fontSizeIndex = n5;
            this.boldIndex = n6;
            this.italicIndex = n7;
            this.length = n8;
        }

        public static Format fromFormatLine(String object) {
            String[] stringArray = TextUtils.split((String)((String)object).substring(7), (String)",");
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                int n8;
                block14: {
                    object = Util.toLowerInvariant(stringArray[i2].trim());
                    switch (((String)object).hashCode()) {
                        default: {
                            break;
                        }
                        case 1767875043: {
                            if (!((String)object).equals("alignment")) break;
                            n8 = 1;
                            break block14;
                        }
                        case 366554320: {
                            if (!((String)object).equals("fontsize")) break;
                            n8 = 3;
                            break block14;
                        }
                        case 3373707: {
                            if (!((String)object).equals("name")) break;
                            n8 = 0;
                            break block14;
                        }
                        case 3029637: {
                            if (!((String)object).equals("bold")) break;
                            n8 = 4;
                            break block14;
                        }
                        case -70925746: {
                            if (!((String)object).equals("primarycolour")) break;
                            n8 = 2;
                            break block14;
                        }
                        case -1178781136: {
                            if (!((String)object).equals("italic")) break;
                            n8 = 5;
                            break block14;
                        }
                    }
                    n8 = -1;
                }
                if (n8 != 0) {
                    if (n8 != 1) {
                        if (n8 != 2) {
                            if (n8 != 3) {
                                if (n8 != 4) {
                                    if (n8 != 5) continue;
                                    n7 = i2;
                                    continue;
                                }
                                n6 = i2;
                                continue;
                            }
                            n5 = i2;
                            continue;
                        }
                        n4 = i2;
                        continue;
                    }
                    n3 = i2;
                    continue;
                }
                n2 = i2;
            }
            object = n2 != -1 ? new Format(n2, n3, n4, n5, n6, n7, stringArray.length) : null;
            return object;
        }
    }

    static final class Overrides {
        private static final Pattern ALIGNMENT_OVERRIDE_PATTERN;
        private static final Pattern BRACES_PATTERN;
        private static final Pattern MOVE_PATTERN;
        private static final String PADDED_DECIMAL_PATTERN = "\\s*\\d+(?:\\.\\d+)?\\s*";
        private static final Pattern POSITION_PATTERN;
        private static final String TAG = "SsaStyle.Overrides";
        public final int alignment;
        public final PointF position;

        static {
            BRACES_PATTERN = Pattern.compile("\\{([^}]*)\\}");
            POSITION_PATTERN = Pattern.compile(Util.formatInvariant("\\\\pos\\((%1$s),(%1$s)\\)", PADDED_DECIMAL_PATTERN));
            MOVE_PATTERN = Pattern.compile(Util.formatInvariant("\\\\move\\(%1$s,%1$s,(%1$s),(%1$s)(?:,%1$s,%1$s)?\\)", PADDED_DECIMAL_PATTERN));
            ALIGNMENT_OVERRIDE_PATTERN = Pattern.compile("\\\\an(\\d+)");
        }

        private Overrides(int n2, PointF pointF) {
            this.alignment = n2;
            this.position = pointF;
        }

        private static int parseAlignmentOverride(String object) {
            int n2 = ((Matcher)(object = ALIGNMENT_OVERRIDE_PATTERN.matcher((CharSequence)object))).find() ? SsaStyle.parseAlignment(Assertions.checkNotNull(((Matcher)object).group(1))) : -1;
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Overrides parseFromDialogue(String string2) {
            Matcher matcher = BRACES_PATTERN.matcher(string2);
            String string3 = null;
            int n2 = -1;
            while (matcher.find()) {
                String string4 = Assertions.checkNotNull(matcher.group(1));
                try {
                    PointF pointF = Overrides.parsePosition(string4);
                    string2 = string3;
                    if (pointF != null) {
                        string2 = pointF;
                    }
                }
                catch (RuntimeException runtimeException) {
                    string2 = string3;
                }
                try {
                    int n3 = Overrides.parseAlignmentOverride(string4);
                    string3 = string2;
                    if (n3 == -1) continue;
                    n2 = n3;
                    string3 = string2;
                }
                catch (RuntimeException runtimeException) {
                    string3 = string2;
                    continue;
                }
                break;
            }
            return new Overrides(n2, (PointF)string3);
        }

        private static PointF parsePosition(String string2) {
            block6: {
                CharSequence charSequence;
                block5: {
                    boolean bl;
                    Matcher matcher;
                    block4: {
                        Matcher matcher2 = POSITION_PATTERN.matcher(string2);
                        matcher = MOVE_PATTERN.matcher(string2);
                        boolean bl2 = matcher2.find();
                        bl = matcher.find();
                        if (!bl2) break block4;
                        if (bl) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("Override has both \\pos(x,y) and \\move(x1,y1,x2,y2); using \\pos values. override='");
                            ((StringBuilder)charSequence).append(string2);
                            ((StringBuilder)charSequence).append("'");
                            Log.i(TAG, ((StringBuilder)charSequence).toString());
                        }
                        charSequence = matcher2.group(1);
                        string2 = matcher2.group(2);
                        break block5;
                    }
                    if (!bl) break block6;
                    charSequence = matcher.group(1);
                    string2 = matcher.group(2);
                }
                return new PointF(Float.parseFloat(((String)Assertions.checkNotNull(charSequence)).trim()), Float.parseFloat(Assertions.checkNotNull(string2).trim()));
            }
            return null;
        }

        public static String stripStyleOverrides(String string2) {
            return BRACES_PATTERN.matcher(string2).replaceAll("");
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SsaAlignment {
    }
}

