/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.pgs;

import android.graphics.Bitmap;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.SimpleSubtitleDecoder;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.pgs.PgsSubtitle;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.Inflater;

public final class PgsDecoder
extends SimpleSubtitleDecoder {
    private static final byte INFLATE_HEADER = 120;
    private static final int SECTION_TYPE_BITMAP_PICTURE = 21;
    private static final int SECTION_TYPE_END = 128;
    private static final int SECTION_TYPE_IDENTIFIER = 22;
    private static final int SECTION_TYPE_PALETTE = 20;
    private final ParsableByteArray buffer = new ParsableByteArray();
    private final CueBuilder cueBuilder;
    private final ParsableByteArray inflatedBuffer = new ParsableByteArray();
    private Inflater inflater;

    public PgsDecoder() {
        super("PgsDecoder");
        this.cueBuilder = new CueBuilder();
    }

    private void maybeInflateData(ParsableByteArray parsableByteArray) {
        if (parsableByteArray.bytesLeft() > 0 && parsableByteArray.peekUnsignedByte() == 120) {
            if (this.inflater == null) {
                this.inflater = new Inflater();
            }
            if (Util.inflate(parsableByteArray, this.inflatedBuffer, this.inflater)) {
                parsableByteArray.reset(this.inflatedBuffer.getData(), this.inflatedBuffer.limit());
            }
        }
    }

    private static Cue readNextSection(ParsableByteArray parsableByteArray, CueBuilder object) {
        int n2 = parsableByteArray.limit();
        int n3 = parsableByteArray.readUnsignedByte();
        int n4 = parsableByteArray.readUnsignedShort();
        int n5 = parsableByteArray.getPosition() + n4;
        Cue cue = null;
        if (n5 > n2) {
            parsableByteArray.setPosition(n2);
            return null;
        }
        if (n3 != 128) {
            switch (n3) {
                default: {
                    object = cue;
                    break;
                }
                case 22: {
                    ((CueBuilder)object).parseIdentifierSection(parsableByteArray, n4);
                    object = cue;
                    break;
                }
                case 21: {
                    ((CueBuilder)object).parseBitmapSection(parsableByteArray, n4);
                    object = cue;
                    break;
                }
                case 20: {
                    ((CueBuilder)object).parsePaletteSection(parsableByteArray, n4);
                    object = cue;
                    break;
                }
            }
        } else {
            cue = ((CueBuilder)object).build();
            ((CueBuilder)object).reset();
            object = cue;
        }
        parsableByteArray.setPosition(n5);
        return object;
    }

    @Override
    protected Subtitle decode(byte[] object, int n2, boolean bl) throws SubtitleDecoderException {
        this.buffer.reset((byte[])object, n2);
        this.maybeInflateData(this.buffer);
        this.cueBuilder.reset();
        object = new ArrayList();
        while (this.buffer.bytesLeft() >= 3) {
            Cue cue = PgsDecoder.readNextSection(this.buffer, this.cueBuilder);
            if (cue == null) continue;
            ((ArrayList)object).add(cue);
        }
        return new PgsSubtitle(Collections.unmodifiableList(object));
    }

    private static final class CueBuilder {
        private final ParsableByteArray bitmapData = new ParsableByteArray();
        private int bitmapHeight;
        private int bitmapWidth;
        private int bitmapX;
        private int bitmapY;
        private final int[] colors = new int[256];
        private boolean colorsSet;
        private int planeHeight;
        private int planeWidth;

        private void parseBitmapSection(ParsableByteArray parsableByteArray, int n2) {
            int n3;
            if (n2 < 4) {
                return;
            }
            parsableByteArray.skipBytes(3);
            int n4 = (parsableByteArray.readUnsignedByte() & 0x80) != 0 ? 1 : 0;
            n2 = n3 = n2 - 4;
            if (n4 != 0) {
                if (n3 < 7) {
                    return;
                }
                n2 = parsableByteArray.readUnsignedInt24();
                if (n2 < 4) {
                    return;
                }
                this.bitmapWidth = parsableByteArray.readUnsignedShort();
                this.bitmapHeight = parsableByteArray.readUnsignedShort();
                this.bitmapData.reset(n2 - 4);
                n2 = n3 - 7;
            }
            if ((n4 = this.bitmapData.getPosition()) < (n3 = this.bitmapData.limit()) && n2 > 0) {
                n2 = Math.min(n2, n3 - n4);
                parsableByteArray.readBytes(this.bitmapData.getData(), n4, n2);
                this.bitmapData.setPosition(n4 + n2);
            }
        }

        private void parseIdentifierSection(ParsableByteArray parsableByteArray, int n2) {
            if (n2 < 19) {
                return;
            }
            this.planeWidth = parsableByteArray.readUnsignedShort();
            this.planeHeight = parsableByteArray.readUnsignedShort();
            parsableByteArray.skipBytes(11);
            this.bitmapX = parsableByteArray.readUnsignedShort();
            this.bitmapY = parsableByteArray.readUnsignedShort();
        }

        private void parsePaletteSection(ParsableByteArray parsableByteArray, int n2) {
            if (n2 % 5 != 2) {
                return;
            }
            parsableByteArray.skipBytes(2);
            Arrays.fill(this.colors, 0);
            int n3 = n2 / 5;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = parsableByteArray.readUnsignedByte();
                int n5 = parsableByteArray.readUnsignedByte();
                int n6 = parsableByteArray.readUnsignedByte();
                int n7 = parsableByteArray.readUnsignedByte();
                int n8 = parsableByteArray.readUnsignedByte();
                double d2 = n5;
                double d3 = n6 - 128;
                Double.isNaN(d3);
                Double.isNaN(d2);
                n5 = (int)(1.402 * d3 + d2);
                double d4 = n7 - 128;
                Double.isNaN(d4);
                Double.isNaN(d2);
                Double.isNaN(d3);
                n6 = (int)(d2 - 0.34414 * d4 - d3 * 0.71414);
                Double.isNaN(d4);
                Double.isNaN(d2);
                n7 = (int)(d2 + d4 * 1.772);
                int[] nArray = this.colors;
                n5 = Util.constrainValue(n5, 0, 255);
                n6 = Util.constrainValue(n6, 0, 255);
                nArray[n4] = Util.constrainValue(n7, 0, 255) | (n6 << 8 | (n8 << 24 | n5 << 16));
            }
            this.colorsSet = true;
        }

        public Cue build() {
            if (this.planeWidth != 0 && this.planeHeight != 0 && this.bitmapWidth != 0 && this.bitmapHeight != 0 && this.bitmapData.limit() != 0 && this.bitmapData.getPosition() == this.bitmapData.limit() && this.colorsSet) {
                this.bitmapData.setPosition(0);
                Object object = new int[this.bitmapWidth * this.bitmapHeight];
                int n2 = 0;
                while (n2 < ((int[])object).length) {
                    int n3;
                    int n4 = this.bitmapData.readUnsignedByte();
                    if (n4 != 0) {
                        n3 = n2 + 1;
                        object[n2] = this.colors[n4];
                        n2 = n3;
                        continue;
                    }
                    n4 = this.bitmapData.readUnsignedByte();
                    if (n4 == 0) continue;
                    n3 = (n4 & 0x40) == 0 ? n4 & 0x3F : (n4 & 0x3F) << 8 | this.bitmapData.readUnsignedByte();
                    n4 = (n4 & 0x80) == 0 ? 0 : this.colors[this.bitmapData.readUnsignedByte()];
                    Arrays.fill(object, n2, n3 += n2, n4);
                    n2 = n3;
                }
                object = Bitmap.createBitmap((int[])object, (int)this.bitmapWidth, (int)this.bitmapHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                return new Cue.Builder().setBitmap((Bitmap)object).setPosition((float)this.bitmapX / (float)this.planeWidth).setPositionAnchor(0).setLine((float)this.bitmapY / (float)this.planeHeight, 0).setLineAnchor(0).setSize((float)this.bitmapWidth / (float)this.planeWidth).setBitmapHeight((float)this.bitmapHeight / (float)this.planeHeight).build();
            }
            return null;
        }

        public void reset() {
            this.planeWidth = 0;
            this.planeHeight = 0;
            this.bitmapX = 0;
            this.bitmapY = 0;
            this.bitmapWidth = 0;
            this.bitmapHeight = 0;
            this.bitmapData.reset(0);
            this.colorsSet = false;
        }
    }
}

