/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.cea;

import com.google.android.exoplayer2.decoder.OutputBuffer;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.SubtitleOutputBuffer;
import com.google.android.exoplayer2.text.cea._$$Lambda$U1BC5HyvT8rXefchROWTJPMwz_Y;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.PriorityQueue;

abstract class CeaDecoder
implements SubtitleDecoder {
    private static final int NUM_INPUT_BUFFERS = 10;
    private static final int NUM_OUTPUT_BUFFERS = 2;
    private final ArrayDeque<CeaInputBuffer> availableInputBuffers = new ArrayDeque();
    private final ArrayDeque<SubtitleOutputBuffer> availableOutputBuffers;
    private CeaInputBuffer dequeuedInputBuffer;
    private long playbackPositionUs;
    private long queuedInputBufferCount;
    private final PriorityQueue<CeaInputBuffer> queuedInputBuffers;

    public CeaDecoder() {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 10; ++n2) {
            this.availableInputBuffers.add(new CeaInputBuffer());
        }
        this.availableOutputBuffers = new ArrayDeque();
        for (n2 = n3; n2 < 2; ++n2) {
            this.availableOutputBuffers.add(new CeaOutputBuffer(new _$$Lambda$U1BC5HyvT8rXefchROWTJPMwz_Y(this)));
        }
        this.queuedInputBuffers = new PriorityQueue();
    }

    private void releaseInputBuffer(CeaInputBuffer ceaInputBuffer) {
        ceaInputBuffer.clear();
        this.availableInputBuffers.add(ceaInputBuffer);
    }

    protected abstract Subtitle createSubtitle();

    protected abstract void decode(SubtitleInputBuffer var1);

    @Override
    public SubtitleInputBuffer dequeueInputBuffer() throws SubtitleDecoderException {
        boolean bl = this.dequeuedInputBuffer == null;
        Assertions.checkState(bl);
        if (this.availableInputBuffers.isEmpty()) {
            return null;
        }
        this.dequeuedInputBuffer = this.availableInputBuffers.pollFirst();
        return this.dequeuedInputBuffer;
    }

    @Override
    public SubtitleOutputBuffer dequeueOutputBuffer() throws SubtitleDecoderException {
        if (this.availableOutputBuffers.isEmpty()) {
            return null;
        }
        while (!this.queuedInputBuffers.isEmpty() && Util.castNonNull(this.queuedInputBuffers.peek()).timeUs <= this.playbackPositionUs) {
            CeaInputBuffer ceaInputBuffer = Util.castNonNull(this.queuedInputBuffers.poll());
            if (ceaInputBuffer.isEndOfStream()) {
                SubtitleOutputBuffer subtitleOutputBuffer = Util.castNonNull(this.availableOutputBuffers.pollFirst());
                subtitleOutputBuffer.addFlag(4);
                this.releaseInputBuffer(ceaInputBuffer);
                return subtitleOutputBuffer;
            }
            this.decode(ceaInputBuffer);
            if (this.isNewSubtitleDataAvailable()) {
                Subtitle subtitle = this.createSubtitle();
                SubtitleOutputBuffer subtitleOutputBuffer = Util.castNonNull(this.availableOutputBuffers.pollFirst());
                subtitleOutputBuffer.setContent(ceaInputBuffer.timeUs, subtitle, Long.MAX_VALUE);
                this.releaseInputBuffer(ceaInputBuffer);
                return subtitleOutputBuffer;
            }
            this.releaseInputBuffer(ceaInputBuffer);
        }
        return null;
    }

    @Override
    public void flush() {
        this.queuedInputBufferCount = 0L;
        this.playbackPositionUs = 0L;
        while (!this.queuedInputBuffers.isEmpty()) {
            this.releaseInputBuffer(Util.castNonNull(this.queuedInputBuffers.poll()));
        }
        CeaInputBuffer ceaInputBuffer = this.dequeuedInputBuffer;
        if (ceaInputBuffer != null) {
            this.releaseInputBuffer(ceaInputBuffer);
            this.dequeuedInputBuffer = null;
        }
    }

    protected final SubtitleOutputBuffer getAvailableOutputBuffer() {
        return this.availableOutputBuffers.pollFirst();
    }

    @Override
    public abstract String getName();

    protected final long getPositionUs() {
        return this.playbackPositionUs;
    }

    protected abstract boolean isNewSubtitleDataAvailable();

    @Override
    public void queueInputBuffer(SubtitleInputBuffer subtitleInputBuffer) throws SubtitleDecoderException {
        boolean bl = subtitleInputBuffer == this.dequeuedInputBuffer;
        Assertions.checkArgument(bl);
        subtitleInputBuffer = (CeaInputBuffer)subtitleInputBuffer;
        if (subtitleInputBuffer.isDecodeOnly()) {
            this.releaseInputBuffer((CeaInputBuffer)subtitleInputBuffer);
        } else {
            long l2 = this.queuedInputBufferCount;
            this.queuedInputBufferCount = 1L + l2;
            CeaInputBuffer.access$102((CeaInputBuffer)subtitleInputBuffer, l2);
            this.queuedInputBuffers.add((CeaInputBuffer)subtitleInputBuffer);
        }
        this.dequeuedInputBuffer = null;
    }

    @Override
    public void release() {
    }

    protected void releaseOutputBuffer(SubtitleOutputBuffer subtitleOutputBuffer) {
        subtitleOutputBuffer.clear();
        this.availableOutputBuffers.add(subtitleOutputBuffer);
    }

    @Override
    public void setPositionUs(long l2) {
        this.playbackPositionUs = l2;
    }

    private static final class CeaInputBuffer
    extends SubtitleInputBuffer
    implements Comparable<CeaInputBuffer> {
        private long queuedInputBufferCount;

        private CeaInputBuffer() {
        }

        static /* synthetic */ long access$102(CeaInputBuffer ceaInputBuffer, long l2) {
            ceaInputBuffer.queuedInputBufferCount = l2;
            return l2;
        }

        @Override
        public int compareTo(CeaInputBuffer ceaInputBuffer) {
            long l2;
            boolean bl = this.isEndOfStream();
            boolean bl2 = ceaInputBuffer.isEndOfStream();
            int n2 = 1;
            int n3 = 1;
            if (bl != bl2) {
                if (!this.isEndOfStream()) {
                    n3 = -1;
                }
                return n3;
            }
            long l3 = l2 = this.timeUs - ceaInputBuffer.timeUs;
            if (l2 == 0L) {
                l3 = l2 = this.queuedInputBufferCount - ceaInputBuffer.queuedInputBufferCount;
                if (l2 == 0L) {
                    return 0;
                }
            }
            n3 = l3 > 0L ? n2 : -1;
            return n3;
        }
    }

    private static final class CeaOutputBuffer
    extends SubtitleOutputBuffer {
        private OutputBuffer.Owner<CeaOutputBuffer> owner;

        public CeaOutputBuffer(OutputBuffer.Owner<CeaOutputBuffer> owner) {
            this.owner = owner;
        }

        public final void release() {
            this.owner.releaseOutputBuffer((OutputBuffer)this);
        }
    }
}

