/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text.cea;

import android.graphics.Color;
import android.text.Layout;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.cea.CeaDecoder;
import com.google.android.exoplayer2.text.cea.CeaSubtitle;
import com.google.android.exoplayer2.text.cea._$;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Cea708Decoder
extends CeaDecoder {
    private static final int CC_VALID_FLAG = 4;
    private static final int CHARACTER_BIG_CARONS = 42;
    private static final int CHARACTER_BIG_OE = 44;
    private static final int CHARACTER_BOLD_BULLET = 53;
    private static final int CHARACTER_CLOSE_DOUBLE_QUOTE = 52;
    private static final int CHARACTER_CLOSE_SINGLE_QUOTE = 50;
    private static final int CHARACTER_DIAERESIS_Y = 63;
    private static final int CHARACTER_ELLIPSIS = 37;
    private static final int CHARACTER_FIVE_EIGHTHS = 120;
    private static final int CHARACTER_HORIZONTAL_BORDER = 125;
    private static final int CHARACTER_LOWER_LEFT_BORDER = 124;
    private static final int CHARACTER_LOWER_RIGHT_BORDER = 126;
    private static final int CHARACTER_MN = 127;
    private static final int CHARACTER_NBTSP = 33;
    private static final int CHARACTER_ONE_EIGHTH = 118;
    private static final int CHARACTER_OPEN_DOUBLE_QUOTE = 51;
    private static final int CHARACTER_OPEN_SINGLE_QUOTE = 49;
    private static final int CHARACTER_SEVEN_EIGHTHS = 121;
    private static final int CHARACTER_SM = 61;
    private static final int CHARACTER_SMALL_CARONS = 58;
    private static final int CHARACTER_SMALL_OE = 60;
    private static final int CHARACTER_SOLID_BLOCK = 48;
    private static final int CHARACTER_THREE_EIGHTHS = 119;
    private static final int CHARACTER_TM = 57;
    private static final int CHARACTER_TSP = 32;
    private static final int CHARACTER_UPPER_LEFT_BORDER = 127;
    private static final int CHARACTER_UPPER_RIGHT_BORDER = 123;
    private static final int CHARACTER_VERTICAL_BORDER = 122;
    private static final int COMMAND_BS = 8;
    private static final int COMMAND_CLW = 136;
    private static final int COMMAND_CR = 13;
    private static final int COMMAND_CW0 = 128;
    private static final int COMMAND_CW1 = 129;
    private static final int COMMAND_CW2 = 130;
    private static final int COMMAND_CW3 = 131;
    private static final int COMMAND_CW4 = 132;
    private static final int COMMAND_CW5 = 133;
    private static final int COMMAND_CW6 = 134;
    private static final int COMMAND_CW7 = 135;
    private static final int COMMAND_DF0 = 152;
    private static final int COMMAND_DF1 = 153;
    private static final int COMMAND_DF2 = 154;
    private static final int COMMAND_DF3 = 155;
    private static final int COMMAND_DF4 = 156;
    private static final int COMMAND_DF5 = 157;
    private static final int COMMAND_DF6 = 158;
    private static final int COMMAND_DF7 = 159;
    private static final int COMMAND_DLC = 142;
    private static final int COMMAND_DLW = 140;
    private static final int COMMAND_DLY = 141;
    private static final int COMMAND_DSW = 137;
    private static final int COMMAND_ETX = 3;
    private static final int COMMAND_EXT1 = 16;
    private static final int COMMAND_EXT1_END = 23;
    private static final int COMMAND_EXT1_START = 17;
    private static final int COMMAND_FF = 12;
    private static final int COMMAND_HCR = 14;
    private static final int COMMAND_HDW = 138;
    private static final int COMMAND_NUL = 0;
    private static final int COMMAND_P16_END = 31;
    private static final int COMMAND_P16_START = 24;
    private static final int COMMAND_RST = 143;
    private static final int COMMAND_SPA = 144;
    private static final int COMMAND_SPC = 145;
    private static final int COMMAND_SPL = 146;
    private static final int COMMAND_SWA = 151;
    private static final int COMMAND_TGW = 139;
    private static final int DTVCC_PACKET_DATA = 2;
    private static final int DTVCC_PACKET_START = 3;
    private static final int GROUP_C0_END = 31;
    private static final int GROUP_C1_END = 159;
    private static final int GROUP_C2_END = 31;
    private static final int GROUP_C3_END = 159;
    private static final int GROUP_G0_END = 127;
    private static final int GROUP_G1_END = 255;
    private static final int GROUP_G2_END = 127;
    private static final int GROUP_G3_END = 255;
    private static final int NUM_WINDOWS = 8;
    private static final String TAG = "Cea708Decoder";
    private final ParsableByteArray ccData = new ParsableByteArray();
    private final CueInfoBuilder[] cueInfoBuilders;
    private List<Cue> cues;
    private CueInfoBuilder currentCueInfoBuilder;
    private DtvCcPacket currentDtvCcPacket;
    private int currentWindow;
    private final boolean isWideAspectRatio;
    private List<Cue> lastCues;
    private int previousSequenceNumber = -1;
    private final int selectedServiceNumber;
    private final ParsableBitArray serviceBlockPacket = new ParsableBitArray();

    public Cea708Decoder(int n2, List<byte[]> list) {
        boolean bl = true;
        int n3 = n2;
        if (n2 == -1) {
            n3 = 1;
        }
        this.selectedServiceNumber = n3;
        if (list == null || !CodecSpecificDataUtil.parseCea708InitializationData(list)) {
            bl = false;
        }
        this.isWideAspectRatio = bl;
        this.cueInfoBuilders = new CueInfoBuilder[8];
        for (n2 = 0; n2 < 8; ++n2) {
            this.cueInfoBuilders[n2] = new CueInfoBuilder();
        }
        this.currentCueInfoBuilder = this.cueInfoBuilders[0];
    }

    private void finalizeCurrentPacket() {
        if (this.currentDtvCcPacket == null) {
            return;
        }
        this.processCurrentPacket();
        this.currentDtvCcPacket = null;
    }

    private List<Cue> getDisplayCues() {
        Object object;
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            if (this.cueInfoBuilders[n2].isEmpty() || !this.cueInfoBuilders[n2].isVisible() || (object = this.cueInfoBuilders[n2].build()) == null) continue;
            arrayList.add(object);
        }
        Collections.sort(arrayList, Cea708CueInfo.LEAST_IMPORTANT_FIRST);
        object = new ArrayList<Cue>(arrayList.size());
        for (n2 = n3; n2 < arrayList.size(); ++n2) {
            object.add(((Cea708CueInfo)arrayList.get((int)n2)).cue);
        }
        return Collections.unmodifiableList(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleC0Command(int n2) {
        if (n2 == 0) return;
        if (n2 != 3) {
            if (n2 != 8) {
                switch (n2) {
                    default: {
                        if (n2 >= 17 && n2 <= 23) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Currently unsupported COMMAND_EXT1 Command: ");
                            stringBuilder.append(n2);
                            Log.w(TAG, stringBuilder.toString());
                            this.serviceBlockPacket.skipBits(8);
                            return;
                        } else if (n2 >= 24 && n2 <= 31) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Currently unsupported COMMAND_P16 Command: ");
                            stringBuilder.append(n2);
                            Log.w(TAG, stringBuilder.toString());
                            this.serviceBlockPacket.skipBits(16);
                            return;
                        } else {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Invalid C0 command: ");
                            stringBuilder.append(n2);
                            Log.w(TAG, stringBuilder.toString());
                        }
                        return;
                    }
                    case 13: {
                        this.currentCueInfoBuilder.append('\n');
                        return;
                    }
                    case 12: {
                        this.resetCueBuilders();
                        return;
                    }
                    case 14: {
                        return;
                    }
                }
            }
            this.currentCueInfoBuilder.backspace();
            return;
        }
        this.cues = this.getDisplayCues();
    }

    private void handleC1Command(int n2) {
        switch (n2) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid C1 command: ");
                stringBuilder.append(n2);
                Log.w(TAG, stringBuilder.toString());
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                this.handleDefineWindow(n2 -= 152);
                if (this.currentWindow == n2) break;
                this.currentWindow = n2;
                this.currentCueInfoBuilder = this.cueInfoBuilders[n2];
                break;
            }
            case 151: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(32);
                    break;
                }
                this.handleSetWindowAttributes();
                break;
            }
            case 146: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(16);
                    break;
                }
                this.handleSetPenLocation();
                break;
            }
            case 145: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(24);
                    break;
                }
                this.handleSetPenColor();
                break;
            }
            case 144: {
                if (!this.currentCueInfoBuilder.isDefined()) {
                    this.serviceBlockPacket.skipBits(16);
                    break;
                }
                this.handleSetPenAttributes();
                break;
            }
            case 143: {
                this.resetCueBuilders();
                break;
            }
            case 141: {
                this.serviceBlockPacket.skipBits(8);
                break;
            }
            case 140: {
                for (int i2 = 1; i2 <= 8; ++i2) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - i2].reset();
                }
                break;
            }
            case 139: {
                for (n2 = 1; n2 <= 8; ++n2) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    CueInfoBuilder cueInfoBuilder = this.cueInfoBuilders[8 - n2];
                    cueInfoBuilder.setVisibility(cueInfoBuilder.isVisible() ^ true);
                }
                break;
            }
            case 138: {
                for (int i3 = 1; i3 <= 8; ++i3) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - i3].setVisibility(false);
                }
                break;
            }
            case 137: {
                for (n2 = 1; n2 <= 8; ++n2) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - n2].setVisibility(true);
                }
                break;
            }
            case 136: {
                for (int i4 = 1; i4 <= 8; ++i4) {
                    if (!this.serviceBlockPacket.readBit()) continue;
                    this.cueInfoBuilders[8 - i4].clear();
                }
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                if (this.currentWindow == (n2 -= 128)) break;
                this.currentWindow = n2;
                this.currentCueInfoBuilder = this.cueInfoBuilders[n2];
            }
            case 142: 
        }
    }

    private void handleC2Command(int n2) {
        if (n2 > 7) {
            if (n2 <= 15) {
                this.serviceBlockPacket.skipBits(8);
            } else if (n2 <= 23) {
                this.serviceBlockPacket.skipBits(16);
            } else if (n2 <= 31) {
                this.serviceBlockPacket.skipBits(24);
            }
        }
    }

    private void handleC3Command(int n2) {
        if (n2 <= 135) {
            this.serviceBlockPacket.skipBits(32);
        } else if (n2 <= 143) {
            this.serviceBlockPacket.skipBits(40);
        } else if (n2 <= 159) {
            this.serviceBlockPacket.skipBits(2);
            n2 = this.serviceBlockPacket.readBits(6);
            this.serviceBlockPacket.skipBits(n2 * 8);
        }
    }

    private void handleDefineWindow(int n2) {
        CueInfoBuilder cueInfoBuilder = this.cueInfoBuilders[n2];
        this.serviceBlockPacket.skipBits(2);
        boolean bl = this.serviceBlockPacket.readBit();
        boolean bl2 = this.serviceBlockPacket.readBit();
        boolean bl3 = this.serviceBlockPacket.readBit();
        int n3 = this.serviceBlockPacket.readBits(3);
        boolean bl4 = this.serviceBlockPacket.readBit();
        int n4 = this.serviceBlockPacket.readBits(7);
        n2 = this.serviceBlockPacket.readBits(8);
        int n5 = this.serviceBlockPacket.readBits(4);
        int n6 = this.serviceBlockPacket.readBits(4);
        this.serviceBlockPacket.skipBits(2);
        int n7 = this.serviceBlockPacket.readBits(6);
        this.serviceBlockPacket.skipBits(2);
        cueInfoBuilder.defineWindow(bl, bl2, bl3, n3, bl4, n4, n2, n6, n7, n5, this.serviceBlockPacket.readBits(3), this.serviceBlockPacket.readBits(3));
    }

    private void handleG0Character(int n2) {
        if (n2 == 127) {
            this.currentCueInfoBuilder.append('\u266b');
        } else {
            this.currentCueInfoBuilder.append((char)(n2 & 0xFF));
        }
    }

    private void handleG1Character(int n2) {
        this.currentCueInfoBuilder.append((char)(n2 & 0xFF));
    }

    private void handleG2Character(int n2) {
        if (n2 != 32) {
            if (n2 != 33) {
                if (n2 != 37) {
                    if (n2 != 42) {
                        if (n2 != 44) {
                            if (n2 != 63) {
                                if (n2 != 57) {
                                    if (n2 != 58) {
                                        if (n2 != 60) {
                                            if (n2 != 61) {
                                                block0 : switch (n2) {
                                                    default: {
                                                        switch (n2) {
                                                            default: {
                                                                StringBuilder stringBuilder = new StringBuilder();
                                                                stringBuilder.append("Invalid G2 character: ");
                                                                stringBuilder.append(n2);
                                                                Log.w(TAG, stringBuilder.toString());
                                                                break block0;
                                                            }
                                                            case 127: {
                                                                this.currentCueInfoBuilder.append('\u250c');
                                                                break block0;
                                                            }
                                                            case 126: {
                                                                this.currentCueInfoBuilder.append('\u2518');
                                                                break block0;
                                                            }
                                                            case 125: {
                                                                this.currentCueInfoBuilder.append('\u2500');
                                                                break block0;
                                                            }
                                                            case 124: {
                                                                this.currentCueInfoBuilder.append('\u2514');
                                                                break block0;
                                                            }
                                                            case 123: {
                                                                this.currentCueInfoBuilder.append('\u2510');
                                                                break block0;
                                                            }
                                                            case 122: {
                                                                this.currentCueInfoBuilder.append('\u2502');
                                                                break block0;
                                                            }
                                                            case 121: {
                                                                this.currentCueInfoBuilder.append('\u215e');
                                                                break block0;
                                                            }
                                                            case 120: {
                                                                this.currentCueInfoBuilder.append('\u215d');
                                                                break block0;
                                                            }
                                                            case 119: {
                                                                this.currentCueInfoBuilder.append('\u215c');
                                                                break block0;
                                                            }
                                                            case 118: 
                                                        }
                                                        this.currentCueInfoBuilder.append('\u215b');
                                                        break;
                                                    }
                                                    case 53: {
                                                        this.currentCueInfoBuilder.append('\u2022');
                                                        break;
                                                    }
                                                    case 52: {
                                                        this.currentCueInfoBuilder.append('\u201d');
                                                        break;
                                                    }
                                                    case 51: {
                                                        this.currentCueInfoBuilder.append('\u201c');
                                                        break;
                                                    }
                                                    case 50: {
                                                        this.currentCueInfoBuilder.append('\u2019');
                                                        break;
                                                    }
                                                    case 49: {
                                                        this.currentCueInfoBuilder.append('\u2018');
                                                        break;
                                                    }
                                                    case 48: {
                                                        this.currentCueInfoBuilder.append('\u2588');
                                                        break;
                                                    }
                                                }
                                            } else {
                                                this.currentCueInfoBuilder.append('\u2120');
                                            }
                                        } else {
                                            this.currentCueInfoBuilder.append('\u0153');
                                        }
                                    } else {
                                        this.currentCueInfoBuilder.append('\u0161');
                                    }
                                } else {
                                    this.currentCueInfoBuilder.append('\u2122');
                                }
                            } else {
                                this.currentCueInfoBuilder.append('\u0178');
                            }
                        } else {
                            this.currentCueInfoBuilder.append('\u0152');
                        }
                    } else {
                        this.currentCueInfoBuilder.append('\u0160');
                    }
                } else {
                    this.currentCueInfoBuilder.append('\u2026');
                }
            } else {
                this.currentCueInfoBuilder.append('\u00a0');
            }
        } else {
            this.currentCueInfoBuilder.append(' ');
        }
    }

    private void handleG3Character(int n2) {
        if (n2 == 160) {
            this.currentCueInfoBuilder.append('\u33c4');
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid G3 character: ");
            stringBuilder.append(n2);
            Log.w(TAG, stringBuilder.toString());
            this.currentCueInfoBuilder.append('_');
        }
    }

    private void handleSetPenAttributes() {
        int n2 = this.serviceBlockPacket.readBits(4);
        int n3 = this.serviceBlockPacket.readBits(2);
        int n4 = this.serviceBlockPacket.readBits(2);
        boolean bl = this.serviceBlockPacket.readBit();
        boolean bl2 = this.serviceBlockPacket.readBit();
        int n5 = this.serviceBlockPacket.readBits(3);
        int n6 = this.serviceBlockPacket.readBits(3);
        this.currentCueInfoBuilder.setPenAttributes(n2, n3, n4, bl, bl2, n5, n6);
    }

    private void handleSetPenColor() {
        int n2 = this.serviceBlockPacket.readBits(2);
        n2 = CueInfoBuilder.getArgbColorFromCeaColor(this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), n2);
        int n3 = this.serviceBlockPacket.readBits(2);
        int n4 = CueInfoBuilder.getArgbColorFromCeaColor(this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), n3);
        this.serviceBlockPacket.skipBits(2);
        n3 = CueInfoBuilder.getArgbColorFromCeaColor(this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2));
        this.currentCueInfoBuilder.setPenColor(n2, n4, n3);
    }

    private void handleSetPenLocation() {
        this.serviceBlockPacket.skipBits(4);
        int n2 = this.serviceBlockPacket.readBits(4);
        this.serviceBlockPacket.skipBits(2);
        int n3 = this.serviceBlockPacket.readBits(6);
        this.currentCueInfoBuilder.setPenLocation(n2, n3);
    }

    private void handleSetWindowAttributes() {
        int n2 = this.serviceBlockPacket.readBits(2);
        int n3 = CueInfoBuilder.getArgbColorFromCeaColor(this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), n2);
        int n4 = this.serviceBlockPacket.readBits(2);
        int n5 = CueInfoBuilder.getArgbColorFromCeaColor(this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2), this.serviceBlockPacket.readBits(2));
        n2 = n4;
        if (this.serviceBlockPacket.readBit()) {
            n2 = n4 | 4;
        }
        boolean bl = this.serviceBlockPacket.readBit();
        n4 = this.serviceBlockPacket.readBits(2);
        int n6 = this.serviceBlockPacket.readBits(2);
        int n7 = this.serviceBlockPacket.readBits(2);
        this.serviceBlockPacket.skipBits(8);
        this.currentCueInfoBuilder.setWindowAttributes(n3, n5, bl, n2, n4, n6, n7);
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresNonNull(value={"currentDtvCcPacket"})
    private void processCurrentPacket() {
        StringBuilder stringBuilder;
        if (this.currentDtvCcPacket.currentIndex != this.currentDtvCcPacket.packetSize * 2 - 1) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("DtvCcPacket ended prematurely; size is ");
            stringBuilder.append(this.currentDtvCcPacket.packetSize * 2 - 1);
            stringBuilder.append(", but current index is ");
            stringBuilder.append(this.currentDtvCcPacket.currentIndex);
            stringBuilder.append(" (sequence number ");
            stringBuilder.append(this.currentDtvCcPacket.sequenceNumber);
            stringBuilder.append(");");
            Log.d(TAG, stringBuilder.toString());
        }
        this.serviceBlockPacket.reset(this.currentDtvCcPacket.packetData, this.currentDtvCcPacket.currentIndex);
        int n2 = this.serviceBlockPacket.readBits(3);
        int n3 = this.serviceBlockPacket.readBits(5);
        int n4 = n2;
        if (n2 == 7) {
            this.serviceBlockPacket.skipBits(2);
            n4 = n2 = this.serviceBlockPacket.readBits(6);
            if (n2 < 7) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid extended service number: ");
                stringBuilder.append(n2);
                Log.w(TAG, stringBuilder.toString());
                n4 = n2;
            }
        }
        if (n3 == 0) {
            if (n4 != 0) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("serviceNumber is non-zero (");
                stringBuilder.append(n4);
                stringBuilder.append(") when blockSize is 0");
                Log.w(TAG, stringBuilder.toString());
            }
            return;
        }
        if (n4 != this.selectedServiceNumber) {
            return;
        }
        n4 = 0;
        while (this.serviceBlockPacket.bitsLeft() > 0) {
            block23: {
                block19: {
                    block22: {
                        block20: {
                            block21: {
                                n2 = this.serviceBlockPacket.readBits(8);
                                if (n2 == 16) break block20;
                                if (n2 <= 31) {
                                    this.handleC0Command(n2);
                                    continue;
                                }
                                if (n2 > 127) break block21;
                                this.handleG0Character(n2);
                                break block19;
                            }
                            if (n2 <= 159) {
                                this.handleC1Command(n2);
                                break block19;
                            } else if (n2 <= 255) {
                                this.handleG1Character(n2);
                                break block19;
                            } else {
                                stringBuilder = new StringBuilder();
                                stringBuilder.append("Invalid base command: ");
                                stringBuilder.append(n2);
                                Log.w(TAG, stringBuilder.toString());
                                continue;
                            }
                        }
                        n2 = this.serviceBlockPacket.readBits(8);
                        if (n2 <= 31) {
                            this.handleC2Command(n2);
                            continue;
                        }
                        if (n2 > 127) break block22;
                        this.handleG2Character(n2);
                        break block19;
                    }
                    if (n2 <= 159) {
                        this.handleC3Command(n2);
                        continue;
                    }
                    if (n2 > 255) break block23;
                    this.handleG3Character(n2);
                }
                n4 = 1;
                continue;
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid extended command: ");
            stringBuilder.append(n2);
            Log.w(TAG, stringBuilder.toString());
        }
        if (n4 != 0) {
            this.cues = this.getDisplayCues();
        }
    }

    private void resetCueBuilders() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.cueInfoBuilders[i2].reset();
        }
    }

    @Override
    protected Subtitle createSubtitle() {
        List<Cue> list = this.cues;
        this.lastCues = list;
        return new CeaSubtitle(Assertions.checkNotNull(list));
    }

    @Override
    protected void decode(SubtitleInputBuffer object) {
        object = Assertions.checkNotNull(((SubtitleInputBuffer)object).data);
        Object object2 = ((ByteBuffer)object).array();
        this.ccData.reset(object2, ((Buffer)object).limit());
        while (this.ccData.bytesLeft() >= 3) {
            int n2 = this.ccData.readUnsignedByte() & 7;
            int n3 = n2 & 3;
            boolean bl = false;
            n2 = (n2 & 4) == 4 ? 1 : 0;
            byte by2 = (byte)this.ccData.readUnsignedByte();
            byte by3 = (byte)this.ccData.readUnsignedByte();
            if (n3 != 2 && n3 != 3 || n2 == 0) continue;
            if (n3 == 3) {
                this.finalizeCurrentPacket();
                int n4 = (by2 & 0xC0) >> 6;
                n2 = this.previousSequenceNumber;
                if (n2 != -1 && n4 != (n2 + 1) % 4) {
                    this.resetCueBuilders();
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Sequence number discontinuity. previous=");
                    ((StringBuilder)object).append(this.previousSequenceNumber);
                    ((StringBuilder)object).append(" current=");
                    ((StringBuilder)object).append(n4);
                    Log.w(TAG, ((StringBuilder)object).toString());
                }
                this.previousSequenceNumber = n4;
                n2 = n3 = by2 & 0x3F;
                if (n3 == 0) {
                    n2 = 64;
                }
                this.currentDtvCcPacket = new DtvCcPacket(n4, n2);
                object = this.currentDtvCcPacket.packetData;
                object2 = this.currentDtvCcPacket;
                n2 = object2.currentIndex;
                object2.currentIndex = n2 + 1;
                object[n2] = by3;
            } else {
                if (n3 == 2) {
                    bl = true;
                }
                Assertions.checkArgument(bl);
                object = this.currentDtvCcPacket;
                if (object == null) {
                    Log.e(TAG, "Encountered DTVCC_PACKET_DATA before DTVCC_PACKET_START");
                    continue;
                }
                object2 = ((DtvCcPacket)object).packetData;
                object = this.currentDtvCcPacket;
                n2 = ((DtvCcPacket)object).currentIndex;
                ((DtvCcPacket)object).currentIndex = n2 + 1;
                object2[n2] = by2;
                object2 = this.currentDtvCcPacket.packetData;
                object = this.currentDtvCcPacket;
                n2 = ((DtvCcPacket)object).currentIndex;
                ((DtvCcPacket)object).currentIndex = n2 + 1;
                object2[n2] = by3;
            }
            if (this.currentDtvCcPacket.currentIndex != this.currentDtvCcPacket.packetSize * 2 - 1) continue;
            this.finalizeCurrentPacket();
        }
    }

    @Override
    public void flush() {
        super.flush();
        this.cues = null;
        this.lastCues = null;
        this.currentWindow = 0;
        this.currentCueInfoBuilder = this.cueInfoBuilders[this.currentWindow];
        this.resetCueBuilders();
        this.currentDtvCcPacket = null;
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    protected boolean isNewSubtitleDataAvailable() {
        boolean bl = this.cues != this.lastCues;
        return bl;
    }

    private static final class Cea708CueInfo {
        private static final Comparator<Cea708CueInfo> LEAST_IMPORTANT_FIRST = _$.Lambda.Cea708Decoder.Cea708CueInfo.8f1il_zEcouq__x8remACEaVBv8.INSTANCE;
        public final Cue cue;
        public final int priority;

        public Cea708CueInfo(CharSequence object, Layout.Alignment alignment, float f2, int n2, int n3, float f3, int n4, float f4, boolean bl, int n5, int n6) {
            object = new Cue.Builder().setText((CharSequence)object).setTextAlignment(alignment).setLine(f2, n2).setLineAnchor(n3).setPosition(f3).setPositionAnchor(n4).setSize(f4);
            if (bl) {
                ((Cue.Builder)object).setWindowColor(n5);
            }
            this.cue = ((Cue.Builder)object).build();
            this.priority = n6;
        }

        static /* synthetic */ int lambda$static$0(Cea708CueInfo cea708CueInfo, Cea708CueInfo cea708CueInfo2) {
            return Integer.compare(cea708CueInfo2.priority, cea708CueInfo.priority);
        }
    }

    private static final class CueInfoBuilder {
        private static final int BORDER_AND_EDGE_TYPE_NONE = 0;
        private static final int BORDER_AND_EDGE_TYPE_UNIFORM = 3;
        public static final int COLOR_SOLID_BLACK;
        public static final int COLOR_SOLID_WHITE;
        public static final int COLOR_TRANSPARENT;
        private static final int DEFAULT_PRIORITY = 4;
        private static final int DIRECTION_BOTTOM_TO_TOP = 3;
        private static final int DIRECTION_LEFT_TO_RIGHT = 0;
        private static final int DIRECTION_RIGHT_TO_LEFT = 1;
        private static final int DIRECTION_TOP_TO_BOTTOM = 2;
        private static final int HORIZONTAL_SIZE = 209;
        private static final int JUSTIFICATION_CENTER = 2;
        private static final int JUSTIFICATION_FULL = 3;
        private static final int JUSTIFICATION_LEFT = 0;
        private static final int JUSTIFICATION_RIGHT = 1;
        private static final int MAXIMUM_ROW_COUNT = 15;
        private static final int PEN_FONT_STYLE_DEFAULT = 0;
        private static final int PEN_FONT_STYLE_MONOSPACED_WITHOUT_SERIFS = 3;
        private static final int PEN_FONT_STYLE_MONOSPACED_WITH_SERIFS = 1;
        private static final int PEN_FONT_STYLE_PROPORTIONALLY_SPACED_WITHOUT_SERIFS = 4;
        private static final int PEN_FONT_STYLE_PROPORTIONALLY_SPACED_WITH_SERIFS = 2;
        private static final int PEN_OFFSET_NORMAL = 1;
        private static final int PEN_SIZE_STANDARD = 1;
        private static final int[] PEN_STYLE_BACKGROUND;
        private static final int[] PEN_STYLE_EDGE_TYPE;
        private static final int[] PEN_STYLE_FONT_STYLE;
        private static final int RELATIVE_CUE_SIZE = 99;
        private static final int VERTICAL_SIZE = 74;
        private static final int[] WINDOW_STYLE_FILL;
        private static final int[] WINDOW_STYLE_JUSTIFICATION;
        private static final int[] WINDOW_STYLE_PRINT_DIRECTION;
        private static final int[] WINDOW_STYLE_SCROLL_DIRECTION;
        private static final boolean[] WINDOW_STYLE_WORD_WRAP;
        private int anchorId;
        private int backgroundColor;
        private int backgroundColorStartPosition;
        private final SpannableStringBuilder captionStringBuilder;
        private boolean defined;
        private int foregroundColor;
        private int foregroundColorStartPosition;
        private int horizontalAnchor;
        private int italicsStartPosition;
        private int justification;
        private int penStyleId;
        private int priority;
        private boolean relativePositioning;
        private final List<SpannableString> rolledUpCaptions = new ArrayList<SpannableString>();
        private int row;
        private int rowCount;
        private boolean rowLock;
        private int underlineStartPosition;
        private int verticalAnchor;
        private boolean visible;
        private int windowFillColor;
        private int windowStyleId;

        static {
            COLOR_SOLID_WHITE = CueInfoBuilder.getArgbColorFromCeaColor(2, 2, 2, 0);
            COLOR_SOLID_BLACK = CueInfoBuilder.getArgbColorFromCeaColor(0, 0, 0, 0);
            COLOR_TRANSPARENT = CueInfoBuilder.getArgbColorFromCeaColor(0, 0, 0, 3);
            WINDOW_STYLE_JUSTIFICATION = new int[]{0, 0, 0, 0, 0, 2, 0};
            WINDOW_STYLE_PRINT_DIRECTION = new int[]{0, 0, 0, 0, 0, 0, 2};
            WINDOW_STYLE_SCROLL_DIRECTION = new int[]{3, 3, 3, 3, 3, 3, 1};
            WINDOW_STYLE_WORD_WRAP = new boolean[]{false, false, false, true, true, true, false};
            int n2 = COLOR_SOLID_BLACK;
            int n3 = COLOR_TRANSPARENT;
            WINDOW_STYLE_FILL = new int[]{n2, n3, n2, n2, n3, n2, n2};
            PEN_STYLE_FONT_STYLE = new int[]{0, 1, 2, 3, 4, 3, 4};
            PEN_STYLE_EDGE_TYPE = new int[]{0, 0, 0, 0, 0, 3, 3};
            PEN_STYLE_BACKGROUND = new int[]{n2, n2, n2, n2, n2, n3, n3};
        }

        public CueInfoBuilder() {
            this.captionStringBuilder = new SpannableStringBuilder();
            this.reset();
        }

        public static int getArgbColorFromCeaColor(int n2, int n3, int n4) {
            return CueInfoBuilder.getArgbColorFromCeaColor(n2, n3, n4, 0);
        }

        /*
         * Unable to fully structure code
         */
        public static int getArgbColorFromCeaColor(int var0, int var1_1, int var2_2, int var3_3) {
            block5: {
                block4: {
                    var4_4 = 0;
                    Assertions.checkIndex(var0, 0, 4);
                    Assertions.checkIndex(var1_1, 0, 4);
                    Assertions.checkIndex(var2_2, 0, 4);
                    Assertions.checkIndex(var3_3, 0, 4);
                    if (var3_3 == 0 || var3_3 == 1) ** GOTO lbl-1000
                    if (var3_3 != 2) {
                        ** if (var3_3 == 3) goto lbl-1000
                    }
                    break block4;
lbl-1000:
                    // 2 sources

                    {
                        var3_3 = 255;
                        ** GOTO lbl20
                    }
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = 0;
                    }
                    break block5;
                }
                var3_3 = 127;
            }
            var0 = var0 > 1 ? 255 : 0;
            var1_1 = var1_1 > 1 ? 255 : 0;
            if (var2_2 > 1) {
                var4_4 = 255;
            }
            return Color.argb((int)var3_3, (int)var0, (int)var1_1, (int)var4_4);
        }

        public void append(char c2) {
            if (c2 == '\n') {
                this.rolledUpCaptions.add(this.buildSpannableString());
                this.captionStringBuilder.clear();
                if (this.italicsStartPosition != -1) {
                    this.italicsStartPosition = 0;
                }
                if (this.underlineStartPosition != -1) {
                    this.underlineStartPosition = 0;
                }
                if (this.foregroundColorStartPosition != -1) {
                    this.foregroundColorStartPosition = 0;
                }
                if (this.backgroundColorStartPosition != -1) {
                    this.backgroundColorStartPosition = 0;
                }
                while (this.rowLock && this.rolledUpCaptions.size() >= this.rowCount || this.rolledUpCaptions.size() >= 15) {
                    this.rolledUpCaptions.remove(0);
                }
            } else {
                this.captionStringBuilder.append(c2);
            }
        }

        public void backspace() {
            int n2 = this.captionStringBuilder.length();
            if (n2 > 0) {
                this.captionStringBuilder.delete(n2 - 1, n2);
            }
        }

        public Cea708CueInfo build() {
            float f2;
            float f3;
            Layout.Alignment alignment;
            int n2;
            boolean bl;
            SpannableStringBuilder spannableStringBuilder;
            block9: {
                block6: {
                    block7: {
                        block8: {
                            if (this.isEmpty()) {
                                return null;
                            }
                            spannableStringBuilder = new SpannableStringBuilder();
                            bl = false;
                            for (n2 = 0; n2 < this.rolledUpCaptions.size(); ++n2) {
                                spannableStringBuilder.append((CharSequence)this.rolledUpCaptions.get(n2));
                                spannableStringBuilder.append('\n');
                            }
                            spannableStringBuilder.append((CharSequence)this.buildSpannableString());
                            n2 = this.justification;
                            if (n2 == 0) break block6;
                            if (n2 == 1) break block7;
                            if (n2 == 2) break block8;
                            if (n2 != 3) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("Unexpected justification value: ");
                                stringBuilder.append(this.justification);
                                throw new IllegalArgumentException(stringBuilder.toString());
                            }
                            break block6;
                        }
                        alignment = Layout.Alignment.ALIGN_CENTER;
                        break block9;
                    }
                    alignment = Layout.Alignment.ALIGN_OPPOSITE;
                    break block9;
                }
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
            if (this.relativePositioning) {
                f3 = (float)this.horizontalAnchor / 99.0f;
                f2 = (float)this.verticalAnchor / 99.0f;
            } else {
                f3 = (float)this.horizontalAnchor / 209.0f;
                f2 = (float)this.verticalAnchor / 74.0f;
            }
            n2 = this.anchorId;
            n2 = n2 / 3 == 0 ? 0 : (n2 / 3 == 1 ? 1 : 2);
            int n3 = this.anchorId;
            n3 = n3 % 3 == 0 ? 0 : (n3 % 3 == 1 ? 1 : 2);
            if (this.windowFillColor != COLOR_SOLID_BLACK) {
                bl = true;
            }
            return new Cea708CueInfo((CharSequence)spannableStringBuilder, alignment, f2 * 0.9f + 0.05f, 0, n2, f3 * 0.9f + 0.05f, n3, -3.4028235E38f, bl, this.windowFillColor, this.priority);
        }

        public SpannableString buildSpannableString() {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)this.captionStringBuilder);
            int n2 = spannableStringBuilder.length();
            if (n2 > 0) {
                if (this.italicsStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new StyleSpan(2), this.italicsStartPosition, n2, 33);
                }
                if (this.underlineStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new UnderlineSpan(), this.underlineStartPosition, n2, 33);
                }
                if (this.foregroundColorStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), this.foregroundColorStartPosition, n2, 33);
                }
                if (this.backgroundColorStartPosition != -1) {
                    spannableStringBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), this.backgroundColorStartPosition, n2, 33);
                }
            }
            return new SpannableString((CharSequence)spannableStringBuilder);
        }

        public void clear() {
            this.rolledUpCaptions.clear();
            this.captionStringBuilder.clear();
            this.italicsStartPosition = -1;
            this.underlineStartPosition = -1;
            this.foregroundColorStartPosition = -1;
            this.backgroundColorStartPosition = -1;
            this.row = 0;
        }

        public void defineWindow(boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.defined = true;
            this.visible = bl;
            this.rowLock = bl2;
            this.priority = n2;
            this.relativePositioning = bl4;
            this.verticalAnchor = n3;
            this.horizontalAnchor = n4;
            this.anchorId = n7;
            n2 = this.rowCount;
            n3 = n5 + 1;
            if (n2 != n3) {
                this.rowCount = n3;
                while (bl2 && this.rolledUpCaptions.size() >= this.rowCount || this.rolledUpCaptions.size() >= 15) {
                    this.rolledUpCaptions.remove(0);
                }
            }
            if (n8 != 0 && this.windowStyleId != n8) {
                this.windowStyleId = n8;
                n2 = n8 - 1;
                this.setWindowAttributes(WINDOW_STYLE_FILL[n2], COLOR_TRANSPARENT, WINDOW_STYLE_WORD_WRAP[n2], 0, WINDOW_STYLE_PRINT_DIRECTION[n2], WINDOW_STYLE_SCROLL_DIRECTION[n2], WINDOW_STYLE_JUSTIFICATION[n2]);
            }
            if (n9 != 0 && this.penStyleId != n9) {
                this.penStyleId = n9;
                n2 = n9 - 1;
                this.setPenAttributes(0, 1, 1, false, false, PEN_STYLE_EDGE_TYPE[n2], PEN_STYLE_FONT_STYLE[n2]);
                this.setPenColor(COLOR_SOLID_WHITE, PEN_STYLE_BACKGROUND[n2], COLOR_SOLID_BLACK);
            }
        }

        public boolean isDefined() {
            return this.defined;
        }

        public boolean isEmpty() {
            boolean bl = !this.isDefined() || this.rolledUpCaptions.isEmpty() && this.captionStringBuilder.length() == 0;
            return bl;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void reset() {
            int n2;
            this.clear();
            this.defined = false;
            this.visible = false;
            this.priority = 4;
            this.relativePositioning = false;
            this.verticalAnchor = 0;
            this.horizontalAnchor = 0;
            this.anchorId = 0;
            this.rowCount = 15;
            this.rowLock = true;
            this.justification = 0;
            this.windowStyleId = 0;
            this.penStyleId = 0;
            this.windowFillColor = n2 = COLOR_SOLID_BLACK;
            this.foregroundColor = COLOR_SOLID_WHITE;
            this.backgroundColor = n2;
        }

        public void setPenAttributes(int n2, int n3, int n4, boolean bl, boolean bl2, int n5, int n6) {
            if (this.italicsStartPosition != -1) {
                if (!bl) {
                    this.captionStringBuilder.setSpan((Object)new StyleSpan(2), this.italicsStartPosition, this.captionStringBuilder.length(), 33);
                    this.italicsStartPosition = -1;
                }
            } else if (bl) {
                this.italicsStartPosition = this.captionStringBuilder.length();
            }
            if (this.underlineStartPosition != -1) {
                if (!bl2) {
                    this.captionStringBuilder.setSpan((Object)new UnderlineSpan(), this.underlineStartPosition, this.captionStringBuilder.length(), 33);
                    this.underlineStartPosition = -1;
                }
            } else if (bl2) {
                this.underlineStartPosition = this.captionStringBuilder.length();
            }
        }

        public void setPenColor(int n2, int n3, int n4) {
            if (this.foregroundColorStartPosition != -1 && (n4 = this.foregroundColor) != n2) {
                this.captionStringBuilder.setSpan((Object)new ForegroundColorSpan(n4), this.foregroundColorStartPosition, this.captionStringBuilder.length(), 33);
            }
            if (n2 != COLOR_SOLID_WHITE) {
                this.foregroundColorStartPosition = this.captionStringBuilder.length();
                this.foregroundColor = n2;
            }
            if (this.backgroundColorStartPosition != -1 && (n2 = this.backgroundColor) != n3) {
                this.captionStringBuilder.setSpan((Object)new BackgroundColorSpan(n2), this.backgroundColorStartPosition, this.captionStringBuilder.length(), 33);
            }
            if (n3 != COLOR_SOLID_BLACK) {
                this.backgroundColorStartPosition = this.captionStringBuilder.length();
                this.backgroundColor = n3;
            }
        }

        public void setPenLocation(int n2, int n3) {
            if (this.row != n2) {
                this.append('\n');
            }
            this.row = n2;
        }

        public void setVisibility(boolean bl) {
            this.visible = bl;
        }

        public void setWindowAttributes(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7) {
            this.windowFillColor = n2;
            this.justification = n7;
        }
    }

    private static final class DtvCcPacket {
        int currentIndex;
        public final byte[] packetData;
        public final int packetSize;
        public final int sequenceNumber;

        public DtvCcPacket(int n2, int n3) {
            this.sequenceNumber = n2;
            this.packetSize = n3;
            this.packetData = new byte[n3 * 2 - 1];
            this.currentIndex = 0;
        }
    }
}

