/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.UnrecognizedInputFormatException;
import com.google.android.exoplayer2.source.hls.HlsTrackMetadataEntry;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

public final class HlsPlaylistParser
implements ParsingLoadable.Parser<HlsPlaylist> {
    private static final String ATTR_CLOSED_CAPTIONS_NONE = "CLOSED-CAPTIONS=NONE";
    private static final String BOOLEAN_FALSE = "NO";
    private static final String BOOLEAN_TRUE = "YES";
    private static final String KEYFORMAT_IDENTITY = "identity";
    private static final String KEYFORMAT_PLAYREADY = "com.microsoft.playready";
    private static final String KEYFORMAT_WIDEVINE_PSSH_BINARY = "urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed";
    private static final String KEYFORMAT_WIDEVINE_PSSH_JSON = "com.widevine";
    private static final String LOG_TAG = "HlsPlaylistParser";
    private static final String METHOD_AES_128 = "AES-128";
    private static final String METHOD_NONE = "NONE";
    private static final String METHOD_SAMPLE_AES = "SAMPLE-AES";
    private static final String METHOD_SAMPLE_AES_CENC = "SAMPLE-AES-CENC";
    private static final String METHOD_SAMPLE_AES_CTR = "SAMPLE-AES-CTR";
    private static final String PLAYLIST_HEADER = "#EXTM3U";
    private static final Pattern REGEX_ATTR_BYTERANGE;
    private static final Pattern REGEX_ATTR_DURATION;
    private static final Pattern REGEX_AUDIO;
    private static final Pattern REGEX_AUTOSELECT;
    private static final Pattern REGEX_AVERAGE_BANDWIDTH;
    private static final Pattern REGEX_BANDWIDTH;
    private static final Pattern REGEX_BYTERANGE;
    private static final Pattern REGEX_BYTERANGE_LENGTH;
    private static final Pattern REGEX_BYTERANGE_START;
    private static final Pattern REGEX_CAN_BLOCK_RELOAD;
    private static final Pattern REGEX_CAN_SKIP_DATE_RANGES;
    private static final Pattern REGEX_CAN_SKIP_UNTIL;
    private static final Pattern REGEX_CHANNELS;
    private static final Pattern REGEX_CHARACTERISTICS;
    private static final Pattern REGEX_CLOSED_CAPTIONS;
    private static final Pattern REGEX_CODECS;
    private static final Pattern REGEX_DEFAULT;
    private static final Pattern REGEX_FORCED;
    private static final Pattern REGEX_FRAME_RATE;
    private static final Pattern REGEX_GAP;
    private static final Pattern REGEX_GROUP_ID;
    private static final Pattern REGEX_HOLD_BACK;
    private static final Pattern REGEX_IMPORT;
    private static final Pattern REGEX_INDEPENDENT;
    private static final Pattern REGEX_INSTREAM_ID;
    private static final Pattern REGEX_IV;
    private static final Pattern REGEX_KEYFORMAT;
    private static final Pattern REGEX_KEYFORMATVERSIONS;
    private static final Pattern REGEX_LANGUAGE;
    private static final Pattern REGEX_LAST_MSN;
    private static final Pattern REGEX_LAST_PART;
    private static final Pattern REGEX_MEDIA_DURATION;
    private static final Pattern REGEX_MEDIA_SEQUENCE;
    private static final Pattern REGEX_MEDIA_TITLE;
    private static final Pattern REGEX_METHOD;
    private static final Pattern REGEX_NAME;
    private static final Pattern REGEX_PART_HOLD_BACK;
    private static final Pattern REGEX_PART_TARGET_DURATION;
    private static final Pattern REGEX_PLAYLIST_TYPE;
    private static final Pattern REGEX_PRELOAD_HINT_TYPE;
    private static final Pattern REGEX_RESOLUTION;
    private static final Pattern REGEX_SKIPPED_SEGMENTS;
    private static final Pattern REGEX_SUBTITLES;
    private static final Pattern REGEX_TARGET_DURATION;
    private static final Pattern REGEX_TIME_OFFSET;
    private static final Pattern REGEX_TYPE;
    private static final Pattern REGEX_URI;
    private static final Pattern REGEX_VALUE;
    private static final Pattern REGEX_VARIABLE_REFERENCE;
    private static final Pattern REGEX_VERSION;
    private static final Pattern REGEX_VIDEO;
    private static final String TAG_BYTERANGE = "#EXT-X-BYTERANGE";
    private static final String TAG_DEFINE = "#EXT-X-DEFINE";
    private static final String TAG_DISCONTINUITY = "#EXT-X-DISCONTINUITY";
    private static final String TAG_DISCONTINUITY_SEQUENCE = "#EXT-X-DISCONTINUITY-SEQUENCE";
    private static final String TAG_ENDLIST = "#EXT-X-ENDLIST";
    private static final String TAG_GAP = "#EXT-X-GAP";
    private static final String TAG_IFRAME = "#EXT-X-I-FRAMES-ONLY";
    private static final String TAG_INDEPENDENT_SEGMENTS = "#EXT-X-INDEPENDENT-SEGMENTS";
    private static final String TAG_INIT_SEGMENT = "#EXT-X-MAP";
    private static final String TAG_I_FRAME_STREAM_INF = "#EXT-X-I-FRAME-STREAM-INF";
    private static final String TAG_KEY = "#EXT-X-KEY";
    private static final String TAG_MEDIA = "#EXT-X-MEDIA";
    private static final String TAG_MEDIA_DURATION = "#EXTINF";
    private static final String TAG_MEDIA_SEQUENCE = "#EXT-X-MEDIA-SEQUENCE";
    private static final String TAG_PART = "#EXT-X-PART";
    private static final String TAG_PART_INF = "#EXT-X-PART-INF";
    private static final String TAG_PLAYLIST_TYPE = "#EXT-X-PLAYLIST-TYPE";
    private static final String TAG_PREFIX = "#EXT";
    private static final String TAG_PRELOAD_HINT = "#EXT-X-PRELOAD-HINT";
    private static final String TAG_PROGRAM_DATE_TIME = "#EXT-X-PROGRAM-DATE-TIME";
    private static final String TAG_RENDITION_REPORT = "#EXT-X-RENDITION-REPORT";
    private static final String TAG_SERVER_CONTROL = "#EXT-X-SERVER-CONTROL";
    private static final String TAG_SESSION_KEY = "#EXT-X-SESSION-KEY";
    private static final String TAG_SKIP = "#EXT-X-SKIP";
    private static final String TAG_START = "#EXT-X-START";
    private static final String TAG_STREAM_INF = "#EXT-X-STREAM-INF";
    private static final String TAG_TARGET_DURATION = "#EXT-X-TARGETDURATION";
    private static final String TAG_VERSION = "#EXT-X-VERSION";
    private static final String TYPE_AUDIO = "AUDIO";
    private static final String TYPE_CLOSED_CAPTIONS = "CLOSED-CAPTIONS";
    private static final String TYPE_MAP = "MAP";
    private static final String TYPE_PART = "PART";
    private static final String TYPE_SUBTITLES = "SUBTITLES";
    private static final String TYPE_VIDEO = "VIDEO";
    private final HlsMasterPlaylist masterPlaylist;
    private final HlsMediaPlaylist previousMediaPlaylist;

    static {
        REGEX_AVERAGE_BANDWIDTH = Pattern.compile("AVERAGE-BANDWIDTH=(\\d+)\\b");
        REGEX_VIDEO = Pattern.compile("VIDEO=\"(.+?)\"");
        REGEX_AUDIO = Pattern.compile("AUDIO=\"(.+?)\"");
        REGEX_SUBTITLES = Pattern.compile("SUBTITLES=\"(.+?)\"");
        REGEX_CLOSED_CAPTIONS = Pattern.compile("CLOSED-CAPTIONS=\"(.+?)\"");
        REGEX_BANDWIDTH = Pattern.compile("[^-]BANDWIDTH=(\\d+)\\b");
        REGEX_CHANNELS = Pattern.compile("CHANNELS=\"(.+?)\"");
        REGEX_CODECS = Pattern.compile("CODECS=\"(.+?)\"");
        REGEX_RESOLUTION = Pattern.compile("RESOLUTION=(\\d+x\\d+)");
        REGEX_FRAME_RATE = Pattern.compile("FRAME-RATE=([\\d\\.]+)\\b");
        REGEX_TARGET_DURATION = Pattern.compile("#EXT-X-TARGETDURATION:(\\d+)\\b");
        REGEX_ATTR_DURATION = Pattern.compile("DURATION=([\\d\\.]+)\\b");
        REGEX_PART_TARGET_DURATION = Pattern.compile("PART-TARGET=([\\d\\.]+)\\b");
        REGEX_VERSION = Pattern.compile("#EXT-X-VERSION:(\\d+)\\b");
        REGEX_PLAYLIST_TYPE = Pattern.compile("#EXT-X-PLAYLIST-TYPE:(.+)\\b");
        REGEX_CAN_SKIP_UNTIL = Pattern.compile("CAN-SKIP-UNTIL=([\\d\\.]+)\\b");
        REGEX_CAN_SKIP_DATE_RANGES = HlsPlaylistParser.compileBooleanAttrPattern("CAN-SKIP-DATERANGES");
        REGEX_SKIPPED_SEGMENTS = Pattern.compile("SKIPPED-SEGMENTS=(\\d+)\\b");
        REGEX_HOLD_BACK = Pattern.compile("[:|,]HOLD-BACK=([\\d\\.]+)\\b");
        REGEX_PART_HOLD_BACK = Pattern.compile("PART-HOLD-BACK=([\\d\\.]+)\\b");
        REGEX_CAN_BLOCK_RELOAD = HlsPlaylistParser.compileBooleanAttrPattern("CAN-BLOCK-RELOAD");
        REGEX_MEDIA_SEQUENCE = Pattern.compile("#EXT-X-MEDIA-SEQUENCE:(\\d+)\\b");
        REGEX_MEDIA_DURATION = Pattern.compile("#EXTINF:([\\d\\.]+)\\b");
        REGEX_MEDIA_TITLE = Pattern.compile("#EXTINF:[\\d\\.]+\\b,(.+)");
        REGEX_LAST_MSN = Pattern.compile("LAST-MSN=(\\d+)\\b");
        REGEX_LAST_PART = Pattern.compile("LAST-PART=(\\d+)\\b");
        REGEX_TIME_OFFSET = Pattern.compile("TIME-OFFSET=(-?[\\d\\.]+)\\b");
        REGEX_BYTERANGE = Pattern.compile("#EXT-X-BYTERANGE:(\\d+(?:@\\d+)?)\\b");
        REGEX_ATTR_BYTERANGE = Pattern.compile("BYTERANGE=\"(\\d+(?:@\\d+)?)\\b\"");
        REGEX_BYTERANGE_START = Pattern.compile("BYTERANGE-START=(\\d+)\\b");
        REGEX_BYTERANGE_LENGTH = Pattern.compile("BYTERANGE-LENGTH=(\\d+)\\b");
        REGEX_METHOD = Pattern.compile("METHOD=(NONE|AES-128|SAMPLE-AES|SAMPLE-AES-CENC|SAMPLE-AES-CTR)\\s*(?:,|$)");
        REGEX_KEYFORMAT = Pattern.compile("KEYFORMAT=\"(.+?)\"");
        REGEX_KEYFORMATVERSIONS = Pattern.compile("KEYFORMATVERSIONS=\"(.+?)\"");
        REGEX_URI = Pattern.compile("URI=\"(.+?)\"");
        REGEX_IV = Pattern.compile("IV=([^,.*]+)");
        REGEX_TYPE = Pattern.compile("TYPE=(AUDIO|VIDEO|SUBTITLES|CLOSED-CAPTIONS)");
        REGEX_PRELOAD_HINT_TYPE = Pattern.compile("TYPE=(PART|MAP)");
        REGEX_LANGUAGE = Pattern.compile("LANGUAGE=\"(.+?)\"");
        REGEX_NAME = Pattern.compile("NAME=\"(.+?)\"");
        REGEX_GROUP_ID = Pattern.compile("GROUP-ID=\"(.+?)\"");
        REGEX_CHARACTERISTICS = Pattern.compile("CHARACTERISTICS=\"(.+?)\"");
        REGEX_INSTREAM_ID = Pattern.compile("INSTREAM-ID=\"((?:CC|SERVICE)\\d+)\"");
        REGEX_AUTOSELECT = HlsPlaylistParser.compileBooleanAttrPattern("AUTOSELECT");
        REGEX_DEFAULT = HlsPlaylistParser.compileBooleanAttrPattern("DEFAULT");
        REGEX_FORCED = HlsPlaylistParser.compileBooleanAttrPattern("FORCED");
        REGEX_INDEPENDENT = HlsPlaylistParser.compileBooleanAttrPattern("INDEPENDENT");
        REGEX_GAP = HlsPlaylistParser.compileBooleanAttrPattern("GAP");
        REGEX_VALUE = Pattern.compile("VALUE=\"(.+?)\"");
        REGEX_IMPORT = Pattern.compile("IMPORT=\"(.+?)\"");
        REGEX_VARIABLE_REFERENCE = Pattern.compile("\\{\\$([a-zA-Z0-9\\-_]+)\\}");
    }

    public HlsPlaylistParser() {
        this(HlsMasterPlaylist.EMPTY, null);
    }

    public HlsPlaylistParser(HlsMasterPlaylist hlsMasterPlaylist, HlsMediaPlaylist hlsMediaPlaylist) {
        this.masterPlaylist = hlsMasterPlaylist;
        this.previousMediaPlaylist = hlsMediaPlaylist;
    }

    private static boolean checkPlaylistHeader(BufferedReader bufferedReader) throws IOException {
        int n2;
        int n3 = n2 = bufferedReader.read();
        if (n2 == 239) {
            if (bufferedReader.read() == 187 && bufferedReader.read() == 191) {
                n3 = bufferedReader.read();
            } else {
                return false;
            }
        }
        n3 = HlsPlaylistParser.skipIgnorableWhitespace(bufferedReader, true, n3);
        for (n2 = 0; n2 < 7; ++n2) {
            if (n3 != PLAYLIST_HEADER.charAt(n2)) {
                return false;
            }
            n3 = bufferedReader.read();
        }
        return Util.isLinebreak(HlsPlaylistParser.skipIgnorableWhitespace(bufferedReader, false, n3));
    }

    private static Pattern compileBooleanAttrPattern(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("=(");
        stringBuilder.append(BOOLEAN_FALSE);
        stringBuilder.append("|");
        stringBuilder.append(BOOLEAN_TRUE);
        stringBuilder.append(")");
        return Pattern.compile(stringBuilder.toString());
    }

    private static DrmInitData getPlaylistProtectionSchemes(String string2, DrmInitData.SchemeData[] schemeDataArray) {
        DrmInitData.SchemeData[] schemeDataArray2 = new DrmInitData.SchemeData[schemeDataArray.length];
        for (int i2 = 0; i2 < schemeDataArray.length; ++i2) {
            schemeDataArray2[i2] = schemeDataArray[i2].copyWithData(null);
        }
        return new DrmInitData(string2, schemeDataArray2);
    }

    private static String getSegmentEncryptionIV(long l2, String string2, String string3) {
        if (string2 == null) {
            return null;
        }
        if (string3 != null) {
            return string3;
        }
        return Long.toHexString(l2);
    }

    private static HlsMasterPlaylist.Variant getVariantWithAudioGroup(ArrayList<HlsMasterPlaylist.Variant> arrayList, String string2) {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            HlsMasterPlaylist.Variant variant = arrayList.get(i2);
            if (!string2.equals(variant.audioGroupId)) continue;
            return variant;
        }
        return null;
    }

    private static HlsMasterPlaylist.Variant getVariantWithSubtitleGroup(ArrayList<HlsMasterPlaylist.Variant> arrayList, String string2) {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            HlsMasterPlaylist.Variant variant = arrayList.get(i2);
            if (!string2.equals(variant.subtitleGroupId)) continue;
            return variant;
        }
        return null;
    }

    private static HlsMasterPlaylist.Variant getVariantWithVideoGroup(ArrayList<HlsMasterPlaylist.Variant> arrayList, String string2) {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            HlsMasterPlaylist.Variant variant = arrayList.get(i2);
            if (!string2.equals(variant.videoGroupId)) continue;
            return variant;
        }
        return null;
    }

    private static double parseDoubleAttr(String string2, Pattern pattern) throws ParserException {
        return Double.parseDouble(HlsPlaylistParser.parseStringAttr(string2, pattern, Collections.<String, String>emptyMap()));
    }

    private static DrmInitData.SchemeData parseDrmSchemeData(String object, String string2, Map<String, String> map) throws ParserException {
        String string3 = HlsPlaylistParser.parseOptionalStringAttr((String)object, REGEX_KEYFORMATVERSIONS, "1", map);
        if (KEYFORMAT_WIDEVINE_PSSH_BINARY.equals(string2)) {
            object = HlsPlaylistParser.parseStringAttr((String)object, REGEX_URI, map);
            return new DrmInitData.SchemeData(C.WIDEVINE_UUID, "video/mp4", Base64.decode((String)((String)object).substring(((String)object).indexOf(44)), (int)0));
        }
        if (KEYFORMAT_WIDEVINE_PSSH_JSON.equals(string2)) {
            return new DrmInitData.SchemeData(C.WIDEVINE_UUID, "hls", Util.getUtf8Bytes((String)object));
        }
        if (KEYFORMAT_PLAYREADY.equals(string2) && "1".equals(string3)) {
            object = HlsPlaylistParser.parseStringAttr((String)object, REGEX_URI, map);
            object = Base64.decode((String)((String)object).substring(((String)object).indexOf(44)), (int)0);
            object = PsshAtomUtil.buildPsshAtom((UUID)C.PLAYREADY_UUID, (byte[])object);
            return new DrmInitData.SchemeData(C.PLAYREADY_UUID, "video/mp4", (byte[])object);
        }
        return null;
    }

    private static String parseEncryptionScheme(String string2) {
        string2 = !METHOD_SAMPLE_AES_CENC.equals(string2) && !METHOD_SAMPLE_AES_CTR.equals(string2) ? "cbcs" : "cenc";
        return string2;
    }

    private static int parseIntAttr(String string2, Pattern pattern) throws ParserException {
        return Integer.parseInt(HlsPlaylistParser.parseStringAttr(string2, pattern, Collections.<String, String>emptyMap()));
    }

    private static long parseLongAttr(String string2, Pattern pattern) throws ParserException {
        return Long.parseLong(HlsPlaylistParser.parseStringAttr(string2, pattern, Collections.<String, String>emptyMap()));
    }

    private static HlsMasterPlaylist parseMasterPlaylist(LineIterator arrayList, String string2) throws IOException {
        String string3;
        Object object;
        Object object2;
        String string4;
        int n2;
        Object object3;
        Object object4;
        int n3;
        String string5;
        boolean bl;
        ArrayList<Object> arrayList2;
        boolean bl2;
        int n4;
        ArrayList<String> arrayList3;
        ArrayList<DrmInitData> arrayList4;
        Object object5;
        ArrayList arrayList5;
        ArrayList<HlsMasterPlaylist.Rendition> arrayList6;
        ArrayList<HlsMasterPlaylist.Rendition> arrayList7;
        ArrayList<HlsMasterPlaylist.Rendition> arrayList8;
        ArrayList<HlsMasterPlaylist.Variant> arrayList9;
        HashMap<String, String> hashMap;
        Object object6;
        block47: {
            object6 = new HashMap();
            hashMap = new HashMap<String, String>();
            arrayList9 = new ArrayList<HlsMasterPlaylist.Variant>();
            arrayList8 = new ArrayList<HlsMasterPlaylist.Rendition>();
            arrayList7 = new ArrayList<HlsMasterPlaylist.Rendition>();
            arrayList6 = new ArrayList<HlsMasterPlaylist.Rendition>();
            arrayList5 = new ArrayList();
            object5 = new ArrayList<String>();
            arrayList4 = new ArrayList<DrmInitData>();
            arrayList3 = new ArrayList<String>();
            n4 = 0;
            bl2 = false;
            while (true) {
                arrayList2 = string2;
                bl = ((LineIterator)((Object)arrayList)).hasNext();
                string5 = "application/x-mpegURL";
                if (!bl) break block47;
                string5 = ((LineIterator)((Object)arrayList)).next();
                if (string5.startsWith(TAG_PREFIX)) {
                    arrayList3.add(string5);
                }
                bl = string5.startsWith(TAG_I_FRAME_STREAM_INF);
                if (string5.startsWith(TAG_DEFINE)) {
                    hashMap.put(HlsPlaylistParser.parseStringAttr(string5, REGEX_NAME, hashMap), HlsPlaylistParser.parseStringAttr(string5, REGEX_VALUE, hashMap));
                    continue;
                }
                if (string5.equals(TAG_INDEPENDENT_SEGMENTS)) {
                    bl2 = true;
                    continue;
                }
                if (string5.startsWith(TAG_MEDIA)) {
                    ((ArrayList)object5).add(string5);
                    continue;
                }
                if (string5.startsWith(TAG_SESSION_KEY)) {
                    arrayList2 = HlsPlaylistParser.parseDrmSchemeData(string5, HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_KEYFORMAT, KEYFORMAT_IDENTITY, hashMap), hashMap);
                    if (arrayList2 == null) continue;
                    arrayList4.add(new DrmInitData(HlsPlaylistParser.parseEncryptionScheme(HlsPlaylistParser.parseStringAttr(string5, REGEX_METHOD, hashMap)), new DrmInitData.SchemeData[]{arrayList2}));
                    continue;
                }
                if (!string5.startsWith(TAG_STREAM_INF) && !bl) continue;
                int n5 = n4 | string5.contains(ATTR_CLOSED_CAPTIONS_NONE);
                n3 = bl ? 16384 : 0;
                int n6 = HlsPlaylistParser.parseIntAttr(string5, REGEX_BANDWIDTH);
                int n7 = HlsPlaylistParser.parseOptionalIntAttr(string5, REGEX_AVERAGE_BANDWIDTH, -1);
                object4 = HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_CODECS, hashMap);
                object3 = HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_RESOLUTION, hashMap);
                if (object3 != null) {
                    object3 = Util.split((String)object3, "x");
                    n2 = Integer.parseInt((String)object3[0]);
                    n4 = Integer.parseInt((String)object3[1]);
                    if (n2 <= 0 || n4 <= 0) {
                        n4 = -1;
                        n2 = -1;
                    }
                } else {
                    n2 = -1;
                    n4 = -1;
                }
                object3 = HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_FRAME_RATE, hashMap);
                float f2 = object3 != null ? Float.parseFloat((String)object3) : -1.0f;
                string4 = HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_VIDEO, hashMap);
                object2 = HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_AUDIO, hashMap);
                object = HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_SUBTITLES, hashMap);
                string3 = HlsPlaylistParser.parseOptionalStringAttr(string5, REGEX_CLOSED_CAPTIONS, hashMap);
                if (bl) {
                    string5 = UriUtil.resolveToUri((String)((Object)arrayList2), (String)HlsPlaylistParser.parseStringAttr(string5, REGEX_URI, hashMap));
                } else {
                    if (!((LineIterator)((Object)arrayList)).hasNext()) break;
                    string5 = UriUtil.resolveToUri((String)((Object)arrayList2), (String)HlsPlaylistParser.replaceVariableReferences(((LineIterator)((Object)arrayList)).next(), hashMap));
                }
                arrayList9.add(new HlsMasterPlaylist.Variant((Uri)string5, new Format.Builder().setId(arrayList9.size()).setContainerMimeType("application/x-mpegURL").setCodecs((String)object4).setAverageBitrate(n7).setPeakBitrate(n6).setWidth(n2).setHeight(n4).setFrameRate(f2).setRoleFlags(n3).build(), string4, (String)object2, (String)object, string3));
                object4 = object6;
                object3 = (ArrayList)((HashMap)object4).get(string5);
                arrayList2 = object3;
                if (object3 == null) {
                    arrayList2 = new ArrayList<HlsTrackMetadataEntry.VariantInfo>();
                    ((HashMap)object4).put(string5, arrayList2);
                }
                arrayList2.add(new HlsTrackMetadataEntry.VariantInfo(n7, n6, string4, (String)object2, (String)object, string3));
                n4 = n5;
            }
            throw new ParserException("#EXT-X-STREAM-INF must be followed by another line");
        }
        object2 = new ArrayList<HlsMasterPlaylist.Variant>();
        object4 = new HashSet<Uri>();
        for (n2 = 0; n2 < arrayList9.size(); ++n2) {
            arrayList = (HlsMasterPlaylist.Variant)arrayList9.get(n2);
            if (!((HashSet)object4).add(((HlsMasterPlaylist.Variant)arrayList).url)) continue;
            bl = ((HlsMasterPlaylist.Variant)arrayList).format.metadata == null;
            Assertions.checkState(bl);
            arrayList2 = new Metadata(new Metadata.Entry[]{new HlsTrackMetadataEntry(null, null, (List)Assertions.checkNotNull((ArrayList)((HashMap)object6).get(((HlsMasterPlaylist.Variant)arrayList).url)))});
            ((ArrayList)object2).add(arrayList.copyWithFormat(((HlsMasterPlaylist.Variant)arrayList).format.buildUpon().setMetadata((Metadata)arrayList2).build()));
        }
        arrayList = null;
        arrayList2 = arrayList;
        object6 = object5;
        object5 = arrayList2;
        for (n3 = 0; n3 < ((ArrayList)object6).size(); ++n3) {
            Metadata metadata;
            block48: {
                object4 = (String)((ArrayList)object6).get(n3);
                string3 = HlsPlaylistParser.parseStringAttr((String)object4, REGEX_GROUP_ID, hashMap);
                string4 = HlsPlaylistParser.parseStringAttr((String)object4, REGEX_NAME, hashMap);
                arrayList2 = new Format.Builder();
                object3 = new StringBuilder();
                ((StringBuilder)object3).append(string3);
                ((StringBuilder)object3).append(":");
                ((StringBuilder)object3).append(string4);
                object = arrayList2.setId(((StringBuilder)object3).toString()).setLabel(string4).setContainerMimeType(string5).setSelectionFlags(HlsPlaylistParser.parseSelectionFlags((String)object4)).setRoleFlags(HlsPlaylistParser.parseRoleFlags((String)object4, hashMap)).setLanguage(HlsPlaylistParser.parseOptionalStringAttr((String)object4, REGEX_LANGUAGE, hashMap));
                arrayList2 = HlsPlaylistParser.parseOptionalStringAttr((String)object4, REGEX_URI, hashMap);
                arrayList2 = arrayList2 == null ? null : UriUtil.resolveToUri((String)string2, (String)((Object)arrayList2));
                object3 = object6;
                metadata = new Metadata(new Metadata.Entry[]{new HlsTrackMetadataEntry(string3, string4, Collections.emptyList())});
                object6 = HlsPlaylistParser.parseStringAttr((String)object4, REGEX_TYPE, hashMap);
                switch (((String)object6).hashCode()) {
                    default: {
                        break;
                    }
                    case 81665115: {
                        if (!((String)object6).equals(TYPE_VIDEO)) break;
                        n2 = 0;
                        break block48;
                    }
                    case 62628790: {
                        if (!((String)object6).equals(TYPE_AUDIO)) break;
                        n2 = 1;
                        break block48;
                    }
                    case -333210994: {
                        if (!((String)object6).equals(TYPE_CLOSED_CAPTIONS)) break;
                        n2 = 3;
                        break block48;
                    }
                    case -959297733: {
                        if (!((String)object6).equals(TYPE_SUBTITLES)) break;
                        n2 = 2;
                        break block48;
                    }
                }
                n2 = -1;
            }
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 == 3) {
                            object6 = HlsPlaylistParser.parseStringAttr((String)object4, REGEX_INSTREAM_ID, hashMap);
                            if (((String)object6).startsWith("CC")) {
                                n2 = Integer.parseInt(((String)object6).substring(2));
                                arrayList2 = "application/cea-608";
                            } else {
                                n2 = Integer.parseInt(((String)object6).substring(7));
                                arrayList2 = "application/cea-708";
                            }
                            object6 = arrayList;
                            if (arrayList == null) {
                                object6 = new ArrayList<Format>();
                            }
                            object.setSampleMimeType(arrayList2).setAccessibilityChannel(n2);
                            object6.add(object.build());
                            arrayList = object6;
                        }
                    } else {
                        object6 = HlsPlaylistParser.getVariantWithSubtitleGroup(arrayList9, string3);
                        if (object6 != null) {
                            object6 = Util.getCodecsOfType(((HlsMasterPlaylist.Variant)object6).format.codecs, 3);
                            object.setCodecs((String)object6);
                            object6 = MimeTypes.getMediaMimeType((String)object6);
                        } else {
                            object6 = null;
                        }
                        object4 = object6;
                        if (object6 == null) {
                            object4 = "text/vtt";
                        }
                        object.setSampleMimeType((String)object4).setMetadata(metadata);
                        if (arrayList2 != null) {
                            arrayList6.add(new HlsMasterPlaylist.Rendition(arrayList2, object.build(), string3, string4));
                        } else {
                            Log.w(LOG_TAG, "EXT-X-MEDIA tag with missing mandatory URI attribute: skipping");
                        }
                    }
                } else {
                    HlsMasterPlaylist.Variant variant = HlsPlaylistParser.getVariantWithAudioGroup(arrayList9, string3);
                    if (variant != null) {
                        object6 = Util.getCodecsOfType(variant.format.codecs, 1);
                        object.setCodecs((String)object6);
                        object6 = MimeTypes.getMediaMimeType((String)object6);
                    } else {
                        object6 = null;
                    }
                    String string6 = HlsPlaylistParser.parseOptionalStringAttr((String)object4, REGEX_CHANNELS, hashMap);
                    if (string6 != null) {
                        object.setChannelCount(Integer.parseInt(Util.splitAtFirst(string6, "/")[0]));
                        object4 = object6;
                        if ("audio/eac3".equals(object6)) {
                            object4 = object6;
                            if (string6.endsWith("/JOC")) {
                                object4 = "audio/eac3-joc";
                            }
                        }
                    } else {
                        object4 = object6;
                    }
                    object.setSampleMimeType((String)object4);
                    if (arrayList2 != null) {
                        object.setMetadata(metadata);
                        arrayList7.add(new HlsMasterPlaylist.Rendition(arrayList2, object.build(), string3, string4));
                    } else if (variant != null) {
                        object5 = object.build();
                    }
                }
            } else {
                object6 = HlsPlaylistParser.getVariantWithVideoGroup(arrayList9, string3);
                if (object6 != null) {
                    object6 = ((HlsMasterPlaylist.Variant)object6).format;
                    object4 = Util.getCodecsOfType(((Format)object6).codecs, 2);
                    object.setCodecs((String)object4).setSampleMimeType(MimeTypes.getMediaMimeType((String)object4)).setWidth(((Format)object6).width).setHeight(((Format)object6).height).setFrameRate(((Format)object6).frameRate);
                }
                if (arrayList2 != null) {
                    object.setMetadata(metadata);
                    arrayList8.add(new HlsMasterPlaylist.Rendition((Uri)arrayList2, object.build(), string3, string4));
                }
            }
            object6 = object3;
        }
        if (n4 != 0) {
            arrayList = Collections.emptyList();
        }
        return new HlsMasterPlaylist(string2, arrayList3, object2, arrayList8, arrayList7, arrayList6, arrayList5, (Format)object5, (List)arrayList, bl2, hashMap, arrayList4);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static HlsMediaPlaylist parseMediaPlaylist(HlsMasterPlaylist var0, HlsMediaPlaylist var1_1, LineIterator var2_2, String var3_3) throws IOException {
        var4_4 /* !! */  = var0;
        var5_5 /* !! */  = var1_1;
        var6_6 = var4_4 /* !! */ .hasIndependentSegments;
        var7_7 = new HashMap<String, String>();
        var8_8 /* !! */  = new HashMap<K, V>();
        var9_9 = new ArrayList<HlsMediaPlaylist.Segment>();
        var10_10 /* !! */  = new ArrayList<HlsMediaPlaylist.Part>();
        var11_11 = new HashMap<Uri, HlsMediaPlaylist.RenditionReport>();
        var12_12 /* !! */  = new ArrayList();
        var13_13 = new HlsMediaPlaylist.ServerControl(-9223372036854775807L, false, -9223372036854775807L, -9223372036854775807L, false);
        var14_14 = new TreeMap<HlsMasterPlaylist, String[]>();
        var15_15 /* !! */  = "";
        var16_16 = "";
        var31_24 = var29_23 = (var27_22 = (var25_21 = (var23_20 = (var21_19 = (var19_18 = (var17_17 = 0L))))));
        var33_25 = null;
        var34_26 = null;
        var35_27 /* !! */  = null;
        var36_28 = false;
        var37_29 = 0;
        var38_30 = -9223372036854775807L;
        var40_31 = 1;
        var41_32 = -9223372036854775807L;
        var43_33 = -9223372036854775807L;
        var45_34 = false;
        var46_35 = false;
        var47_36 = 0;
        var48_37 = -1L;
        var50_38 /* !! */  = null;
        var51_39 /* !! */  = null;
        var52_40 = 0;
        var53_41 = false;
        var54_42 = null;
        var55_43 /* !! */  = null;
        var56_44 = var21_19;
        var21_19 = var17_17;
        block0: while (var2_2.hasNext()) {
            block76: {
                block77: {
                    block75: {
                        block74: {
                            block73: {
                                block71: {
                                    block69: {
                                        block72: {
                                            block70: {
                                                var58_45 = var2_2.next();
                                                if (var58_45.startsWith("#EXT")) {
                                                    var12_12 /* !! */ .add(var58_45);
                                                }
                                                if (var58_45.startsWith("#EXT-X-PLAYLIST-TYPE")) {
                                                    var59_46 = HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_PLAYLIST_TYPE, var7_7);
                                                    if ("VOD".equals(var59_46)) {
                                                        var37_29 = 1;
                                                        continue;
                                                    }
                                                    if (!"EVENT".equals(var59_46)) continue;
                                                    var37_29 = 2;
                                                    continue;
                                                }
                                                if (var58_45.equals("#EXT-X-I-FRAMES-ONLY")) {
                                                    var53_41 = true;
                                                    continue;
                                                }
                                                if (var58_45.startsWith("#EXT-X-START")) {
                                                    var38_30 = (long)(HlsPlaylistParser.parseDoubleAttr(var58_45, HlsPlaylistParser.REGEX_TIME_OFFSET) * 1000000.0);
                                                    continue;
                                                }
                                                if (var58_45.startsWith("#EXT-X-SERVER-CONTROL")) {
                                                    var13_13 = HlsPlaylistParser.parseServerControl(var58_45);
                                                    continue;
                                                }
                                                if (var58_45.startsWith("#EXT-X-PART-INF")) {
                                                    var43_33 = (long)(HlsPlaylistParser.parseDoubleAttr(var58_45, HlsPlaylistParser.REGEX_PART_TARGET_DURATION) * 1000000.0);
                                                    continue;
                                                }
                                                if (var58_45.startsWith("#EXT-X-MAP")) {
                                                    var59_46 = HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_URI, var7_7);
                                                    var54_42 = HlsPlaylistParser.parseOptionalStringAttr(var58_45, HlsPlaylistParser.REGEX_ATTR_BYTERANGE, var7_7);
                                                    var17_17 = var21_19;
                                                    if (var54_42 != null) {
                                                        var54_42 = Util.split((String)var54_42, "@");
                                                        var48_37 = Long.parseLong(var54_42[0]);
                                                        if (((String[])var54_42).length > 1) {
                                                            var21_19 = Long.parseLong(var54_42[1]);
                                                        }
                                                        var17_17 = var21_19;
                                                    }
                                                    if (var48_37 == -1L) {
                                                        var17_17 = 0L;
                                                    }
                                                    if (var55_43 /* !! */  != null && var50_38 /* !! */  == null) {
                                                        throw new ParserException("The encryption IV attribute must be present when an initialization segment is encrypted with METHOD=AES-128.");
                                                    }
                                                    var54_42 = new HlsMediaPlaylist.Segment((String)var59_46, var17_17, var48_37, (String)var55_43 /* !! */ , (String)var50_38 /* !! */ );
                                                    var21_19 = var17_17;
                                                    if (var48_37 != -1L) {
                                                        var21_19 = var17_17 + var48_37;
                                                    }
                                                    var48_37 = -1L;
                                                    continue;
                                                }
                                                if (var58_45.startsWith("#EXT-X-TARGETDURATION")) {
                                                    var41_32 = (long)HlsPlaylistParser.parseIntAttr(var58_45, HlsPlaylistParser.REGEX_TARGET_DURATION) * 1000000L;
                                                    continue;
                                                }
                                                if (var58_45.startsWith("#EXT-X-MEDIA-SEQUENCE")) {
                                                    var56_44 = var27_22 = HlsPlaylistParser.parseLongAttr(var58_45, HlsPlaylistParser.REGEX_MEDIA_SEQUENCE);
                                                    continue;
                                                }
                                                if (var58_45.startsWith("#EXT-X-VERSION")) {
                                                    var40_31 = HlsPlaylistParser.parseIntAttr(var58_45, HlsPlaylistParser.REGEX_VERSION);
                                                    continue;
                                                }
                                                if (!var58_45.startsWith("#EXT-X-DEFINE")) break block70;
                                                var59_46 = HlsPlaylistParser.parseOptionalStringAttr(var58_45, HlsPlaylistParser.REGEX_IMPORT, var7_7);
                                                if (var59_46 != null) {
                                                    var4_4 /* !! */  = (String)var4_4 /* !! */ .variableDefinitions.get(var59_46);
                                                    if (var4_4 /* !! */  != null) {
                                                        var7_7.put((String)var59_46, (String)var4_4 /* !! */ );
                                                    }
                                                } else {
                                                    var7_7.put(HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_NAME, var7_7), HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_VALUE, var7_7));
                                                }
lbl100:
                                                // 3 sources

                                                while (true) {
                                                    var4_4 /* !! */  = var12_12 /* !! */ ;
                                                    var12_12 /* !! */  = var55_43 /* !! */ ;
                                                    ** GOTO lbl436
                                                    break;
                                                }
                                            }
                                            if (var58_45.startsWith("#EXTINF")) {
                                                var29_23 = (long)(HlsPlaylistParser.parseDoubleAttr(var58_45, HlsPlaylistParser.REGEX_MEDIA_DURATION) * 1000000.0);
                                                var16_16 = HlsPlaylistParser.parseOptionalStringAttr(var58_45, HlsPlaylistParser.REGEX_MEDIA_TITLE, (String)var15_15 /* !! */ , var7_7);
                                                var17_17 = var21_19;
lbl109:
                                                // 2 sources

                                                while (true) {
                                                    var21_19 = var17_17;
                                                    continue block0;
                                                    break;
                                                }
                                            }
                                            var59_46 = var8_8 /* !! */ ;
                                            var4_4 /* !! */  = var55_43 /* !! */ ;
                                            if (var58_45.startsWith("#EXT-X-SKIP")) {
                                                var60_47 = HlsPlaylistParser.parseIntAttr(var58_45, HlsPlaylistParser.REGEX_SKIPPED_SEGMENTS);
                                                var61_48 = var5_5 /* !! */  != null && var9_9.isEmpty() != false ? 1 : 0;
                                                Assertions.checkState((boolean)var61_48);
                                                var62_49 = (int)(var56_44 - Util.castNonNull(var1_1).mediaSequence);
                                                var63_50 = var60_47 + var62_49;
                                                if (var62_49 >= 0 && var63_50 <= var5_5 /* !! */ .segments.size()) {
                                                    var17_17 = var25_21;
                                                    var60_47 = var52_40;
                                                    var25_21 = var21_19;
                                                    var21_19 = var17_17;
                                                    var52_40 = var62_49;
                                                    var62_49 = var63_50;
                                                    while (var52_40 < var62_49) {
                                                        var34_26 = var5_5 /* !! */ .segments.get(var52_40);
                                                        var4_4 /* !! */  = var34_26;
                                                        if (var56_44 != var5_5 /* !! */ .mediaSequence) {
                                                            var4_4 /* !! */  = var34_26.copyWith(var21_19, var5_5 /* !! */ .discontinuitySequence - var47_36 + var34_26.relativeDiscontinuitySequence);
                                                        }
                                                        var9_9.add((HlsMediaPlaylist.Segment)var4_4 /* !! */ );
                                                        var19_18 = var21_19 + var4_4 /* !! */ .durationUs;
                                                        if (var4_4 /* !! */ .byteRangeLength != -1L) {
                                                            var25_21 = var4_4 /* !! */ .byteRangeOffset + var4_4 /* !! */ .byteRangeLength;
                                                        }
                                                        var60_47 = var4_4 /* !! */ .relativeDiscontinuitySequence;
                                                        var54_42 = var4_4 /* !! */ .initializationSegment;
                                                        var34_26 = var4_4 /* !! */ .drmInitData;
                                                        var8_8 /* !! */  = var4_4 /* !! */ .fullSegmentEncryptionKeyUri;
                                                        if (var4_4 /* !! */ .encryptionIV == null || !var4_4 /* !! */ .encryptionIV.equals(Long.toHexString(var27_22))) {
                                                            var50_38 /* !! */  = var4_4 /* !! */ .encryptionIV;
                                                        }
                                                        ++var27_22;
                                                        ++var52_40;
                                                        var5_5 /* !! */  = var1_1;
                                                        var4_4 /* !! */  = var8_8 /* !! */ ;
                                                        var21_19 = var19_18;
                                                    }
                                                    var8_8 /* !! */  = var0;
                                                    var5_5 /* !! */  = var1_1;
                                                    var17_17 = var21_19;
                                                    var55_43 /* !! */  = var4_4 /* !! */ ;
                                                    var4_4 /* !! */  = var8_8 /* !! */ ;
                                                    var8_8 /* !! */  = var59_46;
                                                    var21_19 = var25_21;
                                                    var52_40 = var60_47;
                                                    var25_21 = var17_17;
                                                    continue;
                                                }
                                                throw new DeltaUpdateException();
                                            }
                                            if (!var58_45.startsWith("#EXT-X-KEY")) break block71;
                                            var5_5 /* !! */  = HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_METHOD, var7_7);
                                            var4_4 /* !! */  = HlsPlaylistParser.parseOptionalStringAttr(var58_45, HlsPlaylistParser.REGEX_KEYFORMAT, "identity", var7_7);
                                            if (!"NONE".equals(var5_5 /* !! */ )) break block72;
                                            var14_14.clear();
                                            var50_38 /* !! */  = null;
                                            var34_26 = null;
                                            var4_4 /* !! */  = null;
                                            break block69;
                                        }
                                        var50_38 /* !! */  = HlsPlaylistParser.parseOptionalStringAttr(var58_45, HlsPlaylistParser.REGEX_IV, var7_7);
                                        if (!"identity".equals(var4_4 /* !! */ )) ** GOTO lbl183
                                        var8_8 /* !! */  = var51_39 /* !! */ ;
                                        if ("AES-128".equals(var5_5 /* !! */ )) {
                                            var8_8 /* !! */  = HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_URI, var7_7);
                                            var4_4 /* !! */  = var50_38 /* !! */ ;
                                            var50_38 /* !! */  = var8_8 /* !! */ ;
                                        } else {
                                            while (true) {
                                                var4_4 /* !! */  = var50_38 /* !! */ ;
                                                var50_38 /* !! */  = null;
                                                var51_39 /* !! */  = var8_8 /* !! */ ;
                                                break block69;
                                                break;
                                            }
lbl183:
                                            // 1 sources

                                            if (var51_39 /* !! */  == null) {
                                                var51_39 /* !! */  = HlsPlaylistParser.parseEncryptionScheme((String)var5_5 /* !! */ );
                                            }
                                            var5_5 /* !! */  = HlsPlaylistParser.parseDrmSchemeData(var58_45, (String)var4_4 /* !! */ , var7_7);
                                            var8_8 /* !! */  = var51_39 /* !! */ ;
                                            if (var5_5 /* !! */  == null) ** continue;
                                            var14_14.put(var4_4 /* !! */ , var5_5 /* !! */ );
                                            var8_8 /* !! */  = null;
                                            var34_26 = null;
                                            var4_4 /* !! */  = var50_38 /* !! */ ;
                                            var50_38 /* !! */  = var8_8 /* !! */ ;
                                        }
                                    }
                                    var64_51 /* !! */  = var4_4 /* !! */ ;
lbl196:
                                    // 2 sources

                                    while (true) {
                                        var5_5 /* !! */  = var1_1;
                                        var4_4 /* !! */  = var0;
                                        var8_8 /* !! */  = var59_46;
                                        var55_43 /* !! */  = var50_38 /* !! */ ;
                                        var50_38 /* !! */  = var64_51 /* !! */ ;
                                        continue block0;
                                        break;
                                    }
                                }
                                var5_5 /* !! */  = var51_39 /* !! */ ;
                                if (var58_45.startsWith("#EXT-X-BYTERANGE")) {
                                    var51_39 /* !! */  = Util.split(HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_BYTERANGE, var7_7), "@");
                                    var65_52 = Long.parseLong(var51_39 /* !! */ [0]);
                                    var17_17 = var21_19;
                                    var21_19 = var23_20;
                                    var48_37 = var65_52;
                                    var62_49 = var52_40;
                                    if (((String[])var51_39 /* !! */ ).length > 1) {
                                        var17_17 = Long.parseLong(var51_39 /* !! */ [1]);
                                        var62_49 = var52_40;
                                        var48_37 = var65_52;
                                        var21_19 = var23_20;
                                    }
lbl217:
                                    // 5 sources

                                    while (true) {
                                        var4_4 /* !! */  = var0;
                                        var59_46 = var1_1;
                                        var51_39 /* !! */  = var5_5 /* !! */ ;
                                        var5_5 /* !! */  = var59_46;
                                        var23_20 = var21_19;
                                        var52_40 = var62_49;
                                        ** continue;
                                        break;
                                    }
                                }
                                if (var58_45.startsWith("#EXT-X-DISCONTINUITY-SEQUENCE")) {
                                    var47_36 = Integer.parseInt(var58_45.substring(var58_45.indexOf(58) + 1));
                                    var55_43 /* !! */  = var0;
                                    var8_8 /* !! */  = var1_1;
                                    var51_39 /* !! */  = var5_5 /* !! */ ;
                                    var64_51 /* !! */  = var59_46;
                                    var59_46 = var4_4 /* !! */ ;
                                    var46_35 = true;
                                    var4_4 /* !! */  = var55_43 /* !! */ ;
                                    var5_5 /* !! */  = var8_8 /* !! */ ;
                                    var8_8 /* !! */  = var64_51 /* !! */ ;
                                    var55_43 /* !! */  = var59_46;
                                    continue;
                                }
                                if (!var58_45.equals("#EXT-X-DISCONTINUITY")) break block73;
                                var62_49 = var52_40 + 1;
                                var17_17 = var21_19;
                                var21_19 = var23_20;
                                ** GOTO lbl217
                            }
                            if (var58_45.startsWith("#EXT-X-PROGRAM-DATE-TIME")) {
                                if (var23_20 == 0L) {
                                    var23_20 = C.msToUs(Util.parseXsDateTime(var58_45.substring(var58_45.indexOf(58) + 1))) - var25_21;
                                    var17_17 = var21_19;
                                    var21_19 = var23_20;
                                    var62_49 = var52_40;
                                    ** continue;
                                }
                                var55_43 /* !! */  = var4_4 /* !! */ ;
                                ** continue;
                            }
                            if (var58_45.equals("#EXT-X-GAP")) {
                                var64_51 /* !! */  = var0;
                                var8_8 /* !! */  = var1_1;
                                var51_39 /* !! */  = var5_5 /* !! */ ;
                                var55_43 /* !! */  = var4_4 /* !! */ ;
                                var36_28 = true;
                                var4_4 /* !! */  = var64_51 /* !! */ ;
                                var5_5 /* !! */  = var8_8 /* !! */ ;
                                var8_8 /* !! */  = var59_46;
                                continue;
                            }
                            if (var58_45.equals("#EXT-X-INDEPENDENT-SEGMENTS")) {
                                var64_51 /* !! */  = var0;
                                var8_8 /* !! */  = var1_1;
                                var51_39 /* !! */  = var5_5 /* !! */ ;
                                var55_43 /* !! */  = var4_4 /* !! */ ;
                                var6_6 = true;
                                var4_4 /* !! */  = var64_51 /* !! */ ;
                                var5_5 /* !! */  = var8_8 /* !! */ ;
                                var8_8 /* !! */  = var59_46;
                                continue;
                            }
                            if (var58_45.equals("#EXT-X-ENDLIST")) {
                                var64_51 /* !! */  = var0;
                                var8_8 /* !! */  = var1_1;
                                var51_39 /* !! */  = var5_5 /* !! */ ;
                                var55_43 /* !! */  = var4_4 /* !! */ ;
                                var45_34 = true;
                                var4_4 /* !! */  = var64_51 /* !! */ ;
                                var5_5 /* !! */  = var8_8 /* !! */ ;
                                var8_8 /* !! */  = var59_46;
                                continue;
                            }
                            if (!var58_45.startsWith("#EXT-X-RENDITION-REPORT")) break block74;
                            var65_52 = var9_9.size();
                            var17_17 = (long)var10_10 /* !! */ .isEmpty();
                            var17_17 = HlsPlaylistParser.parseOptionalLongAttr(var58_45, HlsPlaylistParser.REGEX_LAST_MSN, var56_44 + var65_52 - var17_17);
                            var59_46 = var10_10 /* !! */ .isEmpty() != false ? Iterables.getLast(var9_9).parts : var10_10 /* !! */ ;
                            var62_49 = var43_33 != -9223372036854775807L ? var59_46.size() - 1 : -1;
                            var62_49 = HlsPlaylistParser.parseOptionalIntAttr(var58_45, HlsPlaylistParser.REGEX_LAST_PART, var62_49);
                            var59_46 = Uri.parse((String)UriUtil.resolve((String)var3_3, (String)HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_URI, var7_7)));
                            var11_11.put(var59_46, new HlsMediaPlaylist.RenditionReport((Uri)var59_46, var17_17, var62_49));
                            break block75;
                        }
                        var64_51 /* !! */  = var12_12 /* !! */ ;
                        var55_43 /* !! */  = var15_15 /* !! */ ;
                        if (!var58_45.startsWith("#EXT-X-PRELOAD-HINT")) break block76;
                        if (var33_25 == null) break block77;
                    }
                    while (true) {
                        var59_46 = var4_4 /* !! */ ;
                        var4_4 /* !! */  = var12_12 /* !! */ ;
                        var12_12 /* !! */  = var59_46;
                        ** GOTO lbl436
                        break;
                    }
                }
                if (!"PART".equals(HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_PRELOAD_HINT_TYPE, var7_7))) ** continue;
                var8_8 /* !! */  = HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_URI, var7_7);
                var17_17 = HlsPlaylistParser.parseOptionalLongAttr(var58_45, HlsPlaylistParser.REGEX_BYTERANGE_START, -1L);
                var65_52 = HlsPlaylistParser.parseOptionalLongAttr(var58_45, HlsPlaylistParser.REGEX_BYTERANGE_LENGTH, -1L);
                var12_12 /* !! */  = HlsPlaylistParser.getSegmentEncryptionIV(var27_22, (String)var4_4 /* !! */ , (String)var50_38 /* !! */ );
                if (var34_26 == null && !var14_14.isEmpty()) {
                    var15_15 /* !! */  = var14_14.values().toArray(new DrmInitData.SchemeData[0]);
                    var34_26 = new DrmInitData((String)var5_5 /* !! */ , (DrmInitData.SchemeData[])var15_15 /* !! */ );
                    var51_39 /* !! */  = var35_27 /* !! */ ;
                    if (var35_27 /* !! */  == null) {
                        var51_39 /* !! */  = HlsPlaylistParser.getPlaylistProtectionSchemes((String)var5_5 /* !! */ , (DrmInitData.SchemeData[])var15_15 /* !! */ );
                    }
                    var35_27 /* !! */  = var51_39 /* !! */ ;
                }
                if (var17_17 == -1L || var65_52 != -1L) {
                    if (var17_17 == -1L) {
                        var17_17 = 0L;
                    }
                    var33_25 = new HlsMediaPlaylist.Part((String)var8_8 /* !! */ , (HlsMediaPlaylist.Segment)var54_42, 0L, var52_40, var19_18, var34_26, (String)var4_4 /* !! */ , (String)var12_12 /* !! */ , var17_17, var65_52, false, false, true);
                }
                var12_12 /* !! */  = var64_51 /* !! */ ;
                var51_39 /* !! */  = var5_5 /* !! */ ;
                var64_51 /* !! */  = var50_38 /* !! */ ;
                var50_38 /* !! */  = var4_4 /* !! */ ;
                var15_15 /* !! */  = var55_43 /* !! */ ;
                ** continue;
            }
            var12_12 /* !! */  = var4_4 /* !! */ ;
            var17_17 = var27_22;
            var4_4 /* !! */  = var11_11;
            if (var58_45.startsWith("#EXT-X-PART")) {
                var8_8 /* !! */  = HlsPlaylistParser.getSegmentEncryptionIV(var17_17, (String)var12_12 /* !! */ , (String)var50_38 /* !! */ );
                var11_11 = HlsPlaylistParser.parseStringAttr(var58_45, HlsPlaylistParser.REGEX_URI, var7_7);
                var65_52 = (long)(HlsPlaylistParser.parseDoubleAttr(var58_45, HlsPlaylistParser.REGEX_ATTR_DURATION) * 1000000.0);
                var51_39 /* !! */  = HlsPlaylistParser.REGEX_INDEPENDENT;
                var61_48 = HlsPlaylistParser.parseOptionalBooleanAttribute(var58_45, (Pattern)var51_39 /* !! */ , false);
                var62_49 = var6_6 != false && var10_10 /* !! */ .isEmpty() != false ? 1 : 0;
                var67_53 = HlsPlaylistParser.parseOptionalBooleanAttribute(var58_45, HlsPlaylistParser.REGEX_GAP, false);
                var51_39 /* !! */  = HlsPlaylistParser.parseOptionalStringAttr(var58_45, HlsPlaylistParser.REGEX_ATTR_BYTERANGE, var7_7);
                if (var51_39 /* !! */  != null) {
                    var51_39 /* !! */  = Util.split((String)var51_39 /* !! */ , "@");
                    var17_17 = Long.parseLong((String)var51_39 /* !! */ [0]);
                    var60_47 = ((DrmInitData)var51_39 /* !! */ ).length;
                    if (var60_47 > 1) {
                        var31_24 = Long.parseLong(var51_39 /* !! */ [1]);
                    }
                } else {
                    var17_17 = -1L;
                }
                if (var17_17 == -1L) {
                    var31_24 = 0L;
                }
                var15_15 /* !! */  = var34_26;
                var51_39 /* !! */  = var35_27 /* !! */ ;
                if (var34_26 == null) {
                    var15_15 /* !! */  = var34_26;
                    var51_39 /* !! */  = var35_27 /* !! */ ;
                    if (!var14_14.isEmpty()) {
                        var34_26 = var14_14.values().toArray(new DrmInitData.SchemeData[0]);
                        var15_15 /* !! */  = new DrmInitData((String)var5_5 /* !! */ , (DrmInitData.SchemeData[])var34_26);
                        var51_39 /* !! */  = var35_27 /* !! */ ;
                        if (var35_27 /* !! */  == null) {
                            var51_39 /* !! */  = HlsPlaylistParser.getPlaylistProtectionSchemes((String)var5_5 /* !! */ , (DrmInitData.SchemeData[])var34_26);
                        }
                    }
                }
                var10_10 /* !! */ .add(new HlsMediaPlaylist.Part((String)var11_11, (HlsMediaPlaylist.Segment)var54_42, var65_52, var52_40, var19_18, var15_15 /* !! */ , (String)var12_12 /* !! */ , (String)var8_8 /* !! */ , var31_24, var17_17, var67_53, (boolean)(var61_48 | var62_49), false));
                var65_52 = var19_18 + var65_52;
                var19_18 = var31_24;
                if (var17_17 != -1L) {
                    var19_18 = var31_24 + var17_17;
                }
                var58_45 = var55_43 /* !! */ ;
                var8_8 /* !! */  = var59_46;
                var55_43 /* !! */  = var12_12 /* !! */ ;
                var11_11 = var4_4 /* !! */ ;
                var34_26 = var15_15 /* !! */ ;
                var35_27 /* !! */  = var51_39 /* !! */ ;
                var17_17 = var65_52;
                var51_39 /* !! */  = var5_5 /* !! */ ;
                var4_4 /* !! */  = var64_51 /* !! */ ;
                var31_24 = var19_18;
                var59_46 = var58_45;
            } else {
                if (!var58_45.startsWith("#")) {
                    var15_15 /* !! */  = HlsPlaylistParser.getSegmentEncryptionIV(var17_17, (String)var12_12 /* !! */ , (String)var50_38 /* !! */ );
                    var58_45 = HlsPlaylistParser.replaceVariableReferences(var58_45, var7_7);
                    var51_39 /* !! */  = (HlsMediaPlaylist.Segment)var59_46.get(var58_45);
                    if (var48_37 == -1L) {
                        var21_19 = 0L;
                        var8_8 /* !! */  = var51_39 /* !! */ ;
                    } else {
                        var8_8 /* !! */  = var51_39 /* !! */ ;
                        if (var53_41) {
                            var8_8 /* !! */  = var51_39 /* !! */ ;
                            if (var54_42 == null) {
                                var8_8 /* !! */  = var51_39 /* !! */ ;
                                if (var51_39 /* !! */  == null) {
                                    var8_8 /* !! */  = new HlsMediaPlaylist.Segment(var58_45, 0L, var21_19, null, null);
                                    var59_46.put(var58_45, var8_8 /* !! */ );
                                }
                            }
                        }
                    }
                    if (var34_26 == null && !var14_14.isEmpty()) {
                        var68_54 = var14_14.values().toArray(new DrmInitData.SchemeData[0]);
                        var11_11 = new DrmInitData((String)var5_5 /* !! */ , var68_54);
                        var51_39 /* !! */  = var11_11;
                        var34_26 = var35_27 /* !! */ ;
                        if (var35_27 /* !! */  == null) {
                            var34_26 = HlsPlaylistParser.getPlaylistProtectionSchemes((String)var5_5 /* !! */ , var68_54);
                            var51_39 /* !! */  = var11_11;
                        }
                    } else {
                        var51_39 /* !! */  = var34_26;
                        var34_26 = var35_27 /* !! */ ;
                    }
                    var35_27 /* !! */  = var54_42 != null ? var54_42 : var8_8 /* !! */ ;
                    var9_9.add(new HlsMediaPlaylist.Segment(var58_45, (HlsMediaPlaylist.Segment)var35_27 /* !! */ , var16_16, var29_23, var52_40, var25_21, var51_39 /* !! */ , (String)var12_12 /* !! */ , (String)var15_15 /* !! */ , var21_19, var48_37, var36_28, var10_10 /* !! */ ));
                    var19_18 = var25_21 + var29_23;
                    var10_10 /* !! */  = new ArrayList<E>();
                    var27_22 = var21_19;
                    if (var48_37 != -1L) {
                        var27_22 = var21_19 + var48_37;
                    }
                    var21_19 = var27_22;
                    var48_37 = -1L;
                    var35_27 /* !! */  = var34_26;
                    var34_26 = var51_39 /* !! */ ;
                    var29_23 = 0L;
                    var25_21 = var19_18;
                    var11_11 = var4_4 /* !! */ ;
                    var16_16 = var55_43 /* !! */ ;
                    var36_28 = false;
                    var4_4 /* !! */  = var0;
                    var8_8 /* !! */  = var1_1;
                    var51_39 /* !! */  = var5_5 /* !! */ ;
                    var15_15 /* !! */  = var16_16;
                    var27_22 = var17_17 + 1L;
                    var5_5 /* !! */  = var8_8 /* !! */ ;
                    var8_8 /* !! */  = var59_46;
                    var55_43 /* !! */  = var12_12 /* !! */ ;
                    var12_12 /* !! */  = var64_51 /* !! */ ;
                    continue;
                }
                var4_4 /* !! */  = var64_51 /* !! */ ;
lbl436:
                // 3 sources

                var59_46 = var15_15 /* !! */ ;
                var17_17 = var19_18;
                var55_43 /* !! */  = var12_12 /* !! */ ;
            }
            var64_51 /* !! */  = var50_38 /* !! */ ;
            var5_5 /* !! */  = var1_1;
            var50_38 /* !! */  = var0;
            var12_12 /* !! */  = var4_4 /* !! */ ;
            var4_4 /* !! */  = var50_38 /* !! */ ;
            var15_15 /* !! */  = var59_46;
            var19_18 = var17_17;
            var50_38 /* !! */  = var64_51 /* !! */ ;
        }
        if (var33_25 != null) {
            var10_10 /* !! */ .add(var33_25);
        }
        var36_28 = var23_20 != 0L;
        return new HlsMediaPlaylist(var37_29, var3_3, (List<String>)var12_12 /* !! */ , var38_30, var23_20, var46_35, var47_36, var56_44, var40_31, var41_32, var43_33, var6_6, var45_34, var36_28, var35_27 /* !! */ , (List<HlsMediaPlaylist.Segment>)var9_9, (List<HlsMediaPlaylist.Part>)var10_10 /* !! */ , var13_13, (Map<Uri, HlsMediaPlaylist.RenditionReport>)var11_11);
    }

    private static boolean parseOptionalBooleanAttribute(String object, Pattern pattern, boolean bl) {
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            return BOOLEAN_TRUE.equals(((Matcher)object).group(1));
        }
        return bl;
    }

    private static double parseOptionalDoubleAttr(String object, Pattern pattern, double d2) {
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            return Double.parseDouble(Assertions.checkNotNull(((Matcher)object).group(1)));
        }
        return d2;
    }

    private static int parseOptionalIntAttr(String object, Pattern pattern, int n2) {
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            return Integer.parseInt(Assertions.checkNotNull(((Matcher)object).group(1)));
        }
        return n2;
    }

    private static long parseOptionalLongAttr(String object, Pattern pattern, long l2) {
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            return Long.parseLong(Assertions.checkNotNull(((Matcher)object).group(1)));
        }
        return l2;
    }

    private static String parseOptionalStringAttr(String object, Pattern pattern, String string2, Map<String, String> map) {
        if (((Matcher)(object = pattern.matcher((CharSequence)object))).find()) {
            string2 = Assertions.checkNotNull(((Matcher)object).group(1));
        }
        object = string2;
        if (!map.isEmpty()) {
            object = string2 == null ? string2 : HlsPlaylistParser.replaceVariableReferences(string2, map);
        }
        return object;
    }

    private static String parseOptionalStringAttr(String string2, Pattern pattern, Map<String, String> map) {
        return HlsPlaylistParser.parseOptionalStringAttr(string2, pattern, null, map);
    }

    private static int parseRoleFlags(String objectArray, Map<String, String> map) {
        objectArray = HlsPlaylistParser.parseOptionalStringAttr((String)objectArray, REGEX_CHARACTERISTICS, map);
        boolean bl = TextUtils.isEmpty((CharSequence)objectArray);
        int n2 = 0;
        if (bl) {
            return 0;
        }
        if (Util.contains(objectArray = Util.split((String)objectArray, ","), "public.accessibility.describes-video")) {
            n2 = 512;
        }
        int n3 = n2;
        if (Util.contains(objectArray, "public.accessibility.transcribes-spoken-dialog")) {
            n3 = n2 | 0x1000;
        }
        n2 = n3;
        if (Util.contains(objectArray, "public.accessibility.describes-music-and-sound")) {
            n2 = n3 | 0x400;
        }
        n3 = n2;
        if (Util.contains(objectArray, "public.easy-to-read")) {
            n3 = n2 | 0x2000;
        }
        return n3;
    }

    private static int parseSelectionFlags(String string2) {
        int n2 = HlsPlaylistParser.parseOptionalBooleanAttribute(string2, REGEX_DEFAULT, false) ? 1 : 0;
        int n3 = n2;
        if (HlsPlaylistParser.parseOptionalBooleanAttribute(string2, REGEX_FORCED, false)) {
            n3 = n2 | 2;
        }
        n2 = n3;
        if (HlsPlaylistParser.parseOptionalBooleanAttribute(string2, REGEX_AUTOSELECT, false)) {
            n2 = n3 | 4;
        }
        return n2;
    }

    private static HlsMediaPlaylist.ServerControl parseServerControl(String string2) {
        double d2 = HlsPlaylistParser.parseOptionalDoubleAttr(string2, REGEX_CAN_SKIP_UNTIL, -9.223372036854776E18);
        long l2 = -9223372036854775807L;
        long l3 = d2 == -9.223372036854776E18 ? -9223372036854775807L : (long)(d2 * 1000000.0);
        boolean bl = HlsPlaylistParser.parseOptionalBooleanAttribute(string2, REGEX_CAN_SKIP_DATE_RANGES, false);
        d2 = HlsPlaylistParser.parseOptionalDoubleAttr(string2, REGEX_HOLD_BACK, -9.223372036854776E18);
        long l4 = d2 == -9.223372036854776E18 ? -9223372036854775807L : (long)(d2 * 1000000.0);
        d2 = HlsPlaylistParser.parseOptionalDoubleAttr(string2, REGEX_PART_HOLD_BACK, -9.223372036854776E18);
        if (d2 != -9.223372036854776E18) {
            l2 = (long)(d2 * 1000000.0);
        }
        return new HlsMediaPlaylist.ServerControl(l3, bl, l4, l2, HlsPlaylistParser.parseOptionalBooleanAttribute(string2, REGEX_CAN_BLOCK_RELOAD, false));
    }

    private static String parseStringAttr(String string2, Pattern pattern, Map<String, String> object) throws ParserException {
        if ((object = HlsPlaylistParser.parseOptionalStringAttr(string2, pattern, object)) != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Couldn't match ");
        ((StringBuilder)object).append(pattern.pattern());
        ((StringBuilder)object).append(" in ");
        ((StringBuilder)object).append(string2);
        throw new ParserException(((StringBuilder)object).toString());
    }

    private static String replaceVariableReferences(String string2, Map<String, String> map) {
        Matcher matcher = REGEX_VARIABLE_REFERENCE.matcher(string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            string2 = matcher.group(1);
            if (!map.containsKey(string2)) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(map.get(string2)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static int skipIgnorableWhitespace(BufferedReader bufferedReader, boolean bl, int n2) throws IOException {
        while (n2 != -1 && Character.isWhitespace(n2) && (bl || !Util.isLinebreak(n2))) {
            n2 = bufferedReader.read();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HlsPlaylist parse(Uri object, InputStream closeable) throws IOException {
        BufferedReader bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)((Object)bufferedReader)));
        UnrecognizedInputFormatException unrecognizedInputFormatException = new ArrayDeque();
        try {
            Object object2;
            if (!HlsPlaylistParser.checkPlaylistHeader(bufferedReader)) {
                unrecognizedInputFormatException = new UnrecognizedInputFormatException("Input does not start with the #EXTM3U header.", object);
                throw unrecognizedInputFormatException;
            }
            while ((object2 = bufferedReader.readLine()) != null) {
                if (((String)(object2 = ((String)object2).trim())).isEmpty()) continue;
                if (((String)object2).startsWith(TAG_STREAM_INF)) {
                    unrecognizedInputFormatException.add(object2);
                    object2 = new LineIterator((Queue<String>)unrecognizedInputFormatException, bufferedReader);
                    HlsMasterPlaylist hlsMasterPlaylist = HlsPlaylistParser.parseMasterPlaylist((LineIterator)object2, object.toString());
                    return hlsMasterPlaylist;
                }
                if (!(((String)object2).startsWith(TAG_TARGET_DURATION) || ((String)object2).startsWith(TAG_MEDIA_SEQUENCE) || ((String)object2).startsWith(TAG_MEDIA_DURATION) || ((String)object2).startsWith(TAG_KEY) || ((String)object2).startsWith(TAG_BYTERANGE) || ((String)object2).equals(TAG_DISCONTINUITY) || ((String)object2).equals(TAG_DISCONTINUITY_SEQUENCE) || ((String)object2).equals(TAG_ENDLIST))) {
                    unrecognizedInputFormatException.add(object2);
                    continue;
                }
                unrecognizedInputFormatException.add(object2);
                HlsMasterPlaylist hlsMasterPlaylist = this.masterPlaylist;
                HlsMediaPlaylist hlsMediaPlaylist = this.previousMediaPlaylist;
                object2 = new LineIterator((Queue<String>)unrecognizedInputFormatException, bufferedReader);
                HlsMediaPlaylist hlsMediaPlaylist2 = HlsPlaylistParser.parseMediaPlaylist(hlsMasterPlaylist, hlsMediaPlaylist, (LineIterator)object2, object.toString());
                return hlsMediaPlaylist2;
            }
            throw new ParserException("Failed to parse the playlist, could not identify any tags.");
        }
        finally {
            Util.closeQuietly(bufferedReader);
        }
    }

    public static final class DeltaUpdateException
    extends IOException {
    }

    private static class LineIterator {
        private final Queue<String> extraLines;
        private String next;
        private final BufferedReader reader;

        public LineIterator(Queue<String> queue, BufferedReader bufferedReader) {
            this.extraLines = queue;
            this.reader = bufferedReader;
        }

        @EnsuresNonNullIf(expression={"next"}, result=true)
        public boolean hasNext() throws IOException {
            block3: {
                if (this.next != null) {
                    return true;
                }
                if (!this.extraLines.isEmpty()) {
                    this.next = Assertions.checkNotNull(this.extraLines.poll());
                    return true;
                }
                do {
                    String string2;
                    this.next = string2 = this.reader.readLine();
                    if (string2 == null) break block3;
                    this.next = this.next.trim();
                } while (this.next.isEmpty());
                return true;
            }
            return false;
        }

        public String next() throws IOException {
            if (this.hasNext()) {
                String string2 = this.next;
                this.next = null;
                return string2;
            }
            throw new NoSuchElementException();
        }
    }
}

