/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class HlsMediaPlaylist
extends HlsPlaylist {
    public static final int PLAYLIST_TYPE_EVENT = 2;
    public static final int PLAYLIST_TYPE_UNKNOWN = 0;
    public static final int PLAYLIST_TYPE_VOD = 1;
    public final int discontinuitySequence;
    public final long durationUs;
    public final boolean hasDiscontinuitySequence;
    public final boolean hasEndTag;
    public final boolean hasProgramDateTime;
    public final long mediaSequence;
    public final long partTargetDurationUs;
    public final int playlistType;
    public final DrmInitData protectionSchemes;
    public final Map<Uri, RenditionReport> renditionReports;
    public final List<Segment> segments;
    public final ServerControl serverControl;
    public final long startOffsetUs;
    public final long startTimeUs;
    public final long targetDurationUs;
    public final List<Part> trailingParts;
    public final int version;

    public HlsMediaPlaylist(int n2, String object, List<String> list, long l2, long l3, boolean bl, int n3, long l4, int n4, long l5, long l6, boolean bl2, boolean bl3, boolean bl4, DrmInitData drmInitData, List<Segment> list2, List<Part> list3, ServerControl serverControl, Map<Uri, RenditionReport> map) {
        super((String)object, list, bl2);
        this.playlistType = n2;
        this.startTimeUs = l3;
        this.hasDiscontinuitySequence = bl;
        this.discontinuitySequence = n3;
        this.mediaSequence = l4;
        this.version = n4;
        this.targetDurationUs = l5;
        this.partTargetDurationUs = l6;
        this.hasEndTag = bl3;
        this.hasProgramDateTime = bl4;
        this.protectionSchemes = drmInitData;
        this.segments = ImmutableList.copyOf(list2);
        this.trailingParts = ImmutableList.copyOf(list3);
        this.renditionReports = ImmutableMap.copyOf(map);
        if (!list3.isEmpty()) {
            object = Iterables.getLast(list3);
            this.durationUs = ((Part)object).relativeStartTimeUs + ((Part)object).durationUs;
        } else if (!list2.isEmpty()) {
            object = Iterables.getLast(list2);
            this.durationUs = ((Segment)object).relativeStartTimeUs + ((Segment)object).durationUs;
        } else {
            this.durationUs = 0L;
        }
        if (l2 == -9223372036854775807L) {
            l2 = -9223372036854775807L;
        } else if (l2 < 0L) {
            l2 = this.durationUs + l2;
        }
        this.startOffsetUs = l2;
        this.serverControl = serverControl;
    }

    public HlsMediaPlaylist copy(List<StreamKey> list) {
        return this;
    }

    public HlsMediaPlaylist copyWith(long l2, int n2) {
        return new HlsMediaPlaylist(this.playlistType, this.baseUri, this.tags, this.startOffsetUs, l2, true, n2, this.mediaSequence, this.version, this.targetDurationUs, this.partTargetDurationUs, this.hasIndependentSegments, this.hasEndTag, this.hasProgramDateTime, this.protectionSchemes, this.segments, this.trailingParts, this.serverControl, this.renditionReports);
    }

    public HlsMediaPlaylist copyWithEndTag() {
        if (this.hasEndTag) {
            return this;
        }
        return new HlsMediaPlaylist(this.playlistType, this.baseUri, this.tags, this.startOffsetUs, this.startTimeUs, this.hasDiscontinuitySequence, this.discontinuitySequence, this.mediaSequence, this.version, this.targetDurationUs, this.partTargetDurationUs, this.hasIndependentSegments, true, this.hasProgramDateTime, this.protectionSchemes, this.segments, this.trailingParts, this.serverControl, this.renditionReports);
    }

    public long getEndTimeUs() {
        return this.startTimeUs + this.durationUs;
    }

    public boolean isNewerThan(HlsMediaPlaylist hlsMediaPlaylist) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = bl;
        if (hlsMediaPlaylist != null) {
            long l2 = this.mediaSequence;
            long l3 = hlsMediaPlaylist.mediaSequence;
            if (l2 > l3) {
                bl3 = bl;
            } else {
                if (l2 < l3) {
                    return false;
                }
                int n2 = this.segments.size() - hlsMediaPlaylist.segments.size();
                if (n2 != 0) {
                    bl3 = n2 > 0 ? bl2 : false;
                    return bl3;
                }
                int n3 = this.trailingParts.size();
                n2 = hlsMediaPlaylist.trailingParts.size();
                bl3 = bl;
                if (n3 <= n2) {
                    bl3 = n3 == n2 && this.hasEndTag && !hlsMediaPlaylist.hasEndTag ? bl : false;
                }
            }
        }
        return bl3;
    }

    public static final class Part
    extends SegmentBase {
        public final boolean isIndependent;
        public final boolean isPreload;

        public Part(String string2, Segment segment, long l2, int n2, long l3, DrmInitData drmInitData, String string3, String string4, long l4, long l5, boolean bl, boolean bl2, boolean bl3) {
            super(string2, segment, l2, n2, l3, drmInitData, string3, string4, l4, l5, bl);
            this.isIndependent = bl2;
            this.isPreload = bl3;
        }

        public Part copyWith(long l2, int n2) {
            return new Part(this.url, this.initializationSegment, this.durationUs, n2, l2, this.drmInitData, this.fullSegmentEncryptionKeyUri, this.encryptionIV, this.byteRangeOffset, this.byteRangeLength, this.hasGapTag, this.isIndependent, this.isPreload);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PlaylistType {
    }

    public static final class RenditionReport {
        public final long lastMediaSequence;
        public final int lastPartIndex;
        public final Uri playlistUri;

        public RenditionReport(Uri uri, long l2, int n2) {
            this.playlistUri = uri;
            this.lastMediaSequence = l2;
            this.lastPartIndex = n2;
        }
    }

    public static final class Segment
    extends SegmentBase {
        public final List<Part> parts;
        public final String title;

        public Segment(String string2, long l2, long l3, String string3, String string4) {
            this(string2, null, "", 0L, -1, -9223372036854775807L, null, string3, string4, l2, l3, false, ImmutableList.of());
        }

        public Segment(String string2, Segment segment, String string3, long l2, int n2, long l3, DrmInitData drmInitData, String string4, String string5, long l4, long l5, boolean bl, List<Part> list) {
            super(string2, segment, l2, n2, l3, drmInitData, string4, string5, l4, l5, bl);
            this.title = string3;
            this.parts = ImmutableList.copyOf(list);
        }

        public Segment copyWith(long l2, int n2) {
            ArrayList<Part> arrayList = new ArrayList<Part>();
            long l3 = l2;
            for (int i2 = 0; i2 < this.parts.size(); ++i2) {
                Part part = this.parts.get(i2);
                arrayList.add(part.copyWith(l3, n2));
                l3 += part.durationUs;
            }
            return new Segment(this.url, this.initializationSegment, this.title, this.durationUs, n2, l2, this.drmInitData, this.fullSegmentEncryptionKeyUri, this.encryptionIV, this.byteRangeOffset, this.byteRangeLength, this.hasGapTag, arrayList);
        }
    }

    public static class SegmentBase
    implements Comparable<Long> {
        public final long byteRangeLength;
        public final long byteRangeOffset;
        public final DrmInitData drmInitData;
        public final long durationUs;
        public final String encryptionIV;
        public final String fullSegmentEncryptionKeyUri;
        public final boolean hasGapTag;
        public final Segment initializationSegment;
        public final int relativeDiscontinuitySequence;
        public final long relativeStartTimeUs;
        public final String url;

        private SegmentBase(String string2, Segment segment, long l2, int n2, long l3, DrmInitData drmInitData, String string3, String string4, long l4, long l5, boolean bl) {
            this.url = string2;
            this.initializationSegment = segment;
            this.durationUs = l2;
            this.relativeDiscontinuitySequence = n2;
            this.relativeStartTimeUs = l3;
            this.drmInitData = drmInitData;
            this.fullSegmentEncryptionKeyUri = string3;
            this.encryptionIV = string4;
            this.byteRangeOffset = l4;
            this.byteRangeLength = l5;
            this.hasGapTag = bl;
        }

        @Override
        public int compareTo(Long l2) {
            int n2 = this.relativeStartTimeUs > l2 ? 1 : (this.relativeStartTimeUs < l2 ? -1 : 0);
            return n2;
        }
    }

    public static final class ServerControl {
        public final boolean canBlockReload;
        public final boolean canSkipDateRanges;
        public final long holdBackUs;
        public final long partHoldBackUs;
        public final long skipUntilUs;

        public ServerControl(long l2, boolean bl, long l3, long l4, boolean bl2) {
            this.skipUntilUs = l2;
            this.canSkipDateRanges = bl;
            this.holdBackUs = l3;
            this.partHoldBackUs = l4;
            this.canBlockReload = bl2;
        }
    }
}

