/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class WebvttExtractor
implements Extractor {
    private static final int HEADER_MAX_LENGTH = 9;
    private static final int HEADER_MIN_LENGTH = 6;
    private static final Pattern LOCAL_TIMESTAMP = Pattern.compile("LOCAL:([^,]+)");
    private static final Pattern MEDIA_TIMESTAMP = Pattern.compile("MPEGTS:(-?\\d+)");
    private final String language;
    private ExtractorOutput output;
    private byte[] sampleData;
    private final ParsableByteArray sampleDataWrapper;
    private int sampleSize;
    private final TimestampAdjuster timestampAdjuster;

    public WebvttExtractor(String string2, TimestampAdjuster timestampAdjuster) {
        this.language = string2;
        this.timestampAdjuster = timestampAdjuster;
        this.sampleDataWrapper = new ParsableByteArray();
        this.sampleData = new byte[1024];
    }

    @RequiresNonNull(value={"output"})
    private TrackOutput buildTrackOutput(long l2) {
        TrackOutput trackOutput = this.output.track(0, 3);
        trackOutput.format(new Format.Builder().setSampleMimeType("text/vtt").setLanguage(this.language).setSubsampleOffsetUs(l2).build());
        this.output.endTracks();
        return trackOutput;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresNonNull(value={"output"})
    private void processSample() throws ParserException {
        long l2;
        Object object = new ParsableByteArray(this.sampleData);
        WebvttParserUtil.validateWebvttHeaderLine((ParsableByteArray)object);
        Object object2 = object.readLine();
        long l3 = l2 = 0L;
        while (!TextUtils.isEmpty((CharSequence)object2)) {
            if (((String)object2).startsWith("X-TIMESTAMP-MAP")) {
                Matcher matcher = LOCAL_TIMESTAMP.matcher((CharSequence)object2);
                if (!matcher.find()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("X-TIMESTAMP-MAP doesn't contain local timestamp: ");
                    ((StringBuilder)object).append((String)object2);
                    throw new ParserException(((StringBuilder)object).toString());
                }
                Matcher matcher2 = MEDIA_TIMESTAMP.matcher((CharSequence)object2);
                if (!matcher2.find()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("X-TIMESTAMP-MAP doesn't contain media timestamp: ");
                    ((StringBuilder)object).append((String)object2);
                    throw new ParserException(((StringBuilder)object).toString());
                }
                l3 = WebvttParserUtil.parseTimestampUs((String)Assertions.checkNotNull(matcher.group(1)));
                l2 = TimestampAdjuster.ptsToUs((long)Long.parseLong(Assertions.checkNotNull(matcher2.group(1))));
            }
            object2 = object.readLine();
        }
        object2 = WebvttParserUtil.findNextCueHeader((ParsableByteArray)object);
        if (object2 == null) {
            this.buildTrackOutput(0L);
            return;
        }
        long l4 = WebvttParserUtil.parseTimestampUs((String)Assertions.checkNotNull(((Matcher)object2).group(1)));
        l3 = this.timestampAdjuster.adjustTsTimestamp(TimestampAdjuster.usToWrappedPts((long)(l2 + l4 - l3)));
        object2 = this.buildTrackOutput(l3 - l4);
        this.sampleDataWrapper.reset(this.sampleData, this.sampleSize);
        object2.sampleData(this.sampleDataWrapper, this.sampleSize);
        object2.sampleMetadata(l3, 1, this.sampleSize, 0, null);
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
        extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder object) throws IOException {
        Assertions.checkNotNull(this.output);
        int n2 = (int)extractorInput.getLength();
        int n3 = this.sampleSize;
        object = this.sampleData;
        if (n3 == ((PositionHolder)object).length) {
            n3 = n2 != -1 ? n2 : ((PositionHolder)object).length;
            this.sampleData = Arrays.copyOf((byte[])object, n3 * 3 / 2);
        }
        object = this.sampleData;
        n3 = this.sampleSize;
        if ((n3 = extractorInput.read((byte[])object, n3, ((PositionHolder)object).length - n3)) != -1) {
            this.sampleSize += n3;
            if (n2 == -1 || this.sampleSize != n2) {
                return 0;
            }
        }
        this.processSample();
        return -1;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        extractorInput.peekFully(this.sampleData, 0, 6, false);
        this.sampleDataWrapper.reset(this.sampleData, 6);
        if (WebvttParserUtil.isWebvttHeaderLine((ParsableByteArray)this.sampleDataWrapper)) {
            return true;
        }
        extractorInput.peekFully(this.sampleData, 6, 3, false);
        this.sampleDataWrapper.reset(this.sampleData, 9);
        return WebvttParserUtil.isWebvttHeaderLine((ParsableByteArray)this.sampleDataWrapper);
    }
}

