/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.media.MediaFormat;
import android.media.MediaParser;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.source.hls.BundledHlsMediaChunkExtractor;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsMediaChunkExtractor;
import com.google.android.exoplayer2.source.hls.WebvttExtractor;
import com.google.android.exoplayer2.source.hls._$;
import com.google.android.exoplayer2.source.mediaparser.InputReaderAdapterV30;
import com.google.android.exoplayer2.source.mediaparser.MediaParserUtil;
import com.google.android.exoplayer2.source.mediaparser.OutputConsumerAdapterV30;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.FileTypes;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MediaParserHlsMediaChunkExtractor
implements HlsMediaChunkExtractor {
    public static final HlsExtractorFactory FACTORY = _$.Lambda.MediaParserHlsMediaChunkExtractor.SJ03B_qeMhhiX8sHszYTiuofDLM.INSTANCE;
    private final Format format;
    private final InputReaderAdapterV30 inputReaderAdapter;
    private final MediaParser mediaParser;
    private final ImmutableList<MediaFormat> muxedCaptionMediaFormats;
    private final OutputConsumerAdapterV30 outputConsumerAdapter;
    private final boolean overrideInBandCaptionDeclarations;
    private int pendingSkipBytes;

    public MediaParserHlsMediaChunkExtractor(MediaParser mediaParser, OutputConsumerAdapterV30 outputConsumerAdapterV30, Format format, boolean bl, ImmutableList<MediaFormat> immutableList, int n2) {
        this.mediaParser = mediaParser;
        this.outputConsumerAdapter = outputConsumerAdapterV30;
        this.overrideInBandCaptionDeclarations = bl;
        this.muxedCaptionMediaFormats = immutableList;
        this.format = format;
        this.pendingSkipBytes = n2;
        this.inputReaderAdapter = new InputReaderAdapterV30();
    }

    private static MediaParser createMediaParserInstance(MediaParser.OutputConsumer outputConsumer, Format object, boolean bl, ImmutableList<MediaFormat> immutableList, String ... stringArray) {
        int n2 = stringArray.length;
        Boolean bl2 = true;
        outputConsumer = n2 == 1 ? MediaParser.createByName((String)stringArray[0], (MediaParser.OutputConsumer)outputConsumer) : MediaParser.create((MediaParser.OutputConsumer)outputConsumer, (String[])stringArray);
        outputConsumer.setParameter("android.media.mediaParser.exposeCaptionFormats", immutableList);
        outputConsumer.setParameter("android.media.mediaParser.overrideInBandCaptionDeclarations", (Object)bl);
        outputConsumer.setParameter("android.media.mediaparser.inBandCryptoInfo", (Object)bl2);
        outputConsumer.setParameter("android.media.mediaparser.eagerlyExposeTrackType", (Object)bl2);
        outputConsumer.setParameter("android.media.mediaparser.ignoreTimestampOffset", (Object)bl2);
        outputConsumer.setParameter("android.media.mediaparser.ts.ignoreSpliceInfoStream", (Object)bl2);
        outputConsumer.setParameter("android.media.mediaparser.ts.mode", (Object)"hls");
        object = object.codecs;
        if (!TextUtils.isEmpty((CharSequence)object)) {
            if (!"audio/mp4a-latm".equals(MimeTypes.getAudioMediaMimeType((String)object))) {
                outputConsumer.setParameter("android.media.mediaparser.ts.ignoreAacStream", (Object)bl2);
            }
            if (!"video/avc".equals(MimeTypes.getVideoMediaMimeType((String)object))) {
                outputConsumer.setParameter("android.media.mediaparser.ts.ignoreAvcStream", (Object)bl2);
            }
        }
        return outputConsumer;
    }

    static /* synthetic */ HlsMediaChunkExtractor lambda$static$0(Uri object, Format format, List collection, TimestampAdjuster object2, Map object3, ExtractorInput extractorInput) throws IOException {
        object = collection;
        if (FileTypes.inferFileTypeFromMimeType(format.sampleMimeType) == 13) {
            return new BundledHlsMediaChunkExtractor((Extractor)new WebvttExtractor(format.language, (TimestampAdjuster)object2), format, object2);
        }
        boolean bl = object != null;
        object3 = ImmutableList.builder();
        if (object != null) {
            for (int i2 = 0; i2 < collection.size(); ++i2) {
                ((ImmutableList.Builder)object3).add(MediaParserUtil.toCaptionsMediaFormat((Format)((Format)collection.get(i2))));
            }
        } else {
            ((ImmutableList.Builder)object3).add(MediaParserUtil.toCaptionsMediaFormat((Format)new Format.Builder().setSampleMimeType("application/cea-608").build()));
        }
        collection = ((ImmutableList.Builder)object3).build();
        object3 = new OutputConsumerAdapterV30();
        if (object == null) {
            object = ImmutableList.of();
        }
        object3.setMuxedCaptionFormats((List)object);
        object3.setTimestampAdjuster(object2);
        object = MediaParserHlsMediaChunkExtractor.createMediaParserInstance((MediaParser.OutputConsumer)object3, format, bl, (ImmutableList<MediaFormat>)collection, "android.media.mediaparser.FragmentedMp4Parser", "android.media.mediaparser.Ac3Parser", "android.media.mediaparser.Ac4Parser", "android.media.mediaparser.AdtsParser", "android.media.mediaparser.Mp3Parser", "android.media.mediaparser.TsParser");
        object2 = new PeekingInputReader(extractorInput);
        object.advance((MediaParser.SeekableInputReader)object2);
        object3.setSelectedParserName(object.getParserName());
        return new MediaParserHlsMediaChunkExtractor((MediaParser)object, (OutputConsumerAdapterV30)object3, format, bl, (ImmutableList<MediaFormat>)collection, ((PeekingInputReader)object2).totalPeekedBytes);
    }

    public void init(ExtractorOutput extractorOutput) {
        this.outputConsumerAdapter.setExtractorOutput(extractorOutput);
    }

    public boolean isPackedAudioExtractor() {
        String string2 = this.mediaParser.getParserName();
        boolean bl = "android.media.mediaparser.Ac3Parser".equals(string2) || "android.media.mediaparser.Ac4Parser".equals(string2) || "android.media.mediaparser.AdtsParser".equals(string2) || "android.media.mediaparser.Mp3Parser".equals(string2);
        return bl;
    }

    public boolean isReusable() {
        String string2 = this.mediaParser.getParserName();
        boolean bl = "android.media.mediaparser.FragmentedMp4Parser".equals(string2) || "android.media.mediaparser.TsParser".equals(string2);
        return bl;
    }

    public void onTruncatedSegmentParsed() {
        this.mediaParser.seek(MediaParser.SeekPoint.START);
    }

    public boolean read(ExtractorInput extractorInput) throws IOException {
        extractorInput.skipFully(this.pendingSkipBytes);
        this.pendingSkipBytes = 0;
        this.inputReaderAdapter.setDataReader((DataReader)extractorInput, extractorInput.getLength());
        return this.mediaParser.advance((MediaParser.SeekableInputReader)this.inputReaderAdapter);
    }

    public HlsMediaChunkExtractor recreate() {
        Assertions.checkState(this.isReusable() ^ true);
        return new MediaParserHlsMediaChunkExtractor(MediaParserHlsMediaChunkExtractor.createMediaParserInstance((MediaParser.OutputConsumer)this.outputConsumerAdapter, this.format, this.overrideInBandCaptionDeclarations, this.muxedCaptionMediaFormats, this.mediaParser.getParserName()), this.outputConsumerAdapter, this.format, this.overrideInBandCaptionDeclarations, this.muxedCaptionMediaFormats, 0);
    }

    private static final class PeekingInputReader
    implements MediaParser.SeekableInputReader {
        private final ExtractorInput extractorInput;
        private int totalPeekedBytes;

        private PeekingInputReader(ExtractorInput extractorInput) {
            this.extractorInput = extractorInput;
        }

        public long getLength() {
            return this.extractorInput.getLength();
        }

        public long getPosition() {
            return this.extractorInput.getPeekPosition();
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            n2 = this.extractorInput.peek(byArray, n2, n3);
            this.totalPeekedBytes += n2;
            return n2;
        }

        public void seekToPosition(long l2) {
            throw new UnsupportedOperationException();
        }
    }
}

