/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseIntArray;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.metadata.emsg.EventMessageDecoder;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.HlsSampleStream;
import com.google.android.exoplayer2.source.hls._$$Lambda$COgt3RAipLG3mXfQxbryzRjBpos;
import com.google.android.exoplayer2.source.hls._$$Lambda$HlsSampleStreamWrapper$8JyeEr0irIOShv9LlAxAmgzl5vY;
import com.google.android.exoplayer2.source.hls._$$Lambda$HlsSampleStreamWrapper$afhkI3tagC__MAOTh7FzBWzQsno;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class HlsSampleStreamWrapper
implements Loader.Callback<Chunk>,
Loader.ReleaseCallback,
SequenceableLoader,
ExtractorOutput,
SampleQueue.UpstreamFormatChangedListener {
    private static final Set<Integer> MAPPABLE_TYPES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 5)));
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_FATAL = -2;
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_NON_FATAL = -3;
    public static final int SAMPLE_QUEUE_INDEX_PENDING = -1;
    private static final String TAG = "HlsSampleStreamWrapper";
    private final Allocator allocator;
    private final Callback callback;
    private final HlsChunkSource chunkSource;
    private Format downstreamTrackFormat;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private DrmInitData drmInitData;
    private final DrmSessionManager drmSessionManager;
    private TrackOutput emsgUnwrappingTrackOutput;
    private int enabledTrackGroupCount;
    private final Handler handler;
    private boolean haveAudioVideoSampleQueues;
    private final ArrayList<HlsSampleStream> hlsSampleStreams;
    private long lastSeekPositionUs;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final Loader loader;
    private Chunk loadingChunk;
    private boolean loadingFinished;
    private final Runnable maybeFinishPrepareRunnable;
    private final ArrayList<HlsMediaChunk> mediaChunks;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private final int metadataType;
    private final Format muxedAudioFormat;
    private final HlsChunkSource.HlsChunkHolder nextChunkHolder;
    private final Runnable onTracksEndedRunnable;
    private Set<TrackGroup> optionalTrackGroups;
    private final Map<String, DrmInitData> overridingDrmInitData;
    private long pendingResetPositionUs;
    private boolean pendingResetUpstreamFormats;
    private boolean prepared;
    private int primarySampleQueueIndex;
    private int primarySampleQueueType;
    private int primaryTrackGroupIndex;
    private final List<HlsMediaChunk> readOnlyMediaChunks;
    private boolean released;
    private long sampleOffsetUs;
    private SparseIntArray sampleQueueIndicesByType;
    private boolean[] sampleQueueIsAudioVideoFlags;
    private Set<Integer> sampleQueueMappingDoneByType;
    private int[] sampleQueueTrackIds;
    private HlsSampleQueue[] sampleQueues;
    private boolean sampleQueuesBuilt;
    private boolean[] sampleQueuesEnabledStates;
    private boolean seenFirstTrackSelection;
    private HlsMediaChunk sourceChunk;
    private int[] trackGroupToSampleQueueIndex;
    private TrackGroupArray trackGroups;
    private final int trackType;
    private boolean tracksEnded;
    private Format upstreamTrackFormat;

    public HlsSampleStreamWrapper(int n2, Callback callback2, HlsChunkSource hlsChunkSource, Map<String, DrmInitData> map, Allocator allocator, long l2, Format format, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher2, int n3) {
        this.trackType = n2;
        this.callback = callback2;
        this.chunkSource = hlsChunkSource;
        this.overridingDrmInitData = map;
        this.allocator = allocator;
        this.muxedAudioFormat = format;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = eventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.mediaSourceEventDispatcher = eventDispatcher2;
        this.metadataType = n3;
        this.loader = new Loader("Loader:HlsSampleStreamWrapper");
        this.nextChunkHolder = new HlsChunkSource.HlsChunkHolder();
        this.sampleQueueTrackIds = new int[0];
        this.sampleQueueMappingDoneByType = new HashSet<Integer>(MAPPABLE_TYPES.size());
        this.sampleQueueIndicesByType = new SparseIntArray(MAPPABLE_TYPES.size());
        this.sampleQueues = new HlsSampleQueue[0];
        this.sampleQueueIsAudioVideoFlags = new boolean[0];
        this.sampleQueuesEnabledStates = new boolean[0];
        this.mediaChunks = new ArrayList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        this.hlsSampleStreams = new ArrayList();
        this.maybeFinishPrepareRunnable = new _$$Lambda$HlsSampleStreamWrapper$8JyeEr0irIOShv9LlAxAmgzl5vY(this);
        this.onTracksEndedRunnable = new _$$Lambda$HlsSampleStreamWrapper$afhkI3tagC__MAOTh7FzBWzQsno(this);
        this.handler = Util.createHandlerForCurrentLooper();
        this.lastSeekPositionUs = l2;
        this.pendingResetPositionUs = l2;
    }

    @EnsuresNonNull(value={"trackGroups", "optionalTrackGroups"})
    private void assertIsPrepared() {
        Assertions.checkState(this.prepared);
        Assertions.checkNotNull(this.trackGroups);
        Assertions.checkNotNull(this.optionalTrackGroups);
    }

    @EnsuresNonNull(value={"trackGroups", "optionalTrackGroups", "trackGroupToSampleQueueIndex"})
    private void buildTracksFromSampleStreams() {
        int n2;
        Object object;
        int n3;
        int n4 = this.sampleQueues.length;
        boolean bl = false;
        int n5 = 0;
        int n6 = 7;
        int n7 = -1;
        while (true) {
            int n8;
            n3 = 2;
            if (n5 >= n4) break;
            object = Assertions.checkStateNotNull(this.sampleQueues[n5].getUpstreamFormat()).sampleMimeType;
            if (!MimeTypes.isVideo((String)object)) {
                n3 = MimeTypes.isAudio((String)object) ? 1 : (MimeTypes.isText((String)object) ? 3 : 7);
            }
            if (HlsSampleStreamWrapper.getTrackTypeScore(n3) > HlsSampleStreamWrapper.getTrackTypeScore(n6)) {
                n2 = n5;
                n8 = n3;
            } else {
                n8 = n6;
                n2 = n7;
                if (n3 == n6) {
                    n8 = n6;
                    n2 = n7;
                    if (n7 != -1) {
                        n2 = -1;
                        n8 = n6;
                    }
                }
            }
            ++n5;
            n6 = n8;
            n7 = n2;
        }
        TrackGroup trackGroup = this.chunkSource.getTrackGroup();
        n2 = trackGroup.length;
        this.primaryTrackGroupIndex = -1;
        this.trackGroupToSampleQueueIndex = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.trackGroupToSampleQueueIndex[n3] = n3;
        }
        TrackGroup[] trackGroupArray = new TrackGroup[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            Format format = Assertions.checkStateNotNull(this.sampleQueues[n3].getUpstreamFormat());
            if (n3 == n7) {
                object = new Format[n2];
                if (n2 == 1) {
                    object[0] = format.withManifestFormatInfo(trackGroup.getFormat(0));
                } else {
                    for (n5 = 0; n5 < n2; ++n5) {
                        object[n5] = HlsSampleStreamWrapper.deriveFormat(trackGroup.getFormat(n5), format, true);
                    }
                }
                trackGroupArray[n3] = new TrackGroup((Format[])object);
                this.primaryTrackGroupIndex = n3;
                continue;
            }
            object = n6 == 2 && MimeTypes.isAudio((String)format.sampleMimeType) ? this.muxedAudioFormat : null;
            trackGroupArray[n3] = new TrackGroup(new Format[]{HlsSampleStreamWrapper.deriveFormat(object, format, false)});
        }
        this.trackGroups = this.createTrackGroupArrayWithDrmInfo(trackGroupArray);
        if (this.optionalTrackGroups == null) {
            bl = true;
        }
        Assertions.checkState(bl);
        this.optionalTrackGroups = Collections.emptySet();
    }

    private boolean canDiscardUpstreamMediaChunksFromIndex(int n2) {
        int n3;
        for (n3 = n2; n3 < this.mediaChunks.size(); ++n3) {
            if (!this.mediaChunks.get((int)n3).shouldSpliceIn) continue;
            return false;
        }
        HlsMediaChunk hlsMediaChunk = this.mediaChunks.get(n2);
        for (n2 = 0; n2 < this.sampleQueues.length; ++n2) {
            n3 = hlsMediaChunk.getFirstSampleIndex(n2);
            if (this.sampleQueues[n2].getReadIndex() <= n3) continue;
            return false;
        }
        return true;
    }

    private static DummyTrackOutput createFakeTrackOutput(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unmapped track with id ");
        stringBuilder.append(n2);
        stringBuilder.append(" of type ");
        stringBuilder.append(n3);
        Log.w(TAG, stringBuilder.toString());
        return new DummyTrackOutput();
    }

    private SampleQueue createSampleQueue(int n2, int n3) {
        int n4;
        int n5 = this.sampleQueues.length;
        int n6 = n4 = 1;
        if (n3 != 1) {
            n6 = n3 == 2 ? n4 : 0;
        }
        HlsSampleQueue hlsSampleQueue = new HlsSampleQueue(this.allocator, this.handler.getLooper(), this.drmSessionManager, this.drmEventDispatcher, this.overridingDrmInitData);
        hlsSampleQueue.setStartTimeUs(this.lastSeekPositionUs);
        if (n6 != 0) {
            hlsSampleQueue.setDrmInitData(this.drmInitData);
        }
        hlsSampleQueue.setSampleOffsetUs(this.sampleOffsetUs);
        Object object = this.sourceChunk;
        if (object != null) {
            hlsSampleQueue.setSourceChunk((HlsMediaChunk)object);
        }
        hlsSampleQueue.setUpstreamFormatChangeListener(this);
        object = this.sampleQueueTrackIds;
        int n7 = n5 + 1;
        this.sampleQueueTrackIds = Arrays.copyOf((int[])object, n7);
        this.sampleQueueTrackIds[n5] = n2;
        this.sampleQueues = Util.nullSafeArrayAppend(this.sampleQueues, hlsSampleQueue);
        this.sampleQueueIsAudioVideoFlags = Arrays.copyOf(this.sampleQueueIsAudioVideoFlags, n7);
        object = this.sampleQueueIsAudioVideoFlags;
        object[n5] = n6;
        n6 = this.haveAudioVideoSampleQueues;
        this.haveAudioVideoSampleQueues = object[n5] | n6;
        this.sampleQueueMappingDoneByType.add(n3);
        this.sampleQueueIndicesByType.append(n3, n5);
        if (HlsSampleStreamWrapper.getTrackTypeScore(n3) > HlsSampleStreamWrapper.getTrackTypeScore(this.primarySampleQueueType)) {
            this.primarySampleQueueIndex = n5;
            this.primarySampleQueueType = n3;
        }
        this.sampleQueuesEnabledStates = Arrays.copyOf(this.sampleQueuesEnabledStates, n7);
        return hlsSampleQueue;
    }

    private TrackGroupArray createTrackGroupArrayWithDrmInfo(TrackGroup[] trackGroupArray) {
        for (int i2 = 0; i2 < trackGroupArray.length; ++i2) {
            TrackGroup trackGroup = trackGroupArray[i2];
            Format[] formatArray = new Format[trackGroup.length];
            for (int i3 = 0; i3 < trackGroup.length; ++i3) {
                Format format = trackGroup.getFormat(i3);
                formatArray[i3] = format.copyWithExoMediaCryptoType(this.drmSessionManager.getExoMediaCryptoType(format));
            }
            trackGroupArray[i2] = new TrackGroup(formatArray);
        }
        return new TrackGroupArray(trackGroupArray);
    }

    private static Format deriveFormat(Format object, Format format, boolean bl) {
        String string2;
        String string3;
        if (object == null) {
            return format;
        }
        int n2 = MimeTypes.getTrackType((String)format.sampleMimeType);
        if (Util.getCodecCountOfType(object.codecs, n2) == 1) {
            string3 = Util.getCodecsOfType(object.codecs, n2);
            string2 = MimeTypes.getMediaMimeType((String)string3);
        } else {
            string3 = MimeTypes.getCodecsCorrespondingToMimeType((String)object.codecs, (String)format.sampleMimeType);
            string2 = format.sampleMimeType;
        }
        Format.Builder builder = format.buildUpon().setId(object.id).setLabel(object.label).setLanguage(object.language).setSelectionFlags(object.selectionFlags).setRoleFlags(object.roleFlags);
        n2 = bl ? object.averageBitrate : -1;
        builder = builder.setAverageBitrate(n2);
        n2 = bl ? object.peakBitrate : -1;
        string3 = builder.setPeakBitrate(n2).setCodecs(string3).setWidth(object.width).setHeight(object.height);
        if (string2 != null) {
            string3.setSampleMimeType(string2);
        }
        if (object.channelCount != -1) {
            string3.setChannelCount(object.channelCount);
        }
        if (object.metadata != null) {
            string2 = object.metadata;
            object = string2;
            if (format.metadata != null) {
                object = format.metadata.copyWithAppendedEntriesFrom((Metadata)string2);
            }
            string3.setMetadata((Metadata)object);
        }
        return string3.build();
    }

    private void discardUpstream(int n2) {
        block5: {
            Assertions.checkState(this.loader.isLoading() ^ true);
            while (n2 < this.mediaChunks.size()) {
                if (!this.canDiscardUpstreamMediaChunksFromIndex(n2)) {
                    ++n2;
                    continue;
                }
                break block5;
            }
            n2 = -1;
        }
        if (n2 == -1) {
            return;
        }
        long l2 = this.getLastMediaChunk().endTimeUs;
        HlsMediaChunk hlsMediaChunk = this.discardUpstreamMediaChunksFromIndex(n2);
        if (this.mediaChunks.isEmpty()) {
            this.pendingResetPositionUs = this.lastSeekPositionUs;
        } else {
            Iterables.getLast(this.mediaChunks).invalidateExtractor();
        }
        this.loadingFinished = false;
        this.mediaSourceEventDispatcher.upstreamDiscarded(this.primarySampleQueueType, hlsMediaChunk.startTimeUs, l2);
    }

    private HlsMediaChunk discardUpstreamMediaChunksFromIndex(int n2) {
        HlsMediaChunk hlsMediaChunk = this.mediaChunks.get(n2);
        ArrayList<HlsMediaChunk> arrayList = this.mediaChunks;
        Util.removeRange(arrayList, n2, arrayList.size());
        for (n2 = 0; n2 < this.sampleQueues.length; ++n2) {
            int n3 = hlsMediaChunk.getFirstSampleIndex(n2);
            this.sampleQueues[n2].discardUpstreamSamples(n3);
        }
        return hlsMediaChunk;
    }

    private boolean finishedReadingChunk(HlsMediaChunk hlsMediaChunk) {
        int n2 = hlsMediaChunk.uid;
        int n3 = this.sampleQueues.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.sampleQueuesEnabledStates[i2] || this.sampleQueues[i2].peekSourceId() != n2) continue;
            return false;
        }
        return true;
    }

    private static boolean formatsMatch(Format format, Format format2) {
        String string2 = format.sampleMimeType;
        String string3 = format2.sampleMimeType;
        int n2 = MimeTypes.getTrackType((String)string2);
        boolean bl = true;
        boolean bl2 = true;
        if (n2 != 3) {
            if (n2 != MimeTypes.getTrackType((String)string3)) {
                bl2 = false;
            }
            return bl2;
        }
        if (!Util.areEqual(string2, string3)) {
            return false;
        }
        if (!"application/cea-608".equals(string2) && !"application/cea-708".equals(string2)) {
            return true;
        }
        bl2 = format.accessibilityChannel == format2.accessibilityChannel ? bl : false;
        return bl2;
    }

    private HlsMediaChunk getLastMediaChunk() {
        ArrayList<HlsMediaChunk> arrayList = this.mediaChunks;
        return arrayList.get(arrayList.size() - 1);
    }

    private TrackOutput getMappedTrackOutput(int n2, int n3) {
        Assertions.checkArgument(MAPPABLE_TYPES.contains(n3));
        int n4 = this.sampleQueueIndicesByType.get(n3, -1);
        if (n4 == -1) {
            return null;
        }
        if (this.sampleQueueMappingDoneByType.add(n3)) {
            this.sampleQueueTrackIds[n4] = n2;
        }
        Object object = this.sampleQueueTrackIds[n4] == n2 ? this.sampleQueues[n4] : HlsSampleStreamWrapper.createFakeTrackOutput(n2, n3);
        return object;
    }

    private static int getTrackTypeScore(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    return 0;
                }
                return 1;
            }
            return 3;
        }
        return 2;
    }

    private void initMediaChunkLoad(HlsMediaChunk hlsMediaChunk) {
        int n2;
        this.sourceChunk = hlsMediaChunk;
        this.upstreamTrackFormat = hlsMediaChunk.trackFormat;
        this.pendingResetPositionUs = -9223372036854775807L;
        this.mediaChunks.add(hlsMediaChunk);
        HlsSampleQueue[] hlsSampleQueueArray = ImmutableList.builder();
        Object object = this.sampleQueues;
        int n3 = ((HlsSampleQueue[])object).length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            hlsSampleQueueArray.add((Object)object[n2].getWriteIndex());
        }
        hlsMediaChunk.init(this, (ImmutableList<Integer>)hlsSampleQueueArray.build());
        hlsSampleQueueArray = this.sampleQueues;
        n3 = hlsSampleQueueArray.length;
        for (n2 = n4; n2 < n3; ++n2) {
            object = hlsSampleQueueArray[n2];
            ((HlsSampleQueue)object).setSourceChunk(hlsMediaChunk);
            if (!hlsMediaChunk.shouldSpliceIn) continue;
            ((SampleQueue)object).splice();
        }
    }

    private static boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof HlsMediaChunk;
    }

    private boolean isPendingReset() {
        boolean bl = this.pendingResetPositionUs != -9223372036854775807L;
        return bl;
    }

    public static /* synthetic */ void lambda$8JyeEr0irIOShv9LlAxAmgzl5vY(HlsSampleStreamWrapper hlsSampleStreamWrapper) {
        hlsSampleStreamWrapper.maybeFinishPrepare();
    }

    public static /* synthetic */ void lambda$afhkI3tagC_-MAOTh7FzBWzQsno(HlsSampleStreamWrapper hlsSampleStreamWrapper) {
        hlsSampleStreamWrapper.onTracksEnded();
    }

    @EnsuresNonNull(value={"trackGroupToSampleQueueIndex"})
    @RequiresNonNull(value={"trackGroups"})
    private void mapSampleQueuesToMatchTrackGroups() {
        HlsSampleQueue[] hlsSampleQueueArray;
        int n2 = this.trackGroups.length;
        this.trackGroupToSampleQueueIndex = new int[n2];
        Arrays.fill(this.trackGroupToSampleQueueIndex, -1);
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < (hlsSampleQueueArray = this.sampleQueues).length; ++i3) {
                if (!HlsSampleStreamWrapper.formatsMatch(Assertions.checkStateNotNull(hlsSampleQueueArray[i3].getUpstreamFormat()), this.trackGroups.get(i2).getFormat(0))) continue;
                this.trackGroupToSampleQueueIndex[i2] = i3;
                continue block0;
            }
        }
        hlsSampleQueueArray = this.hlsSampleStreams.iterator();
        while (hlsSampleQueueArray.hasNext()) {
            ((HlsSampleStream)hlsSampleQueueArray.next()).bindSampleQueue();
        }
    }

    private void maybeFinishPrepare() {
        if (!this.released && this.trackGroupToSampleQueueIndex == null && this.sampleQueuesBuilt) {
            HlsSampleQueue[] hlsSampleQueueArray = this.sampleQueues;
            int n2 = hlsSampleQueueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (hlsSampleQueueArray[i2].getUpstreamFormat() != null) continue;
                return;
            }
            if (this.trackGroups != null) {
                this.mapSampleQueuesToMatchTrackGroups();
            } else {
                this.buildTracksFromSampleStreams();
                this.setIsPrepared();
                this.callback.onPrepared();
            }
        }
    }

    private void onTracksEnded() {
        this.sampleQueuesBuilt = true;
        this.maybeFinishPrepare();
    }

    private void resetSampleQueues() {
        HlsSampleQueue[] hlsSampleQueueArray = this.sampleQueues;
        int n2 = hlsSampleQueueArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            hlsSampleQueueArray[i2].reset(this.pendingResetUpstreamFormats);
        }
        this.pendingResetUpstreamFormats = false;
    }

    private boolean seekInsideBufferUs(long l2) {
        int n2 = this.sampleQueues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.sampleQueues[i2].seekTo(l2, false) || !this.sampleQueueIsAudioVideoFlags[i2] && this.haveAudioVideoSampleQueues) continue;
            return false;
        }
        return true;
    }

    @RequiresNonNull(value={"trackGroups", "optionalTrackGroups"})
    private void setIsPrepared() {
        this.prepared = true;
    }

    private void updateSampleStreams(SampleStream[] sampleStreamArray) {
        this.hlsSampleStreams.clear();
        for (SampleStream sampleStream : sampleStreamArray) {
            if (sampleStream == null) continue;
            this.hlsSampleStreams.add((HlsSampleStream)sampleStream);
        }
    }

    public int bindSampleQueueToSampleStream(int n2) {
        this.assertIsPrepared();
        Assertions.checkNotNull(this.trackGroupToSampleQueueIndex);
        int n3 = this.trackGroupToSampleQueueIndex[n2];
        int n4 = -2;
        if (n3 == -1) {
            if (this.optionalTrackGroups.contains(this.trackGroups.get(n2))) {
                n4 = -3;
            }
            return n4;
        }
        boolean[] blArray = this.sampleQueuesEnabledStates;
        if (blArray[n3]) {
            return -2;
        }
        blArray[n3] = true;
        return n3;
    }

    @Override
    public boolean continueLoading(long l2) {
        if (!(this.loadingFinished || this.loader.isLoading() || this.loader.hasFatalError())) {
            long l3;
            Object object;
            Object object2;
            if (this.isPendingReset()) {
                object2 = Collections.emptyList();
                long l4 = this.pendingResetPositionUs;
                HlsSampleQueue[] hlsSampleQueueArray = this.sampleQueues;
                int n2 = hlsSampleQueueArray.length;
                int n3 = 0;
                while (true) {
                    object = object2;
                    l3 = l4;
                    if (n3 < n2) {
                        hlsSampleQueueArray[n3].setStartTimeUs(this.pendingResetPositionUs);
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else {
                object = this.readOnlyMediaChunks;
                object2 = this.getLastMediaChunk();
                l3 = ((HlsMediaChunk)object2).isLoadCompleted() ? ((HlsMediaChunk)object2).endTimeUs : Math.max(this.lastSeekPositionUs, ((HlsMediaChunk)object2).startTimeUs);
            }
            object2 = this.chunkSource;
            boolean bl = this.prepared || !object.isEmpty();
            ((HlsChunkSource)object2).getNextChunk(l2, l3, (List<HlsMediaChunk>)object, bl, this.nextChunkHolder);
            bl = this.nextChunkHolder.endOfStream;
            object = this.nextChunkHolder.chunk;
            object2 = this.nextChunkHolder.playlistUrl;
            this.nextChunkHolder.clear();
            if (bl) {
                this.pendingResetPositionUs = -9223372036854775807L;
                this.loadingFinished = true;
                return true;
            }
            if (object == null) {
                if (object2 != null) {
                    this.callback.onPlaylistRefreshRequired((Uri)object2);
                }
                return false;
            }
            if (HlsSampleStreamWrapper.isMediaChunk((Chunk)object)) {
                this.initMediaChunkLoad((HlsMediaChunk)object);
            }
            this.loadingChunk = object;
            l2 = this.loader.startLoading(object, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(((Chunk)object).type));
            this.mediaSourceEventDispatcher.loadStarted(new LoadEventInfo(((Chunk)object).loadTaskId, ((Chunk)object).dataSpec, l2), ((Chunk)object).type, this.trackType, ((Chunk)object).trackFormat, ((Chunk)object).trackSelectionReason, ((Chunk)object).trackSelectionData, ((Chunk)object).startTimeUs, ((Chunk)object).endTimeUs);
            return true;
        }
        return false;
    }

    public void continuePreparing() {
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        }
    }

    public void discardBuffer(long l2, boolean bl) {
        if (this.sampleQueuesBuilt && !this.isPendingReset()) {
            int n2 = this.sampleQueues.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.sampleQueues[i2].discardTo(l2, bl, this.sampleQueuesEnabledStates[i2]);
            }
        }
    }

    @Override
    public void endTracks() {
        this.tracksEnded = true;
        this.handler.post(this.onTracksEndedRunnable);
    }

    @Override
    public long getBufferedPositionUs() {
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long l2 = this.lastSeekPositionUs;
        Object object = this.getLastMediaChunk();
        if (!object.isLoadCompleted()) {
            if (this.mediaChunks.size() > 1) {
                object = this.mediaChunks;
                object = (HlsMediaChunk)object.get(object.size() - 2);
            } else {
                object = null;
            }
        }
        long l3 = l2;
        if (object != null) {
            l3 = Math.max(l2, object.endTimeUs);
        }
        l2 = l3;
        if (this.sampleQueuesBuilt) {
            object = this.sampleQueues;
            int n2 = ((HlsSampleQueue[])object).length;
            int n3 = 0;
            while (true) {
                l2 = l3;
                if (n3 >= n2) break;
                l3 = Math.max(l3, object[n3].getLargestQueuedTimestampUs());
                ++n3;
            }
        }
        return l2;
    }

    @Override
    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long l2 = this.loadingFinished ? Long.MIN_VALUE : this.getLastMediaChunk().endTimeUs;
        return l2;
    }

    public int getPrimaryTrackGroupIndex() {
        return this.primaryTrackGroupIndex;
    }

    public TrackGroupArray getTrackGroups() {
        this.assertIsPrepared();
        return this.trackGroups;
    }

    @Override
    public boolean isLoading() {
        return this.loader.isLoading();
    }

    public boolean isReady(int n2) {
        boolean bl = !this.isPendingReset() && this.sampleQueues[n2].isReady(this.loadingFinished);
        return bl;
    }

    public void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        this.chunkSource.maybeThrowError();
    }

    public void maybeThrowError(int n2) throws IOException {
        this.maybeThrowError();
        this.sampleQueues[n2].maybeThrowError();
    }

    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
        if (this.loadingFinished && !this.prepared) {
            throw new ParserException("Loading finished before preparation is complete.");
        }
    }

    @Override
    public void onLoadCanceled(Chunk chunk, long l2, long l3, boolean bl) {
        this.loadingChunk = null;
        LoadEventInfo loadEventInfo = new LoadEventInfo(chunk.loadTaskId, chunk.dataSpec, chunk.getUri(), chunk.getResponseHeaders(), l2, l3, chunk.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(chunk.loadTaskId);
        this.mediaSourceEventDispatcher.loadCanceled(loadEventInfo, chunk.type, this.trackType, chunk.trackFormat, chunk.trackSelectionReason, chunk.trackSelectionData, chunk.startTimeUs, chunk.endTimeUs);
        if (!bl) {
            if (this.isPendingReset() || this.enabledTrackGroupCount == 0) {
                this.resetSampleQueues();
            }
            if (this.enabledTrackGroupCount > 0) {
                this.callback.onContinueLoadingRequested(this);
            }
        }
    }

    @Override
    public void onLoadCompleted(Chunk chunk, long l2, long l3) {
        this.loadingChunk = null;
        this.chunkSource.onChunkLoadCompleted(chunk);
        LoadEventInfo loadEventInfo = new LoadEventInfo(chunk.loadTaskId, chunk.dataSpec, chunk.getUri(), chunk.getResponseHeaders(), l2, l3, chunk.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(chunk.loadTaskId);
        this.mediaSourceEventDispatcher.loadCompleted(loadEventInfo, chunk.type, this.trackType, chunk.trackFormat, chunk.trackSelectionReason, chunk.trackSelectionData, chunk.startTimeUs, chunk.endTimeUs);
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        } else {
            this.callback.onContinueLoadingRequested(this);
        }
    }

    @Override
    public Loader.LoadErrorAction onLoadError(Chunk chunk, long l2, long l3, IOException iOException, int n2) {
        int n3;
        boolean bl = HlsSampleStreamWrapper.isMediaChunk(chunk);
        if (bl && !((HlsMediaChunk)chunk).isPublished() && iOException instanceof HttpDataSource.InvalidResponseCodeException && ((n3 = ((HttpDataSource.InvalidResponseCodeException)iOException).responseCode) == 410 || n3 == 404)) {
            return Loader.RETRY;
        }
        long l4 = chunk.bytesLoaded();
        LoadEventInfo loadEventInfo = new LoadEventInfo(chunk.loadTaskId, chunk.dataSpec, chunk.getUri(), chunk.getResponseHeaders(), l2, l3, l4);
        Object object = new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, new MediaLoadData(chunk.type, this.trackType, chunk.trackFormat, chunk.trackSelectionReason, chunk.trackSelectionData, C.usToMs(chunk.startTimeUs), C.usToMs(chunk.endTimeUs)), iOException, n2);
        l2 = this.loadErrorHandlingPolicy.getBlacklistDurationMsFor((LoadErrorHandlingPolicy.LoadErrorInfo)object);
        boolean bl2 = false;
        boolean bl3 = l2 != -9223372036854775807L ? this.chunkSource.maybeExcludeTrack(chunk, l2) : false;
        if (bl3) {
            if (bl && l4 == 0L) {
                object = this.mediaChunks;
                if ((HlsMediaChunk)((ArrayList)object).remove(((ArrayList)object).size() - 1) == chunk) {
                    bl2 = true;
                }
                Assertions.checkState(bl2);
                if (this.mediaChunks.isEmpty()) {
                    this.pendingResetPositionUs = this.lastSeekPositionUs;
                } else {
                    Iterables.getLast(this.mediaChunks).invalidateExtractor();
                }
            }
            object = Loader.DONT_RETRY;
        } else {
            l2 = this.loadErrorHandlingPolicy.getRetryDelayMsFor((LoadErrorHandlingPolicy.LoadErrorInfo)object);
            object = l2 != -9223372036854775807L ? Loader.createRetryAction(false, l2) : Loader.DONT_RETRY_FATAL;
        }
        bl2 = ((Loader.LoadErrorAction)object).isRetry() ^ true;
        this.mediaSourceEventDispatcher.loadError(loadEventInfo, chunk.type, this.trackType, chunk.trackFormat, chunk.trackSelectionReason, chunk.trackSelectionData, chunk.startTimeUs, chunk.endTimeUs, iOException, bl2);
        if (bl2) {
            this.loadingChunk = null;
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(chunk.loadTaskId);
        }
        if (bl3) {
            if (!this.prepared) {
                this.continueLoading(this.lastSeekPositionUs);
            } else {
                this.callback.onContinueLoadingRequested(this);
            }
        }
        return object;
    }

    @Override
    public void onLoaderReleased() {
        HlsSampleQueue[] hlsSampleQueueArray = this.sampleQueues;
        int n2 = hlsSampleQueueArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            hlsSampleQueueArray[i2].release();
        }
    }

    public void onNewExtractor() {
        this.sampleQueueMappingDoneByType.clear();
    }

    public boolean onPlaylistError(Uri uri, long l2) {
        return this.chunkSource.onPlaylistError(uri, l2);
    }

    public void onPlaylistUpdated() {
        if (this.mediaChunks.isEmpty()) {
            return;
        }
        HlsMediaChunk hlsMediaChunk = Iterables.getLast(this.mediaChunks);
        int n2 = this.chunkSource.getChunkPublicationState(hlsMediaChunk);
        if (n2 == 1) {
            hlsMediaChunk.publish();
        } else if (n2 == 2 && !this.loadingFinished && this.loader.isLoading()) {
            this.loader.cancelLoading();
        }
    }

    @Override
    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    public void prepareWithMasterPlaylistInfo(TrackGroup[] handler, int n2, int ... object) {
        this.trackGroups = this.createTrackGroupArrayWithDrmInfo((TrackGroup[])handler);
        this.optionalTrackGroups = new HashSet<TrackGroup>();
        for (Object object2 : object) {
            this.optionalTrackGroups.add(this.trackGroups.get((int)object2));
        }
        this.primaryTrackGroupIndex = n2;
        handler = this.handler;
        Callback callback2 = this.callback;
        Objects.requireNonNull(callback2);
        handler.post((Runnable)new _$$Lambda$COgt3RAipLG3mXfQxbryzRjBpos(callback2));
        this.setIsPrepared();
    }

    public int readData(int n2, FormatHolder formatHolder, DecoderInputBuffer object, boolean bl) {
        HlsMediaChunk hlsMediaChunk;
        int n3;
        if (this.isPendingReset()) {
            return -3;
        }
        boolean bl2 = this.mediaChunks.isEmpty();
        int n4 = 0;
        if (!bl2) {
            for (n3 = 0; n3 < this.mediaChunks.size() - 1 && this.finishedReadingChunk(this.mediaChunks.get(n3)); ++n3) {
            }
            Util.removeRange(this.mediaChunks, 0, n3);
            hlsMediaChunk = this.mediaChunks.get(0);
            Format format = hlsMediaChunk.trackFormat;
            if (!format.equals((Object)this.downstreamTrackFormat)) {
                this.mediaSourceEventDispatcher.downstreamFormatChanged(this.trackType, format, hlsMediaChunk.trackSelectionReason, hlsMediaChunk.trackSelectionData, hlsMediaChunk.startTimeUs);
            }
            this.downstreamTrackFormat = format;
        }
        if (!this.mediaChunks.isEmpty() && !this.mediaChunks.get(0).isPublished()) {
            return -3;
        }
        n3 = this.sampleQueues[n2].read(formatHolder, (DecoderInputBuffer)object, bl, this.loadingFinished);
        if (n3 == -5) {
            hlsMediaChunk = Assertions.checkNotNull(formatHolder.format);
            object = hlsMediaChunk;
            if (n2 == this.primarySampleQueueIndex) {
                int n5 = this.sampleQueues[n2].peekSourceId();
                for (n2 = n4; n2 < this.mediaChunks.size() && this.mediaChunks.get((int)n2).uid != n5; ++n2) {
                }
                object = n2 < this.mediaChunks.size() ? this.mediaChunks.get((int)n2).trackFormat : Assertions.checkNotNull(this.upstreamTrackFormat);
                object = hlsMediaChunk.withManifestFormatInfo((Format)object);
            }
            formatHolder.format = object;
        }
        return n3;
    }

    @Override
    public void reevaluateBuffer(long l2) {
        if (!this.loader.hasFatalError() && !this.isPendingReset()) {
            int n2;
            if (this.loader.isLoading()) {
                Assertions.checkNotNull(this.loadingChunk);
                if (this.chunkSource.shouldCancelLoad(l2, this.loadingChunk, this.readOnlyMediaChunks)) {
                    this.loader.cancelLoading();
                }
                return;
            }
            for (n2 = this.readOnlyMediaChunks.size(); n2 > 0 && this.chunkSource.getChunkPublicationState(this.readOnlyMediaChunks.get(n2 - 1)) == 2; --n2) {
            }
            if (n2 < this.readOnlyMediaChunks.size()) {
                this.discardUpstream(n2);
            }
            if ((n2 = this.chunkSource.getPreferredQueueSize(l2, this.readOnlyMediaChunks)) < this.mediaChunks.size()) {
                this.discardUpstream(n2);
            }
        }
    }

    public void release() {
        if (this.prepared) {
            HlsSampleQueue[] hlsSampleQueueArray = this.sampleQueues;
            int n2 = hlsSampleQueueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                hlsSampleQueueArray[i2].preRelease();
            }
        }
        this.loader.release(this);
        this.handler.removeCallbacksAndMessages(null);
        this.released = true;
        this.hlsSampleStreams.clear();
    }

    @Override
    public void seekMap(SeekMap seekMap) {
    }

    public boolean seekToUs(long l2, boolean bl) {
        this.lastSeekPositionUs = l2;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = l2;
            return true;
        }
        boolean bl2 = this.sampleQueuesBuilt;
        if (bl2 && !bl && this.seekInsideBufferUs(l2)) {
            return false;
        }
        this.pendingResetPositionUs = l2;
        this.loadingFinished = false;
        this.mediaChunks.clear();
        if (this.loader.isLoading()) {
            if (this.sampleQueuesBuilt) {
                HlsSampleQueue[] hlsSampleQueueArray = this.sampleQueues;
                int n2 = hlsSampleQueueArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hlsSampleQueueArray[i2].discardToEnd();
                }
            }
            this.loader.cancelLoading();
        } else {
            this.loader.clearFatalError();
            this.resetSampleQueues();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean selectTracks(ExoTrackSelection[] var1_1, boolean[] var2_2, SampleStream[] var3_3, boolean[] var4_4, long var5_5, boolean var7_6) {
        block22: {
            block23: {
                block21: {
                    this.assertIsPrepared();
                    var8_7 = this.enabledTrackGroupCount;
                    var9_8 = 0;
                    var10_9 = 0;
                    for (var11_10 = 0; var11_10 < var1_1 /* !! */ .length; ++var11_10) {
                        var12_11 /* !! */  = (HlsSampleStream)var3_3[var11_10];
                        if (var12_11 /* !! */  == null || var1_1 /* !! */ [var11_10] != null && var2_2 /* !! */ [var11_10]) continue;
                        --this.enabledTrackGroupCount;
                        var12_11 /* !! */ .unbindSampleQueue();
                        var3_3[var11_10] = null;
                    }
                    var13_12 = var7_6 || (this.seenFirstTrackSelection != false ? var8_7 == 0 : var5_5 != this.lastSeekPositionUs);
                    var14_13 = this.chunkSource.getTrackSelection();
                    var2_2 /* !! */  = (boolean[])var14_13;
                    for (var11_10 = 0; var11_10 < var1_1 /* !! */ .length; ++var11_10) {
                        var12_11 /* !! */  = var1_1 /* !! */ [var11_10];
                        if (var12_11 /* !! */  == null) {
                            var12_11 /* !! */  = (HlsSampleStream)var2_2 /* !! */ ;
                            var15_14 = var13_12;
                        } else {
                            var8_7 = this.trackGroups.indexOf(var12_11 /* !! */ .getTrackGroup());
                            if (var8_7 == this.primaryTrackGroupIndex) {
                                this.chunkSource.setTrackSelection((ExoTrackSelection)var12_11 /* !! */ );
                                var2_2 /* !! */  = (boolean[])var12_11 /* !! */ ;
                            }
                            var12_11 /* !! */  = (HlsSampleStream)var2_2 /* !! */ ;
                            var15_14 = var13_12;
                            if (var3_3[var11_10] == null) {
                                ++this.enabledTrackGroupCount;
                                var3_3[var11_10] = new HlsSampleStream(this, var8_7);
                                var4_4[var11_10] = true;
                                var12_11 /* !! */  = (HlsSampleStream)var2_2 /* !! */ ;
                                var15_14 = var13_12;
                                if (this.trackGroupToSampleQueueIndex != null) {
                                    ((HlsSampleStream)var3_3[var11_10]).bindSampleQueue();
                                    var12_11 /* !! */  = (HlsSampleStream)var2_2 /* !! */ ;
                                    var15_14 = var13_12;
                                    if (!var13_12) {
                                        var12_11 /* !! */  = this.sampleQueues[this.trackGroupToSampleQueueIndex[var8_7]];
                                        if (!var12_11 /* !! */ .seekTo(var5_5, true) && var12_11 /* !! */ .getReadIndex() != 0) {
                                            var15_14 = true;
                                            var12_11 /* !! */  = (HlsSampleStream)var2_2 /* !! */ ;
                                        } else {
                                            var15_14 = false;
                                            var12_11 /* !! */  = (HlsSampleStream)var2_2 /* !! */ ;
                                        }
                                    }
                                }
                            }
                        }
                        var2_2 /* !! */  = (boolean[])var12_11 /* !! */ ;
                        var13_12 = var15_14;
                    }
                    if (this.enabledTrackGroupCount != 0) break block21;
                    this.chunkSource.reset();
                    this.downstreamTrackFormat = null;
                    this.pendingResetUpstreamFormats = true;
                    this.mediaChunks.clear();
                    if (this.loader.isLoading()) {
                        if (this.sampleQueuesBuilt) {
                            var1_1 /* !! */  = this.sampleQueues;
                            var9_8 = var1_1 /* !! */ .length;
                            for (var11_10 = var10_9; var11_10 < var9_8; ++var11_10) {
                                var1_1 /* !! */ [var11_10].discardToEnd();
                            }
                        }
                        this.loader.cancelLoading();
                        var15_14 = var13_12;
                    } else {
                        this.resetSampleQueues();
                        var15_14 = var13_12;
                    }
                    break block22;
                }
                if (this.mediaChunks.isEmpty() || Util.areEqual(var2_2 /* !! */ , var14_13)) break block23;
                if (this.seenFirstTrackSelection) ** GOTO lbl-1000
                var16_15 = 0L;
                if (var5_5 < 0L) {
                    var16_15 = -var5_5;
                }
                var12_11 /* !! */  = this.getLastMediaChunk();
                var1_1 /* !! */  = this.chunkSource.createMediaChunkIterators((HlsMediaChunk)var12_11 /* !! */ , var5_5);
                var2_2 /* !! */ .updateSelectedTrack(var5_5, var16_15, -9223372036854775807L, this.readOnlyMediaChunks, (MediaChunkIterator[])var1_1 /* !! */ );
                var11_10 = this.chunkSource.getTrackGroup().indexOf(var12_11 /* !! */ .trackFormat);
                if (var2_2 /* !! */ .getSelectedIndexInTrackGroup() == var11_10) {
                    var11_10 = 0;
                } else lbl-1000:
                // 2 sources

                {
                    var11_10 = 1;
                }
                if (var11_10 != 0) {
                    this.pendingResetUpstreamFormats = true;
                    var7_6 = true;
                    var13_12 = true;
                }
            }
            var15_14 = var13_12;
            if (var13_12) {
                this.seekToUs(var5_5, var7_6);
                var11_10 = var9_8;
                while (true) {
                    var15_14 = var13_12;
                    if (var11_10 >= var3_3.length) break;
                    if (var3_3[var11_10] != null) {
                        var4_4[var11_10] = true;
                    }
                    ++var11_10;
                }
            }
        }
        this.updateSampleStreams(var3_3);
        this.seenFirstTrackSelection = true;
        return var15_14;
    }

    public void setDrmInitData(DrmInitData drmInitData) {
        if (!Util.areEqual(this.drmInitData, drmInitData)) {
            HlsSampleQueue[] hlsSampleQueueArray;
            this.drmInitData = drmInitData;
            for (int i2 = 0; i2 < (hlsSampleQueueArray = this.sampleQueues).length; ++i2) {
                if (!this.sampleQueueIsAudioVideoFlags[i2]) continue;
                hlsSampleQueueArray[i2].setDrmInitData(drmInitData);
            }
        }
    }

    public void setIsTimestampMaster(boolean bl) {
        this.chunkSource.setIsTimestampMaster(bl);
    }

    public void setSampleOffsetUs(long l2) {
        if (this.sampleOffsetUs != l2) {
            this.sampleOffsetUs = l2;
            HlsSampleQueue[] hlsSampleQueueArray = this.sampleQueues;
            int n2 = hlsSampleQueueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                hlsSampleQueueArray[i2].setSampleOffsetUs(l2);
            }
        }
    }

    public int skipData(int n2, long l2) {
        int n3;
        boolean bl = this.isPendingReset();
        int n4 = 0;
        if (bl) {
            return 0;
        }
        HlsSampleQueue hlsSampleQueue = this.sampleQueues[n2];
        int n5 = hlsSampleQueue.getSkipCount(l2, this.loadingFinished);
        int n6 = hlsSampleQueue.getReadIndex();
        while (true) {
            n3 = n5;
            if (n4 >= this.mediaChunks.size()) break;
            HlsMediaChunk hlsMediaChunk = this.mediaChunks.get(n4);
            n3 = this.mediaChunks.get(n4).getFirstSampleIndex(n2);
            if (n6 + n5 <= n3) {
                n3 = n5;
                break;
            }
            if (!hlsMediaChunk.isPublished()) {
                n3 -= n6;
                break;
            }
            ++n4;
        }
        hlsSampleQueue.skip(n3);
        return n3;
    }

    @Override
    public TrackOutput track(int n2, int n3) {
        Object object;
        block7: {
            if (MAPPABLE_TYPES.contains(n3)) {
                object = this.getMappedTrackOutput(n2, n3);
            } else {
                for (int i2 = 0; i2 < ((HlsSampleQueue[])(object = this.sampleQueues)).length; ++i2) {
                    if (this.sampleQueueTrackIds[i2] != n2) continue;
                    object = object[i2];
                    break block7;
                }
                object = null;
            }
        }
        Object object2 = object;
        if (object == null) {
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createFakeTrackOutput(n2, n3);
            }
            object2 = this.createSampleQueue(n2, n3);
        }
        if (n3 == 5) {
            if (this.emsgUnwrappingTrackOutput == null) {
                this.emsgUnwrappingTrackOutput = new EmsgUnwrappingTrackOutput((TrackOutput)object2, this.metadataType);
            }
            return this.emsgUnwrappingTrackOutput;
        }
        return object2;
    }

    public void unbindSampleQueue(int n2) {
        this.assertIsPrepared();
        Assertions.checkNotNull(this.trackGroupToSampleQueueIndex);
        n2 = this.trackGroupToSampleQueueIndex[n2];
        Assertions.checkState(this.sampleQueuesEnabledStates[n2]);
        this.sampleQueuesEnabledStates[n2] = false;
    }

    public static interface Callback
    extends SequenceableLoader.Callback<HlsSampleStreamWrapper> {
        public void onPlaylistRefreshRequired(Uri var1);

        public void onPrepared();
    }

    private static class EmsgUnwrappingTrackOutput
    implements TrackOutput {
        private static final Format EMSG_FORMAT;
        private static final Format ID3_FORMAT;
        private static final String TAG = "EmsgUnwrappingTrackOutput";
        private byte[] buffer;
        private int bufferPosition;
        private final TrackOutput delegate;
        private final Format delegateFormat;
        private final EventMessageDecoder emsgDecoder = new EventMessageDecoder();
        private Format format;

        static {
            ID3_FORMAT = new Format.Builder().setSampleMimeType("application/id3").build();
            EMSG_FORMAT = new Format.Builder().setSampleMimeType("application/x-emsg").build();
        }

        /*
         * Enabled aggressive block sorting
         */
        public EmsgUnwrappingTrackOutput(TrackOutput object, int n2) {
            this.delegate = object;
            if (n2 != 1) {
                if (n2 != 3) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unknown metadataType: ");
                    ((StringBuilder)object).append(n2);
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                this.delegateFormat = EMSG_FORMAT;
            } else {
                this.delegateFormat = ID3_FORMAT;
            }
            this.buffer = new byte[0];
            this.bufferPosition = 0;
        }

        private boolean emsgContainsExpectedWrappedFormat(EventMessage eventMessage) {
            boolean bl = (eventMessage = eventMessage.getWrappedMetadataFormat()) != null && Util.areEqual(this.delegateFormat.sampleMimeType, eventMessage.sampleMimeType);
            return bl;
        }

        private void ensureBufferCapacity(int n2) {
            byte[] byArray = this.buffer;
            if (byArray.length < n2) {
                this.buffer = Arrays.copyOf(byArray, n2 + n2 / 2);
            }
        }

        private ParsableByteArray getSampleAndTrimBuffer(int n2, int n3) {
            int n4 = this.bufferPosition - n3;
            ParsableByteArray parsableByteArray = new ParsableByteArray(Arrays.copyOfRange(this.buffer, n4 - n2, n4));
            byte[] byArray = this.buffer;
            System.arraycopy(byArray, n4, byArray, 0, n3);
            this.bufferPosition = n3;
            return parsableByteArray;
        }

        @Override
        public void format(Format format) {
            this.format = format;
            this.delegate.format(this.delegateFormat);
        }

        @Override
        public /* synthetic */ int sampleData(DataReader dataReader, int n2, boolean bl) throws IOException {
            return TrackOutput._CC.$default$sampleData((TrackOutput)this, (DataReader)dataReader, (int)n2, (boolean)bl);
        }

        @Override
        public int sampleData(DataReader dataReader, int n2, boolean bl, int n3) throws IOException {
            this.ensureBufferCapacity(this.bufferPosition + n2);
            n2 = dataReader.read(this.buffer, this.bufferPosition, n2);
            if (n2 == -1) {
                if (bl) {
                    return -1;
                }
                throw new EOFException();
            }
            this.bufferPosition += n2;
            return n2;
        }

        @Override
        public /* synthetic */ void sampleData(ParsableByteArray parsableByteArray, int n2) {
            TrackOutput._CC.$default$sampleData((TrackOutput)this, (ParsableByteArray)parsableByteArray, (int)n2);
        }

        @Override
        public void sampleData(ParsableByteArray parsableByteArray, int n2, int n3) {
            this.ensureBufferCapacity(this.bufferPosition + n2);
            parsableByteArray.readBytes(this.buffer, this.bufferPosition, n2);
            this.bufferPosition += n2;
        }

        @Override
        public void sampleMetadata(long l2, int n2, int n3, int n4, TrackOutput.CryptoData object) {
            block5: {
                ParsableByteArray parsableByteArray;
                block4: {
                    Assertions.checkNotNull(this.format);
                    parsableByteArray = this.getSampleAndTrimBuffer(n3, n4);
                    if (Util.areEqual(this.format.sampleMimeType, this.delegateFormat.sampleMimeType)) break block4;
                    if (!"application/x-emsg".equals(this.format.sampleMimeType)) break block5;
                    if (!this.emsgContainsExpectedWrappedFormat((EventMessage)(parsableByteArray = this.emsgDecoder.decode(parsableByteArray)))) {
                        Log.w(TAG, String.format("Ignoring EMSG. Expected it to contain wrapped %s but actual wrapped format: %s", this.delegateFormat.sampleMimeType, parsableByteArray.getWrappedMetadataFormat()));
                        return;
                    }
                    parsableByteArray = new ParsableByteArray(Assertions.checkNotNull(parsableByteArray.getWrappedMetadataBytes()));
                }
                n3 = parsableByteArray.bytesLeft();
                this.delegate.sampleData(parsableByteArray, n3);
                this.delegate.sampleMetadata(l2, n2, n3, n4, (TrackOutput.CryptoData)object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Ignoring sample for unsupported format: ");
            ((StringBuilder)object).append(this.format.sampleMimeType);
            Log.w(TAG, ((StringBuilder)object).toString());
        }
    }

    private static final class HlsSampleQueue
    extends SampleQueue {
        private DrmInitData drmInitData;
        private final Map<String, DrmInitData> overridingDrmInitData;

        private HlsSampleQueue(Allocator allocator, Looper looper, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher, Map<String, DrmInitData> map) {
            super(allocator, looper, drmSessionManager, eventDispatcher);
            this.overridingDrmInitData = map;
        }

        private Metadata getAdjustedMetadata(Metadata metadata) {
            int n2;
            Metadata.Entry[] entryArray;
            int n3;
            int n4;
            int n5;
            block5: {
                if (metadata == null) {
                    return null;
                }
                n5 = metadata.length();
                n4 = 0;
                for (n3 = 0; n3 < n5; ++n3) {
                    entryArray = metadata.get(n3);
                    if (!(entryArray instanceof PrivFrame) || !"com.apple.streaming.transportStreamTimestamp".equals(((PrivFrame)entryArray).owner)) continue;
                    n2 = n3;
                    break block5;
                }
                n2 = -1;
            }
            if (n2 == -1) {
                return metadata;
            }
            if (n5 == 1) {
                return null;
            }
            entryArray = new Metadata.Entry[n5 - 1];
            for (n3 = n4; n3 < n5; ++n3) {
                if (n3 == n2) continue;
                n4 = n3 < n2 ? n3 : n3 - 1;
                entryArray[n4] = metadata.get(n3);
            }
            return new Metadata(entryArray);
        }

        @Override
        public Format getAdjustedUpstreamFormat(Format format) {
            DrmInitData drmInitData;
            block7: {
                Metadata metadata;
                DrmInitData drmInitData2;
                block6: {
                    drmInitData = this.drmInitData;
                    if (drmInitData == null) {
                        drmInitData = format.drmInitData;
                    }
                    drmInitData2 = drmInitData;
                    if (drmInitData != null) {
                        metadata = this.overridingDrmInitData.get(drmInitData.schemeType);
                        drmInitData2 = drmInitData;
                        if (metadata != null) {
                            drmInitData2 = metadata;
                        }
                    }
                    metadata = this.getAdjustedMetadata(format.metadata);
                    if (drmInitData2 != format.drmInitData) break block6;
                    drmInitData = format;
                    if (metadata == format.metadata) break block7;
                }
                drmInitData = format.buildUpon().setDrmInitData(drmInitData2).setMetadata(metadata).build();
            }
            return super.getAdjustedUpstreamFormat((Format)drmInitData);
        }

        @Override
        public void sampleMetadata(long l2, int n2, int n3, int n4, TrackOutput.CryptoData cryptoData) {
            super.sampleMetadata(l2, n2, n3, n4, cryptoData);
        }

        public void setDrmInitData(DrmInitData drmInitData) {
            this.drmInitData = drmInitData;
            this.invalidateUpstreamFormatAdjustment();
        }

        public void setSourceChunk(HlsMediaChunk hlsMediaChunk) {
            this.sourceId(hlsMediaChunk.uid);
        }
    }
}

