/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManagerProvider;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.hls.DefaultHlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsManifest;
import com.google.android.exoplayer2.source.hls.HlsMediaPeriod;
import com.google.android.exoplayer2.source.hls._$;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistTracker;
import com.google.android.exoplayer2.source.hls.playlist.FilteringHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

public final class HlsMediaSource
extends BaseMediaSource
implements HlsPlaylistTracker.PrimaryPlaylistListener {
    public static final int METADATA_TYPE_EMSG = 3;
    public static final int METADATA_TYPE_ID3 = 1;
    private final boolean allowChunklessPreparation;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final HlsDataSourceFactory dataSourceFactory;
    private final DrmSessionManager drmSessionManager;
    private final long elapsedRealTimeOffsetMs;
    private final HlsExtractorFactory extractorFactory;
    private MediaItem.LiveConfiguration liveConfiguration;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaItem mediaItem;
    private TransferListener mediaTransferListener;
    private final int metadataType;
    private final MediaItem.PlaybackProperties playbackProperties;
    private final HlsPlaylistTracker playlistTracker;
    private final boolean useSessionKeys;

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.hls");
    }

    private HlsMediaSource(MediaItem mediaItem, HlsDataSourceFactory hlsDataSourceFactory, HlsExtractorFactory hlsExtractorFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistTracker hlsPlaylistTracker, long l2, boolean bl, int n2, boolean bl2) {
        this.playbackProperties = Assertions.checkNotNull(mediaItem.playbackProperties);
        this.mediaItem = mediaItem;
        this.liveConfiguration = mediaItem.liveConfiguration;
        this.dataSourceFactory = hlsDataSourceFactory;
        this.extractorFactory = hlsExtractorFactory;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playlistTracker = hlsPlaylistTracker;
        this.elapsedRealTimeOffsetMs = l2;
        this.allowChunklessPreparation = bl;
        this.metadataType = n2;
        this.useSessionKeys = bl2;
    }

    private long getLiveEdgeOffsetUs(HlsMediaPlaylist hlsMediaPlaylist) {
        long l2 = hlsMediaPlaylist.hasProgramDateTime ? C.msToUs(Util.getNowUnixTimeMs(this.elapsedRealTimeOffsetMs)) - hlsMediaPlaylist.getEndTimeUs() : 0L;
        return l2;
    }

    private static long getTargetLiveOffsetUs(HlsMediaPlaylist hlsMediaPlaylist, long l2) {
        HlsMediaPlaylist.ServerControl serverControl = hlsMediaPlaylist.serverControl;
        long l3 = hlsMediaPlaylist.startOffsetUs != -9223372036854775807L ? hlsMediaPlaylist.durationUs - hlsMediaPlaylist.startOffsetUs : (serverControl.partHoldBackUs != -9223372036854775807L && hlsMediaPlaylist.partTargetDurationUs != -9223372036854775807L ? serverControl.partHoldBackUs : (serverControl.holdBackUs != -9223372036854775807L ? serverControl.holdBackUs : 3L * hlsMediaPlaylist.targetDurationUs));
        return l3 + l2;
    }

    private long getWindowDefaultStartPosition(HlsMediaPlaylist hlsMediaPlaylist, long l2) {
        int n2;
        List<HlsMediaPlaylist.Segment> list = hlsMediaPlaylist.segments;
        long l3 = hlsMediaPlaylist.durationUs;
        long l4 = C.msToUs(this.liveConfiguration.targetOffsetMs);
        for (n2 = list.size() - 1; n2 > 0 && list.get((int)n2).relativeStartTimeUs > l3 + l2 - l4; --n2) {
        }
        return list.get((int)n2).relativeStartTimeUs;
    }

    private void maybeUpdateMediaItem(long l2) {
        if ((l2 = C.usToMs(l2)) != this.liveConfiguration.targetOffsetMs) {
            this.liveConfiguration = this.mediaItem.buildUpon().setLiveTargetOffsetMs((long)l2).build().liveConfiguration;
        }
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId object, Allocator allocator, long l2) {
        MediaSourceEventListener.EventDispatcher eventDispatcher = this.createEventDispatcher((MediaSource.MediaPeriodId)((Object)object));
        object = this.createDrmEventDispatcher((MediaSource.MediaPeriodId)((Object)object));
        return new HlsMediaPeriod(this.extractorFactory, this.playlistTracker, this.dataSourceFactory, this.mediaTransferListener, this.drmSessionManager, (DrmSessionEventListener.EventDispatcher)object, this.loadErrorHandlingPolicy, eventDispatcher, allocator, this.compositeSequenceableLoaderFactory, this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    @Deprecated
    public Object getTag() {
        return this.playbackProperties.tag;
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.playlistTracker.maybeThrowPrimaryPlaylistRefreshError();
    }

    public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist hlsMediaPlaylist) {
        long l2 = hlsMediaPlaylist.hasProgramDateTime ? C.usToMs(hlsMediaPlaylist.startTimeUs) : -9223372036854775807L;
        long l3 = hlsMediaPlaylist.playlistType != 2 && hlsMediaPlaylist.playlistType != 1 ? -9223372036854775807L : l2;
        long l4 = hlsMediaPlaylist.startOffsetUs;
        HlsManifest hlsManifest = new HlsManifest(Assertions.checkNotNull(this.playlistTracker.getMasterPlaylist()), hlsMediaPlaylist);
        if (this.playlistTracker.isLive()) {
            long l5 = this.getLiveEdgeOffsetUs(hlsMediaPlaylist);
            long l6 = this.liveConfiguration.targetOffsetMs != -9223372036854775807L ? C.msToUs(this.liveConfiguration.targetOffsetMs) : HlsMediaSource.getTargetLiveOffsetUs(hlsMediaPlaylist, l5);
            this.maybeUpdateMediaItem(Util.constrainValue(l6, l5, hlsMediaPlaylist.durationUs + l5));
            long l7 = hlsMediaPlaylist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            l6 = hlsMediaPlaylist.hasEndTag ? l7 + hlsMediaPlaylist.durationUs : -9223372036854775807L;
            if (!hlsMediaPlaylist.segments.isEmpty()) {
                l4 = this.getWindowDefaultStartPosition(hlsMediaPlaylist, l5);
            } else if (l4 == -9223372036854775807L) {
                l4 = 0L;
            }
            hlsMediaPlaylist = new SinglePeriodTimeline(l3, l2, -9223372036854775807L, l6, hlsMediaPlaylist.durationUs, l7, l4, true, hlsMediaPlaylist.hasEndTag ^ true, (Object)hlsManifest, this.mediaItem, this.liveConfiguration);
        } else {
            if (l4 == -9223372036854775807L) {
                l4 = 0L;
            }
            hlsMediaPlaylist = new SinglePeriodTimeline(l3, l2, -9223372036854775807L, hlsMediaPlaylist.durationUs, hlsMediaPlaylist.durationUs, 0L, l4, true, false, (Object)hlsManifest, this.mediaItem, null);
        }
        this.refreshSourceInfo((Timeline)hlsMediaPlaylist);
    }

    @Override
    protected void prepareSourceInternal(TransferListener object) {
        this.mediaTransferListener = object;
        this.drmSessionManager.prepare();
        object = this.createEventDispatcher(null);
        this.playlistTracker.start(this.playbackProperties.uri, (MediaSourceEventListener.EventDispatcher)object, (HlsPlaylistTracker.PrimaryPlaylistListener)this);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((HlsMediaPeriod)mediaPeriod).release();
    }

    @Override
    protected void releaseSourceInternal() {
        this.playlistTracker.stop();
        this.drmSessionManager.release();
    }

    public static final class Factory
    implements MediaSourceFactory {
        private boolean allowChunklessPreparation;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        private DrmSessionManagerProvider drmSessionManagerProvider;
        private long elapsedRealTimeOffsetMs;
        private HlsExtractorFactory extractorFactory;
        private final HlsDataSourceFactory hlsDataSourceFactory;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private int metadataType;
        private HlsPlaylistParserFactory playlistParserFactory;
        private HlsPlaylistTracker.Factory playlistTrackerFactory;
        private List<StreamKey> streamKeys;
        private Object tag;
        private boolean useSessionKeys;
        private boolean usingCustomDrmSessionManagerProvider;

        public Factory(HlsDataSourceFactory hlsDataSourceFactory) {
            this.hlsDataSourceFactory = Assertions.checkNotNull(hlsDataSourceFactory);
            this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
            this.playlistParserFactory = new DefaultHlsPlaylistParserFactory();
            this.playlistTrackerFactory = DefaultHlsPlaylistTracker.FACTORY;
            this.extractorFactory = HlsExtractorFactory.DEFAULT;
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.metadataType = 1;
            this.streamKeys = Collections.emptyList();
            this.elapsedRealTimeOffsetMs = -9223372036854775807L;
        }

        public Factory(DataSource.Factory factory) {
            this(new DefaultHlsDataSourceFactory(factory));
        }

        static /* synthetic */ DrmSessionManager lambda$setDrmSessionManager$0(DrmSessionManager drmSessionManager, MediaItem mediaItem) {
            return drmSessionManager;
        }

        @Deprecated
        public HlsMediaSource createMediaSource(Uri uri) {
            return this.createMediaSource(new MediaItem.Builder().setUri(uri).setMimeType("application/x-mpegURL").build());
        }

        public HlsMediaSource createMediaSource(MediaItem mediaItem) {
            MediaItem mediaItem2 = mediaItem;
            Assertions.checkNotNull(mediaItem2.playbackProperties);
            Object object = this.playlistParserFactory;
            List list = mediaItem2.playbackProperties.streamKeys.isEmpty() ? this.streamKeys : mediaItem2.playbackProperties.streamKeys;
            HlsPlaylistParserFactory hlsPlaylistParserFactory = object;
            if (!list.isEmpty()) {
                hlsPlaylistParserFactory = new FilteringHlsPlaylistParserFactory(object, list);
            }
            object = mediaItem2.playbackProperties.tag;
            boolean bl = true;
            boolean bl2 = object == null && this.tag != null;
            if (!mediaItem2.playbackProperties.streamKeys.isEmpty() || list.isEmpty()) {
                bl = false;
            }
            if (bl2 && bl) {
                mediaItem2 = mediaItem.buildUpon().setTag(this.tag).setStreamKeys(list).build();
            } else if (bl2) {
                mediaItem2 = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (bl) {
                mediaItem2 = mediaItem.buildUpon().setStreamKeys(list).build();
            }
            object = this.hlsDataSourceFactory;
            HlsExtractorFactory hlsExtractorFactory = this.extractorFactory;
            mediaItem = this.compositeSequenceableLoaderFactory;
            DrmSessionManager drmSessionManager = this.drmSessionManagerProvider.get(mediaItem2);
            list = this.loadErrorHandlingPolicy;
            return new HlsMediaSource(mediaItem2, (HlsDataSourceFactory)object, hlsExtractorFactory, (CompositeSequenceableLoaderFactory)mediaItem, drmSessionManager, (LoadErrorHandlingPolicy)list, this.playlistTrackerFactory.createTracker(this.hlsDataSourceFactory, (LoadErrorHandlingPolicy)list, hlsPlaylistParserFactory), this.elapsedRealTimeOffsetMs, this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
        }

        public int[] getSupportedTypes() {
            return new int[]{2};
        }

        public Factory setAllowChunklessPreparation(boolean bl) {
            this.allowChunklessPreparation = bl;
            return this;
        }

        public Factory setCompositeSequenceableLoaderFactory(CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            if (compositeSequenceableLoaderFactory == null) {
                compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            }
            this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
            return this;
        }

        public Factory setDrmHttpDataSourceFactory(HttpDataSource.Factory factory) {
            if (!this.usingCustomDrmSessionManagerProvider) {
                ((DefaultDrmSessionManagerProvider)this.drmSessionManagerProvider).setDrmHttpDataSourceFactory(factory);
            }
            return this;
        }

        public Factory setDrmSessionManager(DrmSessionManager drmSessionManager) {
            if (drmSessionManager == null) {
                this.setDrmSessionManagerProvider(null);
            } else {
                this.setDrmSessionManagerProvider((DrmSessionManagerProvider)new _$.Lambda.HlsMediaSource.Factory.dV8luI1FqT6CJsT7GDRKpBcyOgE(drmSessionManager));
            }
            return this;
        }

        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
            if (drmSessionManagerProvider != null) {
                this.drmSessionManagerProvider = drmSessionManagerProvider;
                this.usingCustomDrmSessionManagerProvider = true;
            } else {
                this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
                this.usingCustomDrmSessionManagerProvider = false;
            }
            return this;
        }

        public Factory setDrmUserAgent(String string2) {
            if (!this.usingCustomDrmSessionManagerProvider) {
                ((DefaultDrmSessionManagerProvider)this.drmSessionManagerProvider).setDrmUserAgent(string2);
            }
            return this;
        }

        Factory setElapsedRealTimeOffsetMs(long l2) {
            this.elapsedRealTimeOffsetMs = l2;
            return this;
        }

        public Factory setExtractorFactory(HlsExtractorFactory hlsExtractorFactory) {
            if (hlsExtractorFactory == null) {
                hlsExtractorFactory = HlsExtractorFactory.DEFAULT;
            }
            this.extractorFactory = hlsExtractorFactory;
            return this;
        }

        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            if (loadErrorHandlingPolicy == null) {
                loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            }
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
            return this;
        }

        public Factory setMetadataType(int n2) {
            this.metadataType = n2;
            return this;
        }

        public Factory setPlaylistParserFactory(HlsPlaylistParserFactory hlsPlaylistParserFactory) {
            if (hlsPlaylistParserFactory == null) {
                hlsPlaylistParserFactory = new DefaultHlsPlaylistParserFactory();
            }
            this.playlistParserFactory = hlsPlaylistParserFactory;
            return this;
        }

        public Factory setPlaylistTrackerFactory(HlsPlaylistTracker.Factory factory) {
            if (factory == null) {
                factory = DefaultHlsPlaylistTracker.FACTORY;
            }
            this.playlistTrackerFactory = factory;
            return this;
        }

        @Deprecated
        public Factory setStreamKeys(List<StreamKey> list) {
            if (list == null) {
                list = Collections.emptyList();
            }
            this.streamKeys = list;
            return this;
        }

        @Deprecated
        public Factory setTag(Object object) {
            this.tag = object;
            return this;
        }

        public Factory setUseSessionKeys(boolean bl) {
            this.useSessionKeys = bl;
            return this;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetadataType {
    }
}

