/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.hls.Aes128DataSource;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsMediaChunkExtractor;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class HlsMediaChunk
extends MediaChunk {
    public static final String PRIV_TIMESTAMP_FRAME_OWNER = "com.apple.streaming.transportStreamTimestamp";
    private static final AtomicInteger uidSource = new AtomicInteger();
    public final int discontinuitySequenceNumber;
    private final DrmInitData drmInitData;
    private HlsMediaChunkExtractor extractor;
    private final HlsExtractorFactory extractorFactory;
    private boolean extractorInvalidated;
    private final boolean hasGapTag;
    private final Id3Decoder id3Decoder;
    private boolean initDataLoadRequired;
    private final DataSource initDataSource;
    private final DataSpec initDataSpec;
    private final boolean initSegmentEncrypted;
    private final boolean isMasterTimestampSource;
    private boolean isPublished;
    private volatile boolean loadCanceled;
    private boolean loadCompleted;
    private final boolean mediaSegmentEncrypted;
    private final List<Format> muxedCaptionFormats;
    private int nextLoadPosition;
    private HlsSampleStreamWrapper output;
    public final int partIndex;
    public final Uri playlistUrl;
    private final HlsMediaChunkExtractor previousExtractor;
    private ImmutableList<Integer> sampleQueueFirstSampleIndices;
    private final ParsableByteArray scratchId3Data;
    public final boolean shouldSpliceIn;
    private final TimestampAdjuster timestampAdjuster;
    public final int uid;

    private HlsMediaChunk(HlsExtractorFactory hlsExtractorFactory, DataSource dataSource, DataSpec dataSpec, Format format, boolean bl, DataSource dataSource2, DataSpec dataSpec2, boolean bl2, Uri uri, List<Format> list, int n2, Object object, long l2, long l3, long l4, int n3, boolean bl3, int n4, boolean bl4, boolean bl5, TimestampAdjuster timestampAdjuster, DrmInitData drmInitData, HlsMediaChunkExtractor hlsMediaChunkExtractor, Id3Decoder id3Decoder, ParsableByteArray parsableByteArray, boolean bl6) {
        super(dataSource, dataSpec, format, n2, object, l2, l3, l4);
        this.mediaSegmentEncrypted = bl;
        this.partIndex = n3;
        this.isPublished = bl3;
        this.discontinuitySequenceNumber = n4;
        this.initDataSpec = dataSpec2;
        this.initDataSource = dataSource2;
        bl = dataSpec2 != null;
        this.initDataLoadRequired = bl;
        this.initSegmentEncrypted = bl2;
        this.playlistUrl = uri;
        this.isMasterTimestampSource = bl5;
        this.timestampAdjuster = timestampAdjuster;
        this.hasGapTag = bl4;
        this.extractorFactory = hlsExtractorFactory;
        this.muxedCaptionFormats = list;
        this.drmInitData = drmInitData;
        this.previousExtractor = hlsMediaChunkExtractor;
        this.id3Decoder = id3Decoder;
        this.scratchId3Data = parsableByteArray;
        this.shouldSpliceIn = bl6;
        this.sampleQueueFirstSampleIndices = ImmutableList.of();
        this.uid = uidSource.getAndIncrement();
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            Assertions.checkNotNull(byArray2);
            return new Aes128DataSource(dataSource, byArray, byArray2);
        }
        return dataSource;
    }

    public static HlsMediaChunk createInstance(HlsExtractorFactory hlsExtractorFactory, DataSource object, Format format, long l2, HlsMediaPlaylist hlsMediaPlaylist, HlsChunkSource.SegmentBaseHolder segmentBaseHolder, Uri uri, List<Format> list, int n2, Object object2, boolean bl, TimestampAdjusterProvider timestampAdjusterProvider, HlsMediaChunk object3, byte[] object4, byte[] object5) {
        boolean bl2;
        boolean bl3;
        HlsMediaPlaylist.SegmentBase segmentBase = segmentBaseHolder.segmentBase;
        Object object6 = new DataSpec.Builder().setUri(UriUtil.resolveToUri((String)hlsMediaPlaylist.baseUri, (String)segmentBase.url)).setPosition(segmentBase.byteRangeOffset).setLength(segmentBase.byteRangeLength);
        int n3 = segmentBaseHolder.isPreload ? 8 : 0;
        DataSpec dataSpec = ((DataSpec.Builder)object6).setFlags(n3).build();
        boolean bl4 = object4 != null;
        object6 = bl4 ? (Object)HlsMediaChunk.getEncryptionIvArray(Assertions.checkNotNull(segmentBase.encryptionIV)) : null;
        DataSource dataSource = HlsMediaChunk.buildDataSource(object, object4, (byte[])object6);
        object6 = segmentBase.initializationSegment;
        if (object6 != null) {
            bl3 = object5 != null;
            object4 = bl3 ? HlsMediaChunk.getEncryptionIvArray(Assertions.checkNotNull(((HlsMediaPlaylist.Segment)object6).encryptionIV)) : null;
            object6 = new DataSpec(UriUtil.resolveToUri((String)hlsMediaPlaylist.baseUri, (String)((HlsMediaPlaylist.Segment)object6).url), ((HlsMediaPlaylist.Segment)object6).byteRangeOffset, ((HlsMediaPlaylist.Segment)object6).byteRangeLength);
            object5 = HlsMediaChunk.buildDataSource(object, object5, object4);
            object4 = object6;
        } else {
            object5 = null;
            object4 = null;
            bl3 = false;
        }
        long l3 = l2 + segmentBase.relativeStartTimeUs;
        l2 = segmentBase.durationUs;
        int n4 = hlsMediaPlaylist.discontinuitySequence + segmentBase.relativeDiscontinuitySequence;
        if (object3 != null) {
            n3 = uri.equals((Object)((HlsMediaChunk)object3).playlistUrl) && ((HlsMediaChunk)object3).loadCompleted ? 1 : 0;
            Id3Decoder id3Decoder = ((HlsMediaChunk)object3).id3Decoder;
            object6 = ((HlsMediaChunk)object3).scratchId3Data;
            bl2 = HlsMediaChunk.isIndependent(segmentBaseHolder, hlsMediaPlaylist);
            boolean bl5 = n3 != 0 || bl2 && l3 >= ((HlsMediaChunk)object3).endTimeUs;
            object = n3 != 0 && !((HlsMediaChunk)object3).extractorInvalidated && ((HlsMediaChunk)object3).discontinuitySequenceNumber == n4 ? ((HlsMediaChunk)object3).extractor : null;
            bl2 = bl5 ^ true;
            hlsMediaPlaylist = id3Decoder;
            object3 = object6;
        } else {
            object = new Id3Decoder();
            object3 = new ParsableByteArray(10);
            object6 = null;
            bl2 = false;
            hlsMediaPlaylist = object;
            object = object6;
        }
        return new HlsMediaChunk(hlsExtractorFactory, dataSource, dataSpec, format, bl4, (DataSource)object5, (DataSpec)object4, bl3, uri, list, n2, object2, l3, l3 + l2, segmentBaseHolder.mediaSequence, segmentBaseHolder.partIndex, segmentBaseHolder.isPreload ^ true, n4, segmentBase.hasGapTag, bl, timestampAdjusterProvider.getAdjuster(n4), segmentBase.drmInitData, (HlsMediaChunkExtractor)object, (Id3Decoder)hlsMediaPlaylist, (ParsableByteArray)object3, bl2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresNonNull(value={"output"})
    private void feedDataToExtractor(DataSource var1_1, DataSpec var2_2, boolean var3_4) throws IOException {
        var4_5 = false;
        var5_6 = false;
        if (var3_4) {
            if (this.nextLoadPosition != 0) {
                var5_6 = true;
            }
            var6_7 = var2_2;
        } else {
            var6_7 = var2_2.subrange(this.nextLoadPosition);
            var5_6 = var4_5;
        }
        var6_7 = this.prepareExtraction(var1_1, var6_7);
        if (var5_6) {
            var6_7.skipFully(this.nextLoadPosition);
        }
        {
            catch (Throwable var2_3) {
                Util.closeQuietly(var1_1);
                throw var2_3;
            }
            try {
                while (!this.loadCanceled && (var3_4 = this.extractor.read((ExtractorInput)var6_7))) {
                }
            }
            catch (Throwable var11_10) {
                ** GOTO lbl-1000
            }
            catch (EOFException var11_11) {}
            {
                var7_8 = var6_7.getPosition();
                var9_9 = var2_2.position;
lbl23:
                // 2 sources

                while (true) {
                    this.nextLoadPosition = (int)(var7_8 - var9_9);
                    break;
                }
            }
            {
                if ((this.trackFormat.roleFlags & 16384) == 0) ** GOTO lbl-1000
                this.extractor.onTruncatedSegmentParsed();
            }
            {
                var7_8 = var6_7.getPosition();
                var9_9 = var2_2.position;
                ** continue;
            }
        }
        Util.closeQuietly(var1_1);
        return;
lbl-1000:
        // 1 sources

        {
            throw var11_11;
        }
lbl-1000:
        // 1 sources

        {
            this.nextLoadPosition = (int)(var6_7.getPosition() - var2_2.position);
            throw var11_10;
        }
    }

    private static byte[] getEncryptionIvArray(String object) {
        Object object2 = object;
        if (Util.toLowerInvariant((String)object).startsWith("0x")) {
            object2 = ((String)object).substring(2);
        }
        object = new BigInteger((String)object2, 16).toByteArray();
        object2 = new byte[16];
        int n2 = ((Object)object).length > 16 ? ((Object)object).length - 16 : 0;
        System.arraycopy(object, n2, object2, ((Object)object2).length - ((Object)object).length + n2, ((Object)object).length - n2);
        return object2;
    }

    private static boolean isIndependent(HlsChunkSource.SegmentBaseHolder segmentBaseHolder, HlsMediaPlaylist hlsMediaPlaylist) {
        if (segmentBaseHolder.segmentBase instanceof HlsMediaPlaylist.Part) {
            boolean bl = ((HlsMediaPlaylist.Part)segmentBaseHolder.segmentBase).isIndependent || segmentBaseHolder.partIndex == 0 && hlsMediaPlaylist.hasIndependentSegments;
            return bl;
        }
        return hlsMediaPlaylist.hasIndependentSegments;
    }

    @RequiresNonNull(value={"output"})
    private void loadMedia() throws IOException {
        try {
            this.timestampAdjuster.sharedInitializeOrWait(this.isMasterTimestampSource, this.startTimeUs);
            this.feedDataToExtractor((DataSource)this.dataSource, this.dataSpec, this.mediaSegmentEncrypted);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    @RequiresNonNull(value={"output"})
    private void maybeLoadInitData() throws IOException {
        if (!this.initDataLoadRequired) {
            return;
        }
        Assertions.checkNotNull(this.initDataSource);
        Assertions.checkNotNull(this.initDataSpec);
        this.feedDataToExtractor(this.initDataSource, this.initDataSpec, this.initSegmentEncrypted);
        this.nextLoadPosition = 0;
        this.initDataLoadRequired = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long peekId3PrivTimestamp(ExtractorInput extractorInput) throws IOException {
        extractorInput.resetPeekPosition();
        try {
            this.scratchId3Data.reset(10);
            extractorInput.peekFully(this.scratchId3Data.getData(), 0, 10);
        }
        catch (EOFException eOFException) {
            return -9223372036854775807L;
        }
        if (this.scratchId3Data.readUnsignedInt24() != 0x494433) {
            return -9223372036854775807L;
        }
        this.scratchId3Data.skipBytes(3);
        int n2 = this.scratchId3Data.readSynchSafeInt();
        int n3 = n2 + 10;
        if (n3 > this.scratchId3Data.capacity()) {
            byte[] byArray = this.scratchId3Data.getData();
            this.scratchId3Data.reset(n3);
            System.arraycopy(byArray, 0, this.scratchId3Data.getData(), 0, 10);
        }
        extractorInput.peekFully(this.scratchId3Data.getData(), 10, n2);
        extractorInput = this.id3Decoder.decode(this.scratchId3Data.getData(), n2);
        if (extractorInput == null) {
            return -9223372036854775807L;
        }
        n3 = extractorInput.length();
        for (n2 = 0; n2 < n3; ++n2) {
            Metadata.Entry entry = extractorInput.get(n2);
            if (!(entry instanceof PrivFrame)) continue;
            PrivFrame privFrame = (PrivFrame)entry;
            if (!PRIV_TIMESTAMP_FRAME_OWNER.equals(privFrame.owner)) continue;
            System.arraycopy(privFrame.privateData, 0, this.scratchId3Data.getData(), 0, 8);
            this.scratchId3Data.setPosition(0);
            this.scratchId3Data.setLimit(8);
            return this.scratchId3Data.readLong() & 0x1FFFFFFFFL;
        }
        return -9223372036854775807L;
    }

    @EnsuresNonNull(value={"extractor"})
    @RequiresNonNull(value={"output"})
    private DefaultExtractorInput prepareExtraction(DataSource object, DataSpec dataSpec) throws IOException {
        long l2 = object.open(dataSpec);
        DefaultExtractorInput defaultExtractorInput = new DefaultExtractorInput((DataReader)object, dataSpec.position, l2);
        if (this.extractor == null) {
            l2 = this.peekId3PrivTimestamp((ExtractorInput)defaultExtractorInput);
            defaultExtractorInput.resetPeekPosition();
            HlsMediaChunkExtractor hlsMediaChunkExtractor = this.previousExtractor;
            object = hlsMediaChunkExtractor != null ? hlsMediaChunkExtractor.recreate() : this.extractorFactory.createExtractor(dataSpec.uri, this.trackFormat, this.muxedCaptionFormats, this.timestampAdjuster, object.getResponseHeaders(), (ExtractorInput)defaultExtractorInput);
            this.extractor = object;
            if (this.extractor.isPackedAudioExtractor()) {
                object = this.output;
                l2 = l2 != -9223372036854775807L ? this.timestampAdjuster.adjustTsTimestamp(l2) : this.startTimeUs;
                ((HlsSampleStreamWrapper)object).setSampleOffsetUs(l2);
            } else {
                this.output.setSampleOffsetUs(0L);
            }
            this.output.onNewExtractor();
            this.extractor.init((ExtractorOutput)this.output);
        }
        this.output.setDrmInitData(this.drmInitData);
        return defaultExtractorInput;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    public int getFirstSampleIndex(int n2) {
        Assertions.checkState(this.shouldSpliceIn ^ true);
        if (n2 >= this.sampleQueueFirstSampleIndices.size()) {
            return 0;
        }
        return (Integer)this.sampleQueueFirstSampleIndices.get(n2);
    }

    public void init(HlsSampleStreamWrapper hlsSampleStreamWrapper, ImmutableList<Integer> immutableList) {
        this.output = hlsSampleStreamWrapper;
        this.sampleQueueFirstSampleIndices = immutableList;
    }

    public void invalidateExtractor() {
        this.extractorInvalidated = true;
    }

    @Override
    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    public boolean isPublished() {
        return this.isPublished;
    }

    @Override
    public void load() throws IOException {
        HlsMediaChunkExtractor hlsMediaChunkExtractor;
        Assertions.checkNotNull(this.output);
        if (this.extractor == null && (hlsMediaChunkExtractor = this.previousExtractor) != null && hlsMediaChunkExtractor.isReusable()) {
            this.extractor = this.previousExtractor;
            this.initDataLoadRequired = false;
        }
        this.maybeLoadInitData();
        if (!this.loadCanceled) {
            if (!this.hasGapTag) {
                this.loadMedia();
            }
            this.loadCompleted = this.loadCanceled ^ true;
        }
    }

    public void publish() {
        this.isPublished = true;
    }
}

