/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.SystemClock;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunkIterator;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.DataChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.source.hls.FullSegmentEncryptionKeyCache;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.trackselection.BaseTrackSelection;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class HlsChunkSource {
    public static final int CHUNK_PUBLICATION_STATE_PRELOAD = 0;
    public static final int CHUNK_PUBLICATION_STATE_PUBLISHED = 1;
    public static final int CHUNK_PUBLICATION_STATE_REMOVED = 2;
    private static final int KEY_CACHE_SIZE = 4;
    private final DataSource encryptionDataSource;
    private Uri expectedPlaylistUrl;
    private final HlsExtractorFactory extractorFactory;
    private IOException fatalError;
    private boolean independentSegments;
    private boolean isTimestampMaster;
    private final FullSegmentEncryptionKeyCache keyCache;
    private long liveEdgeInPeriodTimeUs;
    private final DataSource mediaDataSource;
    private final List<Format> muxedCaptionFormats;
    private final Format[] playlistFormats;
    private final HlsPlaylistTracker playlistTracker;
    private final Uri[] playlistUrls;
    private byte[] scratchSpace;
    private boolean seenExpectedPlaylistError;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final TrackGroup trackGroup;
    private ExoTrackSelection trackSelection;

    public HlsChunkSource(HlsExtractorFactory object, HlsPlaylistTracker hlsPlaylistTracker, Uri[] uriArray, Format[] formatArray, HlsDataSourceFactory hlsDataSourceFactory, TransferListener transferListener, TimestampAdjusterProvider timestampAdjusterProvider, List<Format> list) {
        this.extractorFactory = object;
        this.playlistTracker = hlsPlaylistTracker;
        this.playlistUrls = uriArray;
        this.playlistFormats = formatArray;
        this.timestampAdjusterProvider = timestampAdjusterProvider;
        this.muxedCaptionFormats = list;
        this.keyCache = new FullSegmentEncryptionKeyCache(4);
        this.scratchSpace = Util.EMPTY_BYTE_ARRAY;
        this.liveEdgeInPeriodTimeUs = -9223372036854775807L;
        this.mediaDataSource = hlsDataSourceFactory.createDataSource(1);
        if (transferListener != null) {
            this.mediaDataSource.addTransferListener(transferListener);
        }
        this.encryptionDataSource = hlsDataSourceFactory.createDataSource(3);
        this.trackGroup = new TrackGroup(formatArray);
        object = new ArrayList();
        for (int i2 = 0; i2 < uriArray.length; ++i2) {
            if ((formatArray[i2].roleFlags & 0x4000) != 0) continue;
            ((ArrayList)object).add(i2);
        }
        this.trackSelection = new InitializationTrackSelection(this.trackGroup, Ints.toArray((Collection<? extends Number>)object));
    }

    private static Uri getFullEncryptionKeyUri(HlsMediaPlaylist hlsMediaPlaylist, HlsMediaPlaylist.SegmentBase segmentBase) {
        if (segmentBase != null && segmentBase.fullSegmentEncryptionKeyUri != null) {
            return UriUtil.resolveToUri((String)hlsMediaPlaylist.baseUri, (String)segmentBase.fullSegmentEncryptionKeyUri);
        }
        return null;
    }

    private Pair<Long, Integer> getNextMediaSequenceAndPartIndex(HlsMediaChunk list, boolean bl, HlsMediaPlaylist hlsMediaPlaylist, long l2, long l3) {
        int n2 = -1;
        if (list != null && !bl) {
            if (((HlsMediaChunk)((Object)list)).isLoadCompleted()) {
                l2 = ((HlsMediaChunk)((Object)list)).partIndex == -1 ? ((MediaChunk)((Object)list)).getNextChunkIndex() : ((HlsMediaChunk)((Object)list)).chunkIndex;
                if (((HlsMediaChunk)((Object)list)).partIndex != -1) {
                    n2 = ((HlsMediaChunk)((Object)list)).partIndex + 1;
                }
                list = new Pair((Object)l2, (Object)n2);
            } else {
                list = new Pair((Object)((HlsMediaChunk)((Object)list)).chunkIndex, (Object)((HlsMediaChunk)((Object)list)).partIndex);
            }
            return list;
        }
        long l4 = hlsMediaPlaylist.durationUs;
        long l5 = l3;
        if (list != null) {
            l5 = this.independentSegments ? l3 : ((HlsMediaChunk)((Object)list)).startTimeUs;
        }
        if (!hlsMediaPlaylist.hasEndTag && l5 >= l4 + l2) {
            return new Pair((Object)(hlsMediaPlaylist.mediaSequence + (long)hlsMediaPlaylist.segments.size()), (Object)-1);
        }
        Object object = hlsMediaPlaylist.segments;
        bl = this.playlistTracker.isLive();
        int n3 = 0;
        bl = !bl || list == null;
        int n4 = Util.binarySearchFloor(object, Long.valueOf(l5 -= l2), true, bl);
        l3 = (long)n4 + hlsMediaPlaylist.mediaSequence;
        int n5 = n2;
        l2 = l3;
        if (n4 >= 0) {
            list = hlsMediaPlaylist.segments.get(n4);
            list = l5 < ((HlsMediaPlaylist.Segment)((Object)list)).relativeStartTimeUs + ((HlsMediaPlaylist.Segment)((Object)list)).durationUs ? ((HlsMediaPlaylist.Segment)((Object)list)).parts : hlsMediaPlaylist.trailingParts;
            while (true) {
                n5 = n2;
                l2 = l3;
                if (n3 >= list.size()) break;
                object = list.get(n3);
                if (l5 < ((HlsMediaPlaylist.Part)object).relativeStartTimeUs + ((HlsMediaPlaylist.Part)object).durationUs) {
                    n5 = n2;
                    l2 = l3;
                    if (!((HlsMediaPlaylist.Part)object).isIndependent) break;
                    l2 = list == hlsMediaPlaylist.trailingParts ? 1L : 0L;
                    l2 = l3 + l2;
                    n5 = n3;
                    break;
                }
                ++n3;
            }
        }
        return new Pair((Object)l2, (Object)n5);
    }

    private static SegmentBaseHolder getNextSegmentHolder(HlsMediaPlaylist hlsMediaPlaylist, long l2, int n2) {
        int n3 = (int)(l2 - hlsMediaPlaylist.mediaSequence);
        int n4 = hlsMediaPlaylist.segments.size();
        Object object = null;
        if (n3 == n4) {
            if (n2 == -1) {
                n2 = 0;
            }
            if (n2 < hlsMediaPlaylist.trailingParts.size()) {
                object = new SegmentBaseHolder(hlsMediaPlaylist.trailingParts.get(n2), l2, n2);
            }
            return object;
        }
        object = hlsMediaPlaylist.segments.get(n3);
        if (n2 == -1) {
            return new SegmentBaseHolder((HlsMediaPlaylist.SegmentBase)object, l2, -1);
        }
        if (n2 < ((HlsMediaPlaylist.Segment)object).parts.size()) {
            return new SegmentBaseHolder(((HlsMediaPlaylist.Segment)object).parts.get(n2), l2, n2);
        }
        n2 = n3 + 1;
        if (n2 < hlsMediaPlaylist.segments.size()) {
            return new SegmentBaseHolder(hlsMediaPlaylist.segments.get(n2), l2 + 1L, -1);
        }
        if (!hlsMediaPlaylist.trailingParts.isEmpty()) {
            return new SegmentBaseHolder(hlsMediaPlaylist.trailingParts.get(0), l2 + 1L, 0);
        }
        return null;
    }

    static List<HlsMediaPlaylist.SegmentBase> getSegmentBaseList(HlsMediaPlaylist hlsMediaPlaylist, long l2, int n2) {
        int n3 = (int)(l2 - hlsMediaPlaylist.mediaSequence);
        if (n3 >= 0 && hlsMediaPlaylist.segments.size() >= n3) {
            ArrayList<HlsMediaPlaylist.SegmentBase> arrayList = new ArrayList<HlsMediaPlaylist.SegmentBase>();
            int n4 = n2;
            if (n3 < hlsMediaPlaylist.segments.size()) {
                n4 = n3;
                if (n2 != -1) {
                    HlsMediaPlaylist.Segment segment = hlsMediaPlaylist.segments.get(n3);
                    if (n2 == 0) {
                        arrayList.add(segment);
                    } else if (n2 < segment.parts.size()) {
                        arrayList.addAll(segment.parts.subList(n2, segment.parts.size()));
                    }
                    n4 = n3 + 1;
                }
                arrayList.addAll(hlsMediaPlaylist.segments.subList(n4, hlsMediaPlaylist.segments.size()));
                n4 = 0;
            }
            if (hlsMediaPlaylist.partTargetDurationUs != -9223372036854775807L) {
                n2 = n4;
                if (n4 == -1) {
                    n2 = 0;
                }
                if (n2 < hlsMediaPlaylist.trailingParts.size()) {
                    arrayList.addAll(hlsMediaPlaylist.trailingParts.subList(n2, hlsMediaPlaylist.trailingParts.size()));
                }
            }
            return Collections.unmodifiableList(arrayList);
        }
        return ImmutableList.of();
    }

    private Chunk maybeCreateEncryptionChunkFor(Uri object, int n2) {
        if (object == null) {
            return null;
        }
        byte[] byArray = this.keyCache.remove(object);
        if (byArray != null) {
            this.keyCache.put(object, byArray);
            return null;
        }
        object = new DataSpec.Builder().setUri((Uri)object).setFlags(1).build();
        return new EncryptionKeyChunk(this.encryptionDataSource, (DataSpec)object, this.playlistFormats[n2], this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.scratchSpace);
    }

    private long resolveTimeToLiveEdgeUs(long l2) {
        long l3 = this.liveEdgeInPeriodTimeUs;
        long l4 = -9223372036854775807L;
        boolean bl = l3 != -9223372036854775807L;
        if (bl) {
            l4 = this.liveEdgeInPeriodTimeUs - l2;
        }
        return l4;
    }

    private void updateLiveEdgeTimeUs(HlsMediaPlaylist hlsMediaPlaylist) {
        long l2 = hlsMediaPlaylist.hasEndTag ? -9223372036854775807L : hlsMediaPlaylist.getEndTimeUs() - this.playlistTracker.getInitialStartTimeUs();
        this.liveEdgeInPeriodTimeUs = l2;
    }

    public MediaChunkIterator[] createMediaChunkIterators(HlsMediaChunk hlsMediaChunk, long l2) {
        int n2 = hlsMediaChunk == null ? -1 : this.trackGroup.indexOf(hlsMediaChunk.trackFormat);
        MediaChunkIterator[] mediaChunkIteratorArray = new MediaChunkIterator[this.trackSelection.length()];
        for (int i2 = 0; i2 < mediaChunkIteratorArray.length; ++i2) {
            int n3 = this.trackSelection.getIndexInTrackGroup(i2);
            Pair<Long, Integer> pair = this.playlistUrls[n3];
            if (!this.playlistTracker.isSnapshotValid((Uri)pair)) {
                mediaChunkIteratorArray[i2] = MediaChunkIterator.EMPTY;
                continue;
            }
            HlsMediaPlaylist hlsMediaPlaylist = this.playlistTracker.getPlaylistSnapshot((Uri)pair, false);
            Assertions.checkNotNull(hlsMediaPlaylist);
            long l3 = hlsMediaPlaylist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            boolean bl = n3 != n2;
            pair = this.getNextMediaSequenceAndPartIndex(hlsMediaChunk, bl, hlsMediaPlaylist, l3, l2);
            long l4 = (Long)pair.first;
            n3 = (Integer)pair.second;
            mediaChunkIteratorArray[i2] = new HlsMediaPlaylistSegmentIterator(hlsMediaPlaylist.baseUri, l3, HlsChunkSource.getSegmentBaseList(hlsMediaPlaylist, l4, n3));
        }
        return mediaChunkIteratorArray;
    }

    public int getChunkPublicationState(HlsMediaChunk hlsMediaChunk) {
        int n2 = hlsMediaChunk.partIndex;
        int n3 = 1;
        if (n2 == -1) {
            return 1;
        }
        Object object = this.playlistUrls[this.trackGroup.indexOf(hlsMediaChunk.trackFormat)];
        HlsMediaPlaylist hlsMediaPlaylist = Assertions.checkNotNull(this.playlistTracker.getPlaylistSnapshot((Uri)object, false));
        n2 = (int)(hlsMediaChunk.chunkIndex - hlsMediaPlaylist.mediaSequence);
        if (n2 < 0) {
            return 1;
        }
        object = n2 < hlsMediaPlaylist.segments.size() ? hlsMediaPlaylist.segments.get((int)n2).parts : hlsMediaPlaylist.trailingParts;
        if (hlsMediaChunk.partIndex >= object.size()) {
            return 2;
        }
        object = (HlsMediaPlaylist.Part)object.get(hlsMediaChunk.partIndex);
        if (((HlsMediaPlaylist.Part)object).isPreload) {
            return 0;
        }
        if (!Util.areEqual(Uri.parse((String)UriUtil.resolve((String)hlsMediaPlaylist.baseUri, (String)((HlsMediaPlaylist.Part)object).url)), hlsMediaChunk.dataSpec.uri)) {
            n3 = 2;
        }
        return n3;
    }

    public void getNextChunk(long l2, long l3, List<HlsMediaChunk> uri, boolean bl, HlsChunkHolder hlsChunkHolder) {
        HlsMediaChunk hlsMediaChunk = uri.isEmpty() ? null : Iterables.getLast(uri);
        int n2 = hlsMediaChunk == null ? -1 : this.trackGroup.indexOf(hlsMediaChunk.trackFormat);
        long l4 = l3 - l2;
        long l5 = this.resolveTimeToLiveEdgeUs(l2);
        long l6 = l4;
        long l7 = l5;
        if (hlsMediaChunk != null) {
            l6 = l4;
            l7 = l5;
            if (!this.independentSegments) {
                long l8 = hlsMediaChunk.getDurationUs();
                l6 = l4 = Math.max(0L, l4 - l8);
                l7 = l5;
                if (l5 != -9223372036854775807L) {
                    l7 = Math.max(0L, l5 - l8);
                    l6 = l4;
                }
            }
        }
        Object object = this.createMediaChunkIterators(hlsMediaChunk, l3);
        this.trackSelection.updateSelectedTrack(l2, l6, l7, uri, object);
        int n3 = this.trackSelection.getSelectedIndexInTrackGroup();
        boolean bl2 = n2 != n3;
        uri = this.playlistUrls[n3];
        if (!this.playlistTracker.isSnapshotValid(uri)) {
            hlsChunkHolder.playlistUrl = uri;
            this.seenExpectedPlaylistError &= uri.equals((Object)this.expectedPlaylistUrl);
            this.expectedPlaylistUrl = uri;
            return;
        }
        object = this.playlistTracker.getPlaylistSnapshot(uri, true);
        Assertions.checkNotNull(object);
        this.independentSegments = object.hasIndependentSegments;
        this.updateLiveEdgeTimeUs((HlsMediaPlaylist)((Object)object));
        l6 = object.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
        Object object2 = this.getNextMediaSequenceAndPartIndex(hlsMediaChunk, bl2, (HlsMediaPlaylist)((Object)object), l6, l3);
        l2 = (Long)object2.first;
        int n4 = (Integer)object2.second;
        if (l2 < object.mediaSequence && hlsMediaChunk != null && bl2) {
            uri = this.playlistUrls[n2];
            object = this.playlistTracker.getPlaylistSnapshot(uri, true);
            Assertions.checkNotNull(object);
            l6 = object.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            object2 = this.getNextMediaSequenceAndPartIndex(hlsMediaChunk, false, (HlsMediaPlaylist)((Object)object), l6, l3);
            l2 = (Long)object2.first;
            n4 = (Integer)object2.second;
            l3 = l6;
        } else {
            l3 = l6;
            n2 = n3;
        }
        if (l2 < object.mediaSequence) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        SegmentBaseHolder segmentBaseHolder = HlsChunkSource.getNextSegmentHolder((HlsMediaPlaylist)((Object)object), l2, n4);
        object2 = segmentBaseHolder;
        if (segmentBaseHolder == null) {
            if (!object.hasEndTag) {
                hlsChunkHolder.playlistUrl = uri;
                this.seenExpectedPlaylistError &= uri.equals((Object)this.expectedPlaylistUrl);
                this.expectedPlaylistUrl = uri;
                return;
            }
            if (!bl && !object.segments.isEmpty()) {
                object2 = new SegmentBaseHolder(Iterables.getLast(object.segments), object.mediaSequence + (long)object.segments.size() - 1L, -1);
            } else {
                hlsChunkHolder.endOfStream = true;
                return;
            }
        }
        this.seenExpectedPlaylistError = false;
        this.expectedPlaylistUrl = null;
        segmentBaseHolder = HlsChunkSource.getFullEncryptionKeyUri((HlsMediaPlaylist)((Object)object), object2.segmentBase.initializationSegment);
        hlsChunkHolder.chunk = this.maybeCreateEncryptionChunkFor((Uri)segmentBaseHolder, n2);
        if (hlsChunkHolder.chunk != null) {
            return;
        }
        Uri uri2 = HlsChunkSource.getFullEncryptionKeyUri((HlsMediaPlaylist)((Object)object), object2.segmentBase);
        hlsChunkHolder.chunk = this.maybeCreateEncryptionChunkFor(uri2, n2);
        if (hlsChunkHolder.chunk != null) {
            return;
        }
        hlsChunkHolder.chunk = HlsMediaChunk.createInstance(this.extractorFactory, this.mediaDataSource, this.playlistFormats[n2], l3, (HlsMediaPlaylist)((Object)object), object2, uri, this.muxedCaptionFormats, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.isTimestampMaster, this.timestampAdjusterProvider, hlsMediaChunk, this.keyCache.get(uri2), this.keyCache.get((Uri)segmentBaseHolder));
    }

    public int getPreferredQueueSize(long l2, List<? extends MediaChunk> list) {
        if (this.fatalError == null && this.trackSelection.length() >= 2) {
            return this.trackSelection.evaluateQueueSize(l2, list);
        }
        return list.size();
    }

    public TrackGroup getTrackGroup() {
        return this.trackGroup;
    }

    public ExoTrackSelection getTrackSelection() {
        return this.trackSelection;
    }

    public boolean maybeExcludeTrack(Chunk chunk, long l2) {
        ExoTrackSelection exoTrackSelection = this.trackSelection;
        return exoTrackSelection.blacklist(exoTrackSelection.indexOf(this.trackGroup.indexOf(chunk.trackFormat)), l2);
    }

    public void maybeThrowError() throws IOException {
        IOException iOException = this.fatalError;
        if (iOException == null) {
            iOException = this.expectedPlaylistUrl;
            if (iOException != null && this.seenExpectedPlaylistError) {
                this.playlistTracker.maybeThrowPlaylistRefreshError((Uri)iOException);
            }
            return;
        }
        throw iOException;
    }

    public void onChunkLoadCompleted(Chunk object) {
        if (object instanceof EncryptionKeyChunk) {
            object = (EncryptionKeyChunk)((Object)object);
            this.scratchSpace = object.getDataHolder();
            this.keyCache.put(((EncryptionKeyChunk)((Object)object)).dataSpec.uri, Assertions.checkNotNull(((EncryptionKeyChunk)((Object)object)).getResult()));
        }
    }

    public boolean onPlaylistError(Uri uri, long l2) {
        int n2;
        boolean bl;
        block5: {
            Uri[] uriArray;
            bl = false;
            for (n2 = 0; n2 < (uriArray = this.playlistUrls).length; ++n2) {
                if (!uriArray[n2].equals((Object)uri)) {
                    continue;
                }
                break block5;
            }
            n2 = -1;
        }
        if (n2 == -1) {
            return true;
        }
        if ((n2 = this.trackSelection.indexOf(n2)) == -1) {
            return true;
        }
        boolean bl2 = this.seenExpectedPlaylistError;
        this.seenExpectedPlaylistError = uri.equals((Object)this.expectedPlaylistUrl) | bl2;
        if (l2 == -9223372036854775807L || this.trackSelection.blacklist(n2, l2)) {
            bl = true;
        }
        return bl;
    }

    public void reset() {
        this.fatalError = null;
    }

    public void setIsTimestampMaster(boolean bl) {
        this.isTimestampMaster = bl;
    }

    public void setTrackSelection(ExoTrackSelection exoTrackSelection) {
        this.trackSelection = exoTrackSelection;
    }

    public boolean shouldCancelLoad(long l2, Chunk chunk, List<? extends MediaChunk> list) {
        if (this.fatalError != null) {
            return false;
        }
        return this.trackSelection.shouldCancelChunkLoad(l2, chunk, list);
    }

    private static final class EncryptionKeyChunk
    extends DataChunk {
        private byte[] result;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, Format format, int n2, Object object, byte[] byArray) {
            super(dataSource, dataSpec, 3, format, n2, object, byArray);
        }

        protected void consume(byte[] byArray, int n2) {
            this.result = Arrays.copyOf(byArray, n2);
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    public static final class HlsChunkHolder {
        public Chunk chunk;
        public boolean endOfStream;
        public Uri playlistUrl;

        public HlsChunkHolder() {
            this.clear();
        }

        public void clear() {
            this.chunk = null;
            this.endOfStream = false;
            this.playlistUrl = null;
        }
    }

    static final class HlsMediaPlaylistSegmentIterator
    extends BaseMediaChunkIterator {
        private final String playlistBaseUri;
        private final List<HlsMediaPlaylist.SegmentBase> segmentBases;
        private final long startOfPlaylistInPeriodUs;

        public HlsMediaPlaylistSegmentIterator(String string2, long l2, List<HlsMediaPlaylist.SegmentBase> list) {
            super(0L, (long)(list.size() - 1));
            this.playlistBaseUri = string2;
            this.startOfPlaylistInPeriodUs = l2;
            this.segmentBases = list;
        }

        public long getChunkEndTimeUs() {
            this.checkInBounds();
            HlsMediaPlaylist.SegmentBase segmentBase = this.segmentBases.get((int)this.getCurrentIndex());
            return this.startOfPlaylistInPeriodUs + segmentBase.relativeStartTimeUs + segmentBase.durationUs;
        }

        public long getChunkStartTimeUs() {
            this.checkInBounds();
            return this.startOfPlaylistInPeriodUs + this.segmentBases.get((int)((int)this.getCurrentIndex())).relativeStartTimeUs;
        }

        public DataSpec getDataSpec() {
            this.checkInBounds();
            HlsMediaPlaylist.SegmentBase segmentBase = this.segmentBases.get((int)this.getCurrentIndex());
            return new DataSpec(UriUtil.resolveToUri((String)this.playlistBaseUri, (String)segmentBase.url), segmentBase.byteRangeOffset, segmentBase.byteRangeLength);
        }
    }

    private static final class InitializationTrackSelection
    extends BaseTrackSelection {
        private int selectedIndex;

        public InitializationTrackSelection(TrackGroup trackGroup, int[] nArray) {
            super(trackGroup, nArray);
            this.selectedIndex = this.indexOf(trackGroup.getFormat(nArray[0]));
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public Object getSelectionData() {
            return null;
        }

        public int getSelectionReason() {
            return 0;
        }

        public void updateSelectedTrack(long l2, long l3, long l4, List<? extends MediaChunk> object, MediaChunkIterator[] mediaChunkIteratorArray) {
            l2 = SystemClock.elapsedRealtime();
            if (!this.isBlacklisted(this.selectedIndex, l2)) {
                return;
            }
            for (int i2 = this.length - 1; i2 >= 0; --i2) {
                if (this.isBlacklisted(i2, l2)) continue;
                this.selectedIndex = i2;
                return;
            }
            object = new IllegalStateException();
            throw object;
        }
    }

    static final class SegmentBaseHolder {
        public final boolean isPreload;
        public final long mediaSequence;
        public final int partIndex;
        public final HlsMediaPlaylist.SegmentBase segmentBase;

        public SegmentBaseHolder(HlsMediaPlaylist.SegmentBase segmentBase, long l2, int n2) {
            this.segmentBase = segmentBase;
            this.mediaSequence = l2;
            this.partIndex = n2;
            boolean bl = segmentBase instanceof HlsMediaPlaylist.Part && ((HlsMediaPlaylist.Part)segmentBase).isPreload;
            this.isPreload = bl;
        }
    }
}

