/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.UrlTemplate;
import com.google.android.exoplayer2.util.Util;
import java.util.List;

public abstract class SegmentBase {
    final RangedUri initialization;
    final long presentationTimeOffset;
    final long timescale;

    public SegmentBase(RangedUri rangedUri, long l2, long l3) {
        this.initialization = rangedUri;
        this.timescale = l2;
        this.presentationTimeOffset = l3;
    }

    public RangedUri getInitialization(Representation representation) {
        return this.initialization;
    }

    public long getPresentationTimeOffsetUs() {
        return Util.scaleLargeTimestamp(this.presentationTimeOffset, 1000000L, this.timescale);
    }

    public static abstract class MultiSegmentBase
    extends SegmentBase {
        final long availabilityTimeOffsetUs;
        final long duration;
        private final long periodStartUnixTimeUs;
        final List<SegmentTimelineElement> segmentTimeline;
        final long startNumber;
        private final long timeShiftBufferDepthUs;

        public MultiSegmentBase(RangedUri rangedUri, long l2, long l3, long l4, long l5, List<SegmentTimelineElement> list, long l6, long l7, long l8) {
            super(rangedUri, l2, l3);
            this.startNumber = l4;
            this.duration = l5;
            this.segmentTimeline = list;
            this.availabilityTimeOffsetUs = l6;
            this.timeShiftBufferDepthUs = l7;
            this.periodStartUnixTimeUs = l8;
        }

        public int getAvailableSegmentCount(long l2, long l3) {
            int n2 = this.getSegmentCount(l2);
            if (n2 != -1) {
                return n2;
            }
            return (int)(this.getSegmentNum(l3 - this.periodStartUnixTimeUs + this.availabilityTimeOffsetUs, l2) - this.getFirstAvailableSegmentNum(l2, l3));
        }

        public long getFirstAvailableSegmentNum(long l2, long l3) {
            long l4;
            if ((long)this.getSegmentCount(l2) == -1L && (l4 = this.timeShiftBufferDepthUs) != -9223372036854775807L) {
                l2 = this.getSegmentNum(l3 - this.periodStartUnixTimeUs - l4, l2);
                return Math.max(this.getFirstSegmentNum(), l2);
            }
            return this.getFirstSegmentNum();
        }

        public long getFirstSegmentNum() {
            return this.startNumber;
        }

        public long getNextSegmentAvailableTimeUs(long l2, long l3) {
            if (this.segmentTimeline != null) {
                return -9223372036854775807L;
            }
            l3 = this.getFirstAvailableSegmentNum(l2, l3) + (long)this.getAvailableSegmentCount(l2, l3);
            return this.getSegmentTimeUs(l3) + this.getSegmentDurationUs(l3, l2) - this.availabilityTimeOffsetUs;
        }

        public abstract int getSegmentCount(long var1);

        public final long getSegmentDurationUs(long l2, long l3) {
            List<SegmentTimelineElement> list = this.segmentTimeline;
            if (list != null) {
                return list.get((int)((int)(l2 - this.startNumber))).duration * 1000000L / this.timescale;
            }
            int n2 = this.getSegmentCount(l3);
            l2 = n2 != -1 && l2 == this.getFirstSegmentNum() + (long)n2 - 1L ? l3 - this.getSegmentTimeUs(l2) : this.duration * 1000000L / this.timescale;
            return l2;
        }

        public long getSegmentNum(long l2, long l3) {
            long l4 = this.getFirstSegmentNum();
            if ((l3 = (long)this.getSegmentCount(l3)) == 0L) {
                return l4;
            }
            if (this.segmentTimeline == null) {
                long l5 = this.duration * 1000000L / this.timescale;
                long l6 = this.startNumber;
                if ((l2 = l2 / l5 + l6) < l4) {
                    l2 = l4;
                } else if (l3 != -1L) {
                    l2 = Math.min(l2, l4 + l3 - 1L);
                }
                return l2;
            }
            long l7 = l3 + l4 - 1L;
            l3 = l4;
            while (l3 <= l7) {
                long l8 = (l7 - l3) / 2L + l3;
                long l9 = this.getSegmentTimeUs(l8);
                if (l9 < l2) {
                    l3 = l8 + 1L;
                    continue;
                }
                if (l9 > l2) {
                    l7 = l8 - 1L;
                    continue;
                }
                return l8;
            }
            if (l3 != l4) {
                l3 = l7;
            }
            return l3;
        }

        public final long getSegmentTimeUs(long l2) {
            List<SegmentTimelineElement> list = this.segmentTimeline;
            l2 = list != null ? list.get((int)((int)(l2 - this.startNumber))).startTime - this.presentationTimeOffset : (l2 - this.startNumber) * this.duration;
            return Util.scaleLargeTimestamp(l2, 1000000L, this.timescale);
        }

        public abstract RangedUri getSegmentUrl(Representation var1, long var2);

        public boolean isExplicit() {
            boolean bl = this.segmentTimeline != null;
            return bl;
        }
    }

    public static final class SegmentList
    extends MultiSegmentBase {
        final List<RangedUri> mediaSegments;

        public SegmentList(RangedUri rangedUri, long l2, long l3, long l4, long l5, List<SegmentTimelineElement> list, long l6, List<RangedUri> list2, long l7, long l8) {
            super(rangedUri, l2, l3, l4, l5, list, l6, l7, l8);
            this.mediaSegments = list2;
        }

        @Override
        public int getSegmentCount(long l2) {
            return this.mediaSegments.size();
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, long l2) {
            return this.mediaSegments.get((int)(l2 - this.startNumber));
        }

        @Override
        public boolean isExplicit() {
            return true;
        }
    }

    public static final class SegmentTemplate
    extends MultiSegmentBase {
        final long endNumber;
        final UrlTemplate initializationTemplate;
        final UrlTemplate mediaTemplate;

        public SegmentTemplate(RangedUri rangedUri, long l2, long l3, long l4, long l5, long l6, List<SegmentTimelineElement> list, long l7, UrlTemplate urlTemplate, UrlTemplate urlTemplate2, long l8, long l9) {
            super(rangedUri, l2, l3, l4, l6, list, l7, l8, l9);
            this.initializationTemplate = urlTemplate;
            this.mediaTemplate = urlTemplate2;
            this.endNumber = l5;
        }

        @Override
        public RangedUri getInitialization(Representation representation) {
            UrlTemplate urlTemplate = this.initializationTemplate;
            if (urlTemplate != null) {
                return new RangedUri(urlTemplate.buildUri(representation.format.id, 0L, representation.format.bitrate, 0L), 0L, -1L);
            }
            return super.getInitialization(representation);
        }

        @Override
        public int getSegmentCount(long l2) {
            if (this.segmentTimeline != null) {
                return this.segmentTimeline.size();
            }
            long l3 = this.endNumber;
            if (l3 != -1L) {
                return (int)(l3 - this.startNumber + 1L);
            }
            if (l2 != -9223372036854775807L) {
                return (int)Util.ceilDivide(l2, this.duration * 1000000L / this.timescale);
            }
            return -1;
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, long l2) {
            long l3 = this.segmentTimeline != null ? ((SegmentTimelineElement)this.segmentTimeline.get((int)((int)(l2 - this.startNumber)))).startTime : (l2 - this.startNumber) * this.duration;
            return new RangedUri(this.mediaTemplate.buildUri(representation.format.id, l2, representation.format.bitrate, l3), 0L, -1L);
        }
    }

    public static final class SegmentTimelineElement {
        final long duration;
        final long startTime;

        public SegmentTimelineElement(long l2, long l3) {
            this.startTime = l2;
            this.duration = l3;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (SegmentTimelineElement)object;
                if (this.startTime != ((SegmentTimelineElement)object).startTime || this.duration != ((SegmentTimelineElement)object).duration) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.startTime * 31 + (int)this.duration;
        }
    }

    public static class SingleSegmentBase
    extends SegmentBase {
        final long indexLength;
        final long indexStart;

        public SingleSegmentBase() {
            this(null, 1L, 0L, 0L, 0L);
        }

        public SingleSegmentBase(RangedUri rangedUri, long l2, long l3, long l4, long l5) {
            super(rangedUri, l2, l3);
            this.indexStart = l4;
            this.indexLength = l5;
        }

        public RangedUri getIndex() {
            long l2 = this.indexLength;
            RangedUri rangedUri = l2 <= 0L ? null : new RangedUri(null, this.indexStart, l2);
            return rangedUri;
        }
    }
}

