/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.EmptySampleStream;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.ChunkSampleStream;
import com.google.android.exoplayer2.source.chunk.ChunkSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.EventSampleStream;
import com.google.android.exoplayer2.source.dash.PlayerEmsgHandler;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Descriptor;
import com.google.android.exoplayer2.source.dash.manifest.EventStream;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DashMediaPeriod
implements MediaPeriod,
SequenceableLoader.Callback<ChunkSampleStream<DashChunkSource>>,
ChunkSampleStream.ReleaseCallback<DashChunkSource> {
    private static final Pattern CEA608_SERVICE_DESCRIPTOR_REGEX = Pattern.compile("CC([1-4])=(.+)");
    private static final Pattern CEA708_SERVICE_DESCRIPTOR_REGEX = Pattern.compile("([1-4])=lang:(\\w+)(,.+)?");
    private final Allocator allocator;
    private MediaPeriod.Callback callback;
    private final DashChunkSource.Factory chunkSourceFactory;
    private SequenceableLoader compositeSequenceableLoader;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final DrmSessionManager drmSessionManager;
    private final long elapsedRealtimeOffsetMs;
    private EventSampleStream[] eventSampleStreams;
    private List<EventStream> eventStreams;
    final int id;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private DashManifest manifest;
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private int periodIndex;
    private final PlayerEmsgHandler playerEmsgHandler;
    private ChunkSampleStream<DashChunkSource>[] sampleStreams;
    private final IdentityHashMap<ChunkSampleStream<DashChunkSource>, PlayerEmsgHandler.PlayerTrackEmsgHandler> trackEmsgHandlerBySampleStream;
    private final TrackGroupInfo[] trackGroupInfos;
    private final TrackGroupArray trackGroups;
    private final TransferListener transferListener;

    public DashMediaPeriod(int n2, DashManifest pair, int n3, DashChunkSource.Factory factory, TransferListener transferListener, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher2, long l2, LoaderErrorThrower loaderErrorThrower, Allocator allocator, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, PlayerEmsgHandler.PlayerEmsgCallback playerEmsgCallback) {
        this.id = n2;
        this.manifest = pair;
        this.periodIndex = n3;
        this.chunkSourceFactory = factory;
        this.transferListener = transferListener;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = eventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.mediaSourceEventDispatcher = eventDispatcher2;
        this.elapsedRealtimeOffsetMs = l2;
        this.manifestLoaderErrorThrower = loaderErrorThrower;
        this.allocator = allocator;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.playerEmsgHandler = new PlayerEmsgHandler((DashManifest)pair, playerEmsgCallback, allocator);
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(0);
        this.eventSampleStreams = new EventSampleStream[0];
        this.trackEmsgHandlerBySampleStream = new IdentityHashMap();
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        pair = pair.getPeriod(n3);
        this.eventStreams = pair.eventStreams;
        pair = DashMediaPeriod.buildTrackGroups(drmSessionManager, pair.adaptationSets, this.eventStreams);
        this.trackGroups = (TrackGroupArray)pair.first;
        this.trackGroupInfos = (TrackGroupInfo[])pair.second;
    }

    private static void buildManifestEventTrackGroupInfos(List<EventStream> list, TrackGroup[] trackGroupArray, TrackGroupInfo[] trackGroupInfoArray, int n2) {
        int n3 = 0;
        while (n3 < list.size()) {
            EventStream eventStream = list.get(n3);
            trackGroupArray[n2] = new TrackGroup(new Format[]{new Format.Builder().setId(eventStream.id()).setSampleMimeType("application/x-emsg").build()});
            trackGroupInfoArray[n2] = TrackGroupInfo.mpdEventTrack(n3);
            ++n3;
            ++n2;
        }
    }

    private static int buildPrimaryAndEmbeddedTrackGroupInfos(DrmSessionManager drmSessionManager, List<AdaptationSet> list, int[][] nArray, int n2, boolean[] blArray, Format[][] formatArray, TrackGroup[] trackGroupArray, TrackGroupInfo[] trackGroupInfoArray) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            Format format;
            int n5;
            int[] nArray2 = nArray[i2];
            Format.Builder builder = new ArrayList();
            int n6 = nArray2.length;
            for (n5 = 0; n5 < n6; ++n5) {
                builder.addAll(list.get((int)nArray2[n5]).representations);
            }
            Object object = new Format[builder.size()];
            for (n5 = 0; n5 < ((Format[])object).length; ++n5) {
                format = ((Representation)builder.get((int)n5)).format;
                object[n5] = format.copyWithExoMediaCryptoType(drmSessionManager.getExoMediaCryptoType(format));
            }
            format = list.get(nArray2[0]);
            n5 = n3 + 1;
            if (blArray[i2]) {
                n4 = n5 + 1;
                n6 = n5;
                n5 = n4;
            } else {
                n6 = -1;
            }
            if (formatArray[i2].length != 0) {
                int n7 = n5 + 1;
                n4 = n5;
                n5 = n7;
            } else {
                n4 = -1;
            }
            trackGroupArray[n3] = new TrackGroup((Format[])object);
            trackGroupInfoArray[n3] = TrackGroupInfo.primaryTrack(format.type, nArray2, n3, n6, n4);
            if (n6 != -1) {
                builder = new Format.Builder();
                object = new StringBuilder();
                ((StringBuilder)object).append(format.id);
                ((StringBuilder)object).append(":emsg");
                trackGroupArray[n6] = new TrackGroup(new Format[]{builder.setId(((StringBuilder)object).toString()).setSampleMimeType("application/x-emsg").build()});
                trackGroupInfoArray[n6] = TrackGroupInfo.embeddedEmsgTrack(nArray2, n3);
            }
            if (n4 != -1) {
                trackGroupArray[n4] = new TrackGroup(formatArray[i2]);
                trackGroupInfoArray[n4] = TrackGroupInfo.embeddedClosedCaptionTrack(nArray2, n3);
            }
            n3 = n5;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ChunkSampleStream<DashChunkSource> buildSampleStream(TrackGroupInfo trackGroupInfo, ExoTrackSelection exoTrackSelection, long l2) {
        TrackGroup trackGroup;
        TrackGroup trackGroup2;
        int n2 = trackGroupInfo.embeddedEventMessageTrackGroupIndex;
        int n3 = 0;
        boolean bl = n2 != -1;
        Object var8_8 = null;
        if (bl) {
            trackGroup2 = this.trackGroups.get(trackGroupInfo.embeddedEventMessageTrackGroupIndex);
            n2 = 1;
        } else {
            trackGroup2 = null;
            n2 = 0;
        }
        int n4 = trackGroupInfo.embeddedClosedCaptionTrackGroupIndex != -1 ? 1 : 0;
        if (n4 != 0) {
            trackGroup = this.trackGroups.get(trackGroupInfo.embeddedClosedCaptionTrackGroupIndex);
            n2 += trackGroup.length;
        } else {
            trackGroup = null;
        }
        Format[] formatArray = new Format[n2];
        int[] nArray = new int[n2];
        if (bl) {
            formatArray[0] = trackGroup2.getFormat(0);
            nArray[0] = 5;
            n2 = 1;
        } else {
            n2 = 0;
        }
        ArrayList<Format> arrayList = new ArrayList<Format>();
        if (n4 != 0) {
            for (n4 = n3; n4 < trackGroup.length; ++n2, ++n4) {
                formatArray[n2] = trackGroup.getFormat(n4);
                nArray[n2] = 3;
                arrayList.add(formatArray[n2]);
            }
        }
        trackGroup2 = var8_8;
        if (this.manifest.dynamic) {
            trackGroup2 = var8_8;
            if (bl) {
                trackGroup2 = this.playerEmsgHandler.newPlayerTrackEmsgHandler();
            }
        }
        exoTrackSelection = this.chunkSourceFactory.createDashChunkSource(this.manifestLoaderErrorThrower, this.manifest, this.periodIndex, trackGroupInfo.adaptationSetIndices, exoTrackSelection, trackGroupInfo.trackType, this.elapsedRealtimeOffsetMs, bl, arrayList, (PlayerEmsgHandler.PlayerTrackEmsgHandler)trackGroup2, this.transferListener);
        trackGroupInfo = new ChunkSampleStream(trackGroupInfo.trackType, nArray, formatArray, (ChunkSource)exoTrackSelection, (SequenceableLoader.Callback)this, this.allocator, l2, this.drmSessionManager, this.drmEventDispatcher, this.loadErrorHandlingPolicy, this.mediaSourceEventDispatcher);
        synchronized (this) {
            this.trackEmsgHandlerBySampleStream.put((ChunkSampleStream<DashChunkSource>)trackGroupInfo, (PlayerEmsgHandler.PlayerTrackEmsgHandler)trackGroup2);
            return trackGroupInfo;
        }
    }

    private static Pair<TrackGroupArray, TrackGroupInfo[]> buildTrackGroups(DrmSessionManager drmSessionManager, List<AdaptationSet> list, List<EventStream> list2) {
        int[][] nArray = DashMediaPeriod.getGroupedAdaptationSetIndices(list);
        int n2 = nArray.length;
        boolean[] blArray = new boolean[n2];
        Format[][] formatArrayArray = new Format[n2][];
        int n3 = DashMediaPeriod.identifyEmbeddedTracks(n2, list, nArray, blArray, formatArrayArray) + n2 + list2.size();
        TrackGroup[] trackGroupArray = new TrackGroup[n3];
        TrackGroupInfo[] trackGroupInfoArray = new TrackGroupInfo[n3];
        DashMediaPeriod.buildManifestEventTrackGroupInfos(list2, trackGroupArray, trackGroupInfoArray, DashMediaPeriod.buildPrimaryAndEmbeddedTrackGroupInfos(drmSessionManager, list, nArray, n2, blArray, formatArrayArray, trackGroupArray, trackGroupInfoArray));
        return Pair.create((Object)new TrackGroupArray(trackGroupArray), (Object)trackGroupInfoArray);
    }

    private static Descriptor findAdaptationSetSwitchingProperty(List<Descriptor> list) {
        return DashMediaPeriod.findDescriptor(list, "urn:mpeg:dash:adaptation-set-switching:2016");
    }

    private static Descriptor findDescriptor(List<Descriptor> list, String string2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Descriptor descriptor = list.get(i2);
            if (!string2.equals(descriptor.schemeIdUri)) continue;
            return descriptor;
        }
        return null;
    }

    private static Descriptor findTrickPlayProperty(List<Descriptor> list) {
        return DashMediaPeriod.findDescriptor(list, "http://dashif.org/guidelines/trickmode");
    }

    private static Format[] getClosedCaptionTrackFormats(List<AdaptationSet> object, int[] object2) {
        int n2 = ((int[])object2).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = object2[i2];
            AdaptationSet adaptationSet = object.get(n3);
            List list = object.get((int)n3).accessibilityDescriptors;
            for (n3 = 0; n3 < list.size(); ++n3) {
                Descriptor descriptor = (Descriptor)list.get(n3);
                if ("urn:scte:dash:cc:cea-608:2015".equals(descriptor.schemeIdUri)) {
                    object = new Format.Builder().setSampleMimeType("application/cea-608");
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(adaptationSet.id);
                    ((StringBuilder)object2).append(":cea608");
                    object = object.setId(((StringBuilder)object2).toString()).build();
                    return DashMediaPeriod.parseClosedCaptionDescriptor(descriptor, CEA608_SERVICE_DESCRIPTOR_REGEX, (Format)object);
                }
                if (!"urn:scte:dash:cc:cea-708:2015".equals(descriptor.schemeIdUri)) continue;
                object2 = new Format.Builder().setSampleMimeType("application/cea-708");
                object = new StringBuilder();
                ((StringBuilder)object).append(adaptationSet.id);
                ((StringBuilder)object).append(":cea708");
                object = object2.setId(((StringBuilder)object).toString()).build();
                return DashMediaPeriod.parseClosedCaptionDescriptor(descriptor, CEA708_SERVICE_DESCRIPTOR_REGEX, (Format)object);
            }
        }
        return new Format[0];
    }

    private static int[][] getGroupedAdaptationSetIndices(List<AdaptationSet> object) {
        Object object2;
        int n2;
        int n3 = object.size();
        SparseIntArray sparseIntArray = new SparseIntArray(n3);
        ArrayList<String[]> arrayList = new ArrayList<String[]>(n3);
        SparseArray sparseArray = new SparseArray(n3);
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            sparseIntArray.put(object.get((int)n2).id, n2);
            object2 = new ArrayList();
            object2.add(n2);
            arrayList.add((String[])object2);
            sparseArray.put(n2, object2);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            AdaptationSet adaptationSet = object.get(i2);
            Object object3 = DashMediaPeriod.findTrickPlayProperty(adaptationSet.essentialProperties);
            object2 = object3;
            if (object3 == null) {
                object2 = DashMediaPeriod.findTrickPlayProperty(adaptationSet.supplementalProperties);
            }
            if (object2 == null || (n2 = sparseIntArray.get(Integer.parseInt(((Descriptor)object2).value), -1)) == -1) {
                n2 = i2;
            }
            int n5 = n2;
            if (n2 == i2) {
                object2 = DashMediaPeriod.findAdaptationSetSwitchingProperty(adaptationSet.supplementalProperties);
                n5 = n2;
                if (object2 != null) {
                    object2 = Util.split(((Descriptor)object2).value, ",");
                    int n6 = ((String[])object2).length;
                    for (int i3 = 0; i3 < n6; ++i3) {
                        int n7 = sparseIntArray.get(Integer.parseInt((String)object2[i3]), -1);
                        n5 = n2;
                        if (n7 != -1) {
                            n5 = Math.min(n2, n7);
                        }
                        n2 = n5;
                    }
                    n5 = n2;
                }
            }
            if (n5 == i2) continue;
            object3 = (List)sparseArray.get(i2);
            object2 = (List)sparseArray.get(n5);
            object2.addAll(object3);
            sparseArray.put(i2, object2);
            arrayList.remove(object3);
        }
        object = new int[arrayList.size()][];
        for (n2 = n4; n2 < ((Object)object).length; ++n2) {
            object[n2] = Ints.toArray((Collection)arrayList.get(n2));
            Arrays.sort((int[])object[n2]);
        }
        return object;
    }

    private int getPrimaryStreamIndex(int n2, int[] nArray) {
        if ((n2 = nArray[n2]) == -1) {
            return -1;
        }
        int n3 = this.trackGroupInfos[n2].primaryTrackGroupIndex;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            if (n4 != n3 || this.trackGroupInfos[n4].trackGroupCategory != 0) continue;
            return n2;
        }
        return -1;
    }

    private int[] getStreamIndexToTrackGroupIndex(ExoTrackSelection[] exoTrackSelectionArray) {
        int[] nArray = new int[exoTrackSelectionArray.length];
        for (int i2 = 0; i2 < exoTrackSelectionArray.length; ++i2) {
            nArray[i2] = exoTrackSelectionArray[i2] != null ? this.trackGroups.indexOf(exoTrackSelectionArray[i2].getTrackGroup()) : -1;
        }
        return nArray;
    }

    private static boolean hasEventMessageTrack(List<AdaptationSet> list, int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            List list2 = list.get((int)nArray[i2]).representations;
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                if (((Representation)list2.get((int)i3)).inbandEventStreams.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private static int identifyEmbeddedTracks(int n2, List<AdaptationSet> list, int[][] nArray, boolean[] blArray, Format[][] formatArray) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = n3;
            if (DashMediaPeriod.hasEventMessageTrack(list, nArray[i2])) {
                blArray[i2] = true;
                n4 = n3 + 1;
            }
            formatArray[i2] = DashMediaPeriod.getClosedCaptionTrackFormats(list, nArray[i2]);
            n3 = n4;
            if (formatArray[i2].length == 0) continue;
            n3 = n4 + 1;
        }
        return n3;
    }

    private static ChunkSampleStream<DashChunkSource>[] newSampleStreamArray(int n2) {
        return new ChunkSampleStream[n2];
    }

    private static Format[] parseClosedCaptionDescriptor(Descriptor object, Pattern pattern, Format format) {
        object = ((Descriptor)object).value;
        if (object == null) {
            return new Format[]{format};
        }
        String[] stringArray = Util.split((String)object, ";");
        Format[] formatArray = new Format[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Matcher matcher = pattern.matcher(stringArray[i2]);
            if (!matcher.matches()) {
                return new Format[]{format};
            }
            int n2 = Integer.parseInt(matcher.group(1));
            Format.Builder builder = format.buildUpon();
            object = new StringBuilder();
            ((StringBuilder)object).append(format.id);
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(n2);
            formatArray[i2] = builder.setId(((StringBuilder)object).toString()).setAccessibilityChannel(n2).setLanguage(matcher.group(2)).build();
        }
        return formatArray;
    }

    private void releaseDisabledStreams(ExoTrackSelection[] exoTrackSelectionArray, boolean[] blArray, SampleStream[] sampleStreamArray) {
        for (int i2 = 0; i2 < exoTrackSelectionArray.length; ++i2) {
            if (exoTrackSelectionArray[i2] != null && blArray[i2]) continue;
            if (sampleStreamArray[i2] instanceof ChunkSampleStream) {
                ((ChunkSampleStream)sampleStreamArray[i2]).release((ChunkSampleStream.ReleaseCallback)this);
            } else if (sampleStreamArray[i2] instanceof ChunkSampleStream.EmbeddedSampleStream) {
                ((ChunkSampleStream.EmbeddedSampleStream)sampleStreamArray[i2]).release();
            }
            sampleStreamArray[i2] = null;
        }
    }

    private void releaseOrphanEmbeddedStreams(ExoTrackSelection[] exoTrackSelectionArray, SampleStream[] sampleStreamArray, int[] nArray) {
        for (int i2 = 0; i2 < exoTrackSelectionArray.length; ++i2) {
            int n2;
            boolean bl;
            if (!(sampleStreamArray[i2] instanceof EmptySampleStream) && !(sampleStreamArray[i2] instanceof ChunkSampleStream.EmbeddedSampleStream) || (bl = (n2 = this.getPrimaryStreamIndex(i2, nArray)) == -1 ? sampleStreamArray[i2] instanceof EmptySampleStream : sampleStreamArray[i2] instanceof ChunkSampleStream.EmbeddedSampleStream && ((ChunkSampleStream.EmbeddedSampleStream)sampleStreamArray[i2]).parent == sampleStreamArray[n2])) continue;
            if (sampleStreamArray[i2] instanceof ChunkSampleStream.EmbeddedSampleStream) {
                ((ChunkSampleStream.EmbeddedSampleStream)sampleStreamArray[i2]).release();
            }
            sampleStreamArray[i2] = null;
        }
    }

    private void selectNewStreams(ExoTrackSelection[] exoTrackSelectionArray, SampleStream[] sampleStreamArray, boolean[] object, long l2, int[] nArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n4 >= exoTrackSelectionArray.length) break;
            ExoTrackSelection exoTrackSelection = exoTrackSelectionArray[n4];
            if (exoTrackSelection != null) {
                if (sampleStreamArray[n4] == null) {
                    object[n4] = true;
                    n2 = nArray[n4];
                    TrackGroupInfo trackGroupInfo = this.trackGroupInfos[n2];
                    if (trackGroupInfo.trackGroupCategory == 0) {
                        sampleStreamArray[n4] = this.buildSampleStream(trackGroupInfo, exoTrackSelection, l2);
                    } else if (trackGroupInfo.trackGroupCategory == 2) {
                        sampleStreamArray[n4] = new EventSampleStream(this.eventStreams.get(trackGroupInfo.eventStreamGroupIndex), exoTrackSelection.getTrackGroup().getFormat(0), this.manifest.dynamic);
                    }
                } else if (sampleStreamArray[n4] instanceof ChunkSampleStream) {
                    ((DashChunkSource)((ChunkSampleStream)sampleStreamArray[n4]).getChunkSource()).updateTrackSelection(exoTrackSelection);
                }
            }
            ++n4;
        }
        for (n2 = n3; n2 < exoTrackSelectionArray.length; ++n2) {
            if (sampleStreamArray[n2] != null || exoTrackSelectionArray[n2] == null) continue;
            n4 = nArray[n2];
            object = this.trackGroupInfos[n4];
            if (object.trackGroupCategory != 1) continue;
            n4 = this.getPrimaryStreamIndex(n2, nArray);
            sampleStreamArray[n2] = n4 == -1 ? new EmptySampleStream() : ((ChunkSampleStream)sampleStreamArray[n4]).selectEmbeddedTrack(l2, object.trackType);
        }
    }

    @Override
    public boolean continueLoading(long l2) {
        return this.compositeSequenceableLoader.continueLoading(l2);
    }

    @Override
    public void discardBuffer(long l2, boolean bl) {
        ChunkSampleStream<DashChunkSource>[] chunkSampleStreamArray = this.sampleStreams;
        int n2 = chunkSampleStreamArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            chunkSampleStreamArray[i2].discardBuffer(l2, bl);
        }
    }

    @Override
    public long getAdjustedSeekPositionUs(long l2, SeekParameters seekParameters) {
        for (ChunkSampleStream<DashChunkSource> chunkSampleStream : this.sampleStreams) {
            if (chunkSampleStream.primaryTrackType != 2) continue;
            return chunkSampleStream.getAdjustedSeekPositionUs(l2, seekParameters);
        }
        return l2;
    }

    @Override
    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    @Override
    public List<StreamKey> getStreamKeys(List<ExoTrackSelection> exoTrackSelection2) {
        List list = this.manifest.getPeriod((int)this.periodIndex).adaptationSets;
        ArrayList<StreamKey> arrayList = new ArrayList<StreamKey>();
        for (ExoTrackSelection exoTrackSelection2 : exoTrackSelection2) {
            int n2 = this.trackGroups.indexOf(exoTrackSelection2.getTrackGroup());
            Object object = this.trackGroupInfos[n2];
            if (((TrackGroupInfo)object).trackGroupCategory != 0) continue;
            object = ((TrackGroupInfo)object).adaptationSetIndices;
            int[] nArray = new int[exoTrackSelection2.length()];
            int n3 = 0;
            for (n2 = 0; n2 < exoTrackSelection2.length(); ++n2) {
                nArray[n2] = exoTrackSelection2.getIndexInTrackGroup(n2);
            }
            Arrays.sort(nArray);
            int n4 = ((AdaptationSet)list.get((int)object[0])).representations.size();
            int n5 = nArray.length;
            int n6 = 0;
            int n7 = 0;
            n2 = n3;
            n3 = n6;
            while (n2 < n5) {
                int n8 = nArray[n2];
                while (n8 >= (n6 = n7 + n4)) {
                    n4 = ((AdaptationSet)list.get((int)object[++n3])).representations.size();
                    n7 = n6;
                }
                arrayList.add(new StreamKey(this.periodIndex, (int)object[n3], n8 - n7));
                ++n2;
            }
        }
        return arrayList;
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    @Override
    public boolean isLoading() {
        return this.compositeSequenceableLoader.isLoading();
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    @Override
    public void onContinueLoadingRequested(ChunkSampleStream<DashChunkSource> chunkSampleStream) {
        this.callback.onContinueLoadingRequested(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSampleStreamReleased(ChunkSampleStream<DashChunkSource> playerTrackEmsgHandler) {
        synchronized (this) {
            playerTrackEmsgHandler = this.trackEmsgHandlerBySampleStream.remove(playerTrackEmsgHandler);
            if (playerTrackEmsgHandler != null) {
                playerTrackEmsgHandler.release();
            }
            return;
        }
    }

    @Override
    public void prepare(MediaPeriod.Callback callback2, long l2) {
        this.callback = callback2;
        callback2.onPrepared(this);
    }

    @Override
    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    @Override
    public void reevaluateBuffer(long l2) {
        this.compositeSequenceableLoader.reevaluateBuffer(l2);
    }

    public void release() {
        this.playerEmsgHandler.release();
        ChunkSampleStream<DashChunkSource>[] chunkSampleStreamArray = this.sampleStreams;
        int n2 = chunkSampleStreamArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            chunkSampleStreamArray[i2].release((ChunkSampleStream.ReleaseCallback)this);
        }
        this.callback = null;
    }

    @Override
    public long seekToUs(long l2) {
        int n2;
        ChunkSampleStream<DashChunkSource>[] chunkSampleStreamArray = this.sampleStreams;
        int n3 = chunkSampleStreamArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            chunkSampleStreamArray[n2].seekToUs(l2);
        }
        chunkSampleStreamArray = this.eventSampleStreams;
        n3 = chunkSampleStreamArray.length;
        for (n2 = n4; n2 < n3; ++n2) {
            chunkSampleStreamArray[n2].seekToUs(l2);
        }
        return l2;
    }

    @Override
    public long selectTracks(ExoTrackSelection[] object, boolean[] object2, SampleStream[] sampleStreamArray, boolean[] object3, long l2) {
        int[] nArray = this.getStreamIndexToTrackGroupIndex((ExoTrackSelection[])object);
        this.releaseDisabledStreams((ExoTrackSelection[])object, (boolean[])object2, sampleStreamArray);
        this.releaseOrphanEmbeddedStreams((ExoTrackSelection[])object, sampleStreamArray, nArray);
        this.selectNewStreams((ExoTrackSelection[])object, sampleStreamArray, (boolean[])object3, l2, nArray);
        object = new ArrayList();
        object3 = new ArrayList();
        int n2 = sampleStreamArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = sampleStreamArray[i2];
            if (object2 instanceof ChunkSampleStream) {
                ((ArrayList)object).add((ChunkSampleStream)object2);
                continue;
            }
            if (!(object2 instanceof EventSampleStream)) continue;
            ((ArrayList)object3).add((EventSampleStream)object2);
        }
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(((ArrayList)object).size());
        ((ArrayList)object).toArray(this.sampleStreams);
        this.eventSampleStreams = new EventSampleStream[((ArrayList)object3).size()];
        ((ArrayList)object3).toArray(this.eventSampleStreams);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        return l2;
    }

    public void updateManifest(DashManifest dashManifest, int n2) {
        this.manifest = dashManifest;
        this.periodIndex = n2;
        this.playerEmsgHandler.updateManifest(dashManifest);
        EventStream eventStream2 = this.sampleStreams;
        if (eventStream2 != null) {
            int n3 = ((ChunkSampleStream<DashChunkSource>[])eventStream2).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                ((DashChunkSource)eventStream2[i2].getChunkSource()).updateManifest(dashManifest, n2);
            }
            this.callback.onContinueLoadingRequested(this);
        }
        this.eventStreams = dashManifest.getPeriod((int)n2).eventStreams;
        block1: for (EventSampleStream eventSampleStream : this.eventSampleStreams) {
            for (EventStream eventStream2 : this.eventStreams) {
                if (!eventStream2.id().equals(eventSampleStream.eventStreamId())) continue;
                int n4 = dashManifest.getPeriodCount();
                boolean bl = true;
                if (!dashManifest.dynamic || n2 != n4 - 1) {
                    bl = false;
                }
                eventSampleStream.updateEventStream(eventStream2, bl);
                continue block1;
            }
        }
    }

    private static final class TrackGroupInfo {
        private static final int CATEGORY_EMBEDDED = 1;
        private static final int CATEGORY_MANIFEST_EVENTS = 2;
        private static final int CATEGORY_PRIMARY = 0;
        public final int[] adaptationSetIndices;
        public final int embeddedClosedCaptionTrackGroupIndex;
        public final int embeddedEventMessageTrackGroupIndex;
        public final int eventStreamGroupIndex;
        public final int primaryTrackGroupIndex;
        public final int trackGroupCategory;
        public final int trackType;

        private TrackGroupInfo(int n2, int n3, int[] nArray, int n4, int n5, int n6, int n7) {
            this.trackType = n2;
            this.adaptationSetIndices = nArray;
            this.trackGroupCategory = n3;
            this.primaryTrackGroupIndex = n4;
            this.embeddedEventMessageTrackGroupIndex = n5;
            this.embeddedClosedCaptionTrackGroupIndex = n6;
            this.eventStreamGroupIndex = n7;
        }

        public static TrackGroupInfo embeddedClosedCaptionTrack(int[] nArray, int n2) {
            return new TrackGroupInfo(3, 1, nArray, n2, -1, -1, -1);
        }

        public static TrackGroupInfo embeddedEmsgTrack(int[] nArray, int n2) {
            return new TrackGroupInfo(5, 1, nArray, n2, -1, -1, -1);
        }

        public static TrackGroupInfo mpdEventTrack(int n2) {
            return new TrackGroupInfo(5, 2, new int[0], -1, -1, -1, n2);
        }

        public static TrackGroupInfo primaryTrack(int n2, int[] nArray, int n3, int n4, int n5) {
            return new TrackGroupInfo(n2, 0, nArray, n3, n4, n5, -1);
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TrackGroupCategory {
        }
    }
}

