/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import android.util.SparseArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.chunk.ChunkExtractor;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class BundledChunkExtractor
implements ExtractorOutput,
ChunkExtractor {
    private static final PositionHolder POSITION_HOLDER = new PositionHolder();
    private final SparseArray<BindingTrackOutput> bindingTrackOutputs;
    private long endTimeUs;
    private final Extractor extractor;
    private boolean extractorInitialized;
    private final Format primaryTrackManifestFormat;
    private final int primaryTrackType;
    private Format[] sampleFormats;
    private SeekMap seekMap;
    private ChunkExtractor.TrackOutputProvider trackOutputProvider;

    public BundledChunkExtractor(Extractor extractor, int n2, Format format) {
        this.extractor = extractor;
        this.primaryTrackType = n2;
        this.primaryTrackManifestFormat = format;
        this.bindingTrackOutputs = new SparseArray();
    }

    @Override
    public void endTracks() {
        Format[] formatArray = new Format[this.bindingTrackOutputs.size()];
        for (int i2 = 0; i2 < this.bindingTrackOutputs.size(); ++i2) {
            formatArray[i2] = Assertions.checkStateNotNull(((BindingTrackOutput)this.bindingTrackOutputs.valueAt((int)i2)).sampleFormat);
        }
        this.sampleFormats = formatArray;
    }

    public ChunkIndex getChunkIndex() {
        SeekMap seekMap = this.seekMap;
        seekMap = seekMap instanceof ChunkIndex ? (ChunkIndex)seekMap : null;
        return seekMap;
    }

    public Format[] getSampleFormats() {
        return this.sampleFormats;
    }

    public void init(ChunkExtractor.TrackOutputProvider trackOutputProvider, long l2, long l3) {
        this.trackOutputProvider = trackOutputProvider;
        this.endTimeUs = l3;
        if (!this.extractorInitialized) {
            this.extractor.init(this);
            if (l2 != -9223372036854775807L) {
                this.extractor.seek(0L, l2);
            }
            this.extractorInitialized = true;
        } else {
            Extractor extractor = this.extractor;
            long l4 = l2;
            if (l2 == -9223372036854775807L) {
                l4 = 0L;
            }
            extractor.seek(0L, l4);
            for (int i2 = 0; i2 < this.bindingTrackOutputs.size(); ++i2) {
                ((BindingTrackOutput)this.bindingTrackOutputs.valueAt(i2)).bind(trackOutputProvider, l3);
            }
        }
    }

    public boolean read(ExtractorInput extractorInput) throws IOException {
        int n2 = this.extractor.read(extractorInput, POSITION_HOLDER);
        boolean bl = false;
        boolean bl2 = n2 != 1;
        Assertions.checkState(bl2);
        bl2 = bl;
        if (n2 == 0) {
            bl2 = true;
        }
        return bl2;
    }

    public void release() {
        this.extractor.release();
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
    }

    @Override
    public TrackOutput track(int n2, int n3) {
        BindingTrackOutput bindingTrackOutput;
        BindingTrackOutput bindingTrackOutput2 = bindingTrackOutput = (BindingTrackOutput)this.bindingTrackOutputs.get(n2);
        if (bindingTrackOutput == null) {
            boolean bl = this.sampleFormats == null;
            Assertions.checkState(bl);
            bindingTrackOutput2 = n3 == this.primaryTrackType ? this.primaryTrackManifestFormat : null;
            bindingTrackOutput2 = new BindingTrackOutput(n2, n3, (Format)bindingTrackOutput2);
            bindingTrackOutput2.bind(this.trackOutputProvider, this.endTimeUs);
            this.bindingTrackOutputs.put(n2, (Object)bindingTrackOutput2);
        }
        return bindingTrackOutput2;
    }

    private static final class BindingTrackOutput
    implements TrackOutput {
        private long endTimeUs;
        private final DummyTrackOutput fakeTrackOutput;
        private final int id;
        private final Format manifestFormat;
        public Format sampleFormat;
        private TrackOutput trackOutput;
        private final int type;

        public BindingTrackOutput(int n2, int n3, Format format) {
            this.id = n2;
            this.type = n3;
            this.manifestFormat = format;
            this.fakeTrackOutput = new DummyTrackOutput();
        }

        public void bind(ChunkExtractor.TrackOutputProvider trackOutputProvider, long l2) {
            if (trackOutputProvider == null) {
                this.trackOutput = this.fakeTrackOutput;
                return;
            }
            this.endTimeUs = l2;
            this.trackOutput = trackOutputProvider.track(this.id, this.type);
            trackOutputProvider = this.sampleFormat;
            if (trackOutputProvider != null) {
                this.trackOutput.format((Format)trackOutputProvider);
            }
        }

        @Override
        public void format(Format format) {
            Format format2 = this.manifestFormat;
            Format format3 = format;
            if (format2 != null) {
                format3 = format.withManifestFormatInfo(format2);
            }
            this.sampleFormat = format3;
            Util.castNonNull(this.trackOutput).format(this.sampleFormat);
        }

        @Override
        public /* synthetic */ int sampleData(DataReader dataReader, int n2, boolean bl) throws IOException {
            return TrackOutput._CC.$default$sampleData((TrackOutput)this, (DataReader)dataReader, (int)n2, (boolean)bl);
        }

        @Override
        public int sampleData(DataReader dataReader, int n2, boolean bl, int n3) throws IOException {
            return Util.castNonNull(this.trackOutput).sampleData(dataReader, n2, bl);
        }

        @Override
        public /* synthetic */ void sampleData(ParsableByteArray parsableByteArray, int n2) {
            TrackOutput._CC.$default$sampleData((TrackOutput)this, (ParsableByteArray)parsableByteArray, (int)n2);
        }

        @Override
        public void sampleData(ParsableByteArray parsableByteArray, int n2, int n3) {
            Util.castNonNull(this.trackOutput).sampleData(parsableByteArray, n2);
        }

        @Override
        public void sampleMetadata(long l2, int n2, int n3, int n4, TrackOutput.CryptoData cryptoData) {
            long l3 = this.endTimeUs;
            if (l3 != -9223372036854775807L && l2 >= l3) {
                this.trackOutput = this.fakeTrackOutput;
            }
            Util.castNonNull(this.trackOutput).sampleMetadata(l2, n2, n3, n4, cryptoData);
        }
    }
}

