/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.ads;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MaskingMediaPeriod;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.SinglePeriodAdTimeline;
import com.google.android.exoplayer2.source.ads._$;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AdsMediaSource
extends CompositeMediaSource<MediaSource.MediaPeriodId> {
    private static final MediaSource.MediaPeriodId CHILD_SOURCE_MEDIA_PERIOD_ID = new MediaSource.MediaPeriodId(new Object());
    private final MediaSourceFactory adMediaSourceFactory;
    private AdMediaSourceHolder[][] adMediaSourceHolders;
    private AdPlaybackState adPlaybackState;
    private final DataSpec adTagDataSpec;
    private final AdsLoader.AdViewProvider adViewProvider;
    private final Object adsId;
    private final AdsLoader adsLoader;
    private ComponentListener componentListener;
    private final MediaSource contentMediaSource;
    private Timeline contentTimeline;
    private final Handler mainHandler;
    private final Timeline.Period period;

    public AdsMediaSource(MediaSource mediaSource, DataSpec dataSpec, Object object, MediaSourceFactory mediaSourceFactory, AdsLoader adsLoader, AdsLoader.AdViewProvider adViewProvider) {
        this.contentMediaSource = mediaSource;
        this.adMediaSourceFactory = mediaSourceFactory;
        this.adsLoader = adsLoader;
        this.adViewProvider = adViewProvider;
        this.adTagDataSpec = dataSpec;
        this.adsId = object;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.period = new Timeline.Period();
        this.adMediaSourceHolders = new AdMediaSourceHolder[0][];
        adsLoader.setSupportedContentTypes(mediaSourceFactory.getSupportedTypes());
    }

    private long[][] getAdDurationsUs() {
        Object object;
        long[][] lArrayArray = new long[this.adMediaSourceHolders.length][];
        for (int i2 = 0; i2 < ((AdMediaSourceHolder[][])(object = this.adMediaSourceHolders)).length; ++i2) {
            lArrayArray[i2] = new long[object[i2].length];
            for (int i3 = 0; i3 < (object = this.adMediaSourceHolders)[i2].length; ++i3) {
                object = object[i2][i3];
                long[] lArray = lArrayArray[i2];
                long l2 = object == null ? -9223372036854775807L : ((AdMediaSourceHolder)object).getDurationUs();
                lArray[i3] = l2;
            }
        }
        return lArrayArray;
    }

    private void maybeUpdateAdMediaSources() {
        AdPlaybackState adPlaybackState = this.adPlaybackState;
        if (adPlaybackState == null) {
            return;
        }
        for (int i2 = 0; i2 < this.adMediaSourceHolders.length; ++i2) {
            Uri uri;
            for (int i3 = 0; i3 < (uri = this.adMediaSourceHolders)[i2].length; ++i3) {
                AdMediaSourceHolder adMediaSourceHolder = uri[i2][i3];
                if (adMediaSourceHolder == null || adMediaSourceHolder.hasMediaSource() || adPlaybackState.adGroups[i2] == null || i3 >= adPlaybackState.adGroups[i2].uris.length || (uri = adPlaybackState.adGroups[i2].uris[i3]) == null) continue;
                MediaItem.Builder builder = new MediaItem.Builder().setUri(uri);
                MediaItem.PlaybackProperties playbackProperties = this.contentMediaSource.getMediaItem().playbackProperties;
                if (playbackProperties != null && playbackProperties.drmConfiguration != null) {
                    playbackProperties = playbackProperties.drmConfiguration;
                    builder.setDrmUuid(playbackProperties.uuid);
                    builder.setDrmKeySetId(playbackProperties.getKeySetId());
                    builder.setDrmLicenseUri(playbackProperties.licenseUri);
                    builder.setDrmForceDefaultLicenseUri(playbackProperties.forceDefaultLicenseUri);
                    builder.setDrmLicenseRequestHeaders(playbackProperties.requestHeaders);
                    builder.setDrmMultiSession(playbackProperties.multiSession);
                    builder.setDrmPlayClearContentWithoutKey(playbackProperties.playClearContentWithoutKey);
                    builder.setDrmSessionForClearTypes(playbackProperties.sessionForClearTypes);
                }
                adMediaSourceHolder.initializeWithMediaSource(this.adMediaSourceFactory.createMediaSource(builder.build()), uri);
            }
        }
    }

    private void maybeUpdateSourceInfo() {
        Timeline timeline = this.contentTimeline;
        AdPlaybackState adPlaybackState = this.adPlaybackState;
        if (adPlaybackState != null && timeline != null) {
            if (adPlaybackState.adGroupCount == 0) {
                this.refreshSourceInfo(timeline);
            } else {
                this.adPlaybackState = this.adPlaybackState.withAdDurationsUs(this.getAdDurationsUs());
                this.refreshSourceInfo((Timeline)new SinglePeriodAdTimeline(timeline, this.adPlaybackState));
            }
        }
    }

    private void onAdPlaybackState(AdPlaybackState adPlaybackState) {
        AdPlaybackState adPlaybackState2 = this.adPlaybackState;
        boolean bl = false;
        if (adPlaybackState2 == null) {
            this.adMediaSourceHolders = new AdMediaSourceHolder[adPlaybackState.adGroupCount][];
            Arrays.fill((Object[])this.adMediaSourceHolders, new AdMediaSourceHolder[0]);
        } else {
            if (adPlaybackState.adGroupCount == this.adPlaybackState.adGroupCount) {
                bl = true;
            }
            Assertions.checkState(bl);
        }
        this.adPlaybackState = adPlaybackState;
        this.maybeUpdateAdMediaSources();
        this.maybeUpdateSourceInfo();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId mediaPeriodId, Allocator allocator, long l2) {
        if (Assertions.checkNotNull(this.adPlaybackState).adGroupCount > 0 && mediaPeriodId.isAd()) {
            Object object = this.adMediaSourceHolders;
            int n2 = mediaPeriodId.adGroupIndex;
            int n3 = mediaPeriodId.adIndexInAdGroup;
            if (object[n2].length <= n3) {
                object[n2] = Arrays.copyOf(object[n2], n3 + 1);
            }
            AdMediaSourceHolder adMediaSourceHolder = this.adMediaSourceHolders[n2][n3];
            object = adMediaSourceHolder;
            if (adMediaSourceHolder == null) {
                this.adMediaSourceHolders[n2][n3] = object = new AdMediaSourceHolder(mediaPeriodId);
                this.maybeUpdateAdMediaSources();
            }
            return ((AdMediaSourceHolder)object).createMediaPeriod(mediaPeriodId, allocator, l2);
        }
        allocator = new MaskingMediaPeriod(mediaPeriodId, allocator, l2);
        allocator.setMediaSource(this.contentMediaSource);
        allocator.createPeriod(mediaPeriodId);
        return allocator;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.contentMediaSource.getMediaItem();
    }

    @Override
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSource.MediaPeriodId mediaPeriodId, MediaSource.MediaPeriodId mediaPeriodId2) {
        if (!mediaPeriodId.isAd()) {
            mediaPeriodId = mediaPeriodId2;
        }
        return mediaPeriodId;
    }

    @Override
    @Deprecated
    public Object getTag() {
        return this.contentMediaSource.getTag();
    }

    public /* synthetic */ void lambda$prepareSourceInternal$0$AdsMediaSource(ComponentListener componentListener) {
        this.adsLoader.start(this, this.adTagDataSpec, this.adsId, this.adViewProvider, componentListener);
    }

    public /* synthetic */ void lambda$releaseSourceInternal$1$AdsMediaSource(ComponentListener componentListener) {
        this.adsLoader.stop(this, componentListener);
    }

    @Override
    protected void onChildSourceInfoRefreshed(MediaSource.MediaPeriodId mediaPeriodId, MediaSource mediaSource, Timeline timeline) {
        if (mediaPeriodId.isAd()) {
            int n2 = mediaPeriodId.adGroupIndex;
            int n3 = mediaPeriodId.adIndexInAdGroup;
            Assertions.checkNotNull(this.adMediaSourceHolders[n2][n3]).handleSourceInfoRefresh(timeline);
        } else {
            int n4 = timeline.getPeriodCount();
            boolean bl = true;
            if (n4 != 1) {
                bl = false;
            }
            Assertions.checkArgument(bl);
            this.contentTimeline = timeline;
        }
        this.maybeUpdateSourceInfo();
    }

    @Override
    protected void prepareSourceInternal(TransferListener object) {
        super.prepareSourceInternal((TransferListener)object);
        object = new ComponentListener();
        this.componentListener = object;
        this.prepareChildSource(CHILD_SOURCE_MEDIA_PERIOD_ID, this.contentMediaSource);
        this.mainHandler.post((Runnable)new _$.Lambda.AdsMediaSource.zcXBZahV9F_k_KJACPO_bl_WWX0(this, (ComponentListener)object));
    }

    @Override
    public void releasePeriod(MediaPeriod object) {
        MaskingMediaPeriod maskingMediaPeriod = (MaskingMediaPeriod)object;
        object = maskingMediaPeriod.id;
        if (object.isAd()) {
            AdMediaSourceHolder adMediaSourceHolder = Assertions.checkNotNull(this.adMediaSourceHolders[((MediaSource.MediaPeriodId)((Object)object)).adGroupIndex][((MediaSource.MediaPeriodId)((Object)object)).adIndexInAdGroup]);
            adMediaSourceHolder.releaseMediaPeriod(maskingMediaPeriod);
            if (adMediaSourceHolder.isInactive()) {
                adMediaSourceHolder.release();
                this.adMediaSourceHolders[((MediaSource.MediaPeriodId)((Object)object)).adGroupIndex][((MediaSource.MediaPeriodId)((Object)object)).adIndexInAdGroup] = null;
            }
        } else {
            maskingMediaPeriod.releasePeriod();
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        ComponentListener componentListener = Assertions.checkNotNull(this.componentListener);
        this.componentListener = null;
        componentListener.stop();
        this.contentTimeline = null;
        this.adPlaybackState = null;
        this.adMediaSourceHolders = new AdMediaSourceHolder[0][];
        this.mainHandler.post((Runnable)new _$.Lambda.AdsMediaSource.4aMSO39zZ_2Ojc5az8RW_qLlkmQ(this, componentListener));
    }

    public static final class AdLoadException
    extends IOException {
        public static final int TYPE_AD = 0;
        public static final int TYPE_AD_GROUP = 1;
        public static final int TYPE_ALL_ADS = 2;
        public static final int TYPE_UNEXPECTED = 3;
        public final int type;

        private AdLoadException(int n2, Exception exception) {
            super(exception);
            this.type = n2;
        }

        public static AdLoadException createForAd(Exception exception) {
            return new AdLoadException(0, exception);
        }

        public static AdLoadException createForAdGroup(Exception exception, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to load ad group ");
            stringBuilder.append(n2);
            return new AdLoadException(1, new IOException(stringBuilder.toString(), exception));
        }

        public static AdLoadException createForAllAds(Exception exception) {
            return new AdLoadException(2, exception);
        }

        public static AdLoadException createForUnexpected(RuntimeException runtimeException) {
            return new AdLoadException(3, runtimeException);
        }

        public RuntimeException getRuntimeExceptionForUnexpected() {
            boolean bl = this.type == 3;
            Assertions.checkState(bl);
            return (RuntimeException)Assertions.checkNotNull(this.getCause());
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }

    private final class AdMediaSourceHolder {
        private final List<MaskingMediaPeriod> activeMediaPeriods;
        private MediaSource adMediaSource;
        private Uri adUri;
        private final MediaSource.MediaPeriodId id;
        private Timeline timeline;

        public AdMediaSourceHolder(MediaSource.MediaPeriodId mediaPeriodId) {
            this.id = mediaPeriodId;
            this.activeMediaPeriods = new ArrayList<MaskingMediaPeriod>();
        }

        public MediaPeriod createMediaPeriod(MediaSource.MediaPeriodId mediaPeriodId, Allocator allocator, long l2) {
            allocator = new MaskingMediaPeriod(mediaPeriodId, allocator, l2);
            this.activeMediaPeriods.add((MaskingMediaPeriod)allocator);
            MediaSource mediaSource = this.adMediaSource;
            if (mediaSource != null) {
                allocator.setMediaSource(mediaSource);
                allocator.setPrepareListener((MaskingMediaPeriod.PrepareListener)new AdPrepareListener(Assertions.checkNotNull(this.adUri)));
            }
            if ((mediaSource = this.timeline) != null) {
                allocator.createPeriod(new MediaSource.MediaPeriodId(mediaSource.getUidOfPeriod(0), mediaPeriodId.windowSequenceNumber));
            }
            return allocator;
        }

        public long getDurationUs() {
            Timeline timeline = this.timeline;
            long l2 = timeline == null ? -9223372036854775807L : timeline.getPeriod(0, AdsMediaSource.this.period).getDurationUs();
            return l2;
        }

        public void handleSourceInfoRefresh(Timeline timeline) {
            int n2 = timeline.getPeriodCount();
            int n3 = 0;
            boolean bl = true;
            if (n2 != 1) {
                bl = false;
            }
            Assertions.checkArgument(bl);
            if (this.timeline == null) {
                Object object = timeline.getUidOfPeriod(0);
                while (n3 < this.activeMediaPeriods.size()) {
                    MaskingMediaPeriod maskingMediaPeriod = this.activeMediaPeriods.get(n3);
                    maskingMediaPeriod.createPeriod(new MediaSource.MediaPeriodId(object, maskingMediaPeriod.id.windowSequenceNumber));
                    ++n3;
                }
            }
            this.timeline = timeline;
        }

        public boolean hasMediaSource() {
            boolean bl = this.adMediaSource != null;
            return bl;
        }

        public void initializeWithMediaSource(MediaSource mediaSource, Uri uri) {
            this.adMediaSource = mediaSource;
            this.adUri = uri;
            for (int i2 = 0; i2 < this.activeMediaPeriods.size(); ++i2) {
                MaskingMediaPeriod maskingMediaPeriod = this.activeMediaPeriods.get(i2);
                maskingMediaPeriod.setMediaSource(mediaSource);
                maskingMediaPeriod.setPrepareListener((MaskingMediaPeriod.PrepareListener)new AdPrepareListener(uri));
            }
            AdsMediaSource.this.prepareChildSource((Object)this.id, mediaSource);
        }

        public boolean isInactive() {
            return this.activeMediaPeriods.isEmpty();
        }

        public void release() {
            if (this.hasMediaSource()) {
                AdsMediaSource.this.releaseChildSource((Object)this.id);
            }
        }

        public void releaseMediaPeriod(MaskingMediaPeriod maskingMediaPeriod) {
            this.activeMediaPeriods.remove(maskingMediaPeriod);
            maskingMediaPeriod.releasePeriod();
        }
    }

    private final class AdPrepareListener
    implements MaskingMediaPeriod.PrepareListener {
        private final Uri adUri;

        public AdPrepareListener(Uri uri) {
            this.adUri = uri;
        }

        public /* synthetic */ void lambda$onPrepareComplete$0$AdsMediaSource$AdPrepareListener(MediaSource.MediaPeriodId mediaPeriodId) {
            AdsMediaSource.this.adsLoader.handlePrepareComplete(AdsMediaSource.this, mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup);
        }

        public /* synthetic */ void lambda$onPrepareError$1$AdsMediaSource$AdPrepareListener(MediaSource.MediaPeriodId mediaPeriodId, IOException iOException) {
            AdsMediaSource.this.adsLoader.handlePrepareError(AdsMediaSource.this, mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup, iOException);
        }

        public void onPrepareComplete(MediaSource.MediaPeriodId mediaPeriodId) {
            AdsMediaSource.this.mainHandler.post((Runnable)new _$.Lambda.AdsMediaSource.AdPrepareListener.fKnX3U0AN4mPVLC978gwlh8u4Wo(this, mediaPeriodId));
        }

        public void onPrepareError(MediaSource.MediaPeriodId mediaPeriodId, IOException iOException) {
            AdsMediaSource.this.createEventDispatcher(mediaPeriodId).loadError(new LoadEventInfo(LoadEventInfo.getNewId(), new DataSpec(this.adUri), SystemClock.elapsedRealtime()), 6, (IOException)AdLoadException.createForAd(iOException), true);
            AdsMediaSource.this.mainHandler.post((Runnable)new _$.Lambda.AdsMediaSource.AdPrepareListener.ZJtMjO8RAu0BMqqkF1KvmN_9T84(this, mediaPeriodId, iOException));
        }
    }

    private final class ComponentListener
    implements AdsLoader.EventListener {
        private final Handler playerHandler = Util.createHandlerForCurrentLooper();
        private volatile boolean stopped;

        public /* synthetic */ void lambda$onAdPlaybackState$0$AdsMediaSource$ComponentListener(AdPlaybackState adPlaybackState) {
            if (this.stopped) {
                return;
            }
            AdsMediaSource.this.onAdPlaybackState(adPlaybackState);
        }

        @Override
        public /* synthetic */ void onAdClicked() {
            AdsLoader.EventListener._CC.$default$onAdClicked((AdsLoader.EventListener)this);
        }

        @Override
        public void onAdLoadError(AdLoadException adLoadException, DataSpec dataSpec) {
            if (this.stopped) {
                return;
            }
            AdsMediaSource.this.createEventDispatcher(null).loadError(new LoadEventInfo(LoadEventInfo.getNewId(), dataSpec, SystemClock.elapsedRealtime()), 6, (IOException)adLoadException, true);
        }

        @Override
        public void onAdPlaybackState(AdPlaybackState adPlaybackState) {
            if (this.stopped) {
                return;
            }
            this.playerHandler.post((Runnable)new _$.Lambda.AdsMediaSource.ComponentListener.EnOXLA4Xyh_hsc2De4jHB6dR5vU(this, adPlaybackState));
        }

        @Override
        public /* synthetic */ void onAdTapped() {
            AdsLoader.EventListener._CC.$default$onAdTapped((AdsLoader.EventListener)this);
        }

        public void stop() {
            this.stopped = true;
            this.playerHandler.removeCallbacksAndMessages(null);
        }
    }
}

