/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.ads;

import android.net.Uri;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public final class AdPlaybackState {
    public static final int AD_STATE_AVAILABLE = 1;
    public static final int AD_STATE_ERROR = 4;
    public static final int AD_STATE_PLAYED = 3;
    public static final int AD_STATE_SKIPPED = 2;
    public static final int AD_STATE_UNAVAILABLE = 0;
    public static final AdPlaybackState NONE = new AdPlaybackState((Object)null, new long[0], null, 0L, -9223372036854775807L);
    public final int adGroupCount;
    public final long[] adGroupTimesUs;
    public final AdGroup[] adGroups;
    public final long adResumePositionUs;
    public final Object adsId;
    public final long contentDurationUs;

    public AdPlaybackState(Object object, long ... lArray) {
        this(object, lArray, (AdGroup[])null, 0L, -9223372036854775807L);
    }

    private AdPlaybackState(Object objectArray, long[] objectArray2, AdGroup[] adGroupArray, long l2, long l3) {
        this.adsId = objectArray;
        this.adGroupTimesUs = objectArray2;
        this.adResumePositionUs = l2;
        this.contentDurationUs = l3;
        this.adGroupCount = objectArray2.length;
        objectArray = adGroupArray;
        if (adGroupArray == null) {
            objectArray2 = new AdGroup[this.adGroupCount];
            int n2 = 0;
            while (true) {
                objectArray = objectArray2;
                if (n2 >= this.adGroupCount) break;
                objectArray2[n2] = (long)new AdGroup();
                ++n2;
            }
        }
        this.adGroups = objectArray;
    }

    private boolean isPositionBeforeAdGroup(long l2, long l3, int n2) {
        if (l2 == Long.MIN_VALUE) {
            return false;
        }
        long l4 = this.adGroupTimesUs[n2];
        boolean bl = true;
        boolean bl2 = true;
        if (l4 == Long.MIN_VALUE) {
            bl = bl2;
            if (l3 != -9223372036854775807L) {
                bl = l2 < l3 ? bl2 : false;
            }
            return bl;
        }
        if (l2 >= l4) {
            bl = false;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (AdPlaybackState)object;
            if (!(Util.areEqual(this.adsId, ((AdPlaybackState)object).adsId) && this.adGroupCount == ((AdPlaybackState)object).adGroupCount && this.adResumePositionUs == ((AdPlaybackState)object).adResumePositionUs && this.contentDurationUs == ((AdPlaybackState)object).contentDurationUs && Arrays.equals(this.adGroupTimesUs, ((AdPlaybackState)object).adGroupTimesUs) && Arrays.equals(this.adGroups, ((AdPlaybackState)object).adGroups))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int getAdGroupIndexAfterPositionUs(long l2, long l3) {
        if (l2 != Long.MIN_VALUE && (l3 == -9223372036854775807L || l2 < l3)) {
            long[] lArray;
            int n2;
            for (n2 = 0; !(n2 >= (lArray = this.adGroupTimesUs).length || lArray[n2] == Long.MIN_VALUE || l2 < lArray[n2] && this.adGroups[n2].hasUnplayedAds()); ++n2) {
            }
            if (n2 >= this.adGroupTimesUs.length) {
                n2 = -1;
            }
            return n2;
        }
        return -1;
    }

    public int getAdGroupIndexForPositionUs(long l2, long l3) {
        int n2;
        for (n2 = this.adGroupTimesUs.length - 1; n2 >= 0 && this.isPositionBeforeAdGroup(l2, l3, n2); --n2) {
        }
        if (n2 < 0 || !this.adGroups[n2].hasUnplayedAds()) {
            n2 = -1;
        }
        return n2;
    }

    public int hashCode() {
        int n2 = this.adGroupCount;
        Object object = this.adsId;
        int n3 = object == null ? 0 : object.hashCode();
        return ((((n2 * 31 + n3) * 31 + (int)this.adResumePositionUs) * 31 + (int)this.contentDurationUs) * 31 + Arrays.hashCode(this.adGroupTimesUs)) * 31 + Arrays.hashCode(this.adGroups);
    }

    public boolean isAdInErrorState(int n2, int n3) {
        Object object = this.adGroups;
        int n4 = ((AdGroup[])object).length;
        boolean bl = false;
        if (n2 >= n4) {
            return false;
        }
        object = object[n2];
        boolean bl2 = bl;
        if (object.count != -1) {
            if (n3 >= object.count) {
                bl2 = bl;
            } else {
                bl2 = bl;
                if (object.states[n3] == 4) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdPlaybackState(adsId=");
        stringBuilder.append(this.adsId);
        stringBuilder.append(", adResumePositionUs=");
        stringBuilder.append(this.adResumePositionUs);
        stringBuilder.append(", adGroups=[");
        for (int i2 = 0; i2 < this.adGroups.length; ++i2) {
            stringBuilder.append("adGroup(timeUs=");
            stringBuilder.append(this.adGroupTimesUs[i2]);
            stringBuilder.append(", ads=[");
            for (int i3 = 0; i3 < this.adGroups[i2].states.length; ++i3) {
                stringBuilder.append("ad(state=");
                int n2 = this.adGroups[i2].states[i3];
                if (n2 != 0) {
                    if (n2 != 1) {
                        if (n2 != 2) {
                            if (n2 != 3) {
                                if (n2 != 4) {
                                    stringBuilder.append('?');
                                } else {
                                    stringBuilder.append('!');
                                }
                            } else {
                                stringBuilder.append('P');
                            }
                        } else {
                            stringBuilder.append('S');
                        }
                    } else {
                        stringBuilder.append('R');
                    }
                } else {
                    stringBuilder.append('_');
                }
                stringBuilder.append(", durationUs=");
                stringBuilder.append(this.adGroups[i2].durationsUs[i3]);
                stringBuilder.append(')');
                if (i3 >= this.adGroups[i2].states.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("])");
            if (i2 >= this.adGroups.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("])");
        return stringBuilder.toString();
    }

    public AdPlaybackState withAdCount(int n2, int n3) {
        boolean bl = n3 > 0;
        Assertions.checkArgument(bl);
        if (this.adGroups[n2].count == n3) {
            return this;
        }
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Util.nullSafeArrayCopy(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = this.adGroups[n2].withAdCount(n3);
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public AdPlaybackState withAdDurationsUs(long[][] lArray) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Util.nullSafeArrayCopy(adGroupArray, adGroupArray.length);
        for (int i2 = 0; i2 < this.adGroupCount; ++i2) {
            adGroupArray[i2] = adGroupArray[i2].withAdDurationsUs(lArray[i2]);
        }
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public AdPlaybackState withAdLoadError(int n2, int n3) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Util.nullSafeArrayCopy(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdState(4, n3);
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public AdPlaybackState withAdResumePositionUs(long l2) {
        if (this.adResumePositionUs == l2) {
            return this;
        }
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, this.adGroups, l2, this.contentDurationUs);
    }

    public AdPlaybackState withAdUri(int n2, int n3, Uri uri) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Util.nullSafeArrayCopy(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdUri(uri, n3);
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public AdPlaybackState withContentDurationUs(long l2) {
        if (this.contentDurationUs == l2) {
            return this;
        }
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, this.adGroups, this.adResumePositionUs, l2);
    }

    public AdPlaybackState withPlayedAd(int n2, int n3) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Util.nullSafeArrayCopy(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdState(3, n3);
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public AdPlaybackState withSkippedAd(int n2, int n3) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Util.nullSafeArrayCopy(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAdState(2, n3);
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public AdPlaybackState withSkippedAdGroup(int n2) {
        AdGroup[] adGroupArray = this.adGroups;
        adGroupArray = Util.nullSafeArrayCopy(adGroupArray, adGroupArray.length);
        adGroupArray[n2] = adGroupArray[n2].withAllAdsSkipped();
        return new AdPlaybackState(this.adsId, this.adGroupTimesUs, adGroupArray, this.adResumePositionUs, this.contentDurationUs);
    }

    public static final class AdGroup {
        public final int count;
        public final long[] durationsUs;
        public final int[] states;
        public final Uri[] uris;

        public AdGroup() {
            this(-1, new int[0], new Uri[0], new long[0]);
        }

        private AdGroup(int n2, int[] nArray, Uri[] uriArray, long[] lArray) {
            boolean bl = nArray.length == uriArray.length;
            Assertions.checkArgument(bl);
            this.count = n2;
            this.states = nArray;
            this.uris = uriArray;
            this.durationsUs = lArray;
        }

        private static long[] copyDurationsUsWithSpaceForAdCount(long[] lArray, int n2) {
            int n3 = lArray.length;
            n2 = Math.max(n2, n3);
            lArray = Arrays.copyOf(lArray, n2);
            Arrays.fill(lArray, n3, n2, -9223372036854775807L);
            return lArray;
        }

        private static int[] copyStatesWithSpaceForAdCount(int[] nArray, int n2) {
            int n3 = nArray.length;
            n2 = Math.max(n2, n3);
            nArray = Arrays.copyOf(nArray, n2);
            Arrays.fill(nArray, n3, n2, 0);
            return nArray;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (AdGroup)object;
                if (!(this.count == ((AdGroup)object).count && Arrays.equals(this.uris, ((AdGroup)object).uris) && Arrays.equals(this.states, ((AdGroup)object).states) && Arrays.equals(this.durationsUs, ((AdGroup)object).durationsUs))) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int getFirstAdIndexToPlay() {
            return this.getNextAdIndexToPlay(-1);
        }

        public int getNextAdIndexToPlay(int n2) {
            int[] nArray;
            ++n2;
            while (n2 < (nArray = this.states).length && nArray[n2] != 0 && nArray[n2] != 1) {
                ++n2;
            }
            return n2;
        }

        public boolean hasUnplayedAds() {
            boolean bl = this.count == -1 || this.getFirstAdIndexToPlay() < this.count;
            return bl;
        }

        public int hashCode() {
            return ((this.count * 31 + Arrays.hashCode(this.uris)) * 31 + Arrays.hashCode(this.states)) * 31 + Arrays.hashCode(this.durationsUs);
        }

        public AdGroup withAdCount(int n2) {
            int[] nArray = AdGroup.copyStatesWithSpaceForAdCount(this.states, n2);
            long[] lArray = AdGroup.copyDurationsUsWithSpaceForAdCount(this.durationsUs, n2);
            return new AdGroup(n2, nArray, Arrays.copyOf(this.uris, n2), lArray);
        }

        public AdGroup withAdDurationsUs(long[] lArray) {
            long[] lArray2;
            int n2 = lArray.length;
            Uri[] uriArray = this.uris;
            if (n2 < uriArray.length) {
                lArray2 = AdGroup.copyDurationsUsWithSpaceForAdCount(lArray, uriArray.length);
            } else {
                lArray2 = lArray;
                if (this.count != -1) {
                    lArray2 = lArray;
                    if (lArray.length > uriArray.length) {
                        lArray2 = Arrays.copyOf(lArray, uriArray.length);
                    }
                }
            }
            return new AdGroup(this.count, this.states, this.uris, lArray2);
        }

        public AdGroup withAdState(int n2, int n3) {
            int[] nArray;
            boolean bl;
            block6: {
                block5: {
                    int n4 = this.count;
                    boolean bl2 = false;
                    bl = n4 == -1 || n3 < n4;
                    Assertions.checkArgument(bl);
                    nArray = AdGroup.copyStatesWithSpaceForAdCount(this.states, n3 + 1);
                    if (nArray[n3] == 0 || nArray[n3] == 1) break block5;
                    bl = bl2;
                    if (nArray[n3] != n2) break block6;
                }
                bl = true;
            }
            Assertions.checkArgument(bl);
            long[] lArray = this.durationsUs;
            if (lArray.length != nArray.length) {
                lArray = AdGroup.copyDurationsUsWithSpaceForAdCount(lArray, nArray.length);
            }
            Uri[] uriArray = this.uris;
            if (uriArray.length != nArray.length) {
                uriArray = Arrays.copyOf(uriArray, nArray.length);
            }
            nArray[n3] = n2;
            return new AdGroup(this.count, nArray, uriArray, lArray);
        }

        public AdGroup withAdUri(Uri uri, int n2) {
            long[] lArray = this.durationsUs;
            int[] nArray = AdGroup.copyStatesWithSpaceForAdCount(this.states, n2 + 1);
            if (lArray.length != nArray.length) {
                lArray = AdGroup.copyDurationsUsWithSpaceForAdCount(lArray, nArray.length);
            }
            Uri[] uriArray = Arrays.copyOf(this.uris, nArray.length);
            uriArray[n2] = uri;
            nArray[n2] = 1;
            return new AdGroup(this.count, nArray, uriArray, lArray);
        }

        public AdGroup withAllAdsSkipped() {
            int n2 = this.count;
            if (n2 == -1) {
                return new AdGroup(0, new int[0], new Uri[0], new long[0]);
            }
            int[] nArray = this.states;
            n2 = nArray.length;
            nArray = Arrays.copyOf(nArray, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray[i2] != 1 && nArray[i2] != 0) continue;
                nArray[i2] = 2;
            }
            return new AdGroup(n2, nArray, this.uris, this.durationsUs);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdState {
    }
}

