/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class SilenceMediaSource
extends BaseMediaSource {
    private static final int CHANNEL_COUNT = 2;
    private static final Format FORMAT = new Format.Builder().setSampleMimeType("audio/raw").setChannelCount(2).setSampleRate(44100).setPcmEncoding(2).build();
    public static final String MEDIA_ID = "SilenceMediaSource";
    private static final MediaItem MEDIA_ITEM = new MediaItem.Builder().setMediaId("SilenceMediaSource").setUri(Uri.EMPTY).setMimeType(SilenceMediaSource.FORMAT.sampleMimeType).build();
    private static final int PCM_ENCODING = 2;
    private static final int SAMPLE_RATE_HZ = 44100;
    private static final byte[] SILENCE_SAMPLE = new byte[Util.getPcmFrameSize(2, 2) * 1024];
    private final long durationUs;
    private final MediaItem mediaItem;

    public SilenceMediaSource(long l2) {
        this(l2, MEDIA_ITEM);
    }

    private SilenceMediaSource(long l2, MediaItem mediaItem) {
        boolean bl = l2 >= 0L;
        Assertions.checkArgument(bl);
        this.durationUs = l2;
        this.mediaItem = mediaItem;
    }

    private static long getAudioByteCount(long l2) {
        l2 = l2 * 44100L / 1000000L;
        return (long)Util.getPcmFrameSize(2, 2) * l2;
    }

    private static long getAudioPositionUs(long l2) {
        return l2 / (long)Util.getPcmFrameSize(2, 2) * 1000000L / 44100L;
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId mediaPeriodId, Allocator allocator, long l2) {
        return new SilenceMediaPeriod(this.durationUs);
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    @Deprecated
    public Object getTag() {
        return Assertions.checkNotNull(this.mediaItem.playbackProperties).tag;
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    protected void prepareSourceInternal(TransferListener transferListener) {
        this.refreshSourceInfo((Timeline)new SinglePeriodTimeline(this.durationUs, true, false, false, null, this.mediaItem));
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
    }

    @Override
    protected void releaseSourceInternal() {
    }

    public static final class Factory {
        private long durationUs;
        private Object tag;

        public SilenceMediaSource createMediaSource() {
            boolean bl = this.durationUs > 0L;
            Assertions.checkState(bl);
            return new SilenceMediaSource(this.durationUs, MEDIA_ITEM.buildUpon().setTag(this.tag).build());
        }

        public Factory setDurationUs(long l2) {
            this.durationUs = l2;
            return this;
        }

        public Factory setTag(Object object) {
            this.tag = object;
            return this;
        }
    }

    private static final class SilenceMediaPeriod
    implements MediaPeriod {
        private static final TrackGroupArray TRACKS = new TrackGroupArray(new TrackGroup[]{new TrackGroup(new Format[]{SilenceMediaSource.access$200()})});
        private final long durationUs;
        private final ArrayList<SampleStream> sampleStreams;

        public SilenceMediaPeriod(long l2) {
            this.durationUs = l2;
            this.sampleStreams = new ArrayList();
        }

        private long constrainSeekPosition(long l2) {
            return Util.constrainValue(l2, 0L, this.durationUs);
        }

        @Override
        public boolean continueLoading(long l2) {
            return false;
        }

        @Override
        public void discardBuffer(long l2, boolean bl) {
        }

        @Override
        public long getAdjustedSeekPositionUs(long l2, SeekParameters seekParameters) {
            return this.constrainSeekPosition(l2);
        }

        @Override
        public long getBufferedPositionUs() {
            return Long.MIN_VALUE;
        }

        @Override
        public long getNextLoadPositionUs() {
            return Long.MIN_VALUE;
        }

        @Override
        public /* synthetic */ List<StreamKey> getStreamKeys(List<ExoTrackSelection> list) {
            return MediaPeriod._CC.$default$getStreamKeys((MediaPeriod)this, list);
        }

        @Override
        public TrackGroupArray getTrackGroups() {
            return TRACKS;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public void maybeThrowPrepareError() {
        }

        @Override
        public void prepare(MediaPeriod.Callback callback2, long l2) {
            callback2.onPrepared(this);
        }

        @Override
        public long readDiscontinuity() {
            return -9223372036854775807L;
        }

        @Override
        public void reevaluateBuffer(long l2) {
        }

        @Override
        public long seekToUs(long l2) {
            l2 = this.constrainSeekPosition(l2);
            for (int i2 = 0; i2 < this.sampleStreams.size(); ++i2) {
                ((SilenceSampleStream)this.sampleStreams.get(i2)).seekTo(l2);
            }
            return l2;
        }

        @Override
        public long selectTracks(ExoTrackSelection[] exoTrackSelectionArray, boolean[] blArray, SampleStream[] sampleStreamArray, boolean[] blArray2, long l2) {
            l2 = this.constrainSeekPosition(l2);
            for (int i2 = 0; i2 < exoTrackSelectionArray.length; ++i2) {
                if (!(sampleStreamArray[i2] == null || exoTrackSelectionArray[i2] != null && blArray[i2])) {
                    this.sampleStreams.remove(sampleStreamArray[i2]);
                    sampleStreamArray[i2] = null;
                }
                if (sampleStreamArray[i2] != null || exoTrackSelectionArray[i2] == null) continue;
                SilenceSampleStream silenceSampleStream = new SilenceSampleStream(this.durationUs);
                silenceSampleStream.seekTo(l2);
                this.sampleStreams.add(silenceSampleStream);
                sampleStreamArray[i2] = silenceSampleStream;
                blArray2[i2] = true;
            }
            return l2;
        }
    }

    private static final class SilenceSampleStream
    implements SampleStream {
        private final long durationBytes;
        private long positionBytes;
        private boolean sentFormat;

        public SilenceSampleStream(long l2) {
            this.durationBytes = SilenceMediaSource.getAudioByteCount(l2);
            this.seekTo(0L);
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void maybeThrowError() {
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer decoderInputBuffer, boolean bl) {
            if (this.sentFormat && !bl) {
                long l2 = this.durationBytes;
                long l3 = this.positionBytes;
                if ((l2 -= l3) == 0L) {
                    decoderInputBuffer.addFlag(4);
                    return -4;
                }
                decoderInputBuffer.timeUs = SilenceMediaSource.getAudioPositionUs(l3);
                decoderInputBuffer.addFlag(1);
                if (decoderInputBuffer.isFlagsOnly()) {
                    return -4;
                }
                int n2 = (int)Math.min((long)SILENCE_SAMPLE.length, l2);
                decoderInputBuffer.ensureSpaceForWrite(n2);
                decoderInputBuffer.data.put(SILENCE_SAMPLE, 0, n2);
                this.positionBytes += (long)n2;
                return -4;
            }
            formatHolder.format = FORMAT;
            this.sentFormat = true;
            return -5;
        }

        public void seekTo(long l2) {
            this.positionBytes = Util.constrainValue(SilenceMediaSource.getAudioByteCount(l2), 0L, this.durationBytes);
        }

        @Override
        public int skipData(long l2) {
            long l3 = this.positionBytes;
            this.seekTo(l2);
            return (int)((this.positionBytes - l3) / (long)SILENCE_SAMPLE.length);
        }
    }
}

