/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Looper;
import android.util.Log;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.SampleDataQueue;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public class SampleQueue
implements TrackOutput {
    static final int SAMPLE_CAPACITY_INCREMENT = 1000;
    private static final String TAG = "SampleQueue";
    private int absoluteFirstIndex;
    private int capacity;
    private TrackOutput.CryptoData[] cryptoDatas;
    private DrmSession currentDrmSession;
    private Format downstreamFormat;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final DrmSessionManager drmSessionManager;
    private final SampleExtrasHolder extrasHolder;
    private int[] flags;
    private Format[] formats;
    private boolean isLastSampleQueued;
    private long largestDiscardedTimestampUs;
    private long largestQueuedTimestampUs;
    private int length;
    private boolean loggedUnexpectedNonSyncSample;
    private long[] offsets;
    private boolean pendingSplice;
    private final Looper playbackLooper;
    private int readPosition;
    private int relativeFirstIndex;
    private final SampleDataQueue sampleDataQueue;
    private long sampleOffsetUs;
    private int[] sizes;
    private int[] sourceIds;
    private long startTimeUs;
    private long[] timesUs;
    private Format unadjustedUpstreamFormat;
    private boolean upstreamAllSamplesAreSyncSamples;
    private Format upstreamCommittedFormat;
    private Format upstreamFormat;
    private boolean upstreamFormatAdjustmentRequired;
    private UpstreamFormatChangedListener upstreamFormatChangeListener;
    private boolean upstreamFormatRequired;
    private boolean upstreamKeyframeRequired;
    private int upstreamSourceId;

    protected SampleQueue(Allocator allocator, Looper looper, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        this.playbackLooper = looper;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = eventDispatcher;
        this.sampleDataQueue = new SampleDataQueue(allocator);
        this.extrasHolder = new SampleExtrasHolder();
        int n2 = this.capacity = 1000;
        this.sourceIds = new int[n2];
        this.offsets = new long[n2];
        this.timesUs = new long[n2];
        this.flags = new int[n2];
        this.sizes = new int[n2];
        this.cryptoDatas = new TrackOutput.CryptoData[n2];
        this.formats = new Format[n2];
        this.startTimeUs = Long.MIN_VALUE;
        this.largestDiscardedTimestampUs = Long.MIN_VALUE;
        this.largestQueuedTimestampUs = Long.MIN_VALUE;
        this.upstreamFormatRequired = true;
        this.upstreamKeyframeRequired = true;
    }

    private boolean attemptSplice(long l2) {
        synchronized (this) {
            int n2;
            block8: {
                block6: {
                    boolean bl;
                    block7: {
                        n2 = this.length;
                        bl = true;
                        if (n2 != 0) break block6;
                        long l3 = this.largestDiscardedTimestampUs;
                        if (l2 > l3) break block7;
                        bl = false;
                    }
                    return bl;
                }
                long l4 = this.getLargestReadTimestampUs();
                if (l4 < l2) break block8;
                return false;
            }
            n2 = this.countUnreadSamplesBefore(l2);
            this.discardUpstreamSampleMetadata(this.absoluteFirstIndex + n2);
            return true;
        }
    }

    private void commitSample(long l2, int n2, long l3, int n3, TrackOutput.CryptoData object) {
        synchronized (this) {
            boolean bl;
            int n4;
            block6: {
                if (this.length <= 0) break block6;
                n4 = this.getRelativeIndex(this.length - 1);
                bl = this.offsets[n4] + (long)this.sizes[n4] <= l3;
                Assertions.checkArgument(bl);
            }
            bl = (0x20000000 & n2) != 0;
            this.isLastSampleQueued = bl;
            this.largestQueuedTimestampUs = Math.max(this.largestQueuedTimestampUs, l2);
            n4 = this.getRelativeIndex(this.length);
            this.timesUs[n4] = l2;
            this.offsets[n4] = l3;
            this.sizes[n4] = n3;
            this.flags[n4] = n2;
            this.cryptoDatas[n4] = object;
            this.formats[n4] = this.upstreamFormat;
            this.sourceIds[n4] = this.upstreamSourceId;
            this.upstreamCommittedFormat = this.upstreamFormat;
            ++this.length;
            if (this.length == this.capacity) {
                n3 = this.capacity + 1000;
                int[] nArray = new int[n3];
                long[] lArray = new long[n3];
                long[] lArray2 = new long[n3];
                int[] nArray2 = new int[n3];
                object = new int[n3];
                TrackOutput.CryptoData[] cryptoDataArray = new TrackOutput.CryptoData[n3];
                Format[] formatArray = new Format[n3];
                n2 = this.capacity - this.relativeFirstIndex;
                System.arraycopy(this.offsets, this.relativeFirstIndex, lArray, 0, n2);
                System.arraycopy(this.timesUs, this.relativeFirstIndex, lArray2, 0, n2);
                System.arraycopy(this.flags, this.relativeFirstIndex, nArray2, 0, n2);
                System.arraycopy(this.sizes, this.relativeFirstIndex, object, 0, n2);
                System.arraycopy(this.cryptoDatas, this.relativeFirstIndex, cryptoDataArray, 0, n2);
                System.arraycopy(this.formats, this.relativeFirstIndex, formatArray, 0, n2);
                System.arraycopy(this.sourceIds, this.relativeFirstIndex, nArray, 0, n2);
                n4 = this.relativeFirstIndex;
                System.arraycopy(this.offsets, 0, lArray, n2, n4);
                System.arraycopy(this.timesUs, 0, lArray2, n2, n4);
                System.arraycopy(this.flags, 0, nArray2, n2, n4);
                System.arraycopy(this.sizes, 0, object, n2, n4);
                System.arraycopy(this.cryptoDatas, 0, cryptoDataArray, n2, n4);
                System.arraycopy(this.formats, 0, formatArray, n2, n4);
                System.arraycopy(this.sourceIds, 0, nArray, n2, n4);
                this.offsets = lArray;
                this.timesUs = lArray2;
                this.flags = nArray2;
                this.sizes = (int[])object;
                this.cryptoDatas = cryptoDataArray;
                this.formats = formatArray;
                this.sourceIds = nArray;
                this.relativeFirstIndex = 0;
                this.capacity = n3;
            }
            return;
        }
    }

    private int countUnreadSamplesBefore(long l2) {
        int n2 = this.length;
        int n3 = this.getRelativeIndex(n2 - 1);
        while (n2 > this.readPosition && this.timesUs[n3] >= l2) {
            int n4 = n2 - 1;
            int n5 = n3 - 1;
            n2 = n4;
            n3 = n5;
            if (n5 != -1) continue;
            n3 = this.capacity - 1;
            n2 = n4;
        }
        return n2;
    }

    public static SampleQueue createWithDrm(Allocator allocator, Looper looper, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        return new SampleQueue(allocator, Assertions.checkNotNull(looper), Assertions.checkNotNull(drmSessionManager), Assertions.checkNotNull(eventDispatcher));
    }

    public static SampleQueue createWithoutDrm(Allocator allocator) {
        return new SampleQueue(allocator, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long discardSampleMetadataTo(long l2, boolean bl, boolean bl2) {
        synchronized (this) {
            if (this.length == 0) return -1L;
            if (l2 >= this.timesUs[this.relativeFirstIndex]) {
                int n2 = bl2 && this.readPosition != this.length ? this.readPosition + 1 : this.length;
                n2 = this.findSampleBefore(this.relativeFirstIndex, n2, l2, bl);
                if (n2 != -1) return this.discardSamples(n2);
                return -1L;
            }
            return -1L;
        }
    }

    private long discardSampleMetadataToEnd() {
        synchronized (this) {
            block4: {
                int n2 = this.length;
                if (n2 != 0) break block4;
                return -1L;
            }
            long l2 = this.discardSamples(this.length);
            return l2;
        }
    }

    private long discardSamples(int n2) {
        this.largestDiscardedTimestampUs = Math.max(this.largestDiscardedTimestampUs, this.getLargestTimestamp(n2));
        this.length -= n2;
        this.absoluteFirstIndex += n2;
        this.relativeFirstIndex += n2;
        int n3 = this.relativeFirstIndex;
        int n4 = this.capacity;
        if (n3 >= n4) {
            this.relativeFirstIndex = n3 - n4;
        }
        this.readPosition -= n2;
        if (this.readPosition < 0) {
            this.readPosition = 0;
        }
        if (this.length == 0) {
            n2 = n3 = this.relativeFirstIndex;
            if (n3 == 0) {
                n2 = this.capacity;
            }
            return this.offsets[--n2] + (long)this.sizes[n2];
        }
        return this.offsets[this.relativeFirstIndex];
    }

    private long discardUpstreamSampleMetadata(int n2) {
        n2 = this.getWriteIndex() - n2;
        boolean bl = false;
        boolean bl2 = n2 >= 0 && n2 <= this.length - this.readPosition;
        Assertions.checkArgument(bl2);
        this.length -= n2;
        this.largestQueuedTimestampUs = Math.max(this.largestDiscardedTimestampUs, this.getLargestTimestamp(this.length));
        bl2 = bl;
        if (n2 == 0) {
            bl2 = bl;
            if (this.isLastSampleQueued) {
                bl2 = true;
            }
        }
        this.isLastSampleQueued = bl2;
        n2 = this.length;
        if (n2 != 0) {
            n2 = this.getRelativeIndex(n2 - 1);
            return this.offsets[n2] + (long)this.sizes[n2];
        }
        return 0L;
    }

    private int findSampleBefore(int n2, int n3, long l2, boolean bl) {
        block4: {
            int n4 = n2;
            int n5 = -1;
            for (n2 = 0; n2 < n3 && this.timesUs[n4] <= l2; ++n2) {
                int n6;
                block6: {
                    block5: {
                        if (!bl) break block5;
                        n6 = n5;
                        if ((this.flags[n4] & 1) == 0) break block6;
                    }
                    if (this.timesUs[n4] == l2) break block4;
                    n6 = n2;
                }
                n5 = ++n4;
                if (n4 == this.capacity) {
                    n5 = 0;
                }
                n4 = n5;
                n5 = n6;
            }
            n2 = n5;
        }
        return n2;
    }

    private long getLargestTimestamp(int n2) {
        long l2;
        long l3 = Long.MIN_VALUE;
        if (n2 == 0) {
            return Long.MIN_VALUE;
        }
        int n3 = this.getRelativeIndex(n2 - 1);
        int n4 = 0;
        while (true) {
            int n5;
            l2 = l3;
            if (n4 >= n2) break;
            l3 = Math.max(l3, this.timesUs[n3]);
            if ((this.flags[n3] & 1) != 0) {
                l2 = l3;
                break;
            }
            n3 = n5 = n3 - 1;
            if (n5 == -1) {
                n3 = this.capacity - 1;
            }
            ++n4;
        }
        return l2;
    }

    private int getRelativeIndex(int n2) {
        int n3 = this.capacity;
        if ((n2 = this.relativeFirstIndex + n2) >= n3) {
            n2 -= n3;
        }
        return n2;
    }

    private boolean hasNextSample() {
        boolean bl = this.readPosition != this.length;
        return bl;
    }

    private boolean mayReadSample(int n2) {
        DrmSession drmSession = this.currentDrmSession;
        boolean bl = drmSession == null || drmSession.getState() == 4 || (this.flags[n2] & 0x40000000) == 0 && this.currentDrmSession.playClearSamplesWithoutKeys();
        return bl;
    }

    private void onFormatResult(Format format, FormatHolder formatHolder) {
        boolean bl = this.downstreamFormat == null;
        Object object = bl ? null : this.downstreamFormat.drmInitData;
        this.downstreamFormat = format;
        DrmInitData drmInitData = format.drmInitData;
        DrmSessionManager drmSessionManager = this.drmSessionManager;
        drmSessionManager = drmSessionManager != null ? format.copyWithExoMediaCryptoType(drmSessionManager.getExoMediaCryptoType(format)) : format;
        formatHolder.format = drmSessionManager;
        formatHolder.drmSession = this.currentDrmSession;
        if (this.drmSessionManager == null) {
            return;
        }
        if (!bl && Util.areEqual(object, drmInitData)) {
            return;
        }
        object = this.currentDrmSession;
        formatHolder.drmSession = this.currentDrmSession = this.drmSessionManager.acquireSession(Assertions.checkNotNull(this.playbackLooper), this.drmEventDispatcher, format);
        if (object != null) {
            object.release(this.drmEventDispatcher);
        }
    }

    private int peekSampleMetadata(FormatHolder formatHolder, DecoderInputBuffer decoderInputBuffer, boolean bl, boolean bl2, SampleExtrasHolder sampleExtrasHolder) {
        synchronized (this) {
            decoderInputBuffer.waitingForKeys = false;
            if (!this.hasNextSample()) {
                if (!bl2 && !this.isLastSampleQueued) {
                    if (this.upstreamFormat != null && (bl || this.upstreamFormat != this.downstreamFormat)) {
                        this.onFormatResult(Assertions.checkNotNull(this.upstreamFormat), formatHolder);
                        return -5;
                    }
                    return -3;
                }
                decoderInputBuffer.setFlags(4);
                return -4;
            }
            int n2 = this.getRelativeIndex(this.readPosition);
            if (!bl && this.formats[n2] == this.downstreamFormat) {
                if (!this.mayReadSample(n2)) {
                    decoderInputBuffer.waitingForKeys = true;
                    return -3;
                }
                decoderInputBuffer.setFlags(this.flags[n2]);
                decoderInputBuffer.timeUs = this.timesUs[n2];
                if (decoderInputBuffer.timeUs < this.startTimeUs) {
                    decoderInputBuffer.addFlag(Integer.MIN_VALUE);
                }
                sampleExtrasHolder.size = this.sizes[n2];
                sampleExtrasHolder.offset = this.offsets[n2];
                sampleExtrasHolder.cryptoData = this.cryptoDatas[n2];
                return -4;
            }
            this.onFormatResult(this.formats[n2], formatHolder);
            return -5;
        }
    }

    private void releaseDrmSessionReferences() {
        DrmSession drmSession = this.currentDrmSession;
        if (drmSession != null) {
            drmSession.release(this.drmEventDispatcher);
            this.currentDrmSession = null;
            this.downstreamFormat = null;
        }
    }

    private void rewind() {
        synchronized (this) {
            this.readPosition = 0;
            this.sampleDataQueue.rewind();
            return;
        }
    }

    private boolean setUpstreamFormat(Format format) {
        synchronized (this) {
            block4: {
                this.upstreamFormatRequired = false;
                boolean bl = Util.areEqual(format, this.upstreamFormat);
                if (!bl) break block4;
                return false;
            }
            this.upstreamFormat = Util.areEqual(format, this.upstreamCommittedFormat) ? this.upstreamCommittedFormat : format;
            this.upstreamAllSamplesAreSyncSamples = MimeTypes.allSamplesAreSyncSamples((String)this.upstreamFormat.sampleMimeType, (String)this.upstreamFormat.codecs);
            this.loggedUnexpectedNonSyncSample = false;
            return true;
        }
    }

    public long discardSampleMetadataToRead() {
        synchronized (this) {
            block4: {
                int n2 = this.readPosition;
                if (n2 != 0) break block4;
                return -1L;
            }
            long l2 = this.discardSamples(this.readPosition);
            return l2;
        }
    }

    public final void discardTo(long l2, boolean bl, boolean bl2) {
        this.sampleDataQueue.discardDownstreamTo(this.discardSampleMetadataTo(l2, bl, bl2));
    }

    public final void discardToEnd() {
        this.sampleDataQueue.discardDownstreamTo(this.discardSampleMetadataToEnd());
    }

    public final void discardToRead() {
        this.sampleDataQueue.discardDownstreamTo(this.discardSampleMetadataToRead());
    }

    public final void discardUpstreamFrom(long l2) {
        if (this.length == 0) {
            return;
        }
        boolean bl = l2 > this.getLargestReadTimestampUs();
        Assertions.checkArgument(bl);
        int n2 = this.countUnreadSamplesBefore(l2);
        this.discardUpstreamSamples(this.absoluteFirstIndex + n2);
    }

    public final void discardUpstreamSamples(int n2) {
        this.sampleDataQueue.discardUpstreamSampleBytes(this.discardUpstreamSampleMetadata(n2));
    }

    @Override
    public final void format(Format object) {
        Format format = this.getAdjustedUpstreamFormat((Format)object);
        this.upstreamFormatAdjustmentRequired = false;
        this.unadjustedUpstreamFormat = object;
        boolean bl = this.setUpstreamFormat(format);
        object = this.upstreamFormatChangeListener;
        if (object != null && bl) {
            object.onUpstreamFormatChanged(format);
        }
    }

    protected Format getAdjustedUpstreamFormat(Format format) {
        Format format2 = format;
        if (this.sampleOffsetUs != 0L) {
            format2 = format;
            if (format.subsampleOffsetUs != Long.MAX_VALUE) {
                format2 = format.buildUpon().setSubsampleOffsetUs(format.subsampleOffsetUs + this.sampleOffsetUs).build();
            }
        }
        return format2;
    }

    public final int getFirstIndex() {
        return this.absoluteFirstIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long getFirstTimestampUs() {
        synchronized (this) {
            block4: {
                if (this.length != 0) break block4;
                return Long.MIN_VALUE;
            }
            return this.timesUs[this.relativeFirstIndex];
        }
    }

    public final long getLargestQueuedTimestampUs() {
        synchronized (this) {
            long l2 = this.largestQueuedTimestampUs;
            return l2;
        }
    }

    public final long getLargestReadTimestampUs() {
        synchronized (this) {
            long l2 = Math.max(this.largestDiscardedTimestampUs, this.getLargestTimestamp(this.readPosition));
            return l2;
        }
    }

    public final int getReadIndex() {
        return this.absoluteFirstIndex + this.readPosition;
    }

    public final int getSkipCount(long l2, boolean bl) {
        synchronized (this) {
            block5: {
                int n2;
                block7: {
                    block6: {
                        n2 = this.getRelativeIndex(this.readPosition);
                        if (!this.hasNextSample() || l2 < this.timesUs[n2]) break block5;
                        if (l2 <= this.largestQueuedTimestampUs || !bl) break block6;
                        int n3 = this.length;
                        n2 = this.readPosition;
                        return n3 - n2;
                    }
                    n2 = this.findSampleBefore(n2, this.length - this.readPosition, l2, true);
                    if (n2 != -1) break block7;
                    return 0;
                }
                return n2;
            }
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Format getUpstreamFormat() {
        synchronized (this) {
            block4: {
                if (!this.upstreamFormatRequired) break block4;
                return null;
            }
            return this.upstreamFormat;
        }
    }

    public final int getWriteIndex() {
        return this.absoluteFirstIndex + this.length;
    }

    protected final void invalidateUpstreamFormatAdjustment() {
        this.upstreamFormatAdjustmentRequired = true;
    }

    public final boolean isLastSampleQueued() {
        synchronized (this) {
            boolean bl = this.isLastSampleQueued;
            return bl;
        }
    }

    public boolean isReady(boolean bl) {
        synchronized (this) {
            int n2;
            block8: {
                block6: {
                    boolean bl2;
                    block7: {
                        Format format;
                        Format format2;
                        bl2 = this.hasNextSample();
                        boolean bl3 = true;
                        if (bl2) break block6;
                        bl2 = bl3;
                        if (bl) break block7;
                        bl2 = bl3;
                        if (this.isLastSampleQueued) break block7;
                        bl2 = this.upstreamFormat != null && (format2 = this.upstreamFormat) != (format = this.downstreamFormat) ? bl3 : false;
                    }
                    return bl2;
                }
                n2 = this.getRelativeIndex(this.readPosition);
                Format format = this.formats[n2];
                Format format3 = this.downstreamFormat;
                if (format == format3) break block8;
                return true;
            }
            bl = this.mayReadSample(n2);
            return bl;
        }
    }

    public void maybeThrowError() throws IOException {
        DrmSession drmSession = this.currentDrmSession;
        if (drmSession != null && drmSession.getState() == 1) {
            throw Assertions.checkNotNull(this.currentDrmSession.getError());
        }
    }

    public final int peek(FormatHolder formatHolder, DecoderInputBuffer decoderInputBuffer, boolean bl, boolean bl2) {
        int n2 = this.peekSampleMetadata(formatHolder, decoderInputBuffer, bl, bl2, this.extrasHolder);
        if (n2 == -4 && !decoderInputBuffer.isEndOfStream() && !decoderInputBuffer.isFlagsOnly()) {
            this.sampleDataQueue.peekToBuffer(decoderInputBuffer, this.extrasHolder);
        }
        return n2;
    }

    public final int peekSourceId() {
        synchronized (this) {
            int n2 = this.getRelativeIndex(this.readPosition);
            n2 = this.hasNextSample() ? this.sourceIds[n2] : this.upstreamSourceId;
            return n2;
        }
    }

    public void preRelease() {
        this.discardToEnd();
        this.releaseDrmSessionReferences();
    }

    public int read(FormatHolder formatHolder, DecoderInputBuffer decoderInputBuffer, boolean bl, boolean bl2) {
        int n2 = this.peekSampleMetadata(formatHolder, decoderInputBuffer, bl, bl2, this.extrasHolder);
        if (n2 == -4 && !decoderInputBuffer.isEndOfStream() && !decoderInputBuffer.isFlagsOnly()) {
            this.sampleDataQueue.readToBuffer(decoderInputBuffer, this.extrasHolder);
            ++this.readPosition;
        }
        return n2;
    }

    public void release() {
        this.reset(true);
        this.releaseDrmSessionReferences();
    }

    public final void reset() {
        this.reset(false);
    }

    public void reset(boolean bl) {
        this.sampleDataQueue.reset();
        this.length = 0;
        this.absoluteFirstIndex = 0;
        this.relativeFirstIndex = 0;
        this.readPosition = 0;
        this.upstreamKeyframeRequired = true;
        this.startTimeUs = Long.MIN_VALUE;
        this.largestDiscardedTimestampUs = Long.MIN_VALUE;
        this.largestQueuedTimestampUs = Long.MIN_VALUE;
        this.isLastSampleQueued = false;
        this.upstreamCommittedFormat = null;
        if (bl) {
            this.unadjustedUpstreamFormat = null;
            this.upstreamFormat = null;
            this.upstreamFormatRequired = true;
        }
    }

    @Override
    public /* synthetic */ int sampleData(DataReader dataReader, int n2, boolean bl) throws IOException {
        return TrackOutput._CC.$default$sampleData((TrackOutput)this, (DataReader)dataReader, (int)n2, (boolean)bl);
    }

    @Override
    public final int sampleData(DataReader dataReader, int n2, boolean bl, int n3) throws IOException {
        return this.sampleDataQueue.sampleData(dataReader, n2, bl);
    }

    @Override
    public /* synthetic */ void sampleData(ParsableByteArray parsableByteArray, int n2) {
        TrackOutput._CC.$default$sampleData((TrackOutput)this, (ParsableByteArray)parsableByteArray, (int)n2);
    }

    @Override
    public final void sampleData(ParsableByteArray parsableByteArray, int n2, int n3) {
        this.sampleDataQueue.sampleData(parsableByteArray, n2);
    }

    @Override
    public void sampleMetadata(long l2, int n2, int n3, int n4, TrackOutput.CryptoData cryptoData) {
        int n5;
        if (this.upstreamFormatAdjustmentRequired) {
            this.format(Assertions.checkStateNotNull(this.unadjustedUpstreamFormat));
        }
        boolean bl = (n5 = n2 & 1) != 0;
        if (this.upstreamKeyframeRequired) {
            if (!bl) {
                return;
            }
            this.upstreamKeyframeRequired = false;
        }
        l2 = this.sampleOffsetUs + l2;
        if (this.upstreamAllSamplesAreSyncSamples) {
            if (l2 < this.startTimeUs) {
                return;
            }
            if (n5 == 0) {
                if (!this.loggedUnexpectedNonSyncSample) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Overriding unexpected non-sync sample for format: ");
                    stringBuilder.append(this.upstreamFormat);
                    Log.w((String)TAG, (String)stringBuilder.toString());
                    this.loggedUnexpectedNonSyncSample = true;
                }
                n2 |= 1;
            }
        }
        if (this.pendingSplice) {
            if (bl && this.attemptSplice(l2)) {
                this.pendingSplice = false;
            } else {
                return;
            }
        }
        this.commitSample(l2, n2, this.sampleDataQueue.getTotalBytesWritten() - (long)n3 - (long)n4, n3, cryptoData);
    }

    public final boolean seekTo(int n2) {
        synchronized (this) {
            this.rewind();
            if (n2 >= this.absoluteFirstIndex) {
                if (n2 > this.absoluteFirstIndex + this.length) {
                } else {
                    this.startTimeUs = Long.MIN_VALUE;
                    this.readPosition = n2 - this.absoluteFirstIndex;
                    return true;
                }
            }
            return false;
        }
    }

    public final boolean seekTo(long l2, boolean bl) {
        synchronized (this) {
            block5: {
                int n2;
                block6: {
                    this.rewind();
                    n2 = this.getRelativeIndex(this.readPosition);
                    if (!this.hasNextSample() || l2 < this.timesUs[n2] || l2 > this.largestQueuedTimestampUs && !bl) break block5;
                    n2 = this.findSampleBefore(n2, this.length - this.readPosition, l2, true);
                    if (n2 != -1) break block6;
                    return false;
                }
                this.startTimeUs = l2;
                this.readPosition += n2;
                return true;
            }
            return false;
        }
    }

    public final void setSampleOffsetUs(long l2) {
        if (this.sampleOffsetUs != l2) {
            this.sampleOffsetUs = l2;
            this.invalidateUpstreamFormatAdjustment();
        }
    }

    public final void setStartTimeUs(long l2) {
        this.startTimeUs = l2;
    }

    public final void setUpstreamFormatChangeListener(UpstreamFormatChangedListener upstreamFormatChangedListener) {
        this.upstreamFormatChangeListener = upstreamFormatChangedListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void skip(int n2) {
        synchronized (this) {
            Throwable throwable2;
            block6: {
                boolean bl;
                block5: {
                    block4: {
                        if (n2 >= 0) {
                            try {
                                if (this.readPosition + n2 > this.length) break block4;
                                bl = true;
                                break block5;
                            }
                            catch (Throwable throwable2) {
                                break block6;
                            }
                        }
                    }
                    bl = false;
                }
                Assertions.checkArgument(bl);
                this.readPosition += n2;
                return;
            }
            throw throwable2;
        }
    }

    public final void sourceId(int n2) {
        this.upstreamSourceId = n2;
    }

    public final void splice() {
        this.pendingSplice = true;
    }

    static final class SampleExtrasHolder {
        public TrackOutput.CryptoData cryptoData;
        public long offset;
        public int size;

        SampleExtrasHolder() {
        }
    }

    public static interface UpstreamFormatChangedListener {
        public void onUpstreamFormatChanged(Format var1);
    }
}

