/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.icy.IcyHeaders;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.BundledExtractorsAdapter;
import com.google.android.exoplayer2.source.IcyDataSource;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.ProgressiveMediaExtractor;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source._$$Lambda$ProgressiveMediaPeriod$XL6L2U_3FG8Q9U9Dud8PsJBs494;
import com.google.android.exoplayer2.source._$$Lambda$ProgressiveMediaPeriod$XtIxRPmKXOyt2tIiDgXldkLBDgg;
import com.google.android.exoplayer2.source._$$Lambda$ProgressiveMediaPeriod$g0rAX0fUGYs_ZNigG_uJ9uWsNPk;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.StatsDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class ProgressiveMediaPeriod
implements MediaPeriod,
ExtractorOutput,
Loader.Callback<ExtractingLoadable>,
Loader.ReleaseCallback,
SampleQueue.UpstreamFormatChangedListener {
    private static final long DEFAULT_LAST_SAMPLE_DURATION_US = 10000L;
    private static final Format ICY_FORMAT;
    private static final Map<String, String> ICY_METADATA_HEADERS;
    private final Allocator allocator;
    private MediaPeriod.Callback callback;
    private final long continueLoadingCheckIntervalBytes;
    private final String customCacheKey;
    private final DataSource dataSource;
    private int dataType;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final DrmSessionManager drmSessionManager;
    private long durationUs;
    private int enabledTrackCount;
    private int extractedSamplesCountAtStartOfLoad;
    private final Handler handler;
    private boolean haveAudioVideoTracks;
    private IcyHeaders icyHeaders;
    private boolean isLive;
    private long lastSeekPositionUs;
    private long length;
    private final Listener listener;
    private final ConditionVariable loadCondition;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final Loader loader;
    private boolean loadingFinished;
    private final Runnable maybeFinishPrepareRunnable;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private boolean notifyDiscontinuity;
    private final Runnable onContinueLoadingRequestedRunnable;
    private boolean pendingDeferredRetry;
    private long pendingResetPositionUs;
    private boolean prepared;
    private final ProgressiveMediaExtractor progressiveMediaExtractor;
    private boolean released;
    private TrackId[] sampleQueueTrackIds;
    private SampleQueue[] sampleQueues;
    private boolean sampleQueuesBuilt;
    private SeekMap seekMap;
    private boolean seenFirstTrackSelection;
    private TrackState trackState;
    private final Uri uri;

    static {
        ICY_METADATA_HEADERS = ProgressiveMediaPeriod.createIcyMetadataHeaders();
        ICY_FORMAT = new Format.Builder().setId("icy").setSampleMimeType("application/x-icy").build();
    }

    public ProgressiveMediaPeriod(Uri uri, DataSource dataSource, ExtractorsFactory extractorsFactory, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher2, Listener listener2, Allocator allocator, String string2, int n2) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = eventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.mediaSourceEventDispatcher = eventDispatcher2;
        this.listener = listener2;
        this.allocator = allocator;
        this.customCacheKey = string2;
        this.continueLoadingCheckIntervalBytes = n2;
        this.loader = new Loader("Loader:ProgressiveMediaPeriod");
        this.progressiveMediaExtractor = new BundledExtractorsAdapter(extractorsFactory);
        this.loadCondition = new ConditionVariable();
        this.maybeFinishPrepareRunnable = new _$$Lambda$ProgressiveMediaPeriod$XtIxRPmKXOyt2tIiDgXldkLBDgg(this);
        this.onContinueLoadingRequestedRunnable = new _$$Lambda$ProgressiveMediaPeriod$XL6L2U_3FG8Q9U9Dud8PsJBs494(this);
        this.handler = Util.createHandlerForCurrentLooper();
        this.sampleQueueTrackIds = new TrackId[0];
        this.sampleQueues = new SampleQueue[0];
        this.pendingResetPositionUs = -9223372036854775807L;
        this.length = -1L;
        this.durationUs = -9223372036854775807L;
        this.dataType = 1;
    }

    static /* synthetic */ IcyHeaders access$702(ProgressiveMediaPeriod progressiveMediaPeriod, IcyHeaders icyHeaders) {
        progressiveMediaPeriod.icyHeaders = icyHeaders;
        return icyHeaders;
    }

    @EnsuresNonNull(value={"trackState", "seekMap"})
    private void assertPrepared() {
        Assertions.checkState(this.prepared);
        Assertions.checkNotNull(this.trackState);
        Assertions.checkNotNull(this.seekMap);
    }

    private boolean configureRetry(ExtractingLoadable extractingLoadable, int n2) {
        SampleQueue[] sampleQueueArray;
        if (this.length == -1L && ((sampleQueueArray = this.seekMap) == null || sampleQueueArray.getDurationUs() == -9223372036854775807L)) {
            boolean bl = this.prepared;
            if (bl && !this.suppressRead()) {
                this.pendingDeferredRetry = true;
                return false;
            }
            this.notifyDiscontinuity = this.prepared;
            this.lastSeekPositionUs = 0L;
            this.extractedSamplesCountAtStartOfLoad = 0;
            sampleQueueArray = this.sampleQueues;
            int n3 = sampleQueueArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                sampleQueueArray[n2].reset();
            }
            extractingLoadable.setLoadPosition(0L, 0L);
            return true;
        }
        this.extractedSamplesCountAtStartOfLoad = n2;
        return true;
    }

    private void copyLengthFromLoader(ExtractingLoadable extractingLoadable) {
        if (this.length == -1L) {
            this.length = extractingLoadable.length;
        }
    }

    private static Map<String, String> createIcyMetadataHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Icy-MetaData", "1");
        return Collections.unmodifiableMap(hashMap);
    }

    private int getExtractedSamplesCount() {
        SampleQueue[] sampleQueueArray = this.sampleQueues;
        int n2 = sampleQueueArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += sampleQueueArray[i2].getWriteIndex();
        }
        return n3;
    }

    private long getLargestQueuedTimestampUs() {
        SampleQueue[] sampleQueueArray = this.sampleQueues;
        int n2 = sampleQueueArray.length;
        long l2 = Long.MIN_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = Math.max(l2, sampleQueueArray[i2].getLargestQueuedTimestampUs());
        }
        return l2;
    }

    private boolean isPendingReset() {
        boolean bl = this.pendingResetPositionUs != -9223372036854775807L;
        return bl;
    }

    public static /* synthetic */ void lambda$XtIxRPmKXOyt2tIiDgXldkLBDgg(ProgressiveMediaPeriod progressiveMediaPeriod) {
        progressiveMediaPeriod.maybeFinishPrepare();
    }

    private void maybeFinishPrepare() {
        block9: {
            int n2;
            if (this.released || this.prepared || !this.sampleQueuesBuilt || this.seekMap == null) break block9;
            Object object = this.sampleQueues;
            int n3 = ((SampleQueue[])object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (object[n2].getUpstreamFormat() != null) continue;
                return;
            }
            this.loadCondition.close();
            n3 = this.sampleQueues.length;
            TrackGroup[] trackGroupArray = new TrackGroup[n3];
            boolean[] blArray = new boolean[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                block10: {
                    Format format;
                    IcyHeaders icyHeaders;
                    boolean bl;
                    block12: {
                        Format format2;
                        block11: {
                            format2 = Assertions.checkNotNull(this.sampleQueues[n2].getUpstreamFormat());
                            object = format2.sampleMimeType;
                            bl = MimeTypes.isAudio((String)object);
                            boolean bl2 = bl || MimeTypes.isVideo((String)object);
                            blArray[n2] = bl2;
                            this.haveAudioVideoTracks = bl2 | this.haveAudioVideoTracks;
                            icyHeaders = this.icyHeaders;
                            object = format2;
                            if (icyHeaders == null) break block10;
                            if (bl) break block11;
                            format = format2;
                            if (!this.sampleQueueTrackIds[n2].isIcyTrack) break block12;
                        }
                        object = (object = format2.metadata) == null ? new Metadata(new Metadata.Entry[]{icyHeaders}) : object.copyWithAppendedEntries(new Metadata.Entry[]{icyHeaders});
                        format = format2.buildUpon().setMetadata((Metadata)object).build();
                    }
                    object = format;
                    if (bl) {
                        object = format;
                        if (format.averageBitrate == -1) {
                            object = format;
                            if (format.peakBitrate == -1) {
                                object = format;
                                if (icyHeaders.bitrate != -1) {
                                    object = format.buildUpon().setAverageBitrate(icyHeaders.bitrate).build();
                                }
                            }
                        }
                    }
                }
                trackGroupArray[n2] = new TrackGroup(new Format[]{object.copyWithExoMediaCryptoType(this.drmSessionManager.getExoMediaCryptoType(object))});
            }
            this.trackState = new TrackState(new TrackGroupArray(trackGroupArray), blArray);
            this.prepared = true;
            Assertions.checkNotNull(this.callback).onPrepared(this);
        }
    }

    private void maybeNotifyDownstreamFormat(int n2) {
        this.assertPrepared();
        boolean[] blArray = this.trackState.trackNotifiedDownstreamFormats;
        if (!blArray[n2]) {
            Format format = this.trackState.tracks.get(n2).getFormat(0);
            this.mediaSourceEventDispatcher.downstreamFormatChanged(MimeTypes.getTrackType((String)format.sampleMimeType), format, 0, null, this.lastSeekPositionUs);
            blArray[n2] = true;
        }
    }

    private void maybeStartDeferredRetry(int n2) {
        this.assertPrepared();
        Object object = this.trackState.trackIsAudioVideoFlags;
        if (this.pendingDeferredRetry && object[n2]) {
            object = this.sampleQueues[n2];
            if (!((SampleQueue)object).isReady(false)) {
                this.pendingResetPositionUs = 0L;
                this.pendingDeferredRetry = false;
                this.notifyDiscontinuity = true;
                this.lastSeekPositionUs = 0L;
                this.extractedSamplesCountAtStartOfLoad = 0;
                object = this.sampleQueues;
                int n3 = ((Object)object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    ((SampleQueue)object[n2]).reset();
                }
                Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
            }
        }
    }

    private TrackOutput prepareTrackOutput(TrackId sampleQueueArray) {
        int n2;
        int n3 = this.sampleQueues.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!sampleQueueArray.equals(this.sampleQueueTrackIds[n2])) continue;
            return this.sampleQueues[n2];
        }
        SampleQueue sampleQueue = SampleQueue.createWithDrm(this.allocator, this.handler.getLooper(), this.drmSessionManager, this.drmEventDispatcher);
        sampleQueue.setUpstreamFormatChangeListener(this);
        TrackId[] trackIdArray = this.sampleQueueTrackIds;
        n2 = n3 + 1;
        trackIdArray = Arrays.copyOf(trackIdArray, n2);
        trackIdArray[n3] = sampleQueueArray;
        this.sampleQueueTrackIds = Util.castNonNullTypeArray(trackIdArray);
        sampleQueueArray = Arrays.copyOf(this.sampleQueues, n2);
        sampleQueueArray[n3] = sampleQueue;
        this.sampleQueues = Util.castNonNullTypeArray(sampleQueueArray);
        return sampleQueue;
    }

    private boolean seekInsideBufferUs(boolean[] blArray, long l2) {
        int n2 = this.sampleQueues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.sampleQueues[i2].seekTo(l2, false) || !blArray[i2] && this.haveAudioVideoTracks) continue;
            return false;
        }
        return true;
    }

    private void setSeekMap(SeekMap seekMap) {
        SeekMap seekMap2 = this.icyHeaders == null ? seekMap : new SeekMap.Unseekable(-9223372036854775807L);
        this.seekMap = seekMap2;
        this.durationUs = seekMap.getDurationUs();
        long l2 = this.length;
        int n2 = 1;
        boolean bl = l2 == -1L && seekMap.getDurationUs() == -9223372036854775807L;
        this.isLive = bl;
        if (this.isLive) {
            n2 = 7;
        }
        this.dataType = n2;
        this.listener.onSourceInfoRefreshed(this.durationUs, seekMap.isSeekable(), this.isLive);
        if (!this.prepared) {
            this.maybeFinishPrepare();
        }
    }

    private void startLoading() {
        SampleQueue[] sampleQueueArray;
        long l2;
        ExtractingLoadable extractingLoadable = new ExtractingLoadable(this.uri, this.dataSource, this.progressiveMediaExtractor, this, this.loadCondition);
        if (this.prepared) {
            Assertions.checkState(this.isPendingReset());
            l2 = this.durationUs;
            if (l2 != -9223372036854775807L && this.pendingResetPositionUs > l2) {
                this.loadingFinished = true;
                this.pendingResetPositionUs = -9223372036854775807L;
                return;
            }
            extractingLoadable.setLoadPosition(Assertions.checkNotNull(this.seekMap).getSeekPoints((long)this.pendingResetPositionUs).first.position, this.pendingResetPositionUs);
            sampleQueueArray = this.sampleQueues;
            int n2 = sampleQueueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                sampleQueueArray[i2].setStartTimeUs(this.pendingResetPositionUs);
            }
            this.pendingResetPositionUs = -9223372036854775807L;
        }
        this.extractedSamplesCountAtStartOfLoad = this.getExtractedSamplesCount();
        l2 = this.loader.startLoading(extractingLoadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(this.dataType));
        sampleQueueArray = extractingLoadable.dataSpec;
        this.mediaSourceEventDispatcher.loadStarted(new LoadEventInfo(extractingLoadable.loadTaskId, (DataSpec)sampleQueueArray, l2), 1, -1, null, 0, null, extractingLoadable.seekTimeUs, this.durationUs);
    }

    private boolean suppressRead() {
        boolean bl = this.notifyDiscontinuity || this.isPendingReset();
        return bl;
    }

    @Override
    public boolean continueLoading(long l2) {
        if (!(this.loadingFinished || this.loader.hasFatalError() || this.pendingDeferredRetry || this.prepared && this.enabledTrackCount == 0)) {
            boolean bl = this.loadCondition.open();
            if (!this.loader.isLoading()) {
                this.startLoading();
                bl = true;
            }
            return bl;
        }
        return false;
    }

    @Override
    public void discardBuffer(long l2, boolean bl) {
        this.assertPrepared();
        if (this.isPendingReset()) {
            return;
        }
        boolean[] blArray = this.trackState.trackEnabledStates;
        int n2 = this.sampleQueues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sampleQueues[i2].discardTo(l2, bl, blArray[i2]);
        }
    }

    @Override
    public void endTracks() {
        this.sampleQueuesBuilt = true;
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    @Override
    public long getAdjustedSeekPositionUs(long l2, SeekParameters seekParameters) {
        this.assertPrepared();
        if (!this.seekMap.isSeekable()) {
            return 0L;
        }
        SeekMap.SeekPoints seekPoints = this.seekMap.getSeekPoints(l2);
        return seekParameters.resolveSeekPositionUs(l2, seekPoints.first.timeUs, seekPoints.second.timeUs);
    }

    @Override
    public long getBufferedPositionUs() {
        long l2;
        long l3;
        this.assertPrepared();
        boolean[] blArray = this.trackState.trackIsAudioVideoFlags;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        if (this.haveAudioVideoTracks) {
            int n2 = this.sampleQueues.length;
            int n3 = 0;
            l3 = Long.MAX_VALUE;
            while (true) {
                l2 = l3;
                if (n3 < n2) {
                    l2 = l3;
                    if (blArray[n3]) {
                        l2 = l3;
                        if (!this.sampleQueues[n3].isLastSampleQueued()) {
                            l2 = Math.min(l3, this.sampleQueues[n3].getLargestQueuedTimestampUs());
                        }
                    }
                    ++n3;
                    l3 = l2;
                    continue;
                }
                break;
            }
        } else {
            l2 = Long.MAX_VALUE;
        }
        l3 = l2;
        if (l2 == Long.MAX_VALUE) {
            l3 = this.getLargestQueuedTimestampUs();
        }
        l2 = l3;
        if (l3 == Long.MIN_VALUE) {
            l2 = this.lastSeekPositionUs;
        }
        return l2;
    }

    @Override
    public long getNextLoadPositionUs() {
        long l2 = this.enabledTrackCount == 0 ? Long.MIN_VALUE : this.getBufferedPositionUs();
        return l2;
    }

    @Override
    public /* synthetic */ List<StreamKey> getStreamKeys(List<ExoTrackSelection> list) {
        return MediaPeriod._CC.$default$getStreamKeys((MediaPeriod)this, list);
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        this.assertPrepared();
        return this.trackState.tracks;
    }

    TrackOutput icyTrack() {
        return this.prepareTrackOutput(new TrackId(0, true));
    }

    @Override
    public boolean isLoading() {
        boolean bl = this.loader.isLoading() && this.loadCondition.isOpen();
        return bl;
    }

    boolean isReady(int n2) {
        boolean bl = !this.suppressRead() && this.sampleQueues[n2].isReady(this.loadingFinished);
        return bl;
    }

    public /* synthetic */ void lambda$new$0$ProgressiveMediaPeriod() {
        if (!this.released) {
            Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
        }
    }

    public /* synthetic */ void lambda$seekMap$1$ProgressiveMediaPeriod(SeekMap seekMap) {
        this.setSeekMap(seekMap);
    }

    void maybeThrowError() throws IOException {
        this.loader.maybeThrowError(this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(this.dataType));
    }

    void maybeThrowError(int n2) throws IOException {
        this.sampleQueues[n2].maybeThrowError();
        this.maybeThrowError();
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
        if (this.loadingFinished && !this.prepared) {
            throw new ParserException("Loading finished before preparation is complete.");
        }
    }

    @Override
    public void onLoadCanceled(ExtractingLoadable sampleQueueArray, long l2, long l3, boolean bl) {
        StatsDataSource statsDataSource = ((ExtractingLoadable)sampleQueueArray).dataSource;
        statsDataSource = new LoadEventInfo(((ExtractingLoadable)sampleQueueArray).loadTaskId, ((ExtractingLoadable)sampleQueueArray).dataSpec, statsDataSource.getLastOpenedUri(), statsDataSource.getLastResponseHeaders(), l2, l3, statsDataSource.getBytesRead());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(((ExtractingLoadable)sampleQueueArray).loadTaskId);
        this.mediaSourceEventDispatcher.loadCanceled((LoadEventInfo)statsDataSource, 1, -1, null, 0, null, ((ExtractingLoadable)sampleQueueArray).seekTimeUs, this.durationUs);
        if (!bl) {
            this.copyLengthFromLoader((ExtractingLoadable)sampleQueueArray);
            sampleQueueArray = this.sampleQueues;
            int n2 = sampleQueueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                sampleQueueArray[i2].reset();
            }
            if (this.enabledTrackCount > 0) {
                Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
            }
        }
    }

    @Override
    public void onLoadCompleted(ExtractingLoadable extractingLoadable, long l2, long l3) {
        SeekMap seekMap;
        if (this.durationUs == -9223372036854775807L && (seekMap = this.seekMap) != null) {
            boolean bl = seekMap.isSeekable();
            long l4 = this.getLargestQueuedTimestampUs();
            l4 = l4 == Long.MIN_VALUE ? 0L : (l4 += 10000L);
            this.durationUs = l4;
            this.listener.onSourceInfoRefreshed(this.durationUs, bl, this.isLive);
        }
        seekMap = extractingLoadable.dataSource;
        seekMap = new LoadEventInfo(extractingLoadable.loadTaskId, extractingLoadable.dataSpec, seekMap.getLastOpenedUri(), seekMap.getLastResponseHeaders(), l2, l3, seekMap.getBytesRead());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(extractingLoadable.loadTaskId);
        this.mediaSourceEventDispatcher.loadCompleted((LoadEventInfo)seekMap, 1, -1, null, 0, null, extractingLoadable.seekTimeUs, this.durationUs);
        this.copyLengthFromLoader(extractingLoadable);
        this.loadingFinished = true;
        Assertions.checkNotNull(this.callback).onContinueLoadingRequested(this);
    }

    @Override
    public Loader.LoadErrorAction onLoadError(ExtractingLoadable extractingLoadable, long l2, long l3, IOException iOException, int n2) {
        boolean bl;
        this.copyLengthFromLoader(extractingLoadable);
        Object object = extractingLoadable.dataSource;
        LoadEventInfo loadEventInfo = new LoadEventInfo(extractingLoadable.loadTaskId, extractingLoadable.dataSpec, object.getLastOpenedUri(), object.getLastResponseHeaders(), l2, l3, object.getBytesRead());
        object = new MediaLoadData(1, -1, null, 0, null, C.usToMs(extractingLoadable.seekTimeUs), C.usToMs(this.durationUs));
        l2 = this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, (MediaLoadData)object, iOException, n2));
        if (l2 == -9223372036854775807L) {
            object = Loader.DONT_RETRY_FATAL;
        } else {
            n2 = this.getExtractedSamplesCount();
            bl = n2 > this.extractedSamplesCountAtStartOfLoad;
            object = this.configureRetry(extractingLoadable, n2) ? Loader.createRetryAction(bl, l2) : Loader.DONT_RETRY;
        }
        bl = ((Loader.LoadErrorAction)object).isRetry() ^ true;
        this.mediaSourceEventDispatcher.loadError(loadEventInfo, 1, -1, null, 0, null, extractingLoadable.seekTimeUs, this.durationUs, iOException, bl);
        if (bl) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(extractingLoadable.loadTaskId);
        }
        return object;
    }

    @Override
    public void onLoaderReleased() {
        SampleQueue[] sampleQueueArray = this.sampleQueues;
        int n2 = sampleQueueArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sampleQueueArray[i2].release();
        }
        this.progressiveMediaExtractor.release();
    }

    @Override
    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    @Override
    public void prepare(MediaPeriod.Callback callback2, long l2) {
        this.callback = callback2;
        this.loadCondition.open();
        this.startLoading();
    }

    int readData(int n2, FormatHolder formatHolder, DecoderInputBuffer decoderInputBuffer, boolean bl) {
        if (this.suppressRead()) {
            return -3;
        }
        this.maybeNotifyDownstreamFormat(n2);
        int n3 = this.sampleQueues[n2].read(formatHolder, decoderInputBuffer, bl, this.loadingFinished);
        if (n3 == -3) {
            this.maybeStartDeferredRetry(n2);
        }
        return n3;
    }

    @Override
    public long readDiscontinuity() {
        if (this.notifyDiscontinuity && (this.loadingFinished || this.getExtractedSamplesCount() > this.extractedSamplesCountAtStartOfLoad)) {
            this.notifyDiscontinuity = false;
            return this.lastSeekPositionUs;
        }
        return -9223372036854775807L;
    }

    @Override
    public void reevaluateBuffer(long l2) {
    }

    public void release() {
        if (this.prepared) {
            SampleQueue[] sampleQueueArray = this.sampleQueues;
            int n2 = sampleQueueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                sampleQueueArray[i2].preRelease();
            }
        }
        this.loader.release(this);
        this.handler.removeCallbacksAndMessages(null);
        this.callback = null;
        this.released = true;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.handler.post((Runnable)new _$$Lambda$ProgressiveMediaPeriod$g0rAX0fUGYs_ZNigG_uJ9uWsNPk(this, seekMap));
    }

    @Override
    public long seekToUs(long l2) {
        int n2;
        this.assertPrepared();
        Object[] objectArray = this.trackState.trackIsAudioVideoFlags;
        if (!this.seekMap.isSeekable()) {
            l2 = 0L;
        }
        int n3 = 0;
        this.notifyDiscontinuity = false;
        this.lastSeekPositionUs = l2;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = l2;
            return l2;
        }
        if (this.dataType != 7 && this.seekInsideBufferUs((boolean[])objectArray, l2)) {
            return l2;
        }
        this.pendingDeferredRetry = false;
        this.pendingResetPositionUs = l2;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            objectArray = this.sampleQueues;
            n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray[n2].discardToEnd();
            }
            this.loader.cancelLoading();
        } else {
            this.loader.clearFatalError();
            objectArray = this.sampleQueues;
            int n4 = objectArray.length;
            for (n2 = n3; n2 < n4; ++n2) {
                objectArray[n2].reset();
            }
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public long selectTracks(ExoTrackSelection[] objectArray, boolean[] object, SampleStream[] sampleStreamArray, boolean[] blArray, long l2) {
        long l3;
        block13: {
            long l4;
            int n2;
            void var3_5;
            int n3;
            int n4;
            block14: {
                Object object2;
                this.assertPrepared();
                TrackGroupArray trackGroupArray = this.trackState.tracks;
                boolean[] blArray2 = this.trackState.trackEnabledStates;
                int n5 = this.enabledTrackCount;
                int n6 = 0;
                n4 = 0;
                int n7 = 0;
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (var3_5[n3] == null || objectArray[n3] != null && object2[n3] != false) continue;
                    n2 = ((SampleStreamImpl)var3_5[n3]).track;
                    Assertions.checkState(blArray2[n2]);
                    --this.enabledTrackCount;
                    blArray2[n2] = false;
                    var3_5[n3] = null;
                }
                n3 = (this.seenFirstTrackSelection ? n5 == 0 : l4 != 0L) ? 1 : 0;
                n2 = n3;
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    n3 = n2;
                    if (var3_5[n5] == null) {
                        n3 = n2;
                        if (objectArray[n5] != null) {
                            object2 = objectArray[n5];
                            boolean bl = object2.length() == 1;
                            Assertions.checkState(bl);
                            bl = object2.getIndexInTrackGroup(0) == 0;
                            Assertions.checkState(bl);
                            int n8 = trackGroupArray.indexOf(object2.getTrackGroup());
                            Assertions.checkState(blArray2[n8] ^ true);
                            ++this.enabledTrackCount;
                            blArray2[n8] = true;
                            var3_5[n5] = new SampleStreamImpl(n8);
                            var4_6[n5] = true;
                            n3 = n2;
                            if (n2 == 0) {
                                object2 = this.sampleQueues[n8];
                                n3 = !((SampleQueue)object2).seekTo(l4, true) && ((SampleQueue)object2).getReadIndex() != 0 ? 1 : 0;
                            }
                        }
                    }
                    n2 = n3;
                }
                if (this.enabledTrackCount != 0) break block14;
                this.pendingDeferredRetry = false;
                this.notifyDiscontinuity = false;
                if (this.loader.isLoading()) {
                    SampleQueue[] sampleQueueArray = this.sampleQueues;
                    n5 = sampleQueueArray.length;
                    for (n3 = n7; n3 < n5; ++n3) {
                        sampleQueueArray[n3].discardToEnd();
                    }
                    this.loader.cancelLoading();
                    l3 = l4;
                    break block13;
                } else {
                    SampleQueue[] sampleQueueArray = this.sampleQueues;
                    n5 = sampleQueueArray.length;
                    n3 = n6;
                    while (true) {
                        l3 = l4;
                        if (n3 < n5) {
                            sampleQueueArray[n3].reset();
                            ++n3;
                            continue;
                        }
                        break block13;
                        break;
                    }
                }
            }
            l3 = l4;
            if (n2 != 0) {
                l4 = this.seekToUs(l4);
                n3 = n4;
                while (true) {
                    l3 = l4;
                    if (n3 >= ((void)var3_5).length) break;
                    if (var3_5[n3] != null) {
                        var4_6[n3] = true;
                    }
                    ++n3;
                }
            }
        }
        this.seenFirstTrackSelection = true;
        return l3;
    }

    int skipData(int n2, long l2) {
        if (this.suppressRead()) {
            return 0;
        }
        this.maybeNotifyDownstreamFormat(n2);
        SampleQueue sampleQueue = this.sampleQueues[n2];
        int n3 = sampleQueue.getSkipCount(l2, this.loadingFinished);
        sampleQueue.skip(n3);
        if (n3 == 0) {
            this.maybeStartDeferredRetry(n2);
        }
        return n3;
    }

    @Override
    public TrackOutput track(int n2, int n3) {
        return this.prepareTrackOutput(new TrackId(n2, false));
    }

    final class ExtractingLoadable
    implements Loader.Loadable,
    IcyDataSource.Listener {
        private final StatsDataSource dataSource;
        private DataSpec dataSpec;
        private final ExtractorOutput extractorOutput;
        private TrackOutput icyTrackOutput;
        private long length;
        private volatile boolean loadCanceled;
        private final ConditionVariable loadCondition;
        private final long loadTaskId;
        private boolean pendingExtractorSeek;
        private final PositionHolder positionHolder;
        private final ProgressiveMediaExtractor progressiveMediaExtractor;
        private long seekTimeUs;
        private boolean seenIcyMetadata;
        private final Uri uri;

        public ExtractingLoadable(Uri uri, DataSource dataSource, ProgressiveMediaExtractor progressiveMediaExtractor, ExtractorOutput extractorOutput, ConditionVariable conditionVariable) {
            this.uri = uri;
            this.dataSource = new StatsDataSource(dataSource);
            this.progressiveMediaExtractor = progressiveMediaExtractor;
            this.extractorOutput = extractorOutput;
            this.loadCondition = conditionVariable;
            this.positionHolder = new PositionHolder();
            this.pendingExtractorSeek = true;
            this.length = -1L;
            this.loadTaskId = LoadEventInfo.getNewId();
            this.dataSpec = this.buildDataSpec(0L);
        }

        private DataSpec buildDataSpec(long l2) {
            return new DataSpec.Builder().setUri(this.uri).setPosition(l2).setKey(ProgressiveMediaPeriod.this.customCacheKey).setFlags(6).setHttpRequestHeaders(ICY_METADATA_HEADERS).build();
        }

        private void setLoadPosition(long l2, long l3) {
            this.positionHolder.position = l2;
            this.seekTimeUs = l3;
            this.pendingExtractorSeek = true;
            this.seenIcyMetadata = false;
        }

        @Override
        public void cancelLoad() {
            this.loadCanceled = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void load() throws IOException {
            int n2 = 0;
            while (n2 == 0 && !this.loadCanceled) {
                block14: {
                    int n3;
                    int n4 = n2;
                    try {
                        Object object2;
                        long l3 = this.positionHolder.position;
                        n4 = n2;
                        this.dataSpec = this.buildDataSpec(l3);
                        n4 = n2;
                        this.length = this.dataSource.open(this.dataSpec);
                        n4 = n2;
                        if (this.length != -1L) {
                            n4 = n2;
                            this.length += l3;
                        }
                        n4 = n2;
                        ProgressiveMediaPeriod.access$702(ProgressiveMediaPeriod.this, IcyHeaders.parse((Map)this.dataSource.getResponseHeaders()));
                        n4 = n2;
                        Object object = object2 = this.dataSource;
                        n4 = n2;
                        if (ProgressiveMediaPeriod.this.icyHeaders != null) {
                            object = object2;
                            n4 = n2;
                            if (((ProgressiveMediaPeriod)ProgressiveMediaPeriod.this).icyHeaders.metadataInterval != -1) {
                                n4 = n2;
                                n4 = n2;
                                object = new IcyDataSource((DataSource)this.dataSource, ((ProgressiveMediaPeriod)ProgressiveMediaPeriod.this).icyHeaders.metadataInterval, this);
                                n4 = n2;
                                this.icyTrackOutput = ProgressiveMediaPeriod.this.icyTrack();
                                n4 = n2;
                                this.icyTrackOutput.format(ICY_FORMAT);
                            }
                        }
                        n4 = n2;
                        ProgressiveMediaExtractor progressiveMediaExtractor = this.progressiveMediaExtractor;
                        n4 = n2;
                        Uri uri = this.uri;
                        n4 = n2;
                        object2 = this.dataSource.getResponseHeaders();
                        n4 = n2;
                        long l2 = this.length;
                        n4 = n2;
                        ExtractorOutput extractorOutput = this.extractorOutput;
                        long l4 = l3;
                        n4 = n2;
                        progressiveMediaExtractor.init((DataReader)object, uri, (Map)object2, l3, l2, extractorOutput);
                        n4 = n2;
                        if (ProgressiveMediaPeriod.this.icyHeaders != null) {
                            n4 = n2;
                            this.progressiveMediaExtractor.disableSeekingOnMp3Streams();
                        }
                        n3 = n2;
                        l3 = l4;
                        n4 = n2;
                        if (this.pendingExtractorSeek) {
                            n4 = n2;
                            this.progressiveMediaExtractor.seek(l4, this.seekTimeUs);
                            n4 = n2;
                            this.pendingExtractorSeek = false;
                            l3 = l4;
                            n3 = n2;
                        }
                        while (n3 == 0) {
                            n4 = n3;
                            boolean bl = this.loadCanceled;
                            if (bl) break;
                            n4 = n3;
                            try {
                                this.loadCondition.block();
                                n4 = n3;
                            }
                            catch (InterruptedException interruptedException) {
                                n4 = n3;
                                n4 = n3;
                                InterruptedIOException throwable = new InterruptedIOException();
                                n4 = n3;
                                throw throwable;
                            }
                            n4 = n2 = this.progressiveMediaExtractor.read(this.positionHolder);
                            l4 = this.progressiveMediaExtractor.getCurrentInputPosition();
                            n3 = n2;
                            n4 = n2;
                            if (l4 <= ProgressiveMediaPeriod.this.continueLoadingCheckIntervalBytes + l3) continue;
                            n4 = n2;
                            this.loadCondition.close();
                            n4 = n2;
                            ProgressiveMediaPeriod.this.handler.post(ProgressiveMediaPeriod.this.onContinueLoadingRequestedRunnable);
                            l3 = l4;
                            n3 = n2;
                        }
                        if (n3 == 1) {
                            n2 = 0;
                            break block14;
                        }
                        n2 = n3;
                    }
                    catch (Throwable throwable) {
                        if (n4 != 1 && this.progressiveMediaExtractor.getCurrentInputPosition() != -1L) {
                            this.positionHolder.position = this.progressiveMediaExtractor.getCurrentInputPosition();
                        }
                        Util.closeQuietly((DataSource)this.dataSource);
                        throw throwable;
                    }
                    if (this.progressiveMediaExtractor.getCurrentInputPosition() != -1L) {
                        this.positionHolder.position = this.progressiveMediaExtractor.getCurrentInputPosition();
                        n2 = n3;
                    }
                }
                Util.closeQuietly((DataSource)this.dataSource);
            }
        }

        @Override
        public void onIcyMetadata(ParsableByteArray parsableByteArray) {
            long l2 = !this.seenIcyMetadata ? this.seekTimeUs : Math.max(ProgressiveMediaPeriod.this.getLargestQueuedTimestampUs(), this.seekTimeUs);
            int n2 = parsableByteArray.bytesLeft();
            TrackOutput trackOutput = Assertions.checkNotNull(this.icyTrackOutput);
            trackOutput.sampleData(parsableByteArray, n2);
            trackOutput.sampleMetadata(l2, 1, n2, 0, null);
            this.seenIcyMetadata = true;
        }
    }

    static interface Listener {
        public void onSourceInfoRefreshed(long var1, boolean var3, boolean var4);
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private final int track;

        public SampleStreamImpl(int n2) {
            this.track = n2;
        }

        @Override
        public boolean isReady() {
            return ProgressiveMediaPeriod.this.isReady(this.track);
        }

        @Override
        public void maybeThrowError() throws IOException {
            ProgressiveMediaPeriod.this.maybeThrowError(this.track);
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer decoderInputBuffer, boolean bl) {
            return ProgressiveMediaPeriod.this.readData(this.track, formatHolder, decoderInputBuffer, bl);
        }

        @Override
        public int skipData(long l2) {
            return ProgressiveMediaPeriod.this.skipData(this.track, l2);
        }
    }

    private static final class TrackId {
        public final int id;
        public final boolean isIcyTrack;

        public TrackId(int n2, boolean bl) {
            this.id = n2;
            this.isIcyTrack = bl;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (TrackId)object;
                if (this.id != ((TrackId)object).id || this.isIcyTrack != ((TrackId)object).isIcyTrack) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return this.id * 31 + this.isIcyTrack;
        }
    }

    private static final class TrackState {
        public final boolean[] trackEnabledStates;
        public final boolean[] trackIsAudioVideoFlags;
        public final boolean[] trackNotifiedDownstreamFormats;
        public final TrackGroupArray tracks;

        public TrackState(TrackGroupArray trackGroupArray, boolean[] blArray) {
            this.tracks = trackGroupArray;
            this.trackIsAudioVideoFlags = blArray;
            this.trackEnabledStates = new boolean[trackGroupArray.length];
            this.trackNotifiedDownstreamFormats = new boolean[trackGroupArray.length];
        }
    }
}

