/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.ClippingMediaPeriod;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.ForwardingTimeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaPeriodId;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MergingMediaPeriod;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MergingMediaSource
extends CompositeMediaSource<Integer> {
    private static final MediaItem EMPTY_MEDIA_ITEM = new MediaItem.Builder().setMediaId("MergingMediaSource").build();
    private static final int PERIOD_COUNT_UNSET = -1;
    private final boolean adjustPeriodTimeOffsets;
    private final boolean clipDurations;
    private final Map<Object, Long> clippedDurationsUs;
    private final Multimap<Object, ClippingMediaPeriod> clippedMediaPeriods;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final MediaSource[] mediaSources;
    private IllegalMergeException mergeError;
    private final ArrayList<MediaSource> pendingTimelineSources;
    private int periodCount;
    private long[][] periodTimeOffsetsUs;
    private final Timeline[] timelines;

    public MergingMediaSource(boolean bl, boolean bl2, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, MediaSource ... mediaSourceArray) {
        this.adjustPeriodTimeOffsets = bl;
        this.clipDurations = bl2;
        this.mediaSources = mediaSourceArray;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.pendingTimelineSources = new ArrayList<MediaSource>(Arrays.asList(mediaSourceArray));
        this.periodCount = -1;
        this.timelines = new Timeline[mediaSourceArray.length];
        this.periodTimeOffsetsUs = new long[0][];
        this.clippedDurationsUs = new HashMap<Object, Long>();
        this.clippedMediaPeriods = MultimapBuilder.hashKeys().arrayListValues().build();
    }

    public MergingMediaSource(boolean bl, boolean bl2, MediaSource ... mediaSourceArray) {
        this(bl, bl2, (CompositeSequenceableLoaderFactory)new DefaultCompositeSequenceableLoaderFactory(), mediaSourceArray);
    }

    public MergingMediaSource(boolean bl, MediaSource ... mediaSourceArray) {
        this(bl, false, mediaSourceArray);
    }

    public MergingMediaSource(MediaSource ... mediaSourceArray) {
        this(false, mediaSourceArray);
    }

    private void computePeriodTimeOffsets() {
        Timeline.Period period = new Timeline.Period();
        for (int i2 = 0; i2 < this.periodCount; ++i2) {
            Timeline[] timelineArray;
            long l2 = -this.timelines[0].getPeriod(i2, period).getPositionInWindowUs();
            for (int i3 = 1; i3 < (timelineArray = this.timelines).length; ++i3) {
                long l3 = -timelineArray[i3].getPeriod(i2, period).getPositionInWindowUs();
                this.periodTimeOffsetsUs[i2][i3] = l2 - l3;
            }
        }
    }

    private void updateClippedDuration() {
        Timeline.Period period = new Timeline.Period();
        for (int i2 = 0; i2 < this.periodCount; ++i2) {
            Object object;
            long l2 = Long.MIN_VALUE;
            for (int i3 = 0; i3 < ((Timeline[])(object = this.timelines)).length; ++i3) {
                long l3;
                block6: {
                    long l4;
                    block7: {
                        block5: {
                            l3 = object[i3].getPeriod(i2, period).getDurationUs();
                            if (l3 != -9223372036854775807L) break block5;
                            l3 = l2;
                            break block6;
                        }
                        l4 = l3 + this.periodTimeOffsetsUs[i2][i3];
                        if (l2 == Long.MIN_VALUE) break block7;
                        l3 = l2;
                        if (l4 >= l2) break block6;
                    }
                    l3 = l4;
                }
                l2 = l3;
            }
            object = object[0].getUidOfPeriod(i2);
            this.clippedDurationsUs.put(object, l2);
            object = this.clippedMediaPeriods.get(object).iterator();
            while (object.hasNext()) {
                ((ClippingMediaPeriod)object.next()).updateClipping(0L, l2);
            }
        }
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId mediaPeriodId, Allocator allocator, long l2) {
        MediaPeriod[] mediaPeriodArray = new MediaPeriod[this.mediaSources.length];
        MediaPeriodId mediaPeriodId2 = this.timelines;
        int n2 = mediaPeriodId2[0].getIndexOfPeriod(mediaPeriodId.periodUid);
        for (int i2 = 0; i2 < mediaPeriodArray.length; ++i2) {
            mediaPeriodId2 = mediaPeriodId.copyWithPeriodUid(this.timelines[i2].getUidOfPeriod(n2));
            mediaPeriodArray[i2] = this.mediaSources[i2].createPeriod((MediaSource.MediaPeriodId)mediaPeriodId2, allocator, l2 - this.periodTimeOffsetsUs[n2][i2]);
        }
        allocator = new MergingMediaPeriod(this.compositeSequenceableLoaderFactory, this.periodTimeOffsetsUs[n2], mediaPeriodArray);
        if (this.clipDurations) {
            allocator = new ClippingMediaPeriod((MediaPeriod)allocator, true, 0L, Assertions.checkNotNull(this.clippedDurationsUs.get(mediaPeriodId.periodUid)).longValue());
            this.clippedMediaPeriods.put(mediaPeriodId.periodUid, (ClippingMediaPeriod)allocator);
            mediaPeriodId = allocator;
        } else {
            mediaPeriodId = allocator;
        }
        return mediaPeriodId;
    }

    @Override
    public MediaItem getMediaItem() {
        MediaItem mediaItem = this.mediaSources;
        mediaItem = ((MediaSource[])mediaItem).length > 0 ? mediaItem[0].getMediaItem() : EMPTY_MEDIA_ITEM;
        return mediaItem;
    }

    @Override
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Integer n2, MediaSource.MediaPeriodId mediaPeriodId) {
        if (n2 != 0) {
            mediaPeriodId = null;
        }
        return mediaPeriodId;
    }

    @Override
    @Deprecated
    public Object getTag() {
        Object object = this.mediaSources;
        object = ((MediaSource[])object).length > 0 ? object[0].getTag() : null;
        return object;
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        IllegalMergeException illegalMergeException = this.mergeError;
        if (illegalMergeException == null) {
            super.maybeThrowSourceInfoRefreshError();
            return;
        }
        throw illegalMergeException;
    }

    @Override
    protected void onChildSourceInfoRefreshed(Integer object, MediaSource mediaSource, Timeline timeline) {
        if (this.mergeError != null) {
            return;
        }
        if (this.periodCount == -1) {
            this.periodCount = timeline.getPeriodCount();
        } else if (timeline.getPeriodCount() != this.periodCount) {
            this.mergeError = new IllegalMergeException(0);
            return;
        }
        if (this.periodTimeOffsetsUs.length == 0) {
            this.periodTimeOffsetsUs = new long[this.periodCount][this.timelines.length];
        }
        this.pendingTimelineSources.remove(mediaSource);
        this.timelines[((Integer)object).intValue()] = timeline;
        if (this.pendingTimelineSources.isEmpty()) {
            if (this.adjustPeriodTimeOffsets) {
                this.computePeriodTimeOffsets();
            }
            mediaSource = this.timelines[0];
            object = mediaSource;
            if (this.clipDurations) {
                this.updateClippedDuration();
                object = new ClippedTimeline((Timeline)mediaSource, this.clippedDurationsUs);
            }
            this.refreshSourceInfo((Timeline)object);
        }
    }

    @Override
    protected void prepareSourceInternal(TransferListener transferListener) {
        super.prepareSourceInternal(transferListener);
        for (int i2 = 0; i2 < this.mediaSources.length; ++i2) {
            this.prepareChildSource(i2, this.mediaSources[i2]);
        }
    }

    @Override
    public void releasePeriod(MediaPeriod object3) {
        Object object = object3;
        if (this.clipDurations) {
            object = (ClippingMediaPeriod)object3;
            for (Map.Entry<Object, ClippingMediaPeriod> entry : this.clippedMediaPeriods.entries()) {
                if (!entry.getValue().equals(object)) continue;
                this.clippedMediaPeriods.remove(entry.getKey(), entry.getValue());
                break;
            }
            object = object.mediaPeriod;
        }
        MergingMediaPeriod mergingMediaPeriod = (MergingMediaPeriod)object;
        for (int i2 = 0; i2 < ((MediaSource[])(object = this.mediaSources)).length; ++i2) {
            object[i2].releasePeriod(mergingMediaPeriod.getChildPeriod(i2));
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        Arrays.fill(this.timelines, null);
        this.periodCount = -1;
        this.mergeError = null;
        this.pendingTimelineSources.clear();
        Collections.addAll(this.pendingTimelineSources, this.mediaSources);
    }

    private static final class ClippedTimeline
    extends ForwardingTimeline {
        private final long[] periodDurationsUs;
        private final long[] windowDurationsUs;

        public ClippedTimeline(Timeline timeline, Map<Object, Long> map) {
            super(timeline);
            int n2;
            int n3 = timeline.getWindowCount();
            this.windowDurationsUs = new long[timeline.getWindowCount()];
            Timeline.Window window = new Timeline.Window();
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                this.windowDurationsUs[n2] = timeline.getWindow((int)n2, (Timeline.Window)window).durationUs;
            }
            n3 = timeline.getPeriodCount();
            this.periodDurationsUs = new long[n3];
            window = new Timeline.Period();
            for (n2 = n4; n2 < n3; ++n2) {
                timeline.getPeriod(n2, (Timeline.Period)window, true);
                long l2 = Assertions.checkNotNull(map.get(window.uid));
                long[] lArray = this.periodDurationsUs;
                if (l2 == Long.MIN_VALUE) {
                    l2 = window.durationUs;
                }
                lArray[n2] = l2;
                if (window.durationUs == -9223372036854775807L) continue;
                lArray = this.windowDurationsUs;
                n4 = window.windowIndex;
                lArray[n4] = lArray[n4] - (window.durationUs - this.periodDurationsUs[n2]);
            }
        }

        public Timeline.Period getPeriod(int n2, Timeline.Period period, boolean bl) {
            super.getPeriod(n2, period, bl);
            period.durationUs = this.periodDurationsUs[n2];
            return period;
        }

        public Timeline.Window getWindow(int n2, Timeline.Window window, long l2) {
            super.getWindow(n2, window, l2);
            window.durationUs = this.windowDurationsUs[n2];
            l2 = window.durationUs != -9223372036854775807L && window.defaultPositionUs != -9223372036854775807L ? Math.min(window.defaultPositionUs, window.durationUs) : window.defaultPositionUs;
            window.defaultPositionUs = l2;
            return window;
        }
    }

    public static final class IllegalMergeException
    extends IOException {
        public static final int REASON_PERIOD_COUNT_MISMATCH = 0;
        public final int reason;

        public IllegalMergeException(int n2) {
            this.reason = n2;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }
}

