/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source._$;
import com.google.android.exoplayer2.source._$$Lambda$MediaSourceEventListener$EventDispatcher$RIFDO9msYkn72bNDpmyhv5rAFKY;
import com.google.android.exoplayer2.source._$$Lambda$MediaSourceEventListener$EventDispatcher$h8bUcr8Ot_gMcu9Yr8fz_qHgReM;
import com.google.android.exoplayer2.source._$$Lambda$MediaSourceEventListener$EventDispatcher$wGoNlRlXeYTKNdaMsEykBJTWloc;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;

public interface MediaSourceEventListener {
    public void onDownstreamFormatChanged(int var1, MediaSource.MediaPeriodId var2, MediaLoadData var3);

    public void onLoadCanceled(int var1, MediaSource.MediaPeriodId var2, LoadEventInfo var3, MediaLoadData var4);

    public void onLoadCompleted(int var1, MediaSource.MediaPeriodId var2, LoadEventInfo var3, MediaLoadData var4);

    public void onLoadError(int var1, MediaSource.MediaPeriodId var2, LoadEventInfo var3, MediaLoadData var4, IOException var5, boolean var6);

    public void onLoadStarted(int var1, MediaSource.MediaPeriodId var2, LoadEventInfo var3, MediaLoadData var4);

    public void onUpstreamDiscarded(int var1, MediaSource.MediaPeriodId var2, MediaLoadData var3);

    public static class EventDispatcher {
        private final CopyOnWriteArrayList<ListenerAndHandler> listenerAndHandlers;
        public final MediaSource.MediaPeriodId mediaPeriodId;
        private final long mediaTimeOffsetMs;
        public final int windowIndex;

        public EventDispatcher() {
            this(new CopyOnWriteArrayList<ListenerAndHandler>(), 0, null, 0L);
        }

        private EventDispatcher(CopyOnWriteArrayList<ListenerAndHandler> copyOnWriteArrayList, int n2, MediaSource.MediaPeriodId mediaPeriodId, long l2) {
            this.listenerAndHandlers = copyOnWriteArrayList;
            this.windowIndex = n2;
            this.mediaPeriodId = mediaPeriodId;
            this.mediaTimeOffsetMs = l2;
        }

        private long adjustMediaTime(long l2) {
            long l3 = C.usToMs(l2);
            l2 = -9223372036854775807L;
            if (l3 != -9223372036854775807L) {
                l2 = this.mediaTimeOffsetMs + l3;
            }
            return l2;
        }

        public void addEventListener(Handler handler, MediaSourceEventListener mediaSourceEventListener) {
            Assertions.checkNotNull(handler);
            Assertions.checkNotNull(mediaSourceEventListener);
            this.listenerAndHandlers.add(new ListenerAndHandler(handler, mediaSourceEventListener));
        }

        public void downstreamFormatChanged(int n2, Format format, int n3, Object object, long l2) {
            this.downstreamFormatChanged(new MediaLoadData(1, n2, format, n3, object, this.adjustMediaTime(l2), -9223372036854775807L));
        }

        public void downstreamFormatChanged(MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener mediaSourceEventListener = listenerAndHandler.listener;
                Util.postOrRun(listenerAndHandler.handler, (Runnable)new _$.Lambda.MediaSourceEventListener.EventDispatcher.lXgSj_TgNs51HV_3_11Y_SYdt1k(this, mediaSourceEventListener, mediaLoadData));
            }
        }

        public /* synthetic */ void lambda$downstreamFormatChanged$5$MediaSourceEventListener$EventDispatcher(MediaSourceEventListener mediaSourceEventListener, MediaLoadData mediaLoadData) {
            mediaSourceEventListener.onDownstreamFormatChanged(this.windowIndex, this.mediaPeriodId, mediaLoadData);
        }

        public /* synthetic */ void lambda$loadCanceled$2$MediaSourceEventListener$EventDispatcher(MediaSourceEventListener mediaSourceEventListener, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            mediaSourceEventListener.onLoadCanceled(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData);
        }

        public /* synthetic */ void lambda$loadCompleted$1$MediaSourceEventListener$EventDispatcher(MediaSourceEventListener mediaSourceEventListener, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            mediaSourceEventListener.onLoadCompleted(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData);
        }

        public /* synthetic */ void lambda$loadError$3$MediaSourceEventListener$EventDispatcher(MediaSourceEventListener mediaSourceEventListener, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException iOException, boolean bl) {
            mediaSourceEventListener.onLoadError(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData, iOException, bl);
        }

        public /* synthetic */ void lambda$loadStarted$0$MediaSourceEventListener$EventDispatcher(MediaSourceEventListener mediaSourceEventListener, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            mediaSourceEventListener.onLoadStarted(this.windowIndex, this.mediaPeriodId, loadEventInfo, mediaLoadData);
        }

        public /* synthetic */ void lambda$upstreamDiscarded$4$MediaSourceEventListener$EventDispatcher(MediaSourceEventListener mediaSourceEventListener, MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
            mediaSourceEventListener.onUpstreamDiscarded(this.windowIndex, mediaPeriodId, mediaLoadData);
        }

        public void loadCanceled(LoadEventInfo loadEventInfo, int n2) {
            this.loadCanceled(loadEventInfo, n2, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L);
        }

        public void loadCanceled(LoadEventInfo loadEventInfo, int n2, int n3, Format format, int n4, Object object, long l2, long l3) {
            this.loadCanceled(loadEventInfo, new MediaLoadData(n2, n3, format, n4, object, this.adjustMediaTime(l2), this.adjustMediaTime(l3)));
        }

        public void loadCanceled(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener mediaSourceEventListener = listenerAndHandler.listener;
                Util.postOrRun(listenerAndHandler.handler, (Runnable)new _$.Lambda.MediaSourceEventListener.EventDispatcher.Jm0OeQ0IopM_KXSMoqCgenhI3pE(this, mediaSourceEventListener, loadEventInfo, mediaLoadData));
            }
        }

        public void loadCompleted(LoadEventInfo loadEventInfo, int n2) {
            this.loadCompleted(loadEventInfo, n2, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L);
        }

        public void loadCompleted(LoadEventInfo loadEventInfo, int n2, int n3, Format format, int n4, Object object, long l2, long l3) {
            this.loadCompleted(loadEventInfo, new MediaLoadData(n2, n3, format, n4, object, this.adjustMediaTime(l2), this.adjustMediaTime(l3)));
        }

        public void loadCompleted(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener mediaSourceEventListener = listenerAndHandler.listener;
                Util.postOrRun(listenerAndHandler.handler, new _$$Lambda$MediaSourceEventListener$EventDispatcher$h8bUcr8Ot_gMcu9Yr8fz_qHgReM(this, mediaSourceEventListener, loadEventInfo, mediaLoadData));
            }
        }

        public void loadError(LoadEventInfo loadEventInfo, int n2, int n3, Format format, int n4, Object object, long l2, long l3, IOException iOException, boolean bl) {
            this.loadError(loadEventInfo, new MediaLoadData(n2, n3, format, n4, object, this.adjustMediaTime(l2), this.adjustMediaTime(l3)), iOException, bl);
        }

        public void loadError(LoadEventInfo loadEventInfo, int n2, IOException iOException, boolean bl) {
            this.loadError(loadEventInfo, n2, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L, iOException, bl);
        }

        public void loadError(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException iOException, boolean bl) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener mediaSourceEventListener = listenerAndHandler.listener;
                Util.postOrRun(listenerAndHandler.handler, new _$$Lambda$MediaSourceEventListener$EventDispatcher$RIFDO9msYkn72bNDpmyhv5rAFKY(this, mediaSourceEventListener, loadEventInfo, mediaLoadData, iOException, bl));
            }
        }

        public void loadStarted(LoadEventInfo loadEventInfo, int n2) {
            this.loadStarted(loadEventInfo, n2, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L);
        }

        public void loadStarted(LoadEventInfo loadEventInfo, int n2, int n3, Format format, int n4, Object object, long l2, long l3) {
            this.loadStarted(loadEventInfo, new MediaLoadData(n2, n3, format, n4, object, this.adjustMediaTime(l2), this.adjustMediaTime(l3)));
        }

        public void loadStarted(LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener mediaSourceEventListener = listenerAndHandler.listener;
                Util.postOrRun(listenerAndHandler.handler, (Runnable)new _$.Lambda.MediaSourceEventListener.EventDispatcher.jgZ8dQ5CK34j6VrAzMlnVEac2G8(this, mediaSourceEventListener, loadEventInfo, mediaLoadData));
            }
        }

        public void removeEventListener(MediaSourceEventListener mediaSourceEventListener) {
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                if (listenerAndHandler.listener != mediaSourceEventListener) continue;
                this.listenerAndHandlers.remove(listenerAndHandler);
            }
        }

        public void upstreamDiscarded(int n2, long l2, long l3) {
            this.upstreamDiscarded(new MediaLoadData(1, n2, null, 3, null, this.adjustMediaTime(l2), this.adjustMediaTime(l3)));
        }

        public void upstreamDiscarded(MediaLoadData mediaLoadData) {
            MediaSource.MediaPeriodId mediaPeriodId = Assertions.checkNotNull(this.mediaPeriodId);
            for (ListenerAndHandler listenerAndHandler : this.listenerAndHandlers) {
                MediaSourceEventListener mediaSourceEventListener = listenerAndHandler.listener;
                Util.postOrRun(listenerAndHandler.handler, new _$$Lambda$MediaSourceEventListener$EventDispatcher$wGoNlRlXeYTKNdaMsEykBJTWloc(this, mediaSourceEventListener, mediaPeriodId, mediaLoadData));
            }
        }

        public EventDispatcher withParameters(int n2, MediaSource.MediaPeriodId mediaPeriodId, long l2) {
            return new EventDispatcher(this.listenerAndHandlers, n2, mediaPeriodId, l2);
        }

        private static final class ListenerAndHandler {
            public Handler handler;
            public MediaSourceEventListener listener;

            public ListenerAndHandler(Handler handler, MediaSourceEventListener mediaSourceEventListener) {
                this.handler = handler;
                this.listener = mediaSourceEventListener;
            }
        }
    }
}

