/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.ForwardingTimeline;
import com.google.android.exoplayer2.source.MaskingMediaPeriod;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class MaskingMediaSource
extends CompositeMediaSource<Void> {
    private boolean hasRealTimeline;
    private boolean hasStartedPreparing;
    private boolean isPrepared;
    private final MediaSource mediaSource;
    private final Timeline.Period period;
    private MaskingTimeline timeline;
    private MaskingMediaPeriod unpreparedMaskingMediaPeriod;
    private final boolean useLazyPreparation;
    private final Timeline.Window window;

    public MaskingMediaSource(MediaSource mediaSource, boolean bl) {
        this.mediaSource = mediaSource;
        bl = bl && mediaSource.isSingleWindow();
        this.useLazyPreparation = bl;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        Timeline timeline = mediaSource.getInitialTimeline();
        if (timeline != null) {
            this.timeline = MaskingTimeline.createWithRealTimeline(timeline, null, null);
            this.hasRealTimeline = true;
        } else {
            this.timeline = MaskingTimeline.createWithPlaceholderTimeline(mediaSource.getMediaItem());
        }
    }

    private Object getExternalPeriodUid(Object object) {
        Object object2 = object;
        if (this.timeline.replacedInternalPeriodUid != null) {
            object2 = object;
            if (this.timeline.replacedInternalPeriodUid.equals(object)) {
                object2 = MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID;
            }
        }
        return object2;
    }

    private Object getInternalPeriodUid(Object object) {
        Object object2 = object;
        if (this.timeline.replacedInternalPeriodUid != null) {
            object2 = object;
            if (object.equals(MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID)) {
                object2 = this.timeline.replacedInternalPeriodUid;
            }
        }
        return object2;
    }

    @RequiresNonNull(value={"unpreparedMaskingMediaPeriod"})
    private void setPreparePositionOverrideToUnpreparedMaskingPeriod(long l2) {
        MaskingMediaPeriod maskingMediaPeriod = this.unpreparedMaskingMediaPeriod;
        int n2 = this.timeline.getIndexOfPeriod(maskingMediaPeriod.id.periodUid);
        if (n2 == -1) {
            return;
        }
        long l3 = this.timeline.getPeriod((int)n2, (Timeline.Period)this.period).durationUs;
        long l4 = l2;
        if (l3 != -9223372036854775807L) {
            l4 = l2;
            if (l2 >= l3) {
                l4 = Math.max(0L, l3 - 1L);
            }
        }
        maskingMediaPeriod.overridePreparePositionUs(l4);
    }

    public MaskingMediaPeriod createPeriod(MediaSource.MediaPeriodId mediaPeriodId, Allocator allocator, long l2) {
        allocator = new MaskingMediaPeriod(mediaPeriodId, allocator, l2);
        allocator.setMediaSource(this.mediaSource);
        if (this.isPrepared) {
            allocator.createPeriod((MediaSource.MediaPeriodId)mediaPeriodId.copyWithPeriodUid(this.getInternalPeriodUid(mediaPeriodId.periodUid)));
        } else {
            this.unpreparedMaskingMediaPeriod = allocator;
            if (!this.hasStartedPreparing) {
                this.hasStartedPreparing = true;
                this.prepareChildSource(null, this.mediaSource);
            }
        }
        return allocator;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaSource.getMediaItem();
    }

    @Override
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Void void_, MediaSource.MediaPeriodId mediaPeriodId) {
        return mediaPeriodId.copyWithPeriodUid(this.getExternalPeriodUid(mediaPeriodId.periodUid));
    }

    @Override
    @Deprecated
    public Object getTag() {
        return this.mediaSource.getTag();
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void onChildSourceInfoRefreshed(Void var1_1, MediaSource var2_2, Timeline var3_3) {
        block7: {
            block6: {
                if (!this.isPrepared) break block6;
                this.timeline = this.timeline.cloneWithUpdatedTimeline(var3_3);
                var1_1 /* !! */  = this.unpreparedMaskingMediaPeriod;
                if (var1_1 /* !! */  != null) {
                    this.setPreparePositionOverrideToUnpreparedMaskingPeriod(var1_1 /* !! */ .getPreparePositionOverrideUs());
                }
                ** GOTO lbl-1000
            }
            if (!var3_3.isEmpty()) break block7;
            var1_1 /* !! */  = this.hasRealTimeline != false ? this.timeline.cloneWithUpdatedTimeline(var3_3) : MaskingTimeline.createWithRealTimeline(var3_3, Timeline.Window.SINGLE_WINDOW_UID, MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID);
            this.timeline = var1_1 /* !! */ ;
            ** GOTO lbl-1000
        }
        var3_3.getWindow(0, this.window);
        var4_4 = this.window.getDefaultPositionUs();
        var1_1 /* !! */  = this.window.uid;
        var2_2 = this.unpreparedMaskingMediaPeriod;
        if (var2_2 != null) {
            var6_5 = var2_2.getPreparePositionUs();
            this.timeline.getPeriodByUid(this.unpreparedMaskingMediaPeriod.id.periodUid, this.period);
            if ((var6_5 += this.period.getPositionInWindowUs()) != this.timeline.getWindow(0, this.window).getDefaultPositionUs()) {
                var4_4 = var6_5;
            }
        }
        var8_6 = var3_3.getPeriodPosition(this.window, this.period, 0, var4_4);
        var2_2 = var8_6.first;
        var4_4 = (Long)var8_6.second;
        var1_1 /* !! */  = this.hasRealTimeline != false ? this.timeline.cloneWithUpdatedTimeline(var3_3) : MaskingTimeline.createWithRealTimeline(var3_3, var1_1 /* !! */ , var2_2);
        this.timeline = var1_1 /* !! */ ;
        var1_1 /* !! */  = this.unpreparedMaskingMediaPeriod;
        if (var1_1 /* !! */  != null) {
            this.setPreparePositionOverrideToUnpreparedMaskingPeriod(var4_4);
            var1_1 /* !! */  = var1_1 /* !! */ .id.copyWithPeriodUid(this.getInternalPeriodUid(var1_1 /* !! */ .id.periodUid));
        } else lbl-1000:
        // 3 sources

        {
            var1_1 /* !! */  = null;
        }
        this.hasRealTimeline = true;
        this.isPrepared = true;
        this.refreshSourceInfo((Timeline)this.timeline);
        if (var1_1 /* !! */  != null) {
            Assertions.checkNotNull(this.unpreparedMaskingMediaPeriod).createPeriod((MediaSource.MediaPeriodId)var1_1 /* !! */ );
        }
    }

    @Override
    public void prepareSourceInternal(TransferListener transferListener) {
        super.prepareSourceInternal(transferListener);
        if (!this.useLazyPreparation) {
            this.hasStartedPreparing = true;
            this.prepareChildSource(null, this.mediaSource);
        }
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((MaskingMediaPeriod)mediaPeriod).releasePeriod();
        if (mediaPeriod == this.unpreparedMaskingMediaPeriod) {
            this.unpreparedMaskingMediaPeriod = null;
        }
    }

    @Override
    public void releaseSourceInternal() {
        this.isPrepared = false;
        this.hasStartedPreparing = false;
        super.releaseSourceInternal();
    }

    private static final class MaskingTimeline
    extends ForwardingTimeline {
        public static final Object MASKING_EXTERNAL_PERIOD_UID = new Object();
        private final Object replacedInternalPeriodUid;
        private final Object replacedInternalWindowUid;

        private MaskingTimeline(Timeline timeline, Object object, Object object2) {
            super(timeline);
            this.replacedInternalWindowUid = object;
            this.replacedInternalPeriodUid = object2;
        }

        public static MaskingTimeline createWithPlaceholderTimeline(MediaItem mediaItem) {
            return new MaskingTimeline(new PlaceholderTimeline(mediaItem), Timeline.Window.SINGLE_WINDOW_UID, MASKING_EXTERNAL_PERIOD_UID);
        }

        public static MaskingTimeline createWithRealTimeline(Timeline timeline, Object object, Object object2) {
            return new MaskingTimeline(timeline, object, object2);
        }

        public MaskingTimeline cloneWithUpdatedTimeline(Timeline timeline) {
            return new MaskingTimeline(timeline, this.replacedInternalWindowUid, this.replacedInternalPeriodUid);
        }

        public int getIndexOfPeriod(Object object) {
            Timeline timeline = this.timeline;
            Object object2 = object;
            if (MASKING_EXTERNAL_PERIOD_UID.equals(object)) {
                Object object3 = this.replacedInternalPeriodUid;
                object2 = object;
                if (object3 != null) {
                    object2 = object3;
                }
            }
            return timeline.getIndexOfPeriod(object2);
        }

        public Timeline.Period getPeriod(int n2, Timeline.Period period, boolean bl) {
            this.timeline.getPeriod(n2, period, bl);
            if (Util.areEqual(period.uid, this.replacedInternalPeriodUid) && bl) {
                period.uid = MASKING_EXTERNAL_PERIOD_UID;
            }
            return period;
        }

        public Timeline getTimeline() {
            return this.timeline;
        }

        public Object getUidOfPeriod(int n2) {
            Object object;
            Object object2 = object = this.timeline.getUidOfPeriod(n2);
            if (Util.areEqual(object, this.replacedInternalPeriodUid)) {
                object2 = MASKING_EXTERNAL_PERIOD_UID;
            }
            return object2;
        }

        public Timeline.Window getWindow(int n2, Timeline.Window window, long l2) {
            this.timeline.getWindow(n2, window, l2);
            if (Util.areEqual(window.uid, this.replacedInternalWindowUid)) {
                window.uid = Timeline.Window.SINGLE_WINDOW_UID;
            }
            return window;
        }
    }

    public static final class PlaceholderTimeline
    extends Timeline {
        private final MediaItem mediaItem;

        public PlaceholderTimeline(MediaItem mediaItem) {
            this.mediaItem = mediaItem;
        }

        public int getIndexOfPeriod(Object object) {
            int n2 = object == MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID ? 0 : -1;
            return n2;
        }

        public Timeline.Period getPeriod(int n2, Timeline.Period period, boolean bl) {
            Object object = null;
            Integer n3 = bl ? Integer.valueOf(0) : null;
            if (bl) {
                object = MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID;
            }
            return period.set((Object)n3, object, 0, -9223372036854775807L, 0L);
        }

        public int getPeriodCount() {
            return 1;
        }

        public Object getUidOfPeriod(int n2) {
            return MaskingTimeline.MASKING_EXTERNAL_PERIOD_UID;
        }

        public Timeline.Window getWindow(int n2, Timeline.Window window, long l2) {
            window.set(Timeline.Window.SINGLE_WINDOW_UID, this.mediaItem, null, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L, false, true, null, 0L, -9223372036854775807L, 0, 0, 0L);
            window.isPlaceholder = true;
            return window;
        }

        public int getWindowCount() {
            return 1;
        }
    }
}

