/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class IcyDataSource
implements DataSource {
    private int bytesUntilMetadata;
    private final Listener listener;
    private final int metadataIntervalBytes;
    private final byte[] metadataLengthByteHolder;
    private final DataSource upstream;

    public IcyDataSource(DataSource dataSource, int n2, Listener listener2) {
        boolean bl = n2 > 0;
        Assertions.checkArgument(bl);
        this.upstream = dataSource;
        this.metadataIntervalBytes = n2;
        this.listener = listener2;
        this.metadataLengthByteHolder = new byte[1];
        this.bytesUntilMetadata = n2;
    }

    private boolean readMetadata() throws IOException {
        int n2;
        if (this.upstream.read(this.metadataLengthByteHolder, 0, 1) == -1) {
            return false;
        }
        int n3 = (this.metadataLengthByteHolder[0] & 0xFF) << 4;
        if (n3 == 0) {
            return true;
        }
        byte[] byArray = new byte[n3];
        int n4 = n3;
        int n5 = 0;
        while (true) {
            if (n4 <= 0) break;
            n2 = this.upstream.read(byArray, n5, n4);
            if (n2 == -1) {
                return false;
            }
            n5 += n2;
            n4 -= n2;
        }
        for (n2 = n3; n2 > 0 && byArray[n2 - 1] == 0; --n2) {
        }
        if (n2 > 0) {
            this.listener.onIcyMetadata(new ParsableByteArray(byArray, n2));
        }
        return true;
    }

    public void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull(transferListener);
        this.upstream.addTransferListener(transferListener);
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.upstream.getResponseHeaders();
    }

    public Uri getUri() {
        return this.upstream.getUri();
    }

    public long open(DataSpec dataSpec) {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.bytesUntilMetadata == 0) {
            if (this.readMetadata()) {
                this.bytesUntilMetadata = this.metadataIntervalBytes;
            } else {
                return -1;
            }
        }
        if ((n2 = this.upstream.read(byArray, n2, Math.min(this.bytesUntilMetadata, n3))) != -1) {
            this.bytesUntilMetadata -= n2;
        }
        return n2;
    }

    public static interface Listener {
        public void onIcyMetadata(ParsableByteArray var1);
    }
}

