/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source._$$Lambda$CompositeMediaSource$XIMxMigUUqAS2WvqSyL5xh9sCFo;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class CompositeMediaSource<T>
extends BaseMediaSource {
    private final HashMap<T, MediaSourceAndListener> childSources = new HashMap();
    private Handler eventHandler;
    private TransferListener mediaTransferListener;

    protected CompositeMediaSource() {
    }

    protected final void disableChildSource(T object) {
        object = Assertions.checkNotNull(this.childSources.get(object));
        ((MediaSourceAndListener)object).mediaSource.disable(((MediaSourceAndListener)object).caller);
    }

    @Override
    protected void disableInternal() {
        for (MediaSourceAndListener mediaSourceAndListener : this.childSources.values()) {
            mediaSourceAndListener.mediaSource.disable(mediaSourceAndListener.caller);
        }
    }

    protected final void enableChildSource(T object) {
        object = Assertions.checkNotNull(this.childSources.get(object));
        ((MediaSourceAndListener)object).mediaSource.enable(((MediaSourceAndListener)object).caller);
    }

    @Override
    protected void enableInternal() {
        for (MediaSourceAndListener mediaSourceAndListener : this.childSources.values()) {
            mediaSourceAndListener.mediaSource.enable(mediaSourceAndListener.caller);
        }
    }

    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(T t2, MediaSource.MediaPeriodId mediaPeriodId) {
        return mediaPeriodId;
    }

    protected long getMediaTimeForChildMediaTime(T t2, long l2) {
        return l2;
    }

    protected int getWindowIndexForChildWindowIndex(T t2, int n2) {
        return n2;
    }

    public /* synthetic */ void lambda$prepareChildSource$0$CompositeMediaSource(Object object, MediaSource mediaSource, Timeline timeline) {
        this.onChildSourceInfoRefreshed(object, mediaSource, timeline);
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        Iterator<MediaSourceAndListener> iterator2 = this.childSources.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().mediaSource.maybeThrowSourceInfoRefreshError();
        }
    }

    protected abstract void onChildSourceInfoRefreshed(T var1, MediaSource var2, Timeline var3);

    protected final void prepareChildSource(T t2, MediaSource mediaSource) {
        Assertions.checkArgument(this.childSources.containsKey(t2) ^ true);
        _$$Lambda$CompositeMediaSource$XIMxMigUUqAS2WvqSyL5xh9sCFo _$$Lambda$CompositeMediaSource$XIMxMigUUqAS2WvqSyL5xh9sCFo = new _$$Lambda$CompositeMediaSource$XIMxMigUUqAS2WvqSyL5xh9sCFo(this, t2);
        ForwardingEventListener forwardingEventListener = new ForwardingEventListener(t2);
        this.childSources.put(t2, new MediaSourceAndListener(mediaSource, _$$Lambda$CompositeMediaSource$XIMxMigUUqAS2WvqSyL5xh9sCFo, forwardingEventListener));
        mediaSource.addEventListener(Assertions.checkNotNull(this.eventHandler), forwardingEventListener);
        mediaSource.addDrmEventListener(Assertions.checkNotNull(this.eventHandler), forwardingEventListener);
        mediaSource.prepareSource(_$$Lambda$CompositeMediaSource$XIMxMigUUqAS2WvqSyL5xh9sCFo, this.mediaTransferListener);
        if (!this.isEnabled()) {
            mediaSource.disable(_$$Lambda$CompositeMediaSource$XIMxMigUUqAS2WvqSyL5xh9sCFo);
        }
    }

    @Override
    protected void prepareSourceInternal(TransferListener transferListener) {
        this.mediaTransferListener = transferListener;
        this.eventHandler = Util.createHandlerForCurrentLooper();
    }

    protected final void releaseChildSource(T object) {
        object = Assertions.checkNotNull(this.childSources.remove(object));
        ((MediaSourceAndListener)object).mediaSource.releaseSource(((MediaSourceAndListener)object).caller);
        ((MediaSourceAndListener)object).mediaSource.removeEventListener(((MediaSourceAndListener)object).eventListener);
    }

    @Override
    protected void releaseSourceInternal() {
        for (MediaSourceAndListener mediaSourceAndListener : this.childSources.values()) {
            mediaSourceAndListener.mediaSource.releaseSource(mediaSourceAndListener.caller);
            mediaSourceAndListener.mediaSource.removeEventListener(mediaSourceAndListener.eventListener);
        }
        this.childSources.clear();
    }

    private final class ForwardingEventListener
    implements MediaSourceEventListener,
    DrmSessionEventListener {
        private DrmSessionEventListener.EventDispatcher drmEventDispatcher;
        private final T id;
        private MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;

        public ForwardingEventListener(T t2) {
            this.mediaSourceEventDispatcher = CompositeMediaSource.this.createEventDispatcher(null);
            this.drmEventDispatcher = CompositeMediaSource.this.createDrmEventDispatcher(null);
            this.id = t2;
        }

        private boolean maybeUpdateEventDispatcher(int n2, MediaSource.MediaPeriodId mediaPeriodId) {
            if (mediaPeriodId != null) {
                MediaSource.MediaPeriodId mediaPeriodId2;
                mediaPeriodId = mediaPeriodId2 = CompositeMediaSource.this.getMediaPeriodIdForChildMediaPeriodId(this.id, mediaPeriodId);
                if (mediaPeriodId2 == null) {
                    return false;
                }
            } else {
                mediaPeriodId = null;
            }
            if (this.mediaSourceEventDispatcher.windowIndex != (n2 = CompositeMediaSource.this.getWindowIndexForChildWindowIndex(this.id, n2)) || !Util.areEqual((Object)this.mediaSourceEventDispatcher.mediaPeriodId, (Object)mediaPeriodId)) {
                this.mediaSourceEventDispatcher = CompositeMediaSource.this.createEventDispatcher(n2, mediaPeriodId, 0L);
            }
            if (this.drmEventDispatcher.windowIndex != n2 || !Util.areEqual((Object)this.drmEventDispatcher.mediaPeriodId, (Object)mediaPeriodId)) {
                this.drmEventDispatcher = CompositeMediaSource.this.createDrmEventDispatcher(n2, mediaPeriodId);
            }
            return true;
        }

        private MediaLoadData maybeUpdateMediaLoadData(MediaLoadData mediaLoadData) {
            long l2 = CompositeMediaSource.this.getMediaTimeForChildMediaTime(this.id, mediaLoadData.mediaStartTimeMs);
            long l3 = CompositeMediaSource.this.getMediaTimeForChildMediaTime(this.id, mediaLoadData.mediaEndTimeMs);
            if (l2 == mediaLoadData.mediaStartTimeMs && l3 == mediaLoadData.mediaEndTimeMs) {
                return mediaLoadData;
            }
            return new MediaLoadData(mediaLoadData.dataType, mediaLoadData.trackType, mediaLoadData.trackFormat, mediaLoadData.trackSelectionReason, mediaLoadData.trackSelectionData, l2, l3);
        }

        @Override
        public void onDownstreamFormatChanged(int n2, MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.downstreamFormatChanged(this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onDrmKeysLoaded(int n2, MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysLoaded();
            }
        }

        @Override
        public void onDrmKeysRemoved(int n2, MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysRemoved();
            }
        }

        @Override
        public void onDrmKeysRestored(int n2, MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.drmEventDispatcher.drmKeysRestored();
            }
        }

        @Override
        public void onDrmSessionAcquired(int n2, MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionAcquired();
            }
        }

        @Override
        public void onDrmSessionManagerError(int n2, MediaSource.MediaPeriodId mediaPeriodId, Exception exception) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionManagerError(exception);
            }
        }

        @Override
        public void onDrmSessionReleased(int n2, MediaSource.MediaPeriodId mediaPeriodId) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.drmEventDispatcher.drmSessionReleased();
            }
        }

        @Override
        public void onLoadCanceled(int n2, MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadCanceled(loadEventInfo, this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onLoadCompleted(int n2, MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadCompleted(loadEventInfo, this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onLoadError(int n2, MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException iOException, boolean bl) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadError(loadEventInfo, this.maybeUpdateMediaLoadData(mediaLoadData), iOException, bl);
            }
        }

        @Override
        public void onLoadStarted(int n2, MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.loadStarted(loadEventInfo, this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }

        @Override
        public void onUpstreamDiscarded(int n2, MediaSource.MediaPeriodId mediaPeriodId, MediaLoadData mediaLoadData) {
            if (this.maybeUpdateEventDispatcher(n2, mediaPeriodId)) {
                this.mediaSourceEventDispatcher.upstreamDiscarded(this.maybeUpdateMediaLoadData(mediaLoadData));
            }
        }
    }

    private static final class MediaSourceAndListener {
        public final MediaSource.MediaSourceCaller caller;
        public final MediaSourceEventListener eventListener;
        public final MediaSource mediaSource;

        public MediaSourceAndListener(MediaSource mediaSource, MediaSource.MediaSourceCaller mediaSourceCaller, MediaSourceEventListener mediaSourceEventListener) {
            this.mediaSource = mediaSource;
            this.caller = mediaSourceCaller;
            this.eventListener = mediaSourceEventListener;
        }
    }
}

