/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.ClippingMediaPeriod;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.ForwardingTimeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public final class ClippingMediaSource
extends CompositeMediaSource<Void> {
    private final boolean allowDynamicClippingUpdates;
    private IllegalClippingException clippingError;
    private ClippingTimeline clippingTimeline;
    private final boolean enableInitialDiscontinuity;
    private final long endUs;
    private final ArrayList<ClippingMediaPeriod> mediaPeriods;
    private final MediaSource mediaSource;
    private long periodEndUs;
    private long periodStartUs;
    private final boolean relativeToDefaultPosition;
    private final long startUs;
    private final Timeline.Window window;

    public ClippingMediaSource(MediaSource mediaSource, long l2) {
        this(mediaSource, 0L, l2, true, false, true);
    }

    public ClippingMediaSource(MediaSource mediaSource, long l2, long l3) {
        this(mediaSource, l2, l3, true, false, false);
    }

    public ClippingMediaSource(MediaSource mediaSource, long l2, long l3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = l2 >= 0L;
        Assertions.checkArgument(bl4);
        this.mediaSource = Assertions.checkNotNull(mediaSource);
        this.startUs = l2;
        this.endUs = l3;
        this.enableInitialDiscontinuity = bl;
        this.allowDynamicClippingUpdates = bl2;
        this.relativeToDefaultPosition = bl3;
        this.mediaPeriods = new ArrayList();
        this.window = new Timeline.Window();
    }

    private void refreshClippedTimeline(Timeline timeline) {
        long l2;
        long l3;
        Object object = this.window;
        int n2 = 0;
        timeline.getWindow(0, object);
        long l4 = this.window.getPositionInFirstPeriodUs();
        object = this.clippingTimeline;
        long l5 = Long.MIN_VALUE;
        if (object != null && !this.mediaPeriods.isEmpty() && !this.allowDynamicClippingUpdates) {
            l3 = this.periodStartUs;
            l2 = this.endUs == Long.MIN_VALUE ? l5 : this.periodEndUs - l4;
            l3 -= l4;
        } else {
            long l6 = this.startUs;
            long l7 = this.endUs;
            l3 = l6;
            l2 = l7;
            if (this.relativeToDefaultPosition) {
                l2 = this.window.getDefaultPositionUs();
                l3 = l6 + l2;
                l2 = l7 + l2;
            }
            this.periodStartUs = l4 + l3;
            if (this.endUs != Long.MIN_VALUE) {
                l5 = l4 + l2;
            }
            this.periodEndUs = l5;
            int n3 = this.mediaPeriods.size();
            while (n2 < n3) {
                this.mediaPeriods.get(n2).updateClipping(this.periodStartUs, this.periodEndUs);
                ++n2;
            }
        }
        try {
            object = new ClippingTimeline(timeline, l3, l2);
            this.clippingTimeline = object;
        }
        catch (IllegalClippingException illegalClippingException) {
            this.clippingError = illegalClippingException;
            return;
        }
        this.refreshSourceInfo((Timeline)this.clippingTimeline);
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId mediaPeriodId, Allocator allocator, long l2) {
        mediaPeriodId = new ClippingMediaPeriod(this.mediaSource.createPeriod(mediaPeriodId, allocator, l2), this.enableInitialDiscontinuity, this.periodStartUs, this.periodEndUs);
        this.mediaPeriods.add((ClippingMediaPeriod)mediaPeriodId);
        return mediaPeriodId;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaSource.getMediaItem();
    }

    @Override
    protected long getMediaTimeForChildMediaTime(Void void_, long l2) {
        if (l2 == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        long l3 = C.usToMs(this.startUs);
        long l4 = Math.max(0L, l2 - l3);
        long l5 = this.endUs;
        l2 = l4;
        if (l5 != Long.MIN_VALUE) {
            l2 = Math.min(C.usToMs(l5) - l3, l4);
        }
        return l2;
    }

    @Override
    @Deprecated
    public Object getTag() {
        return this.mediaSource.getTag();
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        IllegalClippingException illegalClippingException = this.clippingError;
        if (illegalClippingException == null) {
            super.maybeThrowSourceInfoRefreshError();
            return;
        }
        throw illegalClippingException;
    }

    @Override
    protected void onChildSourceInfoRefreshed(Void void_, MediaSource mediaSource, Timeline timeline) {
        if (this.clippingError != null) {
            return;
        }
        this.refreshClippedTimeline(timeline);
    }

    @Override
    protected void prepareSourceInternal(TransferListener transferListener) {
        super.prepareSourceInternal(transferListener);
        this.prepareChildSource(null, this.mediaSource);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        Assertions.checkState(this.mediaPeriods.remove(mediaPeriod));
        this.mediaSource.releasePeriod(((ClippingMediaPeriod)mediaPeriod).mediaPeriod);
        if (this.mediaPeriods.isEmpty() && !this.allowDynamicClippingUpdates) {
            this.refreshClippedTimeline(Assertions.checkNotNull(this.clippingTimeline).timeline);
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.clippingError = null;
        this.clippingTimeline = null;
    }

    private static final class ClippingTimeline
    extends ForwardingTimeline {
        private final long durationUs;
        private final long endUs;
        private final boolean isDynamic;
        private final long startUs;

        public ClippingTimeline(Timeline timeline, long l2, long l3) throws IllegalClippingException {
            block7: {
                boolean bl;
                block8: {
                    block9: {
                        super(timeline);
                        int n2 = timeline.getPeriodCount();
                        boolean bl2 = false;
                        if (n2 != 1) break block7;
                        timeline = timeline.getWindow(0, new Timeline.Window());
                        long l4 = Math.max(0L, l2);
                        if (!timeline.isPlaceholder && l4 != 0L && !timeline.isSeekable) {
                            throw new IllegalClippingException(1);
                        }
                        l2 = l3 == Long.MIN_VALUE ? timeline.durationUs : Math.max(0L, l3);
                        l3 = l2;
                        if (timeline.durationUs != -9223372036854775807L) {
                            l3 = l2;
                            if (l2 > timeline.durationUs) {
                                l3 = timeline.durationUs;
                            }
                            if (l4 > l3) {
                                throw new IllegalClippingException(2);
                            }
                        }
                        this.startUs = l4;
                        this.endUs = l3;
                        l2 = l3 == -9223372036854775807L ? -9223372036854775807L : l3 - l4;
                        this.durationUs = l2;
                        bl = bl2;
                        if (!timeline.isDynamic) break block8;
                        if (l3 == -9223372036854775807L) break block9;
                        bl = bl2;
                        if (timeline.durationUs == -9223372036854775807L) break block8;
                        bl = bl2;
                        if (l3 != timeline.durationUs) break block8;
                    }
                    bl = true;
                }
                this.isDynamic = bl;
                return;
            }
            throw new IllegalClippingException(0);
        }

        public Timeline.Period getPeriod(int n2, Timeline.Period period, boolean bl) {
            this.timeline.getPeriod(0, period, bl);
            long l2 = period.getPositionInWindowUs() - this.startUs;
            long l3 = this.durationUs;
            l3 = l3 == -9223372036854775807L ? -9223372036854775807L : (l3 -= l2);
            return period.set(period.id, period.uid, 0, l3, l2);
        }

        public Timeline.Window getWindow(int n2, Timeline.Window window, long l2) {
            this.timeline.getWindow(0, window, 0L);
            window.positionInFirstPeriodUs += this.startUs;
            window.durationUs = this.durationUs;
            window.isDynamic = this.isDynamic;
            if (window.defaultPositionUs != -9223372036854775807L) {
                window.defaultPositionUs = Math.max(window.defaultPositionUs, this.startUs);
                long l3 = this.endUs;
                l2 = window.defaultPositionUs;
                if (l3 != -9223372036854775807L) {
                    l2 = Math.min(l2, this.endUs);
                }
                window.defaultPositionUs = l2;
                window.defaultPositionUs -= this.startUs;
            }
            l2 = C.usToMs(this.startUs);
            if (window.presentationStartTimeMs != -9223372036854775807L) {
                window.presentationStartTimeMs += l2;
            }
            if (window.windowStartTimeMs != -9223372036854775807L) {
                window.windowStartTimeMs += l2;
            }
            return window;
        }
    }

    public static final class IllegalClippingException
    extends IOException {
        public static final int REASON_INVALID_PERIOD_COUNT = 0;
        public static final int REASON_NOT_SEEKABLE_TO_START = 1;
        public static final int REASON_START_EXCEEDS_END = 2;
        public final int reason;

        public IllegalClippingException(int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal clipping: ");
            stringBuilder.append(IllegalClippingException.getReasonDescription(n2));
            super(stringBuilder.toString());
            this.reason = n2;
        }

        private static String getReasonDescription(int n2) {
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        return "unknown";
                    }
                    return "start exceeds end";
                }
                return "not seekable to start";
            }
            return "invalid period count";
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }
}

