/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import android.os.Looper;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public abstract class BaseMediaSource
implements MediaSource {
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final HashSet<MediaSource.MediaSourceCaller> enabledMediaSourceCallers;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private Looper looper;
    private final ArrayList<MediaSource.MediaSourceCaller> mediaSourceCallers = new ArrayList(1);
    private Timeline timeline;

    public BaseMediaSource() {
        this.enabledMediaSourceCallers = new HashSet(1);
        this.eventDispatcher = new MediaSourceEventListener.EventDispatcher();
        this.drmEventDispatcher = new DrmSessionEventListener.EventDispatcher();
    }

    @Override
    public final void addDrmEventListener(Handler handler, DrmSessionEventListener drmSessionEventListener) {
        Assertions.checkNotNull(handler);
        Assertions.checkNotNull(drmSessionEventListener);
        this.drmEventDispatcher.addEventListener(handler, drmSessionEventListener);
    }

    @Override
    public final void addEventListener(Handler handler, MediaSourceEventListener mediaSourceEventListener) {
        Assertions.checkNotNull(handler);
        Assertions.checkNotNull(mediaSourceEventListener);
        this.eventDispatcher.addEventListener(handler, mediaSourceEventListener);
    }

    protected final DrmSessionEventListener.EventDispatcher createDrmEventDispatcher(int n2, MediaSource.MediaPeriodId mediaPeriodId) {
        return this.drmEventDispatcher.withParameters(n2, mediaPeriodId);
    }

    protected final DrmSessionEventListener.EventDispatcher createDrmEventDispatcher(MediaSource.MediaPeriodId mediaPeriodId) {
        return this.drmEventDispatcher.withParameters(0, mediaPeriodId);
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(int n2, MediaSource.MediaPeriodId mediaPeriodId, long l2) {
        return this.eventDispatcher.withParameters(n2, mediaPeriodId, l2);
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(MediaSource.MediaPeriodId mediaPeriodId) {
        return this.eventDispatcher.withParameters(0, mediaPeriodId, 0L);
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(MediaSource.MediaPeriodId mediaPeriodId, long l2) {
        Assertions.checkNotNull(mediaPeriodId);
        return this.eventDispatcher.withParameters(0, mediaPeriodId, l2);
    }

    @Override
    public final void disable(MediaSource.MediaSourceCaller mediaSourceCaller) {
        boolean bl = this.enabledMediaSourceCallers.isEmpty();
        this.enabledMediaSourceCallers.remove(mediaSourceCaller);
        if (bl ^ true && this.enabledMediaSourceCallers.isEmpty()) {
            this.disableInternal();
        }
    }

    protected void disableInternal() {
    }

    @Override
    public final void enable(MediaSource.MediaSourceCaller mediaSourceCaller) {
        Assertions.checkNotNull(this.looper);
        boolean bl = this.enabledMediaSourceCallers.isEmpty();
        this.enabledMediaSourceCallers.add(mediaSourceCaller);
        if (bl) {
            this.enableInternal();
        }
    }

    protected void enableInternal() {
    }

    @Override
    public /* synthetic */ Timeline getInitialTimeline() {
        return MediaSource._CC.$default$getInitialTimeline((MediaSource)this);
    }

    @Override
    @Deprecated
    public /* synthetic */ Object getTag() {
        return MediaSource._CC.$default$getTag((MediaSource)this);
    }

    protected final boolean isEnabled() {
        return this.enabledMediaSourceCallers.isEmpty() ^ true;
    }

    @Override
    public /* synthetic */ boolean isSingleWindow() {
        return MediaSource._CC.$default$isSingleWindow((MediaSource)this);
    }

    @Override
    public final void prepareSource(MediaSource.MediaSourceCaller mediaSourceCaller, TransferListener transferListener) {
        Looper looper = Looper.myLooper();
        Looper looper2 = this.looper;
        boolean bl = looper2 == null || looper2 == looper;
        Assertions.checkArgument(bl);
        looper2 = this.timeline;
        this.mediaSourceCallers.add(mediaSourceCaller);
        if (this.looper == null) {
            this.looper = looper;
            this.enabledMediaSourceCallers.add(mediaSourceCaller);
            this.prepareSourceInternal(transferListener);
        } else if (looper2 != null) {
            this.enable(mediaSourceCaller);
            mediaSourceCaller.onSourceInfoRefreshed(this, (Timeline)looper2);
        }
    }

    protected abstract void prepareSourceInternal(TransferListener var1);

    protected final void refreshSourceInfo(Timeline timeline) {
        this.timeline = timeline;
        Iterator<MediaSource.MediaSourceCaller> iterator2 = this.mediaSourceCallers.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onSourceInfoRefreshed(this, timeline);
        }
    }

    @Override
    public final void releaseSource(MediaSource.MediaSourceCaller mediaSourceCaller) {
        this.mediaSourceCallers.remove(mediaSourceCaller);
        if (this.mediaSourceCallers.isEmpty()) {
            this.looper = null;
            this.timeline = null;
            this.enabledMediaSourceCallers.clear();
            this.releaseSourceInternal();
        } else {
            this.disable(mediaSourceCaller);
        }
    }

    protected abstract void releaseSourceInternal();

    @Override
    public final void removeDrmEventListener(DrmSessionEventListener drmSessionEventListener) {
        this.drmEventDispatcher.removeEventListener(drmSessionEventListener);
    }

    @Override
    public final void removeEventListener(MediaSourceEventListener mediaSourceEventListener) {
        this.eventDispatcher.removeEventListener(mediaSourceEventListener);
    }
}

