/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.scheduler;

import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Requirements
implements Parcelable {
    public static final Parcelable.Creator<Requirements> CREATOR = new Parcelable.Creator<Requirements>(){

        public Requirements createFromParcel(Parcel parcel) {
            return new Requirements(parcel.readInt());
        }

        public Requirements[] newArray(int n2) {
            return new Requirements[n2];
        }
    };
    public static final int DEVICE_CHARGING = 8;
    public static final int DEVICE_IDLE = 4;
    public static final int DEVICE_STORAGE_NOT_LOW = 16;
    public static final int NETWORK = 1;
    public static final int NETWORK_UNMETERED = 2;
    private final int requirements;

    public Requirements(int n2) {
        int n3 = n2;
        if ((n2 & 2) != 0) {
            n3 = n2 | 1;
        }
        this.requirements = n3;
    }

    private int getNotMetNetworkRequirements(Context context) {
        if (!this.isNetworkRequired()) {
            return 0;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)Assertions.checkNotNull(context.getSystemService("connectivity"));
        if ((context = connectivityManager.getActiveNetworkInfo()) != null && context.isConnected() && Requirements.isInternetConnectivityValidated(connectivityManager)) {
            if (this.isUnmeteredNetworkRequired() && connectivityManager.isActiveNetworkMetered()) {
                return 2;
            }
            return 0;
        }
        return this.requirements & 3;
    }

    private boolean isDeviceCharging(Context context) {
        context = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        boolean bl = false;
        if (context == null) {
            return false;
        }
        int n2 = context.getIntExtra("status", -1);
        if (n2 == 2 || n2 == 5) {
            bl = true;
        }
        return bl;
    }

    private boolean isDeviceIdle(Context context) {
        context = (PowerManager)Assertions.checkNotNull(context.getSystemService("power"));
        int n2 = Util.SDK_INT;
        boolean bl = true;
        if (n2 >= 23) {
            bl = context.isDeviceIdleMode();
        } else if (!(Util.SDK_INT >= 20 ? !context.isInteractive() : !context.isScreenOn())) {
            bl = false;
        }
        return bl;
    }

    private static boolean isInternetConnectivityValidated(ConnectivityManager connectivityManager) {
        int n2 = Util.SDK_INT;
        boolean bl = true;
        if (n2 < 24) {
            return true;
        }
        Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        if ((connectivityManager = connectivityManager.getNetworkCapabilities(network)) == null || !connectivityManager.hasCapability(16)) {
            bl = false;
        }
        return bl;
    }

    private boolean isStorageNotLow(Context context) {
        boolean bl = context.registerReceiver(null, new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW")) == null;
        return bl;
    }

    public boolean checkRequirements(Context context) {
        boolean bl = this.getNotMetRequirements(context) == 0;
        return bl;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            if (this.requirements != ((Requirements)object).requirements) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public Requirements filterRequirements(int n2) {
        int n3 = this.requirements;
        Requirements requirements = (n2 &= n3) == n3 ? this : new Requirements(n2);
        return requirements;
    }

    public int getNotMetRequirements(Context context) {
        int n2;
        int n3 = n2 = this.getNotMetNetworkRequirements(context);
        if (this.isChargingRequired()) {
            n3 = n2;
            if (!this.isDeviceCharging(context)) {
                n3 = n2 | 8;
            }
        }
        n2 = n3;
        if (this.isIdleRequired()) {
            n2 = n3;
            if (!this.isDeviceIdle(context)) {
                n2 = n3 | 4;
            }
        }
        n3 = n2;
        if (this.isStorageNotLowRequired()) {
            n3 = n2;
            if (!this.isStorageNotLow(context)) {
                n3 = n2 | 0x10;
            }
        }
        return n3;
    }

    public int getRequirements() {
        return this.requirements;
    }

    public int hashCode() {
        return this.requirements;
    }

    public boolean isChargingRequired() {
        boolean bl = (this.requirements & 8) != 0;
        return bl;
    }

    public boolean isIdleRequired() {
        boolean bl = (this.requirements & 4) != 0;
        return bl;
    }

    public boolean isNetworkRequired() {
        int n2 = this.requirements;
        boolean bl = true;
        if ((n2 & 1) == 0) {
            bl = false;
        }
        return bl;
    }

    public boolean isStorageNotLowRequired() {
        boolean bl = (this.requirements & 0x10) != 0;
        return bl;
    }

    public boolean isUnmeteredNetworkRequired() {
        boolean bl = (this.requirements & 2) != 0;
        return bl;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.requirements);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequirementFlags {
    }
}

