/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import com.google.android.exoplayer2.offline.Download;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.offline._$;
import com.google.android.exoplayer2.scheduler.Requirements;
import com.google.android.exoplayer2.scheduler.Scheduler;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.HashMap;
import java.util.List;

public abstract class DownloadService
extends Service {
    public static final String ACTION_ADD_DOWNLOAD = "com.google.android.exoplayer.downloadService.action.ADD_DOWNLOAD";
    public static final String ACTION_INIT = "com.google.android.exoplayer.downloadService.action.INIT";
    public static final String ACTION_PAUSE_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.PAUSE_DOWNLOADS";
    public static final String ACTION_REMOVE_ALL_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.REMOVE_ALL_DOWNLOADS";
    public static final String ACTION_REMOVE_DOWNLOAD = "com.google.android.exoplayer.downloadService.action.REMOVE_DOWNLOAD";
    private static final String ACTION_RESTART = "com.google.android.exoplayer.downloadService.action.RESTART";
    public static final String ACTION_RESUME_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.RESUME_DOWNLOADS";
    public static final String ACTION_SET_REQUIREMENTS = "com.google.android.exoplayer.downloadService.action.SET_REQUIREMENTS";
    public static final String ACTION_SET_STOP_REASON = "com.google.android.exoplayer.downloadService.action.SET_STOP_REASON";
    public static final long DEFAULT_FOREGROUND_NOTIFICATION_UPDATE_INTERVAL = 1000L;
    public static final int FOREGROUND_NOTIFICATION_ID_NONE = 0;
    public static final String KEY_CONTENT_ID = "content_id";
    public static final String KEY_DOWNLOAD_REQUEST = "download_request";
    public static final String KEY_FOREGROUND = "foreground";
    public static final String KEY_REQUIREMENTS = "requirements";
    public static final String KEY_STOP_REASON = "stop_reason";
    private static final String TAG = "DownloadService";
    private static final HashMap<Class<? extends DownloadService>, DownloadManagerHelper> downloadManagerHelpers = new HashMap();
    private final int channelDescriptionResourceId;
    private final String channelId;
    private final int channelNameResourceId;
    private DownloadManager downloadManager;
    private final ForegroundNotificationUpdater foregroundNotificationUpdater;
    private boolean isDestroyed;
    private boolean isStopped;
    private int lastStartId;
    private boolean startedInForeground;
    private boolean taskRemoved;

    protected DownloadService(int n2) {
        this(n2, 1000L);
    }

    protected DownloadService(int n2, long l2) {
        this(n2, l2, null, 0, 0);
    }

    @Deprecated
    protected DownloadService(int n2, long l2, String string2, int n3) {
        this(n2, l2, string2, n3, 0);
    }

    protected DownloadService(int n2, long l2, String string2, int n3, int n4) {
        if (n2 == 0) {
            this.foregroundNotificationUpdater = null;
            this.channelId = null;
            this.channelNameResourceId = 0;
            this.channelDescriptionResourceId = 0;
        } else {
            this.foregroundNotificationUpdater = new ForegroundNotificationUpdater(n2, l2);
            this.channelId = string2;
            this.channelNameResourceId = n3;
            this.channelDescriptionResourceId = n4;
        }
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int n2, boolean bl) {
        return DownloadService.getIntent(context, clazz, ACTION_ADD_DOWNLOAD, bl).putExtra(KEY_DOWNLOAD_REQUEST, (Parcelable)downloadRequest).putExtra(KEY_STOP_REASON, n2);
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean bl) {
        return DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, 0, bl);
    }

    public static Intent buildPauseDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean bl) {
        return DownloadService.getIntent(context, clazz, ACTION_PAUSE_DOWNLOADS, bl);
    }

    public static Intent buildRemoveAllDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean bl) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_ALL_DOWNLOADS, bl);
    }

    public static Intent buildRemoveDownloadIntent(Context context, Class<? extends DownloadService> clazz, String string2, boolean bl) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_DOWNLOAD, bl).putExtra(KEY_CONTENT_ID, string2);
    }

    public static Intent buildResumeDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean bl) {
        return DownloadService.getIntent(context, clazz, ACTION_RESUME_DOWNLOADS, bl);
    }

    public static Intent buildSetRequirementsIntent(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean bl) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_REQUIREMENTS, bl).putExtra(KEY_REQUIREMENTS, (Parcelable)requirements);
    }

    public static Intent buildSetStopReasonIntent(Context context, Class<? extends DownloadService> clazz, String string2, int n2, boolean bl) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_STOP_REASON, bl).putExtra(KEY_CONTENT_ID, string2).putExtra(KEY_STOP_REASON, n2);
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String string2) {
        return new Intent(context, clazz).setAction(string2);
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String string2, boolean bl) {
        return DownloadService.getIntent(context, clazz, string2).putExtra(KEY_FOREGROUND, bl);
    }

    private boolean isStopped() {
        return this.isStopped;
    }

    private static boolean needsStartedService(int n2) {
        boolean bl = n2 == 2 || n2 == 5 || n2 == 7;
        return bl;
    }

    private void notifyDownloadChanged(Download download) {
        this.onDownloadChanged(download);
        if (this.foregroundNotificationUpdater != null) {
            if (DownloadService.needsStartedService(download.state)) {
                this.foregroundNotificationUpdater.startPeriodicUpdates();
            } else {
                this.foregroundNotificationUpdater.invalidate();
            }
        }
    }

    private void notifyDownloadRemoved(Download object) {
        this.onDownloadRemoved((Download)object);
        object = this.foregroundNotificationUpdater;
        if (object != null) {
            ((ForegroundNotificationUpdater)object).invalidate();
        }
    }

    private void notifyDownloads(List<Download> list) {
        if (this.foregroundNotificationUpdater != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!DownloadService.needsStartedService(list.get((int)i2).state)) continue;
                this.foregroundNotificationUpdater.startPeriodicUpdates();
                break;
            }
        }
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int n2, boolean bl) {
        DownloadService.startService(context, DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, n2, bl), bl);
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean bl) {
        DownloadService.startService(context, DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, bl), bl);
    }

    public static void sendPauseDownloads(Context context, Class<? extends DownloadService> clazz, boolean bl) {
        DownloadService.startService(context, DownloadService.buildPauseDownloadsIntent(context, clazz, bl), bl);
    }

    public static void sendRemoveAllDownloads(Context context, Class<? extends DownloadService> clazz, boolean bl) {
        DownloadService.startService(context, DownloadService.buildRemoveAllDownloadsIntent(context, clazz, bl), bl);
    }

    public static void sendRemoveDownload(Context context, Class<? extends DownloadService> clazz, String string2, boolean bl) {
        DownloadService.startService(context, DownloadService.buildRemoveDownloadIntent(context, clazz, string2, bl), bl);
    }

    public static void sendResumeDownloads(Context context, Class<? extends DownloadService> clazz, boolean bl) {
        DownloadService.startService(context, DownloadService.buildResumeDownloadsIntent(context, clazz, bl), bl);
    }

    public static void sendSetRequirements(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean bl) {
        DownloadService.startService(context, DownloadService.buildSetRequirementsIntent(context, clazz, requirements, bl), bl);
    }

    public static void sendSetStopReason(Context context, Class<? extends DownloadService> clazz, String string2, int n2, boolean bl) {
        DownloadService.startService(context, DownloadService.buildSetStopReasonIntent(context, clazz, string2, n2, bl), bl);
    }

    public static void start(Context context, Class<? extends DownloadService> clazz) {
        context.startService(DownloadService.getIntent(context, clazz, ACTION_INIT));
    }

    public static void startForeground(Context context, Class<? extends DownloadService> clazz) {
        Util.startForegroundService(context, DownloadService.getIntent(context, clazz, ACTION_INIT, true));
    }

    private static void startService(Context context, Intent intent, boolean bl) {
        if (bl) {
            Util.startForegroundService(context, intent);
        } else {
            context.startService(intent);
        }
    }

    private void stop() {
        ForegroundNotificationUpdater foregroundNotificationUpdater = this.foregroundNotificationUpdater;
        if (foregroundNotificationUpdater != null) {
            foregroundNotificationUpdater.stopPeriodicUpdates();
        }
        if (Util.SDK_INT < 28 && this.taskRemoved) {
            this.stopSelf();
            this.isStopped = true;
        } else {
            this.isStopped |= this.stopSelfResult(this.lastStartId);
        }
    }

    protected abstract DownloadManager getDownloadManager();

    protected abstract Notification getForegroundNotification(List<Download> var1);

    protected abstract Scheduler getScheduler();

    protected final void invalidateForegroundNotification() {
        ForegroundNotificationUpdater foregroundNotificationUpdater = this.foregroundNotificationUpdater;
        if (foregroundNotificationUpdater != null && !this.isDestroyed) {
            foregroundNotificationUpdater.invalidate();
        }
    }

    public final IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException();
    }

    public void onCreate() {
        Class<?> clazz;
        Object object = this.channelId;
        if (object != null) {
            NotificationUtil.createNotificationChannel((Context)this, (String)object, this.channelNameResourceId, this.channelDescriptionResourceId, 2);
        }
        if ((object = downloadManagerHelpers.get(clazz = ((Object)((Object)this)).getClass())) == null) {
            boolean bl = this.foregroundNotificationUpdater != null;
            object = bl ? this.getScheduler() : null;
            this.downloadManager = this.getDownloadManager();
            this.downloadManager.resumeDownloads();
            object = new DownloadManagerHelper(this.getApplicationContext(), this.downloadManager, bl, (Scheduler)object, clazz);
            downloadManagerHelpers.put(clazz, (DownloadManagerHelper)object);
        } else {
            this.downloadManager = ((DownloadManagerHelper)object).downloadManager;
        }
        ((DownloadManagerHelper)object).attachService(this);
    }

    public void onDestroy() {
        this.isDestroyed = true;
        Assertions.checkNotNull(downloadManagerHelpers.get(((Object)((Object)this)).getClass())).detachService(this);
        ForegroundNotificationUpdater foregroundNotificationUpdater = this.foregroundNotificationUpdater;
        if (foregroundNotificationUpdater != null) {
            foregroundNotificationUpdater.stopPeriodicUpdates();
        }
    }

    @Deprecated
    protected void onDownloadChanged(Download download) {
    }

    @Deprecated
    protected void onDownloadRemoved(Download download) {
    }

    public int onStartCommand(Intent object, int n2, int n3) {
        DownloadManager downloadManager;
        String string2;
        Object object2;
        Object object3;
        block32: {
            this.lastStartId = n3;
            this.taskRemoved = false;
            object3 = null;
            if (object != null) {
                object3 = object.getAction();
                object2 = object.getStringExtra(KEY_CONTENT_ID);
                int n4 = this.startedInForeground;
                n2 = !object.getBooleanExtra(KEY_FOREGROUND, false) && !ACTION_RESTART.equals(object3) ? 0 : 1;
                this.startedInForeground = n4 | n2;
            } else {
                object2 = null;
            }
            string2 = object3;
            if (object3 == null) {
                string2 = ACTION_INIT;
            }
            downloadManager = Assertions.checkNotNull(this.downloadManager);
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1547520644: {
                    if (!string2.equals(ACTION_REMOVE_DOWNLOAD)) break;
                    n2 = 3;
                    break block32;
                }
                case 1015676687: {
                    if (!string2.equals(ACTION_INIT)) break;
                    n2 = 0;
                    break block32;
                }
                case 671523141: {
                    if (!string2.equals(ACTION_SET_STOP_REASON)) break;
                    n2 = 7;
                    break block32;
                }
                case 191112771: {
                    if (!string2.equals(ACTION_PAUSE_DOWNLOADS)) break;
                    n2 = 6;
                    break block32;
                }
                case -119057172: {
                    if (!string2.equals(ACTION_SET_REQUIREMENTS)) break;
                    n2 = 8;
                    break block32;
                }
                case -650547439: {
                    if (!string2.equals(ACTION_REMOVE_ALL_DOWNLOADS)) break;
                    n2 = 4;
                    break block32;
                }
                case -871181424: {
                    if (!string2.equals(ACTION_RESTART)) break;
                    n2 = 1;
                    break block32;
                }
                case -932047176: {
                    if (!string2.equals(ACTION_RESUME_DOWNLOADS)) break;
                    n2 = 5;
                    break block32;
                }
                case -1931239035: {
                    if (!string2.equals(ACTION_ADD_DOWNLOAD)) break;
                    n2 = 2;
                    break block32;
                }
            }
            n2 = -1;
        }
        switch (n2) {
            default: {
                object = new StringBuilder();
                ((StringBuilder)object).append("Ignored unrecognized action: ");
                ((StringBuilder)object).append(string2);
                Log.e(TAG, ((StringBuilder)object).toString());
                break;
            }
            case 8: {
                object3 = (Requirements)((Intent)Assertions.checkNotNull(object)).getParcelableExtra(KEY_REQUIREMENTS);
                if (object3 == null) {
                    Log.e(TAG, "Ignored SET_REQUIREMENTS: Missing requirements extra");
                    break;
                }
                object2 = this.getScheduler();
                object = object3;
                if (object2 != null) {
                    object2 = object2.getSupportedRequirements((Requirements)object3);
                    object = object3;
                    if (!((Requirements)object2).equals(object3)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Ignoring requirements not supported by the Scheduler: ");
                        ((StringBuilder)object).append(((Requirements)object3).getRequirements() ^ ((Requirements)object2).getRequirements());
                        Log.w(TAG, ((StringBuilder)object).toString());
                        object = object2;
                    }
                }
                downloadManager.setRequirements((Requirements)object);
                break;
            }
            case 7: {
                if (!((Intent)Assertions.checkNotNull(object)).hasExtra(KEY_STOP_REASON)) {
                    Log.e(TAG, "Ignored SET_STOP_REASON: Missing stop_reason extra");
                    break;
                }
                downloadManager.setStopReason((String)object2, object.getIntExtra(KEY_STOP_REASON, 0));
                break;
            }
            case 6: {
                downloadManager.pauseDownloads();
                break;
            }
            case 5: {
                downloadManager.resumeDownloads();
                break;
            }
            case 4: {
                downloadManager.removeAllDownloads();
                break;
            }
            case 3: {
                if (object2 == null) {
                    Log.e(TAG, "Ignored REMOVE_DOWNLOAD: Missing content_id extra");
                    break;
                }
                downloadManager.removeDownload((String)object2);
                break;
            }
            case 2: {
                object3 = (DownloadRequest)((Intent)Assertions.checkNotNull(object)).getParcelableExtra(KEY_DOWNLOAD_REQUEST);
                if (object3 == null) {
                    Log.e(TAG, "Ignored ADD_DOWNLOAD: Missing download_request extra");
                    break;
                }
                downloadManager.addDownload((DownloadRequest)object3, object.getIntExtra(KEY_STOP_REASON, 0));
            }
            case 0: 
            case 1: 
        }
        if (Util.SDK_INT >= 26 && this.startedInForeground && (object = this.foregroundNotificationUpdater) != null) {
            ((ForegroundNotificationUpdater)object).showNotificationIfNotAlready();
        }
        this.isStopped = false;
        if (downloadManager.isIdle()) {
            this.stop();
        }
        return 1;
    }

    public void onTaskRemoved(Intent intent) {
        this.taskRemoved = true;
    }

    private static final class DownloadManagerHelper
    implements DownloadManager.Listener {
        private final Context context;
        private final DownloadManager downloadManager;
        private DownloadService downloadService;
        private final boolean foregroundAllowed;
        private final Scheduler scheduler;
        private final Class<? extends DownloadService> serviceClass;

        private DownloadManagerHelper(Context context, DownloadManager downloadManager, boolean bl, Scheduler scheduler, Class<? extends DownloadService> clazz) {
            this.context = context;
            this.downloadManager = downloadManager;
            this.foregroundAllowed = bl;
            this.scheduler = scheduler;
            this.serviceClass = clazz;
            downloadManager.addListener(this);
            this.updateScheduler();
        }

        private void restartService() {
            if (this.foregroundAllowed) {
                Intent intent = DownloadService.getIntent(this.context, this.serviceClass, DownloadService.ACTION_RESTART);
                Util.startForegroundService(this.context, intent);
            } else {
                try {
                    Intent intent = DownloadService.getIntent(this.context, this.serviceClass, DownloadService.ACTION_INIT);
                    this.context.startService(intent);
                }
                catch (IllegalStateException illegalStateException) {
                    Log.w(DownloadService.TAG, "Failed to restart DownloadService (process is idle).");
                }
            }
        }

        private boolean serviceMayNeedRestart() {
            DownloadService downloadService = this.downloadService;
            boolean bl = downloadService == null || downloadService.isStopped();
            return bl;
        }

        private void updateScheduler() {
            if (this.scheduler == null) {
                return;
            }
            if (this.downloadManager.isWaitingForRequirements()) {
                String string2 = this.context.getPackageName();
                Requirements requirements = this.downloadManager.getRequirements();
                if (!this.scheduler.schedule(requirements, string2, DownloadService.ACTION_RESTART)) {
                    Log.e(DownloadService.TAG, "Scheduling downloads failed.");
                }
            } else {
                this.scheduler.cancel();
            }
        }

        public void attachService(DownloadService downloadService) {
            boolean bl = this.downloadService == null;
            Assertions.checkState(bl);
            this.downloadService = downloadService;
            if (this.downloadManager.isInitialized()) {
                Util.createHandlerForCurrentOrMainLooper().postAtFrontOfQueue((Runnable)new _$.Lambda.DownloadService.DownloadManagerHelper.Xq9wBYIDnVco2tFdAraQ883Ld78(this, downloadService));
            }
        }

        public void detachService(DownloadService downloadService) {
            boolean bl = this.downloadService == downloadService;
            Assertions.checkState(bl);
            this.downloadService = null;
            if (this.scheduler != null && !this.downloadManager.isWaitingForRequirements()) {
                this.scheduler.cancel();
            }
        }

        public /* synthetic */ void lambda$attachService$0$DownloadService$DownloadManagerHelper(DownloadService downloadService) {
            downloadService.notifyDownloads(this.downloadManager.getCurrentDownloads());
        }

        @Override
        public void onDownloadChanged(DownloadManager object, Download download, Exception exception) {
            object = this.downloadService;
            if (object != null) {
                ((DownloadService)((Object)object)).notifyDownloadChanged(download);
            }
            if (this.serviceMayNeedRestart() && DownloadService.needsStartedService(download.state)) {
                Log.w(DownloadService.TAG, "DownloadService wasn't running. Restarting.");
                this.restartService();
            }
        }

        @Override
        public void onDownloadRemoved(DownloadManager object, Download download) {
            object = this.downloadService;
            if (object != null) {
                ((DownloadService)((Object)object)).notifyDownloadRemoved(download);
            }
        }

        @Override
        public /* synthetic */ void onDownloadsPausedChanged(DownloadManager downloadManager, boolean bl) {
            DownloadManager.Listener._CC.$default$onDownloadsPausedChanged((DownloadManager.Listener)this, (DownloadManager)downloadManager, (boolean)bl);
        }

        @Override
        public final void onIdle(DownloadManager object) {
            object = this.downloadService;
            if (object != null) {
                ((DownloadService)((Object)object)).stop();
            }
        }

        @Override
        public void onInitialized(DownloadManager downloadManager) {
            DownloadService downloadService = this.downloadService;
            if (downloadService != null) {
                downloadService.notifyDownloads(downloadManager.getCurrentDownloads());
            }
        }

        @Override
        public /* synthetic */ void onRequirementsStateChanged(DownloadManager downloadManager, Requirements requirements, int n2) {
            DownloadManager.Listener._CC.$default$onRequirementsStateChanged((DownloadManager.Listener)this, (DownloadManager)downloadManager, (Requirements)requirements, (int)n2);
        }

        @Override
        public void onWaitingForRequirementsChanged(DownloadManager object, boolean bl) {
            if (!bl && !((DownloadManager)object).getDownloadsPaused() && this.serviceMayNeedRestart()) {
                object = ((DownloadManager)object).getCurrentDownloads();
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    if (((Download)object.get((int)i2)).state != 0) continue;
                    this.restartService();
                    break;
                }
            }
            this.updateScheduler();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class ForegroundNotificationUpdater {
        private final Handler handler;
        private boolean notificationDisplayed;
        private final int notificationId;
        private boolean periodicUpdatesStarted;
        private final long updateInterval;

        public ForegroundNotificationUpdater(int n2, long l2) {
            this.notificationId = n2;
            this.updateInterval = l2;
            this.handler = new Handler(Looper.getMainLooper());
        }

        public static /* synthetic */ void lambda$eUq1qNHKGaEQxl_qKPR-_tfIa8c(ForegroundNotificationUpdater foregroundNotificationUpdater) {
            foregroundNotificationUpdater.update();
        }

        private void update() {
            List<Download> list = Assertions.checkNotNull(DownloadService.this.downloadManager).getCurrentDownloads();
            DownloadService downloadService = DownloadService.this;
            downloadService.startForeground(this.notificationId, downloadService.getForegroundNotification(list));
            this.notificationDisplayed = true;
            if (this.periodicUpdatesStarted) {
                this.handler.removeCallbacksAndMessages(null);
                this.handler.postDelayed((Runnable)new _$.Lambda.DownloadService.ForegroundNotificationUpdater.eUq1qNHKGaEQxl_qKPR__tfIa8c(this), this.updateInterval);
            }
        }

        public void invalidate() {
            if (this.notificationDisplayed) {
                this.update();
            }
        }

        public void showNotificationIfNotAlready() {
            if (!this.notificationDisplayed) {
                this.update();
            }
        }

        public void startPeriodicUpdates() {
            this.periodicUpdatesStarted = true;
            this.update();
        }

        public void stopPeriodicUpdates() {
            this.periodicUpdatesStarted = false;
            this.handler.removeCallbacksAndMessages(null);
        }
    }
}

