/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.offline.DefaultDownloadIndex;
import com.google.android.exoplayer2.offline.DefaultDownloaderFactory;
import com.google.android.exoplayer2.offline.Download;
import com.google.android.exoplayer2.offline.DownloadCursor;
import com.google.android.exoplayer2.offline.DownloadIndex;
import com.google.android.exoplayer2.offline.DownloadProgress;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.offline.Downloader;
import com.google.android.exoplayer2.offline.DownloaderFactory;
import com.google.android.exoplayer2.offline.WritableDownloadIndex;
import com.google.android.exoplayer2.offline._$;
import com.google.android.exoplayer2.offline._$$Lambda$_14QHG018Z6p13d3hzJuGTWnNeo;
import com.google.android.exoplayer2.scheduler.Requirements;
import com.google.android.exoplayer2.scheduler.RequirementsWatcher;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DownloadManager {
    public static final int DEFAULT_MAX_PARALLEL_DOWNLOADS = 3;
    public static final int DEFAULT_MIN_RETRY_COUNT = 5;
    public static final Requirements DEFAULT_REQUIREMENTS = new Requirements(1);
    private static final int MSG_ADD_DOWNLOAD = 6;
    private static final int MSG_CONTENT_LENGTH_CHANGED = 10;
    private static final int MSG_DOWNLOAD_UPDATE = 2;
    private static final int MSG_INITIALIZE = 0;
    private static final int MSG_INITIALIZED = 0;
    private static final int MSG_PROCESSED = 1;
    private static final int MSG_RELEASE = 12;
    private static final int MSG_REMOVE_ALL_DOWNLOADS = 8;
    private static final int MSG_REMOVE_DOWNLOAD = 7;
    private static final int MSG_SET_DOWNLOADS_PAUSED = 1;
    private static final int MSG_SET_MAX_PARALLEL_DOWNLOADS = 4;
    private static final int MSG_SET_MIN_RETRY_COUNT = 5;
    private static final int MSG_SET_NOT_MET_REQUIREMENTS = 2;
    private static final int MSG_SET_STOP_REASON = 3;
    private static final int MSG_TASK_STOPPED = 9;
    private static final int MSG_UPDATE_PROGRESS = 11;
    private static final String TAG = "DownloadManager";
    private int activeTaskCount;
    private final Handler applicationHandler;
    private final Context context;
    private final WritableDownloadIndex downloadIndex;
    private List<Download> downloads;
    private boolean downloadsPaused;
    private boolean initialized;
    private final InternalHandler internalHandler;
    private final CopyOnWriteArraySet<Listener> listeners;
    private int maxParallelDownloads;
    private int minRetryCount;
    private int notMetRequirements;
    private int pendingMessages;
    private final RequirementsWatcher.Listener requirementsListener;
    private RequirementsWatcher requirementsWatcher;
    private boolean waitingForRequirements;

    @Deprecated
    public DownloadManager(Context context, DatabaseProvider databaseProvider, Cache cache, DataSource.Factory factory) {
        this(context, databaseProvider, cache, factory, (Executor)_$$Lambda$_14QHG018Z6p13d3hzJuGTWnNeo.INSTANCE);
    }

    public DownloadManager(Context context, DatabaseProvider databaseProvider, Cache cache, DataSource.Factory factory, Executor executor) {
        this(context, (WritableDownloadIndex)new DefaultDownloadIndex(databaseProvider), (DownloaderFactory)new DefaultDownloaderFactory(new CacheDataSource.Factory().setCache(cache).setUpstreamDataSourceFactory(factory), executor));
    }

    public DownloadManager(Context context, WritableDownloadIndex writableDownloadIndex, DownloaderFactory downloaderFactory) {
        Handler handler;
        this.context = context.getApplicationContext();
        this.downloadIndex = writableDownloadIndex;
        this.maxParallelDownloads = 3;
        this.minRetryCount = 5;
        this.downloadsPaused = true;
        this.downloads = Collections.emptyList();
        this.listeners = new CopyOnWriteArraySet();
        this.applicationHandler = handler = Util.createHandlerForCurrentOrMainLooper((Handler.Callback)new _$.Lambda.DownloadManager.Xh4j_vVe_x0mxr_dpfqpIQ3DikM(this));
        HandlerThread handlerThread = new HandlerThread("ExoPlayer:DownloadManager");
        handlerThread.start();
        this.internalHandler = new InternalHandler(handlerThread, writableDownloadIndex, downloaderFactory, handler, this.maxParallelDownloads, this.minRetryCount, this.downloadsPaused);
        writableDownloadIndex = new _$.Lambda.DownloadManager.9oihGmKoXEDrfeODE3DbaHprOHM(this);
        this.requirementsListener = writableDownloadIndex;
        this.requirementsWatcher = new RequirementsWatcher(context, (RequirementsWatcher.Listener)writableDownloadIndex, DEFAULT_REQUIREMENTS);
        this.notMetRequirements = this.requirementsWatcher.start();
        this.pendingMessages = 1;
        this.internalHandler.obtainMessage(0, this.notMetRequirements, 0).sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleMainMessage(Message message) {
        int n2 = message.what;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) throw new IllegalStateException();
                this.onDownloadUpdate((DownloadUpdate)message.obj);
                return true;
            } else {
                this.onMessageProcessed(message.arg1, message.arg2);
            }
            return true;
        } else {
            this.onInitialized((List)message.obj);
        }
        return true;
    }

    public static /* synthetic */ void lambda$9oihGmKoXEDrfeODE3DbaHprOHM(DownloadManager downloadManager, RequirementsWatcher requirementsWatcher, int n2) {
        downloadManager.onRequirementsStateChanged(requirementsWatcher, n2);
    }

    public static /* synthetic */ boolean lambda$Xh4j-vVe-x0mxr_dpfqpIQ3DikM(DownloadManager downloadManager, Message message) {
        return downloadManager.handleMainMessage(message);
    }

    static Download mergeRequest(Download download, DownloadRequest downloadRequest, int n2, long l2) {
        int n3 = download.state;
        long l3 = n3 != 5 && !download.isTerminalState() ? download.startTimeMs : l2;
        n3 = n3 != 5 && n3 != 7 ? (n2 != 0 ? 1 : 0) : 7;
        return new Download(download.request.copyWithMergedRequest(downloadRequest), n3, l3, l2, -1L, n2, 0);
    }

    private void notifyWaitingForRequirementsChanged() {
        Iterator<Listener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onWaitingForRequirementsChanged(this, this.waitingForRequirements);
        }
    }

    private void onDownloadUpdate(DownloadUpdate object) {
        this.downloads = Collections.unmodifiableList(((DownloadUpdate)object).downloads);
        Download download = ((DownloadUpdate)object).download;
        boolean bl = this.updateWaitingForRequirements();
        if (((DownloadUpdate)object).isRemove) {
            object = this.listeners.iterator();
            while (object.hasNext()) {
                ((Listener)object.next()).onDownloadRemoved(this, download);
            }
        } else {
            Iterator<Listener> iterator2 = this.listeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onDownloadChanged(this, download, ((DownloadUpdate)object).finalException);
            }
        }
        if (bl) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private void onInitialized(List<Download> object) {
        this.initialized = true;
        this.downloads = Collections.unmodifiableList(object);
        boolean bl = this.updateWaitingForRequirements();
        object = this.listeners.iterator();
        while (object.hasNext()) {
            ((Listener)object.next()).onInitialized(this);
        }
        if (bl) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private void onMessageProcessed(int n2, int n3) {
        this.pendingMessages -= n2;
        this.activeTaskCount = n3;
        if (this.isIdle()) {
            Iterator<Listener> iterator2 = this.listeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onIdle(this);
            }
        }
    }

    private void onRequirementsStateChanged(RequirementsWatcher object, int n2) {
        object = object.getRequirements();
        if (this.notMetRequirements != n2) {
            this.notMetRequirements = n2;
            ++this.pendingMessages;
            this.internalHandler.obtainMessage(2, n2, 0).sendToTarget();
        }
        boolean bl = this.updateWaitingForRequirements();
        Iterator<Listener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onRequirementsStateChanged(this, (Requirements)object, n2);
        }
        if (bl) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private void setDownloadsPaused(boolean bl) {
        if (this.downloadsPaused == bl) {
            return;
        }
        this.downloadsPaused = bl;
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(1, bl ? 1 : 0, 0).sendToTarget();
        boolean bl2 = this.updateWaitingForRequirements();
        Iterator<Listener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onDownloadsPausedChanged(this, bl);
        }
        if (bl2) {
            this.notifyWaitingForRequirementsChanged();
        }
    }

    private boolean updateWaitingForRequirements() {
        boolean bl = this.downloadsPaused;
        boolean bl2 = true;
        if (!bl && this.notMetRequirements != 0) {
            for (int i2 = 0; i2 < this.downloads.size(); ++i2) {
                if (this.downloads.get((int)i2).state != 0) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (this.waitingForRequirements == bl) {
            bl2 = false;
        }
        this.waitingForRequirements = bl;
        return bl2;
    }

    public void addDownload(DownloadRequest downloadRequest) {
        this.addDownload(downloadRequest, 0);
    }

    public void addDownload(DownloadRequest downloadRequest, int n2) {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(6, n2, 0, downloadRequest).sendToTarget();
    }

    public void addListener(Listener listener2) {
        Assertions.checkNotNull(listener2);
        this.listeners.add(listener2);
    }

    public Looper getApplicationLooper() {
        return this.applicationHandler.getLooper();
    }

    public List<Download> getCurrentDownloads() {
        return this.downloads;
    }

    public DownloadIndex getDownloadIndex() {
        return this.downloadIndex;
    }

    public boolean getDownloadsPaused() {
        return this.downloadsPaused;
    }

    public int getMaxParallelDownloads() {
        return this.maxParallelDownloads;
    }

    public int getMinRetryCount() {
        return this.minRetryCount;
    }

    public int getNotMetRequirements() {
        return this.notMetRequirements;
    }

    public Requirements getRequirements() {
        return this.requirementsWatcher.getRequirements();
    }

    public boolean isIdle() {
        boolean bl = this.activeTaskCount == 0 && this.pendingMessages == 0;
        return bl;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isWaitingForRequirements() {
        return this.waitingForRequirements;
    }

    public void pauseDownloads() {
        this.setDownloadsPaused(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        InternalHandler internalHandler = this.internalHandler;
        synchronized (internalHandler) {
            boolean bl;
            if (this.internalHandler.released) {
                return;
            }
            this.internalHandler.sendEmptyMessage(12);
            boolean bl2 = false;
            while (!(bl = this.internalHandler.released)) {
                try {
                    ((Object)((Object)this.internalHandler)).wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            this.applicationHandler.removeCallbacksAndMessages(null);
            this.downloads = Collections.emptyList();
            this.pendingMessages = 0;
            this.activeTaskCount = 0;
            this.initialized = false;
            this.notMetRequirements = 0;
            this.waitingForRequirements = false;
            return;
        }
    }

    public void removeAllDownloads() {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(8).sendToTarget();
    }

    public void removeDownload(String string2) {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(7, string2).sendToTarget();
    }

    public void removeListener(Listener listener2) {
        this.listeners.remove(listener2);
    }

    public void resumeDownloads() {
        this.setDownloadsPaused(false);
    }

    public void setMaxParallelDownloads(int n2) {
        boolean bl = n2 > 0;
        Assertions.checkArgument(bl);
        if (this.maxParallelDownloads == n2) {
            return;
        }
        this.maxParallelDownloads = n2;
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(4, n2, 0).sendToTarget();
    }

    public void setMinRetryCount(int n2) {
        boolean bl = n2 >= 0;
        Assertions.checkArgument(bl);
        if (this.minRetryCount == n2) {
            return;
        }
        this.minRetryCount = n2;
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(5, n2, 0).sendToTarget();
    }

    public void setRequirements(Requirements requirements) {
        if (requirements.equals(this.requirementsWatcher.getRequirements())) {
            return;
        }
        this.requirementsWatcher.stop();
        this.requirementsWatcher = new RequirementsWatcher(this.context, this.requirementsListener, requirements);
        int n2 = this.requirementsWatcher.start();
        this.onRequirementsStateChanged(this.requirementsWatcher, n2);
    }

    public void setStopReason(String string2, int n2) {
        ++this.pendingMessages;
        this.internalHandler.obtainMessage(3, n2, 0, string2).sendToTarget();
    }

    private static final class DownloadUpdate {
        public final Download download;
        public final List<Download> downloads;
        public final Exception finalException;
        public final boolean isRemove;

        public DownloadUpdate(Download download, boolean bl, List<Download> list, Exception exception) {
            this.download = download;
            this.isRemove = bl;
            this.downloads = list;
            this.finalException = exception;
        }
    }

    private static final class InternalHandler
    extends Handler {
        private static final int UPDATE_PROGRESS_INTERVAL_MS = 5000;
        private int activeDownloadTaskCount;
        private final HashMap<String, Task> activeTasks;
        private final WritableDownloadIndex downloadIndex;
        private final DownloaderFactory downloaderFactory;
        private final ArrayList<Download> downloads;
        private boolean downloadsPaused;
        private final Handler mainHandler;
        private int maxParallelDownloads;
        private int minRetryCount;
        private int notMetRequirements;
        public boolean released;
        private final HandlerThread thread;

        public InternalHandler(HandlerThread handlerThread, WritableDownloadIndex writableDownloadIndex, DownloaderFactory downloaderFactory, Handler handler, int n2, int n3, boolean bl) {
            super(handlerThread.getLooper());
            this.thread = handlerThread;
            this.downloadIndex = writableDownloadIndex;
            this.downloaderFactory = downloaderFactory;
            this.mainHandler = handler;
            this.maxParallelDownloads = n2;
            this.minRetryCount = n3;
            this.downloadsPaused = bl;
            this.downloads = new ArrayList();
            this.activeTasks = new HashMap();
        }

        private void addDownload(DownloadRequest downloadRequest, int n2) {
            Download download = this.getDownload(downloadRequest.id, true);
            long l2 = System.currentTimeMillis();
            if (download != null) {
                this.putDownload(DownloadManager.mergeRequest(download, downloadRequest, n2, l2));
            } else {
                int n3 = n2 != 0 ? 1 : 0;
                this.putDownload(new Download(downloadRequest, n3, l2, l2, -1L, n2, 0));
            }
            this.syncTasks();
        }

        private boolean canDownloadsRun() {
            boolean bl = !this.downloadsPaused && this.notMetRequirements == 0;
            return bl;
        }

        private static int compareStartTimes(Download download, Download download2) {
            return Util.compareLong(download.startTimeMs, download2.startTimeMs);
        }

        private static Download copyDownloadWithState(Download download, int n2, int n3) {
            return new Download(download.request, n2, download.startTimeMs, System.currentTimeMillis(), download.contentLength, n3, 0, download.progress);
        }

        private Download getDownload(String string2, boolean bl) {
            int n2 = this.getDownloadIndex(string2);
            if (n2 != -1) {
                return this.downloads.get(n2);
            }
            if (bl) {
                try {
                    Download download = this.downloadIndex.getDownload(string2);
                    return download;
                }
                catch (IOException iOException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed to load download: ");
                    stringBuilder.append(string2);
                    Log.e(DownloadManager.TAG, stringBuilder.toString(), iOException);
                }
            }
            return null;
        }

        private int getDownloadIndex(String string2) {
            for (int i2 = 0; i2 < this.downloads.size(); ++i2) {
                if (!this.downloads.get((int)i2).request.id.equals(string2)) continue;
                return i2;
            }
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void initialize(int n2) {
            Throwable throwable2;
            DownloadCursor downloadCursor;
            block7: {
                DownloadCursor downloadCursor2;
                this.notMetRequirements = n2;
                DownloadCursor downloadCursor3 = null;
                downloadCursor = downloadCursor2 = null;
                DownloadCursor downloadCursor4 = downloadCursor3;
                try {
                    try {
                        this.downloadIndex.setDownloadingStatesToQueued();
                        downloadCursor = downloadCursor2;
                        downloadCursor4 = downloadCursor3;
                        downloadCursor2 = this.downloadIndex.getDownloads(new int[]{0, 1, 2, 5, 7});
                        while (true) {
                            downloadCursor = downloadCursor2;
                            downloadCursor4 = downloadCursor2;
                            downloadCursor3 = downloadCursor2;
                            if (downloadCursor2.moveToNext()) {
                                downloadCursor = downloadCursor2;
                                downloadCursor4 = downloadCursor2;
                                this.downloads.add(downloadCursor2.getDownload());
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        downloadCursor = downloadCursor4;
                        Log.e(DownloadManager.TAG, "Failed to load index.", iOException);
                        downloadCursor = downloadCursor4;
                        this.downloads.clear();
                        downloadCursor3 = downloadCursor4;
                    }
                }
                catch (Throwable throwable2) {
                    break block7;
                }
                Util.closeQuietly(downloadCursor3);
                downloadCursor4 = new ArrayList(this.downloads);
                this.mainHandler.obtainMessage(0, downloadCursor4).sendToTarget();
                this.syncTasks();
                return;
            }
            Util.closeQuietly(downloadCursor);
            throw throwable2;
        }

        public static /* synthetic */ int lambda$NXQcmC9peGeDWV0s_8pBfzdJpS0(Download download, Download download2) {
            return InternalHandler.compareStartTimes(download, download2);
        }

        private void onContentLengthChanged(Task object, long l2) {
            object = Assertions.checkNotNull(this.getDownload(((Task)object).request.id, false));
            if (l2 != ((Download)object).contentLength && l2 != -1L) {
                this.putDownload(new Download(((Download)object).request, ((Download)object).state, ((Download)object).startTimeMs, System.currentTimeMillis(), l2, ((Download)object).stopReason, ((Download)object).failureReason, ((Download)object).progress));
            }
        }

        private void onDownloadTaskStopped(Download object, Exception exception) {
            DownloadRequest downloadRequest = ((Download)object).request;
            int n2 = exception == null ? 3 : 4;
            long l2 = ((Download)object).startTimeMs;
            long l3 = System.currentTimeMillis();
            long l4 = ((Download)object).contentLength;
            int n3 = ((Download)object).stopReason;
            int n4 = exception == null ? 0 : 1;
            object = new Download(downloadRequest, n2, l2, l3, l4, n3, n4, ((Download)object).progress);
            this.downloads.remove(this.getDownloadIndex(((Download)object).request.id));
            try {
                this.downloadIndex.putDownload((Download)object);
            }
            catch (IOException iOException) {
                Log.e(DownloadManager.TAG, "Failed to update index.", iOException);
            }
            object = new DownloadUpdate((Download)object, false, new ArrayList<Download>(this.downloads), exception);
            this.mainHandler.obtainMessage(2, object).sendToTarget();
        }

        private void onRemoveTaskStopped(Download object) {
            int n2 = ((Download)object).state;
            int n3 = 1;
            if (n2 == 7) {
                if (((Download)object).stopReason == 0) {
                    n3 = 0;
                }
                this.putDownloadWithState((Download)object, n3, ((Download)object).stopReason);
                this.syncTasks();
            } else {
                n3 = this.getDownloadIndex(((Download)object).request.id);
                this.downloads.remove(n3);
                try {
                    this.downloadIndex.removeDownload(((Download)object).request.id);
                }
                catch (IOException iOException) {
                    Log.e(DownloadManager.TAG, "Failed to remove from database");
                }
                object = new DownloadUpdate((Download)object, true, new ArrayList<Download>(this.downloads), null);
                this.mainHandler.obtainMessage(2, object).sendToTarget();
            }
        }

        private void onTaskStopped(Task object) {
            int n2;
            String string2 = ((Task)object).request.id;
            this.activeTasks.remove(string2);
            boolean bl = ((Task)object).isRemove;
            if (!bl) {
                this.activeDownloadTaskCount = n2 = this.activeDownloadTaskCount - 1;
                if (n2 == 0) {
                    this.removeMessages(11);
                }
            }
            if (((Task)object).isCanceled) {
                this.syncTasks();
                return;
            }
            Exception exception = ((Task)object).finalException;
            if (exception != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Task failed: ");
                stringBuilder.append(((Task)object).request);
                stringBuilder.append(", ");
                stringBuilder.append(bl);
                Log.e(DownloadManager.TAG, stringBuilder.toString(), exception);
            }
            object = Assertions.checkNotNull(this.getDownload(string2, false));
            n2 = ((Download)object).state;
            if (n2 != 2) {
                if (n2 != 5 && n2 != 7) {
                    throw new IllegalStateException();
                }
                Assertions.checkState(bl);
                this.onRemoveTaskStopped((Download)object);
            } else {
                Assertions.checkState(bl ^ true);
                this.onDownloadTaskStopped((Download)object, exception);
            }
            this.syncTasks();
        }

        private Download putDownload(Download download) {
            int n2 = download.state;
            boolean bl = true;
            boolean bl2 = n2 != 3 && download.state != 4;
            Assertions.checkState(bl2);
            n2 = this.getDownloadIndex(download.request.id);
            if (n2 == -1) {
                this.downloads.add(download);
                Collections.sort(this.downloads, _$.Lambda.DownloadManager.InternalHandler.NXQcmC9peGeDWV0s_8pBfzdJpS0.INSTANCE);
            } else {
                if (download.startTimeMs == this.downloads.get((int)n2).startTimeMs) {
                    bl = false;
                }
                this.downloads.set(n2, download);
                if (bl) {
                    Collections.sort(this.downloads, _$.Lambda.DownloadManager.InternalHandler.NXQcmC9peGeDWV0s_8pBfzdJpS0.INSTANCE);
                }
            }
            try {
                this.downloadIndex.putDownload(download);
            }
            catch (IOException iOException) {
                Log.e(DownloadManager.TAG, "Failed to update index.", iOException);
            }
            DownloadUpdate downloadUpdate = new DownloadUpdate(download, false, new ArrayList<Download>(this.downloads), null);
            this.mainHandler.obtainMessage(2, (Object)downloadUpdate).sendToTarget();
            return download;
        }

        private Download putDownloadWithState(Download download, int n2, int n3) {
            boolean bl = n2 != 3 && n2 != 4;
            Assertions.checkState(bl);
            return this.putDownload(InternalHandler.copyDownloadWithState(download, n2, n3));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void release() {
            Iterator<Task> iterator2 = this.activeTasks.values().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().cancel(true);
            }
            try {
                this.downloadIndex.setDownloadingStatesToQueued();
            }
            catch (IOException iOException) {
                Log.e(DownloadManager.TAG, "Failed to update index.", iOException);
            }
            this.downloads.clear();
            this.thread.quit();
            synchronized (this) {
                this.released = true;
                ((Object)((Object)this)).notifyAll();
                return;
            }
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void removeAllDownloads() {
            Object object;
            int n2;
            ArrayList<Download> arrayList;
            block16: {
                arrayList = new ArrayList<Download>();
                DownloadCursor downloadCursor = this.downloadIndex.getDownloads(new int[]{3, 4});
                while (downloadCursor.moveToNext()) {
                    arrayList.add(downloadCursor.getDownload());
                }
                if (downloadCursor == null) break block16;
                downloadCursor.close();
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (downloadCursor == null) throw throwable2;
                        try {
                            downloadCursor.close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable.addSuppressed(throwable3);
                                throw throwable2;
                            }
                            catch (IOException iOException) {
                                Log.e(DownloadManager.TAG, "Failed to load downloads.");
                            }
                        }
                    }
                }
            }
            for (n2 = 0; n2 < this.downloads.size(); ++n2) {
                object = this.downloads;
                ((ArrayList)object).set(n2, (Download)InternalHandler.copyDownloadWithState(((ArrayList)object).get(n2), 5, 0));
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.downloads.add(InternalHandler.copyDownloadWithState((Download)arrayList.get(n2), 5, 0));
            }
            Collections.sort(this.downloads, _$.Lambda.DownloadManager.InternalHandler.NXQcmC9peGeDWV0s_8pBfzdJpS0.INSTANCE);
            try {
                this.downloadIndex.setStatesToRemoving();
            }
            catch (IOException iOException) {
                Log.e(DownloadManager.TAG, "Failed to update index.", iOException);
            }
            arrayList = new ArrayList<Download>(this.downloads);
            for (n2 = 0; n2 < this.downloads.size(); ++n2) {
                object = new DownloadUpdate(this.downloads.get(n2), false, arrayList, null);
                this.mainHandler.obtainMessage(2, object).sendToTarget();
            }
            this.syncTasks();
        }

        private void removeDownload(String string2) {
            Object object = this.getDownload(string2, true);
            if (object == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Failed to remove nonexistent download: ");
                ((StringBuilder)object).append(string2);
                Log.e(DownloadManager.TAG, ((StringBuilder)object).toString());
                return;
            }
            this.putDownloadWithState((Download)object, 5, 0);
            this.syncTasks();
        }

        private void setDownloadsPaused(boolean bl) {
            this.downloadsPaused = bl;
            this.syncTasks();
        }

        private void setMaxParallelDownloads(int n2) {
            this.maxParallelDownloads = n2;
            this.syncTasks();
        }

        private void setMinRetryCount(int n2) {
            this.minRetryCount = n2;
        }

        private void setNotMetRequirements(int n2) {
            this.notMetRequirements = n2;
            this.syncTasks();
        }

        private void setStopReason(Download download, int n2) {
            block6: {
                int n3;
                block8: {
                    block7: {
                        block5: {
                            if (n2 != 0) break block5;
                            if (download.state == 1) {
                                this.putDownloadWithState(download, 0, 0);
                            }
                            break block6;
                        }
                        if (n2 == download.stopReason) break block6;
                        int n4 = download.state;
                        if (n4 == 0) break block7;
                        n3 = n4;
                        if (n4 != 2) break block8;
                    }
                    n3 = 1;
                }
                this.putDownload(new Download(download.request, n3, download.startTimeMs, System.currentTimeMillis(), download.contentLength, n2, 0, download.progress));
            }
        }

        private void setStopReason(String string2, int n2) {
            if (string2 == null) {
                for (int i2 = 0; i2 < this.downloads.size(); ++i2) {
                    this.setStopReason(this.downloads.get(i2), n2);
                }
                try {
                    this.downloadIndex.setStopReason(n2);
                }
                catch (IOException iOException) {
                    Log.e(DownloadManager.TAG, "Failed to set manual stop reason", iOException);
                }
            } else {
                Download download = this.getDownload(string2, false);
                if (download != null) {
                    this.setStopReason(download, n2);
                } else {
                    try {
                        this.downloadIndex.setStopReason(string2, n2);
                    }
                    catch (IOException iOException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Failed to set manual stop reason: ");
                        stringBuilder.append(string2);
                        Log.e(DownloadManager.TAG, stringBuilder.toString(), iOException);
                    }
                }
            }
            this.syncTasks();
        }

        private void syncDownloadingDownload(Task task2, Download download, int n2) {
            Assertions.checkState(task2.isRemove ^ true);
            if (!this.canDownloadsRun() || n2 >= this.maxParallelDownloads) {
                this.putDownloadWithState(download, 0, 0);
                task2.cancel(false);
            }
        }

        private Task syncQueuedDownload(Task object, Download object2) {
            if (object != null) {
                Assertions.checkState(((Task)object).isRemove ^ true);
                ((Task)object).cancel(false);
                return object;
            }
            if (this.canDownloadsRun() && this.activeDownloadTaskCount < this.maxParallelDownloads) {
                object = this.putDownloadWithState((Download)object2, 2, 0);
                object2 = this.downloaderFactory.createDownloader(((Download)object).request);
                object2 = new Task(((Download)object).request, (Downloader)object2, ((Download)object).progress, false, this.minRetryCount, this);
                this.activeTasks.put(((Download)object).request.id, (Task)object2);
                int n2 = this.activeDownloadTaskCount;
                this.activeDownloadTaskCount = n2 + 1;
                if (n2 == 0) {
                    this.sendEmptyMessageDelayed(11, 5000L);
                }
                ((Thread)object2).start();
                return object2;
            }
            return null;
        }

        private void syncRemovingDownload(Task object, Download download) {
            if (object != null) {
                if (!((Task)object).isRemove) {
                    ((Task)object).cancel(false);
                }
                return;
            }
            object = this.downloaderFactory.createDownloader(download.request);
            object = new Task(download.request, (Downloader)object, download.progress, true, this.minRetryCount, this);
            this.activeTasks.put(download.request.id, (Task)object);
            ((Thread)object).start();
        }

        private void syncStoppedDownload(Task task2) {
            if (task2 != null) {
                Assertions.checkState(task2.isRemove ^ true);
                task2.cancel(false);
            }
        }

        private void syncTasks() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.downloads.size(); ++i2) {
                Download download = this.downloads.get(i2);
                Task task2 = this.activeTasks.get(download.request.id);
                int n3 = download.state;
                if (n3 != 0) {
                    if (n3 != 1) {
                        if (n3 != 2) {
                            if (n3 != 5 && n3 != 7) {
                                throw new IllegalStateException();
                            }
                            this.syncRemovingDownload(task2, download);
                        } else {
                            Assertions.checkNotNull(task2);
                            this.syncDownloadingDownload(task2, download, n2);
                        }
                    } else {
                        this.syncStoppedDownload(task2);
                    }
                } else {
                    task2 = this.syncQueuedDownload(task2, download);
                }
                n3 = n2;
                if (task2 != null) {
                    n3 = n2;
                    if (!task2.isRemove) {
                        n3 = n2 + 1;
                    }
                }
                n2 = n3;
            }
        }

        private void updateProgress() {
            for (int i2 = 0; i2 < this.downloads.size(); ++i2) {
                Download download = this.downloads.get(i2);
                if (download.state != 2) continue;
                try {
                    this.downloadIndex.putDownload(download);
                    continue;
                }
                catch (IOException iOException) {
                    Log.e(DownloadManager.TAG, "Failed to update index.", iOException);
                }
            }
            this.sendEmptyMessageDelayed(11, 5000L);
        }

        public void handleMessage(Message message) {
            int n2;
            block16: {
                int n3 = message.what;
                n2 = 0;
                boolean bl = false;
                switch (n3) {
                    default: {
                        throw new IllegalStateException();
                    }
                    case 12: {
                        this.release();
                        return;
                    }
                    case 11: {
                        this.updateProgress();
                        return;
                    }
                    case 10: {
                        this.onContentLengthChanged((Task)message.obj, Util.toLong(message.arg1, message.arg2));
                        return;
                    }
                    case 9: {
                        this.onTaskStopped((Task)message.obj);
                        break block16;
                    }
                    case 8: {
                        this.removeAllDownloads();
                        break;
                    }
                    case 7: {
                        this.removeDownload((String)message.obj);
                        break;
                    }
                    case 6: {
                        this.addDownload((DownloadRequest)message.obj, message.arg1);
                        break;
                    }
                    case 5: {
                        this.setMinRetryCount(message.arg1);
                        break;
                    }
                    case 4: {
                        this.setMaxParallelDownloads(message.arg1);
                        break;
                    }
                    case 3: {
                        this.setStopReason((String)message.obj, message.arg1);
                        break;
                    }
                    case 2: {
                        this.setNotMetRequirements(message.arg1);
                        break;
                    }
                    case 1: {
                        if (message.arg1 != 0) {
                            bl = true;
                        }
                        this.setDownloadsPaused(bl);
                        break;
                    }
                    case 0: {
                        this.initialize(message.arg1);
                    }
                }
                n2 = 1;
            }
            this.mainHandler.obtainMessage(1, n2, this.activeTasks.size()).sendToTarget();
        }
    }

    public static interface Listener {
        public void onDownloadChanged(DownloadManager var1, Download var2, Exception var3);

        public void onDownloadRemoved(DownloadManager var1, Download var2);

        public void onDownloadsPausedChanged(DownloadManager var1, boolean var2);

        public void onIdle(DownloadManager var1);

        public void onInitialized(DownloadManager var1);

        public void onRequirementsStateChanged(DownloadManager var1, Requirements var2, int var3);

        public void onWaitingForRequirementsChanged(DownloadManager var1, boolean var2);
    }

    private static class Task
    extends Thread
    implements Downloader.ProgressListener {
        private long contentLength;
        private final DownloadProgress downloadProgress;
        private final Downloader downloader;
        private Exception finalException;
        private volatile InternalHandler internalHandler;
        private volatile boolean isCanceled;
        private final boolean isRemove;
        private final int minRetryCount;
        private final DownloadRequest request;

        private Task(DownloadRequest downloadRequest, Downloader downloader, DownloadProgress downloadProgress, boolean bl, int n2, InternalHandler internalHandler) {
            this.request = downloadRequest;
            this.downloader = downloader;
            this.downloadProgress = downloadProgress;
            this.isRemove = bl;
            this.minRetryCount = n2;
            this.internalHandler = internalHandler;
            this.contentLength = -1L;
        }

        private static int getRetryDelayMillis(int n2) {
            return Math.min((n2 - 1) * 1000, 5000);
        }

        public void cancel(boolean bl) {
            if (bl) {
                this.internalHandler = null;
            }
            if (!this.isCanceled) {
                this.isCanceled = true;
                this.downloader.cancel();
                this.interrupt();
            }
        }

        @Override
        public void onProgress(long l2, long l3, float f2) {
            Object object = this.downloadProgress;
            object.bytesDownloaded = l3;
            object.percentDownloaded = f2;
            if (l2 != this.contentLength) {
                this.contentLength = l2;
                object = this.internalHandler;
                if (object != null) {
                    object.obtainMessage(10, (int)(l2 >> 32), (int)l2, (Object)this).sendToTarget();
                }
            }
        }

        @Override
        public void run() {
            block13: {
                if (this.isRemove) {
                    this.downloader.remove();
                    break block13;
                }
                long l2 = -1L;
                int n2 = 0;
                while (true) {
                    boolean bl = this.isCanceled;
                    if (bl) break;
                    try {
                        this.downloader.download(this);
                    }
                    catch (IOException iOException) {
                        block14: {
                            if (this.isCanceled) continue;
                            long l3 = this.downloadProgress.bytesDownloaded;
                            long l4 = l2;
                            if (l3 != l2) {
                                l4 = l3;
                                n2 = 0;
                            }
                            ++n2;
                            if (n2 > this.minRetryCount) break block14;
                            Thread.sleep(Task.getRetryDelayMillis(n2));
                            l2 = l4;
                            continue;
                        }
                        try {
                            throw iOException;
                        }
                        catch (Exception exception) {
                            this.finalException = exception;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    break;
                }
            }
            InternalHandler internalHandler = this.internalHandler;
            if (internalHandler != null) {
                internalHandler.obtainMessage(9, this).sendToTarget();
            }
        }
    }
}

