/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import com.google.android.exoplayer2.offline.DownloadProgress;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.util.Assertions;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Download {
    public static final int FAILURE_REASON_NONE = 0;
    public static final int FAILURE_REASON_UNKNOWN = 1;
    public static final int STATE_COMPLETED = 3;
    public static final int STATE_DOWNLOADING = 2;
    public static final int STATE_FAILED = 4;
    public static final int STATE_QUEUED = 0;
    public static final int STATE_REMOVING = 5;
    public static final int STATE_RESTARTING = 7;
    public static final int STATE_STOPPED = 1;
    public static final int STOP_REASON_NONE = 0;
    public final long contentLength;
    public final int failureReason;
    final DownloadProgress progress;
    public final DownloadRequest request;
    public final long startTimeMs;
    public final int state;
    public final int stopReason;
    public final long updateTimeMs;

    public Download(DownloadRequest downloadRequest, int n2, long l2, long l3, long l4, int n3, int n4) {
        this(downloadRequest, n2, l2, l3, l4, n3, n4, new DownloadProgress());
    }

    public Download(DownloadRequest downloadRequest, int n2, long l2, long l3, long l4, int n3, int n4, DownloadProgress downloadProgress) {
        Assertions.checkNotNull(downloadProgress);
        boolean bl = true;
        boolean bl2 = n4 == 0;
        boolean bl3 = n2 != 4;
        boolean bl4 = bl2 == bl3;
        Assertions.checkArgument(bl4);
        if (n3 != 0) {
            bl4 = n2 != 2 && n2 != 0 ? bl : false;
            Assertions.checkArgument(bl4);
        }
        this.request = downloadRequest;
        this.state = n2;
        this.startTimeMs = l2;
        this.updateTimeMs = l3;
        this.contentLength = l4;
        this.stopReason = n3;
        this.failureReason = n4;
        this.progress = downloadProgress;
    }

    public long getBytesDownloaded() {
        return this.progress.bytesDownloaded;
    }

    public float getPercentDownloaded() {
        return this.progress.percentDownloaded;
    }

    public boolean isTerminalState() {
        int n2 = this.state;
        boolean bl = n2 == 3 || n2 == 4;
        return bl;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FailureReason {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

