/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.scte35;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.exoplayer2.metadata.scte35.SpliceCommand;
import com.google.android.exoplayer2.metadata.scte35.TimeSignalCommand;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SpliceInsertCommand
extends SpliceCommand {
    public static final Parcelable.Creator<SpliceInsertCommand> CREATOR = new Parcelable.Creator<SpliceInsertCommand>(){

        public SpliceInsertCommand createFromParcel(Parcel parcel) {
            return new SpliceInsertCommand(parcel);
        }

        public SpliceInsertCommand[] newArray(int n2) {
            return new SpliceInsertCommand[n2];
        }
    };
    public final boolean autoReturn;
    public final int availNum;
    public final int availsExpected;
    public final long breakDurationUs;
    public final List<ComponentSplice> componentSpliceList;
    public final boolean outOfNetworkIndicator;
    public final boolean programSpliceFlag;
    public final long programSplicePlaybackPositionUs;
    public final long programSplicePts;
    public final boolean spliceEventCancelIndicator;
    public final long spliceEventId;
    public final boolean spliceImmediateFlag;
    public final int uniqueProgramId;

    private SpliceInsertCommand(long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l3, long l4, List<ComponentSplice> list, boolean bl5, long l5, int n2, int n3, int n4) {
        this.spliceEventId = l2;
        this.spliceEventCancelIndicator = bl;
        this.outOfNetworkIndicator = bl2;
        this.programSpliceFlag = bl3;
        this.spliceImmediateFlag = bl4;
        this.programSplicePts = l3;
        this.programSplicePlaybackPositionUs = l4;
        this.componentSpliceList = Collections.unmodifiableList(list);
        this.autoReturn = bl5;
        this.breakDurationUs = l5;
        this.uniqueProgramId = n2;
        this.availNum = n3;
        this.availsExpected = n4;
    }

    private SpliceInsertCommand(Parcel parcel) {
        this.spliceEventId = parcel.readLong();
        int n2 = parcel.readByte();
        boolean bl = false;
        boolean bl2 = n2 == 1;
        this.spliceEventCancelIndicator = bl2;
        bl2 = parcel.readByte() == 1;
        this.outOfNetworkIndicator = bl2;
        bl2 = parcel.readByte() == 1;
        this.programSpliceFlag = bl2;
        bl2 = parcel.readByte() == 1;
        this.spliceImmediateFlag = bl2;
        this.programSplicePts = parcel.readLong();
        this.programSplicePlaybackPositionUs = parcel.readLong();
        int n3 = parcel.readInt();
        ArrayList<ComponentSplice> arrayList = new ArrayList<ComponentSplice>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(ComponentSplice.createFromParcel(parcel));
        }
        this.componentSpliceList = Collections.unmodifiableList(arrayList);
        bl2 = bl;
        if (parcel.readByte() == 1) {
            bl2 = true;
        }
        this.autoReturn = bl2;
        this.breakDurationUs = parcel.readLong();
        this.uniqueProgramId = parcel.readInt();
        this.availNum = parcel.readInt();
        this.availsExpected = parcel.readInt();
    }

    static SpliceInsertCommand parseFromSection(ParsableByteArray parsableByteArray, long l2, TimestampAdjuster timestampAdjuster) {
        boolean bl;
        int n2;
        long l3;
        boolean bl2;
        int n3;
        boolean bl3;
        boolean bl4;
        int n4;
        long l4 = parsableByteArray.readUnsignedInt();
        boolean bl5 = (parsableByteArray.readUnsignedByte() & 0x80) != 0;
        List<ComponentSplice> list = Collections.emptyList();
        if (!bl5) {
            n4 = parsableByteArray.readUnsignedByte();
            bl4 = (n4 & 0x80) != 0;
            bl3 = (n4 & 0x40) != 0;
            n3 = (n4 & 0x20) != 0 ? 1 : 0;
            bl2 = (n4 & 0x10) != 0;
            l3 = bl3 && !bl2 ? TimeSignalCommand.parseSpliceTime((ParsableByteArray)parsableByteArray, (long)l2) : -9223372036854775807L;
            if (!bl3) {
                n2 = parsableByteArray.readUnsignedByte();
                ArrayList<ComponentSplice> arrayList = new ArrayList<ComponentSplice>(n2);
                n4 = 0;
                while (true) {
                    list = arrayList;
                    if (n4 >= n2) break;
                    int n5 = parsableByteArray.readUnsignedByte();
                    long l5 = !bl2 ? TimeSignalCommand.parseSpliceTime((ParsableByteArray)parsableByteArray, (long)l2) : -9223372036854775807L;
                    arrayList.add(new ComponentSplice(n5, l5, timestampAdjuster.adjustTsTimestamp(l5)));
                    ++n4;
                }
            }
            if (n3 != 0) {
                l2 = parsableByteArray.readUnsignedByte();
                bl = (0x80L & l2) != 0L;
                l2 = ((l2 & 1L) << 32 | parsableByteArray.readUnsignedInt()) * 1000L / 90L;
            } else {
                l2 = -9223372036854775807L;
                bl = false;
            }
            n2 = parsableByteArray.readUnsignedShort();
            n3 = parsableByteArray.readUnsignedByte();
            n4 = parsableByteArray.readUnsignedByte();
            boolean bl6 = bl;
            bl = bl2;
            bl2 = bl6;
        } else {
            bl4 = false;
            bl = false;
            l3 = -9223372036854775807L;
            bl2 = false;
            l2 = -9223372036854775807L;
            n2 = 0;
            n3 = 0;
            n4 = 0;
            bl3 = false;
        }
        return new SpliceInsertCommand(l4, bl5, bl4, bl3, bl, l3, timestampAdjuster.adjustTsTimestamp(l3), list, bl2, l2, n2, n3, n4);
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeLong(this.spliceEventId);
        parcel.writeByte((byte)(this.spliceEventCancelIndicator ? 1 : 0));
        parcel.writeByte((byte)(this.outOfNetworkIndicator ? 1 : 0));
        parcel.writeByte((byte)(this.programSpliceFlag ? 1 : 0));
        parcel.writeByte((byte)(this.spliceImmediateFlag ? 1 : 0));
        parcel.writeLong(this.programSplicePts);
        parcel.writeLong(this.programSplicePlaybackPositionUs);
        int n3 = this.componentSpliceList.size();
        parcel.writeInt(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            this.componentSpliceList.get(n2).writeToParcel(parcel);
        }
        parcel.writeByte((byte)(this.autoReturn ? 1 : 0));
        parcel.writeLong(this.breakDurationUs);
        parcel.writeInt(this.uniqueProgramId);
        parcel.writeInt(this.availNum);
        parcel.writeInt(this.availsExpected);
    }

    public static final class ComponentSplice {
        public final long componentSplicePlaybackPositionUs;
        public final long componentSplicePts;
        public final int componentTag;

        private ComponentSplice(int n2, long l2, long l3) {
            this.componentTag = n2;
            this.componentSplicePts = l2;
            this.componentSplicePlaybackPositionUs = l3;
        }

        public static ComponentSplice createFromParcel(Parcel parcel) {
            return new ComponentSplice(parcel.readInt(), parcel.readLong(), parcel.readLong());
        }

        public void writeToParcel(Parcel parcel) {
            parcel.writeInt(this.componentTag);
            parcel.writeLong(this.componentSplicePts);
            parcel.writeLong(this.componentSplicePlaybackPositionUs);
        }
    }
}

