/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec._$;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class MediaCodecUtil {
    private static final String CODEC_ID_AV01 = "av01";
    private static final String CODEC_ID_AVC1 = "avc1";
    private static final String CODEC_ID_AVC2 = "avc2";
    private static final String CODEC_ID_HEV1 = "hev1";
    private static final String CODEC_ID_HVC1 = "hvc1";
    private static final String CODEC_ID_MP4A = "mp4a";
    private static final String CODEC_ID_VP09 = "vp09";
    private static final Pattern PROFILE_PATTERN = Pattern.compile("^\\D?(\\d+)$");
    private static final String TAG = "MediaCodecUtil";
    private static final HashMap<CodecKey, List<MediaCodecInfo>> decoderInfosCache = new HashMap();
    private static int maxH264DecodableFrameSize = -1;

    private MediaCodecUtil() {
    }

    private static void applyWorkarounds(String string2, List<MediaCodecInfo> list) {
        if ("audio/raw".equals(string2)) {
            if (Util.SDK_INT < 26 && Util.DEVICE.equals("R9") && list.size() == 1 && list.get((int)0).name.equals("OMX.MTK.AUDIO.DECODER.RAW")) {
                list.add(MediaCodecInfo.newInstance((String)"OMX.google.raw.decoder", (String)"audio/raw", (String)"audio/raw", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false));
            }
            MediaCodecUtil.sortByScore(list, _$.Lambda.MediaCodecUtil.cCWO_3tN34TxRUMGlkaLU13g9pw.INSTANCE);
        }
        if (Util.SDK_INT < 21 && list.size() > 1 && ("OMX.SEC.mp3.dec".equals(string2 = list.get((int)0).name) || "OMX.SEC.MP3.Decoder".equals(string2) || "OMX.brcm.audio.mp3.decoder".equals(string2))) {
            MediaCodecUtil.sortByScore(list, _$.Lambda.MediaCodecUtil.5Z_WFpP5Ck4Hyp9KyuAYDjY5c2U.INSTANCE);
        }
        if (Util.SDK_INT < 30 && list.size() > 1 && "OMX.qti.audio.decoder.flac".equals(list.get((int)0).name)) {
            list.add(list.remove(0));
        }
    }

    private static int av1LevelNumberToConst(int n2) {
        switch (n2) {
            default: {
                return -1;
            }
            case 23: {
                return 0x800000;
            }
            case 22: {
                return 0x400000;
            }
            case 21: {
                return 0x200000;
            }
            case 20: {
                return 0x100000;
            }
            case 19: {
                return 524288;
            }
            case 18: {
                return 262144;
            }
            case 17: {
                return 131072;
            }
            case 16: {
                return 65536;
            }
            case 15: {
                return 32768;
            }
            case 14: {
                return 16384;
            }
            case 13: {
                return 8192;
            }
            case 12: {
                return 4096;
            }
            case 11: {
                return 2048;
            }
            case 10: {
                return 1024;
            }
            case 9: {
                return 512;
            }
            case 8: {
                return 256;
            }
            case 7: {
                return 128;
            }
            case 6: {
                return 64;
            }
            case 5: {
                return 32;
            }
            case 4: {
                return 16;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    private static int avcLevelNumberToConst(int n2) {
        switch (n2) {
            default: {
                switch (n2) {
                    default: {
                        switch (n2) {
                            default: {
                                switch (n2) {
                                    default: {
                                        switch (n2) {
                                            default: {
                                                return -1;
                                            }
                                            case 52: {
                                                return 65536;
                                            }
                                            case 51: {
                                                return 32768;
                                            }
                                            case 50: 
                                        }
                                        return 16384;
                                    }
                                    case 42: {
                                        return 8192;
                                    }
                                    case 41: {
                                        return 4096;
                                    }
                                    case 40: 
                                }
                                return 2048;
                            }
                            case 32: {
                                return 1024;
                            }
                            case 31: {
                                return 512;
                            }
                            case 30: 
                        }
                        return 256;
                    }
                    case 22: {
                        return 128;
                    }
                    case 21: {
                        return 64;
                    }
                    case 20: 
                }
                return 32;
            }
            case 13: {
                return 16;
            }
            case 12: {
                return 8;
            }
            case 11: {
                return 4;
            }
            case 10: 
        }
        return 1;
    }

    private static int avcLevelToMaxFrameSize(int n2) {
        if (n2 != 1 && n2 != 2) {
            switch (n2) {
                default: {
                    return -1;
                }
                case 32768: 
                case 65536: {
                    return 0x900000;
                }
                case 16384: {
                    return 5652480;
                }
                case 8192: {
                    return 0x220000;
                }
                case 2048: 
                case 4096: {
                    return 0x200000;
                }
                case 1024: {
                    return 0x140000;
                }
                case 512: {
                    return 921600;
                }
                case 128: 
                case 256: {
                    return 414720;
                }
                case 64: {
                    return 202752;
                }
                case 8: 
                case 16: 
                case 32: 
            }
            return 101376;
        }
        return 25344;
    }

    private static int avcProfileNumberToConst(int n2) {
        if (n2 != 66) {
            if (n2 != 77) {
                if (n2 != 88) {
                    if (n2 != 100) {
                        if (n2 != 110) {
                            if (n2 != 122) {
                                if (n2 != 244) {
                                    return -1;
                                }
                                return 64;
                            }
                            return 32;
                        }
                        return 16;
                    }
                    return 8;
                }
                return 4;
            }
            return 2;
        }
        return 1;
    }

    public static void clearDecoderInfoCache() {
        synchronized (MediaCodecUtil.class) {
            decoderInfosCache.clear();
            return;
        }
    }

    private static Integer dolbyVisionStringToLevel(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = -1;
        int n3 = string2.hashCode();
        block0 : switch (n3) {
            default: {
                switch (n3) {
                    default: {
                        break;
                    }
                    case 1570: {
                        if (!string2.equals("13")) break block0;
                        n2 = 12;
                        break;
                    }
                    case 1569: {
                        if (!string2.equals("12")) break block0;
                        n2 = 11;
                        break;
                    }
                    case 1568: {
                        if (!string2.equals("11")) break block0;
                        n2 = 10;
                        break;
                    }
                    case 1567: {
                        if (!string2.equals("10")) break block0;
                        n2 = 9;
                        break;
                    }
                }
                break;
            }
            case 1545: {
                if (!string2.equals("09")) break;
                n2 = 8;
                break;
            }
            case 1544: {
                if (!string2.equals("08")) break;
                n2 = 7;
                break;
            }
            case 1543: {
                if (!string2.equals("07")) break;
                n2 = 6;
                break;
            }
            case 1542: {
                if (!string2.equals("06")) break;
                n2 = 5;
                break;
            }
            case 1541: {
                if (!string2.equals("05")) break;
                n2 = 4;
                break;
            }
            case 1540: {
                if (!string2.equals("04")) break;
                n2 = 3;
                break;
            }
            case 1539: {
                if (!string2.equals("03")) break;
                n2 = 2;
                break;
            }
            case 1538: {
                if (!string2.equals("02")) break;
                n2 = 1;
                break;
            }
            case 1537: {
                if (!string2.equals("01")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return null;
            }
            case 12: {
                return 4096;
            }
            case 11: {
                return 2048;
            }
            case 10: {
                return 1024;
            }
            case 9: {
                return 512;
            }
            case 8: {
                return 256;
            }
            case 7: {
                return 128;
            }
            case 6: {
                return 64;
            }
            case 5: {
                return 32;
            }
            case 4: {
                return 16;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    private static Integer dolbyVisionStringToProfile(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1545: {
                if (!string2.equals("09")) break;
                n2 = 9;
                break;
            }
            case 1544: {
                if (!string2.equals("08")) break;
                n2 = 8;
                break;
            }
            case 1543: {
                if (!string2.equals("07")) break;
                n2 = 7;
                break;
            }
            case 1542: {
                if (!string2.equals("06")) break;
                n2 = 6;
                break;
            }
            case 1541: {
                if (!string2.equals("05")) break;
                n2 = 5;
                break;
            }
            case 1540: {
                if (!string2.equals("04")) break;
                n2 = 4;
                break;
            }
            case 1539: {
                if (!string2.equals("03")) break;
                n2 = 3;
                break;
            }
            case 1538: {
                if (!string2.equals("02")) break;
                n2 = 2;
                break;
            }
            case 1537: {
                if (!string2.equals("01")) break;
                n2 = 1;
                break;
            }
            case 1536: {
                if (!string2.equals("00")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return null;
            }
            case 9: {
                return 512;
            }
            case 8: {
                return 256;
            }
            case 7: {
                return 128;
            }
            case 6: {
                return 64;
            }
            case 5: {
                return 32;
            }
            case 4: {
                return 16;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    private static Pair<Integer, Integer> getAacCodecProfileAndLevel(String string2, String[] object) {
        block4: {
            int n2;
            if (((String[])object).length != 3) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Ignoring malformed MP4A codec string: ");
                ((StringBuilder)object).append(string2);
                Log.w(TAG, ((StringBuilder)object).toString());
                return null;
            }
            if (!"audio/mp4a-latm".equals(MimeTypes.getMimeTypeFromMp4ObjectType((int)Integer.parseInt(object[1], 16))) || (n2 = MediaCodecUtil.mp4aAudioObjectTypeToProfile(Integer.parseInt((String)object[2]))) == -1) break block4;
            try {
                object = new Pair((Object)n2, (Object)0);
                return object;
            }
            catch (NumberFormatException numberFormatException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Ignoring malformed MP4A codec string: ");
                stringBuilder.append(string2);
                Log.w(TAG, stringBuilder.toString());
            }
        }
        return null;
    }

    private static Pair<Integer, Integer> getAv1ProfileAndLevel(String charSequence, String[] object, ColorInfo colorInfo) {
        int n2;
        int n3;
        int n4;
        int n5;
        block6: {
            if (((String[])object).length < 4) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Ignoring malformed AV1 codec string: ");
                ((StringBuilder)object).append((String)charSequence);
                Log.w(TAG, ((StringBuilder)object).toString());
                return null;
            }
            n5 = 1;
            try {
                n4 = Integer.parseInt(object[1]);
                n3 = Integer.parseInt(((String)object[2]).substring(0, 2));
                n2 = Integer.parseInt((String)object[3]);
                if (n4 == 0) break block6;
            }
            catch (NumberFormatException numberFormatException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Ignoring malformed AV1 codec string: ");
                stringBuilder.append((String)charSequence);
                Log.w(TAG, stringBuilder.toString());
                return null;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Unknown AV1 profile: ");
            ((StringBuilder)charSequence).append(n4);
            Log.w(TAG, ((StringBuilder)charSequence).toString());
            return null;
        }
        if (n2 != 8 && n2 != 10) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Unknown AV1 bit depth: ");
            ((StringBuilder)charSequence).append(n2);
            Log.w(TAG, ((StringBuilder)charSequence).toString());
            return null;
        }
        if (n2 != 8) {
            n5 = colorInfo != null && (colorInfo.hdrStaticInfo != null || colorInfo.colorTransfer == 7 || colorInfo.colorTransfer == 6) ? 4096 : 2;
        }
        if ((n4 = MediaCodecUtil.av1LevelNumberToConst(n3)) == -1) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Unknown AV1 level: ");
            ((StringBuilder)charSequence).append(n3);
            Log.w(TAG, ((StringBuilder)charSequence).toString());
            return null;
        }
        return new Pair((Object)n5, (Object)n4);
    }

    private static Pair<Integer, Integer> getAvcProfileAndLevel(String charSequence, String[] object) {
        block8: {
            int n2;
            int n3;
            block7: {
                if (((String[])object).length < 2) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Ignoring malformed AVC codec string: ");
                    ((StringBuilder)object).append((String)charSequence);
                    Log.w(TAG, ((StringBuilder)object).toString());
                    return null;
                }
                try {
                    if (object[1].length() == 6) {
                        n3 = Integer.parseInt(((String)object[1]).substring(0, 2), 16);
                        n2 = Integer.parseInt(((String)object[1]).substring(4), 16);
                        break block7;
                    }
                    if (((Object)object).length < 3) break block8;
                    n3 = Integer.parseInt((String)object[1]);
                    n2 = Integer.parseInt((String)object[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Ignoring malformed AVC codec string: ");
                    stringBuilder.append((String)charSequence);
                    Log.w(TAG, stringBuilder.toString());
                    return null;
                }
            }
            int n4 = MediaCodecUtil.avcProfileNumberToConst(n3);
            if (n4 == -1) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Unknown AVC profile: ");
                ((StringBuilder)charSequence).append(n3);
                Log.w(TAG, ((StringBuilder)charSequence).toString());
                return null;
            }
            n3 = MediaCodecUtil.avcLevelNumberToConst(n2);
            if (n3 == -1) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Unknown AVC level: ");
                ((StringBuilder)charSequence).append(n2);
                Log.w(TAG, ((StringBuilder)charSequence).toString());
                return null;
            }
            return new Pair((Object)n4, (Object)n3);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Ignoring malformed AVC codec string: ");
        ((StringBuilder)object).append((String)charSequence);
        Log.w(TAG, ((StringBuilder)object).toString());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String getCodecMimeType(android.media.MediaCodecInfo object2, String string2, String string3) {
        void var1_3;
        void var2_4;
        for (String string4 : object2.getSupportedTypes()) {
            if (!string4.equalsIgnoreCase((String)var2_4)) continue;
            return string4;
        }
        if (var2_4.equals("video/dolby-vision")) {
            if ("OMX.MS.HEVCDV.Decoder".equals(var1_3)) {
                return "video/hevcdv";
            }
            if ("OMX.RTK.video.decoder".equals(var1_3) || "OMX.realtek.video.decoder.tunneled".equals(var1_3)) {
                return "video/dv_hevc";
            }
        } else {
            if (var2_4.equals("audio/alac") && "OMX.lge.alac.decoder".equals(var1_3)) {
                return "audio/x-lg-alac";
            }
            if (var2_4.equals("audio/flac") && "OMX.lge.flac.decoder".equals(var1_3)) {
                return "audio/x-lg-flac";
            }
        }
        return null;
    }

    public static Pair<Integer, Integer> getCodecProfileAndLevel(Format format) {
        int n2;
        String[] stringArray;
        block18: {
            if (format.codecs == null) {
                return null;
            }
            stringArray = format.codecs.split("\\.");
            if ("video/dolby-vision".equals(format.sampleMimeType)) {
                return MediaCodecUtil.getDolbyVisionProfileAndLevel(format.codecs, stringArray);
            }
            n2 = 0;
            String string2 = stringArray[0];
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 3624515: {
                    if (!string2.equals(CODEC_ID_VP09)) break;
                    n2 = 2;
                    break block18;
                }
                case 3356560: {
                    if (!string2.equals(CODEC_ID_MP4A)) break;
                    n2 = 6;
                    break block18;
                }
                case 3214780: {
                    if (!string2.equals(CODEC_ID_HVC1)) break;
                    n2 = 4;
                    break block18;
                }
                case 3199032: {
                    if (!string2.equals(CODEC_ID_HEV1)) break;
                    n2 = 3;
                    break block18;
                }
                case 3006244: {
                    if (!string2.equals(CODEC_ID_AVC2)) break;
                    n2 = 1;
                    break block18;
                }
                case 3006243: {
                    if (!string2.equals(CODEC_ID_AVC1)) break;
                    break block18;
                }
                case 3004662: {
                    if (!string2.equals(CODEC_ID_AV01)) break;
                    n2 = 5;
                    break block18;
                }
            }
            n2 = -1;
        }
        switch (n2) {
            default: {
                return null;
            }
            case 6: {
                return MediaCodecUtil.getAacCodecProfileAndLevel(format.codecs, stringArray);
            }
            case 5: {
                return MediaCodecUtil.getAv1ProfileAndLevel(format.codecs, stringArray, format.colorInfo);
            }
            case 3: 
            case 4: {
                return MediaCodecUtil.getHevcProfileAndLevel(format.codecs, stringArray);
            }
            case 2: {
                return MediaCodecUtil.getVp9ProfileAndLevel(format.codecs, stringArray);
            }
            case 0: 
            case 1: 
        }
        return MediaCodecUtil.getAvcProfileAndLevel(format.codecs, stringArray);
    }

    public static MediaCodecInfo getDecoderInfo(String object, boolean bl, boolean bl2) throws DecoderQueryException {
        object = (object = MediaCodecUtil.getDecoderInfos((String)object, bl, bl2)).isEmpty() ? null : (MediaCodecInfo)object.get(0);
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<MediaCodecInfo> getDecoderInfos(String list, boolean bl, boolean bl2) throws DecoderQueryException {
        synchronized (MediaCodecUtil.class) {
            void var2_2;
            void var1_1;
            CodecKey codecKey = new CodecKey((String)((Object)list), (boolean)var1_1, (boolean)var2_2);
            Object object = decoderInfosCache.get(codecKey);
            if (object != null) {
                return object;
            }
            object = Util.SDK_INT >= 21 ? new MediaCodecListCompatV21((boolean)var1_1, (boolean)var2_2) : new MediaCodecListCompatV16();
            ArrayList<MediaCodecInfo> arrayList = MediaCodecUtil.getDecoderInfosInternal(codecKey, (MediaCodecListCompat)object);
            object = arrayList;
            if (var1_1 != false) {
                object = arrayList;
                if (arrayList.isEmpty()) {
                    object = arrayList;
                    if (21 <= Util.SDK_INT) {
                        object = arrayList;
                        if (Util.SDK_INT <= 23) {
                            object = new MediaCodecListCompatV16();
                            arrayList = MediaCodecUtil.getDecoderInfosInternal(codecKey, (MediaCodecListCompat)object);
                            object = arrayList;
                            if (!arrayList.isEmpty()) {
                                object = new StringBuilder();
                                ((StringBuilder)object).append("MediaCodecList API didn't list secure decoder for: ");
                                ((StringBuilder)object).append((String)((Object)list));
                                ((StringBuilder)object).append(". Assuming: ");
                                ((StringBuilder)object).append(arrayList.get((int)0).name);
                                Log.w(TAG, ((StringBuilder)object).toString());
                                object = arrayList;
                            }
                        }
                    }
                }
            }
            MediaCodecUtil.applyWorkarounds(list, object);
            list = Collections.unmodifiableList(object);
            decoderInfosCache.put(codecKey, list);
            return list;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList<MediaCodecInfo> getDecoderInfosInternal(CodecKey var0, MediaCodecListCompat var1_3) throws DecoderQueryException {
        block17: {
            block18: {
                try {
                    var2_4 = new ArrayList<MediaCodecInfo>();
                    var3_5 = var0.mimeType;
                    var4_6 = var1_3.getCodecCount();
                    var5_7 = var1_3.secureDecodersExplicit();
                    var6_8 = 0;
lbl7:
                    // 2 sources

                    while (true) {
                        var7_9 = var0;
                        if (var6_8 >= var4_6) return var2_4;
                        var8_11 = var1_3.getCodecInfoAt(var6_8);
                        if (!MediaCodecUtil.isAlias((android.media.MediaCodecInfo)var8_11) && MediaCodecUtil.isCodecUsableDecoder((android.media.MediaCodecInfo)var8_11, (String)(var9_12 = var8_11.getName()), var5_7, var3_5) && (var10_15 = MediaCodecUtil.getCodecMimeType((android.media.MediaCodecInfo)var8_11, (String)var9_12, var3_5)) != null) break;
                        break block17;
                        break;
                    }
                }
                catch (Exception var0_1) {
                    var0_2 = new DecoderQueryException(var0_1);
                    throw var0_2;
                }
                try {
                    var11_16 /* !! */  = var8_11.getCapabilitiesForType(var10_15);
                    var12_19 = var1_3.isFeatureSupported("tunneled-playback", var10_15, var11_16 /* !! */ );
                    var13_20 = var1_3.isFeatureRequired("tunneled-playback", var10_15, var11_16 /* !! */ );
                    if (!var7_9.tunneling && var13_20 || var7_9.tunneling && !var12_19) break block17;
                    var13_20 = var1_3.isFeatureSupported("secure-playback", var10_15, var11_16 /* !! */ );
                    var12_19 = var1_3.isFeatureRequired("secure-playback", var10_15, var11_16 /* !! */ );
                    if (!var7_9.secure && var12_19 || var7_9.secure && !var13_20) break block17;
                    var14_21 = MediaCodecUtil.isHardwareAccelerated((android.media.MediaCodecInfo)var8_11);
                    var15_22 = MediaCodecUtil.isSoftwareOnly((android.media.MediaCodecInfo)var8_11);
                    var12_19 = MediaCodecUtil.isVendor((android.media.MediaCodecInfo)var8_11);
                    if (!var5_7 || (var16_23 = var7_9.secure) != var13_20) {
                        if (var5_7) break block18;
                    }
                    ** GOTO lbl45
                }
                catch (Exception var11_18) {
                    var7_9 = var9_12;
                    var9_12 = var11_18;
                    ** GOTO lbl-1000
                }
                var16_23 = var7_9.secure;
                if (var16_23) break block18;
                {
                    catch (Exception var7_10) {
                        var11_16 /* !! */  = var9_12;
                        var9_12 = var7_10;
                        var7_9 = var11_16 /* !! */ ;
                        ** GOTO lbl-1000
                    }
lbl45:
                    // 2 sources

                    ** try [egrp 3[TRYBLOCK] [11 : 288->367)] { 
lbl46:
                    // 1 sources

                    var2_4.add(MediaCodecInfo.newInstance((String)var9_12, (String)var3_5, (String)var10_15, (MediaCodecInfo.CodecCapabilities)var11_16 /* !! */ , (boolean)var14_21, (boolean)var15_22, (boolean)var12_19, (boolean)false, (boolean)false));
                    break block17;
                }
lbl49:
                // 1 sources

                catch (Exception var11_17) {
                    var7_9 = var9_12;
                    var9_12 = var11_17;
                    ** GOTO lbl-1000
                }
            }
            var7_9 = var9_12;
            if (var5_7 || !var13_20) break block17;
            var8_11 = new StringBuilder();
            try {
                var8_11.append((String)var7_9);
                var8_11.append(".secure");
                var9_12 = var8_11.toString();
            }
            catch (Exception var9_14) {
                ** GOTO lbl-1000
            }
            try {
                var2_4.add(MediaCodecInfo.newInstance((String)var9_12, (String)var3_5, (String)var10_15, (MediaCodecInfo.CodecCapabilities)var11_16 /* !! */ , (boolean)var14_21, (boolean)var15_22, (boolean)var12_19, (boolean)false, (boolean)true));
                return var2_4;
            }
            catch (Exception var9_13) {}
lbl-1000:
            // 5 sources

            {
                var17_24 = Util.SDK_INT;
                if (var17_24 > 23 || var2_4.isEmpty()) ** GOTO lbl-1000
                var9_12 = new StringBuilder();
                var9_12.append("Skipping codec ");
                var9_12.append((String)var7_9);
                var9_12.append(" (failed to query capabilities)");
                Log.e("MediaCodecUtil", var9_12.toString());
            }
        }
        ++var6_8;
        ** while (true)
lbl-1000:
        // 1 sources

        {
            var0 = new StringBuilder();
            var0.append("Failed to query codec ");
            var0.append((String)var7_9);
            var0.append(" (");
            var0.append(var10_15);
            var0.append(")");
            Log.e("MediaCodecUtil", var0.toString());
            throw var9_12;
        }
    }

    public static List<MediaCodecInfo> getDecoderInfosSortedByFormatSupport(List<MediaCodecInfo> list, Format format) {
        list = new ArrayList<MediaCodecInfo>(list);
        MediaCodecUtil.sortByScore(list, new _$.Lambda.MediaCodecUtil.DM_fEJX1iZ51J6IPGblMN7NcC5Y(format));
        return list;
    }

    public static MediaCodecInfo getDecryptOnlyDecoderInfo() throws DecoderQueryException {
        return MediaCodecUtil.getDecoderInfo("audio/raw", false, false);
    }

    private static Pair<Integer, Integer> getDolbyVisionProfileAndLevel(String object, String[] object2) {
        if (((String[])object2).length < 3) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Ignoring malformed Dolby Vision codec string: ");
            ((StringBuilder)object2).append((String)object);
            Log.w(TAG, ((StringBuilder)object2).toString());
            return null;
        }
        Object object3 = PROFILE_PATTERN.matcher(object2[1]);
        if (!((Matcher)object3).matches()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Ignoring malformed Dolby Vision codec string: ");
            ((StringBuilder)object2).append((String)object);
            Log.w(TAG, ((StringBuilder)object2).toString());
            return null;
        }
        object = MediaCodecUtil.dolbyVisionStringToProfile((String)(object3 = ((Matcher)object3).group(1)));
        if (object == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown Dolby Vision profile string: ");
            ((StringBuilder)object).append((String)object3);
            Log.w(TAG, ((StringBuilder)object).toString());
            return null;
        }
        object3 = MediaCodecUtil.dolbyVisionStringToLevel((String)(object2 = object2[2]));
        if (object3 == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown Dolby Vision level string: ");
            ((StringBuilder)object).append((String)object2);
            Log.w(TAG, ((StringBuilder)object).toString());
            return null;
        }
        return new Pair(object, object3);
    }

    private static Pair<Integer, Integer> getHevcProfileAndLevel(String object, String[] object2) {
        block7: {
            int n2;
            block6: {
                if (((String[])object2).length < 4) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Ignoring malformed HEVC codec string: ");
                    ((StringBuilder)object2).append((String)object);
                    Log.w(TAG, ((StringBuilder)object2).toString());
                    return null;
                }
                Object object3 = PROFILE_PATTERN;
                n2 = 1;
                if (!((Matcher)(object3 = ((Pattern)object3).matcher((CharSequence)object2[1]))).matches()) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Ignoring malformed HEVC codec string: ");
                    ((StringBuilder)object2).append((String)object);
                    Log.w(TAG, ((StringBuilder)object2).toString());
                    return null;
                }
                object = ((Matcher)object3).group(1);
                if ("1".equals(object)) break block6;
                if (!"2".equals(object)) break block7;
                n2 = 2;
            }
            if ((object2 = MediaCodecUtil.hevcCodecStringToProfileLevel((String)(object = object2[3]))) == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Unknown HEVC level string: ");
                ((StringBuilder)object2).append((String)object);
                Log.w(TAG, ((StringBuilder)object2).toString());
                return null;
            }
            return new Pair((Object)n2, object2);
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Unknown HEVC profile string: ");
        ((StringBuilder)object2).append((String)object);
        Log.w(TAG, ((StringBuilder)object2).toString());
        return null;
    }

    private static Pair<Integer, Integer> getVp9ProfileAndLevel(String charSequence, String[] object) {
        int n2;
        int n3;
        if (((String[])object).length < 3) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Ignoring malformed VP9 codec string: ");
            ((StringBuilder)object).append((String)charSequence);
            Log.w(TAG, ((StringBuilder)object).toString());
            return null;
        }
        try {
            n3 = Integer.parseInt(object[1]);
            n2 = Integer.parseInt((String)object[2]);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Ignoring malformed VP9 codec string: ");
            stringBuilder.append((String)charSequence);
            Log.w(TAG, stringBuilder.toString());
            return null;
        }
        int n4 = MediaCodecUtil.vp9ProfileNumberToConst(n3);
        if (n4 == -1) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Unknown VP9 profile: ");
            ((StringBuilder)charSequence).append(n3);
            Log.w(TAG, ((StringBuilder)charSequence).toString());
            return null;
        }
        n3 = MediaCodecUtil.vp9LevelNumberToConst(n2);
        if (n3 == -1) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Unknown VP9 level: ");
            ((StringBuilder)charSequence).append(n2);
            Log.w(TAG, ((StringBuilder)charSequence).toString());
            return null;
        }
        return new Pair((Object)n4, (Object)n3);
    }

    private static Integer hevcCodecStringToProfileLevel(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2312995: {
                if (!string2.equals("L186")) break;
                n2 = 12;
                break;
            }
            case 2312992: {
                if (!string2.equals("L183")) break;
                n2 = 11;
                break;
            }
            case 2312989: {
                if (!string2.equals("L180")) break;
                n2 = 10;
                break;
            }
            case 2312902: {
                if (!string2.equals("L156")) break;
                n2 = 9;
                break;
            }
            case 2312899: {
                if (!string2.equals("L153")) break;
                n2 = 8;
                break;
            }
            case 2312896: {
                if (!string2.equals("L150")) break;
                n2 = 7;
                break;
            }
            case 2312806: {
                if (!string2.equals("L123")) break;
                n2 = 6;
                break;
            }
            case 2312803: {
                if (!string2.equals("L120")) break;
                n2 = 5;
                break;
            }
            case 2193831: {
                if (!string2.equals("H186")) break;
                n2 = 25;
                break;
            }
            case 2193828: {
                if (!string2.equals("H183")) break;
                n2 = 24;
                break;
            }
            case 2193825: {
                if (!string2.equals("H180")) break;
                n2 = 23;
                break;
            }
            case 2193738: {
                if (!string2.equals("H156")) break;
                n2 = 22;
                break;
            }
            case 2193735: {
                if (!string2.equals("H153")) break;
                n2 = 21;
                break;
            }
            case 2193732: {
                if (!string2.equals("H150")) break;
                n2 = 20;
                break;
            }
            case 2193642: {
                if (!string2.equals("H123")) break;
                n2 = 19;
                break;
            }
            case 2193639: {
                if (!string2.equals("H120")) break;
                n2 = 18;
                break;
            }
            case 74854: {
                if (!string2.equals("L93")) break;
                n2 = 4;
                break;
            }
            case 74851: {
                if (!string2.equals("L90")) break;
                n2 = 3;
                break;
            }
            case 74761: {
                if (!string2.equals("L63")) break;
                n2 = 2;
                break;
            }
            case 74758: {
                if (!string2.equals("L60")) break;
                n2 = 1;
                break;
            }
            case 74665: {
                if (!string2.equals("L30")) break;
                n2 = 0;
                break;
            }
            case 71010: {
                if (!string2.equals("H93")) break;
                n2 = 17;
                break;
            }
            case 71007: {
                if (!string2.equals("H90")) break;
                n2 = 16;
                break;
            }
            case 70917: {
                if (!string2.equals("H63")) break;
                n2 = 15;
                break;
            }
            case 70914: {
                if (!string2.equals("H60")) break;
                n2 = 14;
                break;
            }
            case 70821: {
                if (!string2.equals("H30")) break;
                n2 = 13;
            }
        }
        switch (n2) {
            default: {
                return null;
            }
            case 25: {
                return 0x2000000;
            }
            case 24: {
                return 0x800000;
            }
            case 23: {
                return 0x200000;
            }
            case 22: {
                return 524288;
            }
            case 21: {
                return 131072;
            }
            case 20: {
                return 32768;
            }
            case 19: {
                return 8192;
            }
            case 18: {
                return 2048;
            }
            case 17: {
                return 512;
            }
            case 16: {
                return 128;
            }
            case 15: {
                return 32;
            }
            case 14: {
                return 8;
            }
            case 13: {
                return 2;
            }
            case 12: {
                return 0x1000000;
            }
            case 11: {
                return 0x400000;
            }
            case 10: {
                return 0x100000;
            }
            case 9: {
                return 262144;
            }
            case 8: {
                return 65536;
            }
            case 7: {
                return 16384;
            }
            case 6: {
                return 4096;
            }
            case 5: {
                return 1024;
            }
            case 4: {
                return 256;
            }
            case 3: {
                return 64;
            }
            case 2: {
                return 16;
            }
            case 1: {
                return 4;
            }
            case 0: 
        }
        return 1;
    }

    private static boolean isAlias(android.media.MediaCodecInfo mediaCodecInfo) {
        boolean bl = Util.SDK_INT >= 29 && MediaCodecUtil.isAliasV29(mediaCodecInfo);
        return bl;
    }

    private static boolean isAliasV29(android.media.MediaCodecInfo mediaCodecInfo) {
        return mediaCodecInfo.isAlias();
    }

    private static boolean isCodecUsableDecoder(android.media.MediaCodecInfo mediaCodecInfo, String string2, boolean bl, String string3) {
        if (!(mediaCodecInfo.isEncoder() || !bl && string2.endsWith(".secure"))) {
            if (Util.SDK_INT < 21 && ("CIPAACDecoder".equals(string2) || "CIPMP3Decoder".equals(string2) || "CIPVorbisDecoder".equals(string2) || "CIPAMRNBDecoder".equals(string2) || "AACDecoder".equals(string2) || "MP3Decoder".equals(string2))) {
                return false;
            }
            if (Util.SDK_INT < 18 && "OMX.MTK.AUDIO.DECODER.AAC".equals(string2) && ("a70".equals(Util.DEVICE) || "Xiaomi".equals(Util.MANUFACTURER) && Util.DEVICE.startsWith("HM"))) {
                return false;
            }
            if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.mp3".equals(string2) && ("dlxu".equals(Util.DEVICE) || "protou".equals(Util.DEVICE) || "ville".equals(Util.DEVICE) || "villeplus".equals(Util.DEVICE) || "villec2".equals(Util.DEVICE) || Util.DEVICE.startsWith("gee") || "C6602".equals(Util.DEVICE) || "C6603".equals(Util.DEVICE) || "C6606".equals(Util.DEVICE) || "C6616".equals(Util.DEVICE) || "L36h".equals(Util.DEVICE) || "SO-02E".equals(Util.DEVICE))) {
                return false;
            }
            if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(string2) && ("C1504".equals(Util.DEVICE) || "C1505".equals(Util.DEVICE) || "C1604".equals(Util.DEVICE) || "C1605".equals(Util.DEVICE))) {
                return false;
            }
            if (Util.SDK_INT < 24 && ("OMX.SEC.aac.dec".equals(string2) || "OMX.Exynos.AAC.Decoder".equals(string2)) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("zeroflte") || Util.DEVICE.startsWith("zerolte") || Util.DEVICE.startsWith("zenlte") || "SC-05G".equals(Util.DEVICE) || "marinelteatt".equals(Util.DEVICE) || "404SC".equals(Util.DEVICE) || "SC-04G".equals(Util.DEVICE) || "SCV31".equals(Util.DEVICE))) {
                return false;
            }
            if (Util.SDK_INT <= 19 && "OMX.SEC.vp8.dec".equals(string2) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("d2") || Util.DEVICE.startsWith("serrano") || Util.DEVICE.startsWith("jflte") || Util.DEVICE.startsWith("santos") || Util.DEVICE.startsWith("t0"))) {
                return false;
            }
            if (Util.SDK_INT <= 19 && Util.DEVICE.startsWith("jflte") && "OMX.qcom.video.decoder.vp8".equals(string2)) {
                return false;
            }
            return !"audio/eac3-joc".equals(string3) || !"OMX.MTK.AUDIO.DECODER.DSPAC3".equals(string2);
        }
        return false;
    }

    private static boolean isHardwareAccelerated(android.media.MediaCodecInfo mediaCodecInfo) {
        if (Util.SDK_INT >= 29) {
            return MediaCodecUtil.isHardwareAcceleratedV29(mediaCodecInfo);
        }
        return MediaCodecUtil.isSoftwareOnly(mediaCodecInfo) ^ true;
    }

    private static boolean isHardwareAcceleratedV29(android.media.MediaCodecInfo mediaCodecInfo) {
        return mediaCodecInfo.isHardwareAccelerated();
    }

    private static boolean isSoftwareOnly(android.media.MediaCodecInfo object) {
        boolean bl;
        block6: {
            block5: {
                if (Util.SDK_INT >= 29) {
                    return MediaCodecUtil.isSoftwareOnlyV29((android.media.MediaCodecInfo)object);
                }
                object = Util.toLowerInvariant(object.getName());
                bl = ((String)object).startsWith("arc.");
                boolean bl2 = false;
                if (bl) {
                    return false;
                }
                if (((String)object).startsWith("omx.google.") || ((String)object).startsWith("omx.ffmpeg.") || ((String)object).startsWith("omx.sec.") && ((String)object).contains(".sw.") || ((String)object).equals("omx.qcom.video.decoder.hevcswvdec") || ((String)object).startsWith("c2.android.") || ((String)object).startsWith("c2.google.")) break block5;
                bl = bl2;
                if (((String)object).startsWith("omx.")) break block6;
                bl = bl2;
                if (((String)object).startsWith("c2.")) break block6;
            }
            bl = true;
        }
        return bl;
    }

    private static boolean isSoftwareOnlyV29(android.media.MediaCodecInfo mediaCodecInfo) {
        return mediaCodecInfo.isSoftwareOnly();
    }

    private static boolean isVendor(android.media.MediaCodecInfo object) {
        if (Util.SDK_INT >= 29) {
            return MediaCodecUtil.isVendorV29((android.media.MediaCodecInfo)object);
        }
        boolean bl = !((String)(object = Util.toLowerInvariant(object.getName()))).startsWith("omx.google.") && !((String)object).startsWith("c2.android.") && !((String)object).startsWith("c2.google.");
        return bl;
    }

    private static boolean isVendorV29(android.media.MediaCodecInfo mediaCodecInfo) {
        return mediaCodecInfo.isVendor();
    }

    static /* synthetic */ int lambda$applyWorkarounds$1(MediaCodecInfo object) {
        object = ((MediaCodecInfo)object).name;
        if (!((String)object).startsWith("OMX.google") && !((String)object).startsWith("c2.android")) {
            if (Util.SDK_INT < 26 && ((String)object).equals("OMX.MTK.AUDIO.DECODER.RAW")) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    static /* synthetic */ int lambda$applyWorkarounds$2(MediaCodecInfo mediaCodecInfo) {
        return mediaCodecInfo.name.startsWith("OMX.google") ? 1 : 0;
    }

    static /* synthetic */ int lambda$getDecoderInfosSortedByFormatSupport$0(Format format, MediaCodecInfo mediaCodecInfo) {
        try {
            int n2 = mediaCodecInfo.isFormatSupported(format);
            return n2;
        }
        catch (DecoderQueryException decoderQueryException) {
            return -1;
        }
    }

    static /* synthetic */ int lambda$sortByScore$3(ScoreProvider scoreProvider, Object object, Object object2) {
        return scoreProvider.getScore(object2) - scoreProvider.getScore(object);
    }

    public static int maxH264DecodableFrameSize() throws DecoderQueryException {
        if (maxH264DecodableFrameSize == -1) {
            int n2 = 0;
            MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = MediaCodecUtil.getDecoderInfo("video/avc", false, false);
            if (codecProfileLevelArray != null) {
                int n3;
                codecProfileLevelArray = codecProfileLevelArray.getProfileLevels();
                int n4 = codecProfileLevelArray.length;
                n2 = 0;
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(codecProfileLevelArray[n3].level), n2);
                }
                n3 = Util.SDK_INT >= 21 ? 345600 : 172800;
                n2 = Math.max(n2, n3);
            }
            maxH264DecodableFrameSize = n2;
        }
        return maxH264DecodableFrameSize;
    }

    private static int mp4aAudioObjectTypeToProfile(int n2) {
        int n3 = 17;
        if (n2 != 17) {
            n3 = 20;
            if (n2 != 20) {
                n3 = 23;
                if (n2 != 23) {
                    n3 = 29;
                    if (n2 != 29) {
                        n3 = 39;
                        if (n2 != 39) {
                            n3 = 42;
                            if (n2 != 42) {
                                switch (n2) {
                                    default: {
                                        return -1;
                                    }
                                    case 6: {
                                        return 6;
                                    }
                                    case 5: {
                                        return 5;
                                    }
                                    case 4: {
                                        return 4;
                                    }
                                    case 3: {
                                        return 3;
                                    }
                                    case 2: {
                                        return 2;
                                    }
                                    case 1: 
                                }
                                return 1;
                            }
                        }
                    }
                }
            }
        }
        return n3;
    }

    private static <T> void sortByScore(List<T> list, ScoreProvider<T> scoreProvider) {
        Collections.sort(list, new _$.Lambda.MediaCodecUtil.w6BjIcrs1D5BowK8PBZdBwa6Apk(scoreProvider));
    }

    private static int vp9LevelNumberToConst(int n2) {
        if (n2 != 10) {
            if (n2 != 11) {
                if (n2 != 20) {
                    if (n2 != 21) {
                        if (n2 != 30) {
                            if (n2 != 31) {
                                if (n2 != 40) {
                                    if (n2 != 41) {
                                        if (n2 != 50) {
                                            if (n2 != 51) {
                                                switch (n2) {
                                                    default: {
                                                        return -1;
                                                    }
                                                    case 62: {
                                                        return 8192;
                                                    }
                                                    case 61: {
                                                        return 4096;
                                                    }
                                                    case 60: 
                                                }
                                                return 2048;
                                            }
                                            return 512;
                                        }
                                        return 256;
                                    }
                                    return 128;
                                }
                                return 64;
                            }
                            return 32;
                        }
                        return 16;
                    }
                    return 8;
                }
                return 4;
            }
            return 2;
        }
        return 1;
    }

    private static int vp9ProfileNumberToConst(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        return -1;
                    }
                    return 8;
                }
                return 4;
            }
            return 2;
        }
        return 1;
    }

    public static void warmDecoderInfoCache(String string2, boolean bl, boolean bl2) {
        try {
            MediaCodecUtil.getDecoderInfos(string2, bl, bl2);
        }
        catch (DecoderQueryException decoderQueryException) {
            Log.e(TAG, "Codec warming failed", decoderQueryException);
        }
    }

    private static final class CodecKey {
        public final String mimeType;
        public final boolean secure;
        public final boolean tunneling;

        public CodecKey(String string2, boolean bl, boolean bl2) {
            this.mimeType = string2;
            this.secure = bl;
            this.tunneling = bl2;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && object.getClass() == CodecKey.class) {
                object = (CodecKey)object;
                if (!TextUtils.equals((CharSequence)this.mimeType, (CharSequence)((CodecKey)object).mimeType) || this.secure != ((CodecKey)object).secure || this.tunneling != ((CodecKey)object).tunneling) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            int n2 = this.mimeType.hashCode();
            boolean bl = this.secure;
            int n3 = 1231;
            int n4 = bl ? 1231 : 1237;
            if (!this.tunneling) {
                n3 = 1237;
            }
            return ((n2 + 31) * 31 + n4) * 31 + n3;
        }
    }

    public static class DecoderQueryException
    extends Exception {
        private DecoderQueryException(Throwable throwable) {
            super("Failed to query underlying media codecs", throwable);
        }
    }

    private static interface MediaCodecListCompat {
        public int getCodecCount();

        public android.media.MediaCodecInfo getCodecInfoAt(int var1);

        public boolean isFeatureRequired(String var1, String var2, MediaCodecInfo.CodecCapabilities var3);

        public boolean isFeatureSupported(String var1, String var2, MediaCodecInfo.CodecCapabilities var3);

        public boolean secureDecodersExplicit();
    }

    private static final class MediaCodecListCompatV16
    implements MediaCodecListCompat {
        private MediaCodecListCompatV16() {
        }

        @Override
        public int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int n2) {
            return MediaCodecList.getCodecInfoAt((int)n2);
        }

        @Override
        public boolean isFeatureRequired(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return false;
        }

        @Override
        public boolean isFeatureSupported(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            boolean bl = "secure-playback".equals(string2) && "video/avc".equals(string3);
            return bl;
        }

        @Override
        public boolean secureDecodersExplicit() {
            return false;
        }
    }

    private static final class MediaCodecListCompatV21
    implements MediaCodecListCompat {
        private final int codecKind;
        private android.media.MediaCodecInfo[] mediaCodecInfos;

        public MediaCodecListCompatV21(boolean bl, boolean bl2) {
            int n2 = !bl && !bl2 ? 0 : 1;
            this.codecKind = n2;
        }

        @EnsuresNonNull(value={"mediaCodecInfos"})
        private void ensureMediaCodecInfosInitialized() {
            if (this.mediaCodecInfos == null) {
                this.mediaCodecInfos = new MediaCodecList(this.codecKind).getCodecInfos();
            }
        }

        @Override
        public int getCodecCount() {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos.length;
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int n2) {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos[n2];
        }

        @Override
        public boolean isFeatureRequired(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return codecCapabilities.isFeatureRequired(string2);
        }

        @Override
        public boolean isFeatureSupported(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities) {
            return codecCapabilities.isFeatureSupported(string2);
        }

        @Override
        public boolean secureDecodersExplicit() {
            return true;
        }
    }

    private static interface ScoreProvider<T> {
        public int getScore(T var1);
    }
}

