/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.wav;

import android.util.Pair;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.wav.WavHeader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

final class WavHeaderReader {
    private static final String TAG = "WavHeaderReader";

    private WavHeaderReader() {
    }

    public static WavHeader peek(ExtractorInput object) throws IOException {
        Assertions.checkNotNull(object);
        ParsableByteArray parsableByteArray = new ParsableByteArray(16);
        if (ChunkHeader.peek((ExtractorInput)object, (ParsableByteArray)parsableByteArray).id != 1380533830) {
            return null;
        }
        object.peekFully(parsableByteArray.getData(), 0, 4);
        parsableByteArray.setPosition(0);
        int n2 = parsableByteArray.readInt();
        if (n2 != 1463899717) {
            object = new StringBuilder();
            object.append("Unsupported RIFF format: ");
            object.append(n2);
            Log.e(TAG, object.toString());
            return null;
        }
        Object object2 = ChunkHeader.peek(object, parsableByteArray);
        while (((ChunkHeader)object2).id != 1718449184) {
            object.advancePeekPosition((int)((ChunkHeader)object2).size);
            object2 = ChunkHeader.peek(object, parsableByteArray);
        }
        boolean bl = ((ChunkHeader)object2).size >= 16L;
        Assertions.checkState(bl);
        object.peekFully(parsableByteArray.getData(), 0, 16);
        parsableByteArray.setPosition(0);
        int n3 = parsableByteArray.readLittleEndianUnsignedShort();
        int n4 = parsableByteArray.readLittleEndianUnsignedShort();
        int n5 = parsableByteArray.readLittleEndianUnsignedIntToInt();
        int n6 = parsableByteArray.readLittleEndianUnsignedIntToInt();
        n2 = parsableByteArray.readLittleEndianUnsignedShort();
        int n7 = parsableByteArray.readLittleEndianUnsignedShort();
        int n8 = (int)((ChunkHeader)object2).size - 16;
        if (n8 > 0) {
            object2 = new byte[n8];
            object.peekFully((byte[])object2, 0, n8);
            object = object2;
        } else {
            object = Util.EMPTY_BYTE_ARRAY;
        }
        return new WavHeader(n3, n4, n5, n6, n2, n7, (byte[])object);
    }

    public static Pair<Long, Long> skipToData(ExtractorInput object) throws IOException {
        long l2;
        Assertions.checkNotNull(object);
        object.resetPeekPosition();
        ParsableByteArray parsableByteArray = new ParsableByteArray(8);
        ChunkHeader chunkHeader = ChunkHeader.peek((ExtractorInput)object, parsableByteArray);
        while (chunkHeader.id != 1684108385) {
            if (chunkHeader.id != 1380533830 && chunkHeader.id != 1718449184) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Ignoring unknown WAV chunk: ");
                stringBuilder.append(chunkHeader.id);
                Log.w(TAG, stringBuilder.toString());
            }
            l2 = chunkHeader.size + 8L;
            if (chunkHeader.id == 1380533830) {
                l2 = 12L;
            }
            if (l2 <= Integer.MAX_VALUE) {
                object.skipFully((int)l2);
                chunkHeader = ChunkHeader.peek((ExtractorInput)object, parsableByteArray);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Chunk is too large (~2GB+) to skip; id: ");
            ((StringBuilder)object).append(chunkHeader.id);
            throw new ParserException(((StringBuilder)object).toString());
        }
        object.skipFully(8);
        long l3 = object.getPosition();
        long l4 = chunkHeader.size + l3;
        long l5 = object.getLength();
        l2 = l4;
        if (l5 != -1L) {
            l2 = l4;
            if (l4 > l5) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Data exceeds input length: ");
                ((StringBuilder)object).append(l4);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(l5);
                Log.w(TAG, ((StringBuilder)object).toString());
                l2 = l5;
            }
        }
        return Pair.create((Object)l3, (Object)l2);
    }

    private static final class ChunkHeader {
        public static final int SIZE_IN_BYTES = 8;
        public final int id;
        public final long size;

        private ChunkHeader(int n2, long l2) {
            this.id = n2;
            this.size = l2;
        }

        public static ChunkHeader peek(ExtractorInput extractorInput, ParsableByteArray parsableByteArray) throws IOException {
            extractorInput.peekFully(parsableByteArray.getData(), 0, 8);
            parsableByteArray.setPosition(0);
            return new ChunkHeader(parsableByteArray.readInt(), parsableByteArray.readLittleEndianUnsignedInt());
        }
    }
}

