/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.wav;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.WavUtil;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.wav.WavHeader;
import com.google.android.exoplayer2.extractor.wav.WavHeaderReader;
import com.google.android.exoplayer2.extractor.wav.WavSeekMap;
import com.google.android.exoplayer2.extractor.wav._$$Lambda$WavExtractor$5r6M_S0QCNNj_Xavzq9WwuFHep0;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class WavExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = _$$Lambda$WavExtractor$5r6M_S0QCNNj_Xavzq9WwuFHep0.INSTANCE;
    private static final int TARGET_SAMPLES_PER_SECOND = 10;
    private long dataEndPosition = -1L;
    private int dataStartPosition = -1;
    private ExtractorOutput extractorOutput;
    private OutputWriter outputWriter;
    private TrackOutput trackOutput;

    @EnsuresNonNull(value={"extractorOutput", "trackOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull(this.trackOutput);
        Util.castNonNull(this.extractorOutput);
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new WavExtractor()};
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
        this.trackOutput = extractorOutput.track(0, 1);
        extractorOutput.endTracks();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(ExtractorInput object, PositionHolder wavHeader) throws IOException {
        int n2;
        this.assertInitialized();
        if (this.outputWriter == null) {
            wavHeader = WavHeaderReader.peek((ExtractorInput)object);
            if (wavHeader == null) throw new ParserException("Unsupported or unrecognized wav header.");
            if (wavHeader.formatType == 17) {
                this.outputWriter = new ImaAdPcmOutputWriter(this.extractorOutput, this.trackOutput, wavHeader);
            } else if (wavHeader.formatType == 6) {
                this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, wavHeader, "audio/g711-alaw", -1);
            } else if (wavHeader.formatType == 7) {
                this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, wavHeader, "audio/g711-mlaw", -1);
            } else {
                n2 = WavUtil.getPcmEncodingForType((int)wavHeader.formatType, (int)wavHeader.bitsPerSample);
                if (n2 != 0) {
                    this.outputWriter = new PassthroughOutputWriter(this.extractorOutput, this.trackOutput, wavHeader, "audio/raw", n2);
                } else {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unsupported WAV format type: ");
                    ((StringBuilder)object).append(wavHeader.formatType);
                    throw new ParserException(((StringBuilder)object).toString());
                }
            }
        }
        if (this.dataStartPosition == -1) {
            wavHeader = WavHeaderReader.skipToData((ExtractorInput)object);
            this.dataStartPosition = ((Long)wavHeader.first).intValue();
            this.dataEndPosition = (Long)wavHeader.second;
            this.outputWriter.init(this.dataStartPosition, this.dataEndPosition);
        } else if (object.getPosition() == 0L) {
            object.skipFully(this.dataStartPosition);
        }
        long l2 = this.dataEndPosition;
        n2 = 0;
        boolean bl = l2 != -1L;
        Assertions.checkState(bl);
        l2 = this.dataEndPosition;
        long l3 = object.getPosition();
        if (!this.outputWriter.sampleData((ExtractorInput)object, l2 - l3)) return n2;
        return -1;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        OutputWriter outputWriter = this.outputWriter;
        if (outputWriter != null) {
            outputWriter.reset(l3);
        }
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        boolean bl = WavHeaderReader.peek(extractorInput) != null;
        return bl;
    }

    private static final class ImaAdPcmOutputWriter
    implements OutputWriter {
        private static final int[] INDEX_TABLE = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
        private static final int[] STEP_TABLE = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
        private final ParsableByteArray decodedData;
        private final ExtractorOutput extractorOutput;
        private final Format format;
        private final int framesPerBlock;
        private final WavHeader header;
        private final byte[] inputData;
        private long outputFrameCount;
        private int pendingInputBytes;
        private int pendingOutputBytes;
        private long startTimeUs;
        private final int targetSampleSizeFrames;
        private final TrackOutput trackOutput;

        public ImaAdPcmOutputWriter(ExtractorOutput object, TrackOutput trackOutput, WavHeader wavHeader) throws ParserException {
            this.extractorOutput = object;
            this.trackOutput = trackOutput;
            this.header = wavHeader;
            this.targetSampleSizeFrames = Math.max(1, wavHeader.frameRateHz / 10);
            object = new ParsableByteArray(wavHeader.extraData);
            object.readLittleEndianUnsignedShort();
            this.framesPerBlock = object.readLittleEndianUnsignedShort();
            int n2 = wavHeader.numChannels;
            int n3 = (wavHeader.blockSize - n2 * 4) * 8 / (wavHeader.bitsPerSample * n2) + 1;
            int n4 = this.framesPerBlock;
            if (n4 == n3) {
                n4 = Util.ceilDivide(this.targetSampleSizeFrames, n4);
                this.inputData = new byte[wavHeader.blockSize * n4];
                this.decodedData = new ParsableByteArray(n4 * ImaAdPcmOutputWriter.numOutputFramesToBytes(this.framesPerBlock, n2));
                n4 = wavHeader.frameRateHz * wavHeader.blockSize * 8 / this.framesPerBlock;
                this.format = new Format.Builder().setSampleMimeType("audio/raw").setAverageBitrate(n4).setPeakBitrate(n4).setMaxInputSize(ImaAdPcmOutputWriter.numOutputFramesToBytes(this.targetSampleSizeFrames, n2)).setChannelCount(wavHeader.numChannels).setSampleRate(wavHeader.frameRateHz).setPcmEncoding(2).build();
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Expected frames per block: ");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append("; got: ");
            ((StringBuilder)object).append(this.framesPerBlock);
            throw new ParserException(((StringBuilder)object).toString());
        }

        private void decode(byte[] byArray, int n2, ParsableByteArray parsableByteArray) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < this.header.numChannels; ++i3) {
                    this.decodeBlockForChannel(byArray, i2, i3, parsableByteArray.getData());
                }
            }
            n2 = this.numOutputFramesToBytes(this.framesPerBlock * n2);
            parsableByteArray.setPosition(0);
            parsableByteArray.setLimit(n2);
        }

        private void decodeBlockForChannel(byte[] byArray, int n2, int n3, byte[] byArray2) {
            int n4 = this.header.blockSize;
            int n5 = this.header.numChannels;
            int n6 = n2 * n4 + n3 * 4;
            int n7 = n4 / n5;
            n4 = (short)((byArray[n6 + 1] & 0xFF) << 8 | byArray[n6] & 0xFF);
            int n8 = Math.min(byArray[n6 + 2] & 0xFF, 88);
            int n9 = STEP_TABLE[n8];
            n3 = (n2 * this.framesPerBlock * n5 + n3) * 2;
            byArray2[n3] = (byte)(n4 & 0xFF);
            byArray2[n3 + 1] = (byte)(n4 >> 8);
            for (n2 = 0; n2 < (n7 - 4) * 2; ++n2) {
                int n10;
                int n11 = byArray[n2 / 8 * n5 * 4 + (n5 * 4 + n6) + n2 / 2 % 4] & 0xFF;
                n11 = n2 % 2 == 0 ? (n11 &= 0xF) : (n11 >>= 4);
                n9 = n10 = ((n11 & 7) * 2 + 1) * n9 >> 3;
                if ((n11 & 8) != 0) {
                    n9 = -n10;
                }
                n4 = Util.constrainValue(n4 + n9, Short.MIN_VALUE, Short.MAX_VALUE);
                byArray2[n3 += n5 * 2] = (byte)(n4 & 0xFF);
                byArray2[n3 + 1] = (byte)(n4 >> 8);
                n8 = Util.constrainValue(n8 + INDEX_TABLE[n11], 0, STEP_TABLE.length - 1);
                n9 = STEP_TABLE[n8];
            }
        }

        private int numOutputBytesToFrames(int n2) {
            return n2 / (this.header.numChannels * 2);
        }

        private int numOutputFramesToBytes(int n2) {
            return ImaAdPcmOutputWriter.numOutputFramesToBytes(n2, this.header.numChannels);
        }

        private static int numOutputFramesToBytes(int n2, int n3) {
            return n2 * 2 * n3;
        }

        private void writeSampleMetadata(int n2) {
            long l2 = this.startTimeUs;
            long l3 = Util.scaleLargeTimestamp(this.outputFrameCount, 1000000L, this.header.frameRateHz);
            int n3 = this.numOutputFramesToBytes(n2);
            int n4 = this.pendingOutputBytes;
            this.trackOutput.sampleMetadata(l2 + l3, 1, n3, n4 - n3, null);
            this.outputFrameCount += (long)n2;
            this.pendingOutputBytes -= n3;
        }

        @Override
        public void init(int n2, long l2) {
            this.extractorOutput.seekMap((SeekMap)new WavSeekMap(this.header, this.framesPerBlock, (long)n2, l2));
            this.trackOutput.format(this.format);
        }

        @Override
        public void reset(long l2) {
            this.pendingInputBytes = 0;
            this.startTimeUs = l2;
            this.pendingOutputBytes = 0;
            this.outputFrameCount = 0L;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean sampleData(ExtractorInput var1_1, long var2_2) throws IOException {
            var4_3 = Util.ceilDivide(this.targetSampleSizeFrames - this.numOutputBytesToFrames(this.pendingOutputBytes), this.framesPerBlock) * this.header.blockSize;
            if (var2_2 == 0L) {
                while (true) {
                    var5_4 = true;
                    break;
                }
            } else {
                var5_4 = false;
            }
            while (!var5_4 && (var6_5 = this.pendingInputBytes) < var4_3) {
                var6_5 = (int)Math.min((long)(var4_3 - var6_5), var2_2);
                if ((var6_5 = var1_1.read(this.inputData, this.pendingInputBytes, var6_5)) == -1) ** continue;
                this.pendingInputBytes += var6_5;
            }
            var4_3 = this.pendingInputBytes / this.header.blockSize;
            if (var4_3 > 0) {
                this.decode(this.inputData, var4_3, this.decodedData);
                this.pendingInputBytes -= var4_3 * this.header.blockSize;
                var4_3 = this.decodedData.limit();
                this.trackOutput.sampleData(this.decodedData, var4_3);
                this.pendingOutputBytes += var4_3;
                var4_3 = this.numOutputBytesToFrames(this.pendingOutputBytes);
                var6_5 = this.targetSampleSizeFrames;
                if (var4_3 >= var6_5) {
                    this.writeSampleMetadata(var6_5);
                }
            }
            if (var5_4 && (var4_3 = this.numOutputBytesToFrames(this.pendingOutputBytes)) > 0) {
                this.writeSampleMetadata(var4_3);
            }
            return var5_4;
        }
    }

    private static interface OutputWriter {
        public void init(int var1, long var2) throws ParserException;

        public void reset(long var1);

        public boolean sampleData(ExtractorInput var1, long var2) throws IOException;
    }

    private static final class PassthroughOutputWriter
    implements OutputWriter {
        private final ExtractorOutput extractorOutput;
        private final Format format;
        private final WavHeader header;
        private long outputFrameCount;
        private int pendingOutputBytes;
        private long startTimeUs;
        private final int targetSampleSizeBytes;
        private final TrackOutput trackOutput;

        public PassthroughOutputWriter(ExtractorOutput object, TrackOutput trackOutput, WavHeader wavHeader, String string2, int n2) throws ParserException {
            this.extractorOutput = object;
            this.trackOutput = trackOutput;
            this.header = wavHeader;
            int n3 = wavHeader.numChannels * wavHeader.bitsPerSample / 8;
            if (wavHeader.blockSize == n3) {
                int n4 = wavHeader.frameRateHz * n3 * 8;
                this.targetSampleSizeBytes = Math.max(n3, wavHeader.frameRateHz * n3 / 10);
                this.format = new Format.Builder().setSampleMimeType(string2).setAverageBitrate(n4).setPeakBitrate(n4).setMaxInputSize(this.targetSampleSizeBytes).setChannelCount(wavHeader.numChannels).setSampleRate(wavHeader.frameRateHz).setPcmEncoding(n2).build();
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Expected block size: ");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append("; got: ");
            ((StringBuilder)object).append(wavHeader.blockSize);
            throw new ParserException(((StringBuilder)object).toString());
        }

        @Override
        public void init(int n2, long l2) {
            this.extractorOutput.seekMap((SeekMap)new WavSeekMap(this.header, 1, (long)n2, l2));
            this.trackOutput.format(this.format);
        }

        @Override
        public void reset(long l2) {
            this.startTimeUs = l2;
            this.pendingOutputBytes = 0;
            this.outputFrameCount = 0L;
        }

        @Override
        public boolean sampleData(ExtractorInput extractorInput, long l2) throws IOException {
            int n2;
            int n3;
            boolean bl;
            while (true) {
                bl = true;
                if (l2 <= 0L || (n3 = this.pendingOutputBytes) >= (n2 = this.targetSampleSizeBytes)) break;
                n3 = (int)Math.min((long)(n2 - n3), l2);
                if ((n3 = this.trackOutput.sampleData((DataReader)extractorInput, n3, true)) == -1) {
                    l2 = 0L;
                    continue;
                }
                this.pendingOutputBytes += n3;
                l2 -= (long)n3;
            }
            n2 = this.header.blockSize;
            n3 = this.pendingOutputBytes / n2;
            if (n3 > 0) {
                long l3 = this.startTimeUs;
                long l4 = Util.scaleLargeTimestamp(this.outputFrameCount, 1000000L, this.header.frameRateHz);
                n2 = n3 * n2;
                int n4 = this.pendingOutputBytes - n2;
                this.trackOutput.sampleMetadata(l3 + l4, 1, n2, n4, null);
                this.outputFrameCount += (long)n3;
                this.pendingOutputBytes = n4;
            }
            if (l2 > 0L) {
                bl = false;
            }
            return bl;
        }
    }
}

