/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

public interface TsPayloadReader {
    public static final int FLAG_DATA_ALIGNMENT_INDICATOR = 4;
    public static final int FLAG_PAYLOAD_UNIT_START_INDICATOR = 1;
    public static final int FLAG_RANDOM_ACCESS_INDICATOR = 2;

    public void consume(ParsableByteArray var1, int var2) throws ParserException;

    public void init(TimestampAdjuster var1, ExtractorOutput var2, TrackIdGenerator var3);

    public void seek();

    public static final class DvbSubtitleInfo {
        public final byte[] initializationData;
        public final String language;
        public final int type;

        public DvbSubtitleInfo(String string2, int n2, byte[] byArray) {
            this.language = string2;
            this.type = n2;
            this.initializationData = byArray;
        }
    }

    public static final class EsInfo {
        public final byte[] descriptorBytes;
        public final List<DvbSubtitleInfo> dvbSubtitleInfos;
        public final String language;
        public final int streamType;

        public EsInfo(int n2, String list, List<DvbSubtitleInfo> list2, byte[] byArray) {
            this.streamType = n2;
            this.language = list;
            list = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
            this.dvbSubtitleInfos = list;
            this.descriptorBytes = byArray;
        }
    }

    public static interface Factory {
        public SparseArray<TsPayloadReader> createInitialPayloadReaders();

        public TsPayloadReader createPayloadReader(int var1, EsInfo var2);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    public static final class TrackIdGenerator {
        private static final int ID_UNSET = Integer.MIN_VALUE;
        private final int firstTrackId;
        private String formatId;
        private final String formatIdPrefix;
        private int trackId;
        private final int trackIdIncrement;

        public TrackIdGenerator(int n2, int n3) {
            this(Integer.MIN_VALUE, n2, n3);
        }

        public TrackIdGenerator(int n2, int n3, int n4) {
            CharSequence charSequence;
            if (n2 != Integer.MIN_VALUE) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append("/");
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = "";
            }
            this.formatIdPrefix = charSequence;
            this.firstTrackId = n3;
            this.trackIdIncrement = n4;
            this.trackId = Integer.MIN_VALUE;
            this.formatId = "";
        }

        private void maybeThrowUninitializedError() {
            if (this.trackId != Integer.MIN_VALUE) {
                return;
            }
            throw new IllegalStateException("generateNewId() must be called before retrieving ids.");
        }

        public void generateNewId() {
            int n2 = this.trackId;
            n2 = n2 == Integer.MIN_VALUE ? this.firstTrackId : (n2 += this.trackIdIncrement);
            this.trackId = n2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.formatIdPrefix);
            stringBuilder.append(this.trackId);
            this.formatId = stringBuilder.toString();
        }

        public String getFormatId() {
            this.maybeThrowUninitializedError();
            return this.formatId;
        }

        public int getTrackId() {
            this.maybeThrowUninitializedError();
            return this.trackId;
        }
    }
}

