/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.google.android.exoplayer2.extractor.ts.SectionPayloadReader;
import com.google.android.exoplayer2.extractor.ts.SectionReader;
import com.google.android.exoplayer2.extractor.ts.TsBinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ts.TsDurationReader;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.extractor.ts.TsUtil;
import com.google.android.exoplayer2.extractor.ts._$;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TsExtractor
implements Extractor {
    private static final long AC3_FORMAT_IDENTIFIER = 1094921523L;
    private static final long AC4_FORMAT_IDENTIFIER = 1094921524L;
    private static final int BUFFER_SIZE = 9400;
    public static final int DEFAULT_TIMESTAMP_SEARCH_BYTES = 112800;
    private static final long E_AC3_FORMAT_IDENTIFIER = 1161904947L;
    public static final ExtractorsFactory FACTORY = _$.Lambda.TsExtractor.f_UE6PC86cqq4V_qVoFQnPhfFZ8.INSTANCE;
    private static final long HEVC_FORMAT_IDENTIFIER = 1212503619L;
    private static final int MAX_PID_PLUS_ONE = 8192;
    public static final int MODE_HLS = 2;
    public static final int MODE_MULTI_PMT = 0;
    public static final int MODE_SINGLE_PMT = 1;
    private static final int SNIFF_TS_PACKET_COUNT = 5;
    public static final int TS_PACKET_SIZE = 188;
    private static final int TS_PAT_PID = 0;
    public static final int TS_STREAM_TYPE_AAC_ADTS = 15;
    public static final int TS_STREAM_TYPE_AAC_LATM = 17;
    public static final int TS_STREAM_TYPE_AC3 = 129;
    public static final int TS_STREAM_TYPE_AC4 = 172;
    public static final int TS_STREAM_TYPE_AIT = 257;
    public static final int TS_STREAM_TYPE_DTS = 138;
    public static final int TS_STREAM_TYPE_DVBSUBS = 89;
    public static final int TS_STREAM_TYPE_E_AC3 = 135;
    public static final int TS_STREAM_TYPE_H262 = 2;
    public static final int TS_STREAM_TYPE_H263 = 16;
    public static final int TS_STREAM_TYPE_H264 = 27;
    public static final int TS_STREAM_TYPE_H265 = 36;
    public static final int TS_STREAM_TYPE_HDMV_DTS = 130;
    public static final int TS_STREAM_TYPE_ID3 = 21;
    public static final int TS_STREAM_TYPE_MPA = 3;
    public static final int TS_STREAM_TYPE_MPA_LSF = 4;
    public static final int TS_STREAM_TYPE_SPLICE_INFO = 134;
    public static final int TS_SYNC_BYTE = 71;
    private int bytesSinceLastSync;
    private final SparseIntArray continuityCounters;
    private final TsDurationReader durationReader;
    private boolean hasOutputSeekMap;
    private TsPayloadReader id3Reader;
    private final int mode;
    private ExtractorOutput output;
    private final TsPayloadReader.Factory payloadReaderFactory;
    private int pcrPid;
    private boolean pendingSeekToStart;
    private int remainingPmts;
    private final List<TimestampAdjuster> timestampAdjusters;
    private final int timestampSearchBytes;
    private final SparseBooleanArray trackIds;
    private final SparseBooleanArray trackPids;
    private boolean tracksEnded;
    private TsBinarySearchSeeker tsBinarySearchSeeker;
    private final ParsableByteArray tsPacketBuffer;
    private final SparseArray<TsPayloadReader> tsPayloadReaders;

    public TsExtractor() {
        this(0);
    }

    public TsExtractor(int n2) {
        this(1, n2, 112800);
    }

    public TsExtractor(int n2, int n3, int n4) {
        this(n2, new TimestampAdjuster(0L), new DefaultTsPayloadReaderFactory(n3), n4);
    }

    public TsExtractor(int n2, TimestampAdjuster timestampAdjuster, TsPayloadReader.Factory factory) {
        this(n2, timestampAdjuster, factory, 112800);
    }

    public TsExtractor(int n2, TimestampAdjuster timestampAdjuster, TsPayloadReader.Factory factory, int n3) {
        this.payloadReaderFactory = Assertions.checkNotNull(factory);
        this.timestampSearchBytes = n3;
        this.mode = n2;
        if (n2 != 1 && n2 != 2) {
            this.timestampAdjusters = new ArrayList<TimestampAdjuster>();
            this.timestampAdjusters.add(timestampAdjuster);
        } else {
            this.timestampAdjusters = Collections.singletonList(timestampAdjuster);
        }
        this.tsPacketBuffer = new ParsableByteArray(new byte[9400], 0);
        this.trackIds = new SparseBooleanArray();
        this.trackPids = new SparseBooleanArray();
        this.tsPayloadReaders = new SparseArray();
        this.continuityCounters = new SparseIntArray();
        this.durationReader = new TsDurationReader(n3);
        this.pcrPid = -1;
        this.resetPayloadReaders();
    }

    static /* synthetic */ boolean access$1002(TsExtractor tsExtractor, boolean bl) {
        tsExtractor.tracksEnded = bl;
        return bl;
    }

    static /* synthetic */ int access$102(TsExtractor tsExtractor, int n2) {
        tsExtractor.remainingPmts = n2;
        return n2;
    }

    static /* synthetic */ int access$108(TsExtractor tsExtractor) {
        int n2 = tsExtractor.remainingPmts;
        tsExtractor.remainingPmts = n2 + 1;
        return n2;
    }

    static /* synthetic */ int access$402(TsExtractor tsExtractor, int n2) {
        tsExtractor.pcrPid = n2;
        return n2;
    }

    static /* synthetic */ TsPayloadReader access$502(TsExtractor tsExtractor, TsPayloadReader tsPayloadReader) {
        tsExtractor.id3Reader = tsPayloadReader;
        return tsPayloadReader;
    }

    private boolean fillBufferWithAtLeastOnePacket(ExtractorInput extractorInput) throws IOException {
        int n2;
        byte[] byArray = this.tsPacketBuffer.getData();
        if (9400 - this.tsPacketBuffer.getPosition() < 188) {
            n2 = this.tsPacketBuffer.bytesLeft();
            if (n2 > 0) {
                System.arraycopy(byArray, this.tsPacketBuffer.getPosition(), byArray, 0, n2);
            }
            this.tsPacketBuffer.reset(byArray, n2);
        }
        while (this.tsPacketBuffer.bytesLeft() < 188) {
            n2 = this.tsPacketBuffer.limit();
            int n3 = extractorInput.read(byArray, n2, 9400 - n2);
            if (n3 == -1) {
                return false;
            }
            this.tsPacketBuffer.setLimit(n2 + n3);
        }
        return true;
    }

    private int findEndOfFirstTsPacketInBuffer() throws ParserException {
        int n2 = this.tsPacketBuffer.getPosition();
        int n3 = this.tsPacketBuffer.limit();
        int n4 = TsUtil.findSyncBytePosition((byte[])this.tsPacketBuffer.getData(), (int)n2, (int)n3);
        this.tsPacketBuffer.setPosition(n4);
        int n5 = n4 + 188;
        if (n5 > n3) {
            this.bytesSinceLastSync += n4 - n2;
            if (this.mode == 2 && this.bytesSinceLastSync > 376) {
                throw new ParserException("Cannot find sync byte. Most likely not a Transport Stream.");
            }
        } else {
            this.bytesSinceLastSync = 0;
        }
        return n5;
    }

    static /* synthetic */ Extractor[] lambda$static$0() {
        return new Extractor[]{new TsExtractor()};
    }

    private void maybeOutputSeekMap(long l2) {
        if (!this.hasOutputSeekMap) {
            this.hasOutputSeekMap = true;
            if (this.durationReader.getDurationUs() != -9223372036854775807L) {
                this.tsBinarySearchSeeker = new TsBinarySearchSeeker(this.durationReader.getPcrTimestampAdjuster(), this.durationReader.getDurationUs(), l2, this.pcrPid, this.timestampSearchBytes);
                this.output.seekMap(this.tsBinarySearchSeeker.getSeekMap());
            } else {
                this.output.seekMap(new SeekMap.Unseekable(this.durationReader.getDurationUs()));
            }
        }
    }

    private void resetPayloadReaders() {
        this.trackIds.clear();
        this.tsPayloadReaders.clear();
        SparseArray<TsPayloadReader> sparseArray = this.payloadReaderFactory.createInitialPayloadReaders();
        int n2 = sparseArray.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tsPayloadReaders.put(sparseArray.keyAt(i2), (Object)((TsPayloadReader)sparseArray.valueAt(i2)));
        }
        this.tsPayloadReaders.put(0, (Object)new SectionReader((SectionPayloadReader)new PatReader()));
        this.id3Reader = null;
    }

    private boolean shouldConsumePacketPayload(int n2) {
        int n3 = this.mode;
        boolean bl = false;
        if (n3 == 2 || this.tracksEnded || !this.trackPids.get(n2, false)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
    }

    @Override
    public int read(ExtractorInput object, PositionHolder positionHolder) throws IOException {
        int n2;
        int n3;
        long l2 = object.getLength();
        if (this.tracksEnded) {
            TsBinarySearchSeeker tsBinarySearchSeeker;
            n3 = l2 != -1L && this.mode != 2 ? 1 : 0;
            if (n3 != 0 && !this.durationReader.isDurationReadFinished()) {
                return this.durationReader.readDuration((ExtractorInput)object, positionHolder, this.pcrPid);
            }
            this.maybeOutputSeekMap(l2);
            if (this.pendingSeekToStart) {
                this.pendingSeekToStart = false;
                this.seek(0L, 0L);
                if (object.getPosition() != 0L) {
                    positionHolder.position = 0L;
                    return 1;
                }
            }
            if ((tsBinarySearchSeeker = this.tsBinarySearchSeeker) != null && tsBinarySearchSeeker.isSeeking()) {
                return this.tsBinarySearchSeeker.handlePendingSeek((ExtractorInput)object, positionHolder);
            }
        }
        if (!this.fillBufferWithAtLeastOnePacket((ExtractorInput)object)) {
            return -1;
        }
        int n4 = this.findEndOfFirstTsPacketInBuffer();
        if (n4 > (n2 = this.tsPacketBuffer.limit())) {
            return 0;
        }
        int n5 = this.tsPacketBuffer.readInt();
        if ((0x800000 & n5) != 0) {
            this.tsPacketBuffer.setPosition(n4);
            return 0;
        }
        n3 = (0x400000 & n5) != 0 ? 1 : 0;
        int n6 = n3 | 0;
        int n7 = (0x1FFF00 & n5) >> 8;
        n3 = (n5 & 0x20) != 0 ? 1 : 0;
        int n8 = (n5 & 0x10) != 0 ? 1 : 0;
        object = n8 != 0 ? (TsPayloadReader)this.tsPayloadReaders.get(n7) : null;
        if (object == null) {
            this.tsPacketBuffer.setPosition(n4);
            return 0;
        }
        if (this.mode != 2) {
            n8 = this.continuityCounters.get(n7, (n5 &= 0xF) - 1);
            this.continuityCounters.put(n7, n5);
            if (n8 == n5) {
                this.tsPacketBuffer.setPosition(n4);
                return 0;
            }
            if (n5 != (n8 + 1 & 0xF)) {
                object.seek();
            }
        }
        n8 = n6;
        if (n3 != 0) {
            n5 = this.tsPacketBuffer.readUnsignedByte();
            n3 = (this.tsPacketBuffer.readUnsignedByte() & 0x40) != 0 ? 2 : 0;
            n8 = n6 | n3;
            this.tsPacketBuffer.skipBytes(n5 - 1);
        }
        boolean bl = this.tracksEnded;
        if (this.shouldConsumePacketPayload(n7)) {
            this.tsPacketBuffer.setLimit(n4);
            object.consume(this.tsPacketBuffer, n8);
            this.tsPacketBuffer.setLimit(n2);
        }
        if (this.mode != 2 && !bl && this.tracksEnded && l2 != -1L) {
            this.pendingSeekToStart = true;
        }
        this.tsPacketBuffer.setPosition(n4);
        return 0;
    }

    @Override
    public void release() {
    }

    @Override
    public void seek(long l2, long l3) {
        TimestampAdjuster timestampAdjuster;
        int n2;
        boolean bl = this.mode != 2;
        Assertions.checkState(bl);
        int n3 = this.timestampAdjusters.size();
        for (n2 = 0; n2 < n3; ++n2) {
            timestampAdjuster = this.timestampAdjusters.get(n2);
            boolean bl2 = timestampAdjuster.getTimestampOffsetUs() == -9223372036854775807L;
            if (!bl2 && (timestampAdjuster.getTimestampOffsetUs() == 0L || timestampAdjuster.getFirstSampleTimestampUs() == l3)) continue;
            timestampAdjuster.reset(l3);
        }
        if (l3 != 0L && (timestampAdjuster = this.tsBinarySearchSeeker) != null) {
            timestampAdjuster.setSeekTargetUs(l3);
        }
        this.tsPacketBuffer.reset(0);
        this.continuityCounters.clear();
        for (n2 = 0; n2 < this.tsPayloadReaders.size(); ++n2) {
            ((TsPayloadReader)this.tsPayloadReaders.valueAt(n2)).seek();
        }
        this.bytesSinceLastSync = 0;
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException {
        byte[] byArray = this.tsPacketBuffer.getData();
        extractorInput.peekFully(byArray, 0, 940);
        for (int i2 = 0; i2 < 188; ++i2) {
            int n2;
            block2: {
                for (n2 = 0; n2 < 5; ++n2) {
                    if (byArray[n2 * 188 + i2] == 71) continue;
                    n2 = 0;
                    break block2;
                }
                n2 = 1;
            }
            if (n2 == 0) continue;
            extractorInput.skipFully(i2);
            return true;
        }
        return false;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    private class PatReader
    implements SectionPayloadReader {
        private final ParsableBitArray patScratch = new ParsableBitArray(new byte[4]);

        @Override
        public void consume(ParsableByteArray parsableByteArray) {
            if (parsableByteArray.readUnsignedByte() != 0) {
                return;
            }
            if ((parsableByteArray.readUnsignedByte() & 0x80) == 0) {
                return;
            }
            parsableByteArray.skipBytes(6);
            int n2 = parsableByteArray.bytesLeft() / 4;
            for (int i2 = 0; i2 < n2; ++i2) {
                parsableByteArray.readBytes(this.patScratch, 4);
                int n3 = this.patScratch.readBits(16);
                this.patScratch.skipBits(3);
                if (n3 == 0) {
                    this.patScratch.skipBits(13);
                    continue;
                }
                n3 = this.patScratch.readBits(13);
                if (TsExtractor.this.tsPayloadReaders.get(n3) != null) continue;
                TsExtractor.this.tsPayloadReaders.put(n3, (Object)new SectionReader((SectionPayloadReader)new PmtReader(n3)));
                TsExtractor.access$108(TsExtractor.this);
            }
            if (TsExtractor.this.mode != 2) {
                TsExtractor.this.tsPayloadReaders.remove(0);
            }
        }

        @Override
        public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        }
    }

    private class PmtReader
    implements SectionPayloadReader {
        private static final int TS_PMT_DESC_AC3 = 106;
        private static final int TS_PMT_DESC_AIT = 111;
        private static final int TS_PMT_DESC_DTS = 123;
        private static final int TS_PMT_DESC_DVBSUBS = 89;
        private static final int TS_PMT_DESC_DVB_EXT = 127;
        private static final int TS_PMT_DESC_DVB_EXT_AC4 = 21;
        private static final int TS_PMT_DESC_EAC3 = 122;
        private static final int TS_PMT_DESC_ISO639_LANG = 10;
        private static final int TS_PMT_DESC_REGISTRATION = 5;
        private final int pid;
        private final ParsableBitArray pmtScratch = new ParsableBitArray(new byte[5]);
        private final SparseIntArray trackIdToPidScratch;
        private final SparseArray<TsPayloadReader> trackIdToReaderScratch = new SparseArray();

        public PmtReader(int n2) {
            this.trackIdToPidScratch = new SparseIntArray();
            this.pid = n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        private TsPayloadReader.EsInfo readEsInfo(ParsableByteArray parsableByteArray, int n2) {
            int n3 = parsableByteArray.getPosition();
            int n4 = n2 + n3;
            String string2 = null;
            n2 = -1;
            Object object = null;
            while (parsableByteArray.getPosition() < n4) {
                ArrayList<TsPayloadReader.DvbSubtitleInfo> arrayList;
                String string3;
                int n5;
                block16: {
                    int n6;
                    block19: {
                        block15: {
                            block18: {
                                block14: {
                                    block17: {
                                        block13: {
                                            block12: {
                                                n6 = parsableByteArray.readUnsignedByte();
                                                n5 = parsableByteArray.readUnsignedByte();
                                                n5 = parsableByteArray.getPosition() + n5;
                                                if (n5 > n4) break;
                                                if (n6 != 5) break block12;
                                                long l2 = parsableByteArray.readUnsignedInt();
                                                if (l2 == 1094921523L) break block13;
                                                if (l2 == 1161904947L) break block14;
                                                if (l2 == 1094921524L) break block15;
                                                string3 = string2;
                                                arrayList = object;
                                                if (l2 == 1212503619L) {
                                                    n2 = 36;
                                                    string3 = string2;
                                                    arrayList = object;
                                                }
                                                break block16;
                                            }
                                            if (n6 != 106) break block17;
                                        }
                                        n2 = 129;
                                        string3 = string2;
                                        arrayList = object;
                                        break block16;
                                    }
                                    if (n6 != 122) break block18;
                                }
                                n2 = 135;
                                string3 = string2;
                                arrayList = object;
                                break block16;
                            }
                            if (n6 != 127) break block19;
                            string3 = string2;
                            arrayList = object;
                            if (parsableByteArray.readUnsignedByte() != 21) break block16;
                        }
                        n2 = 172;
                        string3 = string2;
                        arrayList = object;
                        break block16;
                    }
                    if (n6 == 123) {
                        n2 = 138;
                        string3 = string2;
                        arrayList = object;
                    } else if (n6 == 10) {
                        string3 = parsableByteArray.readString(3).trim();
                        arrayList = object;
                    } else if (n6 == 89) {
                        arrayList = new ArrayList<TsPayloadReader.DvbSubtitleInfo>();
                        while (parsableByteArray.getPosition() < n5) {
                            string3 = parsableByteArray.readString(3).trim();
                            n2 = parsableByteArray.readUnsignedByte();
                            object = new byte[4];
                            parsableByteArray.readBytes((byte[])object, 0, 4);
                            arrayList.add(new TsPayloadReader.DvbSubtitleInfo(string3, n2, (byte[])object));
                        }
                        n2 = 89;
                        string3 = string2;
                    } else {
                        string3 = string2;
                        arrayList = object;
                        if (n6 == 111) {
                            n2 = 257;
                            arrayList = object;
                            string3 = string2;
                        }
                    }
                }
                parsableByteArray.skipBytes(n5 - parsableByteArray.getPosition());
                string2 = string3;
                object = arrayList;
            }
            parsableByteArray.setPosition(n4);
            return new TsPayloadReader.EsInfo(n2, string2, (List<TsPayloadReader.DvbSubtitleInfo>)object, Arrays.copyOfRange(parsableByteArray.getData(), n3, n4));
        }

        @Override
        public void consume(ParsableByteArray object) {
            int n2;
            int n3;
            int n4;
            Object object2;
            TimestampAdjuster timestampAdjuster;
            if (object.readUnsignedByte() != 2) {
                return;
            }
            if (TsExtractor.this.mode != 1 && TsExtractor.this.mode != 2 && TsExtractor.this.remainingPmts != 1) {
                timestampAdjuster = new TimestampAdjuster(((TimestampAdjuster)TsExtractor.this.timestampAdjusters.get(0)).getFirstSampleTimestampUs());
                TsExtractor.this.timestampAdjusters.add(timestampAdjuster);
            } else {
                timestampAdjuster = (TimestampAdjuster)TsExtractor.this.timestampAdjusters.get(0);
            }
            if ((object.readUnsignedByte() & 0x80) == 0) {
                return;
            }
            object.skipBytes(1);
            int n5 = object.readUnsignedShort();
            object.skipBytes(3);
            object.readBytes(this.pmtScratch, 2);
            this.pmtScratch.skipBits(3);
            TsExtractor.access$402(TsExtractor.this, this.pmtScratch.readBits(13));
            object.readBytes(this.pmtScratch, 2);
            this.pmtScratch.skipBits(4);
            object.skipBytes(this.pmtScratch.readBits(12));
            if (TsExtractor.this.mode == 2 && TsExtractor.this.id3Reader == null) {
                TsPayloadReader.EsInfo esInfo = new TsPayloadReader.EsInfo(21, null, null, Util.EMPTY_BYTE_ARRAY);
                object2 = TsExtractor.this;
                TsExtractor.access$502((TsExtractor)object2, ((TsExtractor)object2).payloadReaderFactory.createPayloadReader(21, esInfo));
                TsExtractor.this.id3Reader.init(timestampAdjuster, TsExtractor.this.output, new TsPayloadReader.TrackIdGenerator(n5, 21, 8192));
            }
            this.trackIdToReaderScratch.clear();
            this.trackIdToPidScratch.clear();
            int n6 = object.bytesLeft();
            while (n6 > 0) {
                int n7;
                block20: {
                    block19: {
                        object.readBytes(this.pmtScratch, 5);
                        n4 = this.pmtScratch.readBits(8);
                        this.pmtScratch.skipBits(3);
                        n3 = this.pmtScratch.readBits(13);
                        this.pmtScratch.skipBits(4);
                        n7 = this.pmtScratch.readBits(12);
                        object2 = this.readEsInfo((ParsableByteArray)object, n7);
                        if (n4 == 6) break block19;
                        n2 = n4;
                        if (n4 != 5) break block20;
                    }
                    n2 = ((TsPayloadReader.EsInfo)object2).streamType;
                }
                n4 = n6 - (n7 + 5);
                n6 = TsExtractor.this.mode == 2 ? n2 : n3;
                if (!TsExtractor.this.trackIds.get(n6)) {
                    object2 = TsExtractor.this.mode == 2 && n2 == 21 ? TsExtractor.this.id3Reader : TsExtractor.this.payloadReaderFactory.createPayloadReader(n2, (TsPayloadReader.EsInfo)object2);
                    if (TsExtractor.this.mode != 2 || n3 < this.trackIdToPidScratch.get(n6, 8192)) {
                        this.trackIdToPidScratch.put(n6, n3);
                        this.trackIdToReaderScratch.put(n6, object2);
                    }
                }
                n6 = n4;
            }
            n6 = this.trackIdToPidScratch.size();
            for (n2 = 0; n2 < n6; ++n2) {
                n3 = this.trackIdToPidScratch.keyAt(n2);
                n4 = this.trackIdToPidScratch.valueAt(n2);
                TsExtractor.this.trackIds.put(n3, true);
                TsExtractor.this.trackPids.put(n4, true);
                object = (TsPayloadReader)this.trackIdToReaderScratch.valueAt(n2);
                if (object == null) continue;
                if (object != TsExtractor.this.id3Reader) {
                    object.init(timestampAdjuster, TsExtractor.this.output, new TsPayloadReader.TrackIdGenerator(n5, n3, 8192));
                }
                TsExtractor.this.tsPayloadReaders.put(n4, object);
            }
            if (TsExtractor.this.mode == 2) {
                if (!TsExtractor.this.tracksEnded) {
                    TsExtractor.this.output.endTracks();
                    TsExtractor.access$102(TsExtractor.this, 0);
                    TsExtractor.access$1002(TsExtractor.this, true);
                }
            } else {
                n2 = 0;
                TsExtractor.this.tsPayloadReaders.remove(this.pid);
                object = TsExtractor.this;
                if (((TsExtractor)object).mode != 1) {
                    n2 = TsExtractor.this.remainingPmts - 1;
                }
                TsExtractor.access$102((TsExtractor)object, n2);
                if (TsExtractor.this.remainingPmts == 0) {
                    TsExtractor.this.output.endTracks();
                    TsExtractor.access$1002(TsExtractor.this, true);
                }
            }
        }

        @Override
        public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator trackIdGenerator) {
        }
    }
}

